

/*******************************************************************************
 *
 * FILE:          FC_Phone_SMTransferCallHandSetHandsFree.h
 *
 * SW-COMPONENT:  FC_Phone application
 *
 * PROJECT:
 *
 * DESCRIPTION:   Abstracts a statemachine
 *
 * AUTHOR:
 *
 * COPYRIGHT:
 *
 *******************************************************************************/

#ifndef _FC_PHONE_SMTRANSFERCALLHANDSETHANDSFREE_H_
#define _FC_PHONE_SMTRANSFERCALLHANDSETHANDSFREE_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
/* Define the states that this machine can take */


#define FC_PHONE_SMTRANSFERCALL_STATE_CALLTRANSFER_STARTED 0

#define FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_CALLTRANSFER_TOHANDSET 	1
#define FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_CALLTRANSFER_TOHANDSFREE 	2

#define FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE1  3
#define FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE2  4

#define FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIOREQUEST_CALLINSTANCE1  5
#define FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIOREQUEST_CALLINSTANCE2  6

#define FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_ALERTTONERELEASE_CALLINSTANCE1  7
#define FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_ALERTTONERELEASE_CALLINSTANCE2  8

#define FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET 	9
#define FC_PHONE_SMTRANSFERCALL_STATE_CALLTRANSFERRED_TOHANDSFREE 	10
#define FC_PHONE_SMTRANSFERCALL_STATE_WAIT_FOR_SWAPDBUSACK_AND_CALLSTATUS 11
#define  FC_PHONE_SMTRANSFERCALL_STATE_WAIT_FOR_SWAPDBUSACK 12
#define  FC_PHONE_SMTRANSFERCALL_STATE_WAIT_FOR_CALLSTATUS 13

#define FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE1_FOR_TRANSFERAUDIOREQ_FROMPHONE  14
#define FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE2_FOR_TRANSFERAUDIOREQ_FROMPHONE  15

#define FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIOREQUEST_CALLINSTANCE1_FOR_TRANSFERAUDIOREQ_FROMPHONE  16
#define FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIOREQUEST_CALLINSTANCE2_FOR_TRANSFERAUDIOREQ_FROMPHONE  17
#define FC_PHONE_SMTRANSFERCALL_STATE_WAIT_FOR_HOLDCALL 18
#define FC_PHONE_SMTRANSFERCALL_STATE_WAIT_FOR_DISCONNECT_FROM_BT 19
//#define FC_PHONE_SMTRANSFERCALL_STATE_HANDLE_CALLTRANSFER_TOVEHICLE 11

/*Error Codes from Dbus while transferring Call*/
#define FC_PHONE_SMTRANSFERCALL_AUDIOTRANSFER_TOHANDSET_AGFAILURE 0x00
#define FC_PHONE_SMTRANSFERCALL_AUDIOTRANSFER_TOHANDSET_NOCONNECTIONTOPHONE 0x001
#define FC_PHONE_SMTRANSFERCALL_AUDIOTRANSFER_TOHANDSET_OPERATIONNOTALLOWED 0x003
#define FC_PHONE_SMTRANSFERCALL_AUDIOTRANSFER_TOHANDSET_OPERATIONNOTSUPPORTED 0x04
#define FC_PHONE_SMTRANSFERCALL_AUDIOTRANSFER_TOHANDSET_NETWORKNOTALLOWED 0x20




class fc_phone_tclSMManager;
/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class fc_phone_tclSMTransferCallHandSetHandsFree: public fc_phone_tclSM
{
public:
   /* Constructor */
   fc_phone_tclSMTransferCallHandSetHandsFree(fc_phone_tclCallInstance *rfpCallInstance[]);
   /* Destructor */
   virtual ~fc_phone_tclSMTransferCallHandSetHandsFree();
   virtual tVoid vCancel(tVoid) FINAL;
   virtual tVoid vExecute(tVoid);
   virtual tBool bProcessEvent(tU16 u16EventId,tVoid *varg);
   virtual tBool bProcessEvent(tU16 u16EventId) FINAL;
   virtual tVoid vTimerCallBack(tU16 u16TimerId);
   virtual tVoid vAudioCallBack(tU16 u16AudioChannelId, tU16 u16RequestState);
   virtual tVoid vNewCallStatus(const T_CallData* const prCallData,tU16 u16_callInstance);
   virtual tVoid vProcessAudioSignal();
   virtual tU16 u16GetSMID();
   virtual tVoid vSetDtmfLength(tU16 u16DtmfLength);

   //Fix for GMMY17-10316
   tBool bProcessEventinSubState(tU16 u16EventId);
private:

   tVoid RevertStateMachine();
   tVoid vHandleEventInHandSetCall(tU16 u16EventId);
   tVoid vHandleAudioTransferInHandSetCallInstance1(tU16 u16EventId);
   tVoid vHandleAudioTransferInHandSetCallInstance2(tU16 u16EventId);

   tVoid vHandleAlertToneInHandsFreeCallInstance1(tU16 u16EventId);
   tVoid vHandleAlertToneInHandsFreeCallInstance2(tU16 u16EventId);
   tVoid vHandleAudioRequestInHandsFreeCallInstance1(tU16 u16EventId);
   tVoid vHandleAudioRequestInHandsFreeCallInstance2(tU16 u16EventId);
   tVoid vHandleEventOnCallTransferToHandSet(tU16 u16EventId);
   tVoid vHandleEventOnCallTransferToHandsFree(tU16 u16EventId);
   tVoid vHandleTransferCallRequestToVehicle();
   tVoid vHandleEventInHandsFreeCall(tU16 u16EventId);
   tVoid vHandleEventInSwapDbusAckOrCallStatus(tU16 u16EventId);
   tVoid vHandleEventInSwapCall(tU16 u16EventId);
   tVoid vHandleTransferCallDbusError(tU16 u16DbusAckType,tChar Code);
   tVoid vProcessOnDynamicDisconnect(tU16 u16EventId);
   tVoid vTimeOutOnAudioTransfer();
   tVoid vHandleAudioRequestForAudioTransferFromPhoneCallInstance1(tU16 u16EventId);
   tVoid vHandleAudioRequestForAudioTransferFromPhoneCallInstance2(tU16 u16EventId);
   tVoid vHandleAudioReleaseForAudioTransferFromPhoneCallInstance1(tU16 u16EventId);
   tVoid vHandleAudioReleaseForAudioTransferFromPhoneCallInstance2(tU16 u16EventId);
   tVoid vHangUpCall();
   tVoid vHandleEventInHoldCall(tU16 u16EventId);
   //GMMY16-15319 - Handling cancel outgoing call in this statemachine
   tVoid vTerminateOutgoingCall();
   tVoid vHandleEventInTerminateBTInCall(tU16 u16EventId);

   tVoid vAssignErrorCode(tChar Code);
   //tBool m_bTimerRunning;
   tU8   m_u8errorCode ;
   tU8 CallTransferState;
   tU8 TransferCallSMCallInstances;
   tBool m_bEventConsumed ;
   tU16 m_u16State_while_TransferAudio;
   tBool m_bHangUpMethodStart;
   tBool m_bHangUpAllMethodStart;
   tBool m_bResumeCallMethodStart;
   fc_phone_tclCallInstance *m_pReleaseCallInstance;
   tU16  m_releaseCallInstanceID;
   tU16 m_u16SMID;

   // DTMF attributes
   tU16 u16_oneTimeDTMFCalculation;
   tU16 m_u16DTMFCharLength;
   tU16 m_u16SentDtmfCounter;
   tU8 m_u8AudioRetryCounter;
};
#endif // _FC_PHONE_SMACCEPTCALL_H_


