/******************************************************************************
 *
 * FILE:          FC_Phone_SMTransferCallHandSetHandsFree.cpp
 *
 * SW-COMPONENT:  FC_Phone application
 *
 * PROJECT:
 *
 * DESCRIPTION:   CCA service Telephone.
 *
 * AUTHOR:
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/
#include "stdio.h"
#include "FC_Phone_SMIncludes.h"
#include "../HelperClasses/FC_Phone_CallManager.h"

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_PHONE_STATEMACHINE
#include "trcGenProj/Header/FC_Phone_SMTransferCallHandSetHandsFree.cpp.trc.h"
#endif

#define FC_PHONE_AUDIOTRANSFER_RETRY_MAX 3
#define ONE_SECOND 1000
/*******************************************************************************
 * FUNCTION: vAudioCallBackTransferCall
 * DESCRIPTION:
 * PARAMETER:
 * RETURNVALUE: None.
 ********************************************************************************/
tVoid vAudioCallBackTransferCall(tU16 u16AudioReqID,tU16 u16AudioChannelId, tU16 u16RequestState)
{
   ETG_TRACE_USR4((" Entering vAudioCallBackTransferCall"));
   fc_phone_tclSM* pSMInstance;
   pSMInstance = fc_phone_tclSMManager::GetSM_FromAudioRequestorId(u16AudioReqID);
   if(pSMInstance)
   {
      pSMInstance->vAudioCallBack(u16AudioChannelId,u16RequestState);
   }
   else
   {
      ETG_TRACE_ERR(("ERROR:: could not get SM for u16TimerId %d",u16AudioReqID));
   }
}

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMTransferCallHandSetHandsFree::fc_phone_tclSMTransferCallHandSetHandsFree
 *
 * DESCRIPTION: Constructor ->For Two Call Instance
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
fc_phone_tclSMTransferCallHandSetHandsFree::fc_phone_tclSMTransferCallHandSetHandsFree(fc_phone_tclCallInstance *rfpCallInstance[]):\
      fc_phone_tclSM(rfpCallInstance)
      {
   ETG_TRACE_USR4((" Entering fc_phone_tclSMTransferCallHandSetHandsFree::fc_phone_tclSMTransferCallHandSetHandsFree"));
   int i = 0;
   m_u8errorCode  = 0;
   CallTransferState = 0;
   TransferCallSMCallInstances  = 0;
   m_releaseCallInstanceID = 0;
   m_pReleaseCallInstance = NULLPTR;
   m_bHangUpMethodStart = FALSE;
   m_bHangUpAllMethodStart = FALSE;
   m_bResumeCallMethodStart = FALSE;
   m_u8AudioRetryCounter=0;
   //m_bTimerRunning = FALSE;
   m_bEventConsumed = FALSE;
   m_u16State_while_TransferAudio = 0;

   for(i = 0; i < FC_PHONE_MAX_CALLINSTANCES; i++)
   {
      if(rfpCallInstance[i])
         TransferCallSMCallInstances++;
   }

   m_u16SMID = FC_PHONE_SMMANAGER_SMID_TRANSFERCALL;
   m_u16SentDtmfCounter  = 0;
   m_u16DTMFCharLength   = 0;
   u16_oneTimeDTMFCalculation = 0;
   ETG_TRACE_USR4(("      TransferCallSMCallInstances = %d",TransferCallSMCallInstances));
      }

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMTransferCallHandSetHandsFree::fc_phone_tclSMTransferCallHandSetHandsFree
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
/* Destructor */
fc_phone_tclSMTransferCallHandSetHandsFree::~fc_phone_tclSMTransferCallHandSetHandsFree()
{
   ETG_TRACE_USR4((" Destructor fc_phone_tclSMTransferCallHandSetHandsFree::~fc_phone_tclSMTransferCallHandSetHandsFree"));
   m_u16State_while_TransferAudio = 0;
   m_u16SMID = FC_PHONE_SMMANAGER_SMID_UNKNOWN;
   m_pReleaseCallInstance = NULLPTR;
}
/*******************************************************************************
 *
 * FUNCTION: vCancel
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMTransferCallHandSetHandsFree::vCancel(tVoid)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMTransferCallHandSetHandsFree::vCancel"));

   m_u16State_while_TransferAudio = 0;
   m_bResumeCallMethodStart = FALSE;

   // If DTMF sending is not finished , send method error
   if (m_u16SentDtmfCounter != m_u16DTMFCharLength)
   {
      ETG_TRACE_USR4((" sending Methos Error to client"));
      u16_oneTimeDTMFCalculation = 0;
      m_u16SentDtmfCounter  = 0;
      m_u16DTMFCharLength   = 0;

      if (m_poCallInstance)
      {
         m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_PLAYDTMF,m_poCallInstance);
      }
      else if (m_poCallInstance2)
      {
         m_poCallInstance2->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_PLAYDTMF,m_poCallInstance2);
      }
   }
}

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMTransferCallHandSetHandsFree::vExecute
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMTransferCallHandSetHandsFree::vExecute()
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMTransferCallHandSetHandsFree::vExecute without Params"));
   CallTransferState = FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSET;
   tU8 u8SCOConnectionStatus = FC_PHONE_DBUS_SCO_CONN_FAILED;
   fc_phone_tclClientHandler_BTSettings *p_clientHndler_bluetooth = (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerBTSettings;
   if(m_poCallInstance)
   {
      u8SCOConnectionStatus = p_clientHndler_bluetooth->vGetSCOConnectionStatus(const_cast<tChar *> (fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId))); //CMG3G-4847 - To solve Lint
   }
   else if(m_poCallInstance2)
   {
      u8SCOConnectionStatus = p_clientHndler_bluetooth->vGetSCOConnectionStatus(const_cast<tChar *> (fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance2->m_u8BDAddressId))); //CMG3G-4847 - To solve Lint
   }
   /* Reset Time */
   if(m_poCallInstance)
   {
      /*TransferCallToHandSet*/
      m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_CALLTRANSFER_TOHANDSET;
      if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_ESTABLISHED)
      {
         ETG_TRACE_USR4(("FC_PHONE_DBUS_SCO_CONN_ESTABLISHED. "));
         m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId),FC_PHONE_CALLTRANSFER_FROMHANSFREE_TOHANDSET);
      }
      // GMMY15-813 Cannot switch call to handsfree from radio if incoming call answered from Bluetooth phone
      else if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_STATUS_UNKNOWN)
      {
         ETG_TRACE_USR4(("FC_PHONE_DBUS_SCO_CONN_STATUS_UNKNOWN. "));
         m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId),FC_PHONE_CALLTRANSFER_FROMHANSFREE_TOHANDSET);
      }
      else
      {
         bProcessEvent(FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK);
      }
   }
   else if(m_poCallInstance2)
   {
      /*TransferCallToHandSet*/
      m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_CALLTRANSFER_TOHANDSET;
      if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_ESTABLISHED)
      {
         ETG_TRACE_USR4(("FC_PHONE_DBUS_SCO_CONN_ESTABLISHED. "));
         m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance2->m_u8BDAddressId),FC_PHONE_CALLTRANSFER_FROMHANSFREE_TOHANDSET);
      }
      // GMMY15-813 Cannot switch call to handsfree from radio if incoming call answered from Bluetooth phone
      else if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_STATUS_UNKNOWN)
      {
         ETG_TRACE_USR4(("FC_PHONE_DBUS_SCO_CONN_STATUS_UNKNOWN. "));
         m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance2->m_u8BDAddressId),FC_PHONE_CALLTRANSFER_FROMHANSFREE_TOHANDSET);
      }
      else
      {
         bProcessEvent(FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK);
      }
   }
   else
   {
      //TODO handle Unknown type of CallTransfer.Revert to  Original State machine
      ETG_TRACE_USR4(("  1 UNKNOWN TYPE OF CALL TRANSFER   "));
   }
}
/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMTransferCallHandSetHandsFree::vExecute
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMTransferCallHandSetHandsFree::vHandleTransferCallRequestToVehicle()
{
   ETG_TRACE_USR4(("Entering fc_phone_tclSMTransferCallHandSetHandsFree::vHandleTransferCallRequestToVehicle:: Wait for Call transfer to HANDS FREE"));
   /* TransferCallToHandsFree */
   /* Release AlertTone */
   ETG_TRACE_USR4(("\n fc_phone_tclSMTransferCallHandSetHandsFree::Wait for Call transfer to HANDS FREE"));
   if((m_poCallInstance) && (m_poCallInstance2))
   {
      if(m_poCallInstance->m_u8AudioChannel == FC_PHONE_AUDIOCHANNEL_ALERTTONE)
      {
         ETG_TRACE_USR3((" fc_phone_tclSMTransferCallHandSetHandsFree:: FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_ALERTTONERELEASE_CALLINSTANCE1"));
         m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_ALERTTONERELEASE_CALLINSTANCE1;
         ETG_TRACE_USR2((" State Change : FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_ALERTTONERELEASE_CALLINSTANCE1"));
         ETG_TRACE_USR3(("Releasing audio...."));
         m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id,m_poCallInstance->m_u8AudioChannel,vAudioCallBackTransferCall);
         m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
      }
      /*else if(m_poCallInstance2->m_u8AudioChannel == FC_PHONE_AUDIOCHANNEL_ALERTTONE)
		{
			ETG_TRACE_USR4((" fc_phone_tclSMTransferCallHandSetHandsFree:: FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_ALERTTONERELEASE_CALLINSTANCE2"));
			m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_ALERTTONERELEASE_CALLINSTANCE2;
			m_poAudioManager->s32ReleaseRequest(m_poCallInstance2->m_u16Id,m_poCallInstance2->m_u8AudioChannel,vAudioCallBackTransferCall);
		}*/
      else //if(m_poCallInstance->m_u8AudioChannel == FC_PHONE_AUDIOCHANNEL_PHONE)
      {
         ETG_TRACE_USR3((" fc_phone_tclSMTransferCallHandSetHandsFree:: FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIOREQUEST_CALLINSTANCE1"));
         m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIOREQUEST_CALLINSTANCE1;
         ETG_TRACE_USR2((" State Change : FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_ALERTTONEREQUEST_CALLINSTANCE1"));
         if (m_poCallInstance->m_u8AudioChannel == FC_PHONE_AUDIOCHANNEL_ID_UNUSED)
         {
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE ;
            ETG_TRACE_USR3(("Requesting  audio...."));
            m_poAudioManager->s32GetRequest(m_poCallInstance->m_u16Id,m_poCallInstance->m_u8AudioChannel,vAudioCallBackTransferCall);
         }
         else
         {
            bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
         }
      }
      /*		else if(m_poCallInstance2->m_u8AudioChannel == FC_PHONE_AUDIOCHANNEL_PHONE)
		{
			ETG_TRACE_USR4((" fc_phone_tclSMTransferCallHandSetHandsFree:: FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIOREQUEST_CALLINSTANCE2"));
			m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIOREQUEST_CALLINSTANCE2;
			m_poAudioManager->s32GetRequest(m_poCallInstance2->m_u16Id,m_poCallInstance2->m_u8AudioChannel,vAudioCallBackTransferCall);
#ifndef PHONE_USE_AVM
			vAudioCallBackTransferCall(m_poCallInstance->m_u16Id , FC_PHONE_AUDIOCHANNEL_PHONE ,FC_PHONE_AUDIOCHANNEL_GRANTED);
#endif //PHONE_USE_AVM
		}
		else
		{
			m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIOREQUEST_CALLINSTANCE1;
			s32ProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
			ETG_TRACE_USR4((" fc_phone_tclSMTransferCallHandSetHandsFree:: No audio and alert tone channel engaged->Both call instances"));
		}*/
   }
   else if((m_poCallInstance) && (!m_poCallInstance2))
   {
      if(m_poCallInstance->m_u8AudioChannel == FC_PHONE_AUDIOCHANNEL_ALERTTONE)
      {
         ETG_TRACE_USR3((" fc_phone_tclSMTransferCallHandSetHandsFree:: FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_ALERTTONERELEASE_CALLINSTANCE2"));
         m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_ALERTTONERELEASE_CALLINSTANCE1;
         ETG_TRACE_USR2((" State Change : FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_ALERTTONERELEASE_CALLINSTANCE1"));
         ETG_TRACE_USR3(("Releasing audio...."));
         m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id,m_poCallInstance->m_u8AudioChannel,vAudioCallBackTransferCall);
         m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
      }
      else //if(m_poCallInstance->m_u8AudioChannel == FC_PHONE_AUDIOCHANNEL_PHONE)
      {
         ETG_TRACE_USR3((" fc_phone_tclSMTransferCallHandSetHandsFree:: FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIOREQUEST_CALLINSTANCE1"));
         m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIOREQUEST_CALLINSTANCE1;
         ETG_TRACE_USR2((" State Change : FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIOREQUEST_CALLINSTANCE1"));
         if (m_poCallInstance->m_u8AudioChannel == FC_PHONE_AUDIOCHANNEL_ID_UNUSED)
         {
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE ;
            ETG_TRACE_USR3(("Requesting  audio....AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE "));
            m_poAudioManager->s32GetRequest(m_poCallInstance->m_u16Id,m_poCallInstance->m_u8AudioChannel,vAudioCallBackTransferCall);
         }
         else
         {
            bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
         }
      }
      /*	else
		{
			m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIOREQUEST_CALLINSTANCE1;
			s32ProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
			ETG_TRACE_USR4((" fc_phone_tclSMTransferCallHandSetHandsFree:: No audio and alert tone channel engaged->1st call instances"));
	 	}
       */
   }
   else if((!m_poCallInstance) && (m_poCallInstance2))
   {
      if(m_poCallInstance2->m_u8AudioChannel == FC_PHONE_AUDIOCHANNEL_ALERTTONE)
      {
         ETG_TRACE_USR3((" fc_phone_tclSMTransferCallHandSetHandsFree:: FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_ALERTTONERELEASE_CALLINSTANCE2"));
         m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_ALERTTONERELEASE_CALLINSTANCE2;
         ETG_TRACE_USR2((" State Change : FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_ALERTTONERELEASE_CALLINSTANCE2"));
         ETG_TRACE_USR3(("Releasing audio...."));
         m_poAudioManager->s32ReleaseRequest(m_poCallInstance2->m_u16Id,m_poCallInstance2->m_u8AudioChannel,vAudioCallBackTransferCall);
         m_poCallInstance2->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
      }
      else //if(m_poCallInstance2->m_u8AudioChannel == FC_PHONE_AUDIOCHANNEL_PHONE)
      {
         ETG_TRACE_USR3((" fc_phone_tclSMTransferCallHandSetHandsFree:: FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIOREQUEST_CALLINSTANCE2"));
         m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIOREQUEST_CALLINSTANCE2;
         ETG_TRACE_USR2((" State Change : FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIOREQUEST_CALLINSTANCE2"));
         if (m_poCallInstance2->m_u8AudioChannel == FC_PHONE_AUDIOCHANNEL_ID_UNUSED)
         {
            m_poCallInstance2->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE ;
            ETG_TRACE_USR3(("Requesting  audio....AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE "));
            m_poAudioManager->s32GetRequest(m_poCallInstance2->m_u16Id,m_poCallInstance2->m_u8AudioChannel,vAudioCallBackTransferCall);
         }
         else
         {
            bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
         }
      }
      /*else
		{
			m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIOREQUEST_CALLINSTANCE2;
			s32ProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
			ETG_TRACE_USR4(("      fc_phone_tclSMTransferCallHandSetHandsFree:: No audio and alert tone channel engaged->2nd call instances"));
		}*/
   }
   else if((!m_poCallInstance) && (!m_poCallInstance2))
   {
      ETG_TRACE_USR4((" fc_phone_tclSMTransferCallHandSetHandsFree:: BOTH CALL INSTANCES ARE NULL"));
   }
}
/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMTransferCallHandSetHandsFree::vProcessEvent
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tBool fc_phone_tclSMTransferCallHandSetHandsFree::bProcessEvent(tU16 u16EventId,tVoid *varg)
{
   tBool bRetVal= FALSE;
   ETG_TRACE_USR4((" Entering fc_phone_tclSMTransferCallHandSetHandsFree::vProcessEvent With Args u16EventId %d",u16EventId));
   FcPhone_processEventArg *p_method_data = (FcPhone_processEventArg *)varg;
   if(p_method_data->bIsItDbusAck == TRUE)
   {
      if(p_method_data->u16DbusAckType == FC_PHONE_CB_FID_AUDIOTRANSFER)
      {
         /*Currently ALPS is returning 1->Success 0->Failure */
         if(p_method_data->Status == CALLTRANSFER_FAILURE)
         {
            ETG_TRACE_USR4(("p_method_data->Status :: %d p_method_data->Code :: 0x%x",p_method_data->Status,p_method_data->Code));
            ETG_TRACE_USR4(("DBUS TransferCall  FAILS"));
            vHandleTransferCallDbusError(p_method_data->u16DbusAckType,p_method_data->Code);
         }
         else
         {
            ETG_TRACE_USR4(("DBUS TransferCall  SUCCESS"));
            //reseting value of retry counter on successful audio transfer
            m_u8AudioRetryCounter = 0;
            ETG_TRACE_USR4(("Reset retry counter to 0 "));
            bRetVal = bProcessEvent(u16EventId);
         }
      }
      else
      {
         if(FC_PHONE_DBUS_STATUS_SUCCESS != p_method_data->Status)
         {
            ETG_TRACE_USR4(("DBUS Request Fails"));
            vHandleTransferCallDbusError(p_method_data->u16DbusAckType,p_method_data->Code);
         }
         else
         {
            ETG_TRACE_USR4(("DBUS Request Success"));
            bRetVal = bProcessEvent(u16EventId);
         }
      }
   }
   else
   {
      ETG_TRACE_USR4((" Handling Other events of Transfer Call"));
      //JAC2-4389. The correct call instance should be considered for terminating the outgoing call.
      if ((u16EventId == FC_PHONE_SM_EVENT_HANGUPCALL_OK)||(u16EventId == FC_PHONE_SM_EVENT_CANCELOUTGOINGCALL_OK))
      {
         ETG_TRACE_USR4((" u16CallInstanceID :: %d",p_method_data->u16CallInstanceID));
         m_releaseCallInstanceID = p_method_data->u16CallInstanceID;

         ETG_TRACE_USR4((" m_releaseCallInstanceID :: %d",m_releaseCallInstanceID));
      }
      bRetVal = bProcessEvent(u16EventId);
   }
   ETG_TRACE_USR4(("   bRetVal = %d  ",bRetVal));
   m_bEventConsumed = FALSE;
   return bRetVal;
}
/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMTransferCallHandSetHandsFree::vProcessEvent
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tBool fc_phone_tclSMTransferCallHandSetHandsFree::bProcessEvent(tU16 u16EventId)
{

   ETG_TRACE_USR4((" Entering fc_phone_tclSMTransferCallHandSetHandsFree::vProcessEvent Without ARGS u16EventId %d",u16EventId));
   ETG_TRACE_USR2((" m_u16State = %d ",m_u16State));
   switch(m_u16State)
   {
      case FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_CALLTRANSFER_TOHANDSET:
      {
         ETG_TRACE_USR2(("STATE :: FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_CALLTRANSFER_TOHANDSET "));
         vHandleEventInHandSetCall(u16EventId);
         break;
      }
      case FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_CALLTRANSFER_TOHANDSFREE:
      {
         ETG_TRACE_USR2(("STATE :: FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_CALLTRANSFER_TOHANDSFREE "));
         vHandleEventInHandsFreeCall(u16EventId);
         break;
      }
      case FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE1:
      {
         ETG_TRACE_USR2(("STATE :: FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE1 "));
         vHandleAudioTransferInHandSetCallInstance1(u16EventId);
         break;
      }
      case FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE2:
      {
         ETG_TRACE_USR2(("STATE :: FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE2 "));
         vHandleAudioTransferInHandSetCallInstance2(u16EventId);
         break;
      }
      case FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_ALERTTONERELEASE_CALLINSTANCE1:
      {
         ETG_TRACE_USR2(("STATE :: FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_ALERTTONERELEASE_CALLINSTANCE1 "));
         vHandleAlertToneInHandsFreeCallInstance1(u16EventId);
         break;
      }
      case FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_ALERTTONERELEASE_CALLINSTANCE2:
      {
         ETG_TRACE_USR2(("STATE :: FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_ALERTTONERELEASE_CALLINSTANCE2 "));
         vHandleAlertToneInHandsFreeCallInstance2(u16EventId);
         break;
      }
      case FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIOREQUEST_CALLINSTANCE1:
      {
         ETG_TRACE_USR2(("STATE :: FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIOREQUEST_CALLINSTANCE1 "));
         vHandleAudioRequestInHandsFreeCallInstance1(u16EventId);
         break;
      }
      case FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIOREQUEST_CALLINSTANCE2:
      {
         ETG_TRACE_USR2(("STATE :: FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIOREQUEST_CALLINSTANCE2 "));
         vHandleAudioRequestInHandsFreeCallInstance2(u16EventId);
         break;
      }
      case FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET:
      {
         ETG_TRACE_USR2(("STATE :: FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET "));
         vHandleEventOnCallTransferToHandSet(u16EventId);
         break;
      }
      case FC_PHONE_SMTRANSFERCALL_STATE_CALLTRANSFERRED_TOHANDSFREE:
      {
         ETG_TRACE_USR2(("STATE :: FC_PHONE_SMTRANSFERCALL_STATE_CALLTRANSFERRED_TOHANDSFREE "));
         vHandleEventOnCallTransferToHandsFree(u16EventId);
         break;
      }
      case FC_PHONE_SMTRANSFERCALL_STATE_WAIT_FOR_SWAPDBUSACK_AND_CALLSTATUS :
      {
         ETG_TRACE_USR2((" STATE :: FC_PHONE_SMTRANSFERCALL_STATE_WAIT_FOR_SWAPDBUSACK_AND_CALLSTATUS "));
         vHandleEventInSwapDbusAckOrCallStatus(u16EventId);
      }
      break;
      case FC_PHONE_SMTRANSFERCALL_STATE_WAIT_FOR_SWAPDBUSACK:
      {
         ETG_TRACE_USR2((" STATE :: FC_PHONE_SMTRANSFERCALL_STATE_WAIT_FOR_SWAPDBUSACK  "));
         vHandleEventInSwapCall(u16EventId);
      }
      break;
      case FC_PHONE_SMTRANSFERCALL_STATE_WAIT_FOR_HOLDCALL:
      {
         ETG_TRACE_USR2((" STATE :: FC_PHONE_SMTRANSFERCALL_STATE_WAIT_FOR_HOLDCALL :: FC_PHONE_SMTRANSFERCALL_STATE_WAIT_FOR_HOLDCALL "));
         vHandleEventInHoldCall(u16EventId);
      }
      break;
      case FC_PHONE_SMTRANSFERCALL_STATE_WAIT_FOR_DISCONNECT_FROM_BT:
      {
         ETG_TRACE_USR2(("STATE :: FC_PHONE_SMTRANSFERCALL_STATE_WAIT_FOR_DISCONNECT_FROM_BT "));
         vHandleEventInTerminateBTInCall(u16EventId);
      }
         break;
      default:
      {
         ETG_TRACE_USR2(("STATE :: FC_PHONE_SMTRANSFERCALL State Doesnt match"));
         break;
      }
   }
   m_bEventConsumed |= m_bEventConsumed;
   ETG_TRACE_USR4(("  m_bEventConsumed = %d  ",m_bEventConsumed));
   return m_bEventConsumed;
}
/*******************************************************************************
 *
 * FUNCTION: RevertStateMachine
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMTransferCallHandSetHandsFree::RevertStateMachine()
{   
   ETG_TRACE_USR4((" Entering fc_phone_tclSMTransferCallHandSetHandsFree::RevertStateMachine "));
   fc_phone_tclCallInstance *pCallInstance[FC_PHONE_MAX_CALLINSTANCES];
   pCallInstance[0] = m_poCallInstance;
   pCallInstance[1] = m_poCallInstance2;
   //Revert to corresponding State Machine
   m_poSMManager->vRevertStateMachine(pCallInstance);
}
/*******************************************************************************
 *
 * FUNCTION: vHandleEventInHoldCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMTransferCallHandSetHandsFree::vHandleEventInHoldCall(tU16 u16EventId)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMTransferCallHandSetHandsFree::vHandleEventInHoldCall u16EventId %d",u16EventId));
   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_DBUS_HOLDCALL_ACK_OK:
      {
         ETG_TRACE_USR3(("  EVENT ::FC_PHONE_SM_EVENT_DBUS_HOLDCALL_ACK_OK "));
         //update the status to hold
         m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET;
         ETG_TRACE_USR2(("  State change::FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET "));
         if(m_poCallInstance)
         {
            m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
            m_poCallInstance->m_u16CallStatusNotice = FC_PHONE_CALLINSTANCE_CALLSTATUS_ONHOLD;
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_HOLDCALL,m_poCallInstance);
            // m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
            // m_pDbusIf->bGetCallStaus(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId));
         }
         else if(m_poCallInstance2)
         {
            m_poCallInstance2->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
            m_poCallInstance2->m_u16CallStatusNotice = FC_PHONE_CALLINSTANCE_CALLSTATUS_ONHOLD;
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_HOLDCALL,m_poCallInstance2);
            // m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance2);
            //m_pDbusIf->bGetCallStaus(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance2->m_u8BDAddressId));
         }
      }
      break;
      default:
      {
         ETG_TRACE_USR4((" fc_phone_tclSMTransferCallHandSetHandsFree::vHandleEventInHoldCall : DEFAULT u16EventId %d",u16EventId));
      }
      break;
   }
}
/*******************************************************************************
 *
 * FUNCTION: vHandleAlertToneInHandsFreeCallInstance1
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMTransferCallHandSetHandsFree::vHandleAlertToneInHandsFreeCallInstance1(tU16 u16EventId)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMTransferCallHandSetHandsFree::vHandleAlertToneInHandsFreeCallInstance1 u16EventId %d",u16EventId));
   switch(u16EventId)
   {
      case FC_PHONE_SM_EVENT_ALERT_REQUEST_OK:
      {
         ETG_TRACE_USR3(("  FC_PHONE_SM_EVENT_ALERT_REQUEST_OK"));
         if(m_poCallInstance2)
         {
            //if(m_poCallInstance2->m_u8AudioChannel)
            if (FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_poCallInstance2->m_u8AudioChannel)
            {
               m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_ALERTTONERELEASE_CALLINSTANCE2;
               ETG_TRACE_USR2(("  State change::FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_ALERTTONERELEASE_CALLINSTANCE2 "));
               ETG_TRACE_USR3(("Releasing audio...."));
               m_poAudioManager->s32ReleaseRequest(m_poCallInstance2->m_u16Id,m_poCallInstance2->m_u8AudioChannel,vAudioCallBackTransferCall);
               m_poCallInstance2->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
            }
         }
         else
         {
            if(m_poCallInstance)
            {
               m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIOREQUEST_CALLINSTANCE1;
               ETG_TRACE_USR2(("  State change::FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_ALERTTONERELEASE_CALLINSTANCE1 "));
               m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
               ETG_TRACE_USR3(("Requesting  audio....AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE "));
               m_poAudioManager->s32GetRequest(m_poCallInstance->m_u16Id,m_poCallInstance->m_u8AudioChannel,vAudioCallBackTransferCall);

            }
            else
            {
               //Dbus Transfer
               ETG_TRACE_USR4(("No call instance exist"));
            }
         }
         break;
      }
      case FC_PHONE_SM_EVENT_ALERT_REQUEST_NOK:
      {
         ETG_TRACE_USR4((" Failure of Releasing Alert Tone"));
         m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET;
         ETG_TRACE_USR2(("  State Change::FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET "));
         break;
      }
      default:
      {
         ETG_TRACE_USR4((" fc_phone_tclSMTransferCallHandSetHandsFree::vHandleAlertToneInHandsFreeCallInstance1 DEFAULT"));
         break;
      }
   }
}
/*******************************************************************************
 *
 * FUNCTION: vHandleAlertToneInHandsFreeCallInstance2
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMTransferCallHandSetHandsFree::vHandleAlertToneInHandsFreeCallInstance2(tU16 u16EventId)
{
   ETG_TRACE_USR4((" fc_phone_tclSMTransferCallHandSetHandsFree::vHandleAlertToneInHandsFreeCallInstance2 u16EventId %d",u16EventId));
   switch(u16EventId)
   {
      case FC_PHONE_SM_EVENT_ALERT_REQUEST_OK:
      {
         ETG_TRACE_USR3(("  FC_PHONE_SM_EVENT_ALERT_REQUEST_OK"));
         if(m_poCallInstance)
         {
            m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIOREQUEST_CALLINSTANCE1;
            ETG_TRACE_USR2(("  State ::FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIOREQUEST_CALLINSTANCE1 "));
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
            ETG_TRACE_USR3(("Requesting  audio....AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE "));
            m_poAudioManager->s32GetRequest(m_poCallInstance->m_u16Id,m_poCallInstance->m_u8AudioChannel,vAudioCallBackTransferCall);

         }
         else if(m_poCallInstance2)
         {
            m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIOREQUEST_CALLINSTANCE2;
            ETG_TRACE_USR2(("  State Change::FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIOREQUEST_CALLINSTANCE2 "));
            m_poCallInstance2->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
            ETG_TRACE_USR3(("Requesting  audio....AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE "));
            m_poAudioManager->s32GetRequest(m_poCallInstance2->m_u16Id,m_poCallInstance2->m_u8AudioChannel,vAudioCallBackTransferCall);

         }
         break;
      }
      case FC_PHONE_SM_EVENT_ALERT_REQUEST_NOK:
      {
         ETG_TRACE_USR4(("Failure of Releasing Alert Tone:: FC_PHONE_SM_EVENT_ALERT_REQUEST_NOK"));
         m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET;
         ETG_TRACE_USR2(("  State ::FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET "));
         break;
      }
      default:
      {
         ETG_TRACE_USR3(("fc_phone_tclSMTransferCallHandSetHandsFree::vHandleAlertToneInHandsFreeCallInstance2:: in default "));
         break;
      }
   }

}

/*******************************************************************************
 *
 * FUNCTION: vHandleAudioReleaseForAudioTransferFromPhoneCallInstance1
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMTransferCallHandSetHandsFree::vHandleAudioReleaseForAudioTransferFromPhoneCallInstance1(tU16 u16EventId)
{
   ETG_TRACE_USR4(("Entering vHandleAudioReleaseForAudioTransferFromPhoneCallInstance1 u16EventId %d ",u16EventId));
   tU8 u8SCOConnectionStatus = FC_PHONE_DBUS_SCO_CONN_FAILED;
   fc_phone_tclClientHandler_BTSettings *p_clientHndler_bluetooth = (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerBTSettings;
   if(m_poCallInstance)
   {
      u8SCOConnectionStatus = p_clientHndler_bluetooth->vGetSCOConnectionStatus(const_cast<tChar *> (fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId))); //CMG3G-4847 - To solve Lint
   }
   switch(u16EventId)
   {
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
      {
         ETG_TRACE_USR4(("Phone Chnl Release"));
         ETG_TRACE_USR3(("  FC_PHONE_SM_EVENT_PHONE_REQUEST_OK"));
         if(m_poCallInstance)
         {
            m_poCallInstance->m_bUsingVehicleAudio = FALSE;
            ETG_TRACE_USR3(("UsingVehicleAudio = FALSE  "));
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO, m_poCallInstance);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, m_poCallInstance);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_ACTIVECALLINHANDSET, m_poCallInstance);
         }
         if(m_poCallInstance2)
         {
            m_u16State_while_TransferAudio = FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE2_FOR_TRANSFERAUDIOREQ_FROMPHONE;
            if(m_poCallInstance2->m_u8AudioChannel != FC_PHONE_AUDIOCHANNEL_ID_UNUSED)
            {
               ETG_TRACE_USR3(("Releasing audio...."));
               m_poAudioManager->s32ReleaseRequest(m_poCallInstance2->m_u16Id,FC_PHONE_AUDIOCHANNEL_PHONE,vAudioCallBackTransferCall);
               m_poCallInstance2->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
            }
            else
            {
               bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
            }
         }
         else
         {
            /*Acquire Channel Fails, transfer audio to handset again*/
            if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_ESTABLISHED)
            {
               ETG_TRACE_USR4(("FC_PHONE_DBUS_SCO_CONN_ESTABLISHED. "));
               if (m_poCallInstance)
               {
                  m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId), FC_PHONE_CALLTRANSFER_FROMHANSFREE_TOHANDSET);
               }
               else
               {
                  m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET;
                  ETG_TRACE_USR2(("  State ::FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET "));
                  m_u16State_while_TransferAudio = 0;
               }
            }
            // GMMY15-813 Cannot switch call to handsfree from radio if incoming call answered from Bluetooth phone
            else if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_STATUS_UNKNOWN)
            {
               ETG_TRACE_USR4(("FC_PHONE_DBUS_SCO_CONN_STATUS_UNKNOWN. "));
               if (m_poCallInstance)
               {
                  m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId), FC_PHONE_CALLTRANSFER_FROMHANSFREE_TOHANDSET);
               }
               else
               {
                  m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET;
                  ETG_TRACE_USR2(("  State ::FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET "));
                  m_u16State_while_TransferAudio = 0;
               }
            }
            else
            {
               m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET;
               ETG_TRACE_USR2(("  State Change::FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET "));
               m_u16State_while_TransferAudio = 0;
            }
         }
      }
      break;
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK:
      {
         ETG_TRACE_USR3(("  FC_PHONE_SM_EVENT_PHONE_REQUEST_OK"));
         break;
      }
      break;
      case FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK:
      {
         m_u16State_while_TransferAudio = 0;
         m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET;
         ETG_TRACE_USR2(("  State Change::FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET "));
      }
      break;
      default:
      {
         ETG_TRACE_USR4((" fc_phone_tclSMTransferCallHandSetHandsFree::vHandleAudioReleaseForAudioTransferFromPhoneCallInstance1:: DEFAULT"));
         break;
      }
   }

}

/*******************************************************************************
 *
 * FUNCTION: vHandleAudioReleaseForAudioTransferFromPhoneCallInstance2
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMTransferCallHandSetHandsFree::vHandleAudioReleaseForAudioTransferFromPhoneCallInstance2(tU16 u16EventId)
{
   ETG_TRACE_USR4(("Entering vHandleAudioReleaseForAudioTransferFromPhoneCallInstance2 u16EventId %d ",u16EventId));
   tU8 u8SCOConnectionStatus = FC_PHONE_DBUS_SCO_CONN_FAILED;
   fc_phone_tclClientHandler_BTSettings *p_clientHndler_bluetooth = (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerBTSettings;
   if(m_poCallInstance2)
   {
      u8SCOConnectionStatus = p_clientHndler_bluetooth->vGetSCOConnectionStatus(const_cast<tChar *> (fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance2->m_u8BDAddressId))); //CMG3G-4847 - To solve Lint
   }
   switch(u16EventId)
   {
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
      {
         ETG_TRACE_USR3(("Phone Chnl Released::FC_PHONE_SM_EVENT_PHONE_REQUEST_OK"));
         if(m_poCallInstance2)
         {
            m_poCallInstance2->m_bUsingVehicleAudio = FALSE;
            ETG_TRACE_USR3(("UsingVehicleAudio = FALSE  "));
            m_poCallInstance2->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO, m_poCallInstance2);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, m_poCallInstance2);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_ACTIVECALLINHANDSET, m_poCallInstance2);
         }
         /*Acquire Channel Fails, transfer audio to handset again*/
         if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_ESTABLISHED)
         {
            ETG_TRACE_USR4(("FC_PHONE_DBUS_SCO_CONN_ESTABLISHED. "));
            if (m_poCallInstance2)
            {
               m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance2->m_u8BDAddressId), FC_PHONE_CALLTRANSFER_FROMHANSFREE_TOHANDSET);
            }
            else
            {
               m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET;
               ETG_TRACE_USR2(("  State Change::FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET "));
               m_u16State_while_TransferAudio = 0;
            }
         }
         // GMMY15-813 Cannot switch call to handsfree from radio if incoming call answered from Bluetooth phone
         else if (u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_STATUS_UNKNOWN)
         {
            ETG_TRACE_USR4(("FC_PHONE_DBUS_SCO_CONN_STATUS_UNKNOWN. "));
            if (m_poCallInstance2)
            {
               m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance2->m_u8BDAddressId), FC_PHONE_CALLTRANSFER_FROMHANSFREE_TOHANDSET);
            }
            else
            {
               m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET;
               ETG_TRACE_USR2(("  State Change::FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET "));
               m_u16State_while_TransferAudio = 0;
            }
         }
         else
         {
            m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET;
            ETG_TRACE_USR2(("  State Change::FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET "));
            m_u16State_while_TransferAudio = 0;
         }
      }
      break;
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK:
      {
         /*Do Nothing*/
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK"));
         break;
      }
      case FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK"));
         m_u16State_while_TransferAudio = 0;
         m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET;
         ETG_TRACE_USR2(("  State Change::FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET "));
      }
      break;
      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMTransferCallHandSetHandsFree::vHandleAudioReleaseForAudioTransferFromPhoneCallInstance2 ::DEFAULT "));
         break;
      }
   }
}
/*******************************************************************************
 *
 * FUNCTION: vHandleAudioRequestForAudioTransferFromPhoneCallInstance1
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMTransferCallHandSetHandsFree::vHandleAudioRequestForAudioTransferFromPhoneCallInstance1(tU16 u16EventId)
{
   ETG_TRACE_USR4(("Entering vHandleAudioRequestForAudioTransferFromPhoneCallInstance1 u16EventId %d",u16EventId));
   switch(u16EventId)
   {
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
      {
         ETG_TRACE_USR3(("Phone Chnl Acquired:: FC_PHONE_SM_EVENT_PHONE_REQUEST_OK"));
         if(m_poCallInstance)
         {
            m_poCallInstance->m_bUsingVehicleAudio = TRUE;
            ETG_TRACE_USR3(("UsingVehicleAudio = TRUE  "));
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO, m_poCallInstance);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, m_poCallInstance);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_ACTIVECALLINHANDSET, m_poCallInstance);
         }
         if(m_poCallInstance2)
         {
            m_u16State_while_TransferAudio = FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIOREQUEST_CALLINSTANCE2_FOR_TRANSFERAUDIOREQ_FROMPHONE;
            if(m_poCallInstance2->m_u8AudioChannel == FC_PHONE_AUDIOCHANNEL_ID_UNUSED)
            {
               m_poCallInstance2->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
               ETG_TRACE_USR3(("Requesting  audio....AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE "));
               m_poAudioManager->s32GetRequest(m_poCallInstance2->m_u16Id,m_poCallInstance2->m_u8AudioChannel,vAudioCallBackTransferCall);
            }
            else
            {
               bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
            }
         }
         else
         {
            RevertStateMachine();
         }
         break;
      }
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK:
      {
         /*Stay in Routed State of Transfer Call SM.*/
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK"));
         if(m_poCallInstance)
         {
            m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId), FC_PHONE_CALLTRANSFER_FROMHANSFREE_TOHANDSET);
         }
      }
      break;
      case FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK"));
         m_u16State_while_TransferAudio = 0;
         m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET;
         ETG_TRACE_USR2(("  State Change ::FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET "));
      }
      break;
      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMTransferCallHandSetHandsFree::vHandleAudioRequestForAudioTransferFromPhoneCallInstance1:: DEFAULT "));
         break;
      }
   }

}

/*******************************************************************************
 *
 * FUNCTION: vHandleAudioRequestForAudioTransferFromPhoneCallInstance2
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMTransferCallHandSetHandsFree::vHandleAudioRequestForAudioTransferFromPhoneCallInstance2(tU16 u16EventId)
{
   ETG_TRACE_USR4(("Entering vHandleAudioRequestForAudioTransferFromPhoneCallInstance2 u16EventId %d ",u16EventId));
   switch(u16EventId)
   {
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
      {
         ETG_TRACE_USR3(("Phone Chnl Acquired::FC_PHONE_SM_EVENT_PHONE_REQUEST_OK"));
         if(m_poCallInstance2)
         {
            m_poCallInstance2->m_bUsingVehicleAudio = TRUE;
            ETG_TRACE_USR3(("UsingVehicleAudio = TRUE  "));
            m_poCallInstance2->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO, m_poCallInstance2);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, m_poCallInstance2);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_ACTIVECALLINHANDSET, m_poCallInstance2);
         }
         m_u16State_while_TransferAudio = 0;
         RevertStateMachine();
         break;
      }
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK:
      {
         /*Stay in Routed State of Transfer Call SM. So Doing nothing Here*/
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK"));
         if(m_poCallInstance)
         {
            m_u16State_while_TransferAudio = FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE1_FOR_TRANSFERAUDIOREQ_FROMPHONE;
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
            ETG_TRACE_USR3(("Releasing audio....AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE"));
            m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id,m_poCallInstance->m_u8AudioChannel,vAudioCallBackTransferCall);
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
         }
         else if(m_poCallInstance2)
         {
            m_u16State_while_TransferAudio = FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE2_FOR_TRANSFERAUDIOREQ_FROMPHONE;
            m_poCallInstance2->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
            ETG_TRACE_USR3(("Releasing audio....AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE"));
            m_poAudioManager->s32ReleaseRequest(m_poCallInstance2->m_u16Id,m_poCallInstance2->m_u8AudioChannel,vAudioCallBackTransferCall);
            m_poCallInstance2->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
         }

      }
      break;
      case FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK"));
         m_u16State_while_TransferAudio = 0;
         m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET;
         ETG_TRACE_USR2(("  State Change::FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET "));
      }
      break;
      default:
      {
         ETG_TRACE_USR3(("fc_phone_tclSMTransferCallHandSetHandsFree::vHandleAudioRequestForAudioTransferFromPhoneCallInstance2:: DEFAULT "));
         break;
      }
   }
}

/*******************************************************************************
 *
 * FUNCTION: vHandleAudioRequestInHandsFreeCallInstance1
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMTransferCallHandSetHandsFree::vHandleAudioRequestInHandsFreeCallInstance1(tU16 u16EventId)
{
   ETG_TRACE_USR3((" fc_phone_tclSMTransferCallHandSetHandsFree::vHandleAudioRequestInHandsFreeCallInstance1 u16EventId :: %d", u16EventId));
   switch(u16EventId)
   {
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_PHONE_REQUEST_OK"));

         if(m_poCallInstance2)
         {
            m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIOREQUEST_CALLINSTANCE2;
            ETG_TRACE_USR2(("  State Change::FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIOREQUEST_CALLINSTANCE2 "));
            if (m_poCallInstance2->m_u8AudioChannel == FC_PHONE_AUDIOCHANNEL_ID_UNUSED)
            {
               m_poCallInstance2->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
               ETG_TRACE_USR3(("Requesting  audio....AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE "));
               m_poAudioManager->s32GetRequest(m_poCallInstance2->m_u16Id,m_poCallInstance2->m_u8AudioChannel,vAudioCallBackTransferCall);
            }
            else
            {
               bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
            }
         }
         else if(m_poCallInstance)
         {
            m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_CALLTRANSFER_TOHANDSFREE;
            ETG_TRACE_USR2(("  State Change::FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_CALLTRANSFER_TOHANDSFREE "));
            tU8 u8SCOConnectionStatus = FC_PHONE_DBUS_SCO_CONN_FAILED;
            fc_phone_tclClientHandler_BTSettings *p_clientHndler_bluetooth = (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerBTSettings;
            u8SCOConnectionStatus = p_clientHndler_bluetooth->vGetSCOConnectionStatus(const_cast<tChar *> (fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId))); //CMG3G-4847 - To solve Lint
            if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_DISCONNECTED)
            {
               ETG_TRACE_USR4(("FC_PHONE_DBUS_SCO_CONN_DISCONNECTED. "));
               m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId),FC_PHONE_CALLTRANSFER_FROMHANDSET_TOHANSFREE);
            }
            // GMMY15-813 Cannot switch call to handsfree from radio if incoming call answered from Bluetooth phone
            else if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_STATUS_UNKNOWN)
            {
               ETG_TRACE_USR4(("FC_PHONE_DBUS_SCO_CONN_STATUS_UNKNOWN. "));
               m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId),FC_PHONE_CALLTRANSFER_FROMHANDSET_TOHANSFREE);
            }
            else
            {
               bProcessEvent(FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK);
            }
         }
         break;
      }
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK:
      {
         ETG_TRACE_USR3(("Failure of acquiring LC_PHONE Chnl:: FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK"));
         m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET;
            ETG_TRACE_USR2(("  State Change::FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET "));
			 //GMMY16-19936- when channel is denied reset m_u8AudioChannel to toggle HS/HF
            if(m_poCallInstance)
            {
               m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
               ETG_TRACE_USR3(("Requesting  audio....AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED "));
               vAssignErrorCode(FC_PHONE_ALLOCATE_ACK_NO_AUDIO_CHANNEL);
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSFREE,m_poCallInstance);
            }
            else if(m_poCallInstance2)
            {
               m_poCallInstance2->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
               ETG_TRACE_USR3(("Requesting  audio....AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED "));
               vAssignErrorCode(FC_PHONE_ALLOCATE_ACK_NO_AUDIO_CHANNEL);
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSFREE,m_poCallInstance2);
            }
            break;
         }
      default:
      {
         ETG_TRACE_USR3(("fc_phone_tclSMTransferCallHandSetHandsFree::vHandleAudioRequestInHandsFreeCallInstance1:: DEFAULT "));
         break;
      }
   }

}

/*******************************************************************************
 *
 * FUNCTION: vHandleAudioRequestInHandsFreeCallInstance2
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMTransferCallHandSetHandsFree::vHandleAudioRequestInHandsFreeCallInstance2(tU16 u16EventId)
{
   ETG_TRACE_USR4((" fc_phone_tclSMTransferCallHandSetHandsFree::vHandleAudioRequestInHandsFreeCallInstance2 u16EventId %d",u16EventId));
   switch(u16EventId)
   {
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_PHONE_REQUEST_OK"));
         tU8 u8SCOConnectionStatus = FC_PHONE_DBUS_SCO_CONN_FAILED;
         fc_phone_tclClientHandler_BTSettings *p_clientHndler_bluetooth = (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerBTSettings;
         if(m_poCallInstance)
            u8SCOConnectionStatus = p_clientHndler_bluetooth->vGetSCOConnectionStatus(const_cast<tChar *> (fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId))); //CMG3G-4847 - To solve Lint
         else if(m_poCallInstance2)
            u8SCOConnectionStatus = p_clientHndler_bluetooth->vGetSCOConnectionStatus(const_cast<tChar *> (fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance2->m_u8BDAddressId))); //CMG3G-4847 - To solve Lint

         if(m_poCallInstance)
         {
            m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_CALLTRANSFER_TOHANDSFREE;
            ETG_TRACE_USR2(("  State Change::FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_CALLTRANSFER_TOHANDSFREE"));
            ETG_TRACE_USR4((" Currently Audio Manager NOT READY SO ASSUMING AUDIO IS READY AND INVOKING DBUS CALLS     "));
            if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_DISCONNECTED)
            {
               ETG_TRACE_USR4(("FC_PHONE_DBUS_SCO_CONN_DISCONNECTED. "));
               m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId),FC_PHONE_CALLTRANSFER_FROMHANDSET_TOHANSFREE);
            }
            // GMMY15-813 Cannot switch call to handsfree from radio if incoming call answered from Bluetooth phone
            else if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_STATUS_UNKNOWN)
            {
               ETG_TRACE_USR4(("FC_PHONE_DBUS_SCO_CONN_STATUS_UNKNOWN. "));
               m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId),FC_PHONE_CALLTRANSFER_FROMHANDSET_TOHANSFREE);
            }
            else
            {
               bProcessEvent(FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK);
            }
         }
         else if(m_poCallInstance2)
         {
            m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_CALLTRANSFER_TOHANDSFREE;
            ETG_TRACE_USR2(("  State Change::FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_CALLTRANSFER_TOHANDSFREE"));
            ETG_TRACE_USR4((" Currently Audio Manager NOT READY SO ASSUMING AUDIO IS READY AND INVOKING DBUS CALLS     "));
            if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_DISCONNECTED)
            {
               ETG_TRACE_USR4(("FC_PHONE_DBUS_SCO_CONN_DISCONNECTED. "));
               m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance2->m_u8BDAddressId),FC_PHONE_CALLTRANSFER_FROMHANDSET_TOHANSFREE);
            }
            // GMMY15-813 Cannot switch call to handsfree from radio if incoming call answered from Bluetooth phone
            else if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_STATUS_UNKNOWN)
            {
               ETG_TRACE_USR4(("FC_PHONE_DBUS_SCO_CONN_STATUS_UNKNOWN. "));
               m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance2->m_u8BDAddressId),FC_PHONE_CALLTRANSFER_FROMHANDSET_TOHANSFREE);
            }
            else
            {
               bProcessEvent(FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK);
            }
         }
         break;
      }
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK:
      {
         ETG_TRACE_ERR(("Failure of acquiring LC_PHONE Chnl::FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK"));
         m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET;
         ETG_TRACE_USR2(("  State Change::FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET"));
		 //GMMY16-19936- when channel is denied reset m_u8AudioChannel to toggle HS/HF
         if(m_poCallInstance)
         {
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
            ETG_TRACE_USR3(("Requesting  audio....AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED "));
            vAssignErrorCode(FC_PHONE_ALLOCATE_ACK_NO_AUDIO_CHANNEL);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSFREE,m_poCallInstance);
         }
         else if(m_poCallInstance2)
         {
            m_poCallInstance2->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
            ETG_TRACE_USR3(("Requesting  audio....AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED "));
            vAssignErrorCode(FC_PHONE_ALLOCATE_ACK_NO_AUDIO_CHANNEL);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSFREE,m_poCallInstance2);
         }
         break;
      }
      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMTransferCallHandSetHandsFree::vHandleAudioRequestInHandsFreeCallInstance2:: DEFAULT "));
         break;
      }
   }
}

/*******************************************************************************
 *
 * FUNCTION: vHandleEventOnCallTransferToHandSet
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMTransferCallHandSetHandsFree::vHandleEventOnCallTransferToHandSet(tU16 u16EventId)
{
   ETG_TRACE_USR4((" fc_phone_tclSMTransferCallHandSetHandsFree::vHandleEventOnCallTransferToHandSet u16EventId %d",u16EventId));
   switch(u16EventId)
   {
      case FC_PHONE_SM_EVENT_HOLDCALL_REQUEST:
      {
         ETG_TRACE_USR3(("  EVENT ::FC_PHONE_SM_EVENT_HOLDCALL_REQUEST "));
         /* Forward Hold Request to DBus */
         m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_WAIT_FOR_HOLDCALL;
         if(m_poCallInstance)
         {
            m_pDbusIf->bHoldCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId));
         }
         else if(m_poCallInstance2)
         {
            m_pDbusIf->bHoldCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance2->m_u8BDAddressId));
         }
      }
      break;
      case FC_PHONE_SM_EVENT_TRANSFERCALL_ACK_OK:
      {
         ETG_TRACE_USR3((" FC_PHONE_SM_EVENT_TRANSFERCALL_ACK_OK "));
         ETG_TRACE_USR2(("STATE :: CALL TRANSFER TO HANDSET SUCCESS "));
      }
      break;

      case FC_PHONE_SM_EVENT_TRANSFERCALLVEHICLE_REQUEST_OK:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_TRANSFERCALLVEHICLE_REQUEST_OK"));
         m_bEventConsumed = TRUE;
         CallTransferState = FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSFREE;
         vHandleTransferCallRequestToVehicle();
      }
      break;

      case FC_PHONE_SM_EVENT_SWAPCALL_OK:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_SWAPCALL_OK"));
         m_bEventConsumed = TRUE ;
         if(m_poCallInstance)
         {
            m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_WAIT_FOR_SWAPDBUSACK_AND_CALLSTATUS ;
            ETG_TRACE_USR2(("  State Change::FC_PHONE_SMTRANSFERCALL_STATE_WAIT_FOR_SWAPDBUSACK_AND_CALLSTATUS"));
            m_pDbusIf->bSwapCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId));
         }
         else if(m_poCallInstance2)
         {
            m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_WAIT_FOR_SWAPDBUSACK_AND_CALLSTATUS ;
            ETG_TRACE_USR2(("  State Change::FC_PHONE_SMTRANSFERCALL_STATE_WAIT_FOR_SWAPDBUSACK_AND_CALLSTATUS"));
            m_pDbusIf->bSwapCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance2->m_u8BDAddressId));
         }
      }
      break;
      case FC_PHONE_SM_EVENT_IF_HANDSETCALL_TRANSFER_TOVEHICLE:
      {
         ETG_TRACE_USR3((" EVENT :: FC_PHONE_SM_EVENT_IF_HANDSETCALL_TRANSFER_TOVEHICLE "));
         m_bEventConsumed = TRUE ;
         //Acquire Audio
         //Transfer Audio to Vehicle
         //Start corresponding SM (Dial/Accept)
         CallTransferState = FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSFREE;
         if(m_poCallInstance)
         {
            (fc_phone_tclApp::m_poMainAppInstance)->m_poTimer->s32Stop(static_cast<tU16>(FC_PHONE_SMTRANSFERCALL_AUDIOTRANSFER_TIMER_ID+m_poCallInstance->m_u16Id));
         }
         else if(m_poCallInstance2)
         {
            (fc_phone_tclApp::m_poMainAppInstance)->m_poTimer->s32Stop(static_cast<tU16>(FC_PHONE_SMTRANSFERCALL_AUDIOTRANSFER_TIMER_ID+m_poCallInstance2->m_u16Id));
         }
         vHandleTransferCallRequestToVehicle();
      }
      break;

      case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
      {
         ETG_TRACE_USR3((" EVENT :: FC_PHONE_SM_EVENT_PHONE_REQUEST_OK "));
         if(m_u16State_while_TransferAudio == FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE1_FOR_TRANSFERAUDIOREQ_FROMPHONE)
         {
            vHandleAudioReleaseForAudioTransferFromPhoneCallInstance1(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
         }
         else if(m_u16State_while_TransferAudio == FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE2_FOR_TRANSFERAUDIOREQ_FROMPHONE)
         {
            vHandleAudioReleaseForAudioTransferFromPhoneCallInstance2(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
         }
         else if(m_u16State_while_TransferAudio == FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIOREQUEST_CALLINSTANCE1_FOR_TRANSFERAUDIOREQ_FROMPHONE)
         {
            vHandleAudioRequestForAudioTransferFromPhoneCallInstance1(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
         }
         else if(m_u16State_while_TransferAudio == FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIOREQUEST_CALLINSTANCE2_FOR_TRANSFERAUDIOREQ_FROMPHONE)
         {
            vHandleAudioRequestForAudioTransferFromPhoneCallInstance2(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
         }

      }
      break;

      case FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK:
      {
         ETG_TRACE_USR3((" EVENT :: FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK "));
         if(m_u16State_while_TransferAudio == FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE1_FOR_TRANSFERAUDIOREQ_FROMPHONE)
         {
            vHandleAudioReleaseForAudioTransferFromPhoneCallInstance1(FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK);
         }
         else if(m_u16State_while_TransferAudio == FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE2_FOR_TRANSFERAUDIOREQ_FROMPHONE)
         {
            vHandleAudioReleaseForAudioTransferFromPhoneCallInstance2(FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK);
         }
         else if(m_u16State_while_TransferAudio == FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIOREQUEST_CALLINSTANCE1_FOR_TRANSFERAUDIOREQ_FROMPHONE)
         {
            vHandleAudioRequestForAudioTransferFromPhoneCallInstance1(FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK);
         }
         else if(m_u16State_while_TransferAudio == FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIOREQUEST_CALLINSTANCE2_FOR_TRANSFERAUDIOREQ_FROMPHONE)
         {
            vHandleAudioRequestForAudioTransferFromPhoneCallInstance2(FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK);
         }
      }
      break;

      case FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK:
      {
         ETG_TRACE_USR3((" EVENT :: FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK "));
         m_u16State_while_TransferAudio = 0;
      }
      break;

      case FC_PHONE_SM_EVENT_HANGUPCALLALL_OK :
      {
         ETG_TRACE_USR3((" FC_PHONE_SM_EVENT_HANGUPCALLALL_OK"));
         m_bEventConsumed = TRUE ;
         m_bHangUpAllMethodStart = TRUE;
         FCPhoneDbusClient_TerminateType_t enTerminateType = FC_PHONE_DBUS_TERMINATETYPE_SINGLECALL;
         if((fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->bIsAgThreeWayCallSupported())
         {
            enTerminateType = FC_PHONE_DBUS_TERMINATETYPE_ALL;
         }
         ETG_TRACE_USR4((" enTerminateType:: %d",enTerminateType));
         if(m_poCallInstance)
         {
            m_pDbusIf->bHangUpCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId),enTerminateType);
         }
         else if(m_poCallInstance2)
         {
            m_pDbusIf->bHangUpCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance2->m_u8BDAddressId),enTerminateType);
         }
      }
      break;
      case FC_PHONE_SM_EVENT_HANGUPCALL_OK :
      {
         ETG_TRACE_USR3((" FC_PHONE_SM_EVENT_HANGUPCALL_OK"));

         vHangUpCall();
      }
      break;

      case FC_PHONE_SM_EVENT_RESUMECALL_REQUEST:
      {
         ETG_TRACE_USR3(("  EVENT ::FC_PHONE_SM_EVENT_RESUMECALL_REQUEST "));

         /* Forward Resume Request to DBus */
         m_bEventConsumed = TRUE ;
         m_bResumeCallMethodStart = TRUE;
         if (m_poCallInstance)
         {
            m_pDbusIf->bResumeCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId));
         }
         else if (m_poCallInstance2)
         {
            m_pDbusIf->bResumeCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance2->m_u8BDAddressId));
         }
      }
      break;

      case FC_PHONE_SM_EVENT_DBUS_RESUMECALL_ACK_OK:
      {

         ETG_TRACE_USR3(("  EVENT ::FC_PHONE_SM_EVENT_DBUS_RESUMECALL_ACK_OK "));
         m_bResumeCallMethodStart = FALSE;
         if (m_poCallInstance)
         {
            m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_RESUMECALL,m_poCallInstance);
         }
         else if (m_poCallInstance2)
         {
            m_poCallInstance2->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_RESUMECALL,m_poCallInstance2);
         }
      }
      break;

      case FC_PHONE_SM_EVENT_SENDDTMF:
      {
         ETG_TRACE_USR3(("  EVENT ::FC_PHONE_SM_EVENT_SENDDTMF "));
         ETG_TRACE_USR4(("u16_oneTimeDTMFCalculation:: %d ",u16_oneTimeDTMFCalculation));
         if(0 == u16_oneTimeDTMFCalculation)
         {
            u16_oneTimeDTMFCalculation = 1;
            if (m_poCallInstance)
            {
               if (FC_PHONE_CALLINSTANCE_CALLSTATUS_ACTIVE == m_poCallInstance->m_u16CallStatusNotice)
               {
                  m_u16DTMFCharLength  = static_cast<tU16>(OSAL_u32StringLength(m_poCallInstance->DTMFChar));
               }
            }

            if (m_poCallInstance2)
            {
               if (FC_PHONE_CALLINSTANCE_CALLSTATUS_ACTIVE == m_poCallInstance2->m_u16CallStatusNotice)
               {
                  m_u16DTMFCharLength  = static_cast<tU16>(OSAL_u32StringLength(m_poCallInstance2->DTMFChar));
               }
            }

            m_u16SentDtmfCounter  = 0;
            (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vSetDtmfStatus(TRUE);
            ETG_TRACE_USR4(("  m_u16DTMFCharLength :: %d ",m_u16DTMFCharLength));
         }

         if (m_poCallInstance)
         {
            if (FC_PHONE_CALLINSTANCE_CALLSTATUS_ACTIVE == m_poCallInstance->m_u16CallStatusNotice)
            {
               tU8 u8DtmfValue = (tU8)m_poCallInstance->DTMFChar[m_u16SentDtmfCounter];
               m_pDbusIf->bSendDTMF(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId),u8DtmfValue);
            }
         }

         if (m_poCallInstance2)
         {
            if (FC_PHONE_CALLINSTANCE_CALLSTATUS_ACTIVE == m_poCallInstance2->m_u16CallStatusNotice)
            {
               tU8 u8DtmfValue = (tU8)m_poCallInstance2->DTMFChar[m_u16SentDtmfCounter];
               m_pDbusIf->bSendDTMF(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance2->m_u8BDAddressId),u8DtmfValue);
            }
         }
      }
      break;

      case FC_PHONE_SM_EVENT_DBUS_DTMF_ACK_OK:
      {
         ETG_TRACE_USR3(("  EVENT ::FC_PHONE_SM_EVENT_DBUS_DTMF_ACK_OK "));

         //Update Method Status
         m_u16SentDtmfCounter++;

         if(m_u16SentDtmfCounter == m_u16DTMFCharLength)
         {
            ETG_TRACE_USR4(("  SENDING DTMF SUCCESS ,sending MR to client"));
            u16_oneTimeDTMFCalculation = 0;
            m_u16SentDtmfCounter  = 0;
            m_u16DTMFCharLength   = 0;

            if (m_poCallInstance)
            {
               if (FC_PHONE_CALLINSTANCE_CALLSTATUS_ACTIVE == m_poCallInstance->m_u16CallStatusNotice)
               {
                  m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
                  m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_PLAYDTMF,m_poCallInstance);
               }
            }

            if (m_poCallInstance2)
            {
               if (FC_PHONE_CALLINSTANCE_CALLSTATUS_ACTIVE == m_poCallInstance2->m_u16CallStatusNotice)
               {
                  m_poCallInstance2->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
                  m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_PLAYDTMF,m_poCallInstance2);
               }
            }

            (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vSetDtmfStatus(FALSE);
         }
         else
         {
            ETG_TRACE_USR4((" Previous DTMF sent, processing for next  "));
            bProcessEvent(FC_PHONE_SM_EVENT_SENDDTMF);
         }
      }
      break;

      case FC_PHONE_SM_EVENT_CANCELOUTGOINGCALL_OK:
         {
            ETG_TRACE_USR4((" FC_PHONE_SM_EVENT_CANCELOUTGOINGCALL_OK  "));
            vTerminateOutgoingCall();
            m_bEventConsumed = TRUE;
         }
         break;
      default:
      {
         ETG_TRACE_USR4((" fc_phone_tclSMTransferCallHandSetHandsFree::vHandleEventOnCallTransferToHandSet DEFAULT "));
         break;
      }
   }
}

/*******************************************************************************
 *
 * FUNCTION: vHandleEventOnCallTransferToHandsFree
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMTransferCallHandSetHandsFree::vHandleEventOnCallTransferToHandsFree(tU16 u16EventId)
{
   ETG_TRACE_USR4((" fc_phone_tclSMTransferCallHandSetHandsFree::vHandleEventOnCallTransferToHandsFree u16EventId %d",u16EventId));
   switch(u16EventId)
   {
      case FC_PHONE_SM_EVENT_TRANSFERCALL_ACK_OK:
      {
         ETG_TRACE_USR2(("STATE :: CALL TRANSFER TO HANDSFREE SUCCESS "));
         ETG_TRACE_USR3(("EVENT  :: FC_PHONE_SM_EVENT_TRANSFERCALL_ACK_OK "));
         break;
      }
      default:
      {
         ETG_TRACE_USR4((" fc_phone_tclSMTransferCallHandSetHandsFree::vHandleEventOnCallTransferToHandsFree u16EventId :: DEFAULT "));
         break;
      }
   }

}


/*******************************************************************************
 *
 * FUNCTION: vHandleAudioTransferInHandSetCallInstance1
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMTransferCallHandSetHandsFree::vHandleAudioTransferInHandSetCallInstance1(tU16 u16EventId)
{
   ETG_TRACE_USR4((" fc_phone_tclSMTransferCallHandSetHandsFree::vHandleAudioTransferInHandSetCallInstance1 u16EventId %d",u16EventId));
   switch(u16EventId)
   {
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
      {
         //Fix for GMMY17-10316
         if(m_u16State_while_TransferAudio != 0)
         {
            if(bProcessEventinSubState(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK))
            {
               ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_PHONE_REQUEST_OK consumed in Substate"));
            }
         }
         else
         {
            ETG_TRACE_USR3(("EVENT  :: FC_PHONE_SM_EVENT_PHONE_REQUEST_OK "));
            m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE2;
            ETG_TRACE_USR2(("  State Change::FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE2"));
            if(m_poCallInstance)
            {
               m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
               m_poCallInstance->m_bUsingVehicleAudio = FALSE;
               ETG_TRACE_USR3(("UsingVehicleAudio = FALSE "));
               m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_ACTIVECALLINHANDSET,m_poCallInstance);
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
               //TODO Handling Alert (0x3FF) active with alert manager, deactivate alert using DeactivateAlert.StartAck, Microphone
            }


            if(m_poCallInstance2)
            {
               m_poCallInstance2->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
               //TODO Should I hv to assign Audio Channel ??, Need to check Microphone stream from outgoing audio
               ETG_TRACE_USR4(("Transfer Call m_poCallInstance2->m_u8AudioChannel = %d",m_poCallInstance2->m_u8AudioChannel));
               if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_poCallInstance2->m_u8AudioChannel)
               {
                  ETG_TRACE_USR3(("Releasing audio...."));
                  m_poAudioManager->s32ReleaseRequest(m_poCallInstance2->m_u16Id,m_poCallInstance2->m_u8AudioChannel,vAudioCallBackTransferCall);
                  m_poCallInstance2->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
               }
            }
            else
            {
               ETG_TRACE_USR4(("No call instance is active hence audio is released and transfer call is done"));
               m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET;
               ETG_TRACE_USR2(("  State Change::FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET"));
               //Call Instance is null so faking FC_PHONE_SM_EVENT_PHONE_REQUEST_OK
               bProcessEvent(FC_PHONE_SM_EVENT_TRANSFERCALL_ACK_OK);
            }
         }
         break;
      }
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK:
      {
         //Fix for GMMY17-10316
         if(m_u16State_while_TransferAudio != 0)
         {
            if(bProcessEventinSubState(FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK))
            {
               ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK consumed in Substate"));
            }
         }
         else
         {
            ETG_TRACE_USR3(("EVENT  :: FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK "));
            if(m_poCallInstance)
            {
               ETG_TRACE_USR4(("TRANSFERCALL STATE :: AUDIO CHANNEL NOTRELEASED AND UPDATING STATUS "));
               m_poCallInstance->m_bUsingVehicleAudio = TRUE;
               ETG_TRACE_USR3(("UsingVehicleAudio = TRUE  "));
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
               //TODO Should I have to revert to original state Machine again
               RevertStateMachine();
            }
         }
         break;
      }
      default:
      {
         ETG_TRACE_USR4((" fc_phone_tclSMTransferCallHandSetHandsFree::vHandleAudioTransferInHandSetCallInstance1 DEFAULT"));
         break;
      }
   }
}
/*******************************************************************************
 *
 * FUNCTION: vHandleAudioTransferInHandSetCallInstance2
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMTransferCallHandSetHandsFree::vHandleAudioTransferInHandSetCallInstance2(tU16 u16EventId)
{
   ETG_TRACE_USR4((" fc_phone_tclSMTransferCallHandSetHandsFree::vHandleAudioTransferInHandSetCallInstance2 u16EventId %d",u16EventId));
   switch(u16EventId)
   {
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
      {
         //Fix for GMMY17-10316
         if(m_u16State_while_TransferAudio != 0)
         {
            if(bProcessEventinSubState(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK))
            {
               ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_PHONE_REQUEST_OK consumed in Substate"));
            }
         }
         else
         {
            ETG_TRACE_USR3((" EVENT ::FC_PHONE_SM_EVENT_PHONE_REQUEST_OK"));
            m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET;
            ETG_TRACE_USR2(("  State Change::FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET"));
            if(m_poCallInstance2)
            {
               m_poCallInstance2->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
               m_poCallInstance2->m_bUsingVehicleAudio = FALSE;
               ETG_TRACE_USR3(("UsingVehicleAudio = FALSE "));
               m_poCallInstance2->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance2);
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_ACTIVECALLINHANDSET,m_poCallInstance2);
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance2);
            }
            //Transfer Call is being done
            bProcessEvent(FC_PHONE_SM_EVENT_TRANSFERCALL_ACK_OK);
         }
         break;
      }
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK:
      {
         //Fix for GMMY17-10316
         if(m_u16State_while_TransferAudio != 0)
         {
            if(bProcessEventinSubState(FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK))
            {
               ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK consumed in Substate"));
            }
         }
         else
         {
            ETG_TRACE_USR3((" EVENT ::FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK"));
            if(m_poCallInstance2)
            {
               ETG_TRACE_USR3(("TRANSFERCALL STATE :: AUDIO CHANNEL NOTRELEASED AND UPDATING STATUS "));
               m_poCallInstance2->m_bUsingVehicleAudio = TRUE;
               ETG_TRACE_USR3(("UsingVehicleAudio = TRUE  "));
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance2);
               //TODO Should I have to revert to original state Machine again
               RevertStateMachine();
            }
         }
         break;
      }
      default:
      {
         ETG_TRACE_USR3(("fc_phone_tclSMTransferCallHandSetHandsFree::vHandleAudioTransferInHandSetCallInstance2:: DEFAULT  "));
         break;
      }
   }

}

/*******************************************************************************
 *
 * FUNCTION:   bProcessEventinSubState
 *
 * DESCRIPTION:Fix for GMMY17-10316
 *             The event FC_PHONE_SM_EVENT_PHONE_REQUEST_OK and
 *             FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK to be handled in the substates
 *             if m_u16State_while_TransferAudio is not zero
 *
 * PARAMETER:  u16EventId
 *
 * RETURNVALUE: Boolean.
 *              TRUE - Event is consumed in the Sub-state
 *              FALSE- Event is not consumed in the Sub-state
 *
 ********************************************************************************/
tBool fc_phone_tclSMTransferCallHandSetHandsFree::bProcessEventinSubState(tU16 u16EventId)
{
   ETG_TRACE_USR4((" fc_phone_tclSMTransferCallHandSetHandsFree::bProcessEventinSubState u16EventId ::%d",u16EventId));
   ETG_TRACE_USR4((" fc_phone_tclSMTransferCallHandSetHandsFree::m_u16State_while_TransferAudio = %d", m_u16State_while_TransferAudio));

   tBool bIsEventConsumed = TRUE;

   switch(u16EventId)
   {
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
      {
         ETG_TRACE_USR3((" EVENT :: FC_PHONE_SM_EVENT_PHONE_REQUEST_OK "));
         if(m_u16State_while_TransferAudio == FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE1_FOR_TRANSFERAUDIOREQ_FROMPHONE)
         {
            vHandleAudioReleaseForAudioTransferFromPhoneCallInstance1(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
         }
         else if(m_u16State_while_TransferAudio == FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE2_FOR_TRANSFERAUDIOREQ_FROMPHONE)
         {
            vHandleAudioReleaseForAudioTransferFromPhoneCallInstance2(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
         }
         else if(m_u16State_while_TransferAudio == FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIOREQUEST_CALLINSTANCE1_FOR_TRANSFERAUDIOREQ_FROMPHONE)
         {
            vHandleAudioRequestForAudioTransferFromPhoneCallInstance1(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
         }
         else if(m_u16State_while_TransferAudio == FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIOREQUEST_CALLINSTANCE2_FOR_TRANSFERAUDIOREQ_FROMPHONE)
         {
            vHandleAudioRequestForAudioTransferFromPhoneCallInstance2(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
         }
         else
         {
            bIsEventConsumed = FALSE;
         }
         break;
      }
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK:
      {
         ETG_TRACE_USR3((" EVENT :: FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK "));
         if(m_u16State_while_TransferAudio == FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE1_FOR_TRANSFERAUDIOREQ_FROMPHONE)
         {
            vHandleAudioReleaseForAudioTransferFromPhoneCallInstance1(FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK);
         }
         else if(m_u16State_while_TransferAudio == FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE2_FOR_TRANSFERAUDIOREQ_FROMPHONE)
         {
            vHandleAudioReleaseForAudioTransferFromPhoneCallInstance2(FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK);
         }
         else if(m_u16State_while_TransferAudio == FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIOREQUEST_CALLINSTANCE1_FOR_TRANSFERAUDIOREQ_FROMPHONE)
         {
            vHandleAudioRequestForAudioTransferFromPhoneCallInstance1(FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK);
         }
         else if(m_u16State_while_TransferAudio == FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIOREQUEST_CALLINSTANCE2_FOR_TRANSFERAUDIOREQ_FROMPHONE)
         {
            vHandleAudioRequestForAudioTransferFromPhoneCallInstance2(FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK);
         }
         else
         {
            bIsEventConsumed = FALSE;
         }
         break;
      }
      default:
      {
         ETG_TRACE_USR4((" fc_phone_tclSMTransferCallHandSetHandsFree::bProcessEventinSubState u16EventId ::%d",u16EventId));
         bIsEventConsumed = FALSE;
      }
   }

   ETG_TRACE_USR4(("bIsEventConsumed = %d", bIsEventConsumed));
   return bIsEventConsumed;
}
/*******************************************************************************
 *
 * FUNCTION: vHandleEventInHandSetCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMTransferCallHandSetHandsFree::vHandleEventInHandSetCall(tU16 u16EventId)
{
   ETG_TRACE_USR4((" fc_phone_tclSMTransferCallHandSetHandsFree::vHandleEventInHandSetCall u16EventId ::%d",u16EventId));
   tU8 u8TransferCallCause = (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->m_u8TransferCallCause;
   switch(u16EventId)
   {
      case FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK:
      {
         ETG_TRACE_USR4((" EVENT : FC_PHONE_SM_EVENT_DBUS_HANDSET_TRANSFERCALL_ACK_OK"));
         if(m_poCallInstance)
         {
            if(u8TransferCallCause == FC_PHONE_TRANSFERCALL_HMI_TRIGGER)
            {
               ETG_TRACE_USR4(("Sending TransferCallToHandSet Method Result"));
               m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSET,m_poCallInstance);
               //m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_ACTIVECALLINHANDSET,m_poCallInstance);
            }
            else
            {
               ETG_TRACE_USR4(("External trigger hence. Not sending TransferCallToHandSet Method Result"));
            }
         }
         else if(m_poCallInstance2)
         {
            if(u8TransferCallCause == FC_PHONE_TRANSFERCALL_HMI_TRIGGER)
            {
               ETG_TRACE_USR4(("Sending TransferCallToHandSet Method Result"));
               m_poCallInstance2->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSET,m_poCallInstance2);
               //m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_ACTIVECALLINHANDSET,m_poCallInstance2);
            }
            else
            {
               ETG_TRACE_USR4(("External trigger hence.  Not sending TransferCallToHandSet Method Result"));
            }
         }
         if(u8TransferCallCause == FC_PHONE_TRANSFERCALL_EXT_TRIGGER)
         {
            if(m_poCallInstance)
            {
               m_poAudioManager->s32SyncAudioMangerOnChannelRelease(m_poCallInstance->m_u16Id,m_poCallInstance->m_u8AudioChannel);
               m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
               m_poCallInstance->m_bUsingVehicleAudio = FALSE;
               ETG_TRACE_USR3(("UsingVehicleAudio = FALSE "));
               m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_ACTIVECALLINHANDSET,m_poCallInstance);
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
            }
            if(m_poCallInstance2)
            {
               m_poAudioManager->s32SyncAudioMangerOnChannelRelease(m_poCallInstance2->m_u16Id,m_poCallInstance2->m_u8AudioChannel);
               m_poCallInstance2->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
               m_poCallInstance2->m_bUsingVehicleAudio = FALSE;
               ETG_TRACE_USR3(("UsingVehicleAudio = FALSE "));
               m_poCallInstance2->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance2);
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_ACTIVECALLINHANDSET,m_poCallInstance2);
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance2);
            }
            (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->m_u8TransferCallCause = 0;
            m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET;
            ETG_TRACE_USR2(("  State Change::FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET"));
            //Transfer Call is being done
            bProcessEvent(FC_PHONE_SM_EVENT_TRANSFERCALL_ACK_OK);
         }
         else if(u8TransferCallCause == FC_PHONE_TRANSFERCALL_EXT_TRIGGER_DNT_RELEASE_CHANNEL)
         {
            ETG_TRACE_USR2((" FC_PHONE_TRANSFERCALL_EXT_TRIGGER_DNT_RELEASE_CHANNEL"));
         }
         else
         {
            if(m_poCallInstance)
            {
               m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE1;
               ETG_TRACE_USR2(("State Change: FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE1"));
               //NCG3D-19473
               /*m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
               //TODO Should I hv to assign Audio Channel ??, Need to check Microphone stream from outgoing audio
               if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_poCallInstance->m_u8AudioChannel)
               {
                  ETG_TRACE_USR3(("Releasing audio...."));
                  m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id,m_poCallInstance->m_u8AudioChannel,vAudioCallBackTransferCall);
                  m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
               }*/
               //TODO Handling Alert (0x3FF) active with alert manager, deactivate alert using DeactivateAlert.StartAck
            }
            else if(m_poCallInstance2)
            {
               ETG_TRACE_USR4((" Call Instance is null so faking FC_PHONE_SM_EVENT_PHONE_REQUEST_OK"));
               m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE2;
               ETG_TRACE_USR2(("State Change: FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE2"));
               //NCG3D-19473
               /*if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_poCallInstance2->m_u8AudioChannel)
               {
                  ETG_TRACE_USR3(("Releasing audio...."));
                  m_poAudioManager->s32ReleaseRequest(m_poCallInstance2->m_u16Id,m_poCallInstance2->m_u8AudioChannel,vAudioCallBackTransferCall);
                  m_poCallInstance2->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
               }*/
            }
            else
            {
               m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET;
               ETG_TRACE_USR2(("  State Change::FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET"));
               //Call Instance is null so faking FC_PHONE_SM_EVENT_PHONE_REQUEST_OK
               bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
            }
         }
         break;
      }
      default:
      {
         ETG_TRACE_USR4((" fc_phone_tclSMTransferCallHandSetHandsFree::vHandleEventInHandSetCall DEFAULT"));
         break;
      }

   }
}
/*******************************************************************************
 *
 * FUNCTION: vHandleEventInHandsFreeCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMTransferCallHandSetHandsFree::vHandleEventInHandsFreeCall(tU16 u16EventId)
{
   ETG_TRACE_USR4((" fc_phone_tclSMTransferCallHandSetHandsFree::vHandleEventInHandsFreeCall u16EventId %d",u16EventId));
   switch(u16EventId)
   {
      case FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK:
      {
         m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_CALLTRANSFERRED_TOHANDSFREE;
         ETG_TRACE_USR2(("State Change: FC_PHONE_SMTRANSFERCALL_STATE_CALLTRANSFERRED_TOHANDSFREE"));
         ETG_TRACE_USR3((" EVENT : FC_PHONE_SM_EVENT_DBUS_HANDSFREE_TRANSFERCALL_ACK_OK"));

         if(m_poCallInstance)
         {
            m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSFREE,m_poCallInstance);
            /*HMI needs Active call in handset update once call is transferred from handset
             *  to handsfree and update is sent as IDLE*/
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_ACTIVECALLINHANDSET,m_poCallInstance);
         }
         else if(m_poCallInstance2)
         {
            m_poCallInstance2->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSFREE,m_poCallInstance2);
            /*HMI needs Active call in handset update once call is transferred from handset
             *  to handsfree and update is sent as IDLE*/
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_ACTIVECALLINHANDSET,m_poCallInstance2);
         }
         //TODO Handling Alert (1001,1002,1003) active with alert manager, deactivate alert using DeactivateAlert.StartAck
         //TODO Restart the previous State Machine by Cancelling the current state machine and timer resets
         RevertStateMachine();
         break;
      }
      default:
      {
         ETG_TRACE_USR4((" fc_phone_tclSMTransferCallHandSetHandsFree::vHandleEventInHandsFreeCall DEFAULT"));
         break;
      }

   }
}

/*******************************************************************************
 *
 * FUNCTION: vHandleEventInSwapDbusAckOrCallStatus
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMTransferCallHandSetHandsFree::vHandleEventInSwapDbusAckOrCallStatus(tU16 u16EventId)
{
   ETG_TRACE_USR4(("  fc_phone_tclSMTransferCallHandSetHandsFree::vHandleEventInSwapDbusAckOrCallStatus"));

   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_DBUS_SWAPCALL_ACK_OK :
      {
         ETG_TRACE_USR3(("  FC_PHONE_SM_EVENT_DBUS_SWAPCALL_ACK_OK "));
         m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET;
         ETG_TRACE_USR2(("State Change: FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET"));
		 //CMG3GB-1410- post Swap MR on Dbus ack.
         if(m_poCallInstance)
         {
            m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_SWAPCALL,m_poCallInstance);
         }
         else if(m_poCallInstance2)
         {
            m_poCallInstance2->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_SWAPCALL,m_poCallInstance2);
         }
      }
      break ;

      case FC_PHONE_SM_EVENT_CALLSTATUS_UPDATE:
      {
         ETG_TRACE_USR3(("  FC_PHONE_SM_EVENT_CALLSTATUS_UPDATE "));
         m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_WAIT_FOR_SWAPDBUSACK ;
         ETG_TRACE_USR2(("State Change: FC_PHONE_SMTRANSFERCALL_STATE_WAIT_FOR_SWAPDBUSACK"));
      }
      break ;
      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMTransferCallHandSetHandsFree::vHandleEventInSwapDbusAckOrCallStatus Default. u16EventId:: %d",u16EventId));
      }
      break;
   }
}
/*******************************************************************************
 *
 * FUNCTION: vHandleEventInSwapCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMTransferCallHandSetHandsFree::vHandleEventInSwapCall(tU16 u16EventId)
{
   ETG_TRACE_USR4(("  fc_phone_tclSMTransferCallHandSetHandsFree::vHandleEventInSwapCallu16EventId %d ",u16EventId));
   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_DBUS_SWAPCALL_ACK_OK :
      case FC_PHONE_SM_EVENT_CALLSTATUS_UPDATE :
      {
         ETG_TRACE_USR4(("   SENDING SWAPCALL MR to client"));
         if(m_poCallInstance)
         {
            m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET;
            ETG_TRACE_USR2(("State Change: C_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET"));
            m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_SWAPCALL,m_poCallInstance);
         }
         else if(m_poCallInstance2)
         {
            m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET;
            ETG_TRACE_USR2(("State Change: C_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET"));
            m_poCallInstance2->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_SWAPCALL,m_poCallInstance2);
         }
      }
      break ;


      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMTransferCallHandSetHandsFree::vHandleEventInSwapCall Default. u16EventId:: %d",u16EventId));
      }
      break;
   }
}

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMTransferCallHandSetHandsFree::vAudioCallBack
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMTransferCallHandSetHandsFree::vAudioCallBack(tU16 u16AudioChannelId, tU16 u16RequestState)
{
   ETG_TRACE_USR4((" fc_phone_tclSMTransferCallHandSetHandsFree::vAudioCallBack "));
   switch (u16AudioChannelId)
   {
      case FC_PHONE_AUDIOCHANNEL_ALERTTONE:
      {
         ETG_TRACE_USR3(("EVENT : FC_PHONE_AUDIOCHANNEL_ALERTTONE "));
         if(FC_PHONE_AUDIOCHANNEL_GRANTED == u16RequestState)
         {
            ETG_TRACE_USR3((" u16RequestState::FC_PHONE_AUDIOCHANNEL_GRANTED "));
            bProcessEvent(FC_PHONE_SM_EVENT_ALERT_REQUEST_OK);
         }
         else
         {
            ETG_TRACE_USR3((" u16RequestState::FC_PHONE_AUDIOCHANNEL_DENIED_SUSPENDED "));
            bProcessEvent(FC_PHONE_SM_EVENT_ALERT_REQUEST_NOK);
         }
         break;
      }
      case FC_PHONE_AUDIOCHANNEL_PHONE:
      {
         if(FC_PHONE_AUDIOCHANNEL_GRANTED == u16RequestState)
         {
            ETG_TRACE_USR3((" u16RequestState::FC_PHONE_AUDIOCHANNEL_GRANTED"));
            bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
         }
         else
         {
            //TODO How to Handle if AudioChannel is not released
            ETG_TRACE_USR3((" u16RequestState::FC_PHONE_AUDIOCHANNEL_DENIED_SUSPENDED "));
            bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK);
         }
         break;
      }
      default:
      {
         ETG_TRACE_USR4((" fc_phone_tclSMTransferCallHandSetHandsFree::vAudioCallBack:: UNKNOWN u16AudioChannelId "));
         break;
      }
   }
}
/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMAcceptCall::vTimerCallBack
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMTransferCallHandSetHandsFree::vTimerCallBack(tU16 u16TimerId)
{
   ETG_TRACE_USR4((" fc_phone_tclSMTransferCallHandSetHandsFree::vTimerCallBack u16TimerId %d ",u16TimerId));
   if(m_poCallInstance)
   {
      if((FC_PHONE_SMTRANSFERCALL_AUDIOTRANSFER_TIMER_ID +(m_poCallInstance->m_u16Id)) == u16TimerId)
      {
         vTimeOutOnAudioTransfer();
         return;
      }
   }
   if(m_poCallInstance2)
   {
      if((FC_PHONE_SMTRANSFERCALL_AUDIOTRANSFER_TIMER_ID + (m_poCallInstance2->m_u16Id)) == u16TimerId)
      {
         vTimeOutOnAudioTransfer();
         return;
      }
   }

   if(u16TimerId == FC_PHONE_CALLINSTANCE_TIMER_ID)
   {
      if (m_poCallInstance)
      {
         vIncrementTimer(m_poCallInstance);
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, m_poCallInstance);
      }
      if (m_poCallInstance2)
      {
         vIncrementTimer(m_poCallInstance2);
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, m_poCallInstance2);
      }
   }
   else
   {
      ETG_TRACE_USR4(("Invalid timerID(Not CallInstance)"));
   }
}
/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMTransferCallHandSetHandsFree::vNewCallStatus
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMTransferCallHandSetHandsFree::vNewCallStatus(const T_CallData* const prCallData,tU16 u16_callInstance)
{
   ETG_TRACE_USR4((" fc_phone_tclSMTransferCallHandSetHandsFree::vNewCallStatus m_u16State %d",m_u16State));
   fc_phone_tclCallInstance* poCallInstance_current = NULLPTR;
   if(m_poCallInstance)
   {
      if(m_poCallInstance->m_u16Id == u16_callInstance)
      {
         poCallInstance_current = m_poCallInstance;
      }

   }
   if(m_poCallInstance2)
   {
      if(m_poCallInstance2->m_u16Id == u16_callInstance)
      {
         poCallInstance_current = m_poCallInstance2;
      }

   }

   //CMG3G-8447. Lint fix.
   //The below if condition becomes TRUE only when both the call instances turn to be NULL.
   if(!poCallInstance_current)
   {
      ETG_TRACE_USR4(("poCallInstance_current is NULL. Hence returning."));
      return;
   }

   if(TRUE == m_bHangUpMethodStart )
   {
      ETG_TRACE_USR4(("m_releaseCallInstanceID %d ",m_releaseCallInstanceID));
      if(m_releaseCallInstanceID == u16_callInstance)
      {
         if(PHONE_CALLSTATE_IDLE != prCallData->rCallStatus.u8CallState)
         {
            poCallInstance_current->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_HANGUP,poCallInstance_current);
            ETG_TRACE_USR4((" Set m_bHangUpMethodStart to FALSE"));

         }
         else
         {
            poCallInstance_current->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_HANGUP,poCallInstance_current);
         }
         m_bHangUpMethodStart = FALSE;
      }
      else
      {
         ETG_TRACE_USR4(("Call status update received for Active call Instance"));
      }
   }
   else if(TRUE == m_bHangUpAllMethodStart)
   {
      if(PHONE_CALLSTATE_IDLE != prCallData->rCallStatus.u8CallState)
      {
         poCallInstance_current->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_HANGUP,poCallInstance_current);
         ETG_TRACE_USR4((" Set m_bHangUpMethodStart to FALSE"));

      }
      else
      {
         poCallInstance_current->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_HANGUP,poCallInstance_current);
      }
      m_bHangUpAllMethodStart = FALSE;

   }


   /* Send Call status notification and act on Call Status accordingly */
   switch(m_u16State)
   {
      case FC_PHONE_SMTRANSFERCALL_STATE_WAIT_FOR_SWAPDBUSACK_AND_CALLSTATUS:
      {
         ETG_TRACE_USR2((" FC_PHONE_SMTRANSFERCALL_STATE_WAIT_FOR_SWAPDBUSACK_AND_CALLSTATUS"));
         if(PHONE_CALLSTATE_IDLE == prCallData->rCallStatus.u8CallState)
         {
            //start IDLE SM for IDLE call instance
            // start dial/accept SM for second
            //to stop timer if running
            if(FC_PHONE_CALLINSTANCE_CALLSTATUS_IDLE !=  poCallInstance_current->m_u16CallStatusNotice)
            {
               m_poTimer->s32Stop(poCallInstance_current->m_u16TimerId); // Bugfix for GMMY16-17241
               if(poCallInstance_current->m_u8AudioChannel == FC_PHONE_AUDIOCHANNEL_PHONE)
               {
                  ETG_TRACE_USR3(("Releasing audio...."));
                  m_poAudioManager->s32ReleaseRequest(poCallInstance_current->m_u16Id, FC_PHONE_AUDIOCHANNEL_PHONE,vAudioCallBackTransferCall);
                  poCallInstance_current->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
               }
            }
            if(TransferCallSMCallInstances == FC_PHONE_MAX_CALLINSTANCES)
            {
               TransferCallSMCallInstances--;
               if(poCallInstance_current == m_poCallInstance)
               {
                  m_poCallInstance = NULLPTR;
               }
               if(poCallInstance_current == m_poCallInstance2)
               {
                  m_poCallInstance2 = NULLPTR;
               }
               m_poSMManager->vSMStartIdleSM(poCallInstance_current);
               //CMG3G-8447. Lint Fix.
               if(poCallInstance_current)
               {
                  poCallInstance_current->vInit();
                  m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, poCallInstance_current);
                  m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_ACTIVECALLINHANDSET,poCallInstance_current);
               }
               else
               {
                  ETG_TRACE_USR4(("poCallInstance_current is NULL now!!!"));
               }
            }
            else if(TransferCallSMCallInstances == (FC_PHONE_MAX_CALLINSTANCES-1))
            {
               TransferCallSMCallInstances = 0;
               poCallInstance_current->vInit();
               //vCopyCallData(prCallData,poCallInstance_current);
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, poCallInstance_current);
               //Assuming vehicle Audio is false
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_ACTIVECALLINHANDSET,poCallInstance_current);
               m_poSMManager->vSMFinished(poCallInstance_current->m_u16Id);
            }
         }
         else
         {
            ETG_TRACE_USR4(("UPDATING CALL STATUS TO Client "));
            bProcessEvent(FC_PHONE_SM_EVENT_CALLSTATUS_UPDATE);
            vCopyCallData(prCallData,poCallInstance_current);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, poCallInstance_current);
         }
      }
      break;
      default:
      {
         ETG_TRACE_USR2((" vNewCallStatus:: m_u16State %d",m_u16State));
         if(PHONE_CALLSTATE_IDLE == prCallData->rCallStatus.u8CallState)
         {
            //start IDLE SM for IDLE call instance
            // start dial/accept SM for second
            //to stop timer if running
            if(FC_PHONE_CALLINSTANCE_CALLSTATUS_IDLE !=  poCallInstance_current->m_u16CallStatusNotice)
            {
               m_poTimer->s32Stop(poCallInstance_current->m_u16TimerId); // Bugfix for GMMY16-17241
               if(poCallInstance_current->m_u8AudioChannel == FC_PHONE_AUDIOCHANNEL_PHONE)
               {
                  ETG_TRACE_USR3(("Releasing audio...."));
                  m_poAudioManager->s32ReleaseRequest(poCallInstance_current->m_u16Id, FC_PHONE_AUDIOCHANNEL_PHONE,vAudioCallBackTransferCall);
                  poCallInstance_current->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;

               }
            }
            if(TransferCallSMCallInstances == FC_PHONE_MAX_CALLINSTANCES)
            {
               ETG_TRACE_USR4(("vRevertStateMachine entered"));

               //Fix for NCG3D-85055 issue.
               fc_phone_tclCallInstance *pCallInstance[FC_PHONE_MAX_CALLINSTANCES] = { NULLPTR };

               if (poCallInstance_current)
               {
                  poCallInstance_current->vInit();
                  m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, poCallInstance_current);
               }

               if (poCallInstance_current == m_poCallInstance)
               {
                  ETG_TRACE_USR4(("m_poCallInstance matches with rfpCallInstance"));
                  if (m_poCallInstance2)
                  {
                     pCallInstance[1] = m_poCallInstance2;
                  }
                  else
                  {
                     ETG_TRACE_FATAL(("FATAL : m_poCallInstance2 is NULL"));
                  }
                  pCallInstance[0] = poCallInstance_current;
               }

               if (poCallInstance_current == m_poCallInstance2)
               {
                  ETG_TRACE_USR4(("m_poCallInstance2 matches with rfpCallInstance"));
                  if (m_poCallInstance)
                  {
                     pCallInstance[0] = m_poCallInstance;
                  }
                  else
                  {
                     ETG_TRACE_FATAL(("FATAL : m_poCallInstance is NULL"));
                  }
                  pCallInstance[1] = poCallInstance_current;
               }

               m_poSMManager->vRevertStateMachine(pCallInstance);

            }
            else if(TransferCallSMCallInstances == (FC_PHONE_MAX_CALLINSTANCES-1))
            {
               TransferCallSMCallInstances = 0;
               if(poCallInstance_current)
               {
                  poCallInstance_current->vInit();
                  //vCopyCallData(prCallData,poCallInstance_current);
                  m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, poCallInstance_current);
                  //Assuming vehicle Audio is false
                  m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_ACTIVECALLINHANDSET,poCallInstance_current);
                  m_poSMManager->vSMFinished(poCallInstance_current->m_u16Id);
               }
               else
               {
                  ETG_TRACE_USR4(("poCallInstance_current is NULL now!!!"));
               }
            }
         }
         else
         {
            //GMMY16-13831- start timer if not started when call status received as ACTIVE/HELD
            if((PHONE_CALLSTATE_ACTIVE == prCallData->rCallStatus.u8CallState)
                  ||(PHONE_CALLSTATE_HELD == prCallData->rCallStatus.u8CallState))
            {
               if(FALSE == (fc_phone_tclApp::m_poMainAppInstance)->m_poTimer->s32GetAliveTimerId(FC_PHONE_CALLINSTANCE_TIMER_ID))
               {
                  ETG_TRACE_USR4(("Start timer "));
                  poCallInstance_current->m_u16TimerId = FC_PHONE_CALLINSTANCE_TIMER_ID;
                  m_poTimer->s32Start(poCallInstance_current->m_u16TimerId,FC_PHONE_ONE_SECOND,vCallInstanceTimerCallBack);
               }
               else
               {
                  ETG_TRACE_USR4(("Call Timer running "));
               }

               //NCG3D-1646. Incoming call event was set to IDLE if the call status changes from RINGING to ACTIVE or HELD.
               if (FC_PHONE_CALLINSTANCE_INCOMINGCALLEVENT_RINGING == poCallInstance_current->m_u16IncomingCallEvent)
               {
                  ETG_TRACE_USR4((" Sending u16IncomingCallEvent IDLE to the clients"));
                  poCallInstance_current->m_u16IncomingCallEvent = FC_PHONE_CALLINSTANCE_INCOMINGCALLEVENT_IDLE;
                  m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_INCOMINGCALL, poCallInstance_current);
               }
            }
            ETG_TRACE_USR4(("UPDATING CALL STATUS TO Client "));
            vCopyCallData(prCallData,poCallInstance_current);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, poCallInstance_current);
         }
      }
      break;
   }
}
/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMTransferCallHandSetHandsFree:: vHandleTransferCallDbusError
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMTransferCallHandSetHandsFree::vHandleTransferCallDbusError(tU16 u16DbusAckType,tChar Code)
{
   ETG_TRACE_USR4(("fc_phone_tclSMTransferCallHandSetHandsFree::vHandleTransferCallDbusError "));

   switch(u16DbusAckType)
   {
      case FC_PHONE_CB_FID_AUDIOTRANSFER:
      {
         ETG_TRACE_USR3((" FC_PHONE_CB_FID_AUDIOTRANSFER "));
         vAssignErrorCode(Code);
         //Method Error for TransferCall Failure
         /*If 1st call is accepted in handset and 2nd call accpeted in HMI and if Audio Transfer Fails*/
         if(((fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vGetAudioTransferStatus() == FC_PHONE_DBUS_SCO_CONN_DISCONNECTED) && (m_u8AudioRetryCounter < FC_PHONE_AUDIOTRANSFER_RETRY_MAX))
         {
            if(m_poCallInstance)
            {
               (fc_phone_tclApp::m_poMainAppInstance)->m_poTimer->s32Start(static_cast<tU16>(FC_PHONE_SMTRANSFERCALL_AUDIOTRANSFER_TIMER_ID+m_poCallInstance->m_u16Id),ONE_SECOND,vCallInstanceTimerCallBack);
               m_u8AudioRetryCounter++;
            }
            else if(m_poCallInstance2)
            {
               (fc_phone_tclApp::m_poMainAppInstance)->m_poTimer->s32Start(static_cast<tU16>(FC_PHONE_SMTRANSFERCALL_AUDIOTRANSFER_TIMER_ID+m_poCallInstance2->m_u16Id),ONE_SECOND,vCallInstanceTimerCallBack);
               m_u8AudioRetryCounter++;
            }
            return;
         }
         else
         {
            if(CallTransferState == FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSET)
            {
               ETG_TRACE_USR3((" CallTransferState == FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSET "));

               //Fix for NCG3D-3419. TransferCalltoHS_MR should not be sent if it is an EXT TRIGGER(eg.SA_OFF received w/o ReleaseRequest)
               if(((fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->m_u8TransferCallCause) == FC_PHONE_TRANSFERCALL_HMI_TRIGGER)
               {
                  if(m_poCallInstance)
                  {
                     m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
                     m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSET,m_poCallInstance);
                  }
                  else if(m_poCallInstance2)
                  {
                     m_poCallInstance2->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
                     m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSET,m_poCallInstance2);
                  }
               }
               else if(((fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->m_u8TransferCallCause) == FC_PHONE_TRANSFERCALL_EXT_TRIGGER_DNT_RELEASE_CHANNEL)
               {
                  ETG_TRACE_USR2((" FC_PHONE_TRANSFERCALL_EXT_TRIGGER_DNT_RELEASE_CHANNEL"));
                  if(m_poCallInstance)
                  {
                     m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
                     m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_ACCEPTCALL,m_poCallInstance);
                  }
                  else if(m_poCallInstance2)
                  {
                     m_poCallInstance2->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
                     m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_ACCEPTCALL,m_poCallInstance2);
                  }
                  (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->m_u8TransferCallCause = 0;
               }
               //Fix for NCG3D-3419.
               else if(((fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->m_u8TransferCallCause) == FC_PHONE_TRANSFERCALL_EXT_TRIGGER)
               {
                  ETG_TRACE_USR2((" FC_PHONE_TRANSFERCALL_EXT_TRIGGER so sync channel attributes"));
                  if(m_poCallInstance)
                  {
                     m_poAudioManager->s32SyncAudioMangerOnChannelRelease(m_poCallInstance->m_u16Id,m_poCallInstance->m_u8AudioChannel);
                     m_poCallInstance->m_u8AudioChannel =  FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
                     m_poCallInstance->m_bUsingVehicleAudio = FALSE;
                  }
                  if(m_poCallInstance2)
                  {
                     m_poAudioManager->s32SyncAudioMangerOnChannelRelease(m_poCallInstance2->m_u16Id,m_poCallInstance2->m_u8AudioChannel);
                     m_poCallInstance2->m_u8AudioChannel =  FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
                     m_poCallInstance2->m_bUsingVehicleAudio = FALSE;
                  }
                  (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->m_u8TransferCallCause = 0;
               }
               CallTransferState = 0;
               RevertStateMachine();
            }
            else if(CallTransferState == FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSFREE)
            {
               m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET;
               if(m_poCallInstance)
               {
                  if(m_poCallInstance->m_u8AudioChannel == FC_PHONE_AUDIOCHANNEL_PHONE)
                  {
                     ETG_TRACE_USR3(("Releasing audio...."));
                     m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id,m_poCallInstance->m_u8AudioChannel,vAudioCallBackTransferCall);
                  }
                  m_poCallInstance->m_u8AudioChannel =  FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
                  m_poCallInstance->m_bUsingVehicleAudio = FALSE;
                  ETG_TRACE_USR3(("UsingVehicleAudio = FALSE "));
                  m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSFREE,m_poCallInstance);
                  m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
                  m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
                  m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_ACTIVECALLINHANDSET,m_poCallInstance);
               }
               if(m_poCallInstance2)
               {
                  if(m_poCallInstance2->m_u8AudioChannel == FC_PHONE_AUDIOCHANNEL_PHONE)
                  {
                     ETG_TRACE_USR3(("Releasing audio...."));
                     m_poAudioManager->s32ReleaseRequest(m_poCallInstance2->m_u16Id,m_poCallInstance2->m_u8AudioChannel,vAudioCallBackTransferCall);
                  }
                  m_poCallInstance2->m_u8AudioChannel =  FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
                  m_poCallInstance2->m_bUsingVehicleAudio = FALSE;
                  ETG_TRACE_USR3(("UsingVehicleAudio = FALSE "));
                  m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSFREE,m_poCallInstance2);
                  m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance2);
                  m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance2);
                  m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_ACTIVECALLINHANDSET,m_poCallInstance2);
               }
               CallTransferState = 0;
            }
         }
      }
      break;

      case FC_PHONE_CB_FID_HOLDCALL:
      {
         ETG_TRACE_USR3((" FC_PHONE_CB_FID_HOLDCALL "));
         if(m_u16State == FC_PHONE_SMTRANSFERCALL_STATE_WAIT_FOR_HOLDCALL)
         {
            ETG_TRACE_USR4((" FC_PHONE_CB_FID_HOLDCALL "));
            vAssignErrorCode(Code);
            m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET;
            if(m_poCallInstance)
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_HOLDCALL,m_poCallInstance);
            else if(m_poCallInstance2)
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_HOLDCALL,m_poCallInstance2);
         }
         else
         {
            ETG_TRACE_USR4((" HOLDCALL Error is not serviced in this state"));
         }
      }
      break;

      case FC_PHONE_CB_FID_SWAPCALL:
      {
         ETG_TRACE_USR3((" FC_PHONE_CB_FID_SWAPCALL"));
         if((m_u16State == FC_PHONE_SMTRANSFERCALL_STATE_WAIT_FOR_SWAPDBUSACK_AND_CALLSTATUS) ||
               (m_u16State == FC_PHONE_SMTRANSFERCALL_STATE_WAIT_FOR_SWAPDBUSACK))
         {
            ETG_TRACE_USR4((" FC_PHONE_CB_FID_SWAPCALL "));
            vAssignErrorCode(Code);
            m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET;
            if(m_poCallInstance)
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_SWAPCALL,m_poCallInstance);
            else if(m_poCallInstance2)
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_SWAPCALL,m_poCallInstance2);
         }
         else
         {
            ETG_TRACE_USR4((" Swap CALL Error is not serviced in this state"));
         }
      }
      break;

      case FC_PHONE_CB_FID_HANGUPCALL:
      {
         ETG_TRACE_USR3((" FC_PHONE_CB_FID_HANGUPCALL"));
         if((m_bHangUpAllMethodStart == TRUE) || (m_bHangUpMethodStart == TRUE))
         {
            ETG_TRACE_USR4((" FC_PHONE_CB_FID_HANGUPCALL "));
            vAssignErrorCode(Code);
            m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET;
            if(m_poCallInstance)
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_HANGUP,m_poCallInstance);
            else if(m_poCallInstance2)
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_HANGUP,m_poCallInstance2);
         }
         else
         {
            ETG_TRACE_USR4((" Hangup CALL Error is not serviced in this state"));
         }
      }
      break;

      case FC_PHONE_CB_FID_RESUMECALL:
      {
         ETG_TRACE_USR3((" FC_PHONE_CB_FID_RESUMECALL"));
         if(m_bResumeCallMethodStart == TRUE)
         {
            ETG_TRACE_USR4((" FC_PHONE_CB_FID_RESUMECALL "));
            m_bResumeCallMethodStart = FALSE;
            vAssignErrorCode(Code);

            m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET;

            if(m_poCallInstance)
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_RESUMECALL,m_poCallInstance);
            else if(m_poCallInstance2)
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_RESUMECALL,m_poCallInstance2);
         }
         else
         {
            ETG_TRACE_USR4((" Resume CALL Error is not serviced in this state"));
         }
      }
      break;

      case FC_PHONE_CB_FID_SENDDTMF:
      {
         //Targeted to SM hence dont care of States
         ETG_TRACE_USR3((" FC_PHONE_CB_FID_SENDDTMF "));
         vAssignErrorCode(Code);
         (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vSetDtmfStatus(FALSE);
         if(m_poCallInstance)
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_PLAYDTMF,m_poCallInstance);
         else if(m_poCallInstance2)
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_PLAYDTMF,m_poCallInstance2);

         m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET;
      }
      break;

      case FC_PHONE_CB_FID_TERMINATE:
      {
         ETG_TRACE_USR3((" FC_PHONE_CB_FID_TERMINATE"));
         vAssignErrorCode(Code);
         m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET;
         if(m_poCallInstance)
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_CANCELOUTGOINGCALL,m_poCallInstance);
         else if(m_poCallInstance2)
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_CANCELOUTGOINGCALL,m_poCallInstance2);
      }
      break;
      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMTransferCallHandSetHandsFree::vHandleTransferCallDbusError This Event ID is not supported yet"));
      }
      break;
   }
}
/********************************************************************************
 * FUNCTION: vProcessOnDynamicDisconnect
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMTransferCallHandSetHandsFree::vProcessOnDynamicDisconnect(tU16 u16EventId)
{
   ETG_TRACE_USR4(("fc_phone_tclSMTransferCallHandSetHandsFree::vProcessOnDynamicDisconnect u16EventId %d ",u16EventId));
   //release Audio channels
   switch(u16EventId)
   {
   case FC_PHONE_SM_EVENT_SLC_OFF:
      {
         //m_bUsingVehicleAudio false , and stop timer if running
         //if(TRUE == m_bTimerRunning)
         //{
         if(m_poCallInstance)
         {
            if( FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_poCallInstance->m_u8AudioChannel )
            {
               if(((fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->m_u8TransferCallCause) != FC_PHONE_TRANSFERCALL_EXT_TRIGGER)
               {
                  ETG_TRACE_USR2((" EVENT :: RELEASING Audio Channel "));
                  m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id,m_poCallInstance->m_u8AudioChannel,vAudioCallBackTransferCall);
               }
               else
               {   
                  ETG_TRACE_USR2((" FC_PHONE_TRANSFERCALL_EXT_TRIGGER so sync channel attributes. "));
                  m_poAudioManager->s32SyncAudioMangerOnChannelRelease(m_poCallInstance->m_u16Id,m_poCallInstance->m_u8AudioChannel);
               }
            }
            //if any audio channel is not aquired , got to idle state and send the status to client
            //m_bUsingVehicleAudio false , and stop timer if running
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
            m_poCallInstance->m_bUsingVehicleAudio = FALSE;
            ETG_TRACE_USR3(("UsingVehicleAudio = FALSE "));
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,\
               m_poCallInstance);
            m_poTimer->s32Stop(m_poCallInstance->m_u16TimerId); // Bugfix for GMMY16-17241
            //m_bTimerRunning = FALSE;
            vCancel();
            m_poCallInstance->vInit();
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
            //send SLC status to client
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_SLC,m_poCallInstance);
         }
         if(m_poCallInstance2)
         {
            if( FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_poCallInstance2->m_u8AudioChannel )
            {
               if(((fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->m_u8TransferCallCause) != FC_PHONE_TRANSFERCALL_EXT_TRIGGER)
               {
                  ETG_TRACE_USR2((" EVENT :: RELEASING Audio Channel "));
                  m_poAudioManager->s32ReleaseRequest(m_poCallInstance2->m_u16Id,m_poCallInstance2->m_u8AudioChannel,vAudioCallBackTransferCall);
               }
               else
               {   
                  ETG_TRACE_USR2((" FC_PHONE_TRANSFERCALL_EXT_TRIGGER so sync channel attributes. "));
                  m_poAudioManager->s32SyncAudioMangerOnChannelRelease(m_poCallInstance2->m_u16Id,m_poCallInstance2->m_u8AudioChannel);
               }
            }
            //if any audio channel is not aquired , got to idle state and send the status to client
            //m_bUsingVehicleAudio false , and stop timer if running
            m_poCallInstance2->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
            m_poCallInstance2->m_bUsingVehicleAudio = FALSE;
            ETG_TRACE_USR3(("UsingVehicleAudio = FALSE "));
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,\
               m_poCallInstance2);
            m_poTimer->s32Stop(m_poCallInstance2->m_u16TimerId); // Bugfix for GMMY16-17241
            //m_bTimerRunning = FALSE;
            vCancel();
            m_poCallInstance2->vInit();
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance2);
            //send SLC status to client
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_SLC,m_poCallInstance2);
         }
         if((m_poCallInstance) && (m_poCallInstance2))
         {
            //go to idle state
            fc_phone_tclCallInstance* poTempCallInstance = m_poCallInstance;
            m_poCallInstance = NULLPTR ;
            m_poSMManager->vSMStartIdleSM(poTempCallInstance);
            m_poSMManager->vSMFinished(m_poCallInstance2->m_u16Id);
         }
         else if(m_poCallInstance)
         {
            //go to idle state
            m_poSMManager->vSMFinished(m_poCallInstance->m_u16Id);
         }
         else if(m_poCallInstance2)
         {
            //go to idle state
            m_poSMManager->vSMFinished(m_poCallInstance2->m_u16Id);
         }
         //}
      }
      break;
   default:
      {
         ETG_TRACE_USR4(("IN DEFAULT : vProcessOnDynamicDisconnect: wrong u16EventId= %d ",u16EventId));
      }
      break;
   }
}

/*******************************************************************************
 *
 * FUNCTION: vProcessAudioSignal
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMTransferCallHandSetHandsFree::vProcessAudioSignal()
{
   ETG_TRACE_USR4(("fc_phone_tclSMTransferCallHandSetHandsFree::vProcessAudioSignal "));
   //NCG3D-131177: The Accept call should be processed only after receiving the SCO connection from the STACK.
   // Hence the SM handling is moved here.
   tU8 u8TransferCallCause = (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->m_u8TransferCallCause;
   if(u8TransferCallCause == FC_PHONE_TRANSFERCALL_EXT_TRIGGER_DNT_RELEASE_CHANNEL)
   {
      ETG_TRACE_USR2((" FC_PHONE_TRANSFERCALL_EXT_TRIGGER_DNT_RELEASE_CHANNEL"));
      (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->m_u8TransferCallCause = 0;
      // TODO: The SM should be reverted to SM_Accept call and the audio Manager changes should be taken into account

      if(m_poCallInstance != NULLPTR)
      {
         m_poTimer->s32Stop(m_poCallInstance->m_u16TimerId);
      }
      if(m_poCallInstance2 != NULLPTR)
      {
         m_poTimer->s32Stop(m_poCallInstance2->m_u16TimerId);
      }
      vCancel();

      tU16 u16ID;
      (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vSwitchtoActive(u16ID);
      m_poSMManager->vTransferToAcceptCallSMforPassiveDev(u16ID);

      return;
   }

   /*HfSetUp Audio signal is received and transfer call to handsfree again*/
   tU8 u8SCOConnectionStatus = FC_PHONE_DBUS_SCO_CONN_FAILED;
   fc_phone_tclClientHandler_BTSettings *p_clientHndler_bluetooth = (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerBTSettings;
   if(m_poCallInstance)
   {
      u8SCOConnectionStatus = p_clientHndler_bluetooth->vGetSCOConnectionStatus(const_cast<tChar *> (fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId))); //CMG3G-4847 - To solve Lint
   }
   else if(m_poCallInstance2)
   {
      u8SCOConnectionStatus = p_clientHndler_bluetooth->vGetSCOConnectionStatus(const_cast<tChar *> (fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance2->m_u8BDAddressId))); //CMG3G-4847 - To solve Lint
   }

   if( FC_PHONE_DBUS_SCO_CONN_ESTABLISHED == u8SCOConnectionStatus)
   {
      ETG_TRACE_USR4(("u8SCOConnectionStatus::FC_PHONE_DBUS_SCO_CONN_ESTABLISHED "));
      if(m_poCallInstance)
      {
         //setting vehicle auido to true
         m_poCallInstance->m_bUsingVehicleAudio = TRUE;
         ETG_TRACE_USR3(("In side vprocess audio UsingVehicleAudio = TRUE  "));
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO, m_poCallInstance);
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, m_poCallInstance);
      }
      if(m_poCallInstance2)
      {
         //setting vehicle auido to true
         m_poCallInstance2->m_bUsingVehicleAudio = TRUE;
         ETG_TRACE_USR3(("UsingVehicleAudio = TRUE  "));
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO, m_poCallInstance2);
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, m_poCallInstance2);
      }
   }


   /*HfSetUpAudio Signal is triggered when call becomes alerting for Nexus */

   /* GMMY17-10316
    * HfSetUpAudio should also be handled in the states:
    * FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE1 and
    * FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE2
    */
   if((m_u16State == FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET) ||
         (m_u16State == FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE1) ||
         (m_u16State == FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE2) ||
         (m_u16State == FC_PHONE_SMTRANSFERCALL_STATE_WAIT_FOR_SWAPDBUSACK_AND_CALLSTATUS))
   {
      ETG_TRACE_USR4(("  fc_phone_tclSMTransferCallHandSetHandsFree::u8SCOConnectionStatus: = %d ",u8SCOConnectionStatus));
      if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_ESTABLISHED)
      {
         if((m_poCallInstance) && (m_poCallInstance2))
         {

            ETG_TRACE_USR4((" fc_phone_tclSMTransferCallHandSetHandsFree:: FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIOREQUEST_CALLINSTANCE1"));
            m_u16State_while_TransferAudio = FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIOREQUEST_CALLINSTANCE1_FOR_TRANSFERAUDIOREQ_FROMPHONE;
            if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED == m_poCallInstance->m_u8AudioChannel)
            {
               m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
               ETG_TRACE_USR3(("Requesting  audio....AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE "));
               m_poAudioManager->s32GetRequest(m_poCallInstance->m_u16Id,FC_PHONE_AUDIOCHANNEL_PHONE,vAudioCallBackTransferCall);
            }
            else
            {
               bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
            }
         }
         else if((m_poCallInstance) && (!m_poCallInstance2))
         {

            ETG_TRACE_USR4((" fc_phone_tclSMTransferCallHandSetHandsFree:: FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIOREQUEST_CALLINSTANCE1"));
            m_u16State_while_TransferAudio = FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIOREQUEST_CALLINSTANCE1_FOR_TRANSFERAUDIOREQ_FROMPHONE;
            if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED == m_poCallInstance->m_u8AudioChannel)
            {
               m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
               ETG_TRACE_USR3(("Requesting  audio....AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE "));
               m_poAudioManager->s32GetRequest(m_poCallInstance->m_u16Id,FC_PHONE_AUDIOCHANNEL_PHONE,vAudioCallBackTransferCall);
            }
            else
            {
               bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
            }
         }
         else if((!m_poCallInstance) && (m_poCallInstance2))
         {

            ETG_TRACE_USR4((" fc_phone_tclSMTransferCallHandSetHandsFree:: FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIOREQUEST_CALLINSTANCE2"));
            m_u16State_while_TransferAudio = FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIOREQUEST_CALLINSTANCE2_FOR_TRANSFERAUDIOREQ_FROMPHONE;
            if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED == m_poCallInstance2->m_u8AudioChannel)
            {
               m_poCallInstance2->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
               ETG_TRACE_USR3(("Requesting  audio....AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE "));
               m_poAudioManager->s32GetRequest(m_poCallInstance2->m_u16Id,FC_PHONE_AUDIOCHANNEL_PHONE,vAudioCallBackTransferCall);
            }
            else
            {
               bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
            }

         }
      }
      else if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_DISCONNECTED)
      {
         if((m_poCallInstance) && (m_poCallInstance2))
         {

            ETG_TRACE_USR4((" fc_phone_tclSMTransferCallHandSetHandsFree:: FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE1"));
            m_u16State_while_TransferAudio = FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE1_FOR_TRANSFERAUDIOREQ_FROMPHONE;
            if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_poCallInstance->m_u8AudioChannel)
            {
               ETG_TRACE_USR3(("Releasing audio...."));
               m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id,m_poCallInstance->m_u8AudioChannel,vAudioCallBackTransferCall);
               m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
            }
            else
            {
               bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
            }
         }
         else if((m_poCallInstance) && (!m_poCallInstance2))
         {
            ETG_TRACE_USR4((" fc_phone_tclSMTransferCallHandSetHandsFree:: FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE1"));
            m_u16State_while_TransferAudio = FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE1_FOR_TRANSFERAUDIOREQ_FROMPHONE;
            if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_poCallInstance->m_u8AudioChannel)
            {
               ETG_TRACE_USR3(("Releasing audio...."));
               m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id,m_poCallInstance->m_u8AudioChannel,vAudioCallBackTransferCall);
               m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
            }
            else
            {
               bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
            }
         }
         else if((!m_poCallInstance) && (m_poCallInstance2))
         {
            ETG_TRACE_USR4((" fc_phone_tclSMTransferCallHandSetHandsFree:: FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE2"));
            m_u16State_while_TransferAudio = FC_PHONE_SMTRANSFERCALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE2_FOR_TRANSFERAUDIOREQ_FROMPHONE;
            if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_poCallInstance2->m_u8AudioChannel)
            {
               ETG_TRACE_USR3(("Releasing audio...."));
               m_poAudioManager->s32ReleaseRequest(m_poCallInstance2->m_u16Id,m_poCallInstance2->m_u8AudioChannel,vAudioCallBackTransferCall);
               m_poCallInstance2->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
            }
            else
            {
               bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
            }
         }
      }
   }
}

   /*******************************************************************************
    *
    * FUNCTION: vTimeOutOnAudioTransfer
    *
    * DESCRIPTION:
    *
    * PARAMETER:
    *
    * RETURNVALUE: None.
    *
    ********************************************************************************/
   tVoid fc_phone_tclSMTransferCallHandSetHandsFree::vTimeOutOnAudioTransfer(tVoid)
   {
      /*Retry Audio Transfer till it return success*/
      ETG_TRACE_USR4(("Handle vTimeOutOnAudioTransfer"));
      if(m_poCallInstance)
      {
         (fc_phone_tclApp::m_poMainAppInstance)->m_poTimer->s32Stop(static_cast<tU16>(FC_PHONE_SMTRANSFERCALL_AUDIOTRANSFER_TIMER_ID+m_poCallInstance->m_u16Id));
      }
      else if(m_poCallInstance2)
      {
         (fc_phone_tclApp::m_poMainAppInstance)->m_poTimer->s32Stop(static_cast<tU16>(FC_PHONE_SMTRANSFERCALL_AUDIOTRANSFER_TIMER_ID+m_poCallInstance2->m_u16Id));
      }
      if(CallTransferState == FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSET)
      {
         ETG_TRACE_USR4(("Handle vTimeOutOnAudioTransfer: Call Transfer to Handset"));
         if((fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vGetAudioTransferStatus() == FC_PHONE_DBUS_SCO_CONN_ESTABLISHED)
         {
            if(m_poCallInstance)
            {
               m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId), FC_PHONE_CALLTRANSFER_FROMHANSFREE_TOHANDSET);
            }
            else if(m_poCallInstance2)
            {
               m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance2->m_u8BDAddressId), FC_PHONE_CALLTRANSFER_FROMHANSFREE_TOHANDSET);
            }
         }
         // GMMY15-813 Cannot switch call to handsfree from radio if incoming call answered from Bluetooth phone
         else if((fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vGetAudioTransferStatus() == FC_PHONE_DBUS_SCO_CONN_STATUS_UNKNOWN)
         {
            ETG_TRACE_USR4(("FC_PHONE_DBUS_SCO_CONN_STATUS_UNKNOWN. "));
            if(m_poCallInstance)
            {
               m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId), FC_PHONE_CALLTRANSFER_FROMHANSFREE_TOHANDSET);
            }
            else if(m_poCallInstance2)
            {
               m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance2->m_u8BDAddressId), FC_PHONE_CALLTRANSFER_FROMHANSFREE_TOHANDSET);
            }
         }
         else
         {
            bProcessEvent(FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK);
         }
      }
      else if(CallTransferState == FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSFREE)
      {
         ETG_TRACE_USR4(("Handle vTimeOutOnAudioTransfer: Call Transfer to Handsfree"));
         if((fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vGetAudioTransferStatus() == FC_PHONE_DBUS_SCO_CONN_DISCONNECTED)
         {
            if(m_poCallInstance)
            {
               m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId), FC_PHONE_CALLTRANSFER_FROMHANDSET_TOHANSFREE);
            }
            else if(m_poCallInstance2)
            {
               m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance2->m_u8BDAddressId), FC_PHONE_CALLTRANSFER_FROMHANDSET_TOHANSFREE);
            }
         }
         // GMMY15-813 Cannot switch call to handsfree from radio if incoming call answered from Bluetooth phone
         else if((fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vGetAudioTransferStatus() == FC_PHONE_DBUS_SCO_CONN_STATUS_UNKNOWN)
         {
            ETG_TRACE_USR4(("FC_PHONE_DBUS_SCO_CONN_STATUS_UNKNOWN. "));
            if(m_poCallInstance)
            {
               m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId), FC_PHONE_CALLTRANSFER_FROMHANDSET_TOHANSFREE);
            }
            else if(m_poCallInstance2)
            {
               m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance2->m_u8BDAddressId), FC_PHONE_CALLTRANSFER_FROMHANDSET_TOHANSFREE);
            }
         }
         else
         {
            bProcessEvent(FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK);
         }
      }

   }

   /*******************************************************************************
    *
    * FUNCTION: vHangUpCall
    *
    * DESCRIPTION:
    *
    * PARAMETER:
    *
    * RETURNVALUE: None.
    *
    ********************************************************************************/
   tVoid fc_phone_tclSMTransferCallHandSetHandsFree::vHangUpCall()
   {
      ETG_TRACE_USR4((" fc_phone_tclSMHangUpCall::vHangUpCall"));

      if (m_poCallInstance)
      {
         if (m_releaseCallInstanceID == m_poCallInstance->m_u16Id)
         {
            m_pReleaseCallInstance = m_poCallInstance;
         }
      }
      if (m_poCallInstance2)
      {
         if (m_releaseCallInstanceID == m_poCallInstance2->m_u16Id)
         {
            m_pReleaseCallInstance = m_poCallInstance2;
         }
      }


      FCPhoneDbusClient_TerminateType_t enTerminateType = FC_PHONE_DBUS_TERMINATETYPE_SINGLECALL;
      if((fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->bIsAgThreeWayCallSupported())
      {
      if (fc_phone_tclCallManager::m_u16Count > 1)
      {
         if (m_pReleaseCallInstance)
         {
            if (FC_PHONE_CALLINSTANCE_CALLSTATUS_ACTIVE ==  m_pReleaseCallInstance->m_u16CallStatusNotice)
            {
               ETG_TRACE_USR4(("Terminate active call"));
               enTerminateType = FC_PHONE_DBUS_TERMINATETYPE_MULTIPLECALL_ACTIVE;
            }

            if (FC_PHONE_CALLINSTANCE_CALLSTATUS_ONHOLD ==  m_pReleaseCallInstance->m_u16CallStatusNotice)
            {
               ETG_TRACE_USR4(("Terminate held call"));
               enTerminateType = FC_PHONE_DBUS_TERMINATETYPE_MULTIPLECALL_INACTIVE;
               }
            }
         }
      }

      if (m_pReleaseCallInstance)
      {
         ETG_TRACE_USR4((" enTerminateType :; %d",enTerminateType));
         m_pDbusIf->bHangUpCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_pReleaseCallInstance->m_u8BDAddressId),enTerminateType);
         m_bEventConsumed = TRUE ;
         m_bHangUpMethodStart = TRUE;
      }
   }
   /*******************************************************************************
    *
    * FUNCTION: vAssignErrorCode
    *
    * DESCRIPTION:
    *
    * PARAMETER:
    *
    * RETURNVALUE: None.
    *
    ********************************************************************************/
   tVoid fc_phone_tclSMTransferCallHandSetHandsFree::vAssignErrorCode(tChar Code)
   {
      ETG_TRACE_USR4((" fc_phone_tclSMTransferCallHandSetHandsFree::vAssignErrorCode "));
      switch(Code)
      {
         case FC_PHONE_DBUS_ERRORCODE_STATE_ERROR:
         {
            if(m_poCallInstance)
               m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACK_STATE_ERROR;
            if(m_poCallInstance2)
               m_poCallInstance2->m_AckError = FC_PHONE_CALLINSTANCE_ACK_STATE_ERROR;
         }
         break;
         case FC_PHONE_DBUS_ERRORCODE_OPERATION_NOT_ALLOWED:
         case FC_PHONE_DBUS_ERRORCODE_OPERATION_NOT_SUPPORTED:
         {
            if(m_poCallInstance)
               m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOTAVAILABLE;
            if(m_poCallInstance2)
               m_poCallInstance2->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOTAVAILABLE;
         }
         break;
         //Fix GMMY15-661
         case FC_PHONE_ALLOCATE_ACK_NO_AUDIO_CHANNEL:
         {
            ETG_TRACE_USR4(("      FC_PHONE_ALLOCATE_ACK_NO_AUDIO_CHANNEL" ));
            if(m_poCallInstance)
               m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACK_NO_AUDIO_CHANNEL;
            if(m_poCallInstance2)
               m_poCallInstance2->m_AckError = FC_PHONE_CALLINSTANCE_ACK_NO_AUDIO_CHANNEL;
         }
         break;
         //End of fix GMMY15-661
         default:
         {
            ETG_TRACE_USR4(("      IN DEFAULT This Error Code [0x%x] is not supported yet",Code) );
            if(m_poCallInstance)
               m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
            if(m_poCallInstance2)
               m_poCallInstance2->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
         }
         break;
      }
   }

   /*******************************************************************************
    *
    * FUNCTION: u16GetSMID
    *
    * DESCRIPTION:
    *
    * PARAMETER:
    *
    * RETURNVALUE: None.
    *
    ********************************************************************************/
   tU16 fc_phone_tclSMTransferCallHandSetHandsFree::u16GetSMID()
   {
      ETG_TRACE_USR4((" fc_phone_tclSMTransferCallHandSetHandsFree::u16GetSMID "));
      return m_u16SMID;
   }

   /*******************************************************************************
    *
    * FUNCTION: vSetDtmfLength
    *
    * DESCRIPTION:
    *
    * PARAMETER:
    *
    * RETURNVALUE: None.
    *
    ********************************************************************************/
   tVoid fc_phone_tclSMTransferCallHandSetHandsFree::vSetDtmfLength(tU16 u16DtmfLength)
   {
      ETG_TRACE_USR4((" fc_phone_tclSMTransferCallHandSetHandsFree::vSetDtmfLength "));
      m_u16DTMFCharLength = u16DtmfLength;
   }

/*******************************************************************************
 * FUNCTION: vTerminateOutgoingCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMTransferCallHandSetHandsFree::vTerminateOutgoingCall()
{
   ETG_TRACE_USR4(("Entering fc_phone_tclSMTransferCallHandSetHandsFree::vTerminateOutgoingCall "));

   //JAC2-4389. The correct call instance should be considered for terminating the outgoing call.
   if (m_poCallInstance)
   {
      if (m_releaseCallInstanceID == m_poCallInstance->m_u16Id)
      {
         m_pReleaseCallInstance = m_poCallInstance;
      }
   }
   if (m_poCallInstance2)
   {
      if (m_releaseCallInstanceID == m_poCallInstance2->m_u16Id)
      {
         m_pReleaseCallInstance = m_poCallInstance2;
      }
   }

   FCPhoneDbusClient_TerminateType_t enTerminateType = FC_PHONE_DBUS_TERMINATETYPE_SINGLECALL;
   tU16 u16SMCount = 0;

   // gmmy15-8470- when cancel outgoing event is received after posting dial for second call and callstatus for second call not received.
   for(tU16 indx=0; indx< FC_PHONE_SMMANAGER_MAX_SM_SUPPORTED; indx++)
   {

      if(m_poSMManager)
      {
         ETG_TRACE_USR4(("Checking the call object state of current call instance"));
         if(FC_PHONE_CALLINSTANCE_OBJECTSTATE_ACTIVE == m_poSMManager->u8GetCallObjectState(indx))
         {
            ETG_TRACE_USR4((" FC_PHONE_CALLINSTANCE_OBJECTSTATE_ACTIVE "));
            u16SMCount++;
         }
      }
   }
   ETG_TRACE_USR3(("SMCount is:  %d",u16SMCount));

   //JAC2-4389. The code has been optimized.
   if(m_pReleaseCallInstance)
   {
      if (fc_phone_tclCallManager::m_u16Count > 1 || u16SMCount >1)
      {
         ETG_TRACE_USR4(("Terminating ACTIVE(Outgoing) Call"));
         m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_WAIT_FOR_DISCONNECT_FROM_BT ;
         ETG_TRACE_USR2((" State Change:FC_PHONE_SMTRANSFERCALL_STATE_WAIT_FOR_DISCONNECT_FROM_BT "));
#ifndef BLUETOOTH_DISABLE_ENHANCED_CALL_CTRL // Disabled enhanced call control in BT_Stack
         //GMMY15-9890 To cancel the second outgoing call using HfReleaseSpecCall when ENDTARGETCALL is supported by the device
         if(((fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->getAgThreeWayCallSuppFeatures()) & FC_PHONE_ENHANCECALLCTRL_ENDTARGETCALL_MASK)
         {
            tU16 u16DbusCallInstance ;
            u16DbusCallInstance = m_pReleaseCallInstance->m_u16Id+1;
            ETG_TRACE_USR2(("u16DbusCallInstance %d",u16DbusCallInstance));
            enTerminateType = FC_PHONE_DBUS_TERMINATETYPE_THREEWAYCALL_SPECIFIC_CANCEL_OUTGOING;
            ETG_TRACE_USR4((" enTerminateType :; %d",enTerminateType));
            m_pDbusIf->bReleaseSpecCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_pReleaseCallInstance->m_u8BDAddressId), enTerminateType, (const unsigned char)u16DbusCallInstance);
         }
         else
#endif // Disabled enhanced call control in BT_Stack
         {
            if((fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->bIsAgThreeWayCallSupported())
            {
               enTerminateType = FC_PHONE_DBUS_TERMINATETYPE_MULTIPLECALL_ACTIVE ;
               ETG_TRACE_USR4((" enTerminateType :; %d",enTerminateType));
            }
            m_pDbusIf->bTerminateCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_pReleaseCallInstance->m_u8BDAddressId), enTerminateType);
         }
      }
      /*Ending a single call*/
      else if ((fc_phone_tclCallManager::m_u16Count <= 1) && (m_pReleaseCallInstance->m_u16CallStatusNotice == FC_PHONE_CALLINSTANCE_CALLSTATUS_DIALING))
      {
         m_u16State =  FC_PHONE_SMTRANSFERCALL_STATE_WAIT_FOR_DISCONNECT_FROM_BT ;
         ETG_TRACE_USR2(("State Change:FC_PHONE_SMTRANSFERCALL_STATE_WAIT_FOR_DISCONNECT_FROM_BT"));
         ETG_TRACE_USR4(("Terminating Single Call"));
         m_pDbusIf->bTerminateCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_pReleaseCallInstance->m_u8BDAddressId), enTerminateType);
      }
      else
      {
         ETG_TRACE_ERR(("Call Count doesn't Match"));
      }
   }
   else
   {
      ETG_TRACE_ERR(("Call Instance  is NULL"));
   }
   m_releaseCallInstanceID = 0;
}

/*******************************************************************************
 *
 * FUNCTION: vHandleEventInCancelOutgoingBTInCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMTransferCallHandSetHandsFree::vHandleEventInTerminateBTInCall(tU16 u16EventId)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMTransferCallHandSetHandsFree::vHandleEventInTerminateBTInCall %d",u16EventId));
   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_DBUS_TERMINATE_ACK_OK:
      {
         ETG_TRACE_USR3(("  EVENT : OR FC_PHONE_SM_EVENT_DBUS_TERMINATE_ACK_OK"));
         //to stop timer if active
         if(m_poCallInstance)
         {
            //JAC2-4389. On successful acknowledgement of terminatting the Outgoing call, the state should be changed accordingly.
            if((fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vGetVehicleAudioStatus() == TRUE)
            {
               m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_CALLTRANSFERRED_TOHANDSFREE;
               ETG_TRACE_USR2(("  State change::FC_PHONE_SMTRANSFERCALL_STATE_CALLTRANSFERRED_TOHANDSFREE "));
            }
            else
            {
               m_u16State = FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET;
               ETG_TRACE_USR2(("  State change::FC_PHONE_SMTRANSFERCALL_STATE_ROUTINGCALLIN_HANDSET "));
            }
            //send method result
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_CANCELOUTGOINGCALL,\
                  m_poCallInstance);
         }
         else
         {
            ETG_TRACE_ERR(("Call Instance  is NULL"));
         }
      }
      break;
      default:
      {
         ETG_TRACE_ERR(("  ERROR : vHandleEventInTerminateBTInCall:: DEFAULT  u16EventId %d",u16EventId));
      }
      break;
   }
}
