/******************************************************************************
 *
 * FILE:          FC_Phone_SMManager.cpp
 *
 * SW-COMPONENT:  FC_Phone application
 *
 * PROJECT:
 *
 * DESCRIPTION:   CCA service Telephone.
 *
 * AUTHOR:
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

#include "FC_Phone_SMIncludes.h"
#include "../HelperClasses/FC_Phone_CallManager.h"
#include "../FC_Phone_service_Telephone.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_PHONE_STATEMACHINE
#include "trcGenProj/Header/FC_Phone_SMManager.cpp.trc.h"
#endif


/* Local defines, define here */

fc_phone_tclSM* fc_phone_tclSMManager::m_SMTable[FC_PHONE_SMMANAGER_MAX_SM_SUPPORTED];


/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMManager
 *
 * DESCRIPTION:Constructor
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ***************************************************************************/
fc_phone_tclSMManager::fc_phone_tclSMManager(fc_phone_tclSMObserver*& rfpSMObserver)
{
   ETG_TRACE_USR4((" fc_phone_tclSMManager::fc_phone_tclSMManager "));
   m_poObserver = rfpSMObserver;

   for(tU16 indx=0; indx< FC_PHONE_SMMANAGER_MAX_SM_SUPPORTED ;indx++)
   {
      m_SMTable[indx] = NULLPTR ;
   }
   for(tU16 indx=0; indx< FC_PHONE_SMMANAGER_MAX_SM_TODELETE ;indx++)
   {
      m_apSMToBeDeleted[indx] = NULLPTR ;
   }

}
/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMManager
 *
 * DESCRIPTION:destructor
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ***************************************************************************/
fc_phone_tclSMManager::~fc_phone_tclSMManager()
{
   ETG_TRACE_USR4((" fc_phone_tclSMManager::~fc_phone_tclSMManager "));
   m_poObserver = NULLPTR;
}
/*******************************************************************************
 *
 * FUNCTION: GetSMIndex_FromCallInstanceID
 *
 * DESCRIPTION: Get StateMachine Valid Index instance from call instance ID
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tS16 fc_phone_tclSMManager::GetSMIndex_FromCallInstanceID(tU16 u16_callInstanceID)
{
   ETG_TRACE_USR4(("fc_phone_tclSMManager::GetSMIndex_FromCallInstanceID CallInstanceID: %d", u16_callInstanceID));
   
   tS16 indx = 0;
   
   for(indx = 0; indx < FC_PHONE_SMMANAGER_MAX_SM_SUPPORTED; indx++)
   {
      if(m_SMTable[indx])
      {
         if(m_SMTable[indx]->m_poCallInstance)
         {
            if(m_SMTable[indx]->m_poCallInstance->m_u16Id == u16_callInstanceID)
            {
               ETG_TRACE_USR4(("indx = %d Returning Index of CallInstance %d ",indx,m_SMTable[indx]->m_poCallInstance->m_u16Id));
               return indx ;
            }
         }
         if(m_SMTable[indx]->m_poCallInstance2)
         {
            if(m_SMTable[indx]->m_poCallInstance2->m_u16Id == u16_callInstanceID)
            {
               ETG_TRACE_USR4(("indx = %d Returning Index of CallInstance %d ",indx,m_SMTable[indx]->m_poCallInstance2->m_u16Id));
               return indx;
            }
         }
      }
      else
      {
         ETG_TRACE_USR4(("m_SMTable[indx] is NULL "));
      }
   }
   return INVALID_INDEX;
}


/*******************************************************************************
 *
 * FUNCTION: GetSM_FromCallInstanceID
 *
 * DESCRIPTION: Get StateMachine instance from call instance
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
fc_phone_tclSM* fc_phone_tclSMManager::GetSM_FromCallInstanceID(tU16 u16_callInstanceID)
{
   tU16 indx;
   ETG_TRACE_USR4((" fc_phone_tclSMManager::GetSM_FromCallInstanceID %d  ",u16_callInstanceID));
   for(indx=0; indx< FC_PHONE_SMMANAGER_MAX_SM_SUPPORTED ;indx++)
   {
      if(m_SMTable[indx])
      {
         if(m_SMTable[indx]->m_poCallInstance)
         {
            if(m_SMTable[indx]->m_poCallInstance->m_u16Id == u16_callInstanceID)
            {
               ETG_TRACE_USR4(("Returing SMinstance of CallInstance %d ",m_SMTable[indx]->m_poCallInstance->m_u16Id));
               return m_SMTable[indx] ;
            }
         }
         if(m_SMTable[indx]->m_poCallInstance2)
         {
            if(m_SMTable[indx]->m_poCallInstance2->m_u16Id == u16_callInstanceID)
            {
               ETG_TRACE_USR4(("Returing SMinstance of CallInstance %d ",m_SMTable[indx]->m_poCallInstance2->m_u16Id));
               return m_SMTable[indx] ;
            }
         }
      }
      else
      {
         ETG_TRACE_USR4(("m_SMTable[indx] is NULL "));
      }
   }
   return NULLPTR ;
}


/*******************************************************************************
 *
 * FUNCTION: GetSM_FromTimerID
 *
 * DESCRIPTION: Get StateMachine instance from call instance
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
fc_phone_tclSM* fc_phone_tclSMManager::GetSM_FromTimerID(tU16 u16_TimerID)
{
   tU16 indx;

   ETG_TRACE_USR4(("fc_phone_tclSMManager::GetSM_FromTimerID InPut u16_TimerID %d ",u16_TimerID));
   for(indx=0; indx< FC_PHONE_SMMANAGER_MAX_SM_SUPPORTED ;indx++)
   {
      if(m_SMTable[indx])
      {
         if(m_SMTable[indx]->m_poCallInstance)
         {
            if((m_SMTable[indx]->m_poCallInstance->m_u16Id == u16_TimerID)
                  ||(m_SMTable[indx]->m_poCallInstance->m_u16Id == (u16_TimerID-FC_PHONE_SMACH_ALERT_TIMER_ID))
                  || (m_SMTable[indx]->m_poCallInstance->m_u16Id == (u16_TimerID-FC_PHONE_SMACH_AUDIOTRANSFER_TIMER_ID))
                  || (m_SMTable[indx]->m_poCallInstance->m_u16Id == (u16_TimerID-FC_PHONE_SMTRANSFERCALL_AUDIOTRANSFER_TIMER_ID))
                  || (m_SMTable[indx]->m_poCallInstance->m_u16Id == (u16_TimerID-FC_PHONE_TERMINATECALLRETRY_TIMER_ID))
                  || (m_SMTable[indx]->m_poCallInstance->m_u16Id == (u16_TimerID-FC_PHONE_DIAL_CALLSTATUS_FAILURE_TIMER_ID))

            )
            {
               ETG_TRACE_USR4((" Returing SMinstance of CallInstance %d ",m_SMTable[indx]->m_poCallInstance->m_u16Id));
               return m_SMTable[indx] ;
            }
         }
         if(m_SMTable[indx]->m_poCallInstance2)
         {
            if((m_SMTable[indx]->m_poCallInstance2->m_u16Id == u16_TimerID)
                  ||(m_SMTable[indx]->m_poCallInstance2->m_u16Id == (u16_TimerID-FC_PHONE_SMACH_ALERT_TIMER_ID))
                  || (m_SMTable[indx]->m_poCallInstance2->m_u16Id == (u16_TimerID-FC_PHONE_SMACH_AUDIOTRANSFER_TIMER_ID)) //Timer for AudioTransfer
                  || (m_SMTable[indx]->m_poCallInstance2->m_u16Id == (u16_TimerID-FC_PHONE_SMTRANSFERCALL_AUDIOTRANSFER_TIMER_ID)) //Timer for AudioTransfer
                  || (m_SMTable[indx]->m_poCallInstance->m_u16Id == (u16_TimerID-FC_PHONE_TERMINATECALLRETRY_TIMER_ID))
                  || (m_SMTable[indx]->m_poCallInstance->m_u16Id == (u16_TimerID-FC_PHONE_DIAL_CALLSTATUS_FAILURE_TIMER_ID))
            )
            {
               ETG_TRACE_USR4((" Returing SMinstance of CallInstance %d ",m_SMTable[indx]->m_poCallInstance2->m_u16Id));
               return m_SMTable[indx] ;
            }
         }
      }
      else
      {
         ETG_TRACE_USR4((" m_SMTable[indx] is NULL "));
      }
   }
   return NULLPTR ;
}

/*******************************************************************************
 *
 * FUNCTION: GetSM_FromAudioRequestorId
 *
 * DESCRIPTION: Get StateMachine instance from 6AudioReqID
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
fc_phone_tclSM* fc_phone_tclSMManager::GetSM_FromAudioRequestorId(tU16 u16AudioReqID)
{
   tU16 indx;
   ETG_TRACE_USR4(("fc_phone_tclSMManager::GetSM_FromAudioRequestorId: InPut u16AudioReqID %d ",u16AudioReqID));
   for(indx=0; indx< FC_PHONE_SMMANAGER_MAX_SM_SUPPORTED ;indx++)
   {
      if(m_SMTable[indx])
      {
         if(m_SMTable[indx]->m_poCallInstance)
         {
            if(m_SMTable[indx]->m_poCallInstance->m_u16Id == u16AudioReqID)
            {
               ETG_TRACE_USR4(("Returing SMinstance of CallInstance %d ",m_SMTable[indx]->m_poCallInstance->m_u16Id));
               return m_SMTable[indx] ;
            }
         }
         if(m_SMTable[indx]->m_poCallInstance2)
         {
            if(m_SMTable[indx]->m_poCallInstance2->m_u16Id == u16AudioReqID)
            {
               ETG_TRACE_USR4(("Returing SMinstance of CallInstance %d ",m_SMTable[indx]->m_poCallInstance2->m_u16Id));
               return m_SMTable[indx] ;
            }
         }
      }
      else
      {
         ETG_TRACE_USR4(("m_SMTable[indx] is NULL "));
      }
   }
   return NULLPTR ;
}

/*******************************************************************************
 *
 * FUNCTION: vRevertStateMachine
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMManager::vRevertStateMachine(fc_phone_tclCallInstance *rfpCallInstance[])
{
   ETG_TRACE_USR4(("fc_phone_tclSMManager::vRevertStateMachine "));
   tS16 SMIndex = 0;
   tU16 u16StateMachineId = 0;
   fc_phone_tclSM* StateMachineToDelete = NULLPTR;
   fc_phone_tclSM* m_poCurrentStateMachine = NULLPTR;

   fc_phone_tclCallInstance *pCallInstance[FC_PHONE_MAX_CALLINSTANCES];

   pCallInstance[0] = rfpCallInstance[0];
   pCallInstance[1] = rfpCallInstance[1];

   for(tU8 i = 0; i < FC_PHONE_MAX_CALLINSTANCES; i++)
   {
      if(pCallInstance[i])
      {
         StateMachineToDelete = GetSM_FromCallInstanceID(pCallInstance[i]->m_u16Id);
         SMIndex = GetSMIndex_FromCallInstanceID(pCallInstance[i]->m_u16Id);
         if(StateMachineToDelete)
         {
            if(StateMachineToDelete->m_poCallInstance)
            {
               ETG_TRACE_USR2(("cancel statemachine : %d",StateMachineToDelete->m_poCallInstance->m_u16Id));
            }
            if(StateMachineToDelete->m_poCallInstance2)
            {

               ETG_TRACE_USR2(("cancel statemachine : %d",StateMachineToDelete->m_poCallInstance2->m_u16Id));
            }
            /* Cancel the previous StateMachine */
            //ActiveStateMachine1->vCancel(); //Commented out because it cancels the timer count
            /* Delete the previous state machine object */
            //    			m_SMTable[ActiveStateMachine->m_poCallInstance->m_u16Id] = NULL;
            //    			StateMachineToDelete = OSAL_NULL;
            vAddSMToDelete(StateMachineToDelete);
            if(SMIndex != INVALID_INDEX)
            {
               //Making Null in SM table for 1 or 2 call instances
               m_SMTable[SMIndex] = NULLPTR;
            }
         }
         if(i == 0) //In order to skip checking for 3rd call instance in 2nd condition . Revert to conference call state machine
         {
            if((pCallInstance[i]) && (pCallInstance[i+1]))
            {
               if(((pCallInstance[i]->m_u16CallStatusNotice == FC_PHONE_CALLINSTANCE_CALLSTATUS_ACTIVE) && (pCallInstance[i+1]->m_u16CallStatusNotice == FC_PHONE_CALLINSTANCE_CALLSTATUS_ACTIVE))\
                     || ((pCallInstance[i]->m_u16CallStatusNotice == FC_PHONE_CALLINSTANCE_CALLSTATUS_CONFERENCE) && (pCallInstance[i+1]->m_u16CallStatusNotice == FC_PHONE_CALLINSTANCE_CALLSTATUS_CONFERENCE)))
               {
                  u16StateMachineId = FC_PHONE_SMMANAGER_SMID_CONFERENCECALL;
                  vCreate(u16StateMachineId,pCallInstance, NULLPTR);
                  for(tU8 j = 0; j < FC_PHONE_MAX_CALLINSTANCES; j++)
                  {
                     if(pCallInstance[i])
                     {
                        m_poCurrentStateMachine = GetSM_FromCallInstanceID(pCallInstance[i]->m_u16Id);
                        break;
                     }
                  }
                  if(m_poCurrentStateMachine)
                  {
                     ETG_TRACE_USR4(("EXECUTE Conference Call state Machine.......  "));
                     m_poCurrentStateMachine->vRestore();
                     break;
                  }
               }
            }
         }
         if(pCallInstance[i]->m_u8CallDirection == PHONE_CALLDIRECTION_INCOMING)
         {
            ETG_TRACE_USR4(("pCallInstance[i]->m_u8CallDirection = %d",pCallInstance[i]->m_u8CallDirection));
            u16StateMachineId = FC_PHONE_SMMANAGER_SMID_ACCEPTCALL;
         }
         else if(pCallInstance[i]->m_u8CallDirection == PHONE_CALLDIRECTION_OUTGOING)
         {
            ETG_TRACE_USR4(("pCallInstance[i]->m_u8CallDirection = %d",pCallInstance[i]->m_u8CallDirection));
            u16StateMachineId = FC_PHONE_SMMANAGER_SMID_DIAL;
         }
         else
         {
            ETG_TRACE_USR4(("pCallInstance[i]->m_u8CallDirection = %d",pCallInstance[i]->m_u8CallDirection));
            u16StateMachineId = FC_PHONE_SMMANAGER_SMID_IDLE;
         }
         vCreate(u16StateMachineId,pCallInstance[i], NULLPTR);
         m_poCurrentStateMachine = GetSM_FromCallInstanceID(pCallInstance[i]->m_u16Id);
         if(m_poCurrentStateMachine)
         {
            ETG_TRACE_USR4(("EXECUTE.......  "));
            m_poCurrentStateMachine->vRestore();
         }
      }
   }
}

/*******************************************************************************
 *
 * FUNCTION: vStartSM
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMManager::vStartSM(tU16 u16StateMachineId, fc_phone_tclCallInstance*& rfpCallInstance,tVoid *varg )
{
   ETG_TRACE_USR4((" fc_phone_tclSMManager::vStartSM_withArg  u16StateMachineId %d", u16StateMachineId));
   tS16 SMIndex = 0;
   fc_phone_tclSM* m_poCurrentStateMachine = NULLPTR;
   fc_phone_tclSM* m_poStateMachineToDelete = NULLPTR;
   fc_phone_tclCallInstance *pCallInstance;

   pCallInstance = rfpCallInstance;
   m_poStateMachineToDelete = GetSM_FromCallInstanceID(pCallInstance->m_u16Id);
   SMIndex = GetSMIndex_FromCallInstanceID(pCallInstance->m_u16Id);
   if(m_poStateMachineToDelete)
   {
      m_poStateMachineToDelete->vCancel();
      vAddSMToDelete(m_poStateMachineToDelete);
      if(SMIndex != INVALID_INDEX)
      {
         //Making Null in SM table for 1 or 2 call instances
         m_SMTable[SMIndex] = NULLPTR;
      }
   }

   /* Create and keep new state machine */
   vCreate(u16StateMachineId,pCallInstance,varg);

   /* Start the new State Machine */
   ETG_TRACE_USR4(("GetSM_FromCallInstanceID for EXECUTE "));
   m_poCurrentStateMachine = GetSM_FromCallInstanceID(pCallInstance->m_u16Id);
   if(m_poCurrentStateMachine)
   {
      ETG_TRACE_USR4(("EXECUTE.......  "));
      m_poCurrentStateMachine->vExecute();
   }
   else
   {
      ETG_TRACE_USR4(("m_poCurrentStateMachine = NULL ,This line never should execute "));
   }
   vTryDeleteUnusedSM();
}


/*******************************************************************************
 *
 * FUNCTION: vStartSM
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMManager::vStartSM(tU16 u16StateMachineId, fc_phone_tclCallInstance*& rfpCallInstance)
{
   vStartSM(u16StateMachineId, rfpCallInstance, NULLPTR);
}


/*******************************************************************************
 *
 * FUNCTION: vStartTransferCallTSM
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMManager::vStartSM(tU16 u16StateMachineId, fc_phone_tclCallInstance *rfpCallInstance[])
{
   vStartSM(u16StateMachineId, rfpCallInstance, NULLPTR);
}


/*******************************************************************************
 *
 * FUNCTION: vStartSM
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMManager::vStartSM(tU16 u16StateMachineId, fc_phone_tclCallInstance *rfpCallInstance[], tVoid *varg)
{
   ETG_TRACE_USR4(("fc_phone_tclSMManager::vStartSM With Two Callinstance With Args  u16StateMachineId %d", u16StateMachineId));
   fc_phone_tclCallInstance *pCallInstance[FC_PHONE_MAX_CALLINSTANCES];
   fc_phone_tclSM* m_poCurrentStateMachine = NULLPTR;
   fc_phone_tclSM* m_poStateMachineToDelete = NULLPTR;

   tS16 SMIndex = 0;

   pCallInstance[0] = rfpCallInstance[0];
   pCallInstance[1] = rfpCallInstance[1];
   for(tU8 i = 0; i < FC_PHONE_MAX_CALLINSTANCES; i++)
   {
      ETG_TRACE_USR2((" vStartSM: i = %d", i));
      if(pCallInstance[i])
      {
         ETG_TRACE_USR3((" vStartSM: GetSM_FromCallInstanceID for %d ", i));
         m_poStateMachineToDelete = GetSM_FromCallInstanceID(pCallInstance[i]->m_u16Id);
         SMIndex = GetSMIndex_FromCallInstanceID(pCallInstance[i]->m_u16Id);
         if(m_poStateMachineToDelete)
         {
            if(m_poStateMachineToDelete->m_poCallInstance)
            {
               ETG_TRACE_USR2(("cancel statemachine : %d",m_poStateMachineToDelete->m_poCallInstance->m_u16Id));
            }

            if(m_poStateMachineToDelete->m_poCallInstance2)
            {
               ETG_TRACE_USR4(("cancel statemachine : %d",m_poStateMachineToDelete->m_poCallInstance2->m_u16Id));
            }

            vAddSMToDelete(m_poStateMachineToDelete);
            if(SMIndex != INVALID_INDEX)
            {
               //Making Null in SM table for 1 or 2 call instances
               m_SMTable[SMIndex] = NULLPTR;
            }
         }
      }
   }

   /* Create and keep new state machine */
   vCreate(u16StateMachineId, pCallInstance, varg);

   for (tU8 i = 0; i < FC_PHONE_MAX_CALLINSTANCES; i++)
   {
      if (pCallInstance[i])
      {
         m_poCurrentStateMachine = GetSM_FromCallInstanceID(pCallInstance[i]->m_u16Id);
         break;
      }
   }

   if (m_poCurrentStateMachine)
   {
      ETG_TRACE_USR4(("EXECUTE.......  "));
      m_poCurrentStateMachine->vExecute();
   }

   vTryDeleteUnusedSM();
}


/*******************************************************************************
 *
 * FUNCTION: vProcessEvent
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMManager::vProcessEvent(tU16 u16EventId,tU16 u16EventType,tVoid *varg)
{

   /* Delegate it to Current State Machine */
   ETG_TRACE_USR4(("fc_phone_tclSMManager::vProcessEvent EventId %d", u16EventId));
   tU16 indx;

   if(FC_PHONE_EVENTTYPE_BROADCAST == u16EventType)
   {
      ETG_TRACE_USR4(("BroadCasting vProcessEvent to all listed SMs"));

      for(indx=0; indx< FC_PHONE_SMMANAGER_MAX_SM_SUPPORTED ;indx++)
      {
         if(m_SMTable[indx])
         {
            m_SMTable[indx]->bProcessAllEvents(u16EventId,varg) ;
         }
         else
         {
            ETG_TRACE_USR4(("m_SMTableindx = %d is NULL",indx));
         }
      }
   }
   else if(FC_PHONE_EVENTTYPE_BROADCAST_CONSUMED == u16EventType)
   {
      ETG_TRACE_USR4(("BroadCasting vProcessEvent to all listed SMs for CONSUMED EVENT TYPE"));

      tS32 s32RetValue ;
      for(indx = 0; indx < FC_PHONE_SMMANAGER_MAX_SM_SUPPORTED ;indx++)
      {
         if(m_SMTable[indx])
         {
            s32RetValue = m_SMTable[indx]->bProcessAllEvents(u16EventId,varg) ;
            if(s32RetValue == TRUE && m_SMTable[indx]->m_poCallInstance)
            {
               ETG_TRACE_USR4(("Event Consumed by callinstance:: %d ",m_SMTable[indx]->m_poCallInstance->m_u16Id));
               break ;
            }
         }
         else
         {
            ETG_TRACE_USR4(("m_SMTableindx = %d is NULL",indx));
         }
      }
   }
   else if(FC_PHONE_EVENTTYPE_TARGATED == u16EventType)
   {
      FcPhone_processEventArg   *ptProcessEventArg = (FcPhone_processEventArg*)varg;
      ETG_TRACE_USR4(("Processing EVENT to call Instance %d",ptProcessEventArg->u16CallInstanceID));
      //search for the corresponding call Instance In SM Table
      tU16 u16_SMPosition = FC_PHONE_SMMANAGER_CALLINSTANCEID_UNKNOWN ;
      for(indx=0; indx< FC_PHONE_SMMANAGER_MAX_SM_SUPPORTED ;indx++)
      {
         if(m_SMTable[indx])
         {
            if(m_SMTable[indx]->m_poCallInstance)
            {
               if(m_SMTable[indx]->m_poCallInstance->m_u16Id == ptProcessEventArg->u16CallInstanceID)
               {
                  u16_SMPosition = indx ;
                  break;
               }
            }

            if(m_SMTable[indx]->m_poCallInstance2)
            {
               if(m_SMTable[indx]->m_poCallInstance2->m_u16Id == ptProcessEventArg->u16CallInstanceID)
               {
                  u16_SMPosition = indx ;
                  break;
               }
            }
         }
      }
      if(FC_PHONE_SMMANAGER_CALLINSTANCEID_UNKNOWN != u16_SMPosition)
      {
         m_SMTable[u16_SMPosition]->bProcessAllEvents(u16EventId,varg) ;
      }
      else
      {
         ETG_TRACE_USR4(("DROPPED :: Could not process the EVENT for callInstance [%d] "
               "Because callInstance is not found in SM Table ",ptProcessEventArg->u16CallInstanceID));
      }
   }
   else
   {
      ETG_TRACE_ERR((" Error:: Wrong ProcessEvent  %d",u16EventType));
   }
   vTryDeleteUnusedSM();
}

/*******************************************************************************
 *
 * FUNCTION: bProcessEvent
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tBool fc_phone_tclSMManager::bProcessEvent(tU16 u16EventId,tU16 u16EventType,tVoid *varg)
{
   /* Delegate it to Current State Machine */
   ETG_TRACE_USR4(("fc_phone_tclSMManager::bProcessEvent  u16EventId %d", u16EventId));
   tBool bEventConsumed = FALSE;
   if(FC_PHONE_EVENTTYPE_BROADCAST == u16EventType)
   {
      ETG_TRACE_USR4(("BroadCasting bProcessEvent to all listed SMs"));

      for(tU16 indx=0; indx<FC_PHONE_SMMANAGER_MAX_SM_SUPPORTED ;indx++)
      {
         ETG_TRACE_USR4((" index  %d",indx));
         if(m_SMTable[indx])
         {
            bEventConsumed = (tBool) (bEventConsumed | m_SMTable[indx]->bProcessAllEvents(u16EventId,varg)) ;
         }
         else
         {
            ETG_TRACE_USR4(("m_SMTableindx = %d is NULL",indx));
         }
      }
   }
   else if(FC_PHONE_EVENTTYPE_BROADCAST_CONSUMED == u16EventType)
   {
      ETG_TRACE_USR4(("BroadCasting vProcessEvent to all listed SMs for CONSUMED EVENT TYPE"));

      tBool bRetValue ;
      for(tU16 indx = 0; indx < FC_PHONE_SMMANAGER_MAX_SM_SUPPORTED ;indx++)
      {
         if(m_SMTable[indx])
         {
            bRetValue = m_SMTable[indx]->bProcessAllEvents(u16EventId,varg) ;
            if(bRetValue == TRUE && m_SMTable[indx]->m_poCallInstance)
            {
               ETG_TRACE_USR4(("Event Consumed by callinstance:: %d ",m_SMTable[indx]->m_poCallInstance->m_u16Id));
               bEventConsumed = TRUE ;
               break ;
            }
         }
         else
         {
            ETG_TRACE_USR4(("m_SMTableindx = %d is NULL",indx));
         }
      }
   }
   else if(FC_PHONE_EVENTTYPE_TARGATED == u16EventType)
   {
      FcPhone_processEventArg   *ptProcessEventArg = (FcPhone_processEventArg*)varg;
      ETG_TRACE_USR4(("Processing EVENT to call Instance %d",ptProcessEventArg->u16CallInstanceID));
      //search for the corresponding call Instance In SM Table
      tU16 u16_SMPosition = FC_PHONE_SMMANAGER_CALLINSTANCEID_UNKNOWN ;
      for(tU16 indx=0; indx< FC_PHONE_SMMANAGER_MAX_SM_SUPPORTED ;indx++)
      {
         if(m_SMTable[indx])
         {
            if(m_SMTable[indx]->m_poCallInstance)
            {
               if(m_SMTable[indx]->m_poCallInstance->m_u16Id == ptProcessEventArg->u16CallInstanceID)
               {
                  u16_SMPosition = indx ;
                  break;
               }
            }

            if(m_SMTable[indx]->m_poCallInstance2)
            {
               if(m_SMTable[indx]->m_poCallInstance2->m_u16Id == ptProcessEventArg->u16CallInstanceID)
               {
                  u16_SMPosition = indx ;
                  break;
               }
            }
         }
      }
      if(FC_PHONE_SMMANAGER_CALLINSTANCEID_UNKNOWN != u16_SMPosition)
      {
         bEventConsumed = m_SMTable[u16_SMPosition]->bProcessAllEvents(u16EventId,varg) ;
      }
      else
      {
         ETG_TRACE_USR4(("DROPPED :: Could not process the EVENT for callInstance [%d] "
               "Because callInstance is not found in SM Table ",ptProcessEventArg->u16CallInstanceID));
      }
   }
   else
   {
      ETG_TRACE_ERR((" Error:: Wrong ProcessEvent  %d",u16EventType));
   }
   vTryDeleteUnusedSM();
   return bEventConsumed;

}

/*******************************************************************************
 *
 * FUNCTION: vProcessVREvent
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMManager::vProcessVREvent(tU16 u16EventId)
{
   ETG_TRACE_USR4((" ENTER : vProcessVREvent  u16EventId %d ", u16EventId));
   fc_phone_tclSMVRSession* poVRInstance = fc_phone_tclSMVRSession::poGetInstance();
   poVRInstance->vProcessEvent(u16EventId);
   ETG_TRACE_USR4((" EXIT : vProcessVREvent"));
}

/*******************************************************************************
 *
 * FUNCTION: vProcessExtVREvent
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMManager::vProcessExtVREvent(tU16 u16EventId)
{
   ETG_TRACE_USR4((" ENTER : vProcessExtVREvent  u16EventId %d ", u16EventId));
   fc_phone_tclSMExtVRSession* poExtVRInstance = fc_phone_tclSMExtVRSession::poGetInstance();
   poExtVRInstance->vProcessEvent(u16EventId);

   ETG_TRACE_USR4((" EXIT : vProcessExtVREvent"));
}

/*******************************************************************************
 *
 * FUNCTION: isExternalVRSessionActive
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tBool fc_phone_tclSMManager::bIsExternalVRSessionIdle()
{
   ETG_TRACE_USR4((" ENTER : bIsExternalVRSessionIdle "));
   tBool bIsIdle = false;
   fc_phone_tclSMExtVRSession* poExtVRInstance = fc_phone_tclSMExtVRSession::poGetInstance();
   bIsIdle = poExtVRInstance->isExtVRSessionIdle();
   return bIsIdle;
}
/*******************************************************************************
 *
 * FUNCTION: vProcessVREvent
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMManager::vProcessVREvent(tU16 u16EventId,tVoid *varg)
{
   ETG_TRACE_USR4((" ENTER : vProcessVREvent with arg  u16EventId %d ", u16EventId));
   fc_phone_tclSMVRSession* poVRInstance = fc_phone_tclSMVRSession::poGetInstance();
   if ( !poVRInstance->bProcessEvent(u16EventId, varg))
   {
      ETG_TRACE_USR3((" vProcessVREvent - Event not handled"));
   }
   ETG_TRACE_USR4((" EXIT : vProcessVREvent with arg"));
}

/*******************************************************************************
 *
 * FUNCTION: vSMFinished
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMManager::vSMFinished(tU16 u16CallInstanceId)
{
   ETG_TRACE_USR4(("fc_phone_tclSMManager::vSMFinished u16CallInstanceId %d",u16CallInstanceId));
   /* Delete the Current Command */
   tS16 SMIndex = 0;
   fc_phone_tclSM* m_poCurrentStateMachine = NULLPTR;
   fc_phone_tclSM* m_poStateMachineToDelete = NULLPTR;

   fc_phone_tclCallInstance* pTempCallInstance;
   m_poStateMachineToDelete = GetSM_FromCallInstanceID(u16CallInstanceId);
   SMIndex = GetSMIndex_FromCallInstanceID(u16CallInstanceId);


   if(m_poStateMachineToDelete)
   {
      if(m_poStateMachineToDelete->m_poCallInstance)
      {
         if(u16CallInstanceId == m_poStateMachineToDelete->m_poCallInstance->m_u16Id)
         {
            pTempCallInstance = m_poStateMachineToDelete->m_poCallInstance;
         }
      }

      else if(m_poStateMachineToDelete->m_poCallInstance2)
      {
         if(u16CallInstanceId == m_poStateMachineToDelete->m_poCallInstance2->m_u16Id)
         {
            pTempCallInstance = m_poStateMachineToDelete->m_poCallInstance2;
         }
      }
      vAddSMToDelete(m_poStateMachineToDelete);
      if(SMIndex != INVALID_INDEX)
      {
         //Making Null in SM table for 1 or 2 call instances
         m_SMTable[SMIndex] = NULLPTR;
      }
      vCreate(FC_PHONE_SMMANAGER_SMID_IDLE, pTempCallInstance, NULLPTR);
      /* Execute Idle StateMachine */
      m_poCurrentStateMachine = GetSM_FromCallInstanceID(u16CallInstanceId);
      if(m_poCurrentStateMachine)
      {
         ETG_TRACE_USR4(("EXECUTE.......  "));
         m_poCurrentStateMachine->vExecute();
      }
      else
      {
         ETG_TRACE_USR4(("m_poCurrentStateMachine = NULL ,This line never should execute "));
      }
   }
   vTryDeleteUnusedSM();
}

/*******************************************************************************
 *
 * FUNCTION: vSMStartIdle
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMManager::vSMStartIdleSM( fc_phone_tclCallInstance *rfpCallInstance)
{
   ETG_TRACE_USR4(("fc_phone_tclSMManager::vSMStartIdle "));
   /* Delete the Current Command */
   fc_phone_tclSM* m_poCurrentStateMachine = NULLPTR;
   vCreate(FC_PHONE_SMMANAGER_SMID_IDLE, rfpCallInstance, NULLPTR);
   /* Execute Idle StateMachine */
   m_poCurrentStateMachine = GetSM_FromCallInstanceID(rfpCallInstance->m_u16Id);
   if(m_poCurrentStateMachine)
   {
      ETG_TRACE_USR4(("EXECUTE.......  "));
      m_poCurrentStateMachine->vExecute();
   }
   else
   {
      ETG_TRACE_USR4(("m_poCurrentStateMachine = NULL ,This line never should execute "));
   }
   vTryDeleteUnusedSM();
}

/*******************************************************************************
 *
 * FUNCTION: vSendStatus
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMManager::vSendStatus(tU16 u16StatusUpdateId,\
      fc_phone_tclCallInstance*& rfpCallInstance)
{
   ETG_TRACE_USR4(("fc_phone_tclSMManager::vSendStatus "));
   m_poObserver->vSendStatus(u16StatusUpdateId,rfpCallInstance);
}
/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMObserver::vSendStatus
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ***************************************************************************/
tVoid fc_phone_tclSMManager::vSendStatus(tU16 u16StatusUpdateId,tVoid *varg)
{
   ETG_TRACE_USR4((" ENTER: fc_phone_tclSMManager::vSendStatus "));

   m_poObserver->vSendStatus(u16StatusUpdateId,varg);

   ETG_TRACE_USR4((" EXIT: fc_phone_tclSMManager::vSendStatus"));
}

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMObserver::vSendError
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ***************************************************************************/
tVoid fc_phone_tclSMManager::vSendError(tU16 u16StatusUpdateId,tVoid *varg)
{
   ETG_TRACE_USR4((" ENTER: fc_phone_tclSMManager::vSendStatus "));

   m_poObserver->vSendPropertyError(u16StatusUpdateId,varg);

   ETG_TRACE_USR4((" EXIT: fc_phone_tclSMManager::vSendStatus"));
}
/*******************************************************************************
 *
 * FUNCTION: u16GetUnmappedCallInstance
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tU16 fc_phone_tclSMManager::u16GetUnmappedCallInstance(const T_CallData* const prCallData)
{
   ETG_TRACE_USR4(("fc_phone_tclSMManager::u16GetUnmappedCallInstance"));

   tU16 u16Unmapped_callInstance =  FC_PHONE_SMMANAGER_CALLINSTANCEID_UNKNOWN;
   //Search for unmapped ACTIVE CallInstance In SMs
   //If call state is incoming this checks for unmapped call instance so that it maps to IDLE SM
   if((prCallData->rCallStatus.u8CallState == PHONE_CALLSTATE_INCOMING) || (prCallData->rCallStatus.u8CallState == PHONE_CALLSTATE_WAITING))
   {
      //Search for unmapped CallInstance In SMs
      for(tU16 indx=0; indx< FC_PHONE_SMMANAGER_MAX_SM_SUPPORTED ;indx++)
      {
         if(m_SMTable[indx])
         {
            if(m_SMTable[indx]->m_poCallInstance)
            {
               if((FC_PHONE_CALLSTATUS_MAPSTATE_SM_USING_UNMAPPED == m_SMTable[indx]->m_poCallInstance->m_enCallStatusHdlr_MapState)
                     &&(FC_PHONE_CALLINSTANCE_OBJECTSTATE_IDLE == m_SMTable[indx]->m_poCallInstance->m_u8ObjectState))
               {
                  m_SMTable[indx]->m_poCallInstance->m_enCallStatusHdlr_MapState = FC_PHONE_CALLSTATUS_MAPSTATE_SM_USING_MAPPED ;
                  ETG_TRACE_USR4(("Unmapped CallInstance Found is especially for incoming call::%d ",m_SMTable[indx]->m_poCallInstance->m_u16Id));
                  u16Unmapped_callInstance = m_SMTable[indx]->m_poCallInstance->m_u16Id ;
                  return u16Unmapped_callInstance ;
               }
            }
         }
      }
   }
   for(tU16 indx=0; indx< FC_PHONE_SMMANAGER_MAX_SM_SUPPORTED ;indx++)
   {
      if(m_SMTable[indx])
      {
         if(m_SMTable[indx]->m_poCallInstance)
         {
            if((FC_PHONE_CALLSTATUS_MAPSTATE_SM_USING_UNMAPPED == m_SMTable[indx]->m_poCallInstance->m_enCallStatusHdlr_MapState)
                  &&(FC_PHONE_CALLINSTANCE_OBJECTSTATE_ACTIVE == m_SMTable[indx]->m_poCallInstance->m_u8ObjectState)
            )
            {
               m_SMTable[indx]->m_poCallInstance->m_enCallStatusHdlr_MapState = FC_PHONE_CALLSTATUS_MAPSTATE_SM_USING_MAPPED ;
               ETG_TRACE_USR4(("Unmapped ACTIVE CallInstance Found is ::%d ",m_SMTable[indx]->m_poCallInstance->m_u16Id));
               u16Unmapped_callInstance = m_SMTable[indx]->m_poCallInstance->m_u16Id ;
               return u16Unmapped_callInstance ;
            }
         }
      }
   }

   //Search for unmapped CallInstance In SMs
   for(tU16 indx=0; indx< FC_PHONE_SMMANAGER_MAX_SM_SUPPORTED ;indx++)
   {
      if(m_SMTable[indx])
      {
         if(m_SMTable[indx]->m_poCallInstance)
         {
            if(FC_PHONE_CALLSTATUS_MAPSTATE_SM_USING_UNMAPPED == m_SMTable[indx]->m_poCallInstance->m_enCallStatusHdlr_MapState)
            {
               m_SMTable[indx]->m_poCallInstance->m_enCallStatusHdlr_MapState = FC_PHONE_CALLSTATUS_MAPSTATE_SM_USING_MAPPED ;
               ETG_TRACE_USR4(("Unmapped CallInstance Found is ::%d ",m_SMTable[indx]->m_poCallInstance->m_u16Id));
               u16Unmapped_callInstance = m_SMTable[indx]->m_poCallInstance->m_u16Id ;
               return u16Unmapped_callInstance ;
            }
         }
      }
   }

   ETG_TRACE_ERR(("Error : this line should never execute."));
   return u16Unmapped_callInstance ;

}

/*******************************************************************************
 *
 * FUNCTION: vProcessAudioSignal
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMManager::vProcessAudioSignal()
{
   ETG_TRACE_USR4(("fc_phone_tclSMManager::vProcessAudioSignal "));
   for(tU16 indx=0; indx< FC_PHONE_SMMANAGER_MAX_SM_SUPPORTED ;indx++)
   {
      if(m_SMTable[indx])
      {
         m_SMTable[indx]->vProcessAudioSignal();
      }
      else
      {
         ETG_TRACE_USR4(("m_SMTableindx = %d is NULL",indx));
      }
   }
}

/*******************************************************************************
 *
 * FUNCTION: vNewCallStatus
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMManager::vNewCallStatus(const T_CallData* const prCallData,tU16 u16_callInstance)
{
   ETG_TRACE_USR4(("fc_phone_tclSMManager::vNewCallStatus callInstance :: %d ",u16_callInstance));
   if(u16_callInstance != FC_PHONE_SMMANAGER_CALLINSTANCEID_UNKNOWN)
   {
      fc_phone_tclSM* m_poCurrentStateMachine;
      m_poCurrentStateMachine = GetSM_FromCallInstanceID(u16_callInstance);
      if(m_poCurrentStateMachine)
      {
         ETG_TRACE_USR4(("m_poCurrentStateMachine is NOT NULL"));
        //OSAL_s32ThreadWait(500);
         ETG_TRACE_USR4(("Wait timer expired"));
         m_poCurrentStateMachine->vNewCallStatus(prCallData,u16_callInstance);
      }
      else
      {
         ETG_TRACE_USR4(("vNewCallStatus:: m_poCurrentStateMachine is NULL"));
      }
   }
}
/*******************************************************************************
 *
 * FUNCTION: vUpdateSMInstanceInSMTable
 *
 * DESCRIPTION: update the SM TABLE

 * PARAMETER:
 *          fc_phone_tclSM* : SM instance pointer
 *          tU16            : call instance id
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMManager::vUpdateSMInstanceInSMTable(fc_phone_tclSM* pSMInstance)
{
   tU16 indx;
   ETG_TRACE_USR4((" fc_phone_tclSMManager::vUpdateSMInstanceInSMTable "));
   //If call instance is already in table, update the SM instance
   for(indx=0; indx < FC_PHONE_SMMANAGER_MAX_SM_SUPPORTED;indx++)
   {
      ETG_TRACE_USR4(("m_SMTable[%d] =  %p",indx,m_SMTable[indx]));
      if(!m_SMTable[indx] )
      {
         m_SMTable[indx] =  pSMInstance;
         ETG_TRACE_USR4(("m_SMTable[%d] =  %p",indx,m_SMTable[indx]));
         return;
      }
   }

}

/*******************************************************************************
 *
 * FUNCTION: vCallTimerCallBack
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMManager::vCallTimerCallBack(tU16 u16_TimerID)
{
   for(tU8 u8Index = 0; u8Index < FC_PHONE_SMMANAGER_MAX_SM_SUPPORTED ;u8Index++)
   {
      if(m_SMTable[u8Index])
      {
         tBool bCallbackCalled = FALSE;//Avoid to increment the call duration twice.

         if(m_SMTable[u8Index]->m_poCallInstance)
         {
            if(m_SMTable[u8Index]->m_poCallInstance->m_u16TimerId == u16_TimerID)
            {
               ETG_TRACE_USR4((" Returing SMinstance of CallInstance %d ",m_SMTable[u8Index]->m_poCallInstance->m_u16Id));
               m_SMTable[u8Index]->vTimerCallBack(u16_TimerID);
               bCallbackCalled = TRUE;
            }
         }
         if(FALSE == bCallbackCalled && m_SMTable[u8Index]->m_poCallInstance2)
         {
            if(m_SMTable[u8Index]->m_poCallInstance2->m_u16TimerId == u16_TimerID)
            {
               ETG_TRACE_USR4((" Returing SMinstance of CallInstance %d ",m_SMTable[u8Index]->m_poCallInstance2->m_u16Id));
               m_SMTable[u8Index]->vTimerCallBack(u16_TimerID);
            }
         }
      }
      else
      {
         ETG_TRACE_USR4((" m_SMTable[indx] is NULL "));
      }
   }
}

/*******************************************************************************
 *
 * FUNCTION: vCreate
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMManager::vCreate(tU16 u16StateMachineId,fc_phone_tclCallInstance *rfpCallInstance[], tVoid *vArg)
{
   ETG_TRACE_USR4(("fc_phone_tclSMManager::vCreate With Two Call Instances and Args"));
   fc_phone_tclSM* m_poCurrentStateMachine = NULLPTR;

   ETG_TRACE_USR2(("u16StateMachineId :: %d ",u16StateMachineId));
   switch (u16StateMachineId)
   {
      case FC_PHONE_SMMANAGER_SMID_TRANSFERCALL:
      {
         ETG_TRACE_USR4(("u16StateMachineId::FC_PHONE_SMMANAGER_SMID_TRANSFER CALL"));
         m_poCurrentStateMachine = OSAL_NEW fc_phone_tclSMTransferCallHandSetHandsFree(rfpCallInstance);
         break;
      }

      case FC_PHONE_SMMANAGER_SMID_CONFERENCECALL:
      {
         ETG_TRACE_USR4(("u16StateMachineId::FC_PHONE_SMMANAGER_SMID_CONFERENCECALL CALL"));
         if(vArg)
         {
            m_poCurrentStateMachine = OSAL_NEW fc_phone_tclSMConferenceCall(rfpCallInstance, vArg);
         }
         else
         {
            m_poCurrentStateMachine = OSAL_NEW fc_phone_tclSMConferenceCall(rfpCallInstance);
         }
         break;
      }

      default:
      {
         ETG_TRACE_USR4(("Wrong u16StateMachineId %d", u16StateMachineId));
      }
      break;
   }

   ETG_TRACE_USR4(("Updating SM TABLE"));
   if (m_poCurrentStateMachine)
   {
      vUpdateSMInstanceInSMTable(m_poCurrentStateMachine);
   }
   else
   {
      ETG_TRACE_USR4(("m_poCurrentStateMachine is NULL "));
   }
}

/*******************************************************************************
 *
 * FUNCTION: vCreate
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMManager::vCreate(tU16 u16StateMachineId,fc_phone_tclCallInstance*& rfpCallInstance,tVoid *vArg)
{
   ETG_TRACE_USR4(("fc_phone_tclSMManager::vCreate with args "));
   fc_phone_tclSM* m_poCurrentStateMachine = NULLPTR;

   ETG_TRACE_USR2(("u16StateMachineId :: %d", u16StateMachineId));
   switch (u16StateMachineId)
   {

      case FC_PHONE_SMMANAGER_SMID_DIAL:
      {
         ETG_TRACE_USR4(("u16StateMachineId::FC_PHONE_SMMANAGER_SMID_DIAL "));
         if(vArg)
         {
            m_poCurrentStateMachine = OSAL_NEW fc_phone_tclSMDial(rfpCallInstance, vArg);
         }
         else
         {
            m_poCurrentStateMachine = OSAL_NEW fc_phone_tclSMDial(rfpCallInstance);
         }
      }
      break;

      case FC_PHONE_SMMANAGER_SMID_IDLE:
      {
         m_poCurrentStateMachine = OSAL_NEW fc_phone_tclSMIdle(rfpCallInstance);
      }
      break;

      case FC_PHONE_SMMANAGER_SMID_ACCEPTCALL:
      {
         m_poCurrentStateMachine = OSAL_NEW fc_phone_tclSMAcceptCall(rfpCallInstance);
      }
      break;

      case FC_PHONE_SMMANAGER_SMID_IGNORECALL:
      {
         m_poCurrentStateMachine = OSAL_NEW fc_phone_tclSMRejectCall(rfpCallInstance);
      }
      break;

      case FC_PHONE_SMMANAGER_SMID_REJECTCALL:
      {
         m_poCurrentStateMachine = OSAL_NEW fc_phone_tclSMRejectCall(rfpCallInstance);
      }
      break;

      case FC_PHONE_SMMANAGER_SMID_HANGUPCALL:
      {
         m_poCurrentStateMachine = OSAL_NEW fc_phone_tclSMHangUpCall(rfpCallInstance);
      }
      break;

      case FC_PHONE_SMMANAGER_SMID_ACTIVECALLINHANDSET:
      {
         m_poCurrentStateMachine = OSAL_NEW fc_phone_tclSMACH(rfpCallInstance);
      }
      break;

      default:
      {
         ETG_TRACE_USR4((" This SM is not supproted :: %d ", u16StateMachineId));

      }
      break;
   }

   ETG_TRACE_USR4(("Updating SM TABLE"));
   if (m_poCurrentStateMachine)
   {
      vUpdateSMInstanceInSMTable(m_poCurrentStateMachine);
   }
   else
   {
      ETG_TRACE_USR4(("m_poCurrentStateMachine is NULL "));
   }
}



/*******************************************************************************
 *
 * FUNCTION: vProcessOnDynamicDisconnect
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMManager::vProcessOnDynamicDisconnect(tU16 u16EventId,tU8 u8BDId)
{
   ETG_TRACE_USR4(("fc_phone_tclSMManager::vProcessOnDynamicDisconnect u16EventId %d",u16EventId));

   //compare the device Address with all the SM deviceAddress in SM table
   //Send Disconnect to  SMs ,which belong to disconnected Device address
   tU8 u8_SLCOFF_BDAddress[PHONE_SLCOFF_BDADDRESS];
   memset(u8_SLCOFF_BDAddress,0,PHONE_SLCOFF_BDADDRESS);
   tBool bSMProcessingSLC_Off = FALSE ;

   for(tU16 indx=0; indx< FC_PHONE_SMMANAGER_MAX_SM_SUPPORTED ;indx++)
   {
      if(m_SMTable[indx])
      {
         if(m_SMTable[indx]->m_poCallInstance)
         {
            if(m_SMTable[indx]->m_poCallInstance->m_u8BDAddressId == u8BDId)
            {
               ETG_TRACE_USR4(("SLCOFF for CallInstanceID :: %d ",m_SMTable[indx]->m_poCallInstance->m_u16Id));
               bSMProcessingSLC_Off = TRUE ;

               //Delete the callinstance entry from CallManager handler MAPTable (if Present)
               fc_phone_tclCallManager *pCallManagerInstance ;
               pCallManagerInstance = (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->m_poCallManager ;

               if(pCallManagerInstance)
               {
                  ETG_TRACE_USR4(("process Deleting corresponding callInstance entry from CallManager Hndler Table"));
                  pCallManagerInstance->vDeleteCallInstanceFromCMHandlerMapTable(m_SMTable[indx]->m_poCallInstance->m_u16Id) ;

                  //GMMY15-11552 - m_u16count and callhandler map table not cleared if ignition OFF -> ON done with 2 active calls.

                  if(m_SMTable[indx]->m_poCallInstance2)
                  {
                     pCallManagerInstance->vDeleteCallInstanceFromCMHandlerMapTable(m_SMTable[indx]->m_poCallInstance2->m_u16Id) ;
                  }
               }
               //process the dynamic disconnect for this SM
               m_SMTable[indx]->vProcessOnDynamicDisconnect(u16EventId) ;
            }
         }
         else if(m_SMTable[indx]->m_poCallInstance2)
         {
            if(m_SMTable[indx]->m_poCallInstance2->m_u8BDAddressId == u8BDId)
            {
               ETG_TRACE_USR4(("SLCOFF for CallInstanceID :: %d ",m_SMTable[indx]->m_poCallInstance2->m_u16Id));
               bSMProcessingSLC_Off = TRUE ;

               //Delete the callinstance entry from CallManager handler MAPTable (if Present)
               fc_phone_tclCallManager *pCallManagerInstance ;
               pCallManagerInstance = (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->m_poCallManager ;

               if(pCallManagerInstance)
               {
                  ETG_TRACE_USR4(("process Deleting corresponding callInstance entry from CallManager Hndler Table"));
                  pCallManagerInstance->vDeleteCallInstanceFromCMHandlerMapTable(m_SMTable[indx]->m_poCallInstance2->m_u16Id) ;
               }
               //process the dynamic disconnect for this SM
               m_SMTable[indx]->vProcessOnDynamicDisconnect(u16EventId) ;
            }
         }
      }
   }

   vProcessVREvent(u16EventId,(tVoid*)u8_SLCOFF_BDAddress);
   vProcessExtVREvent(u16EventId);

   //ALL SM is in IDLE State and not processing SLC off
   //Process sending SLC off From SM manager
   if(FALSE == bSMProcessingSLC_Off)
   {
      ETG_TRACE_USR4((" Processing SLC off from SM manager, As no SM is ACtive "));
      //send SLC status to client
      if(m_SMTable[0]->m_poCallInstance)
      {
         vSendStatus(FC_PHONE_SMMANAGER_STATUS_SLC,m_SMTable[0]->m_poCallInstance);
      }
      else if(m_SMTable[0]->m_poCallInstance2)
      {
         vSendStatus(FC_PHONE_SMMANAGER_STATUS_SLC,m_SMTable[0]->m_poCallInstance2);
      }
      else
      {
         ETG_TRACE_USR4((" This Line Should never Execute "));
      }
   }
}


/*******************************************************************************
 *
 * FUNCTION: vBroadCastInternalEvent
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMManager::vBroadCastInternalEvent(tU16 u16EventId)
{
   ETG_TRACE_USR4((" vBroadCastInternalEvent enter:: u16EventId : %d",u16EventId));

   //BroadCast
   FcPhone_processEventArg   tProcessEventArg ;
   tProcessEventArg.bIsItDbusAck =  FALSE ;

   vProcessEvent(u16EventId, FC_PHONE_EVENTTYPE_BROADCAST,&tProcessEventArg);

}

/*******************************************************************************
 *
 * FUNCTION: vRestoreActiveCallInHandset
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMManager::vRestoreToActiveCallInHandset(tU16 u16CallInstanceId)
{
   ETG_TRACE_USR4(("fc_phone_tclSMManager::vRestoreToActiveCallInHandset CallInstanceId: '%u'", u16CallInstanceId));

   fc_phone_tclSM* poStateMachineToDelete = GetSM_FromCallInstanceID(u16CallInstanceId);
   tS16 s16SMIndex = GetSMIndex_FromCallInstanceID(u16CallInstanceId);

   NULL_CHECK(poStateMachineToDelete);
   fc_phone_tclCallInstance* poTempCallInstance = poStateMachineToDelete->m_poCallInstance;
   vAddSMToDelete(poStateMachineToDelete);

   if (INVALID_INDEX != s16SMIndex)
   {
      m_SMTable[s16SMIndex] = NULLPTR;
   }

   vCreate(FC_PHONE_SMMANAGER_SMID_ACTIVECALLINHANDSET, poTempCallInstance, NULLPTR);

   fc_phone_tclSM* poCurrentStateMachine = GetSM_FromCallInstanceID(u16CallInstanceId);
   if (poCurrentStateMachine)
   {
      ETG_TRACE_USR4(("EXECUTE To Restore.......  "));
      poCurrentStateMachine->vRestore();
   }
   else
   {
      ETG_TRACE_ERR(("Error :: m_poCurrentStateMachine = NULL ,This line never should execute "));
   }
}

/*******************************************************************************
 *
 * FUNCTION: bRestoreFromActiveCallInHandset
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tBool fc_phone_tclSMManager::bRestoreFromActiveCallInHandset(tU16 u16CallInstanceId)
{
   ETG_TRACE_USR4(("fc_phone_tclSMManager::bRestoreFromActiveCallInHandset CallInstanceId: '%u'", u16CallInstanceId));

   tBool bRetVal = TRUE;

   fc_phone_tclSM* poStateMachineToDelete = GetSM_FromCallInstanceID(u16CallInstanceId);
   if(!poStateMachineToDelete)
   {
      return bRetVal;
   }
   tS16 s16SMIndex = GetSMIndex_FromCallInstanceID(u16CallInstanceId);
   fc_phone_tclCallInstance* poTempCallInstance = poStateMachineToDelete->m_poCallInstance;

   tU16 u16SMID = FC_PHONE_SMMANAGER_SMID_UNKNOWN;

   if (PHONE_CALLDIRECTION_INCOMING == poTempCallInstance->m_u8CallDirection)
   {
      vAddSMToDelete(poStateMachineToDelete);

      if (INVALID_INDEX != s16SMIndex)
      {
         m_SMTable[s16SMIndex] = NULLPTR;
      }

      u16SMID = FC_PHONE_SMMANAGER_SMID_ACCEPTCALL;
   }
   else if (PHONE_CALLDIRECTION_OUTGOING == poTempCallInstance->m_u8CallDirection)
   {
      vAddSMToDelete(poStateMachineToDelete);

      if (INVALID_INDEX != s16SMIndex)
      {
         m_SMTable[s16SMIndex] = NULLPTR;
      }

      u16SMID = FC_PHONE_SMMANAGER_SMID_DIAL;
   }
   else
   {
      ETG_TRACE_USR4(("Wrong CallDirection :: %u ", poTempCallInstance->m_u8CallDirection));
      bRetVal = FALSE;
      return bRetVal;
   }

   vCreate(u16SMID, poTempCallInstance, NULLPTR);

   fc_phone_tclSM* poCurrentStateMachine = GetSM_FromCallInstanceID(u16CallInstanceId);

   if (poCurrentStateMachine)
   {
      ETG_TRACE_USR4(("EXECUTE To Restore.......  "));
      poCurrentStateMachine->vRestore();
   }
   else
   {
      ETG_TRACE_USR4(("Error :: CurrentStateMachine is NULL"));
      bRetVal = FALSE;
      return bRetVal;
   }

   return bRetVal;
}

/*******************************************************************************
 *
 * FUNCTION: vTransferToAcceptCallSMforPassiveDev
 *
 * DESCRIPTION: Transfers to the Accept Call SM
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMManager::vTransferToAcceptCallSMforPassiveDev(tU16 u16CallInstanceId)
{
   ETG_TRACE_USR4((" vTransferToAcceptCallSMforPassiveDev entered with u16CallInstanceId: %d", u16CallInstanceId));

   fc_phone_tclSM* poStateMachine = GetSM_FromCallInstanceID(u16CallInstanceId);
   NULL_CHECK(poStateMachine);
   fc_phone_tclCallInstance* poReceivedCallInstance = poStateMachine->m_poCallInstance;
   fc_phone_tclCallInstance* poOtherCallInstance = (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vGetCallInstanceOfOtherSM(poReceivedCallInstance);

   for(tU16 indx=0; indx< FC_PHONE_SMMANAGER_MAX_SM_SUPPORTED ;indx++)
   {
      if(m_SMTable[indx])
      {
         vAddSMToDelete(m_SMTable[indx]);
         m_SMTable[indx] = NULLPTR;
      }
      else
      {
         ETG_TRACE_USR4(("m_SMTable[%d] is NULL", indx));
      }
   }

   vCreate(FC_PHONE_SMMANAGER_SMID_ACCEPTCALL, poReceivedCallInstance, NULLPTR);
   vCreate(FC_PHONE_SMMANAGER_SMID_IDLE, poOtherCallInstance, NULLPTR);

   for(tU16 indx=0; indx< FC_PHONE_SMMANAGER_MAX_SM_SUPPORTED ;indx++)
   {
      fc_phone_tclSM* poCurrentStateMachine = GetSM_FromCallInstanceID(indx);
      if (poCurrentStateMachine)
      {
         ETG_TRACE_USR4(("EXECUTE.......  "));
         poCurrentStateMachine->vExecute();
      }
      else
      {
         ETG_TRACE_ERR(("Error :: m_poCurrentStateMachine = NULL ,This line never should execute "));
      }
   }
}

/*******************************************************************************
 *
 * FUNCTION: bIsSMRunning
 *
 * DESCRIPTION: Check if SM is running already
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tBool fc_phone_tclSMManager::bIsSMRunning(tU16 u16StateMachineId,
      tU16 u16_callInstanceID)
{
   ETG_TRACE_USR4((" bIsSMRunning enter"));
   tU16 indx;
   ETG_TRACE_USR2(("InPut u16StateMachineId %d ",u16StateMachineId));
   for(indx=0; indx< FC_PHONE_SMMANAGER_MAX_SM_SUPPORTED ;indx++)
   {
      if (m_SMTable[indx])
      {
         if (m_SMTable[indx]->m_poCallInstance)
         {
            if (u16_callInstanceID == m_SMTable[indx]->m_poCallInstance->m_u16Id)
            {
               if (u16StateMachineId == m_SMTable[indx]->u16GetSMID())
               {
                  return TRUE;
               }
            }
         }
      }
      else
      {
         ETG_TRACE_USR4(("m_SMTable[indx] is NULL "));
      }
   }
   return FALSE ;
}

/*******************************************************************************
 *
 * FUNCTION: vSetDtmfLen
 *
 * DESCRIPTION: Pass the new dtmf len to SM
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMManager::vSetDtmfLen(tU16 u16DtmfLen,
      tU16 u16CallInstanceID)
{
   ETG_TRACE_USR4((" vSetDtmfLen enter"));
   tU16 indx;
   ETG_TRACE_USR2(("InPut u16_callInstanceID %d ",u16CallInstanceID));
   for(indx=0; indx< FC_PHONE_SMMANAGER_MAX_SM_SUPPORTED ;indx++)
   {
      if (m_SMTable[indx])
      {
         if (m_SMTable[indx]->m_poCallInstance)
         {
            if (u16CallInstanceID == m_SMTable[indx]->m_poCallInstance->m_u16Id)
            {
               m_SMTable[indx]->vSetDtmfLength(u16DtmfLen);
            }
         }
      }
      else
      {
         ETG_TRACE_USR4((" m_SMTable[indx] is NULL"));
      }
   }
}

/*******************************************************************************
 *
 * FUNCTION: vAddSMToDelete
 *
 * DESCRIPTION: Add the list of SM to be delete
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMManager::vAddSMToDelete(fc_phone_tclSM* pSMInstance)
{
   ETG_TRACE_USR4((" vAddSMToDelete enter"));
   for(tU16 DelIndx=0; DelIndx < FC_PHONE_SMMANAGER_MAX_SM_TODELETE; DelIndx++)
   {
      if(!m_apSMToBeDeleted[DelIndx])
      {
         ETG_TRACE_USR4((" SM to be deleted is added"));
         m_apSMToBeDeleted[DelIndx] = pSMInstance;
         break;
      }
   }
}

/*******************************************************************************
 *
 * FUNCTION: vTryDeleteUnusedSMs
 *
 * DESCRIPTION: Add the list of SM to be delete
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMManager::vTryDeleteUnusedSM()
{
   ETG_TRACE_USR4((" Delete UnUsed SM "));
   for(tU16 DelIndx=0; DelIndx < FC_PHONE_SMMANAGER_MAX_SM_TODELETE; DelIndx++)
   {
      if(m_apSMToBeDeleted[DelIndx])
      {
         ETG_TRACE_USR4((" SM is  deleted "));
         OSAL_DELETE m_apSMToBeDeleted[DelIndx];
         m_apSMToBeDeleted[DelIndx] = NULLPTR;
      }
      else
      {
         break;
      }
   }
}

/*******************************************************************************
 *
 * FUNCTION: getCallInstancebyUniqueId
 *
 * DESCRIPTION: Returns CallInstance using uniqueId
 *
 * PARAMETER:tU16
 *
 * RETURNVALUE: fc_phone_tclCallInstance*
 *
 ********************************************************************************/

fc_phone_tclCallInstance* fc_phone_tclSMManager::getCallInstancebyUniqueId(tU16 u16Id)
{
   ETG_TRACE_USR4(("fc_phone_tclSMManager::getCallInstancebyUniqueId InPut u16Id %d", u16Id));
   tS16 count = 0;
   for(count = 0; count < FC_PHONE_SMMANAGER_MAX_SM_SUPPORTED; count++)
   {
      ETG_TRACE_USR4(("fc_phone_tclSMManager::getCallInstancebyUniqueId count   %d", count));
      if(m_SMTable[count])
      {
         ETG_TRACE_USR4(("m_SMTable[count] is not equal to NULL "));
         if(m_SMTable[count]->m_poCallInstance)
         {
            ETG_TRACE_USR4(("CallInstance not equal to NULL "));
            if(m_SMTable[count]->m_poCallInstance->m_u16Id == u16Id)
            {
               ETG_TRACE_USR4(("count = %d Returning CallInstance %d ",count,m_SMTable[count]->m_poCallInstance->m_u16Id));
               return m_SMTable[count]->m_poCallInstance;
            }
         }
         // gmmy15-10054 when in conference call only one state machine will be there with two call instance
         //for the two ACTIVE call, so a check need to be done for 2nd call instance also.
         //for other statemachines call int=stance 2 will be NULL.

         if(m_SMTable[count]->m_poCallInstance2)
         {
            ETG_TRACE_USR4(("CallInstance2 not equal to NULL "));
            if(m_SMTable[count]->m_poCallInstance2->m_u16Id == u16Id)
            {
               ETG_TRACE_USR4(("count = %d Returning CallInstance2 %d ",count,m_SMTable[count]->m_poCallInstance2->m_u16Id));
               return m_SMTable[count]->m_poCallInstance2;
            }
         }

      }
      else
      {
         ETG_TRACE_USR4(("m_SMTable[count] is NULL "));
      }
   }
   return NULLPTR;
}

/*******************************************************************************
 *
 * FUNCTION: u8GetCallObjectState
 *
 * DESCRIPTION: Returns object state of the corresponding call instance
 *
 * PARAMETER:tU8
 *
 * RETURNVALUE: tU8
 *
 ********************************************************************************/
tU16 fc_phone_tclSMManager::u8GetCallObjectState(tU16 index)
{
   ETG_TRACE_USR4(("fc_phone_tclSMManager::u8GetCallObjectState, index-  %d", index));
   for (tU16 ind = 0; ind < FC_PHONE_SMMANAGER_MAX_SM_SUPPORTED; ++ind)
   {
      if (m_SMTable[ind])
      {
         if(m_SMTable[ind]->m_poCallInstance)
         {
            ETG_TRACE_USR4(("m_SMTable[ind]->m_poCallInstance exist"));
            if(m_SMTable[ind]->m_poCallInstance->m_u16Id == index)
            {
               return m_SMTable[ind]->m_poCallInstance->m_u8ObjectState;
            }
         }
         if(m_SMTable[ind]->m_poCallInstance2)
         {
            ETG_TRACE_USR4(("m_SMTable[ind]->m_poCallInstance2 exist"));
            if(m_SMTable[ind]->m_poCallInstance2->m_u16Id == index)
            {
               return m_SMTable[ind]->m_poCallInstance2->m_u8ObjectState;
            }
         }
         else
         {
            ETG_TRACE_USR4(("The CI is NULL"));
         }
      }
      else
      {
         ETG_TRACE_USR4(("m_SMTable[ind] is NULL"));
      }
   }

   return FC_PHONE_CALLINSTANCE_OBJECTSTATE_IDLE;
}
