

/*******************************************************************************
 *
 * FILE:          FC_Phone_SMIdle.h
 *
 * SW-COMPONENT:  FC_Phone application
 *
 * PROJECT:
 *
 * DESCRIPTION:   Abstracts a statemachine
 *
 * AUTHOR:        Guruprasad G R
 *
 * COPYRIGHT:    (c)Celestial Systems, Bangalore, India
 *
 *******************************************************************************/

#ifndef _FC_PHONE_SMIDLE_H_
#define _FC_PHONE_SMIDLE_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/

/* Define the states that this machine can take */

#define FC_PHONE_SMIDLE_STATE_IDLE 0
#define FC_PHONE_SMIDLE_STATE_WAIT_FOR_CALLSTATUS_RINGING 1
#define FC_PHONE_SMIDLE_STATE_WAIT_FOR_PHONEBOOKRESPONSE_OR_RINGTONEACTIVATED 2
#define FC_PHONE_SMIDLE_STATE_WAIT_FOR_PHONEBOOKRESPONSE                      3
#define FC_PHONE_SMIDLE_STATE_WAIT_FOR_RINGTONEACTIVATED                      4

#define FC_PHONE_SMIDLE_STATE_WAIT_FOR_AM_RESPONSE_INCOMINGCALL 5
#define FC_PHONE_SMIDLE_STATE_RINGING  6
#define FC_PHONE_SMIDLE_STATE_WAIT_FOR_HOLD_RESPONE  7
#define FC_PHONE_SMIDLE_STATE_ONHOLD   8
#define FC_PHONE_SMIDLE_STATE_WAIT_FOR_AM_RESPONSE_ALERTTONE 9
#define FC_PHONE_SMIDLE_STATE_WAIT_FOR_AM_ALERTTONE_REQTIMEOUT 10
#define FC_PHONE_SMIDLE_STATE_ALERTTONE_PLAYING 11
#define FC_PHONE_SMIDLE_STATE_WAIT_FOR_AVM_RESPONSE_ALERTTONERETRY 12
#define FC_PHONE_SMIDLE_STATE_DISPLAY_ONLY_PROMPT 13
#define FC_PHONE_SMIDLE_STATE_WAIT_FOR_RINGMUTEACK    14
#define FC_PHONE_SMIDLE_STATE_RINGTONE_MUTED          15
#define FC_PHONE_SMIDLE_STATE_WAIT_FOR_RINGUNMUTEACK  16

#define FC_PHONE_SMIDLE_STATE_WAIT_FOR_RELEASE_ALERTTONE 17

#define FC_PHONE_SMIDLE_STATE_WAIT_FOR_SLC_OFF_RESPONSE 18
#define FC_PHONE_SMIDLE_STATE_WAIT_FOR_NOSIGNAL_RESPONSE 19

#define FC_PHONE_SMIDLE_STATE_ROUTING_INCOMINGCALL_IN_HANDSET  20
#define FC_PHONE_SMIDLE_STATE_WAIT_FOR_INCOMINGCALL_TERMINATE  21
#define FC_PHONE_SMIDLE_STATE_WAIT_FOR_AUDIO_RELEASE_AND_INIT_IDLE 22
#define FC_PHONE_SMIDLE_STATE_CONFERENCE_TIMER_STARTED  23
#define FC_PHONE_SMIDLE_STATE_WAIT_FOR_AM_RESPONSE_ACTIVATE_VOICE 24
#define FC_PHONE_SMIDLE_STATE_WAIT_FOR_CONNECT_FROM_BT 25
#define FC_PHONE_SMIDLE_STATE_ALERTTONE_PAUSED 26
#define FC_PHONE_SMIDLE_STATE_WAIT_FOR_ALERTTONE_PLAYSTATE 27
#define FC_PHONE_SMIDLE_STATE_WAIT_FOR_ALERTTONE_STOPSTATE 28
#define FC_PHONE_SMIDLE_STATE_ALERT_TONE_RELEASED 29  // Bugfix for GMMY16-10666
#define FC_PHONE_SMIDLE_STATE_RELEASE_ALERT_ACTIVATE_RINGTONE 30  //Fix for PSARCCB-3030

class fc_phone_tclSMManager;
/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class fc_phone_tclSMIdle : public fc_phone_tclSM 
{
public:

   /* Constructor */
   fc_phone_tclSMIdle(fc_phone_tclCallInstance*&  rfpCallInstance);

   /* Destructor */
   virtual ~fc_phone_tclSMIdle();
   virtual tVoid vCancel(tVoid) FINAL;
   virtual tVoid vExecute(tVoid);
   virtual tBool bProcessEvent(tU16 u16EventId) FINAL;
   virtual tBool bProcessEvent(tU16 u16EventId,tVoid *varg);
   virtual tVoid vNewCallStatus(const T_CallData* const prCallData,tU16 u16_callInstance);
   virtual tVoid vTimerCallBack(tU16 u16TimerId);
   virtual tVoid vAudioCallBack(tU16 u16AudioChannelId, tU16 u16RequestState);
   virtual tVoid vProcessOnDynamicDisconnect(tU16 u16EventId);
   virtual tVoid vProcessAudioSignal();
   virtual tVoid vRestore(tVoid);

private:
   tBool m_bTimerRunning;
   tU16  m_u16AlertCountRetry;
   tU16  m_u16AlertPromptPlayCount;
   tBool m_bEventConsumed ;
   tBool m_bAlertPlaying;
   tBool AudioTransferStatus;
   tBool m_bAlertRequestPending;
   tVoid vInit(tVoid);
   tVoid vHandleEventInIdle(tU16 u16EventId);
   tVoid vHandleEventInWaitforCallStatusRinging(tU16 u16EventId);
   tVoid vHandleEventPhoneBookResponseOrRingtoneActivated(tU16 u16EventId);
   tVoid vHandleEventPhoneBookResponse(tU16 u16EventId);
   tVoid vHandleEventRingtoneActivated(tU16 u16EventId);
   tVoid vHandleEventInAMAlertTone(tU16 u16EventId);
   tVoid vHandleEventInAMAlertReqTimeOut(tU16 u16EventId);
   tVoid vHandleEventInAlertTonePlay(tU16 u16EventId);
   tVoid vHandleEventInAlertTonePause(tU16 u16EventId);
   tVoid vHandleEventInRinging(tU16 u16EventId);
   tVoid vHandleEventInHoldResponse(tU16 u16EventId);
   tVoid vHandleEventInRingMuteAck(tU16 u16EventId);
   tVoid vHandleEventInRingMuted(tU16 u16EventId);
   tVoid vHandleEventInRingUnMuteAck(tU16 u16EventId);
   tVoid vHandleEventInAlertToneRelease(tU16 u16EventId);
   tVoid vHandleEventInSLCOffResponse(tU16 u16EventId);
   tVoid vHandleEventInRoutingHandsetCall(tU16 u16EventId);
   tVoid vHandleEventInTerminateIncomingCall(tU16 u16EventId);
   tVoid vHandleEventInReleasingAudioAndReInitIdle(tU16 u16EventId);
   tVoid vHandleEventInAMInActivateVoiceCall(tU16 u16EventId);
   tVoid vHandleEventInSMIdleBTInCall(tU16 u16EventId);

   //Fix for CMG3GB-3184. "Start Waiting mode" has to be handled in the state FC_PHONE_SMIDLE_STATE_ALERT_TONE_RELEASED
   tVoid vHandleEventInSMIdleAlertToneReleased(tU16 u16EventId);
   //Fix for PSARCCB-3030 . Play ringtone for the second incoming call, when first active call is disconnected.
   tVoid vHandleEventInSMIdleReleaseAlertTone(tU16 u16EventId);

   tVoid vHandleCallWaiting(const T_CallData* const prCallData);
   tVoid vStopAlertTone();
   tVoid vStartPauseTimer();
   tVoid vHandleAlertToneStateInPlayState();
   tVoid vHandleAlertToneStateInStopState();
};



#endif // _FC_PHONE_SMIDLE_H_


