/******************************************************************************
 *
 * FILE:          FC_Phone_SMIdle.cpp
 *
 * SW-COMPONENT:  FC_Phone application
 *
 * PROJECT:
 *
 * DESCRIPTION:   CCA service Telephone.
 *
 * AUTHOR:
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

#include "FC_Phone_SMIncludes.h"
#include "../HelperClasses/FC_Phone_CallManager.h"
#include "stdio.h"
#include "../FC_Phone_clienthandler_BTSettings.h"
#include "FC_Phone_SMVRSession.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_PHONE_STATEMACHINE
#include "trcGenProj/Header/FC_Phone_SMIdle.cpp.trc.h"
#endif

// TODO: The Alert Tone related things has to be removed from this file

/*******************************************************************************
 *
 * FUNCTION: vAudioCallBackIdle
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid vAudioCallBackIdle(tU16 u16AudioReqID,tU16 u16AudioChannelId, tU16 u16RequestState)
{
   ETG_TRACE_USR4((" Entering  fvAudioCallBackIdle "));
   //fc_phone_tclSMIdle::m_poInstance ->vAudioCallBack(u16AudioChannelId, u16RequestState);
   fc_phone_tclSM* pSMInstance ;
   pSMInstance = fc_phone_tclSMManager::GetSM_FromAudioRequestorId(u16AudioReqID) ;   

   if(pSMInstance)
   {
      pSMInstance->vAudioCallBack(u16AudioChannelId, u16RequestState);
   }
   else
   {
      ETG_TRACE_ERR(("ERROR:: could not get SM for u16TimerId %d",u16AudioReqID));
   }
}

/* Fix for GMMY15-10552 Incoming call alert is delayed */
/*******************************************************************************
 *
 * FUNCTION: vTimerCallBackIncCallAlert
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid vTimerCallBackIncCallAlert(tU16 u16TimerId)
{
   ETG_TRACE_USR4(("ENTER vTimerCallBackIncCallAlert: %d",u16TimerId));

   if(FC_PHONE_INCOMINGCALLALERT_TIMER_ID == u16TimerId)
   {
      if(fc_phone_tclApp::m_poMainAppInstance)
      {
         if((fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone)
            (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vUpdateSearchPhoneBookMR_ResponseToSMs();
         else
            ETG_TRACE_ERR(("(fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone is NULL"));

         ETG_TRACE_USR3((" FC_PHONE_INCOMINGCALLALERT_TIMER_ID Timer Stopped for safe side"));

         (fc_phone_tclApp::m_poMainAppInstance)->m_poTimer->s32Stop(FC_PHONE_INCOMINGCALLALERT_TIMER_ID);
      }
      else
      {
         ETG_TRACE_ERR(("fc_phone_tclApp::m_poMainAppInstance is NULL"));
      }
   }
   else
   {
      ETG_TRACE_ERR(("Not a INCOMINGCALLALERT_TIMER_ID"));
   }
}

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSM
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
fc_phone_tclSMIdle::fc_phone_tclSMIdle(fc_phone_tclCallInstance*& rfpCallInstance) :
      fc_phone_tclSM(rfpCallInstance)
{
   ETG_TRACE_USR4(("Entering fc_phone_tclSMIdle::fc_phone_tclSMIdle"));

   vInit();

   m_bEventConsumed = FALSE;
   m_bAlertPlaying = FALSE;
   AudioTransferStatus = FALSE;
   m_bAlertRequestPending = FALSE;
   m_bTimerRunning = FALSE;
   m_u16AlertCountRetry = 0;
   m_u16AlertPromptPlayCount = 0;
}

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMIdle
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
/* Destructor */
fc_phone_tclSMIdle::~fc_phone_tclSMIdle()
{
   ETG_TRACE_USR4(("Entering fc_phone_tclSMIdle::~fc_phone_tclSMIdle "));
}

/*******************************************************************************
 *
 * FUNCTION: vRestoreIDLE
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMIdle::vRestore(tVoid)
{
   ETG_TRACE_USR4((" Restore IDLE  State Machine "));
   m_bTimerRunning = TRUE;
   ETG_TRACE_USR3(("m_bTimerRunning = TRUE "));
   m_u16State = FC_PHONE_SMIDLE_STATE_IDLE;
   m_bAlertRequestPending = FALSE;
}
/*******************************************************************************
 *
 * FUNCTION: vCancel
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMIdle::vCancel(tVoid)
{
   ETG_TRACE_USR4((" fc_phone_tclSMIdle::vCancel "));

   if(TRUE == m_bTimerRunning)
   {
      ETG_TRACE_USR4((" Stoping Timer with TimerId:; %d ",m_poCallInstance->m_u16Id));
      m_poTimer->s32Stop(m_poCallInstance->m_u16TimerId); // Bugfix for GMMY16-17241
      m_bTimerRunning = FALSE;
      ETG_TRACE_USR3(("m_bTimerRunning = FALSE"));
   }

   vStopAlertTone();
   //NCG3D-142658 : Updating the channel acquisition counter as the Phone channel would be released.
   fc_phone_tclClientHandler_BTSettings *p_clientHndler_bluetooth = (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerBTSettings;
   tU16 bInBandRingtone = p_clientHndler_bluetooth->vIsInBandRingtone();
   if(bInBandRingtone && (FC_PHONE_AUDIOCHANNEL_ALERTTONE == m_poCallInstance->m_u8AudioChannel))
   {
      ETG_TRACE_USR4((" SMIdle-vCancel: Updating acquisition counter"));
      m_poAudioManager->vUpdateChannelAttributes(FC_PHONE_AUDIOCHANNEL_PHONE, FC_PHONE_REQUESTTYPE_RELEASE);
   }

   m_bAlertRequestPending = FALSE;
}
/*******************************************************************************
 *
 * FUNCTION: vExecute
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMIdle::vExecute()
{
   /* Nothing to do as this class only listens to the event */
   ETG_TRACE_USR4((" fc_phone_tclSMIdle::vExecute "));
}
/*******************************************************************************
 *
 * FUNCTION: bProcessEvent
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tBool fc_phone_tclSMIdle::bProcessEvent(tU16 u16EventId,tVoid *varg)
{
   ETG_TRACE_USR4((" fc_phone_tclSMIdle::bProcessEvent u16EventId %d",u16EventId));
   (tVoid)varg ;
   tBool bRetVal= FALSE ;
   FcPhone_processEventArg   *ptProcessEventArg = (FcPhone_processEventArg *) varg;
   if((TRUE == ptProcessEventArg->bIsItDbusAck) && (FC_PHONE_DBUS_STATUS_SUCCESS != ptProcessEventArg->Status))
   {
      AudioTransferStatus = TRUE;
   }

   bRetVal = bProcessEvent(u16EventId) ;

   return bRetVal ;
}

/*******************************************************************************
 *
 * FUNCTION: bProcessEvent
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tBool fc_phone_tclSMIdle::bProcessEvent(tU16 u16EventId)
{
   ETG_TRACE_USR4(("fc_phone_tclSMIdle::bProcessEvent u16EventId: %d", u16EventId));
   switch (m_u16State)
   {
      case FC_PHONE_SMIDLE_STATE_IDLE:
      {
         ETG_TRACE_USR2(("state :: FC_PHONE_SMIDLE_STATE_IDLE "));
         vHandleEventInIdle(u16EventId);
      }
      break;
      
      case FC_PHONE_SMIDLE_STATE_WAIT_FOR_CALLSTATUS_RINGING:
      {
         ETG_TRACE_USR2(("state :: FC_PHONE_SMIDLE_STATE_WAIT_FOR_CALLSTATUS_RINGING "));
         vHandleEventInWaitforCallStatusRinging(u16EventId);
      }
      break;
      
      case FC_PHONE_SMIDLE_STATE_WAIT_FOR_PHONEBOOKRESPONSE_OR_RINGTONEACTIVATED:
      {
         ETG_TRACE_USR2(("state :: FC_PHONE_SMIDLE_STATE_WAIT_FOR_PHONEBOOKRESPONSE_OR_RINGTONEACTIVATED "));
         vHandleEventPhoneBookResponseOrRingtoneActivated(u16EventId);
      }
      break;
      
      case FC_PHONE_SMIDLE_STATE_WAIT_FOR_PHONEBOOKRESPONSE:
      {
         ETG_TRACE_USR2((" state :: FC_PHONE_SMIDLE_STATE_WAIT_FOR_PHONEBOOKRESPONSE "));
         vHandleEventPhoneBookResponse(u16EventId);
      }
      break;
      
      case FC_PHONE_SMIDLE_STATE_WAIT_FOR_RINGTONEACTIVATED:
      {
         ETG_TRACE_USR2((" state :: FC_PHONE_SMIDLE_STATE_WAIT_FOR_RINGTONEACTIVATED "));
         vHandleEventRingtoneActivated(u16EventId);
      }
      break;

      case FC_PHONE_SMIDLE_STATE_RINGING:
      {
         ETG_TRACE_USR2(("state :: FC_PHONE_SMIDLE_STATE_RINGING "));
         vHandleEventInRinging(u16EventId);
      }
      break;
      
      case FC_PHONE_SMIDLE_STATE_WAIT_FOR_HOLD_RESPONE:
      {
         ETG_TRACE_USR2(("state :: FC_PHONE_SMIDLE_STATE_WAIT_FOR_HOLD_RESPONE "));
         vHandleEventInHoldResponse(u16EventId);
      }
      break;
      
      case FC_PHONE_SMIDLE_STATE_WAIT_FOR_AM_RESPONSE_ALERTTONE:
      {
         ETG_TRACE_USR2(("state :: FC_PHONE_SMIDLE_STATE_WAIT_FOR_AM_RESPONSE_ALERTTONE "));
         vHandleEventInAMAlertTone(u16EventId);
      }
      break;
      
      case FC_PHONE_SMIDLE_STATE_WAIT_FOR_ALERTTONE_PLAYSTATE:
      {
         ETG_TRACE_USR2(("state :: FC_PHONE_SMIDLE_STATE_WAIT_FOR_ALERTTONE_PLAYSTATE "));
         vHandleAlertToneStateInPlayState();
      }
      break;
      
      case FC_PHONE_SMIDLE_STATE_WAIT_FOR_ALERTTONE_STOPSTATE:
      {
         ETG_TRACE_USR2(("state :: FC_PHONE_SMIDLE_STATE_WAIT_FOR_ALERTTONE_STOPSTATE "));
         vHandleAlertToneStateInStopState();
      }
      break;
      
      case FC_PHONE_SMIDLE_STATE_WAIT_FOR_AM_ALERTTONE_REQTIMEOUT:
      {
         ETG_TRACE_USR2(("state :: FC_PHONE_SMIDLE_STATE_WAIT_FOR_AM_ALERTTONE_REQTIMEOUT "));
         vHandleEventInAMAlertReqTimeOut(u16EventId);
      }
      break;
      
      case FC_PHONE_SMIDLE_STATE_ALERTTONE_PLAYING:
      {
         ETG_TRACE_USR2(("state :: FC_PHONE_SMIDLE_STATE_ALERTTONE_PLAYING "));
         vHandleEventInAlertTonePlay(u16EventId);
      }
      break;
      
      case FC_PHONE_SMIDLE_STATE_ALERTTONE_PAUSED:
      {
         ETG_TRACE_USR2(("state :: FC_PHONE_SMIDLE_STATE_ALERTTONE_PAUSED "));
         vHandleEventInAlertTonePause(u16EventId);
      }
      break;
      
      case FC_PHONE_SMIDLE_STATE_WAIT_FOR_RINGMUTEACK:
      {
         ETG_TRACE_USR2(("state :: FC_PHONE_SMIDLE_STATE_WAIT_FOR_RINGMUTEACK "));
         vHandleEventInRingMuteAck(u16EventId);
      }
      break;

      case FC_PHONE_SMIDLE_STATE_RINGTONE_MUTED:
      {
         ETG_TRACE_USR2(("state :: FC_PHONE_SMIDLE_STATE_RINGTONE_MUTED "));
         vHandleEventInRingMuted(u16EventId);
      }
      break;
      
      case FC_PHONE_SMIDLE_STATE_WAIT_FOR_RINGUNMUTEACK:
      {
         ETG_TRACE_USR2(("state :: FC_PHONE_SMIDLE_STATE_WAIT_FOR_RINGUNMUTEACK "));
         vHandleEventInRingUnMuteAck(u16EventId);
      }
      break;
      
      case FC_PHONE_SMIDLE_STATE_WAIT_FOR_RELEASE_ALERTTONE:
      {
         ETG_TRACE_USR2(("state :: FC_PHONE_SMIDLE_STATE_WAIT_FOR_RELEASE_ALERTTONE "));
         vHandleEventInAlertToneRelease(u16EventId);
      }
      break;
      
      case FC_PHONE_SMIDLE_STATE_WAIT_FOR_SLC_OFF_RESPONSE:
      {
         ETG_TRACE_USR2(("state :: FC_PHONE_SMIDLE_STATE_WAIT_FOR_SLC_OFF_RESPONSE "));
         vHandleEventInSLCOffResponse(u16EventId);
      }
      break;

      case FC_PHONE_SMIDLE_STATE_ROUTING_INCOMINGCALL_IN_HANDSET:
      {
         ETG_TRACE_USR2(("state :: FC_PHONE_SMIDLE_STATE_ROUTING_INCOMINGCALL_IN_HANDSET "));
         vHandleEventInRoutingHandsetCall(u16EventId);
      }
      break;

      case FC_PHONE_SMIDLE_STATE_WAIT_FOR_INCOMINGCALL_TERMINATE:
      {
         ETG_TRACE_USR2(("state :: FC_PHONE_SMIDLE_STATE_WAIT_FOR_INCOMINGCALL_TERMINATE "));
         vHandleEventInTerminateIncomingCall(u16EventId);
      }
      break;

      case FC_PHONE_SMIDLE_STATE_WAIT_FOR_AUDIO_RELEASE_AND_INIT_IDLE:
      {
         ETG_TRACE_USR2((" STATE :: FC_PHONE_SMIDLE_STATE_WAIT_FOR_AUDIO_RELEASE_AND_INIT_IDLE "));
         vHandleEventInReleasingAudioAndReInitIdle(u16EventId);
      }
      break;
      
      case FC_PHONE_SMIDLE_STATE_WAIT_FOR_AM_RESPONSE_ACTIVATE_VOICE:
      {
         ETG_TRACE_USR2((" STATE :: FC_PHONE_SMIDLE_STATE_WAIT_FOR_AM_RESPONSE_ACTIVATE_VOICE "));
         vHandleEventInAMInActivateVoiceCall(u16EventId);
      }
      break;
      
      case FC_PHONE_SMIDLE_STATE_WAIT_FOR_CONNECT_FROM_BT:
      {
         ETG_TRACE_USR2((" STATE :FC_PHONE_SMIDLE_STATE_WAIT_FOR_CONNECT_FROM_BT "));
         vHandleEventInSMIdleBTInCall(u16EventId);
      }
      break;

         // Bugfix for GMMY16-10666
      case FC_PHONE_SMIDLE_STATE_ALERT_TONE_RELEASED:
      {
         ETG_TRACE_USR2((" STATE :FC_PHONE_SMIDLE_STATE_ALERT_TONE_RELEASED "));

         //Fix for CMG3GB-3184. "Start Waiting mode" has to be handled in the state FC_PHONE_SMIDLE_STATE_ALERT_TONE_RELEASED
         vHandleEventInSMIdleAlertToneReleased(u16EventId);
      }
      break;
      
        //Fix for PSARCCB-3030 . Play ringtone for the second incoming call, when first active call is disconnected.
      case FC_PHONE_SMIDLE_STATE_RELEASE_ALERT_ACTIVATE_RINGTONE:
      {
         ETG_TRACE_USR2((" STATE :FC_PHONE_SMIDLE_STATE_RELEASE_ALERT_ACTIVATE_RINGTONE "));

         vHandleEventInSMIdleReleaseAlertTone(u16EventId);
      }
      break;

      default:
      {
         ETG_TRACE_USR4((" fc_phone_tclSMIdle::bProcessEvent DEFAULT u16EventId: %d", u16EventId));
      }
   }
   
   tBool bRetVal = m_bEventConsumed;
   m_bEventConsumed = FALSE;
   return bRetVal;
}

/*******************************************************************************
 *
 * FUNCTION: vHandleEventInSMIdleBTInCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMIdle::vHandleEventInSMIdleBTInCall(tU16 u16EventId)
{
   ETG_TRACE_USR4(("fc_phone_tclSMIdle::vHandleEventInSMIdleBTInCall u16EventId %d",u16EventId));
   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK :
      {
         ETG_TRACE_USR4((" EVENT :: FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK ,START corresponding (dial/Accept) SM "));
         if(AudioTransferStatus == TRUE)
         {
            m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
            m_poCallInstance->m_bUsingVehicleAudio = FALSE;
            ETG_TRACE_USR3(("UsingVehicleAudio = FALSE"));
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSFREE,m_poCallInstance);
            m_poSMManager->bRestoreFromActiveCallInHandset(m_poCallInstance->m_u16Id);
            AudioTransferStatus = FALSE;
         }
         else
         {
            m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
            m_poCallInstance->m_bUsingVehicleAudio = TRUE;
            ETG_TRACE_USR3(("UsingVehicleAudio = TRUE"));
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSFREE,m_poCallInstance);
            m_poSMManager->bRestoreFromActiveCallInHandset(m_poCallInstance->m_u16Id);
         }
      }
      break;
      default:
      {
         ETG_TRACE_USR4((" fc_phone_tclSMIdle::vHandleEventInSMIdleBTInCall DEFAULT "));
      }
      break;
   }
}

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMIdle::vHandleEventInAMInActivateVoiceCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMIdle::vHandleEventInAMInActivateVoiceCall(tU16 u16EventId)
{

   ETG_TRACE_USR4(("fc_phone_tclSMIdle::vHandleEventInAMInActivateVoiceCall u16EventId %d",u16EventId));
   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
      {
         ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_PHONE_REQUEST_OK"));
         /* Receiving audio channel is complete */
         m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
         m_poCallInstance->m_bUsingVehicleAudio = TRUE;
         ETG_TRACE_USR3(("UsingVehicleAudio = TRUE"));
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO, m_poCallInstance);
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, m_poCallInstance);
         //Transfer Audio
         m_u16State = FC_PHONE_SMIDLE_STATE_WAIT_FOR_CONNECT_FROM_BT;
         ETG_TRACE_USR2(("State Change: FC_PHONE_SMIDLE_STATE_WAIT_FOR_CONNECT_FROM_BT"));
         m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId), FC_PHONE_CALLTRANSFER_FROMHANDSET_TOHANSFREE);
      }
      break;
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK:
      {
         ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK"));
         /* TO DO:Transfer the call to handset */
         m_poCallInstance->m_bUsingVehicleAudio = FALSE;
         ETG_TRACE_USR3(("UsingVehicleAudio = FALSE "));
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO, m_poCallInstance);
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, m_poCallInstance);
         m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSET,m_poCallInstance);
         m_u16State = FC_PHONE_SMIDLE_STATE_ROUTING_INCOMINGCALL_IN_HANDSET;
         ETG_TRACE_USR2(("State change: FC_PHONE_SMIDLE_STATE_ROUTING_INCOMINGCALL_IN_HANDSET"));
      }
      break;
      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMIdle::vHandleEventInAMInActivateVoiceCall: IN DEFAULT u16EventId %d",u16EventId));
      }
      break;
   }
}


/*******************************************************************************
 *
 * FUNCTION: vHandleEventInRoutingHandsetCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMIdle::vHandleEventInRoutingHandsetCall(tU16 u16EventId)
{
   ETG_TRACE_USR4(("fc_phone_tclSMIdle::vHandleEventInRoutingHandsetCall u16EventId %d",u16EventId));

   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_INCOMINGCALL_REQUEST_OK:
      case FC_PHONE_SM_EVENT_ALERT_REQUEST_OK:
      {
         ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_INCOMINGCALL_REQUEST_OK"));
         ETG_TRACE_USR3(("  EVENT : OR FC_PHONE_SM_EVENT_ALERT_REQUEST_OK"));
         m_bEventConsumed = TRUE ;
         //Update the audio channel status
         m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED ;
         m_poCallInstance->m_bUsingVehicleAudio = FALSE;
         ETG_TRACE_USR3(("UsingVehicleAudio = FALSE "));
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,\
               m_poCallInstance);


      }
      break;

      case FC_PHONE_SM_EVENT_INCOMINGCALL_REQUEST_NOK:
      case FC_PHONE_SM_EVENT_ALERT_REQUEST_NOK:
      {

         ETG_TRACE_USR3((" EVENT : FC_PHONE_SM_EVENT_INCOMINGCALL_REQUEST_NOK"));
         ETG_TRACE_USR3(("  EVENT :OR  FC_PHONE_SM_EVENT_ALERT_REQUEST_NOK"));
         m_bEventConsumed = TRUE ;
         /* TO DO:Transfer the call to handset */
         m_poCallInstance->m_bUsingVehicleAudio = TRUE;
         ETG_TRACE_USR3(("UsingVehicleAudio = TRUE "));
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,\
               m_poCallInstance);

      }
      break;
      case FC_PHONE_SM_EVENT_IF_HANDSETCALL_TRANSFER_TOVEHICLE:
      {
         ETG_TRACE_USR3((" EVENT :: FC_PHONE_SM_EVENT_IF_HANDSETCALL_TRANSFER_TOVEHICLE "));
         m_bEventConsumed = TRUE ;
         //Acquire Audio
         //Transfer Audio to Vehicle
         //Start corresponding SM (Dial/Accept)
         m_u16State = FC_PHONE_SMIDLE_STATE_WAIT_FOR_AM_RESPONSE_ACTIVATE_VOICE ;
         ETG_TRACE_USR2(("State change: FC_PHONE_SMIDLE_STATE_WAIT_FOR_AM_RESPONSE_ACTIVATE_VOICE"));
         m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
         ETG_TRACE_USR3(("Request Audio ...AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE "));
         m_poAudioManager->s32GetRequest(m_poCallInstance->m_u16Id,FC_PHONE_AUDIOCHANNEL_PHONE,vAudioCallBackIdle);
#ifndef PHONE_USE_AVM
         //calling audio call back from here,
         //once AV manager working this callback will be called from AV manager
         vAudioCallBackIdle(m_poCallInstance->m_u16Id,FC_PHONE_AUDIOCHANNEL_PHONE ,FC_PHONE_AUDIOCHANNEL_GRANTED);
#endif //PHONE_USE_AVM

      }
      break;
      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMIdle::vHandleEventInRoutingHandsetCall: default u16EventId %d",u16EventId));
         m_bEventConsumed = FALSE ;

      }
      break;
   }




}

/*******************************************************************************
 *
 * FUNCTION: vHandleEventInIdle
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMIdle::vHandleEventInIdle(tU16 u16EventId)
{
   ETG_TRACE_USR4(("fc_phone_tclSMIdle::vHandleEventInIdle u16EventId %d",u16EventId));

   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_DBUS_INCOMINGCALL_ACK_OK:
      {
         ETG_TRACE_USR3((" EVENT::FC_PHONE_SM_EVENT_DBUS_INCOMINGCALL_ACK_OK "));
         m_bEventConsumed = TRUE ;
         m_u16State = FC_PHONE_SMIDLE_STATE_WAIT_FOR_CALLSTATUS_RINGING;
         ETG_TRACE_USR2(("State change: FC_PHONE_SMIDLE_STATE_WAIT_FOR_CALLSTATUS_RINGING"));
      }
      break;
      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMIdle::vHandleEventInIdle DEFAULT u16EventId %d",u16EventId));
         m_bEventConsumed = FALSE ;
      }
      break;
   }
}
/*******************************************************************************
 *
 * FUNCTION: vHandleEventInWaitforCallStatusRinging
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMIdle::vHandleEventInWaitforCallStatusRinging(tU16 u16EventId)
{
   ETG_TRACE_USR4(("fc_phone_tclSMIdle::vHandleEventInWaitforCallStatusRinging u16EventId %d",u16EventId));

   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_CALLSTATUS_RINGING:
      {
         ETG_TRACE_USR3((" EVENT::FC_PHONE_SM_EVENT_CALLSTATUS_RINGING "));
         m_bEventConsumed = TRUE ;
         tU16 CommandCounterID = 0;
         if(FALSE == m_poAudioManager->bGetPriorityChannel())
         {
            /* Activate a call instance */
            m_poCallInstance->m_u8ObjectState = \
                  FC_PHONE_CALLINSTANCE_OBJECTSTATE_ACTIVE;

            /* Assign an CallInstanceId */
            // m_poCallInstance->m_u16Id = 0x00; /* To be generated */

            /* Update Incoming Call Event Field */
            m_poCallInstance->m_u16IncomingCallEvent = \
                  FC_PHONE_CALLINSTANCE_INCOMINGCALLEVENT_RINGING;

            //m_u16State = FC_PHONE_SMIDLE_STATE_WAIT_FOR_AM_RESPONSE_INCOMINGCALL;
            m_u16State = FC_PHONE_SMIDLE_STATE_WAIT_FOR_PHONEBOOKRESPONSE_OR_RINGTONEACTIVATED;
            ETG_TRACE_USR2(("State change: FC_PHONE_SMIDLE_STATE_WAIT_FOR_PHONEBOOKRESPONSE_OR_RINGTONEACTIVATED"));

            //Request phonebook for the names of corresponding Number
            tU8  u8DeviceHandle = (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->u8GetActiveDeviceHandle();
            fc_phone_tclClientHandler_PhoneBook *p_clientHndler_phonebook = (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerPhoneBook ;
            p_clientHndler_phonebook->vSearchPhoneBook(u8DeviceHandle,m_poCallInstance->m_strCellNumber,CommandCounterID);


            // m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_INCOMINGCALL,m_poCallInstance);

            //Request AVmanager for RingTone/AlertTone

            if(TRUE == m_poCallInstance->m_bcallWaitingState )
            {
               ETG_TRACE_USR4((" Requesting for  ALERT TONE "));
               m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ALERTTONE;
               ETG_TRACE_USR3(("Request Audio ...AudioChannel = FC_PHONE_AUDIOCHANNEL_ALERTTONE "));
               m_poAudioManager->s32GetRequest(m_poCallInstance->m_u16Id,FC_PHONE_AUDIOCHANNEL_ALERTTONE,vAudioCallBackIdle);
               //NCG3D-142658 : Incrementing the Channel acquisition counter for Phone channel.
               fc_phone_tclClientHandler_BTSettings *p_clientHndler_bluetooth = (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerBTSettings;
               tU16 bInBandRingtone = p_clientHndler_bluetooth->vIsInBandRingtone();
               if(bInBandRingtone)
               {
                  ETG_TRACE_USR4((" SMIdle: Updating acquisition counter"));
                  m_poAudioManager->vUpdateChannelAttributes(FC_PHONE_AUDIOCHANNEL_PHONE, FC_PHONE_REQUESTTYPE_GET);
               }
            }
            else
            {
               ETG_TRACE_USR4((" Requesting for  INCOMINGRING TONE "));
               m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_INCOMINGRINGTONE;
               ETG_TRACE_USR3(("Request Audio ...AudioChannel = FC_PHONE_AUDIOCHANNEL_INCOMINGRINGTONE "));
               m_poAudioManager->s32GetRequest(m_poCallInstance->m_u16Id,FC_PHONE_AUDIOCHANNEL_INCOMINGRINGTONE,vAudioCallBackIdle);
            }
         }
         else
         {
            ETG_TRACE_USR4(("  Priority FLAG ON.... terminate incoming call  "));

            m_u16State = FC_PHONE_SMIDLE_STATE_WAIT_FOR_INCOMINGCALL_TERMINATE ;
            ETG_TRACE_USR2(("State change: FC_PHONE_SMIDLE_STATE_WAIT_FOR_INCOMINGCALL_TERMINATE"));
            m_pDbusIf->bRejectCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId), FC_PHONE_DBUS_IGNORE_SINGLECALL);

         }



      }
      break;
      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMIdle::vHandleEventInWaitforCallStatusRinging IN DEFAULT  u16EventId %d",u16EventId));
         m_bEventConsumed = FALSE ;
      }
      break;
   }
}
/*******************************************************************************
 *
 * FUNCTION: vHandleEventPhoneBookResponseOrRingtoneActivated
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMIdle::vHandleEventPhoneBookResponseOrRingtoneActivated(tU16 u16EventId)
{
   ETG_TRACE_USR4(("fc_phone_tclSMIdle::vHandleEventPhoneBookResponseOrRingtoneActivated u16EventId %d",u16EventId));
   m_bEventConsumed = TRUE ;
   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_ALERT_REQUEST_OK :
      case FC_PHONE_SM_EVENT_INCOMINGCALL_REQUEST_OK:
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
      {
         // got AVManager Response : wait for phonebook response
         ETG_TRACE_USR3((" EVENT::FC_PHONE_SM_EVENT_INCOMINGCALL_REQUEST_OK "));

         /* Recieving audio channel is complete */
         /* THis ends incoming call notification */
         m_u16State = FC_PHONE_SMIDLE_STATE_WAIT_FOR_PHONEBOOKRESPONSE;
         ETG_TRACE_USR2(("State change: FC_PHONE_SMIDLE_STATE_WAIT_FOR_PHONEBOOKRESPONSE"));

         /* Fix for GMMY15-10552 Incoming call alert is delayed */
         (fc_phone_tclApp::m_poMainAppInstance)->m_poTimer->s32Start(
               FC_PHONE_INCOMINGCALLALERT_TIMER_ID, FC_PHONE_ONE_SECOND * 2,
               vTimerCallBackIncCallAlert);

         if(FC_PHONE_SM_EVENT_ALERT_REQUEST_OK == u16EventId)
         {
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ALERTTONE;
         }
         else if(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK == u16EventId)
         {
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
         }
         else
         {
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_INCOMINGRINGTONE;
         }
         //GMMY15-11943- HMI depends on UsingVehicleAudio to updated handset/hansfree so if call in handset and for acquiring alert channel
         //if vehicle audio is updated as TRUE then Handsfree button toggles to Handset on arrival of Call waiting alert.
         //m_poCallInstance->m_bUsingVehicleAudio = TRUE;
         //  ETG_TRACE_USR3(("UsingVehicleAudio = TRUE "));
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,\
               m_poCallInstance);
      }
      break;

      case FC_PHONE_SM_EVENT_PHONEBOOK_RESPONSE_OK :
      {
         // got phonebook response :: wait for AVManager Response

         ETG_TRACE_USR3(("EVENT::FC_PHONE_SM_EVENT_PHONEBOOK_RESPONSE_OK "));
         m_u16State = FC_PHONE_SMIDLE_STATE_WAIT_FOR_RINGTONEACTIVATED ;
         ETG_TRACE_USR2(("State change: FC_PHONE_SMIDLE_STATE_WAIT_FOR_RINGTONEACTIVATED"));
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_INCOMINGCALL,m_poCallInstance);

         m_poCallInstance->m_u16CallStatusNotice = FC_PHONE_CALLINSTANCE_CALLSTATUS_RINGTONE;
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
      }
      break;

      case FC_PHONE_SM_EVENT_INCOMINGCALL_REQUEST_NOK:
      case FC_PHONE_SM_EVENT_ALERT_REQUEST_NOK:
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK:
      {
         ETG_TRACE_USR3(("EVENT::FC_PHONE_SM_EVENT_INCOMINGCALL_REQUEST_NOK "));
         /* Now try requesing for ALERT Channel */
         /* Send ALERT Request for AVManager */
         m_u16State = FC_PHONE_SMIDLE_STATE_WAIT_FOR_PHONEBOOKRESPONSE;
         ETG_TRACE_USR2(("State change: FC_PHONE_SMIDLE_STATE_WAIT_FOR_PHONEBOOKRESPONSE"));
         m_bAlertRequestPending = TRUE;
      }
      break;

#ifdef PHONE_WAITINGMODE
      case FC_PHONE_SM_EVENT_START_WAITING_MODE:
      {
         if (FC_PHONE_CALLINSTANCE_INCOMINGCALLEVENT_RINGING == m_poCallInstance->m_u16IncomingCallEvent)
         {
            ETG_TRACE_USR3(("Start the AcceptCall SM"));
            m_poSMManager->vStartSM(FC_PHONE_SMMANAGER_SMID_ACCEPTCALL, m_poCallInstance);
         }
      }
      break;
#endif

      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMIdle::vHandleEventPhoneBookResponseOrRingtoneActivated : DEFAULT u16EventId %d",u16EventId));
         m_bEventConsumed = FALSE ;
      }
      break;
   }
}


/*******************************************************************************
 *
 * FUNCTION: vHandleEventPhoneBookResponse
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMIdle::vHandleEventPhoneBookResponse(tU16 u16EventId)
{
   ETG_TRACE_USR4(("fc_phone_tclSMIdle::vHandleEventPhoneBookResponse u16EventId %d",u16EventId));
   m_bEventConsumed = TRUE ;

   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_PHONEBOOK_RESPONSE_OK:
      {
         ETG_TRACE_USR3((" EVENT::FC_PHONE_SM_EVENT_PHONEBOOK_RESPONSE_OK "));

         /* Fix for GMMY15-10552 Incoming call alert is delayed */
         ETG_TRACE_USR3((" FC_PHONE_INCOMINGCALLALERT_TIMER_ID Timer Stopped "));
         (fc_phone_tclApp::m_poMainAppInstance)->m_poTimer->s32Stop(FC_PHONE_INCOMINGCALLALERT_TIMER_ID);

         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_INCOMINGCALL,m_poCallInstance);
         //send call Status
         m_u16State = FC_PHONE_SMIDLE_STATE_RINGING;
         ETG_TRACE_USR2(("State change: FC_PHONE_SMIDLE_STATE_RINGING"));
         m_poCallInstance->m_u16CallStatusNotice = FC_PHONE_CALLINSTANCE_CALLSTATUS_RINGTONE;
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);

         /* If incoming rintone channel denied, wait for phone book response and request for alert tone */
         if (TRUE == m_bAlertRequestPending)
         {
            m_u16State = FC_PHONE_SMIDLE_STATE_WAIT_FOR_AM_RESPONSE_ALERTTONE;
            ETG_TRACE_USR2(("State change: FC_PHONE_SMIDLE_STATE_WAIT_FOR_AM_RESPONSE_ALERTTONE"));
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ALERTTONE;
            ETG_TRACE_USR3(("Request Audio ...AudioChannel = FC_PHONE_AUDIOCHANNEL_ALERTTONE"));
            m_poAudioManager->s32GetRequest(m_poCallInstance->m_u16Id ,FC_PHONE_AUDIOCHANNEL_ALERTTONE,vAudioCallBackIdle);
            m_bAlertRequestPending = FALSE;
         }
      }
      break;

#ifdef PHONE_WAITINGMODE
      case FC_PHONE_SM_EVENT_START_WAITING_MODE:
      {
         if (FC_PHONE_CALLINSTANCE_INCOMINGCALLEVENT_RINGING == m_poCallInstance->m_u16IncomingCallEvent)
         {
            ETG_TRACE_USR3(("Start the AcceptCall SM"));
            m_poSMManager->vStartSM(FC_PHONE_SMMANAGER_SMID_ACCEPTCALL, m_poCallInstance);
         }
      }
      break;
#endif

      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMIdle::vHandleEventPhoneBookResponse: DEFAULT u16EventId %d",u16EventId));
         m_bEventConsumed = FALSE ;
         ETG_TRACE_ERR((" Error : In default "));

      }
      break;
   }


}

/*******************************************************************************
 *
 * FUNCTION: vHandleEventRingtoneActivated
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMIdle::vHandleEventRingtoneActivated(tU16 u16EventId)
{
   ETG_TRACE_USR4(("fc_phone_tclSMIdle::vHandleEventRingtoneActivated u16EventId %d", u16EventId));
   m_bEventConsumed = TRUE;

   switch (u16EventId)
   {
   //GMMY16-21498
      case FC_PHONE_SM_EVENT_ALERT_REQUEST_OK:
      {
         ETG_TRACE_USR3(("EVENT::FC_PHONE_SM_EVENT_ALERT_REQUEST_OK"));
         m_u16State = FC_PHONE_SMIDLE_STATE_RINGING;
         ETG_TRACE_USR2(("State change: FC_PHONE_SMIDLE_STATE_RINGING"));
         m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ALERTTONE;
         vHandleEventInAMAlertTone(u16EventId);
         /* GMMY15-11943- HMI depends on UsingVehicleAudio to updated handset/hansfree
         * so if call in handset and for acquiring alert channel */
         // If vehicle audio is updated as TRUE then Handsfree button toggles to Handset on arrival of Call waiting alert.
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO, m_poCallInstance);
      }
      break;
      case FC_PHONE_SM_EVENT_INCOMINGCALL_REQUEST_OK:
      {
         ETG_TRACE_USR3(("EVENT::FC_PHONE_SM_EVENT_INCOMINGCALL_REQUEST_OK"));
         m_u16State = FC_PHONE_SMIDLE_STATE_RINGING;
         ETG_TRACE_USR2(("State change: FC_PHONE_SMIDLE_STATE_RINGING"));
         m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_INCOMINGRINGTONE;
         /* GMMY15-11943- HMI depends on UsingVehicleAudio to updated handset/hansfree
          * so if call in handset and for acquiring alert channel */
         // If vehicle audio is updated as TRUE then Handsfree button toggles to Handset on arrival of Call waiting alert.
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO, m_poCallInstance);
      }
      break;

/* SUZUKI-12814 - For in-band ringtone LC_Phone channel will be allocated. On successful allocation of the channel */
// m_u8AudioChannel should be set as FC_PHONE_AUDIOCHANNEL_PHONE instead of FC_PHONE_AUDIOCHANNEL_INCOMINGRINGTONE.
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
      {
         ETG_TRACE_USR3(("EVENT::FC_PHONE_SM_EVENT_PHONE_REQUEST_OK"));
         m_u16State = FC_PHONE_SMIDLE_STATE_RINGING;
         ETG_TRACE_USR2(("State change: FC_PHONE_SMIDLE_STATE_RINGING"));
         m_poCallInstance->m_bUsingVehicleAudio = TRUE;
         ETG_TRACE_USR3(("UsingVehicleAudio = TRUE "));
         m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO, m_poCallInstance);
      }
      break;
      
      case FC_PHONE_SM_EVENT_INCOMINGCALL_REQUEST_NOK:
      {
         ETG_TRACE_USR3(("EVENT::FC_PHONE_SM_EVENT_INCOMINGCALL_REQUEST_NOK"));
         /* Now try requesing for ALERT Channel */
         /* Send ALERT Request for AVManager */
         m_u16State = FC_PHONE_SMIDLE_STATE_WAIT_FOR_AM_RESPONSE_ALERTTONE;
         ETG_TRACE_USR2(("State change: FC_PHONE_SMIDLE_STATE_WAIT_FOR_AM_RESPONSE_ALERTTONE"));
         m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ALERTTONE;
         ETG_TRACE_USR3(("Request AudioChannel = FC_PHONE_AUDIOCHANNEL_ALERTTONE"));
         m_poAudioManager->s32GetRequest(m_poCallInstance->m_u16Id, FC_PHONE_AUDIOCHANNEL_ALERTTONE, vAudioCallBackIdle);
      }
      break;

      case FC_PHONE_SM_EVENT_RINGTONEMUTE:
      {
         ETG_TRACE_USR3((" EVENT::FC_PHONE_SM_EVENT_RINGTONEMUTE "));
         m_u16State = FC_PHONE_SMIDLE_STATE_WAIT_FOR_RINGMUTEACK;
         ETG_TRACE_USR2(("State Change: FC_PHONE_SMIDLE_STATE_WAIT_FOR_RINGMUTEACK"));
         tU16 bInBandRingtone;
         fc_phone_tclClientHandler_BTSettings *p_clientHndler_bluetooth = (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerBTSettings;
         bInBandRingtone = p_clientHndler_bluetooth->vIsInBandRingtone();
         if (bInBandRingtone)
         {
            ETG_TRACE_USR3(("bInBandRingtone so Release AudioChannel FC_PHONE_AUDIOCHANNEL_PHONE"));
            m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id, FC_PHONE_AUDIOCHANNEL_PHONE, vAudioCallBackIdle);
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
         }
         else
         {
            ETG_TRACE_USR3(("Vehicle ringtone so Release AudioChannel FC_PHONE_AUDIOCHANNEL_INCOMINGRINGTONE"));
            m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id, FC_PHONE_AUDIOCHANNEL_INCOMINGRINGTONE, vAudioCallBackIdle);
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
         }
      }
      break;

#ifdef PHONE_WAITINGMODE
         case FC_PHONE_SM_EVENT_START_WAITING_MODE:
         {
            if (FC_PHONE_CALLINSTANCE_INCOMINGCALLEVENT_RINGING == m_poCallInstance->m_u16IncomingCallEvent)
            {
               ETG_TRACE_USR3(("Start the AcceptCall SM"));
               m_poSMManager->vStartSM(FC_PHONE_SMMANAGER_SMID_ACCEPTCALL, m_poCallInstance);
            }
         }
         break;
#endif

      default:
      {
         m_bEventConsumed = FALSE;
         ETG_TRACE_ERR((" Error : In default"));
      }
   }
}

/*******************************************************************************
 *
 * FUNCTION: vHandleEventInAMAlertTone
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMIdle::vHandleEventInAMAlertTone(tU16 u16EventId)
{
   ETG_TRACE_USR4(("fc_phone_tclSMIdle::vHandleEventInAMAlertTone u16EventId %d",u16EventId));
   m_bEventConsumed = TRUE ;

   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_ALERT_REQUEST_OK:
      {

         ETG_TRACE_USR4((" EVENT::FC_PHONE_SM_EVENT_ALERT_REQUEST_OK "));

         m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ALERTTONE;
         //GMMY15-11943- HMI depends on UsingVehicleAudio to updated handset/hansfree so if call in handset and for acquiring alert channel
         //if vehicle audio is updated as TRUE then Handsfree button toggles to Handset on arrival of Call waiting alert.
         // m_poCallInstance->m_bUsingVehicleAudio = TRUE;
         //ETG_TRACE_USR3(("UsingVehicleAudio = TRUE "));
         ETG_TRACE_USR3(("Sending vehicle audio status "));
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,\
               m_poCallInstance);


         // No alert tone support. Hence FC_PHONE_AUDIOCHANNEL_ALERTTONE channel is simply released and the state is changed.
         // Else PlayAlerttone interface should be called from here.

         ETG_TRACE_USR3(("Release alert tone channel..."));
         m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id, FC_PHONE_AUDIOCHANNEL_ALERTTONE, vAudioCallBackIdle);
         m_poCallInstance->m_u8AudioChannel
         = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
         ETG_TRACE_USR3(("AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED"));
         m_u16State = FC_PHONE_SMIDLE_STATE_ALERT_TONE_RELEASED;
         ETG_TRACE_USR2(("State change: FC_PHONE_SMIDLE_STATE_ALERT_TONE_RELEASED"));
      }
      break;
      case FC_PHONE_SM_EVENT_ALERT_REQUEST_NOK:
      {
         ETG_TRACE_USR3((" EVENT::FC_PHONE_SM_EVENT_ALERT_REQUEST_NOK "));
         /* retry getting the ALERT channel FC_PHONE_ALERT_CHANNEL_REQUEST_RETRY_COUNT times */
         if(0x00 == m_u16AlertCountRetry)
         {
            ETG_TRACE_USR4((" No Alert tone channel acquired after retry - wait for user to accept/reject or call to end "));
            //m_u16State = FC_PHONE_SMIDLE_STATE_IDLE;

            //m_u16State = FC_PHONE_SMIDLE_STATE_WAIT_FOR_RELEASE_ALERTTONE ;
            //release alert Tone
            //m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id,FC_PHONE_AUDIOCHANNEL_ALERTTONE,vAudioCallBackIdle);

         }
         else
         {
            m_u16State = FC_PHONE_SMIDLE_STATE_WAIT_FOR_AM_ALERTTONE_REQTIMEOUT;
            ETG_TRACE_USR2((" State change: FC_PHONE_SMIDLE_STATE_WAIT_FOR_AM_ALERTTONE_REQTIMEOUT "));
            m_u16AlertCountRetry --;
         }
      }
      break;
      case FC_PHONE_SM_EVENT_HOLDCALL_REQUEST:
      {
         if(TRUE == m_bTimerRunning)
         {
            m_poTimer->s32Stop(m_poCallInstance->m_u16TimerId); // Bugfix for GMMY16-17241
            m_bTimerRunning = FALSE;
            ETG_TRACE_USR3(("m_bTimerRunning = FALSE"));
         }
         ETG_TRACE_USR3((" EVENT::FC_PHONE_SM_EVENT_HOLDCALL_REQUEST "));

         m_u16State = FC_PHONE_SMIDLE_STATE_WAIT_FOR_HOLD_RESPONE;
         ETG_TRACE_USR2((" State change: FC_PHONE_SMIDLE_STATE_WAIT_FOR_HOLD_RESPONE "));
         m_pDbusIf->bHoldIncomingCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId));
      }
      break;
      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMIdle::vHandleEventInAMAlertTone DEFAULT  u16EventId %d",u16EventId));
         m_bEventConsumed = FALSE ;
      }
      break;
   }
}
/*******************************************************************************
 *
 * FUNCTION: vHandleEventInAVMAlertReqTimeOut
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMIdle::vHandleEventInAMAlertReqTimeOut(tU16 u16EventId)
{
   ETG_TRACE_USR4(("fc_phone_tclSMIdle::vHandleEventInAMAlertReqTimeOut u16EventId %d",u16EventId));
   m_bEventConsumed = TRUE ;
   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_TIMER_EXPIRED:
      {
         ETG_TRACE_USR3((" EVENT::FC_PHONE_SM_EVENT_TIMER_EXPIRED "));

         /* retry getting the ALERT channel FC_PHONE_ALERT_CHANNEL_REQUEST_RETRY_COUNT times */
         if(0x00 == m_u16AlertCountRetry)
         {
            m_u16State = FC_PHONE_SMIDLE_STATE_DISPLAY_ONLY_PROMPT;
            ETG_TRACE_USR2(("State change: FC_PHONE_SMIDLE_STATE_DISPLAY_ONLY_PROMPT"));
         }
         else
         {
            m_u16State = FC_PHONE_SMIDLE_STATE_WAIT_FOR_AM_RESPONSE_ALERTTONE;
            ETG_TRACE_USR2(("State change: FC_PHONE_SMIDLE_STATE_WAIT_FOR_AM_RESPONSE_ALERTTONE "));
            m_u16AlertCountRetry --;
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ALERTTONE;
            ETG_TRACE_USR3(("Request Audio ...AudioChannel = FC_PHONE_AUDIOCHANNEL_ALERTTONE"));
            m_poAudioManager->s32GetRequest(m_poCallInstance->m_u16Id,FC_PHONE_AUDIOCHANNEL_ALERTTONE,vAudioCallBackIdle);
         }

      }
      break;

      case FC_PHONE_SM_EVENT_HOLDCALL_REQUEST:
      {
         if(TRUE == m_bTimerRunning)
         {
            m_poTimer->s32Stop(m_poCallInstance->m_u16TimerId); // Bugfix for GMMY16-17241
            m_bTimerRunning = FALSE;
            ETG_TRACE_USR3(("m_bTimerRunning = FALSE"));
         }
         ETG_TRACE_USR3((" EVENT::FC_PHONE_SM_EVENT_HOLDCALL_REQUEST "));

         m_u16State = FC_PHONE_SMIDLE_STATE_WAIT_FOR_HOLD_RESPONE;
         ETG_TRACE_USR2(("State change: FC_PHONE_SMIDLE_STATE_WAIT_FOR_HOLD_RESPONE"));
         m_pDbusIf->bHoldIncomingCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId));
      }
      break;

      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMIdle::vHandleEventInAMAlertReqTimeOut: IN DEFAULT  u16EventId %d",u16EventId));
         m_bEventConsumed = FALSE ;
      }
      break;
   }

}
/*******************************************************************************
 *
 * FUNCTION: vHandleEventInAlertTonePlay
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMIdle::vHandleEventInAlertTonePlay(tU16 u16EventId)
{
   ETG_TRACE_USR4(("fc_phone_tclSMIdle::vHandleEventInAlertTonePlay u16EventId %d",u16EventId));
   m_bEventConsumed = TRUE ;
   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_TIMER_EXPIRED:
      {
         ETG_TRACE_USR3((" EVENT::FC_PHONE_SM_EVENT_TIMER_EXPIRED "));

         // TODO: If the Alerttone playable count is over(which is configured), the Alerttone has to be stopped
         /*
             m_u16State = FC_PHONE_SMIDLE_STATE_WAIT_FOR_ALERTTONE_STOPSTATE;
            ETG_TRACE_USR2(("State change: FC_PHONE_SMIDLE_STATE_WAIT_FOR_ALERTTONE_STOPSTATE"));

            // Stop the alert tone playing
            vStopAlertTone();
          */
      }
      break;

      case FC_PHONE_SM_EVENT_HOLDCALL_REQUEST:
      {
         if(TRUE == m_bTimerRunning)
         {
            m_poTimer->s32Stop(m_poCallInstance->m_u16TimerId); // Bugfix for GMMY16-17241
            m_bTimerRunning = FALSE;
            ETG_TRACE_USR3(("m_bTimerRunning = FALSE"));
         }
         ETG_TRACE_USR3((" EVENT::FC_PHONE_SM_EVENT_HOLDCALL_REQUEST "));

         m_u16State = FC_PHONE_SMIDLE_STATE_WAIT_FOR_HOLD_RESPONE;
         ETG_TRACE_USR2(("State change: FC_PHONE_SMIDLE_STATE_WAIT_FOR_HOLD_RESPONE"));
         m_pDbusIf->bHoldIncomingCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId));
      }
      break;

      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMIdle::vHandleEventInAlertTonePlay DEFAULT u16EventId %d",u16EventId));
         m_bEventConsumed = FALSE ;
      }
      break;
   }

}

/*******************************************************************************
 *
 * FUNCTION: vHandleEventInAlertTonePause
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMIdle::vHandleEventInAlertTonePause(tU16 u16EventId)
{
   ETG_TRACE_USR4(("fc_phone_tclSMIdle::vHandleEventInAlertTonePause u16EventId %d", u16EventId));

   m_bEventConsumed = TRUE ;

   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_TIMER_EXPIRED:
      {
         /* Bugfix for GMMY16-10666: Media song is played for the duration of Incoming
          * call alert, if a call is initiated while message is being read aloud */
         m_u16State = FC_PHONE_SMIDLE_STATE_WAIT_FOR_ALERTTONE_PLAYSTATE;
         ETG_TRACE_USR2(("State change: FC_PHONE_SMIDLE_STATE_WAIT_FOR_ALERTTONE_PLAYSTATE"));

         // TODO: PlayAlertTone interface has to be called
         //FC_Phone_PlayerEngine *m_poAlertTonePlayer = (fc_phone_tclApp::m_poMainAppInstance)->m_poAlertTonePlayer;
         //m_poAlertTonePlayer->PlayAlertTone(ALERTTONE_FILE_PATH);
         m_bAlertPlaying = TRUE;
      }
      break;

      case FC_PHONE_SM_EVENT_HOLDCALL_REQUEST:
      {
         if(TRUE == m_bTimerRunning)
         {
            m_poTimer->s32Stop(m_poCallInstance->m_u16TimerId); // Bugfix for GMMY16-17241
            m_bTimerRunning = FALSE;
            ETG_TRACE_USR3(("m_bTimerRunning = FALSE"));
         }
         ETG_TRACE_USR3((" EVENT::FC_PHONE_SM_EVENT_HOLDCALL_REQUEST "));

         m_u16State = FC_PHONE_SMIDLE_STATE_WAIT_FOR_HOLD_RESPONE;
         ETG_TRACE_USR2(("State Change: FC_PHONE_SMIDLE_STATE_WAIT_FOR_HOLD_RESPONE"));
         m_pDbusIf->bHoldIncomingCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId));
      }
      break;

      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMIdle::vHandleEventInAlertTonePause DEFAULT  u16EventId %d",u16EventId));
         m_bEventConsumed = FALSE;
      }
      break;
   }
}

/*******************************************************************************
 *
 * FUNCTION: vHandleEventInRinging
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMIdle::vHandleEventInRinging(tU16 u16EventId)
{
   ETG_TRACE_USR4(("fc_phone_tclSMIdle::vHandleEventInRinging u16EventId %d",u16EventId));
   m_bEventConsumed = TRUE ;

   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_HOLDCALL_REQUEST:
      {
         ETG_TRACE_USR3((" EVENT::FC_PHONE_SM_EVENT_HOLDCALL_REQUEST "));

         m_u16State = FC_PHONE_SMIDLE_STATE_WAIT_FOR_HOLD_RESPONE;
         ETG_TRACE_USR2(("State Change: FC_PHONE_SMIDLE_STATE_WAIT_FOR_HOLD_RESPONE"));
         m_pDbusIf->bHoldIncomingCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId));
      }
      break;
      case FC_PHONE_SM_EVENT_RINGTONEMUTE:
      {
         ETG_TRACE_USR3((" EVENT::FC_PHONE_SM_EVENT_RINGTONEMUTE "));

         m_u16State = FC_PHONE_SMIDLE_STATE_WAIT_FOR_RINGMUTEACK;
         ETG_TRACE_USR2(("State Change: FC_PHONE_SMIDLE_STATE_WAIT_FOR_RINGMUTEACK"));
         ETG_TRACE_USR3(("Release Audio .."));
         tU16 bInBandRingtone;
         fc_phone_tclClientHandler_BTSettings *p_clientHndler_bluetooth = (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerBTSettings;
         bInBandRingtone = p_clientHndler_bluetooth->vIsInBandRingtone();
         if(bInBandRingtone)
         {
            //Since same SourceNr and channel is used for Inabnd ringtone and the phone audio so use FC_PHONE_AUDIOCHANNEL_PHONE
            ETG_TRACE_USR3(("bInBandRingtone so Release AudioChannel FC_PHONE_AUDIOCHANNEL_PHONE"));
            m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id, FC_PHONE_AUDIOCHANNEL_PHONE, vAudioCallBackIdle);
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
         }
         else
         {
            ETG_TRACE_USR3(("Vehicle ringtone so Release AudioChannel FC_PHONE_AUDIOCHANNEL_INCOMINGRINGTONE"));
            m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id, FC_PHONE_AUDIOCHANNEL_INCOMINGRINGTONE, vAudioCallBackIdle);
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;

         }
      }
      break;

#ifdef PHONE_WAITINGMODE
      case FC_PHONE_SM_EVENT_START_WAITING_MODE:
      {
         if (FC_PHONE_CALLINSTANCE_INCOMINGCALLEVENT_RINGING == m_poCallInstance->m_u16IncomingCallEvent)
         {
            ETG_TRACE_USR3(("Start the AcceptCall SM"));
            m_poSMManager->vStartSM(FC_PHONE_SMMANAGER_SMID_ACCEPTCALL, m_poCallInstance);
         }
      }
      break;
#endif

      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMIdle::vHandleEventInRinging DEFAULT u16EventId %d",u16EventId));
         m_bEventConsumed = FALSE ;
      }
      break;
   }

}

/*******************************************************************************
 *
 * FUNCTION: vHandleEventInSMIdleAlertToneReleased
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMIdle::vHandleEventInSMIdleAlertToneReleased(tU16 u16EventId)
{
   ETG_TRACE_USR4(("fc_phone_tclSMIdle::vHandleEventInSMIdleAlertToneReleased u16EventId %d",u16EventId));

#ifdef PHONE_WAITINGMODE
   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_START_WAITING_MODE:
      {
         if (FC_PHONE_CALLINSTANCE_INCOMINGCALLEVENT_RINGING == m_poCallInstance->m_u16IncomingCallEvent)
         {
            ETG_TRACE_USR3(("Start the AcceptCall SM"));
            m_poSMManager->vStartSM(FC_PHONE_SMMANAGER_SMID_ACCEPTCALL, m_poCallInstance);
         }
         m_bEventConsumed = TRUE ;
      }
      break;


      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMIdle::vHandleEventInSMIdleAlertToneReleased DEFAULT u16EventId %d",u16EventId));
      }
      break;
   }
#endif

}

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMIdle::vHandleEventInSMIdleReleaseAlertTone
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMIdle::vHandleEventInSMIdleReleaseAlertTone(tU16 u16EventId)
{
   ETG_TRACE_USR4(("fc_phone_tclSMIdle::vHandleEventInSMIdleReleaseAlertTone u16EventId %d",u16EventId));
   m_bEventConsumed = TRUE ;
   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_ALERT_REQUEST_OK:
      {
         ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_ALERT_REQUEST_OK"));
         m_u16State = FC_PHONE_SMIDLE_STATE_WAIT_FOR_RINGTONEACTIVATED;
         ETG_TRACE_USR2(("State Change: FC_PHONE_SMIDLE_STATE_WAIT_FOR_RINGTONEACTIVATED"));
         m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_INCOMINGRINGTONE;
         ETG_TRACE_USR3(("Request Audio ...AudioChannel = FC_PHONE_AUDIOCHANNEL_INCOMINGRINGTONE "));
         m_poAudioManager->s32GetRequest(m_poCallInstance->m_u16Id,FC_PHONE_AUDIOCHANNEL_INCOMINGRINGTONE,vAudioCallBackIdle);
      }
      break;
      case FC_PHONE_SM_EVENT_ALERT_REQUEST_NOK:
      {
         ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_ALERT_REQUEST_NOK"));
      }
      break;
      case FC_PHONE_SM_EVENT_PHONEBOOK_RESPONSE_OK :
      {
         ETG_TRACE_USR3(("EVENT::FC_PHONE_SM_EVENT_PHONEBOOK_RESPONSE_OK "));
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_INCOMINGCALL,m_poCallInstance);
         m_poCallInstance->m_u16CallStatusNotice = FC_PHONE_CALLINSTANCE_CALLSTATUS_RINGTONE;
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
      }
      break;
#ifdef PHONE_WAITINGMODE
      case FC_PHONE_SM_EVENT_START_WAITING_MODE:
      {
         if (FC_PHONE_CALLINSTANCE_INCOMINGCALLEVENT_RINGING == m_poCallInstance->m_u16IncomingCallEvent)
         {
            ETG_TRACE_USR3(("Start the AcceptCall SM"));
            m_poSMManager->vStartSM(FC_PHONE_SMMANAGER_SMID_ACCEPTCALL, m_poCallInstance);
         }
      }
      break;
#endif
      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMIdle::vHandleEventInAMInActivateVoiceCall: IN DEFAULT u16EventId %d",u16EventId));
         m_bEventConsumed = FALSE;
      }
      break;
   }
}

/*******************************************************************************
 *
 * FUNCTION: vHandleEventInRingMuteAck
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMIdle::vHandleEventInRingMuteAck(tU16 u16EventId)
{
   ETG_TRACE_USR4(("fc_phone_tclSMIdle::vHandleEventInRingMuteAck u16EventId %d",u16EventId));
   m_bEventConsumed = TRUE ;
   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_INCOMINGCALL_REQUEST_OK:
      {
         ETG_TRACE_USR3((" EVENT::FC_PHONE_SM_EVENT_RINGTONEMUTED "));
         m_u16State = FC_PHONE_SMIDLE_STATE_RINGTONE_MUTED;
         ETG_TRACE_USR2(("State Change :FC_PHONE_SMIDLE_STATET_RINGTONEMUTED "));
         m_poCallInstance->m_bAudioStatus = FC_PHONE_CALLINSTANCE_AUDIOMUTED;
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_AUDIOMUTE, m_poCallInstance);

         //m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
         m_poCallInstance->m_bRingtoneMuteStatus = FC_PHONE_RINGTONE_MUTED ;
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_RINGTONEMUTE,\
               m_poCallInstance);
      }
      break;

      case FC_PHONE_SM_EVENT_INCOMINGCALL_REQUEST_NOK:
      {
         /* Do nothing but remain in ringing state */
         m_u16State = FC_PHONE_SMIDLE_STATE_RINGING;
         ETG_TRACE_USR2(("State Change :FC_PHONE_SMIDLE_STATE_RINGING "));
      }
      break;
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
      {
         ETG_TRACE_USR3((" EVENT::FC_PHONE_SM_EVENT_RINGTONEMUTED "));
         m_u16State = FC_PHONE_SMIDLE_STATE_RINGTONE_MUTED;
         m_poCallInstance->m_bUsingVehicleAudio = FALSE;
         ETG_TRACE_USR2(("State Change :FC_PHONE_SMIDLE_STATET_RINGTONEMUTED "));
         m_poCallInstance->m_bAudioStatus = FC_PHONE_CALLINSTANCE_AUDIOMUTED;
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_AUDIOMUTE, m_poCallInstance);
         //m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
         m_poCallInstance->m_bRingtoneMuteStatus = FC_PHONE_RINGTONE_MUTED ;
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_RINGTONEMUTE, m_poCallInstance);
      }
      break;

      case FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK:
      {
         /* Do nothing but remain in ringing state */
         m_u16State = FC_PHONE_SMIDLE_STATE_RINGING;
         ETG_TRACE_USR2(("State Change :FC_PHONE_SMIDLE_STATE_RINGING "));
      }
      break;

      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMIdle::vHandleEventInRingMuteAck DEFAULT u16EventId %d",u16EventId));
         m_bEventConsumed = FALSE ;
      }
      break;
   }

}
/*******************************************************************************
 *
 * FUNCTION: vHandleEventInRingUnMuteAck
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMIdle::vHandleEventInRingUnMuteAck(tU16 u16EventId)
{
   ETG_TRACE_USR4(("fc_phone_tclSMIdle::vHandleEventInRingUnMuteAck u16EventId %d",u16EventId));

   switch (u16EventId)
   {

      case FC_PHONE_SM_EVENT_INCOMINGCALL_REQUEST_OK:
      {

         ETG_TRACE_USR4((" EVENT::FC_PHONE_SM_EVENT_INCOMINGCALL_REQUEST_OK "));
         m_poCallInstance->m_bAudioStatus = FC_PHONE_CALLINSTANCE_AUDIOUNMUTED;
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_AUDIOMUTE, m_poCallInstance);

         m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
         m_u16State = FC_PHONE_SMIDLE_STATE_RINGING;
         ETG_TRACE_USR2(("State Change :FC_PHONE_SMIDLE_STATE_RINGING "));
         m_poCallInstance->m_bRingtoneMuteStatus = FC_PHONE_RINGTONE_UNMUTED;
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_RINGTONEMUTE,\
               m_poCallInstance);
      }
      break;

      case FC_PHONE_SM_EVENT_INCOMINGCALL_REQUEST_NOK:
      {
         /* Do nothing but remain in muted state */
         m_u16State = FC_PHONE_SMIDLE_STATE_RINGTONE_MUTED;
         ETG_TRACE_USR2(("State Change :FC_PHONE_SMIDLE_STATE_RINGTONE_MUTED "));
      }
      break;

      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMIdle::vHandleEventInRingUnMuteAck DEFAULT u16EventId %d",u16EventId));
         m_bEventConsumed = FALSE ;
      }
      break;
   }

}

/*******************************************************************************
 *
 * FUNCTION: vHandleEventInAlertToneRelease
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMIdle::vHandleEventInAlertToneRelease(tU16 u16EventId)
{
   ETG_TRACE_USR4(("fc_phone_tclSMIdle::vHandleEventInAlertToneRelease u16EventId %d",u16EventId));
   m_bEventConsumed = TRUE ;

   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_ALERT_REQUEST_OK:
      case FC_PHONE_SM_EVENT_ALERT_REQUEST_NOK:
      {
         ETG_TRACE_USR3((" EVENT::FC_PHONE_SM_EVENT_ALERT_REQUEST_OK "));
         m_u16State = FC_PHONE_SMIDLE_STATE_IDLE;
         ETG_TRACE_USR2(("State Change :FC_PHONE_SMIDLE_STATE_IDLE "));
         vCancel();
         vInit();
         m_poCallInstance->vInit();
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_INCOMINGCALL,\
               m_poCallInstance);

      }
      break;


      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMIdle::vHandleEventInAlertToneRelease:DEFAULT  u16EventId %d",u16EventId));
         m_bEventConsumed = FALSE ;
      }
      break;
   }
}

/*******************************************************************************
 *
 * FUNCTION: vHandleEventInTerminateIncomingCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMIdle::vHandleEventInTerminateIncomingCall(tU16 u16EventId)
{
   ETG_TRACE_USR4(("fc_phone_tclSMIdle::vHandleEventInTerminateIncomingCall u16EventId %d",u16EventId));

   /*  delete the call Instance */
   (tVoid)u16EventId ;
   vCancel();
   vInit();
   m_poCallInstance->vInit();
   m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_INCOMINGCALL,\
         m_poCallInstance);

   m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,\
         m_poCallInstance);


}

/*******************************************************************************
 *
 * FUNCTION: vNewCallStatus
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMIdle::vNewCallStatus(const T_CallData* const prCallData,tU16 u16_callInstance)
{
   ETG_TRACE_USR4((" fc_phone_tclSMIdle::vNewCallStatus "));

   fc_phone_tclSMVRSession *poVRInstance = fc_phone_tclSMVRSession::poGetInstance();
   (tVoid)u16_callInstance ;
   switch (m_u16State)
   {

      case FC_PHONE_SMIDLE_STATE_WAIT_FOR_CALLSTATUS_RINGING:
      {
         ETG_TRACE_USR3((" STATE: FC_PHONE_SMIDLE_STATE_WAIT_FOR_CALLSTATUS_RINGING "));
         /* Incoming call confirmed */
         if (PHONE_CALLSTATE_INCOMING == prCallData->rCallStatus.u8CallState)
         {
            vCopyCallData(prCallData);
            bProcessEvent(FC_PHONE_SM_EVENT_CALLSTATUS_RINGING);
         }
         else if((FC_PHONE_CALLINSTANCE_CALLSTATUS_IDLE == m_poCallInstance->m_u16CallStatusNotice)
               &&(PHONE_CALLSTATE_WAITING == prCallData->rCallStatus.u8CallState)
         )
         {
            // Fix for GMMY15-2225 :: Call waiting alert (2nd incoming call alert) is not displayed
            ETG_TRACE_USR4((" PHONE_CALLSTATE_WAITING"));
            vHandleCallWaiting(prCallData);
         }
      }
      break;

      default:
      {
         /* Send Call status notification and act on Call Status accordingly */
         ETG_TRACE_USR4(("fc_phone_tclSMIdle::vNewCallStatus: DEFAULT "));
         if (   (FC_PHONE_CALLINSTANCE_CALLSTATUS_IDLE != \
               m_poCallInstance->m_u16CallStatusNotice)
               &&( PHONE_CALLSTATE_IDLE ==
                     prCallData->rCallStatus.u8CallState)
         )
         {
            /* Call got hung up at the receiver end,so delete the call Instance */

            //Sending incoming call event as Idle in call is not accepted
            if (FC_PHONE_CALLINSTANCE_INCOMINGCALLEVENT_RINGING == m_poCallInstance->m_u16IncomingCallEvent)
            {
               ETG_TRACE_USR4((" Sending u16IncomingCallEvent IDLE in INCOMING CALL STATUS to HMI "));
               m_poCallInstance->m_u16IncomingCallEvent = FC_PHONE_CALLINSTANCE_INCOMINGCALLEVENT_IDLE;
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_INCOMINGCALL, m_poCallInstance);
            }
            if (FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_poCallInstance->m_u8AudioChannel)
            {
               //m_u16State = FC_PHONE_SMIDLE_STATE_WAIT_FOR_AUDIO_RELEASE_AND_INIT_IDLE ;
               // release audio channel, and do not wait for audio release ACK
               // NCG3D-142658 : Decrementing the Channel Acquisition counter.
               fc_phone_tclClientHandler_BTSettings *p_clientHndler_bluetooth = (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerBTSettings;
               tU16 bInBandRingtone = p_clientHndler_bluetooth->vIsInBandRingtone();
               if(bInBandRingtone && (FC_PHONE_AUDIOCHANNEL_ALERTTONE == m_poCallInstance->m_u8AudioChannel))
               {
                  ETG_TRACE_USR4((" SMIdle: Updating acquisition counter in IDLE call state"));
                  m_poAudioManager->vUpdateChannelAttributes(FC_PHONE_AUDIOCHANNEL_PHONE, FC_PHONE_REQUESTTYPE_RELEASE);
               }

               ETG_TRACE_USR3(("Release Audio .."));
               m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id, m_poCallInstance->m_u8AudioChannel, vAudioCallBackIdle);

               //vHandleEventInReleasingAudioAndReInitIdle(FC_PHONE_SM_EVENT_CALLSTATUS_ONIDLE);
            }
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
            ETG_TRACE_USR3(("AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED"));

            vCancel();
            vInit();
            m_poCallInstance->vInit();

            //send status to client : now status is IDLE
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, m_poCallInstance);
         }

         //While Call Accepted by HANDSET
         else if (   (FC_PHONE_CALLINSTANCE_CALLSTATUS_RINGTONE == m_poCallInstance->m_u16CallStatusNotice)
               &&((PHONE_CALLSTATE_ACTIVE == prCallData->rCallStatus.u8CallState)
                     || (PHONE_CALLSTATE_HELD == prCallData->rCallStatus.u8CallState))
         )
         {
            ETG_TRACE_USR4(("  Starting ActiveCall In Handset StateMachine for CALL ACCEPTED FROM HANDSET..... "));

            if (FC_PHONE_CALLINSTANCE_INCOMINGCALLEVENT_RINGING == m_poCallInstance->m_u16IncomingCallEvent)
            {
               ETG_TRACE_USR4((" Sending u16IncomingCallEvent IDLE in INCOMING CALL STATUS to HMI "));

               m_poCallInstance->m_u16IncomingCallEvent = FC_PHONE_CALLINSTANCE_INCOMINGCALLEVENT_IDLE;
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_INCOMINGCALL, m_poCallInstance);
            }

            //transfer to handset if any call is on HMI
            //vCopyCallData(prCallData);
            //m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
            m_poSMManager->vStartSM(FC_PHONE_SMMANAGER_SMID_ACTIVECALLINHANDSET,m_poCallInstance);
         }

         /*call Waiting , when second incoming call came*/
         //No incoming call EVENT from dbus for second incoming call
         //so new call status itself , incoming call will be detected and incoming call
         //status will be sent to the Client(HMI)
         else if((FC_PHONE_CALLINSTANCE_CALLSTATUS_IDLE == m_poCallInstance->m_u16CallStatusNotice)
               &&(PHONE_CALLSTATE_WAITING == prCallData->rCallStatus.u8CallState)
         )
         {
            ETG_TRACE_USR4((" PHONE_CALLSTATE_WAITING in default "));
            vHandleCallWaiting(prCallData);
         }

         // This is considered as SIRI request only if SIRI session is ACTIVE and running. And hence the bIsVRSessionRunning() is used
         else if((TRUE == poVRInstance->bIsVRSessionRunning()) &&
               ((PHONE_CALLSTATE_DIALING == prCallData->rCallStatus.u8CallState)|| (PHONE_CALLSTATE_ALERTING == prCallData->rCallStatus.u8CallState))
         )
         {
            ETG_TRACE_USR4((" Voice Call via' SIRI  Active hence Dial SM is started "));
            vCopyCallData(prCallData);
            // CMG3G-7982- Extend VR session
            //Fix for PSARCCB-5362. The voice session should not be ended only if any of the call is not IDLE.
            //Added to that, the SCO channel should also be open.
#ifdef EXTEND_VR_SESSION
            tU8 u8SCOConnectionStatus = FC_PHONE_DBUS_SCO_CONN_FAILED;
            fc_phone_tclClientHandler_BTSettings *p_clientHndler_bluetooth = (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerBTSettings;
            u8SCOConnectionStatus = p_clientHndler_bluetooth->vGetSCOConnectionStatus(const_cast<tChar *> (fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId))); //CMG3G-4847 - To solve Lint
            ETG_TRACE_USR4(("  fc_phone_tclSMIdle::u8SCOConnectionStatus = %d ",u8SCOConnectionStatus));
            if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_ESTABLISHED)
            {
               poVRInstance->vStopExtendedVRSession();
            }
#endif
            ETG_TRACE_USR3((" sending BTVR as inactive to HMI and to phone to end the same."));
            poVRInstance->vUpdateVRstatusInactive();
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_ACTIVECALLINHANDSET,m_poCallInstance);
            m_poCallInstance->m_u8ObjectState = FC_PHONE_CALLINSTANCE_OBJECTSTATE_ACTIVE;
            m_poSMManager->vStartSM(FC_PHONE_SMMANAGER_SMID_DIAL,m_poCallInstance);
         }
         /* Active callInHandset (Call Dialled from Handset)*/
         else if((FC_PHONE_CALLINSTANCE_CALLSTATUS_IDLE == m_poCallInstance->m_u16CallStatusNotice)
               && ((PHONE_CALLSTATE_DIALING == prCallData->rCallStatus.u8CallState)|| (PHONE_CALLSTATE_ALERTING == prCallData->rCallStatus.u8CallState))
         )

         {
            ETG_TRACE_USR4(("Starting ACTIVECALL in HANDSET State MAchine "));
            // CMG3G-7982- Extend VR session
            //Fix for PSARCCB-5362. The voice session should not be ended only if any of the call is not IDLE.
            //Added to that, the SCO channel should also be open.
#ifdef EXTEND_VR_SESSION
            tU8 u8SCOConnectionStatus = FC_PHONE_DBUS_SCO_CONN_FAILED;
            fc_phone_tclClientHandler_BTSettings *p_clientHndler_bluetooth = (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerBTSettings;
            u8SCOConnectionStatus = p_clientHndler_bluetooth->vGetSCOConnectionStatus(const_cast<tChar *> (fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId))); //CMG3G-4847 - To solve Lint
            ETG_TRACE_USR4(("  fc_phone_tclSMIdle::u8SCOConnectionStatus = %d ",u8SCOConnectionStatus));
            if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_ESTABLISHED)
            {
               poVRInstance->vStopExtendedVRSession();
            }
#endif
            vCopyCallData(prCallData);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_ACTIVECALLINHANDSET,m_poCallInstance);
            m_poCallInstance->m_u8ObjectState = FC_PHONE_CALLINSTANCE_OBJECTSTATE_ACTIVE;
            m_poSMManager->vStartSM(FC_PHONE_SMMANAGER_SMID_ACTIVECALLINHANDSET,m_poCallInstance); //Fix for the isue GMMY15-5984
         }

         /* Active callInHandset (User walked in with Call in handset)*/
         else if((FC_PHONE_CALLINSTANCE_CALLSTATUS_IDLE == m_poCallInstance->m_u16CallStatusNotice)
               &&(( PHONE_CALLSTATE_ACTIVE == prCallData->rCallStatus.u8CallState)
                     || ( PHONE_CALLSTATE_HELD == prCallData->rCallStatus.u8CallState))
         )
         {
            ETG_TRACE_USR4(("Starting ACTIVECALL in HANDSET State MAchine For User Walking In with Call in Handset"));
            m_poCallInstance->m_u8ObjectState = FC_PHONE_CALLINSTANCE_OBJECTSTATE_ACTIVE;
            vCopyCallData(prCallData);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);            

            m_poSMManager->vStartSM(FC_PHONE_SMMANAGER_SMID_ACTIVECALLINHANDSET,m_poCallInstance);
         }

         else if ((FC_PHONE_CALLINSTANCE_CALLSTATUS_IDLE == \
               m_poCallInstance->m_u16CallStatusNotice)
               &&( PHONE_CALLSTATE_IDLE ==
                     prCallData->rCallStatus.u8CallState)
         )
         {
            /* Call got hung up at the caller end,so delete the call Instance */
            ETG_TRACE_USR4(("Already Status is IDLE.. do nothing "));

         }

         // Bug fix for PTS issue
         // When HfRing is missed and call status is received
         // Incoming call pop was not seen. To solve this if state change from idle to ring is received
         // phone fblock sends incoming call event
         else if ((FC_PHONE_CALLINSTANCE_CALLSTATUS_IDLE == \
               m_poCallInstance->m_u16CallStatusNotice)
               &&( PHONE_CALLSTATE_INCOMING ==
                     prCallData->rCallStatus.u8CallState)
         )
         {
            ETG_TRACE_USR4((" PTS:HfRing signal missed and call status ringing received"));
            fc_phone_tclClientHandler_BTSettings *p_clientHndler_bluetooth = (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerBTSettings;

            if (p_clientHndler_bluetooth)
            {
               ETG_TRACE_USR3((" Updating ringtone device id"));
                p_clientHndler_bluetooth->vUpdateRingToneDeviceAddrId(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressIdFromBDAddress((const tChar *) prCallData->BD_Address));
            }

            vCopyCallData(prCallData);
            m_u16State = FC_PHONE_SMIDLE_STATE_WAIT_FOR_CALLSTATUS_RINGING;
            ETG_TRACE_USR2(("STATE Change: FC_PHONE_SMIDLE_STATE_WAIT_FOR_CALLSTATUS_RINGING"));
            bProcessEvent(FC_PHONE_SM_EVENT_CALLSTATUS_RINGING);
         }
         else
         {
            /* Check if caller number is updated, if yes send incoming call property Update */
            ETG_TRACE_USR4(("IN DEFAULT ELSE PART "));
            tChar achCellNumber[FC_PHONE_MAXSTRINGLENGTH];
            vStringCopy(achCellNumber, m_poCallInstance->m_strCellNumber, FC_PHONE_MAXSTRINGLENGTH);
            vCopyCallData(prCallData);

            /* If two strings are not equal, send Incoming call event update */
            if(0x00 != OSAL_s32StringCompare(achCellNumber, m_poCallInstance->m_strCellNumber))
            {
               ETG_TRACE_USR4(("Sending Incoming call Status In Default "));
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_INCOMINGCALL, m_poCallInstance);
            }

            //Fix for PSARCCB-3030
            //When there was a second call in waiting state, first call was ended from Remote end.
            //Since there is only one Incoming call, the Incoming Ring-tone has to be activated.
            if((m_poCallInstance->m_u8AudioChannel == FC_PHONE_AUDIOCHANNEL_ALERTTONE) && (!m_poCallInstance->m_bcallWaitingState))
            {
               //On ending the ACTIVE call(DIALLED from HMI or Phone) when there is a waiting call,
               //the RINGTONE will not be heard. This is because "m_u8RingToneDeviceAddrId" is not set for that call.
               //And hence ERROR will be received for RequestAvailableRingtonesList_MS
               fc_phone_tclClientHandler_BTSettings *p_clientHndler_bluetooth = (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerBTSettings;
               if (p_clientHndler_bluetooth)
               {
                  ETG_TRACE_USR3((" Updating ringtone device id"));
                  p_clientHndler_bluetooth->vUpdateRingToneDeviceAddrId(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressIdFromBDAddress((const tChar *) prCallData->BD_Address));
               }

               ETG_TRACE_USR4(("Sending Incoming call Status In Default "));
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_INCOMINGCALL, m_poCallInstance);

               m_u16State = FC_PHONE_SMIDLE_STATE_RELEASE_ALERT_ACTIVATE_RINGTONE;
               ETG_TRACE_USR3(("Release Alert Tone .."));
               m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id,m_poCallInstance->m_u8AudioChannel,vAudioCallBackIdle);
               m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
               ETG_TRACE_USR3(("AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED"));
            }

            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
         }

      }
      break;
   }
}
/*******************************************************************************
 *
 * FUNCTION: vTimerCallBack
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMIdle::vTimerCallBack(tU16 u16TimerId)
{

   ETG_TRACE_USR4((" fc_phone_tclSMIdle::vTimerCallBack = %d",u16TimerId));
   (tVoid)u16TimerId ;//for removing warning

   if(m_bTimerRunning == TRUE )
   {
      ETG_TRACE_USR3((" Call Accepted In Handset Timer Executed "));

      if(u16TimerId == FC_PHONE_CALLINSTANCE_TIMER_ID)
      {
         vIncrementTimer(m_poCallInstance);
         ETG_TRACE_USR4(("fc_phone_tclSMIdle: calling vSendStatus"));
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, m_poCallInstance);
      }
      else
      {
         ETG_TRACE_USR4(("Invalid timerID(Not CallInstance)"));
      }
   }
}
/*******************************************************************************
 *
 * FUNCTION: vAudioCallBack
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMIdle::vAudioCallBack(tU16 u16AudioChannelId, tU16 u16RequestState)
{

   ETG_TRACE_USR4((" fc_phone_tclSMIdle::vAudioCallBack "));
   switch (u16AudioChannelId)
   {
      case FC_PHONE_AUDIOCHANNEL_INCOMINGRINGTONE:
      {
         ETG_TRACE_USR3((" EVENT::FC_PHONE_AUDIOCHANNEL_INCOMINGRINGTONE "));
         if (FC_PHONE_AUDIOCHANNEL_GRANTED == u16RequestState)
         {

            ETG_TRACE_USR4((" u16RequestState::FC_PHONE_AUDIOCHANNEL_INCOMINGRINGTONE_GRANTED "));
            bProcessEvent(FC_PHONE_SM_EVENT_INCOMINGCALL_REQUEST_OK);

         }
         else
         {

            ETG_TRACE_USR4((" u16RequestState::FC_PHONE_AUDIOCHANNEL_INCOMINGRINGTONE_DENIED_SUSPENDED "));
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
            ETG_TRACE_USR3(("AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED"));
            bProcessEvent(FC_PHONE_SM_EVENT_INCOMINGCALL_REQUEST_NOK);
         }

      }
      break;

      case FC_PHONE_AUDIOCHANNEL_ALERTTONE:
      {
         ETG_TRACE_USR3((" EVENT::FC_PHONE_AUDIOCHANNEL_ALERTTONE "));
         if (FC_PHONE_AUDIOCHANNEL_GRANTED == u16RequestState)
         {


            ETG_TRACE_USR4((" u16RequestState::FC_PHONE_AUDIOCHANNEL_GRANTED "));
            bProcessEvent(FC_PHONE_SM_EVENT_ALERT_REQUEST_OK);

         }
         else
         {

            ETG_TRACE_USR4((" u16RequestState::FC_PHONE_AUDIOCHANNEL_DENIED_SUSPENDED "));
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
            ETG_TRACE_USR3(("AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED"));
            bProcessEvent(FC_PHONE_SM_EVENT_ALERT_REQUEST_NOK);
         }

      }

      break;
      case FC_PHONE_AUDIOCHANNEL_PHONE:
      {
         ETG_TRACE_USR3((" EVENT::FC_PHONE_AUDIOCHANNEL_PHONE "));
         if (FC_PHONE_AUDIOCHANNEL_GRANTED == u16RequestState)
         {
            ETG_TRACE_USR4((" u16RequestState::FC_PHONE_AUDIOCHANNEL_GRANTED "));
            bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);

         }
         else
         {
            ETG_TRACE_USR4((" u16RequestState::FC_PHONE_AUDIOCHANNEL_DENIED_SUSPENDED "));
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
            ETG_TRACE_USR3(("AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED"));
            bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK);
         }

      }

      break;
      default:
      {
         ETG_TRACE_USR4((" fc_phone_tclSMIdle::vAudioCallBack: DEFAULT  "));
      }
      break;
   }
}
/*******************************************************************************
 *
 * FUNCTION: vHandleEventInRingMuted
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMIdle::vHandleEventInRingMuted(tU16 u16EventId)
{
   ETG_TRACE_USR4((" fc_phone_tclSMIdle::vHandleEventInRingMuted with u16EventId %d",u16EventId));
   m_bEventConsumed = TRUE ;
   switch(u16EventId)
   {
      case FC_PHONE_SM_EVENT_RINGTONEUNMUTE:
      {
         ETG_TRACE_USR3((" EVENT :: FC_PHONE_SM_EVENT_RINGTONEUNMUTE "));
         m_u16State = FC_PHONE_SMIDLE_STATE_WAIT_FOR_RINGUNMUTEACK;
         ETG_TRACE_USR2(("State Change :FC_PHONE_SMIDLE_STATE_WAIT_FOR_RINGUNMUTEACK "));
         m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_INCOMINGRINGTONE;
         ETG_TRACE_USR3(("Request Audio ...AudioChannel = FC_PHONE_AUDIOCHANNEL_INCOMINGRINGTONE"));
         m_poAudioManager->s32GetRequest(m_poCallInstance->m_u16Id,FC_PHONE_AUDIOCHANNEL_INCOMINGRINGTONE,vAudioCallBackIdle);

      }
      break;
      case FC_PHONE_SM_EVENT_HOLDCALL_REQUEST:
      {
         ETG_TRACE_USR2((" EVENT::FC_PHONE_SM_EVENT_HOLDCALL_REQUEST "));
         m_u16State = FC_PHONE_SMIDLE_STATE_WAIT_FOR_HOLD_RESPONE;
         ETG_TRACE_USR2(("State Change :FC_PHONE_SMIDLE_STATE_WAIT_FOR_HOLD_RESPONE"));
         m_pDbusIf->bHoldIncomingCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId));
      }
      break;
      default:
      {
         ETG_TRACE_USR4((" fc_phone_tclSMIdle::vHandleEventInRingMuted in DEFAULT with u16EventId %d",u16EventId));
         m_bEventConsumed = FALSE ;
      }
      break;
   }
}
/*******************************************************************************
 *
 * FUNCTION: vHandleEventInHoldResponse
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMIdle::vHandleEventInHoldResponse(tU16 u16EventId)
{
   ETG_TRACE_USR4((" fc_phone_tclSMIdle::vHandleEventInHoldResponse u16EventId %d",u16EventId));
   m_bEventConsumed = TRUE ;
   switch(u16EventId)
   {
      case FC_PHONE_SM_EVENT_DBUS_HOLDINCOMINGCALL_ACK_OK:
      {
         ETG_TRACE_USR3((" EVENT :: FC_PHONE_SM_EVENT_DBUS_HOLDCALL_ACK_OK "));

         m_u16State = FC_PHONE_SMIDLE_STATE_ONHOLD;
         ETG_TRACE_USR2(("State Change :FC_PHONE_SMIDLE_STATE_ONHOLD"));
         m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
         m_poCallInstance->m_u16CallStatusNotice = FC_PHONE_CALLINSTANCE_CALLSTATUS_ONHOLD;
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_HOLDCALL, \
               m_poCallInstance);
         // m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
         // m_pDbusIf->bGetCallStaus(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId));


      }
      break;
      default:
      {
         ETG_TRACE_USR4((" fc_phone_tclSMIdle::vHandleEventInHoldResponse: DEFAULT u16EventId %d",u16EventId));
         m_bEventConsumed = FALSE ;
      }
      break;
   }
}
/*******************************************************************************
 *
 * FUNCTION: vInit
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMIdle::vInit(tVoid)
{
   ETG_TRACE_USR4((" fc_phone_tclSMIdle::vInit"));
   m_u16State = FC_PHONE_SMIDLE_STATE_IDLE;
   ETG_TRACE_USR4(("State Change:FC_PHONE_SMIDLE_STATE_IDLE "));
   m_bTimerRunning = FALSE;
   ETG_TRACE_USR3(("m_bTimerRunning = FALSE"));
   m_bAlertRequestPending = FALSE;
}
//NCG3D-142658 : Added the vProcessAudioSignal in to IDLE SM to handle the Phone channel request.
/*******************************************************************************
 *
 * FUNCTION: vProcessAudioSignal
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMIdle::vProcessAudioSignal()
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMIdle::vProcessAudioSignal "));

   tU8 u8SCOConnectionStatus = FC_PHONE_DBUS_SCO_CONN_FAILED;
   fc_phone_tclClientHandler_BTSettings *p_clientHndler_bluetooth = (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerBTSettings;
   u8SCOConnectionStatus = p_clientHndler_bluetooth->vGetSCOConnectionStatus(const_cast<tChar *> (fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId))); //CMG3G-4847 - To solve Lint
   ETG_TRACE_USR4(("  fc_phone_tclSMAcceptCall::u8SCOConnectionStatus = %d ",u8SCOConnectionStatus));
   if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_DISCONNECTED)
   {
      tU16 bInBandRingtone = p_clientHndler_bluetooth->vIsInBandRingtone();
      if(bInBandRingtone && (FC_PHONE_AUDIOCHANNEL_ALERTTONE == m_poCallInstance->m_u8AudioChannel))
      {
         ETG_TRACE_USR4((" SMIdle-vCancel: Updating acquisition counter"));
         m_poAudioManager->vUpdateChannelAttributes(FC_PHONE_AUDIOCHANNEL_PHONE, FC_PHONE_REQUESTTYPE_RELEASE);
      }
   }
}

/*******************************************************************************
 *
 * FUNCTION: vProcessOnDynamicDisconnect
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMIdle::vProcessOnDynamicDisconnect(tU16 u16EventId)
{
   ETG_TRACE_USR4((" fc_phone_tclSMIdle::vProcessOnDynamicDisconnect "));
   //release Audio channels

   switch(u16EventId)
   {

      case FC_PHONE_SM_EVENT_SLC_OFF:
      {
         if (FC_PHONE_CALLINSTANCE_INCOMINGCALLEVENT_RINGING == m_poCallInstance->m_u16IncomingCallEvent)
         {
            ETG_TRACE_USR4((" Sending u16IncomingCallEvent IDLE in INCOMING CALL STATUS to HMI "));
            m_poCallInstance->m_u16IncomingCallEvent = FC_PHONE_CALLINSTANCE_INCOMINGCALLEVENT_IDLE;
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_INCOMINGCALL, m_poCallInstance);
         }

         if( FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_poCallInstance->m_u8AudioChannel )
         {
            ETG_TRACE_USR3((" EVENT :: RELEASING Audio Channel "));
            //if any audio channel aquired, release it
            //m_u16State = FC_PHONE_SMIDLE_STATE_WAIT_FOR_SLC_OFF_RESPONSE;
            ETG_TRACE_USR3(("Release Audio .."));
            m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id,m_poCallInstance->m_u8AudioChannel,vAudioCallBackIdle);
            vCancel();

            ETG_TRACE_USR4((" No audio channel is aquired, releasing instance "));\

            //if any audio channel is not aquired , got to idle state and send the status to client
            //m_bUsingVehicleAudio false , and stop timer if running
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
            ETG_TRACE_USR3(("AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED"));
            m_poCallInstance->m_bUsingVehicleAudio = FALSE;
            ETG_TRACE_USR3(("UsingVehicleAudio = FALSE "));
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,\
                  m_poCallInstance);

            if(TRUE == m_bTimerRunning)
            {
               m_poTimer->s32Stop(m_poCallInstance->m_u16TimerId); // Bugfix for GMMY16-17241
               m_bTimerRunning = FALSE;
               ETG_TRACE_USR3(("m_bTimerRunning = FALSE"));
            }

            m_poCallInstance->vInit();
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,\
                  m_poCallInstance);
            //send SLC status to client
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_SLC,m_poCallInstance);
         }
      }
      break;
      default:
      {
         ETG_TRACE_USR4((" IN DEFAULT : vProcessOnDynamicDisconnect: wrong u16EventId= %d ",u16EventId));
      }
      break;
   }
}
/*******************************************************************************
 *
 * FUNCTION: vHandleEventInSLCOffResponse
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMIdle::vHandleEventInSLCOffResponse(tU16 u16EventId)
{
   ETG_TRACE_USR4((" fc_phone_tclSMIdle::vHandleEventInSLCOffResponse "));

   switch(u16EventId)
   {

      case FC_PHONE_SM_EVENT_INCOMINGCALL_REQUEST_OK:
      case FC_PHONE_SM_EVENT_ALERT_REQUEST_OK :
      case FC_PHONE_SM_EVENT_INCOMINGCALL_REQUEST_NOK:
      case FC_PHONE_SM_EVENT_ALERT_REQUEST_NOK :
      {
         //m_bUsingVehicleAudio false , and stop timer if running
         m_poCallInstance->m_bUsingVehicleAudio = FALSE;
         ETG_TRACE_USR3(("UsingVehicleAudio = FALSE "));
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,\
               m_poCallInstance);

         // Go to idle state
         m_poCallInstance->vInit();
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,\
               m_poCallInstance);

         //send SLC status to client
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_SLC,m_poCallInstance);
      }
      break;


      default:
      {
         ETG_TRACE_USR4((" IN DEFAULT : vHandleEventInSLCOffResponse: wrong u16EventId= %d ",u16EventId));
      }
      break;
   }

}


/*******************************************************************************
 *
 * FUNCTION: vHandleEventInReleasingAudioAndReInitIdle
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMIdle::vHandleEventInReleasingAudioAndReInitIdle(tU16 u16EventId)
{
   (tVoid) u16EventId ;
   ETG_TRACE_USR4((" fc_phone_tclSMIdle::vHandleEventInReleasingAudioAndReinitIdle"));
   fc_phone_tclClientHandler_BTSettings *p_clientHndler_bluetooth = (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerBTSettings;
   vCancel();
   vInit();
   m_poCallInstance->vInit();
   //m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_INCOMINGCALL, m_poCallInstance);

   //send status to client : now status is IDLE
   m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, m_poCallInstance);
   if(p_clientHndler_bluetooth->GetOutGoingSourceChangeStatus())
   {
      p_clientHndler_bluetooth->SetOutGoingSourceChangeStatus(FALSE);
   }
}

/*******************************************************************************
 *
 * FUNCTION: vStopAlertTone
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMIdle::vStopAlertTone()
{
   ETG_TRACE_USR4((" fc_phone_tclSMIdle::vStopAlertTone "));
   if (m_bAlertPlaying == TRUE)
   {
      ETG_TRACE_USR4((" Stoping Alert Tone Play"));

      // The StopAlertTone interface is called from here
      //FC_Phone_PlayerEngine *m_AlertTonePlayer = (fc_phone_tclApp::m_poMainAppInstance)->m_poAlertTonePlayer;
      //m_AlertTonePlayer->StopAlertTone();
      m_bAlertPlaying = FALSE;
   }
}

/*******************************************************************************
 *
 * FUNCTION: vHandleAlertToneStateInPlayState()
 *
 * DESCRIPTION:
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMIdle::vHandleAlertToneStateInPlayState()
{
   ETG_TRACE_USR4((" fc_phone_tclSMIdle::vHandleAlertToneStateInPlayState "));

   // TODO: The response(Both Success and Failure) for PlayAlertTone interface to be handled here.
   m_u16State = FC_PHONE_SMIDLE_STATE_ALERTTONE_PLAYING;
   ETG_TRACE_USR2(("State change: FC_PHONE_SMIDLE_STATE_ALERTTONE_PLAYING"));
}

/*******************************************************************************
 *
 * FUNCTION: vHandleAlertToneStateInStopState()
 *
 * DESCRIPTION:
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMIdle::vHandleAlertToneStateInStopState()
{
   ETG_TRACE_USR4((" fc_phone_tclSMIdle::vHandleAlertToneStateInStopState "));

   ETG_TRACE_USR3((" m_u16AlertPromptPlayCount: %d ", m_u16AlertPromptPlayCount));

   /*
   // Bugfix for GMMY16-10666: Media song is played for the duration of Incoming
    // call alert, if a call is initiated while message is being read aloud

   // If alert is not played for ALERT_TONE_COUNT times then start pause channel, otherwise release the channel
   if (0x00 == m_u16AlertPromptPlayCount)
   {
      //Release the alert tone channel if still holding
      if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_poCallInstance->m_u8AudioChannel)
      {
         ETG_TRACE_USR4(("Releasing the LC_ALERT_TONE channel"));
         m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id, m_poCallInstance->m_u8AudioChannel, vAudioCallBackIdle);
         m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
         ETG_TRACE_USR3(("AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED"));
         m_u16State = FC_PHONE_SMIDLE_STATE_ALERT_TONE_RELEASED;
         ETG_TRACE_USR2(("State change: FC_PHONE_SMIDLE_STATE_ALERT_TONE_RELEASED"));
      }
   }
   else
   {
      m_u16AlertPromptPlayCount--;
      ETG_TRACE_USR3((" m_u16AlertPromptPlayCount: %d ", m_u16AlertPromptPlayCount));
      if ((0x00 == m_u16AlertPromptPlayCount) &&
            (FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_poCallInstance->m_u8AudioChannel))
      {
         ETG_TRACE_USR4(("Releasing the LC_ALERT_TONE channel, ALERT_TONE_COUNT times is reached"));
         m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id,
               m_poCallInstance->m_u8AudioChannel, vAudioCallBackIdle);
         m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
         ETG_TRACE_USR3(("AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED"));
         m_u16State = FC_PHONE_SMIDLE_STATE_ALERT_TONE_RELEASED;
         ETG_TRACE_USR2(("State change: FC_PHONE_SMIDLE_STATE_ALERT_TONE_RELEASED"));
      }
      else
      {
         // Continue playing alert tone till ALERT_TONE_COUNT times is reached/user action is performed
         vStartPauseTimer();
      }
   }
    */
}

/*******************************************************************************
 *
 * FUNCTION: vStartPauseTimer()
 *
 * DESCRIPTION:
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMIdle::vStartPauseTimer()
{
   ETG_TRACE_USR4(("fc_phone_tclSMIdle::vStartPauseTimer"));

   /* Alert file played, now wait for pause duration to restart play */
   m_u16State = FC_PHONE_SMIDLE_STATE_ALERTTONE_PAUSED;
   ETG_TRACE_USR2(("State change: FC_PHONE_SMIDLE_STATE_ALERTTONE_PAUSED"));

}

/*******************************************************************************
 *
 * FUNCTION: vHandleCallWaiting
 *
 * DESCRIPTION: Handles waiting call
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMIdle::vHandleCallWaiting(const T_CallData* const prCallData)
{
   ETG_TRACE_USR4(("fc_phone_tclSMIdle::vHandleCallWaiting"));
   /* Check if caller number is updated, if yes send incoming call property Update */
   //tChar achCellNumber[FC_PHONE_MAXSTRINGLENGTH];
   //(void)OSAL_szStringCopy(achCellNumber,m_poCallInstance->m_strCellNumber);
   vCopyCallData(prCallData);

   /* If two strings are not equal, send Incoming call event update */
   //if(0x00 != OSAL_s32StringCompare(achCellNumber, m_poCallInstance->m_strCellNumber))
   //{
   //sandeep:: have to check
   ETG_TRACE_USR4(("Processing second incoming call "));

   m_poCallInstance->m_bcallWaitingState = TRUE ;

   //for first incoming call we were doing state setting in INCOMING CALL DBUS ACK
   //And process event After Call Status Received.
   //Here both the thing will be done together ,
   //because no Incoming Event from dbus for second incoming call
   m_u16State = FC_PHONE_SMIDLE_STATE_WAIT_FOR_CALLSTATUS_RINGING;
   ETG_TRACE_USR2(("State Change :FC_PHONE_SMIDLE_STATE_WAIT_FOR_CALLSTATUS_RINGING "));

   bProcessEvent(FC_PHONE_SM_EVENT_CALLSTATUS_RINGING);

   //}
}
