

/*******************************************************************************
 *
 * FILE:          FC_Phone_SMAcceptCall.h
 *
 * SW-COMPONENT:  FC_Phone application
 *
 * PROJECT:
 *
 * DESCRIPTION:   Abstracts a statemachine
 *
 * AUTHOR:        Guruprasad G R
 *
 * COPYRIGHT:    (c)Celestial Systems, Bangalore, India
 *
 *******************************************************************************/

#ifndef _FC_PHONE_SMHANGUPCALL_H_
#define _FC_PHONE_SMHANGUPCALL_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
/* Define the states that this machine can take */

#define FC_PHONE_SMHANGUPCALL_STATE_HANGUP_CALL_STARTED 0
#define FC_PHONE_SMHANGUPALL_STATE_WAIT_FOR_CONNECT_FROM_BT  1 
#define FC_PHONE_SMHANGUPCALL_STATE_WAIT_FOR_AM_RESPONSE_DEACTIVATE_VOICE_INCOMINGCALL 2
#define FC_PHONE_SMHANGUPCALL_STATE_WAIT_FOR_CONNECTED_RESPONSE_SUCCESS 3

#define FC_PHONE_SMHANGUPCALL_STATE_WAIT_FOR_SLC_OFF_RESPONSE 4
#define FC_PHONE_SMHANGUPCALL_STATE_WAIT_FOR_NOSIGNAL_RESPONSE 5
#define FC_PHONE_SMHANGUPCALL_STATE_WAIT_FOR_DBUSACKONHANGUP 7
#define FC_PHONE_SMHANGUPCALL_STATE_WAIT_FOR_CALLSTATUS_ONHANGUP 8
#define FC_PHONE_SMHANGUPCALL_STATE_WAIT_FOR_CHANGEDEVICESTATE_ONCALLEND 9

class fc_phone_tclSMManager;
/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class fc_phone_tclSMHangUpCall : public fc_phone_tclSM 
{
public:

   /* Constructor */
   fc_phone_tclSMHangUpCall(fc_phone_tclCallInstance*&  rfpCallInstance);

   /* Destructor */
   virtual ~fc_phone_tclSMHangUpCall();

   virtual tVoid vCancel(tVoid);
   virtual tVoid vExecute(tVoid);
   virtual tBool bProcessEvent(tU16 u16EventId) FINAL;
   virtual tBool bProcessEvent(tU16 u16EventId,tVoid *varg);
   virtual tVoid vAudioCallBack(tU16 u16AudioChannelId, tU16 u16RequestState);
   virtual tVoid vProcessOnDynamicDisconnect(tU16 u16EventId);
   virtual tVoid vNewCallStatus(const T_CallData* const prCallData,tU16 u16_callInstance);
   virtual tVoid vTimerCallBack(tU16 u16TimerId);
private:
   tBool m_bEventConsumed ;
   tU16  m_u16CallStatusBeforeTerminate ;
   tU8 m_u8CallTotal;
   tBool m_bTimerRunning;
   tBool m_bHangUpMethodStart;

   tVoid vHandleEventInHangUpBTInCall(tU16 u16EventId);
   tVoid vHandleEventInAMInDeActivateVoiceCall();
   tVoid vHandleDbusError(tU16 u16DbusAckType,tChar Code);
   tVoid vStopTimer(tVoid);
};

#endif // _FC_PHONE_SMHANGUPCALL_H_


