/******************************************************************************
 *
 * FILE:          FC_Phone_SMHangUpCall.cpp
 *
 * SW-COMPONENT:  FC_Phone application
 *
 * PROJECT:
 *
 * DESCRIPTION:   CCA service Telephone.
 *
 * AUTHOR:
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

#include "FC_Phone_SMIncludes.h"
#include "../HelperClasses/FC_Phone_CallManager.h"
#include "../FC_Phone_clienthandler_BTSettings.h"
#include "../FC_Phone_service_Telephone.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_PHONE_STATEMACHINE
#include "trcGenProj/Header/FC_Phone_SMHangUpCall.cpp.trc.h"
#endif
/*******************************************************************************
 *
 * FUNCTION: vAudioCallBackHangUp
 *
 * DESCRIPTION: Audio callback Register for  Get/Release Ack
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid vAudioCallBackHangUp(tU16 u16AudioReqID,tU16 u16AudioChannelId, tU16 u16RequestState)
{
   ETG_TRACE_USR4((" Entering  vAudioCallBackHangUp"));


   fc_phone_tclSM* pSMInstance ;
   pSMInstance = fc_phone_tclSMManager::GetSM_FromAudioRequestorId(u16AudioReqID) ;

   if(pSMInstance)
   {
      pSMInstance->vAudioCallBack(u16AudioChannelId, u16RequestState);
   }
   else
   {
      ETG_TRACE_ERR(("ERROR:: could not get SM for u16TimerId %d",u16AudioReqID));
   }
}

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMHangUpCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
fc_phone_tclSMHangUpCall::fc_phone_tclSMHangUpCall(fc_phone_tclCallInstance*&  rfpCallInstance):\
      fc_phone_tclSM(rfpCallInstance)

      {

   ETG_TRACE_USR4((" Entering fc_phone_tclSMHangUpCall::fc_phone_tclSMHangUpCall"));
   m_u16State = FC_PHONE_SMHANGUPCALL_STATE_HANGUP_CALL_STARTED;
   ETG_TRACE_USR2(("State Change:FC_PHONE_SMHANGUPCALL_STATE_HANGUP_CALL_STARTED "));
   m_bEventConsumed = FALSE ;
   m_u16CallStatusBeforeTerminate = 0;
   m_u8CallTotal = 0;
   m_bTimerRunning = FALSE;
   m_bHangUpMethodStart = FALSE;
   ETG_TRACE_USR3((" TimerRunning = FALSE"));
      }
/*******************************************************************************
 *
 * FUNCTION: ~fc_phone_tclSMHangUpCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
/* Destructor */
fc_phone_tclSMHangUpCall::~fc_phone_tclSMHangUpCall()
{
   ETG_TRACE_USR4((" calling fc_phone_tclSMHangUpCall::~fc_phone_tclSMHangUpCall"));
}
/*******************************************************************************
 *
 * FUNCTION: vCancel
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMHangUpCall::vCancel(tVoid)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMHangUpCall::vCancel"));
   m_poCallInstance->m_HangupALL_flag = FALSE ;
   m_bHangUpMethodStart = FALSE;
}

/*******************************************************************************
 *
 * FUNCTION: vStopTimer
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMHangUpCall::vStopTimer(tVoid)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMHangUpCall::vStopTimer"));

   if (TRUE == m_bTimerRunning)
   {
      ETG_TRACE_USR4((" stopping TIMER"));
      m_poTimer->s32Stop(m_poCallInstance->m_u16TimerId); // Bugfix for GMMY16-17241
      m_bTimerRunning = FALSE;
      ETG_TRACE_USR3((" TimerRunning = FALSE"));
   }
}

/*******************************************************************************
 *
 * FUNCTION: vExecute
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMHangUpCall::vExecute()
{

   ETG_TRACE_USR4((" Entering fc_phone_tclSMHangUpCall::vExecute"));
   m_u16CallStatusBeforeTerminate = m_poCallInstance->m_u16CallStatusNotice ;
   m_bTimerRunning = TRUE ;
   ETG_TRACE_USR3((" TimerRunning = TRUE"));
   //Send update to client   
   m_poCallInstance->m_u16CallStatusNotice = FC_PHONE_CALLINSTANCE_CALLSTATUS_DISCONNECTING;
   m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);

   vHandleEventInAMInDeActivateVoiceCall();
}

/*******************************************************************************
 *
 * FUNCTION: bProcessEvent
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tBool fc_phone_tclSMHangUpCall::bProcessEvent(tU16 u16EventId,tVoid *varg)
{

   (tVoid)varg ;
   FcPhone_processEventArg   *ptProcessEventArg = (FcPhone_processEventArg *) varg;
   tBool bRetVal = FALSE;
   if(TRUE == ptProcessEventArg->bIsItDbusAck)
   {
      ETG_TRACE_USR4((" Status :: %d  Code :: 0x%x",ptProcessEventArg->Status,ptProcessEventArg->Code));
      if(FC_PHONE_DBUS_STATUS_SUCCESS != ptProcessEventArg->Status)
      {
         ETG_TRACE_USR2((" DBUS Call is not succeed, updating error code "));
         vHandleDbusError(ptProcessEventArg->u16DbusAckType,ptProcessEventArg->Code);
      }
      else
      {
         ETG_TRACE_USR2((" DBUS Call is  succeeded "));
         bRetVal = bProcessEvent(u16EventId) ;
      }
   }
   else
   {
      bRetVal = bProcessEvent(u16EventId) ;
   }
   return bRetVal ;
}
/*******************************************************************************
 *
 * FUNCTION: bProcessEvent
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tBool fc_phone_tclSMHangUpCall::bProcessEvent(tU16 u16EventId)
{
   ETG_TRACE_USR4(("tVoid fc_phone_tclSMHangUpCall::bProcessEvent"));
   switch (m_u16State) 
   {
      case FC_PHONE_SMHANGUPALL_STATE_WAIT_FOR_CONNECT_FROM_BT:
      {
         ETG_TRACE_USR2((" STATE::FC_PHONE_SMHANGUPALL_STATE_WAIT_FOR_CONNECT_FROM_BT "));
         vHandleEventInHangUpBTInCall(u16EventId);
      }
      break;
      default:
      {
         ETG_TRACE_USR4((" fc_phone_tclSMHangUpCall::bProcessEvent: DEFAULT"));
      }
      break;
   }

   tBool bRetVal= m_bEventConsumed ;
   m_bEventConsumed = FALSE ;
   return bRetVal ;
}


/*******************************************************************************
 *
 * FUNCTION: vHandleEventInAMInDeActivateVoiceCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMHangUpCall::vHandleEventInAMInDeActivateVoiceCall()
{

   ETG_TRACE_USR4((" Entering fc_phone_tclSMHangUpCall::vHandleEventInAMInDeActivateVoiceCall "));
   tU16 u16CallState = FC_PHONE_CALLINSTANCE_CALLSTATUS_IDLE;
   FCPhoneDbusClient_TerminateType_t enTerminateType = FC_PHONE_DBUS_TERMINATETYPE_SINGLECALL;

   if (m_poCallInstance)
   {
      if ((fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->bIsAgThreeWayCallSupported())
      {
         if (TRUE == m_poCallInstance->m_HangupALL_flag)
         {
            //m_poCallInstance->m_HangupALL_flag = FALSE ;
            enTerminateType = FC_PHONE_DBUS_TERMINATETYPE_ALL;
         }
         else if (fc_phone_tclCallManager::m_u16Count > 1)
         {
#ifndef BLUETOOTH_DISABLE_ENHANCED_CALL_CTRL // Disabled enhanced call control in BT_Stack
            // Use HfReleaseSpecCall when ENDTARGETCALL is supported by the device
            if (((fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->getAgThreeWayCallSuppFeatures()) & FC_PHONE_ENHANCECALLCTRL_ENDTARGETCALL_MASK)
            {
               //GMMY16-25794 - donot use release active call here as if both calls are active, it would end both calls
               fc_phone_tclCallManager *p_callManagerInstance = (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->m_poCallManager;
               if (p_callManagerInstance)
               {
                  //GMMY16-2960 - to find corresponding instance to be sent to DBus
                  m_u16State = FC_PHONE_SMHANGUPALL_STATE_WAIT_FOR_CONNECT_FROM_BT;
                  ETG_TRACE_USR2((" State Change : FC_PHONE_SMHANGUPALL_STATE_WAIT_FOR_CONNECT_FROM_BT"));
                  m_bHangUpMethodStart = TRUE;
                  tU16 u16DbusCallInstance = p_callManagerInstance->u16GetDbusCallInstanceFromCM(m_poCallInstance->m_u16Id);
                  ETG_TRACE_USR2(("u16DbusCallInstance %d", u16DbusCallInstance));
                  enTerminateType = FC_PHONE_DBUS_TERMINATETYPE_THREEWAYCALL_SPECIFIC;
                  ETG_TRACE_USR4((" enTerminateType :: %d", enTerminateType));
                  m_pDbusIf->bReleaseSpecCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId), enTerminateType, (const unsigned char) u16DbusCallInstance);
                  return;
               }
               else
               {
                  ETG_TRACE_ERR(("The p_callManagerInstance is NULL. Hence not terminating the call."));
               }
            }
#endif // Disabled enhanced call control in BT_Stack
            // NCG3D-150772: To handle the Hangup of active call when second incoming call is in progress.
            ETG_TRACE_USR4((" m_poCallInstance->m_u16CallStatusNotice = %d ",m_poCallInstance->m_u16CallStatusNotice));
            fc_phone_tclCallInstance* pOtherCallInstance = (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vGetCallInstanceOfOtherSM(m_poCallInstance);
            ETG_TRACE_USR4((" pOtherCallInstance->m_u16CallStatusNotice = %d ",pOtherCallInstance->m_u16CallStatusNotice));

            if(FC_PHONE_CALLINSTANCE_CALLSTATUS_ACTIVE == m_u16CallStatusBeforeTerminate && FC_PHONE_CALLINSTANCE_CALLSTATUS_RINGTONE == pOtherCallInstance->m_u16CallStatusNotice)
            {
               ETG_TRACE_USR4((" Terminating Active call and accept wating call"));
               enTerminateType = FC_PHONE_DBUS_TERMINATETYPE_ACTIVECALL_ACCEPT_WAITING;
            }
            else if (FC_PHONE_CALLINSTANCE_CALLSTATUS_ACTIVE == m_u16CallStatusBeforeTerminate)
            {
               //release Active call
               ETG_TRACE_USR4((" Terminating ACTIVE call"));
               enTerminateType = FC_PHONE_DBUS_TERMINATETYPE_MULTIPLECALL_ACTIVE;
            }
            else if(FC_PHONE_CALLINSTANCE_CALLSTATUS_RINGTONE == m_u16CallStatusBeforeTerminate)
            {
               // NCG3D-14519 - release waiting call
               ETG_TRACE_USR4((" Terminating Waiting call"));
               enTerminateType = FC_PHONE_DBUS_TERMINATETYPE_SECONDCALL_WAITING;
            }
            else
            {
               //release InActive call
               ETG_TRACE_USR4((" Terminating IN-ACTIVE call"));
               enTerminateType = FC_PHONE_DBUS_TERMINATETYPE_MULTIPLECALL_INACTIVE;
            }
         }
         else if (fc_phone_tclCallManager::m_u16Count == 1)
         {
            // BugV2.0 174211- RetrieveCallStatus is no longer needed. the Call state is retrieved from CallStatusList table
            u16CallState = (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->u16GetCallStateFromCallInstID(m_poCallInstance->m_u16Id);
            ETG_TRACE_USR3(("u16CallState: %u", ETG_ENUM(TR_CALLSTATUS,u16CallState)));

            if (u16CallState == FC_PHONE_CALLINSTANCE_CALLSTATUS_BUSY)
            {
               //release InActive call
               ETG_TRACE_USR4((" Terminating All Calls for Three way call not supported case"));
               enTerminateType = FC_PHONE_DBUS_TERMINATETYPE_ALL;
            }
         }
      }
      ETG_TRACE_USR4((" enTerminateType :; %d", enTerminateType));
      /* Delegate it to Dbus */
      m_u16State = FC_PHONE_SMHANGUPALL_STATE_WAIT_FOR_CONNECT_FROM_BT;
      ETG_TRACE_USR2((" State Change : FC_PHONE_SMHANGUPALL_STATE_WAIT_FOR_CONNECT_FROM_BT"));
      m_bHangUpMethodStart = TRUE;
      m_pDbusIf->bHangUpCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId), enTerminateType);
   }
}

/*******************************************************************************
 *
 * FUNCTION: vHandleEventInHangUpBTInCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/

tVoid fc_phone_tclSMHangUpCall::vHandleEventInHangUpBTInCall(tU16 u16EventId)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMHangUpCall::vHandleEventInHangUpBTInCall u16EventId %d",u16EventId));
   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_DBUS_HANGUPCALL_ACK_OK:
      {
         ETG_TRACE_USR3((" EVENT :: FC_PHONE_SM_EVENT_DBUS_HANGUPCALL_ACK_OK"));
      }
      break;
      case FC_PHONE_SM_EVENT_CALLSTATUS_ONHANGUP:
      {
         ETG_TRACE_USR3((" EVENT :: FC_PHONE_SM_EVENT_CALLSTATUS_ONHANGUP"));
      }
      break;
      default:
      {
         ETG_TRACE_USR3((" EVENT :: Default Case of Hangup "));
      }
      break;
   }
}

/*******************************************************************************
 *
 * FUNCTION: vAudioCallBack
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/

tVoid fc_phone_tclSMHangUpCall::vAudioCallBack(tU16 u16AudioChannelId, tU16 u16RequestState)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMHangUpCall::vAudioCallBack"));
   switch (u16AudioChannelId)
   {
      case FC_PHONE_AUDIOCHANNEL_PHONE:
      case FC_PHONE_AUDIOCHANNEL_ALERTTONE:
      {
         if (FC_PHONE_AUDIOCHANNEL_GRANTED == u16RequestState)
         {
            ETG_TRACE_USR3(("  FC_PHONE_AUDIOCHANNEL_GRANTED "));
            bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
         }
         else
         {
            ETG_TRACE_USR3(("  u16RequestState::FC_PHONE_AUDIOCHANNEL_DENIED_SUSPENDED "));
            bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK);
         }
      }
      break;
      default:
      {
         ETG_TRACE_USR4((" fc_phone_tclSMHangUpCall::vAudioCallBack : IN DEFAULT "));
      }
      break;

   }
}



/*******************************************************************************
 *
 * FUNCTION: vProcessOnDynamicDisconnect
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMHangUpCall::vProcessOnDynamicDisconnect(tU16 u16EventId)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMHangUpCall::vProcessOnDynamicDisconnect u16EventId %d",u16EventId));
   //release Audio channels

   switch(u16EventId)
   {

      case FC_PHONE_SM_EVENT_SLC_OFF:
      {

         if( FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_poCallInstance->m_u8AudioChannel )
         {
            ETG_TRACE_USR3((" EVENT :: RELEASING Audio Channel "));
            //if any audio channel aquired, release it
            //m_u16State = FC_PHONE_SMHANGUPCALL_STATE_WAIT_FOR_SLC_OFF_RESPONSE;
            ETG_TRACE_USR3((" Release  Audio ... "));
            m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id,m_poCallInstance->m_u8AudioChannel,vAudioCallBackHangUp);
            if(FC_PHONE_AUDIOCHANNEL_PHONE == m_poCallInstance->m_u8AudioChannel)
            {
               m_poCallInstance->m_bUsingVehicleAudio = FALSE;
               ETG_TRACE_USR3((" UsingVehicleAudio = FALSE"));
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
            }
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
            ETG_TRACE_USR3((" AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED "));
            ETG_TRACE_USR3((" No audio channel is aquired, releasing instance "));
            //if any audio channel is not aquired , got to idle state and send the status to client
            m_poCallInstance->vInit();
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
            //send SLC status to client
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_SLC,m_poCallInstance);
            m_poSMManager->vSMFinished(m_poCallInstance->m_u16Id);
         }
      }
      break;
      default:
      {
         ETG_TRACE_USR4((" IN DEFAULT : vProcessOnDynamicDisconnect: wrong u16EventId= %d ",u16EventId));
      }
      break;
   }
}


/*******************************************************************************
 *
 * FUNCTION: vNewCallStatus
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMHangUpCall::vNewCallStatus(const T_CallData* const prCallData,tU16 u16_callInstance)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMHangUpCall::vNewCallStatus "));

   (tVoid) u16_callInstance;

   ETG_TRACE_USR4(("Callstatus ACTIVE | HELD "));
   // if call status received as ACTIVE while hangup in processing,, POST Hangup MR.
   if( TRUE == m_bHangUpMethodStart)
   {
      if(PHONE_CALLSTATE_IDLE != prCallData->rCallStatus.u8CallState)
      {
         ETG_TRACE_USR4((" Callstatus!=  IDLE"));
         m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_HANGUP,m_poCallInstance);

      }
      else
      {
         ETG_TRACE_USR4(("Callstatus =  IDLE"));
         m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_HANGUP,m_poCallInstance);

         if (FC_PHONE_CALLINSTANCE_INCOMINGCALLEVENT_RINGING == m_poCallInstance->m_u16IncomingCallEvent)
         {
            ETG_TRACE_USR4(("Sending InComingCallEvent(IDLE) property update to clients"));

            m_poCallInstance->m_u16IncomingCallEvent = FC_PHONE_CALLINSTANCE_INCOMINGCALLEVENT_IDLE;
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_INCOMINGCALL, m_poCallInstance);
         }
      }
      ETG_TRACE_USR4((" Set m_bHangUpMethodStart to FALSE"));
      m_bHangUpMethodStart = FALSE;
   }
   m_u8CallTotal = prCallData->rCallStatus.u8CallTotal;
   ETG_TRACE_USR4((" fc_phone_tclSMHangUpCall::m_u8CallTotal = %d , m_poCallInstance->m_HangupALL_flag = %d",m_u8CallTotal,m_poCallInstance->m_HangupALL_flag));
   if(m_poCallInstance->m_HangupALL_flag == TRUE)
   {
      if(m_u8CallTotal == 0)
      {
         if(PHONE_CALLSTATE_IDLE == prCallData->rCallStatus.u8CallState)
         {
            ETG_TRACE_USR4((" vNewCallStatus :PHONE_CALLSTATE_IDLE == prCallData->rCallStatus.u8CallState "));

#ifdef PHONE_WAITINGMODE
            fc_phone_tclWaitingMode* poWaitingMode = fc_phone_tclWaitingMode::poGetInstance();
            tenFC_Phone_WaitingModeState enWaitingModeState = poWaitingMode->enGetWaitingModeState();

            //Both calls/single call came to an end during waiting mode
            if (FC_PHONE_WAITINGMODE_IDLE != enWaitingModeState)
            {
               poWaitingMode->bProcessEvent(FC_PHONE_WAITING_MODE_EVENT_END_OF_ACTIVE_CALLS);
            }
#endif
            if (FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_poCallInstance->m_u8AudioChannel)
            {
               ETG_TRACE_USR3((" Releasing Audio...."));
               m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id,m_poCallInstance->m_u8AudioChannel,vAudioCallBackHangUp);
               m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
               ETG_TRACE_USR3((" AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED..."));
               m_poCallInstance->m_bUsingVehicleAudio = FALSE;
               ETG_TRACE_USR3(("UsingVehicleAudio = FALSE..."));
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO, m_poCallInstance);
            }

            //to stop timer if active
            vStopTimer();

            m_poCallInstance->vInit();
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, m_poCallInstance);
            m_poSMManager->vSMFinished(m_poCallInstance->m_u16Id);
         }
      }
   }
   else
   {
      if( PHONE_CALLSTATE_IDLE == prCallData->rCallStatus.u8CallState)
      {
         ETG_TRACE_USR4((" vNewCallStatus :PHONE_CALLSTATE_IDLE == prCallData->rCallStatus.u8CallState "));

#ifdef PHONE_WAITINGMODE
         fc_phone_tclWaitingMode* poWaitingMode = fc_phone_tclWaitingMode::poGetInstance();
         tenFC_Phone_WaitingModeState enWaitingModeState = poWaitingMode->enGetWaitingModeState();

         //Both calls/single call came to an end during waiting mode
         if ((FC_PHONE_WAITINGMODE_IDLE != enWaitingModeState) && (0 == prCallData->rCallStatus.u8CallTotal))
         {
            poWaitingMode->bProcessEvent(FC_PHONE_WAITING_MODE_EVENT_END_OF_ACTIVE_CALLS);
         }
#endif

         if (FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_poCallInstance->m_u8AudioChannel)
         {
            m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id,m_poCallInstance->m_u8AudioChannel,vAudioCallBackHangUp);
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;

            m_poCallInstance->m_bUsingVehicleAudio = FALSE;
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO, m_poCallInstance);

         }

         //to stop timer if active
         vStopTimer();
         m_poCallInstance->vInit();
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, m_poCallInstance);
         m_poSMManager->vSMFinished(m_poCallInstance->m_u16Id);
      }
      // Gmmy16-8009 - When Active call status received in Hangup call state machine, revert back to the active call satemachine as the call was not ended in device
      else if((PHONE_CALLSTATE_ACTIVE == prCallData->rCallStatus.u8CallState) || 
         (PHONE_CALLSTATE_HELD == prCallData->rCallStatus.u8CallState ))
      {
         vCopyCallData(prCallData);
         fc_phone_tclCallInstance *poCallInstance[FC_PHONE_MAX_CALLINSTANCES];
         poCallInstance[0] = m_poCallInstance;
         poCallInstance[1] = NULLPTR;
         m_poSMManager->vRevertStateMachine(poCallInstance);
      }
   }
}

/*******************************************************************************
 *
 * FUNCTION: vHandleDbusError
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMHangUpCall::vHandleDbusError(tU16 u16DbusAckType,tChar Code)
{
   ETG_TRACE_USR4((" Entering  fc_phone_tclSMHangUpCall::vHandleDbusError "));
   switch(u16DbusAckType)
   {
      case FC_PHONE_CB_FID_HANGUPCALL:
      {
         ETG_TRACE_USR4((" FC_PHONE_CB_FID_HANGUPCALL "));
         switch(Code)
         {
            case FC_PHONE_DBUS_ERRORCODE_STATE_ERROR:
            {
               m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACK_STATE_ERROR;
            }
            break;
            case FC_PHONE_DBUS_ERRORCODE_OPERATION_NOT_ALLOWED:
            case FC_PHONE_DBUS_ERRORCODE_OPERATION_NOT_SUPPORTED:
            {
               m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOTAVAILABLE;
            }
            break;
            default:
            {
               ETG_TRACE_USR4((" IN DEFAULT This Error Code [0x%x] is not supported yet",Code) );
               m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
            }
            break;
         }
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_HANGUP,m_poCallInstance);
         if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED == m_poCallInstance->m_u8AudioChannel)
         {
            ETG_TRACE_USR3((" Request Audio ... "));
            m_poAudioManager->s32GetRequest( m_poCallInstance->m_u16Id,FC_PHONE_AUDIOCHANNEL_PHONE,vAudioCallBackHangUp);
         }

         m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE ;
         ETG_TRACE_USR3((" AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE "));
         m_poCallInstance->m_bUsingVehicleAudio = TRUE;
         ETG_TRACE_USR3((" UsingVehicleAudio = TRUE"));
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
         //m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
         fc_phone_tclCallInstance *pCallInstance[FC_PHONE_MAX_CALLINSTANCES];
         pCallInstance[0] = m_poCallInstance;
         pCallInstance[1] = NULLPTR;

         // Call status is set to disconnecting - Get new call status
         m_pDbusIf->bGetCallStatus(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId));

         m_poSMManager->vRevertStateMachine(pCallInstance);
      }
      break;
      default:
      {
         ETG_TRACE_USR4((" This Event ID is not supported yet"));
         break;
      }
   }
}

/*******************************************************************************
 *
 * FUNCTION: vTimerCallBack
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMHangUpCall::vTimerCallBack(tU16 u16TimerId)
{
   ETG_TRACE_USR4((" ENTER: fc_phone_tclSMHangUpCall::vTimerCallBack u16TimerId = %d",u16TimerId));

   if (m_poCallInstance)
   {
      if(u16TimerId == FC_PHONE_CALLINSTANCE_TIMER_ID)
      {
         vIncrementTimer(m_poCallInstance);
         ETG_TRACE_USR4(("fc_phone_tclSMHangUpCall: calling vSendStatus"));
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, m_poCallInstance);
      }
      else
      {
         ETG_TRACE_USR4(("Invalid timerID(Not CallInstance)"));
      }
   }
}
