/*******************************************************************************
 *
 * FILE:          FC_Phone_SMExtVRSession.h
 *
 * SW-COMPONENT:  FC_Phone application
 *
 * PROJECT:
 *
 * DESCRIPTION:   Abstracts a statemachine
 *
 * AUTHOR:
 *
 * COPYRIGHT:    (c)Celestial Systems, Bangalore, India
 *
 *******************************************************************************/

#ifndef _FC_PHONE_EXTVRSESSION_H_
#define _FC_PHONE_EXTVRSESSION_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
/* Define the states that this machine can take */

#define FC_PHONE_SMEXTVR_STATE_IDLE                             0
#define FC_PHONE_SMEXTVR_STATE_WAITING_FOR_CHANNEL_ACQUISITION  1
#define FC_PHONE_SMEXTVR_STATE_READY                            2
#define FC_PHONE_SMEXTVR_STATE_WAITING_FOR_START_STREAMING      3
#define FC_PHONE_SMEXTVR_STATE_ACTIVE                           4
#define FC_PHONE_SMEXTVR_STATE_WAITING_FOR_STOP_STREAMING       5
#define FC_PHONE_SMEXTVR_STATE_WAITING_FOR_CHANNEL_RELEASE      6
#define FC_PHONE_SMEXTVR_STATE_WAITING_FOR_STOP_EXT_VR_INCOMING_CALL      7
#define FC_PHONE_SMEXTVR_STATE_WAITING_FOR_CH_REL_DUE_TO_INCOMING_CALL      8
#define FC_PHONE_SMEXTVR_STATE_WAITING_FOR_IDLE_CS      9

enum ExtVRErrorCode
{
   EXT_VR_NO_ERROR,
   EXT_VR_ERROR_IN_STREAMING,
   EXT_VR_ERROR_PHONE_CALL_ACTIVE
};

enum ExtVRStates
{
   EXT_VR_IDLE,
   EXT_VR_READY,
   EXT_VR_ACTIVE
};

class fc_phone_tclSMManager;
/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

class ExtVRStateParams
{
public:
   ExtVRStateParams() : m_u8ExtVRState(EXT_VR_IDLE), m_u8ErrorCode(EXT_VR_NO_ERROR)
   {

   }

   ExtVRStateParams(ExtVRStates u8ExtVRState, ExtVRErrorCode u8ErrorCode) :
      m_u8ExtVRState(u8ExtVRState), m_u8ErrorCode(u8ErrorCode)
   {

   }

   ~ExtVRStateParams() {}

   ExtVRStates m_u8ExtVRState;
   ExtVRErrorCode m_u8ErrorCode;
};

class fc_phone_tclSMExtVRSession : public fc_phone_tclSM
{
public:

   /* Constructor */
   fc_phone_tclSMExtVRSession();

   /* Destructor */
   virtual ~fc_phone_tclSMExtVRSession();

   /* Process event from hmi */
   virtual tVoid vProcessEvent(tU16 u16EventId) FINAL;

   virtual tVoid vCancel(tVoid) FINAL;

   static  fc_phone_tclSMExtVRSession* poGetInstance(void);

   tBool isExtVRSessionIdle();

private:
   static fc_phone_tclSMExtVRSession* m_poExtVRInstance;
   tU16 m_u16State;
   tU16 m_u16AudioChannel;
   tBool m_bIdleCallState;


   tVoid vHandleEventInIdleState(tU16 u16EventId);
   tVoid vHandleEventInWaitingForChnlAquisition(tU16 u16EventId);
   tVoid vHandleEventInReadyState(tU16 u16EventId);
   tVoid vHandleEventInWaitingForStartStreaming(tU16 u16EventId);
   tVoid vHandleEventInActiveState(tU16 u16EventId);
   tVoid vHandleEventInWaitingForStopStreaming(tU16 u16EventId);
   tVoid vHandleEventInWaitingForChannelRelease(tU16 u16EventId);
   tVoid vHandleEventInWaitForStopExtVRDueToIncomingCall(tU16 u16EventId);
   tVoid vHandleEventInWaitForIdleCS(tU16 u16EventId);
   tVoid vHandleWaitingForChReleaseDueToIncomingCall(tU16 u16EventId);

   tVoid vSendExtVRStatus(ExtVRStates u8ExtVRState = EXT_VR_IDLE, ExtVRErrorCode u8ErrorCode = EXT_VR_NO_ERROR);

   tVoid vHandleExtVRChannelAllocation();
   tVoid vHandleChannelAcquisition();
   tVoid vHandleSourceActivityOff();
   tVoid vHandleSCOChannelAcquisition();
   tVoid vHandleSCOChannelRelease();
   tVoid vHandleStartStreamingAudio();
   tVoid vHandleStopStreamingAudio();
   tVoid vHandleSpeechRequestNotOk();

   tVoid vReleaseSpeechChannel();
   tVoid vHandleEventSLCOFF();
};

#endif // _FC_PHONE_EXTVRSESSION_H_


