/*******************************************************************************
 *
 * FILE:          FC_Phone_SMEvents.h
 *
 * SW-COMPONENT:  FC_Phone application
 *
 * PROJECT:
 *
 * DESCRIPTION:   Global list of events for all the state machines
 *
 * AUTHOR:        Guruprasad G R
 *
 * COPYRIGHT:    (c)Celestial Systems, Bangalore, India
 *
 *******************************************************************************/
#ifndef _FC_PHONE_SMEVENTS_H_
#define _FC_PHONE_SMEVENTS_H_


/* Define the events that the machine can take */
//#define FC_PHONE_SM_EVENT_INCOMINGCALL                 0
#define FC_PHONE_SM_EVENT_CALLSTATUS_RINGING           1
#define FC_PHONE_SM_EVENT_INCOMINGCALL_REQUEST_OK      2
#define FC_PHONE_SM_EVENT_INCOMINGCALL_REQUEST_NOK     3

#define FC_PHONE_SM_EVENT_ALERT_REQUEST_OK             4
#define FC_PHONE_SM_EVENT_ALERT_REQUEST_NOK            5
#define FC_PHONE_SM_EVENT_PHONE_REQUEST_OK             6
#define FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK            7
#define FC_PHONE_SM_EVENT_TIMER_EXPIRED                8
#define FC_PHONE_SM_EVENT_SRCACTIVITY_START            9
#define FC_PHONE_SM_EVENT_AUDIO_CONNECTION_OK          10
#define FC_PHONE_SM_EVENT_AUDIO_CONNECTION_NOK         11
#define FC_PHONE_SM_EVENT_RINGTONEMUTE                 12
#define FC_PHONE_SM_EVENT_RINGTONEUNMUTE               13
#define FC_PHONE_SM_EVENT_RINGTONEMUTED                14
#define FC_PHONE_SM_EVENT_RINGTONEUNMUTED              15

//#define FC_PHONE_SM_EVENT_BTCONNECTION_REQUEST_OK      16
//#define FC_PHONE_SM_EVENT_BTCONNECTION_REQUEST_NOK     17
#define FC_PHONE_SM_EVENT_MICROPHONE_MUTE_OK           18
#define FC_PHONE_SM_EVENT_MICROPHONE_UNMUTE_OK         19
#define FC_PHONE_SM_EVENT_MICROPHONEMUTED              20
#define FC_PHONE_SM_EVENT_MICROPHONEUNMUTED            21
#define FC_PHONE_SM_EVENT_HOLDCALL_REQUEST             22
#define FC_PHONE_SM_EVENT_RESUMECALL_REQUEST           23
#define FC_PHONE_SM_EVENT_SRCACTIVITY_ON_OK            24
#define FC_PHONE_SM_EVENT_SRCACTIVITY_OFF_OK           25
//#define FC_PHONE_SM_EVENT_OUTGOINGCALL_ACK_OK          26
//#define FC_PHONE_SM_EVENT_OUTGOINGCALL_ACK_NOK         27
#define FC_PHONE_SM_EVENT_CANCELOUTGOINGCALL_OK        28
#define FC_PHONE_SM_EVENT_OUTGOINGCALL_REQUEST_OK      29
#define FC_PHONE_SM_EVENT_OUTGOINGCALL_REQUEST_NOK     30
#define FC_PHONE_SM_EVENT_ACTIVECALLINHANDSET_REQUEST_OK 31
#define FC_PHONE_SM_EVENT_SLC_OFF                      32
#define FC_PHONE_SM_EVENT_NO_SIGNAL                    33
#define FC_PHONE_SM_EVENT_ACK_OK                       34
#define FC_PHONE_SM_EVENT_SENDDTMF                     35

#define FC_PHONE_SM_EVENT_PHONEBOOK_RESPONSE_OK        36
#define FC_PHONE_SM_EVENT_SWAPCALL_OK                  37
#define FC_PHONE_SM_EVENT_CALLSTATUS_UPDATE            38
#define FC_PHONE_SM_EVENT_TRANSFERCALLVEHICLE_REQUEST_OK 39

#define FC_PHONE_SM_EVENT_IF_VEHICLECALL_TRANSFER_TOHANTSET     40
#define FC_PHONE_SM_EVENT_IF_HANDSETCALL_TRANSFER_TOVEHICLE     41

#define FC_PHONE_SM_EVENT_SPLITCALL_OK                   42
#define FC_PHONE_SM_EVENT_HANGUPCALL_OK             43
#define FC_PHONE_SM_EVENT_AUDIORELEASE_ACK_OK            44
#define FC_PHONE_SM_EVENT_AUDIORELEASE_ACK_NOK           45
#define FC_PHONE_SM_EVENT_CHANGEDEVICESTATE_RESPONSE_OK            46
#define FC_PHONE_SM_EVENT_SA_OFF                         47
#define FC_PHONE_SM_EVENT_HANGUPCALLALL_OK          48
#define FC_PHONE_SM_EVENT_SINGLE_CALL_HANGUP             49   
#define FC_PHONE_SM_EVENT_CHANGEDEVICESTATE_RESPONSE_NOK             50
#define FC_PHONE_SM_EVENT_CALLSTATUS_ONIDLE             51
#define FC_PHONE_SM_EVENT_CALLSTATUS_ONHANGUP             52
#define FC_PHONE_SM_EVENT_SCOCONNECTION_STATUS_IND             53
#define FC_PHONE_SM_EVENT_TRANSFERCALLHANDSET_REQUEST_OK 54
#define FC_PHONE_SM_EVENT_ONSTARCALL_HANGUP 55
#define FC_PHONE_SM_EVENT_SPEECH_REQUEST_OK              56
#define FC_PHONE_SM_EVENT_SPEECH_REQUEST_NOK             57
#define FC_PHONE_SM_EVENT_SETPLAY_MR             58
#define FC_PHONE_SM_EVENT_SETPLAY_ME             59
#define FC_PHONE_SM_EVENT_ARL_SRCACTIVITY_ON             60
#ifdef PHONE_WAITINGMODE
#define FC_PHONE_SM_EVENT_START_WAITING_MODE             61
#define FC_PHONE_SM_EVENT_ARL_PHONEWAIT_SRC_ON           62
#endif
#define FC_PHONE_SM_EVENT_START_EXTERNAL_VR             63
#define FC_PHONE_SM_EVENT_STOP_EXTERNAL_VR              64


//DbusCallback events
#define FC_PHONE_SM_EVENT_DBUS_ACK_BASE                    200
#define FC_PHONE_SM_EVENT_DBUS_INCOMINGCALL_ACK_OK         (FC_PHONE_SM_EVENT_DBUS_ACK_BASE+1)
#define FC_PHONE_SM_EVENT_DBUS_REJECTCALL_ACK_OK           (FC_PHONE_SM_EVENT_DBUS_ACK_BASE+2)
#define FC_PHONE_SM_EVENT_DBUS_ACCEPTCALL_ACK_OK           (FC_PHONE_SM_EVENT_DBUS_ACK_BASE+3)
#define FC_PHONE_SM_EVENT_DBUS_HANGUPCALL_ACK_OK           (FC_PHONE_SM_EVENT_DBUS_ACK_BASE+4)
#define FC_PHONE_SM_EVENT_DBUS_DIAL_ACK_OK                 (FC_PHONE_SM_EVENT_DBUS_ACK_BASE+5)
#define FC_PHONE_SM_EVENT_DBUS_TERMINATE_ACK_OK            (FC_PHONE_SM_EVENT_DBUS_ACK_BASE+6)
#define FC_PHONE_SM_EVENT_DBUS_HOLDCALL_ACK_OK             (FC_PHONE_SM_EVENT_DBUS_ACK_BASE+7)
#define FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK         (FC_PHONE_SM_EVENT_DBUS_ACK_BASE+8)
#define FC_PHONE_SM_EVENT_DBUS_DTMF_ACK_OK                 (FC_PHONE_SM_EVENT_DBUS_ACK_BASE+9)
#define FC_PHONE_SM_EVENT_DBUS_RESUMECALL_ACK_OK           (FC_PHONE_SM_EVENT_DBUS_ACK_BASE+10)
#define FC_PHONE_SM_EVENT_DBUS_HOLDINCOMINGCALL_ACK_OK     (FC_PHONE_SM_EVENT_DBUS_ACK_BASE+11)
#define FC_PHONE_SM_EVENT_DBUS_SWAPCALL_ACK_OK             (FC_PHONE_SM_EVENT_DBUS_ACK_BASE+12)
#define FC_PHONE_SM_EVENT_TRANSFERCALL_ACK_OK              (FC_PHONE_SM_EVENT_DBUS_ACK_BASE+13)
#define FC_PHONE_SM_EVENT_DBUS_CONFCALL_ACK_OK             (FC_PHONE_SM_EVENT_DBUS_ACK_BASE+14)
#define FC_PHONE_SM_EVENT_DBUS_SPLITCALL_ACK_OK            (FC_PHONE_SM_EVENT_DBUS_ACK_BASE+15)
#define FC_PHONE_SM_EVENT_DBUS_VOICEREC_ACTIVATION_ACK_OK  (FC_PHONE_SM_EVENT_DBUS_ACK_BASE+16)
#define FC_PHONE_SM_EVENT_DBUS_VOICEREC_DEACTIVATION_ACK_OK (FC_PHONE_SM_EVENT_DBUS_ACK_BASE+17)
#define FC_PHONE_SM_EVENT_DBUS_VOICEREC_ACTIVATION_IND      (FC_PHONE_SM_EVENT_DBUS_ACK_BASE+18)
#define FC_PHONE_SM_EVENT_DBUS_VOICEREC_DEACTIVATION_IND    (FC_PHONE_SM_EVENT_DBUS_ACK_BASE+19)
#define FC_PHONE_SM_EVENT_DBUS_VOICEREC_WAITFOR_STOPVR_DEACTIVATION_ACK_OK (FC_PHONE_SM_EVENT_DBUS_ACK_BASE+20)
#define FC_PHONE_SM_EVENT_DBUS_VOICEREC_SCO_RELEASE                        (FC_PHONE_SM_EVENT_DBUS_ACK_BASE+21)
#define FC_PHONE_SM_EVENT_DBUS_VOICEREC_SCO_ACQUISITION                    (FC_PHONE_SM_EVENT_DBUS_ACK_BASE+22)
#define FC_PHONE_SM_EVENT_DBUS_VOICEREC_DEACT_INCOMINGCALL                 (FC_PHONE_SM_EVENT_DBUS_ACK_BASE+23)
#define FC_PHONE_SM_EVENT_DBUS_CALLSTATUS_IDLE                             (FC_PHONE_SM_EVENT_DBUS_ACK_BASE+24)
#define FC_PHONE_SM_EVENT_DBUS_CALLSTATUS_ACTIVE                             (FC_PHONE_SM_EVENT_DBUS_ACK_BASE+25)
#define FC_PHONE_SM_EVENT_DBUS_CALLSTATUS_INCOMING                             (FC_PHONE_SM_EVENT_DBUS_ACK_BASE+26)

//DbusCallback events
#define FC_PHONE_SM_EVENT_VR_BASE                          400
#define FC_PHONE_SM_EVENT_CCX_VR_SA_ON                     (FC_PHONE_SM_EVENT_VR_BASE+1)
#define FC_PHONE_SM_EVENT_CCX_VR_SA_OFF                    (FC_PHONE_SM_EVENT_VR_BASE+2)
#define FC_PHONE_SM_EVENT_CCX_BT_DEVICE_VR_ACTIVE          (FC_PHONE_SM_EVENT_VR_BASE+3)
#define FC_PHONE_SM_EVENT_CCX_BT_DEVICE_VR_INACTIVE        (FC_PHONE_SM_EVENT_VR_BASE+4)
#define FC_PHONE_SM_EVENT_CCX_BT_DEVICE_VR_ACTIVE_FOR_PASSIVE_DEVICE        (FC_PHONE_SM_EVENT_VR_BASE+5)
#define FC_PHONE_SM_EVENT_CCX_EXT_VR_ACTIVE                (FC_PHONE_SM_EVENT_VR_BASE+6)
#define FC_PHONE_SM_EVENT_CCX_EXT_VR_INACTIVE              (FC_PHONE_SM_EVENT_VR_BASE+7)
#define FC_PHONE_SM_EVENT_CCX_EXT_VR_ECNRSTARTAUDIO        (FC_PHONE_SM_EVENT_VR_BASE+8)
#define FC_PHONE_SM_EVENT_CCX_EXT_VR_ECNRSTOPAUDIO         (FC_PHONE_SM_EVENT_VR_BASE+9)

#define  FC_PHONE_DBUS_ERRORCODE_STATE_ERROR 0x0008
//Fix GMMY15-661
#define  FC_PHONE_ALLOCATE_ACK_NO_AUDIO_CHANNEL 0x05

#define  FC_PHONE_DBUS_ERRORCODE_AG_FAILURE 0x00
#define  FC_PHONE_DBUS_ERRORCODE_NO_CONNECTION_TO_PHONE 0x01
#define  FC_PHONE_DBUS_ERRORCODE_OPERATION_NOT_ALLOWED 0x03
#define  FC_PHONE_DBUS_ERRORCODE_OPERATION_NOT_SUPPORTED 0x04
#define  FC_PHONE_DBUS_ERRORCODE_PH_SIM_PIN_REQUIRED 0x05
#define  FC_PHONE_DBUS_ERRORCODE_SIM_NOT_INSERTED 0x0A
#define  FC_PHONE_DBUS_ERRORCODE_SIM_PIN_REQUIRED 0x0B
#define  FC_PHONE_DBUS_ERRORCODE_SIM_PUK_REQUIRED 0x0C
#define  FC_PHONE_DBUS_ERRORCODE_SIM_FAILURE 0x0D
#define  FC_PHONE_DBUS_ERRORCODE_SIM_BUSY 0x0E
#define  FC_PHONE_DBUS_ERRORCODE_INCORRECT_PASSWORD 0x10
#define  FC_PHONE_DBUS_ERRORCODE_SIM_PIN2_REQUIRED 0x11
#define  FC_PHONE_DBUS_ERRORCODE_SIM_PUK2_REQUIRED 0x12
#define  FC_PHONE_DBUS_ERRORCODE_MEMORY_FULL 0x14
#define  FC_PHONE_DBUS_ERRORCODE_INVALID_INDEX 0x15
#define  FC_PHONE_DBUS_ERRORCODE_MEMORY_FAILURE 0x17
#define  FC_PHONE_DBUS_ERRORCODE_TEXTSTRING_TOOLONG 0x18
#define  FC_PHONE_DBUS_ERRORCODE_INVALIDCHAR_TEXTSTRING 0x19
#define  FC_PHONE_DBUS_ERRORCODE_DIAL_STRING_TOOLONG 0x1A
#define  FC_PHONE_DBUS_ERRORCODE_INVALIDCHAR_DIALSTRING 0x1B
#define  FC_PHONE_DBUS_ERRORCODE_NO_NETWORK_SERVICE 0x1E
#define  FC_PHONE_DBUS_ERRORCODE_EMERGENCY_CALLS_ONLY 0x20
#define  FC_PHONE_DBUS_ERRORCODE_ERR_NO_CARRIER 0x21
#define  FC_PHONE_DBUS_ERRORCODE_ERR_BUSY 0x22
#define  FC_PHONE_DBUS_ERRORCODE_ERR_NO_ANSWER 0x23
#define  FC_PHONE_DBUS_ERRORCODE_ERR_DELAYED 0x24
#define  FC_PHONE_DBUS_ERRORCODE_ERR_BLACKLISTED 0x25
#define  FC_PHONE_DBUS_ERRORCODE_NETWORK_TIMEOUT 0x26
#define  FC_PHONE_DBUS_ERRORCODE_INPROGRESS 0x27
#define  FC_PHONE_DBUS_ERRORCODE_INVALID_ARGUMENTS 0x28
#define  FC_PHONE_DBUS_ERRORCODE_INVALID_FORMAT 0x29
#define  FC_PHONE_DBUS_ERRORCODE_NOT_IMPLEMENTED 0x2A
#define  FC_PHONE_DBUS_ERRORCODE_FAILED 0x2B

#define  FC_PHONE_DBUS_ERRORCODE_NO_ERR_INFORMATION 0xFF

#endif /*_FC_PHONE_SMEVENTS_H_*/
