/******************************************************************************
 *
 * FILE:          FC_Phone_SMDial.cpp
 *
 * SW-COMPONENT:  FC_Phone application
 *
 * PROJECT:
 *
 * DESCRIPTION:   CCA service Telephone.
 *
 * AUTHOR:
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

#include "FC_Phone_SMIncludes.h"
#include "stdio.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_PHONE_STATEMACHINE
#include "trcGenProj/Header/FC_Phone_SMDial.cpp.trc.h"
#endif
#include "../HelperClasses/FC_Phone_CallManager.h"

/*******************************************************************************
 *
 * FUNCTION: vAudioCallBackDial
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid vAudioCallBackDial(tU16 u16AudioReqID,tU16 u16AudioChannelId, tU16 u16RequestState)
{
   ETG_TRACE_USR4((" Entering vAudioCallBackDial"));
   //fc_phone_tclSMDial::m_poInstance->vAudioCallBack(u16AudioChannelId, u16RequestState);
   fc_phone_tclSM* pSMInstance ;
   pSMInstance = fc_phone_tclSMManager::GetSM_FromAudioRequestorId(u16AudioReqID) ;   

   if(pSMInstance)
   {
      pSMInstance->vAudioCallBack(u16AudioChannelId, u16RequestState);
   }
   else
   {
      ETG_TRACE_ERR(("ERROR:: could not get SM for u16TimerId %d",u16AudioReqID));
   }
}

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMDial
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
fc_phone_tclSMDial::fc_phone_tclSMDial(fc_phone_tclCallInstance*&  rfpCallInstance):\
      fc_phone_tclSM(rfpCallInstance)

      {
   ETG_TRACE_USR4(("Entering constructor fc_phone_tclSMDial::fc_phone_tclSMDial "));
   m_phonenumber = NULLPTR ;
   m_bTimerRunning = FALSE;
   m_u16State_while_MicroPhoneMute =0 ;
   m_u8errorCode = 0;
   m_u16State_while_Hold = 0;
   m_u16_memID = FC_PHONE_SMDIAL_UNKNOWN_MEMID ;
   m_en_dialType = FC_PHONE_DIALTYPE_DIAL;
   m_bTerminateCallReqBeforeDial = FALSE;
   m_bEventConsumed = FALSE ;
   m_bTerminateCallTimerRunning = FALSE;
   m_u8RetryCount = 0;
   m_u16SentDtmfCounter  = 0;
   m_u16DTMFCharLength   = 0;
   u16_DialoneTimeDTMFCalculation = 0;
   m_bTerminateCallRequest = FALSE;
   m_bTerminateCallPosted = FALSE;
   m_u16State_while_TransferAudio = 0;
   m_bTransferCallToVehicleRequest = FALSE;
   m_u16State_CurrentState = FC_PHONE_SMDIAL_STATE_DIAL_STARTED;
   m_bCallStatusFailureTimerRunning = FALSE;
      }

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMDial
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
fc_phone_tclSMDial::fc_phone_tclSMDial(fc_phone_tclCallInstance*& rfpCallInstance, tVoid *vArg) :
      fc_phone_tclSM(rfpCallInstance)
{
   ETG_TRACE_USR4(("Entering constructor fc_phone_tclSMDial::fc_phone_tclSMDial "));
   FcPhoneDial_InputParamStruct *pst_inparam = (FcPhoneDial_InputParamStruct *) vArg;
   tU32 u32_number_size;
   m_u16State = FC_PHONE_SMDIAL_STATE_DIAL_STARTED;
   ETG_TRACE_USR4(("STATE change: FC_PHONE_SMDIAL_STATE_DIAL_STARTED"));
   m_u8errorCode = 0;
   m_phonenumber = NULLPTR;
   m_u16_memID = FC_PHONE_SMDIAL_UNKNOWN_MEMID;
   m_bTerminateCallReqBeforeDial = FALSE;
   m_bEventConsumed = FALSE;
   m_bTerminateCallTimerRunning = FALSE;
   m_u8RetryCount = 0;
   //update the dial type
   m_en_dialType = pst_inparam->en_dialType;

   //update the phoneNumber or memID based on dial Type
   if ((FC_PHONE_DIALTYPE_DIAL == pst_inparam->en_dialType) || (FC_PHONE_DIALTYPE_DIALEXTENDED == pst_inparam->en_dialType))
   {
      m_phonenumber = NULLPTR;
      u32_number_size = static_cast<tU32>(OSAL_u32StringLength(pst_inparam->pu8_phoneNumber));
      m_phonenumber = OSAL_NEW
      tU8[u32_number_size + 1];

      if (!m_phonenumber)
      {
         ETG_TRACE_FATAL((" FATAL ERROR : memory not allocated for m_phonenumber "));
      }
      else
      {
         memset(m_phonenumber, 0, u32_number_size + 1);
         //If memory allocated for the m_phonenumber, do the copy
         vStringCopy((char*) m_phonenumber, (const char*) pst_inparam->pu8_phoneNumber, u32_number_size + 1);

         //copy number to call instance also
         vStringCopy(rfpCallInstance->m_strCellNumber, (const char*) pst_inparam->pu8_phoneNumber, FC_PHONE_MAXSTRINGLENGTH);
      }

   }
   else if (FC_PHONE_DIALTYPE_SPEEDDIAL == pst_inparam->en_dialType)
   {
      m_u16_memID = pst_inparam->u16_memID;
   }
   else
   {
      ETG_TRACE_USR4((" WARNING : Wrong Dial Type ID "));
   }

   //default value to the member variables

   m_bTimerRunning = FALSE;
   ETG_TRACE_USR3(("  TimerRunning = FALSE "));
   m_u16State_while_MicroPhoneMute = 0;
   m_u8errorCode = 0;
   m_u16State_while_Hold = 0;
   m_u16SentDtmfCounter = 0;
   m_u16DTMFCharLength = 0;
   u16_DialoneTimeDTMFCalculation = 0;
   m_bTerminateCallRequest = FALSE;
   m_bTerminateCallPosted = FALSE;
   m_bTransferCallToVehicleRequest = FALSE;
   m_u16State_CurrentState = FC_PHONE_SMDIAL_STATE_DIAL_STARTED;
   m_u16State_while_TransferAudio = 0;
   m_bCallStatusFailureTimerRunning = FALSE;
}
/*******************************************************************************
 *
 * FUNCTION: ~fc_phone_tclSMDial :: Destructor
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/

fc_phone_tclSMDial::~fc_phone_tclSMDial()
{

   ETG_TRACE_USR4((" Destructor called ::fc_phone_tclSMDial :: ~fc_phone_tclSMDial"));
   if(m_phonenumber)
   {
      OSAL_DELETE[] m_phonenumber;
   }
   m_bTimerRunning = FALSE;
   m_bTerminateCallTimerRunning = FALSE;
   m_bCallStatusFailureTimerRunning = FALSE;
   ETG_TRACE_USR3(("  TimerRunning = FALSE "));
   m_u16State_while_MicroPhoneMute =0 ;
   m_u8errorCode = 0;
   m_bTerminateCallRequest = FALSE;
   m_bTerminateCallPosted = FALSE;
   m_bTransferCallToVehicleRequest = FALSE;
}
/*******************************************************************************
 *
 * FUNCTION: vCancel
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMDial::vCancel(tVoid)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMDial::vCancel"));

   //If DTMF sending is not finished , send method error
   if(m_poCallInstance && m_u16SentDtmfCounter != m_u16DTMFCharLength )
   {
      ETG_TRACE_ERR((" sending Method Error to client"));
      u16_DialoneTimeDTMFCalculation = 0;
      m_u16SentDtmfCounter  = 0;
      m_u16DTMFCharLength   = 0;
      m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
      m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_PLAYDTMF,m_poCallInstance);
   }

   m_u16State_while_TransferAudio = 0;
}

/*******************************************************************************
 *
 * FUNCTION: vStopTimer
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMDial::vStopTimer(tVoid)
{
   ETG_TRACE_USR4(("Entering fc_phone_tclSMDial::vStopTimer,m_bTimerRunning : %d ",m_bTimerRunning));

   if (m_poCallInstance && TRUE == m_bTimerRunning)
   {
      ETG_TRACE_USR4((" Stopping TIMER"));
      m_poTimer->s32Stop(m_poCallInstance->m_u16TimerId); // Bugfix for GMMY16-17241
      m_bTimerRunning = FALSE;
      ETG_TRACE_USR4((" TimerRunning = FALSE"));
   }
}

/*******************************************************************************
 *
 * FUNCTION: vRestoreDialSM
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMDial::vRestore(tVoid)
{
   ETG_TRACE_USR4(("Entering TIMER is Running"));
   m_bTimerRunning = TRUE;
   ETG_TRACE_USR3((" TimerRunning = TRUE"));
   ETG_TRACE_USR4((" Restore Dial  State Machine "));
   if(m_poCallInstance )
   {
      tU8 u8SCOConnectionStatus = FC_PHONE_DBUS_SCO_CONN_FAILED;
      fc_phone_tclClientHandler_BTSettings *p_clientHndler_bluetooth = (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerBTSettings;
      u8SCOConnectionStatus = p_clientHndler_bluetooth->vGetSCOConnectionStatus(const_cast<tChar *> (fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId))); //CMG3G-4847 - To solve Lint
      //Dbus call for transferring call to handset
      if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_ESTABLISHED)
      {
         if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED == m_poCallInstance->m_u8AudioChannel)
      {
         m_u16State = FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIOACTIVATION_FOR_RESTOREDIALSM;
         ETG_TRACE_USR2(("STATE change: FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIOACTIVATION_FOR_RESTOREDIALSM"));
         m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
         ETG_TRACE_USR3((" Requesting Audio m_poCallInstance::  AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE"));
         m_poAudioManager->s32GetRequest(m_poCallInstance->m_u16Id,FC_PHONE_AUDIOCHANNEL_PHONE,vAudioCallBackDial);
      }
      else
      {
         // m_bUsingVehicleAudio is set to TRUE.
         m_u16State = FC_PHONE_SMDIAL_STATE_CALL_ROUTED;
         m_poCallInstance->m_bUsingVehicleAudio = TRUE;
         ETG_TRACE_USR3(("  m_bUsingVehicleAudio = TRUE "));
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
            ETG_TRACE_USR2(("STATE change: FC_PHONE_SMDIAL_STATE_CALL_ROUTED"));
         }
      }
      else
      {
         ETG_TRACE_USR2(("SCO Disconnected and no channel available"));
         m_u16State = FC_PHONE_SMDIAL_STATE_CALL_ROUTED;
         ETG_TRACE_USR2(("STATE change: FC_PHONE_SMDIAL_STATE_CALL_ROUTED"));
      }
   }
}

/*******************************************************************************
 *
 * FUNCTION: vExecute
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMDial::vExecute()
{
   ETG_TRACE_USR4(("Entering fc_phone_tclSMDial::vExecute "));
   if(m_poCallInstance)
   {
      //If any ActiveCallInHandset is going on ,transfer it to Vehicle
      if(fc_phone_tclCallManager::m_u16Count == 1)
      {
         //Check whether Other call uses Vehicle Audio or not.
         if(!(fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vGetVehicleAudioStatus())
         {
            ETG_TRACE_USR4((" fc_phone_tclSMDial::Other Call Doesnt Use Vehicle audio "));
            fc_phone_tclCallInstance* pCallInstance = (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vGetCallInstanceOfOtherSM(m_poCallInstance);
            if(pCallInstance)
            {
                //GMMY16-19255 - check callstatus for the other call instance
               if((FC_PHONE_CALLINSTANCE_CALLSTATUS_ACTIVE == pCallInstance->m_u16CallStatusNotice)
                  ||(FC_PHONE_CALLINSTANCE_CALLSTATUS_ONHOLD == pCallInstance->m_u16CallStatusNotice)/* transfer only if call is active in device. */
                  ||(FC_PHONE_CALLINSTANCE_CALLSTATUS_CONFERENCE == pCallInstance->m_u16CallStatusNotice))
               {
                  m_u16State = FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIOTRANSFER_ONDIAL;
                  ETG_TRACE_USR2(("STATE change: FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIOTRANSFER_ONDIAL"));
                  //m_poCallInstance->m_u16CallStatusNotice = FC_PHONE_CALLINSTANCE_CALLSTATUS_DIALING;
                  //m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
                  m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId), FC_PHONE_CALLTRANSFER_FROMHANDSET_TOHANSFREE);
                  fc_phone_tclCallInstance *poCallInstance[FC_PHONE_MAX_CALLINSTANCES];
                  poCallInstance[0] = pCallInstance;
                  poCallInstance[1] = NULLPTR;
                  m_poSMManager->vRevertStateMachine(poCallInstance);
                  return;
               }
               else
               {
                  ETG_TRACE_USR2(("Other call is not active"));
               }
            }
            else
            {
               ETG_TRACE_USR4((" fc_phone_tclSMDial::Couldnt Find Call instance of another SM"));
            }
         }
      }
      m_u16State = FC_PHONE_SMDIAL_STATE_WAIT_FOR_CONNECT_FROM_BT;
      ETG_TRACE_USR4((" State Change: FC_PHONE_SMDIAL_STATE_WAIT_FOR_CONNECT_FROM_BT "));
      if ((FC_PHONE_DIALTYPE_DIAL == m_en_dialType) || (FC_PHONE_DIALTYPE_DIALEXTENDED == m_en_dialType))
      {
         //GMMY15-5984:Final D2SC Telephone]If an outgoing call is made using BT Speech recognition, the call cannot be ended using SWC or centerstack .
         //No need to send dail req for the call which is dailed in handset
         if(m_phonenumber)
         {
            ETG_TRACE_USR4((" Executing Dial ......."));
            m_pDbusIf->bDial(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId),(const char*) m_phonenumber);
         }
         else
            ETG_TRACE_ERR((" m_phonenumber is NULL"));
      }
      else
      {
         if(FC_PHONE_DIALTYPE_SPEEDDIAL == m_en_dialType)
         {
            ETG_TRACE_USR4((" Executing Speed Dial ........."));
            m_pDbusIf->bSpeedDial(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId),m_u16_memID);
         }
         else
         {
            ETG_TRACE_USR4((" WARNING : Wrong Dial Type ID "));
         }
      }

   }
   else
   {
      ETG_TRACE_ERR(("Call Instance  is NULL"));
   }
}

/*******************************************************************************
 *
 * FUNCTION: bProcessEvent
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/

tBool fc_phone_tclSMDial::bProcessEvent(tU16 u16EventId,tVoid *varg)
{
   ETG_TRACE_USR4(("Entering fc_phone_tclSMDial::bProcessEvent with arg "));
   tBool bRetVal= FALSE ;


   FcPhone_processEventArg   *ptProcessEventArg = (FcPhone_processEventArg *) varg;

   //if dbus call is not success , update the error code
   //if((TRUE == ptProcessEventArg->bIsItDbusAck) && (u16EventId == FC_PHONE_SM_EVENT_DBUS_DIAL_ACK_OK))
   if(TRUE == ptProcessEventArg->bIsItDbusAck)
   {
      ETG_TRACE_USR4(("DBus Ack with Status :: %d  Code :: 0x%x ",ptProcessEventArg->Status,ptProcessEventArg->Code));
      if(ptProcessEventArg->u16DbusAckType == FC_PHONE_CB_FID_AUDIOTRANSFER)
      {
         if(ptProcessEventArg->Status == CALLTRANSFER_FAILURE)
         {
            ETG_TRACE_USR4(("DBUS TransferCall  FAILS"));
            vHandleDbusError(ptProcessEventArg->u16DbusAckType,ptProcessEventArg->Code);
         }
         else
         {
            ETG_TRACE_USR4(("DBUS TransferCall  SUCCESS"));
            bRetVal = bProcessEvent(u16EventId);
         }
      }
      else
      {
         if(FC_PHONE_DBUS_STATUS_SUCCESS != ptProcessEventArg->Status)
         {
            ETG_TRACE_USR4((" DBUS Call is not succeed, updating error code  m_u8errorCode :: 0x%x",m_u8errorCode));
            ETG_TRACE_ERR(("DBUS Call is not succeed"));
            //m_u8errorCode = ptProcessEventArg->Code ;
            vHandleDbusError(ptProcessEventArg->u16DbusAckType,ptProcessEventArg->Code);
         }
         else
         {
            ETG_TRACE_USR4((" DBUS Call is  succeeded "));
            //m_u8errorCode = 0 ;
            bRetVal = bProcessEvent(u16EventId) ;
         }
      }
   }
   else
   {
      bRetVal = bProcessEvent(u16EventId) ;
   }


   return bRetVal ;
}
/*******************************************************************************
 *
 * FUNCTION: bProcessEvent
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/

tBool fc_phone_tclSMDial::bProcessEvent(tU16 u16EventId)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMDial::bProcessEvent "));
   m_u16State_CurrentState = m_u16State;
   switch (m_u16State)
   {
      case FC_PHONE_SMDIAL_STATE_WAIT_FOR_CONNECT_FROM_BT:
      {
         ETG_TRACE_USR2((" STATE :: FC_PHONE_SMDIAL_STATE_WAIT_FOR_CONNECT_FROM_BT "));
         vHandleEventInDialBTInCall(u16EventId);
      }
      break;

      case FC_PHONE_SMDIAL_STATE_WAIT_FOR_AM_RESPONSE_ACTIVATE_VOICE:
      {
         ETG_TRACE_USR2((" STATE :: FC_PHONE_SMDIAL_STATE_WAIT_FOR_AM_RESPONSE_ACTIVATE_VOICE "));
         vHandleEventInAMInActivateVoiceCall(u16EventId);
      }
      break;

      case FC_PHONE_SMDIAL_STATE_CONNECTED_FROM_BT:
      {
         ETG_TRACE_USR2((" STATE :: FC_PHONE_SMDIAL_STATE_CONNECTED_FROM_BT "));
         vHandleEventInDialConnectedWithBT(u16EventId);
      }
      break;


      case FC_PHONE_SMDIAL_STATE_CALL_ROUTED:
      {
         ETG_TRACE_USR2((" STATE :: FC_PHONE_SMDIAL_STATE_CALL_ROUTED "));
         vHandleEventInCallRouted(u16EventId);
      }
      break;

      case FC_PHONE_SMDIAL_STATE_WAIT_FOR_CANCELOUTGOINGCALL_AND_AUDIO :
      {
         ETG_TRACE_USR2((" STATE :: FC_PHONE_SMDIAL_STATE_WAIT_FOR_CANCELOUTGOINGCALL_AND_AUDIO "));
         vHandleEventInCancelOutgoingCallAndAudio(u16EventId);

      }
      break;


      case FC_PHONE_SMDIAL_STATE_WAIT_FOR_DISCONNECT_FROM_BT :
      {
         ETG_TRACE_USR2((" STATE :: FC_PHONE_SMDIAL_STATE_WAIT_FOR_DISCONNECT_FROM_BT "));
         vHandleEventInTerminateBTInCall(u16EventId);

      }
      break;

      case FC_PHONE_SMDIAL_STATE_WAIT_FOR_HOLDCALL:
      {
         ETG_TRACE_USR2((" STATE :: FC_PHONE_SMDIAL_STATE_WAIT_FOR_HOLDCALL "));
         vHandleEventInHoldCall(u16EventId);
      }

      break;

      case FC_PHONE_SMDIAL_STATE_WAIT_FOR_RESUMECALL :
      {
         ETG_TRACE_USR2((" STATE :: FC_PHONE_SMDIAL_STATE_WAIT_FOR_RESUMECALL "));
         vHandleEventInResumeCall(u16EventId);
      }
      break ;

      case FC_PHONE_SMDIAL_STATE_CALL_TRANSFERTOHANDSET :
      {
         ETG_TRACE_USR2((" STATE :: FC_PHONE_SMDIAL_STATE_CALL_TRANSFERTOHANDSET "));
         vHandleEventInRoutingHandsetCall(u16EventId);
      }
      break;

      case FC_PHONE_SMDIAL_STATE_WAIT_FOR_SWAPDBUSACK_AND_CALLSTATUS :
      {
         ETG_TRACE_USR2((" STATE :: FC_PHONE_SMDIAL_STATE_WAIT_FOR_SWAPDBUSACK_AND_CALLSTATUS "));
         vHandleEventInSwapDbusAckOrCallStatus(u16EventId);
      }
      break;

      case FC_PHONE_SMDIAL_STATE_WAIT_FOR_SWAPDBUSACK :
      case FC_PHONE_SMDIAL_STATE_WAIT_FOR_CALLSTATUS :
      {
         ETG_TRACE_USR2((" STATE :: FC_PHONE_SMDIAL_STATE_WAIT_FOR_SWAPDBUSACK :: FC_PHONE_SMDIAL_STATE_WAIT_FOR_CALLSTATUS "));
         vHandleEventInSwapCall(u16EventId);
      }
      break;

      case FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIO_RELEASE_AND_AUDIOTRANSFER_DBUS_CALL :
      {
         ETG_TRACE_USR2((" STATE :: FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIO_RELEASE_AND_DBUS_CALL  "));

         vHandleEventInReleaseAudioAndTransferAudio(u16EventId);

      }
      break ;

      case FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIOACTIVATION_FOR_RESTOREDIALSM :
      {
         ETG_TRACE_USR2((" STATE :: FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIOACTIVATION_FOR_RESTOREDIALSM  "));
         vHandleEventInAudioActivationOnRestoreDialSM(u16EventId);
      }
      break ;
      case FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIOTRANSFER_ONDIAL:
      {
         ETG_TRACE_USR2((" STATE :: FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIOTRANSFER_ONDIAL:: FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIOTRANSFER_ONDIAL "));
         vHandleEventInAudioTransferOnDial(u16EventId);
      }
      break;
      default:
      {
         ETG_TRACE_USR4(("bProcessEvent: DEFAULT STATE entered"));
      }
      break;
   }

   tBool bRetVal= m_bEventConsumed ;


   m_bEventConsumed = FALSE ;
   return bRetVal ;
}

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMDial::vHandleEventInAudioTransferOnDial
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMDial::vHandleEventInAudioTransferOnDial(tU16 u16EventId)
{
   ETG_TRACE_USR4(("  fc_phone_tclSMDial : vHandleEventInAudioTransferOnDial"));
   switch (u16EventId)
   {
   case FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK:
      {
         ETG_TRACE_USR3((" FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK"));
         //GMMY16-22441 - Since dial usecase flow is changed- first post dial req and then followed by channel allocation
         // for other call in handset, After audio is transfered, follow the same
         m_u16State = FC_PHONE_SMDIAL_STATE_WAIT_FOR_CONNECT_FROM_BT;
         ETG_TRACE_USR4((" State Change: FC_PHONE_SMDIAL_STATE_WAIT_FOR_CONNECT_FROM_BT "));
         if(m_poCallInstance)
         {
            if ((FC_PHONE_DIALTYPE_DIAL == m_en_dialType) || (FC_PHONE_DIALTYPE_DIALEXTENDED == m_en_dialType))
            {
               //GMMY15-5984:Final D2SC Telephone]If an outgoing call is made using BT Speech recognition, the call cannot be ended using SWC or centerstack .
               //No need to send dail req for the call which is dailed in handset
               if(m_phonenumber)
               {
                  ETG_TRACE_USR4((" Executing Dial ......."));
                  m_pDbusIf->bDial(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId),(const char*) m_phonenumber);
               }
               else
                  ETG_TRACE_ERR((" m_phonenumber is NULL"));
            }
            else
            {
               if(FC_PHONE_DIALTYPE_SPEEDDIAL == m_en_dialType)
               {
                  ETG_TRACE_USR4((" Executing Speed Dial ........."));
                  m_pDbusIf->bSpeedDial(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId),m_u16_memID);
               }
               else
               {
                  ETG_TRACE_USR4((" WARNING : Wrong Dial Type ID "));
               }
            }
         }
         else
         {
            ETG_TRACE_ERR(("Call Instance  is NULL"));
         }
      }
      break;
   default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMDial::vHandleEventInAudioTransferOnDial DEFAULT : Wrong Event ID u16EventId: %d",u16EventId));
      }
      break;
   }
}

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMDial::vHandleEventInAudioAcquisitionOnTransferAudioRequest
 *
 * DESCRIPTION: Handling Transfer Audio requests from phone
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMDial::vHandleEventInAudioAcquisitionOnTransferAudioRequest(tU16 u16EventId)
{
   ETG_TRACE_USR4(("  fc_phone_tclSMDial : vHandleEventInAudioAcquisitionOnTransferAudioRequest"));
   if(m_poCallInstance)
   {
      switch (u16EventId)
      {
         case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
         {
            ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_PHONE_REQUEST_OK"));
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE ;
            m_poCallInstance->m_bUsingVehicleAudio = TRUE;
            ETG_TRACE_USR3(("  UsingVehicleAudio = TRUE"));
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
            if(m_bTransferCallToVehicleRequest == TRUE)
            {
               m_bTransferCallToVehicleRequest = FALSE;
               //Send Method Result for Transfer call to Vehicle
               m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSFREE,m_poCallInstance);
            }
            m_u16State_while_TransferAudio = 0;

         }
         break;
         case FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK:
         {
            ETG_TRACE_USR3((" EVENT : FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK"));
            m_u16State_while_TransferAudio = FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIO_RELEASE_ON_TRANSFERCALLREQ_FROM_PHONE;
            if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_poCallInstance->m_u8AudioChannel)
            {
               ETG_TRACE_USR3((" Releasing  Audio m_poCallInstance "));
               m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id,FC_PHONE_AUDIOCHANNEL_PHONE,vAudioCallBackDial);
            }
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED ;
            m_poCallInstance->m_bUsingVehicleAudio = FALSE;
            ETG_TRACE_USR3(("  UsingVehicleAudio = FALSE "));
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
            m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId), FC_PHONE_CALLTRANSFER_FROMHANSFREE_TOHANDSET);

         }
         break;
         case FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK:
         {
            ETG_TRACE_USR3((" EVENT :FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK"));
            if( m_bTransferCallToVehicleRequest == TRUE)
            {
               m_bTransferCallToVehicleRequest = FALSE;
               //Send Method Result for Transfer call to Vehicle
               m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSFREE,m_poCallInstance);
            }
            else
            {
               m_u16State_while_TransferAudio = 0;
            }
            //m_u16State = FC_PHONE_SMDIAL_STATE_CALL_ROUTED;
         }
         break;
         default:
         {
            ETG_TRACE_USR4((" fc_phone_tclSMDial::vHandleEventInAudioAcquisitionOnTransferAudioRequest"
                  " DEFAULT : Wrong Event ID u16EventId: %d",u16EventId));
         }
         break;
      }
   }
   else
   {
      ETG_TRACE_ERR(("Call Instance  is NULL"));
   }
}


/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMDial::vHandleEventInAudioReleaseOnTransferAudioRequest
 *
 * DESCRIPTION: Handling Transfer Audio requests from phone
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMDial::vHandleEventInAudioReleaseOnTransferAudioRequest(tU16 u16EventId)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMDial : vHandleEventInAudioAudioReleaseOnTransferAudioRequest"));
   if(m_poCallInstance)
   {
      switch (u16EventId)
      {
         case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
         {
            ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_PHONE_REQUEST_OK"));
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED ;
            m_poCallInstance->m_bUsingVehicleAudio = FALSE;
            ETG_TRACE_USR3(("  UsingVehicleAudio = FALSE"));
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
            //			m_poSMManager->vRestoreToActiveCallInHandset(m_poCallInstance->m_u16Id);
            m_u16State_while_TransferAudio = 0;

         }
         break;
         case FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK:
         {
            ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK"));
            //AcquireAudioChannel and transfer audio to handsfree
            m_u16State_while_TransferAudio = FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIO_ACQUISITION_ON_TRANSFERCALLREQ_FROM_PHONE;

            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
            if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED == m_poCallInstance->m_u8AudioChannel)
            {
               ETG_TRACE_USR3((" Requesting Audio m_poCallInstance::  AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE"));
               m_poAudioManager->s32GetRequest(m_poCallInstance->m_u16Id,FC_PHONE_AUDIOCHANNEL_PHONE,vAudioCallBackDial);
            }
            m_poCallInstance->m_bUsingVehicleAudio = TRUE;
            ETG_TRACE_USR3(("  UsingVehicleAudio = TRUE "));
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
            m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId), FC_PHONE_CALLTRANSFER_FROMHANDSET_TOHANSFREE);

         }
         break;
         case FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK:
         {
            ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK"));
            m_u16State_while_TransferAudio = 0;
            //m_u16State = FC_PHONE_SMDIAL_STATE_CALL_ROUTED;
         }
         break;
         default:
         {
            ETG_TRACE_USR4(("fc_phone_tclSMDial::vHandleEventInAudioReleaseOnTransferAudioRequest"
                  " DEFAULT : Wrong Event ID u16EventId: %d",u16EventId));
         }
         break;
      }
   }
   else
   {
      ETG_TRACE_ERR(("Call Instance  is NULL"));
   }
}

/*******************************************************************************
 *
 * FUNCTION: vHandleEventInRejectBTInCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/

tVoid fc_phone_tclSMDial::vHandleEventInDialBTInCall(tU16 u16EventId)
{
   ETG_TRACE_USR4(("Entering fc_phone_tclSMManager::vHandleEventInDialBTInCall "));
   switch (u16EventId)
   {

      case FC_PHONE_SM_EVENT_DBUS_DIAL_ACK_OK :
      {
         ETG_TRACE_USR3((" EVENT :: FC_PHONE_SM_EVENT_DBUS_DIAL_ACK_OK "));

         //Send Method Result
         if(m_poCallInstance)
         {
            m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;

            if(FC_PHONE_DIALTYPE_DIAL == m_en_dialType)
            {
               ETG_TRACE_USR4((" Sending Dial Method Result"));
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_DIAL,m_poCallInstance);
               // Wait for 15 Secs to get the call status as DIALING
               m_poTimer->s32Start(static_cast<tU16>(FC_PHONE_DIAL_CALLSTATUS_FAILURE_TIMER_ID + m_poCallInstance->m_u16Id),
                     ( 15 * FC_PHONE_ONE_SECOND ),vCallInstanceTimerCallBack);
               m_bCallStatusFailureTimerRunning = TRUE;
            }
            else if(FC_PHONE_DIALTYPE_SPEEDDIAL == m_en_dialType)
            {
               ETG_TRACE_USR4((" Sending SpeedDial Method Result"));
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_SPEEDDIAL,m_poCallInstance);
               m_poTimer->s32Start(static_cast<tU16>(FC_PHONE_DIAL_CALLSTATUS_FAILURE_TIMER_ID + m_poCallInstance->m_u16Id),
                  ( 15 * FC_PHONE_ONE_SECOND ),vCallInstanceTimerCallBack);
               m_bCallStatusFailureTimerRunning = TRUE;
            }
            else if (FC_PHONE_DIALTYPE_DIALEXTENDED == m_en_dialType)
            {
               ETG_TRACE_USR4((" Sending DialExtended Method Result"));
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_DIALEXTENDED,m_poCallInstance);
               m_poTimer->s32Start(static_cast<tU16>(FC_PHONE_DIAL_CALLSTATUS_FAILURE_TIMER_ID + m_poCallInstance->m_u16Id),
                  ( 15 * FC_PHONE_ONE_SECOND ),vCallInstanceTimerCallBack);
               m_bCallStatusFailureTimerRunning = TRUE;			   
            }
            else
            {
               ETG_TRACE_USR4((" warning : wrong Dial Type Id"));
            }
            m_u16State = FC_PHONE_SMDIAL_STATE_CONNECTED_FROM_BT;
            ETG_TRACE_USR2((" State Change:FC_PHONE_SMDIAL_STATE_CONNECTED_FROM_BT "));
            tU8 u8SCOConnectionStatus = FC_PHONE_DBUS_SCO_CONN_FAILED;
            fc_phone_tclClientHandler_BTSettings *p_clientHndler_bluetooth = (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerBTSettings;
            u8SCOConnectionStatus = p_clientHndler_bluetooth->vGetSCOConnectionStatus(const_cast<tChar *> (fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId))); //CMG3G-4847 - To solve Lint
            ETG_TRACE_USR4(("  fc_phone_tclSMDial::u8SCOConnectionStatus = %d ",u8SCOConnectionStatus));
            if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_ESTABLISHED)
            {
               m_u16State = FC_PHONE_SMDIAL_STATE_WAIT_FOR_AM_RESPONSE_ACTIVATE_VOICE;
               ETG_TRACE_USR3((" State Change: FC_PHONE_SMDIAL_STATE_WAIT_FOR_AM_RESPONSE_ACTIVATE_VOICE"));
               if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED == m_poCallInstance->m_u8AudioChannel )
               {
                  m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
                  ETG_TRACE_USR3((" Requesting Audio m_poCallInstance::  AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE"));
                  m_poAudioManager->s32GetRequest(m_poCallInstance->m_u16Id,FC_PHONE_AUDIOCHANNEL_PHONE,vAudioCallBackDial);
               }
               else
               {
                  bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
               }
            }
            else
            {
               ETG_TRACE_USR3((" SCO-Disconnected wait for SCO connection"));
            }

         }
         else
         {
            ETG_TRACE_ERR(("Call Instance  is NULL"));
         }
      }
      break;
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
      {
         ETG_TRACE_USR3(("  EVENT ::FC_PHONE_SM_EVENT_PHONE_REQUEST_OK "));
         if(m_u16State_while_TransferAudio == FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIO_RELEASE_ON_TRANSFERCALLREQ_FROM_PHONE)
         {
            vHandleEventInAudioReleaseOnTransferAudioRequest(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
         }
         else if(m_u16State_while_TransferAudio == FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIO_ACQUISITION_ON_TRANSFERCALLREQ_FROM_PHONE)
         {
            vHandleEventInAudioAcquisitionOnTransferAudioRequest(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
         }
      }
      break;
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK:
      {
         ETG_TRACE_USR3(("  EVENT ::FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK "));
         if(m_u16State_while_TransferAudio == FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIO_RELEASE_ON_TRANSFERCALLREQ_FROM_PHONE)
         {
            vHandleEventInAudioReleaseOnTransferAudioRequest(FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK);
         }
         else if(m_u16State_while_TransferAudio == FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIO_ACQUISITION_ON_TRANSFERCALLREQ_FROM_PHONE)
         {
            vHandleEventInAudioAcquisitionOnTransferAudioRequest(FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK);
         }
      }
      break;

      case FC_PHONE_SM_EVENT_CANCELOUTGOINGCALL_OK :
      {
         ETG_TRACE_USR3(("  EVENT ::FC_PHONE_SM_EVENT_CANCELOUTGOINGCALL_OK "));
         m_bTerminateCallRequest = TRUE;
         //Fix for GMMY15-6691
         vCancelOutgoingCall();
         m_bEventConsumed = TRUE;
      }
      break;
      default:
      {
         ETG_TRACE_USR4(("  fc_phone_tclSMDial::vHandleEventInDialBTInCall:: Default  "));
      }
      break;
   }
}


/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMDial::vHandleEventInAMInActivateVoiceCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMDial::vHandleEventInAMInActivateVoiceCall(tU16 u16EventId)
{

   ETG_TRACE_USR4((" Entering fc_phone_tclSMDial::vHandleEventInAMInActivateVoiceCall"));

   //FIX GMMY15-4458 Nullpointerexception in "phone.out"
   //Adding null check to m_poCallInstance
   if(m_poCallInstance)
   {
      switch (u16EventId)
      {
         case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
         {

            if(m_u16State_while_TransferAudio == FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIO_RELEASE_ON_TRANSFERCALLREQ_FROM_PHONE)
            {
               vHandleEventInAudioReleaseOnTransferAudioRequest(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
            }
            else if(m_u16State_while_TransferAudio == FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIO_ACQUISITION_ON_TRANSFERCALLREQ_FROM_PHONE)
            {
               vHandleEventInAudioAcquisitionOnTransferAudioRequest(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
            }
            else
            {
               // come back to routed state as routed state happens when callstatus beccomes active
               //, so when hf-release followed by hf-set up comes it should be made back to routed state.
               ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_PHONE_REQUEST_OK"));
               /* Receiving audio channel is complete */
               m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
               m_poCallInstance->m_bUsingVehicleAudio = TRUE ;
               ETG_TRACE_USR3(("  UsingVehicleAudio = TRUE"));
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
            }
            m_u16State = FC_PHONE_SMDIAL_STATE_CALL_ROUTED;
            ETG_TRACE_USR3(("  STATE Change : FC_PHONE_SMDIAL_STATE_CALL_ROUTED"));
         }
         break;

         case FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK:
         {

            ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK"));
            /* TO DO:Transfer the call to handset */
            m_poCallInstance->m_bUsingVehicleAudio = FALSE;
            ETG_TRACE_USR3(("  UsingVehicleAudio = FALSE"));
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,
                  m_poCallInstance);
            m_u16State = FC_PHONE_SMDIAL_STATE_CALL_TRANSFERTOHANDSET;
            ETG_TRACE_USR2((" State Change: FC_PHONE_SMDIAL_STATE_CALL_TRANSFERTOHANDSET "));
            tU8 u8SCOConnectionStatus = FC_PHONE_DBUS_SCO_CONN_FAILED;
            fc_phone_tclClientHandler_BTSettings *p_clientHndler_bluetooth = (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerBTSettings;
            u8SCOConnectionStatus = p_clientHndler_bluetooth->vGetSCOConnectionStatus(const_cast<tChar *> (fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId))); //CMG3G-4847 - To solve Lint

            if((fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->m_bDialMethodStartFlag  == TRUE)
            {
               m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACK_NO_AUDIO_CHANNEL;
               if(FC_PHONE_DIALTYPE_DIAL == m_en_dialType)
               {
                  ETG_TRACE_USR4((" Sending Dial Method Result"));
                  m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_DIAL,m_poCallInstance);
               }
               else if(FC_PHONE_DIALTYPE_DIALEXTENDED == m_en_dialType){
                  ETG_TRACE_USR4((" Sending DialExtended Method Result"));
                  m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_DIALEXTENDED,m_poCallInstance);
               }
            }
            //Dbus call for transferring call to handset
            if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_ESTABLISHED)
            {
               ETG_TRACE_USR4(("FC_PHONE_DBUS_SCO_CONN_ESTABLISHED"));
               m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId), FC_PHONE_CALLTRANSFER_FROMHANSFREE_TOHANDSET);
            }
            else
            {

               ETG_TRACE_USR4(("FC_PHONE_DBUS_SCO_CONN_STATUS_UNKNOWN"));

               //Update the audio channel status
               m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
               m_poCallInstance->m_bUsingVehicleAudio = FALSE;
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);

               //to stop timer if active
               vStopTimer();

               vCancel();
               m_poCallInstance->vInit();
               //send status to client : now status is IDLE
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
               m_poSMManager->vSMFinished(m_poCallInstance->m_u16Id);
            }
         }
         break;

         case FC_PHONE_SM_EVENT_CANCELOUTGOINGCALL_OK :
         {
            ETG_TRACE_USR3(("  EVENT ::FC_PHONE_SM_EVENT_CANCELOUTGOINGCALL_OK "));
            //m_bTerminateCallReqBeforeDial = TRUE;
            m_bTerminateCallRequest = TRUE;
            vCancelOutgoingCall();
            m_bEventConsumed = TRUE;
         }
         break;

         case FC_PHONE_SM_EVENT_HOLDCALL_REQUEST:
         {
            ETG_TRACE_USR3((" EVENT ::FC_PHONE_SM_EVENT_HOLDCALL_REQUEST "));

            /* Forward Hold Request to DBus */
            m_u16State_while_Hold = m_u16State ;
            m_u16State = FC_PHONE_SMDIAL_STATE_WAIT_FOR_HOLDCALL;
            ETG_TRACE_USR4((" State Change: FC_PHONE_SMDIAL_STATE_WAIT_FOR_HOLDCALL "));
            m_pDbusIf->bHoldCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId));
         }
         break;


         default:
         {
            ETG_TRACE_USR3((" EVENT ::is not serviced in vHandleEventInAMInActivateVoiceCall "));
         }
         break;
      }
   }
   else
   {
      ETG_TRACE_ERR(("Call Instance received is NULL"));
   }
}
/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMDial::vHandleEventInAudioActivationOnRestoreDialSM
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMDial::vHandleEventInAudioActivationOnRestoreDialSM(tU16 u16EventId)
{

   ETG_TRACE_USR4(("  Entering fc_phone_tclSMDial::vHandleEventInAudioActivationOnRestoreDialSM"));
   if(m_poCallInstance)
   {
      switch (u16EventId)
      {
         case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
         {
            ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_PHONE_REQUEST_OK"));
            m_u16State = FC_PHONE_SMDIAL_STATE_CALL_ROUTED;
            ETG_TRACE_USR2((" State Change: FC_PHONE_SMDIAL_STATE_CALL_ROUTED "));
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
            m_poCallInstance->m_bUsingVehicleAudio = TRUE;
            ETG_TRACE_USR3(("  UsingVehicleAudio = TRUE "));
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
         }
         break;
         case FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK:
         {
            ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK"));
            /* TO DO:Transfer the call to handset */
            m_poCallInstance->m_bUsingVehicleAudio = FALSE;
            ETG_TRACE_USR3(("  UsingVehicleAudio = FALSE "));
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
            m_u16State = FC_PHONE_SMDIAL_STATE_CALL_TRANSFERTOHANDSET;
            ETG_TRACE_USR2((" State Change: FC_PHONE_SMDIAL_STATE_CALL_TRANSFERTOHANDSET "));
            m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId), FC_PHONE_CALLTRANSFER_FROMHANSFREE_TOHANDSET);
         }
         break;
         default:
         {
            ETG_TRACE_USR4(("fc_phone_tclSMDial::vHandleEventInAudioActivationOnRestoreDialSM :: Default "));
         }
         break;
      }
   }
   else
   {
      ETG_TRACE_ERR(("Call Instance  is NULL"));
   }
}



/*******************************************************************************
 *
 * FUNCTION: vHandleEventInDialConnectedWithBT
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/

tVoid fc_phone_tclSMDial::vHandleEventInDialConnectedWithBT(tU16 u16EventId)
{


   ETG_TRACE_USR4(("Entering  fc_phone_tclSMManager::vHandleEventInDialConnectedWithBT "));

   switch (u16EventId)
   {

      case FC_PHONE_SM_EVENT_CANCELOUTGOINGCALL_OK :
      {
         ETG_TRACE_USR3((" EVENT :: FC_PHONE_SM_EVENT_CANCELOUTGOINGCALL_OK "));
         m_bTerminateCallRequest = TRUE;
         vCancelOutgoingCall();
         m_bEventConsumed = TRUE;
      }
      break;
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
      {
         ETG_TRACE_USR3((" EVENT ::FC_PHONE_SM_EVENT_PHONE_REQUEST_OK "));
         if(m_u16State_while_TransferAudio == FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIO_RELEASE_ON_TRANSFERCALLREQ_FROM_PHONE)
         {
            vHandleEventInAudioReleaseOnTransferAudioRequest(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
         }
         else if(m_u16State_while_TransferAudio == FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIO_ACQUISITION_ON_TRANSFERCALLREQ_FROM_PHONE)
         {
            vHandleEventInAudioAcquisitionOnTransferAudioRequest(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
         }
      }
      break;
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK:
      {
         ETG_TRACE_USR3((" EVENT ::FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK "));
         if(m_u16State_while_TransferAudio == FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIO_RELEASE_ON_TRANSFERCALLREQ_FROM_PHONE)
         {
            vHandleEventInAudioReleaseOnTransferAudioRequest(FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK);
         }
         else if(m_u16State_while_TransferAudio == FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIO_ACQUISITION_ON_TRANSFERCALLREQ_FROM_PHONE)
         {
            vHandleEventInAudioAcquisitionOnTransferAudioRequest(FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK);
         }
      }
      break;
      case FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK:
      {
         ETG_TRACE_USR3((" EVENT ::FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK "));
         if(m_u16State_while_TransferAudio == FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIO_RELEASE_ON_TRANSFERCALLREQ_FROM_PHONE)
         {
            vHandleEventInAudioReleaseOnTransferAudioRequest(FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK);
         }
         else if(m_u16State_while_TransferAudio == FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIO_ACQUISITION_ON_TRANSFERCALLREQ_FROM_PHONE)
         {
            vHandleEventInAudioAcquisitionOnTransferAudioRequest(FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK);
         }
      }
      break;

      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMDial::vHandleEventInDialConnectedWithBT:: Default "));
      }
      break;
   }

}


/*******************************************************************************
 *
 * FUNCTION: vHandleEventInCallRouted
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMDial::vHandleEventInCallRouted(tU16 u16EventId)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMDial::vHandleEventInCallRouted with EventId %d",u16EventId));
   if(m_poCallInstance)
   {

      switch (u16EventId)
      {
         case FC_PHONE_SM_EVENT_CANCELOUTGOINGCALL_OK :
         {
            m_bTerminateCallRequest = TRUE;
            ETG_TRACE_USR3((" EVENT :: FC_PHONE_SM_EVENT_CANCELOUTGOINGCALL_OK "));

            //update the state
            m_u16State = FC_PHONE_SMDIAL_STATE_WAIT_FOR_CANCELOUTGOINGCALL_AND_AUDIO ;
            ETG_TRACE_USR2((" State Change: FC_PHONE_SMDIAL_STATE_WAIT_FOR_CANCELOUTGOINGCALL_AND_AUDIO "));

            //release ringtone/Alert audio channel, if in use
            if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED !=  m_poCallInstance->m_u8AudioChannel )
            {
               ETG_TRACE_USR3((" Releasing  Audio m_poCallInstance "));
               m_poAudioManager->s32ReleaseRequest( m_poCallInstance->m_u16Id,m_poCallInstance->m_u8AudioChannel,vAudioCallBackDial);
               m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
            }
            else
            {
               //No audio channel engaged, so going to next step by faking FC_PHONE_SM_EVENT_PHONE_REQUEST_OK
               bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);

            }
            m_bEventConsumed = TRUE;
            //do thing for cancel outgoing call
         }
         break;

         case FC_PHONE_SM_EVENT_HOLDCALL_REQUEST:
         {
            ETG_TRACE_USR3(("  EVENT ::FC_PHONE_SM_EVENT_HOLDCALL_REQUEST "));

            /* Forward Hold Request to DBus */

            m_u16State = FC_PHONE_SMDIAL_STATE_WAIT_FOR_HOLDCALL;
            ETG_TRACE_USR2((" State Change: FC_PHONE_SMDIAL_STATE_WAIT_FOR_HOLDCALL "));
            m_pDbusIf->bHoldCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId));
         }
         break;

         case FC_PHONE_SM_EVENT_SENDDTMF:
         {
            ETG_TRACE_USR3(("  EVENT ::FC_PHONE_SM_EVENT_SENDDTMF u16_DialoneTimeDTMFCalculation:: %d ",u16_DialoneTimeDTMFCalculation));

            if(0 == u16_DialoneTimeDTMFCalculation)
            {
               u16_DialoneTimeDTMFCalculation = 1;
               m_u16DTMFCharLength  = static_cast<tU16>(OSAL_u32StringLength(m_poCallInstance->DTMFChar));
               m_u16SentDtmfCounter  = 0;
               (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vSetDtmfStatus(TRUE);
               ETG_TRACE_USR4(("  m_u16DTMFCharLength :: %d ",m_u16DTMFCharLength));
            }

            tU8 u8DtmfValue = (tU8)m_poCallInstance->DTMFChar[m_u16SentDtmfCounter];
            m_pDbusIf->bSendDTMF(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId),u8DtmfValue);
         }
         break;

         case FC_PHONE_SM_EVENT_DBUS_DTMF_ACK_OK:
         {
            ETG_TRACE_USR3(("  EVENT ::FC_PHONE_SM_EVENT_DBUS_DTMF_ACK_OK "));

            m_u16SentDtmfCounter++;
            if(m_u16SentDtmfCounter == m_u16DTMFCharLength)
            {
               ETG_TRACE_USR4(("  SENDING DTMF SUCCESS ,sending MR to client"));
               u16_DialoneTimeDTMFCalculation = 0;
               m_u16SentDtmfCounter  = 0;
               m_u16DTMFCharLength   = 0;
               m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_PLAYDTMF,m_poCallInstance);
               (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vSetDtmfStatus(FALSE);
            }
            else
            {
               ETG_TRACE_USR4((" Previous DTMF sent, processing for next  "));
               bProcessEvent(FC_PHONE_SM_EVENT_SENDDTMF);
            }
         }
         break;

         case FC_PHONE_SM_EVENT_SWAPCALL_OK :
         {
            ETG_TRACE_USR3((" FC_PHONE_SM_EVENT_SWAPCALL_OK :; calling dbus swapcall "));

            m_bEventConsumed = TRUE ;
            m_u16State = FC_PHONE_SMDIAL_STATE_WAIT_FOR_SWAPDBUSACK_AND_CALLSTATUS ;
            ETG_TRACE_USR2((" State Change: FC_PHONE_SMDIAL_STATE_WAIT_FOR_SWAPDBUSACK_AND_CALLSTATUS  "));
            m_pDbusIf->bSwapCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId));
         }
         break ;

         case FC_PHONE_SM_EVENT_IF_VEHICLECALL_TRANSFER_TOHANTSET :
         {
            ETG_TRACE_USR3((" FC_PHONE_SM_EVENT_IF_VEHICLECALL_TRANSFER_TOHANTSET"));

            //release audio
            //Send Dbus method for audio Transfer
            //Start ActiveCall In Handset SM
            m_u16State = FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIO_RELEASE_AND_AUDIOTRANSFER_DBUS_CALL ;
            ETG_TRACE_USR2((" State Change: FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIO_RELEASE_AND_AUDIOTRANSFER_DBUS_CALL  "));
            if(m_poCallInstance->m_u8AudioChannel != FC_PHONE_AUDIOCHANNEL_ID_UNUSED)
            {
               ETG_TRACE_USR3((" Releasing  Audio m_poCallInstance "));
               m_poAudioManager->s32ReleaseRequest( m_poCallInstance->m_u16Id,m_poCallInstance->m_u8AudioChannel,vAudioCallBackDial);
               m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
            }
            else
            {
               bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
            }
         }
         break ;

         case FC_PHONE_SM_EVENT_RESUMECALL_REQUEST:
         {
            ETG_TRACE_USR3(("  EVENT ::FC_PHONE_SM_EVENT_RESUMECALL_REQUEST "));
            /* Forward Resume Request to DBus */
            m_u16State = FC_PHONE_SMDIAL_STATE_WAIT_FOR_RESUMECALL;
            ETG_TRACE_USR2((" State Change: FC_PHONE_SMDIAL_STATE_WAIT_FOR_RESUMECALL  "));
            m_pDbusIf->bResumeCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId));
         }
         break;

         case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
         {
            ETG_TRACE_USR3(("  EVENT ::FC_PHONE_SM_EVENT_PHONE_REQUEST_OK "));
            if(m_u16State_while_TransferAudio == FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIO_RELEASE_ON_TRANSFERCALLREQ_FROM_PHONE)
            {
               vHandleEventInAudioReleaseOnTransferAudioRequest(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
            }
            else if(m_u16State_while_TransferAudio == FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIO_ACQUISITION_ON_TRANSFERCALLREQ_FROM_PHONE)
            {
               vHandleEventInAudioAcquisitionOnTransferAudioRequest(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
            }
         }
         break;

         case FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK:
         {
            ETG_TRACE_USR3(("  EVENT ::FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK "));
            if(m_u16State_while_TransferAudio == FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIO_RELEASE_ON_TRANSFERCALLREQ_FROM_PHONE)
            {
               vHandleEventInAudioReleaseOnTransferAudioRequest(FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK);
            }
            else if(m_u16State_while_TransferAudio == FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIO_ACQUISITION_ON_TRANSFERCALLREQ_FROM_PHONE)
            {
               vHandleEventInAudioAcquisitionOnTransferAudioRequest(FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK);
            }
         }
         break;

         case FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK:
         {
            ETG_TRACE_USR3(("  EVENT ::C_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK "));
            if(m_u16State_while_TransferAudio == FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIO_RELEASE_ON_TRANSFERCALLREQ_FROM_PHONE)
            {
               vHandleEventInAudioReleaseOnTransferAudioRequest(FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK);
            }
            else if(m_u16State_while_TransferAudio == FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIO_ACQUISITION_ON_TRANSFERCALLREQ_FROM_PHONE)
            {
               vHandleEventInAudioAcquisitionOnTransferAudioRequest(FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK);
            }
         }
         break;

         case FC_PHONE_SM_EVENT_TRANSFERCALLVEHICLE_REQUEST_OK:
         {
            ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_TRANSFERCALLVEHICLE_REQUEST_OK"));
            //Act like for SetUpAudio
            if(m_poCallInstance->m_bUsingVehicleAudio == FALSE)
            {
               m_bEventConsumed = TRUE;
               m_bTransferCallToVehicleRequest = TRUE;
               m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId), FC_PHONE_CALLTRANSFER_FROMHANDSET_TOHANSFREE);
            }
            else
            {
               //Send Method Error for Transfer call to Vehicle
               m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSFREE,m_poCallInstance);
            }
         }
         break;

         // Bugfix for SUZUKI-17949: Unable to make outgoing call from call/contact/dialpad
         case FC_PHONE_SM_EVENT_DBUS_TERMINATE_ACK_OK:
         {
            ETG_TRACE_USR4(("FC_PHONE_SM_EVENT_DBUS_TERMINATE_ACK_OK"));
            vHandleEventInTerminateBTInCall(u16EventId);
         }
         break;

         case FC_PHONE_SM_EVENT_DBUS_SWAPCALL_ACK_OK:
         {
            //Post method result only on DBUS ack
            ETG_TRACE_USR3(("vHandleEventInSwapCall: SENDING SWAPCALL MR to client"));
            m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_SWAPCALL,m_poCallInstance);
            
         }
         break;
         
#ifdef PHONE_WAITINGMODE
      case FC_PHONE_SM_EVENT_START_WAITING_MODE:
      {
         ETG_TRACE_USR3((" EVENT:: FC_PHONE_SM_EVENT_START_WAITING_MODE "));

         m_bEventConsumed = TRUE;

         if (FALSE ==
               ((fc_phone_tclApp::m_poMainAppInstance)->m_poPhoneAudioRouting->vTriggerPhoneAudioAllocation(
                     FC_PHONE_AUDIOCHANNEL_PHONEWAIT)))
         {
            ETG_TRACE_ERR(("Audio Route request posting failed!"));

            fc_phone_tclWaitingMode* poWaitingMode = fc_phone_tclWaitingMode::poGetInstance();
            poWaitingMode->bProcessEvent(FC_PHONE_WAITING_MODE_EVENT_PHONEWAIT_SRC_ROUTING_FAILED);
         }
      }
      break;
#endif

         default:
         {
            ETG_TRACE_USR3(("fc_phone_tclSMDial::vHandleEventInCallRouted Default. "));
            m_bEventConsumed = FALSE ;
         }
         break;
      }
   }
   else
   {
      ETG_TRACE_ERR(("Call Instance  is NULL"));
   }
}



/*******************************************************************************
 *
 * FUNCTION: vHandleEventInSwapDbusAckOrCallStatus
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMDial::vHandleEventInSwapDbusAckOrCallStatus(tU16 u16EventId)
{
   ETG_TRACE_USR4(("Entering fc_phone_tclSMDial::vHandleEventInSwapDbusAckOrCallStatus with EventId: %d",u16EventId));

   switch (u16EventId)
   {

      case FC_PHONE_SM_EVENT_DBUS_SWAPCALL_ACK_OK :
      {
         ETG_TRACE_USR3(("  FC_PHONE_SM_EVENT_DBUS_SWAPCALL_ACK_OK "));
         m_u16State = FC_PHONE_SMDIAL_STATE_WAIT_FOR_CALLSTATUS ;
         ETG_TRACE_USR2((" State Change: FC_PHONE_SMDIAL_STATE_WAIT_FOR_CALLSTATUS  "));
         //Post method result
         m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_SWAPCALL,m_poCallInstance);
      }
      break ;

      case FC_PHONE_SM_EVENT_CALLSTATUS_UPDATE :
      {
         ETG_TRACE_USR3(("  FC_PHONE_SM_EVENT_DBUS_SWAPCALL_ACK_OK "));
         m_u16State = FC_PHONE_SMDIAL_STATE_WAIT_FOR_SWAPDBUSACK ;
         ETG_TRACE_USR2((" State Change: FC_PHONE_SMDIAL_STATE_WAIT_FOR_SWAPDBUSACK  "));
      }
      break ;

      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMDial::vHandleEventInSwapDbusAckOrCallStatus Default. u16EventId:: %d",u16EventId));
      }
      break;
   }
}

/*******************************************************************************
 *
 * FUNCTION: vHandleEventInSwapCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMDial::vHandleEventInSwapCall(tU16 u16EventId)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMDial::vHandleEventInSwapCall with EventId %d ",u16EventId));
   if(m_poCallInstance)
   {
      switch (u16EventId)
      {

      case FC_PHONE_SM_EVENT_DBUS_SWAPCALL_ACK_OK :
         {
            //Post method result only on DBUS ack
            ETG_TRACE_USR3(("vHandleEventInSwapCall: SENDING SWAPCALL MR to client"));
            m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_SWAPCALL,m_poCallInstance);
         }
         //Break not required here as state has to be changed to routed.
      case FC_PHONE_SM_EVENT_CALLSTATUS_UPDATE :
         {
            m_u16State = FC_PHONE_SMDIAL_STATE_CALL_ROUTED ;
            ETG_TRACE_USR2((" State Change: FC_PHONE_SMDIAL_STATE_CALL_ROUTED "));
         }
         break ;


         default:
         {
            ETG_TRACE_USR4(("vHandleEventInSwapCall: Default entered with u16EventId:: %d",u16EventId));
         }
         break;
      }
   }
   else
   {
      ETG_TRACE_ERR(("Call Instance  is NULL"));
   }
}



/*******************************************************************************
 *
 * FUNCTION: vHandleEventInReleaseAudioAndTransferAudio
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMDial::vHandleEventInReleaseAudioAndTransferAudio(tU16 u16EventId)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMDial::vHandleEventInReleaseAudioAndTransferAudio with EventId %d",u16EventId));
   if(m_poCallInstance)
   {
      switch (u16EventId)
      {
         case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
         {
            ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_PHONE_REQUEST_OK"));


            //Update the audio channel status
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED ;
            m_poCallInstance->m_bUsingVehicleAudio = FALSE;
            ETG_TRACE_USR3(("  UsingVehicleAudio = FALSE "));
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO, m_poCallInstance);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, m_poCallInstance);
            m_poSMManager->vRestoreToActiveCallInHandset(m_poCallInstance->m_u16Id);
         }
         break;

         case FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK:
         {
            ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK"));
            m_u16State = FC_PHONE_SMDIAL_STATE_CALL_ROUTED;
            ETG_TRACE_USR2((" State Change:FC_PHONE_SMDIAL_STATE_CALL_ROUTED "));
            m_poCallInstance->m_bUsingVehicleAudio = TRUE;
            ETG_TRACE_USR3(("  UsingVehicleAudio = TRUE "));
         }
         break;
         default:
            break;
      }
   }
   else
   {
      ETG_TRACE_ERR(("Call Instance  is NULL"));
   }
}

/*******************************************************************************
 *
 * FUNCTION: vHandleEventInCancelOutgoingCallAndAudio
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMDial::vHandleEventInCancelOutgoingCallAndAudio(tU16 u16EventId)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMDial::vHandleEventInCancelOutgoingCallAndAudio with EventId %d",u16EventId));

   fc_phone_tclCallManager *p_callManagerInstance = (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->m_poCallManager ;
   if(m_poCallInstance)
   {
      switch (u16EventId)
      {
         case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
         {

            ETG_TRACE_USR3(("  EVENT : OR FC_PHONE_SM_EVENT_PHONE_REQUEST_OK"));

            //Update the audio channel status
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED ;
            m_poCallInstance->m_bUsingVehicleAudio = FALSE;
            ETG_TRACE_USR3(("  UsingVehicleAudio = FALSE "));
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,
                  m_poCallInstance);

            //Dbus call to disconnect call from BT
            //hf dial not posted to phone device.
            if(m_bTerminateCallReqBeforeDial)
            {
               //send property status to client
               m_poCallInstance->m_u16CallStatusNotice = FC_PHONE_CALLINSTANCE_CALLSTATUS_DIALING;
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
               m_bTerminateCallReqBeforeDial = FALSE;

               //posting dial method error as hf_dial is not posted to phone device and cancel outgoing call is received .
               if((fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->m_bDialMethodStartFlag  == TRUE)
               {
                  ETG_TRACE_USR3(("  m_bDialMethodStartFlag  == TRUE, sending  DIAL method error "));
                  m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOTAVAILABLE;
                  if(FC_PHONE_DIALTYPE_DIAL == m_en_dialType)
                  {
                     ETG_TRACE_USR4((" Sending Dial Method Result"));
                     m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_DIAL,m_poCallInstance);
                  }
                  else if(FC_PHONE_DIALTYPE_DIALEXTENDED == m_en_dialType){
                     ETG_TRACE_USR4((" Sending DialExtended Method Result"));
                     m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_DIALEXTENDED,m_poCallInstance);
                  }
               }
               //to stop timer if active
               vStopTimer();

               vCancel();
               //send method result
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_CANCELOUTGOINGCALL,m_poCallInstance);
               m_poCallInstance->vInit();
               //send status to client : now status is IDLE
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
               m_poSMManager->vSMFinished(m_poCallInstance->m_u16Id);
            }
            else if (m_bTerminateCallRequest)
            {
               vTerminateOutgoingCall();
            }
            else if(p_callManagerInstance && p_callManagerInstance->bCheckCallActive(m_poCallInstance->m_u16Id))
            {
               vTerminateOutgoingCall();
            }
         }
         break;

         case FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK:
         {
            ETG_TRACE_USR2(("  EVENT :OR  FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK"));
            /* TO DO:Transfer the call to handset */
            m_poCallInstance->m_bUsingVehicleAudio = TRUE;
            ETG_TRACE_USR3(("  UsingVehicleAudio = TRUE "));
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,
                  m_poCallInstance);

         }
         break;

         default:
         {
            ETG_TRACE_USR4(("  fc_phone_tclSMDial::vHandleEventInCancelOutgoingCallAndAudio :: Default"));
         }
         break;
      }
   }
   else
   {
      ETG_TRACE_ERR(("Call Instance  is NULL"));
   }
}


/*******************************************************************************
 *
 * FUNCTION: vHandleEventInCancelOutgoingBTInCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMDial::vHandleEventInTerminateBTInCall(tU16 u16EventId)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMDial::vHandleEventInTerminateBTInCall %d",u16EventId));
   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_DBUS_TERMINATE_ACK_OK:
         {

            m_u8RetryCount = 0;
            vStopTerminateRetryTimer(); //Start terminate retry timer if running.
            ETG_TRACE_USR3(("  EVENT : OR FC_PHONE_SM_EVENT_DBUS_TERMINATE_ACK_OK"));
            //to stop timer if active
            if(m_bTerminateCallPosted ==  TRUE)
            {
               m_bTerminateCallPosted = FALSE;
               if(m_poCallInstance)
               {
                  //send method result
                  m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_CANCELOUTGOINGCALL,\
                     m_poCallInstance);
               }

               else
               {
                  ETG_TRACE_ERR(("Call Instance  is NULL"));
               }
            }
         }
      break;
      default:
      {
         ETG_TRACE_ERR(("  ERROR : fc_phone_tclSMDial::vHandleEventInTerminateBTInCall:: DEFAULT  u16EventId %d",u16EventId));
      }
      break;
   }




}




/*******************************************************************************
 *
 * FUNCTION: vNewCallStatus
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMDial::vNewCallStatus(const T_CallData* const prCallData,tU16 u16_callInstance)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMDial::vNewCallStatus "));
   (tVoid)u16_callInstance ;

   //FIX GMMY15-4458 Variables m_poCallInstance and prCallData were accessed without checking if they are NULL; which is wrong.
   if(prCallData && m_poCallInstance)
   {
      vStopCallStatusFailureTimer(); // stop the wait for callstatus timer as new callstaus is received
      switch (m_u16State)
      {
         case FC_PHONE_SMDIAL_STATE_WAIT_FOR_SWAPDBUSACK_AND_CALLSTATUS :
         case FC_PHONE_SMDIAL_STATE_WAIT_FOR_CALLSTATUS :
         {
            if( PHONE_CALLSTATE_IDLE == prCallData->rCallStatus.u8CallState)
            {
               ETG_TRACE_USR3((" vNewCallStatus :PHONE_CALLSTATE_IDLE == prCallData->rCallStatus.u8CallState "));
               //update the state
               m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_SWAPCALL,m_poCallInstance);
               //m_u16State = FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIO_RELEASE_AND_INIT_IDLE ;
               //release ringtone/Alert audio channel, if in use
               vCancelSMReleaseChannel();
            }
            else
            {
               ETG_TRACE_USR4(("UPDATING CALL STATUS TO Cleint "));
               vCopyCallData(prCallData);
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
               bProcessEvent(FC_PHONE_SM_EVENT_CALLSTATUS_UPDATE);
            }
         }
         break ;
         case FC_PHONE_SMDIAL_STATE_CALL_ROUTED :
         {
            ETG_TRACE_USR3((" vNewCallStatus :IN FC_PHONE_SMDIAL_STATE_CALL_ROUTED STATUS"));
            //When call disconnected by the connected usr
            if( PHONE_CALLSTATE_IDLE == prCallData->rCallStatus.u8CallState)
            {
#ifdef PHONE_WAITINGMODE
            fc_phone_tclWaitingMode* poWaitingMode = fc_phone_tclWaitingMode::poGetInstance();
            tenFC_Phone_WaitingModeState enWaitingModeState = poWaitingMode->enGetWaitingModeState();

            //Both calls/single call came to an end during waiting mode
            if ((FC_PHONE_WAITINGMODE_IDLE != enWaitingModeState) && (0 == prCallData->rCallStatus.u8CallTotal))
            {
               poWaitingMode->bProcessEvent(FC_PHONE_WAITING_MODE_EVENT_END_OF_ACTIVE_CALLS);
            }
#endif

            ETG_TRACE_USR4((" vNewCallStatus :PHONE_CALLSTATE_IDLE == prCallData->rCallStatus.u8CallState "));
            //update the state
            //                         m_u16State = FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIO_RELEASE_AND_INIT_IDLE ;
            //release ringtone/Alert audio channel, if in use
            vCancelSMReleaseChannel();
         }

          // sm state changes to routed on channel successfully aquired so timer should be started when callstatus received as ACTIVE.

               else if (   ( (FC_PHONE_CALLINSTANCE_CALLSTATUS_DIALING == m_poCallInstance->m_u16CallStatusNotice)
                  ||(FC_PHONE_CALLINSTANCE_CALLSTATUS_RINGTONE == m_poCallInstance->m_u16CallStatusNotice)
                  ||(FC_PHONE_CALLINSTANCE_CALLSTATUS_BUSY == m_poCallInstance->m_u16CallStatusNotice))
                  &&( PHONE_CALLSTATE_ACTIVE ==  prCallData->rCallStatus.u8CallState)
                  )
                  // if( PHONE_CALLSTATE_ACTIVE == prCallData->rCallStatus.u8CallState)
               {
                  ETG_TRACE_USR4((" CALL ACCEPTTED : updating call instance to ACTIVE "));
                  //Already phone audio channel aquired.
                  //start timer and update the state to routing
                  m_poCallInstance->m_u16CallStatusNotice = FC_PHONE_CALLINSTANCE_CALLSTATUS_ACTIVE;
                  m_u16State = FC_PHONE_SMDIAL_STATE_CALL_ROUTED;
                  ETG_TRACE_USR2(("State Change:FC_PHONE_SMDIAL_STATE_CALL_ROUTED "));
                  m_bTimerRunning = TRUE;
                  ETG_TRACE_USR3((" TimerRunning = TRUE"));
                  m_poCallInstance->m_u16TimerId = FC_PHONE_CALLINSTANCE_TIMER_ID;
                  m_poTimer->s32Start(m_poCallInstance->m_u16TimerId,FC_PHONE_ONE_SECOND,vCallInstanceTimerCallBack);
                  m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
                  vCopyCallData(prCallData);
                  break;

               }
               else if ( (FC_PHONE_CALLINSTANCE_CALLSTATUS_IDLE == m_poCallInstance->m_u16CallStatusNotice)
                  && ( ( PHONE_CALLSTATE_ACTIVE ==  prCallData->rCallStatus.u8CallState )
                  || ( PHONE_CALLSTATE_HELD ==  prCallData->rCallStatus.u8CallState ) ) )
               {
                  ETG_TRACE_USR4(("Call status becomes active without dialing/alerting"));
                  m_poCallInstance->m_u16CallStatusNotice = FC_PHONE_CALLINSTANCE_CALLSTATUS_ACTIVE;
                  m_u16State = FC_PHONE_SMDIAL_STATE_CALL_ROUTED;
                  ETG_TRACE_USR2(("State Change:FC_PHONE_SMDIAL_STATE_CALL_ROUTED "));
                  m_bTimerRunning = TRUE;
                  ETG_TRACE_USR3((" TimerRunning = TRUE"));
                  m_poCallInstance->m_u16TimerId = FC_PHONE_CALLINSTANCE_TIMER_ID;
                  m_poTimer->s32Start(m_poCallInstance->m_u16TimerId,FC_PHONE_ONE_SECOND,vCallInstanceTimerCallBack);
                  m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
                  vCopyCallData(prCallData);
               }
               else
               {
                  ETG_TRACE_USR4(("UPDATING CALL STATUS TO Client "));
                  vCopyCallData(prCallData);
                  m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
            }
         }
         break;
		 //SUZUKI-18670
       /*  case FC_PHONE_SMDIAL_STATE_WAIT_FOR_DISCONNECT_FROM_BT:
            {
               ETG_TRACE_USR4(("FC_PHONE_SMDIAL_STATE_WAIT_FOR_DISCONNECT_FROM_BT "));
               if( PHONE_CALLSTATE_IDLE == prCallData->rCallStatus.u8CallState)
               {
                  // Idle callstatus received after posting terminate so post cancel outgoingmethod result 
                  ETG_TRACE_USR4(("IDLE callstatus received after posting terminate "));
                  m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_CANCELOUTGOINGCALL,\
                     m_poCallInstance);
                  vCancelSMReleaseChannel();
               }
            }
            break ;    */

         default:
         {

            ETG_TRACE_USR4((" IN DEFAULT :m_u16State : %d m_poCallInstance->m_u16CallStatusNotice : %d prCallData->rCallStatus.u8CallState %d ",m_u16State,m_poCallInstance->m_u16CallStatusNotice,prCallData->rCallStatus.u8CallState));

            /* Send Call status notification and act on Call Status accordingly */

            if (PHONE_CALLSTATE_IDLE == prCallData->rCallStatus.u8CallState)
            {

               //m_u16State = FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIO_RELEASE_AND_INIT_IDLE ;
               if((m_u16State == FC_PHONE_SMDIAL_STATE_WAIT_FOR_CANCELOUTGOINGCALL_AND_AUDIO))
               {
                  m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
                  m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_CANCELOUTGOINGCALL,m_poCallInstance);

               }
               else if(m_u16State == FC_PHONE_SMDIAL_STATE_WAIT_FOR_DISCONNECT_FROM_BT) 

               {
                  if(m_bTerminateCallPosted ==  TRUE)
                  {
                     ETG_TRACE_USR4(("FC_PHONE_SMDIAL_STATE_WAIT_FOR_DISCONNECT_FROM_BT|FC_PHONE_SMDIAL_STATE_WAIT_FOR_CANCELOUTGOINGCALL_AND_AUDIO"));
                     //post cancel outgoing call MR
                     m_bTerminateCallPosted = FALSE;
                     m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
                     m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_CANCELOUTGOINGCALL,m_poCallInstance);
                  }
               }

               //release ringtone/Alert audio channel ,if in use
               if( FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_poCallInstance->m_u8AudioChannel)
               {
                  ETG_TRACE_USR3((" RELEASING Audio channel.. "));
                  m_poAudioManager->s32ReleaseRequest( m_poCallInstance->m_u16Id ,m_poCallInstance->m_u8AudioChannel,vAudioCallBackDial);
               }
               //Update the audio channel status
               m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED ;
               m_poCallInstance->m_bUsingVehicleAudio = FALSE;
               ETG_TRACE_USR3(("  UsingVehicleAudio = FALSE "));
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);

               //to stop timer if active
               vStopTimer();

               vStopTerminateRetryTimer(); //Start terminate retry timer if running.
               m_u8RetryCount = 0;
               vCancel();
               m_poCallInstance->vInit();
               //send status to client : now status is IDLE
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
               m_poSMManager->vSMFinished(m_poCallInstance->m_u16Id);
            }

            //update state while Dialling
            else if (   (FC_PHONE_CALLINSTANCE_CALLSTATUS_IDLE == m_poCallInstance->m_u16CallStatusNotice)
                  &&( PHONE_CALLSTATE_DIALING ==  prCallData->rCallStatus.u8CallState)
            )
            {
               ETG_TRACE_USR4((" Call status - Idle to Dialling"));

               //CT GMMY15-1343 FIX
               //Phone number will be extracted; from Call status notice received for status change from IDLE to DIALLING.
               //Specific to Speed dial since Phone number will not be available from HMI as part of Speed dial request.
               vCopyCallData(prCallData);
               /* Send Call Status Notice status */
               m_poCallInstance->m_u16CallStatusNotice = FC_PHONE_CALLINSTANCE_CALLSTATUS_DIALING;
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);

               if((prCallData->rCallStatus.u8CallTotal == 1) && (m_bTerminateCallRequest == TRUE))
               {
                  ETG_TRACE_USR4(("Terminate Call is requested by User "));
                  bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
               }
               else if((prCallData->rCallStatus.u8CallTotal == 2) && (m_bTerminateCallRequest == TRUE))
               {
                  ETG_TRACE_USR4(("Terminate Call is requested by User "));
                  bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
               }
               /* Send Call Status Notice status */
               m_poCallInstance->m_u16CallStatusNotice = FC_PHONE_CALLINSTANCE_CALLSTATUS_DIALING;
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
            }

            //update state while ringing/Alerting
            else if (   (FC_PHONE_CALLINSTANCE_CALLSTATUS_DIALING == m_poCallInstance->m_u16CallStatusNotice)
                  &&( PHONE_CALLSTATE_ALERTING ==  prCallData->rCallStatus.u8CallState)
            )
               //if( PHONE_CALLSTATE_ALERTING == prCallData->rCallStatus.u8CallState)
            {
               ETG_TRACE_USR4((" UPDATING CALL Instances for ringing/Alerting "));
               if((prCallData->rCallStatus.u8CallTotal == 1) && (m_bTerminateCallRequest == TRUE))
               {
                  ETG_TRACE_USR4(("Terminate Call is requested by User "));
                  bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
               }
               else if((prCallData->rCallStatus.u8CallTotal == 2) && (m_bTerminateCallRequest == TRUE))
               {
                  ETG_TRACE_USR4(("Terminate Call is requested by User "));
                  bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
               }

               /* Send Call Status Notice status */
               m_poCallInstance->m_u16CallStatusNotice = FC_PHONE_CALLINSTANCE_CALLSTATUS_DIALING;
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);


            }

            //when call accepted
            else if (   ( (FC_PHONE_CALLINSTANCE_CALLSTATUS_DIALING == m_poCallInstance->m_u16CallStatusNotice)
                  ||(FC_PHONE_CALLINSTANCE_CALLSTATUS_RINGTONE == m_poCallInstance->m_u16CallStatusNotice)
                  ||(FC_PHONE_CALLINSTANCE_CALLSTATUS_BUSY == m_poCallInstance->m_u16CallStatusNotice))
                  &&( PHONE_CALLSTATE_ACTIVE ==  prCallData->rCallStatus.u8CallState)
            )
               // if( PHONE_CALLSTATE_ACTIVE == prCallData->rCallStatus.u8CallState)
            {
               if((m_u16State == FC_PHONE_SMDIAL_STATE_WAIT_FOR_DISCONNECT_FROM_BT) 
                  ||(m_u16State == FC_PHONE_SMDIAL_STATE_WAIT_FOR_CANCELOUTGOINGCALL_AND_AUDIO))
               {
                  ETG_TRACE_USR4(("FC_PHONE_SMDIAL_STATE_WAIT_FOR_DISCONNECT_FROM_BT|FC_PHONE_SMDIAL_STATE_WAIT_FOR_CANCELOUTGOINGCALL_AND_AUDIO"));
                  //post cancel outgoing call MR
                  m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
                  m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_CANCELOUTGOINGCALL,m_poCallInstance);
                   m_bTerminateCallPosted = FALSE;
               }


               ETG_TRACE_USR4((" CALL ACCEPTTED : updating call instance to ACTIVE "));
               //Already phone audio channel aquired.
               //start timer and update the state to routing
               m_poCallInstance->m_u16CallStatusNotice = FC_PHONE_CALLINSTANCE_CALLSTATUS_ACTIVE;
               m_u16State = FC_PHONE_SMDIAL_STATE_CALL_ROUTED;
               ETG_TRACE_USR2(("State Change:FC_PHONE_SMDIAL_STATE_CALL_ROUTED "));
               m_bTimerRunning = TRUE;
               ETG_TRACE_USR3((" TimerRunning = TRUE"));
               m_poCallInstance->m_u16TimerId = FC_PHONE_CALLINSTANCE_TIMER_ID;
               m_poTimer->s32Start(m_poCallInstance->m_u16TimerId,FC_PHONE_ONE_SECOND,vCallInstanceTimerCallBack);
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
               vCopyCallData(prCallData);
               break;

            }
            // Call status becomes active without dialling/alerting.
            else if ( (FC_PHONE_CALLINSTANCE_CALLSTATUS_IDLE == m_poCallInstance->m_u16CallStatusNotice)
                  && ( ( PHONE_CALLSTATE_ACTIVE ==  prCallData->rCallStatus.u8CallState )
                        || ( PHONE_CALLSTATE_HELD ==  prCallData->rCallStatus.u8CallState ) ) )
            {
               ETG_TRACE_USR4(("Call status becomes active without dialing/alerting"));
               m_poCallInstance->m_u16CallStatusNotice = FC_PHONE_CALLINSTANCE_CALLSTATUS_ACTIVE;
               m_u16State = FC_PHONE_SMDIAL_STATE_CALL_ROUTED;
               ETG_TRACE_USR2(("State Change:FC_PHONE_SMDIAL_STATE_CALL_ROUTED "));
               m_bTimerRunning = TRUE;
               ETG_TRACE_USR3((" TimerRunning = TRUE"));
               m_poCallInstance->m_u16TimerId = FC_PHONE_CALLINSTANCE_TIMER_ID;
               m_poTimer->s32Start(m_poCallInstance->m_u16TimerId,FC_PHONE_ONE_SECOND,vCallInstanceTimerCallBack);
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
               vCopyCallData(prCallData);
            }
            //When call Not accepted (rejected or ignored)
            else if (   ((FC_PHONE_CALLINSTANCE_CALLSTATUS_BUSY == m_poCallInstance->m_u16CallStatusNotice)
                  ||(FC_PHONE_CALLINSTANCE_CALLSTATUS_RINGTONE == m_poCallInstance->m_u16CallStatusNotice))
                  &&( PHONE_CALLSTATE_IDLE ==  prCallData->rCallStatus.u8CallState)
            )
               //if( PHONE_CALLSTATE_IDLE == prCallData->rCallStatus.u8CallState)
            {
               ETG_TRACE_USR4((" CALL NOT ACCEPTTED (Rejected/Ignored) : updating call instance to IDLE  "));
               //m_u16State = FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIO_RELEASE_AND_INIT_IDLE ;
               //release ringtone/Alert audio channel ,if in use
               if( FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_poCallInstance->m_u8AudioChannel)
               {
                  ETG_TRACE_USR3((" RELEASING Audio channel.. "));
                  m_poAudioManager->s32ReleaseRequest( m_poCallInstance->m_u16Id,m_poCallInstance->m_u8AudioChannel,vAudioCallBackDial);
               }
               //Update the audio channel status
               m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED ;
               m_poCallInstance->m_bUsingVehicleAudio = FALSE;
               ETG_TRACE_USR3(("  UsingVehicleAudio = FALSE "));
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);

               //to stop timer if active
               vStopTimer();

               vStopTerminateRetryTimer(); //Start terminate retry timer if running.
               m_u8RetryCount = 0;

               vCancel();
               m_poCallInstance->vInit();
               //send status to client : now status is IDLE
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
               m_poSMManager->vSMFinished(m_poCallInstance->m_u16Id);
            }
            else
            {
               ETG_TRACE_USR4(("UPDATING CALL STATUS TO Cleint"));
               if((prCallData->rCallStatus.u8CallTotal == 1) && (m_bTerminateCallRequest == TRUE))
               {
                  ETG_TRACE_USR4(("Terminate Call is requested by User "));
                  bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
               }
               else if((prCallData->rCallStatus.u8CallTotal == 2) && (m_bTerminateCallRequest == TRUE))
               {
                  ETG_TRACE_USR4(("Terminate Call is requested by User "));
                  bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
               }
               vCopyCallData(prCallData);
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
            }
         }
         break;
      }
   }
   else
   {
      ETG_TRACE_ERR(("calldata || Call Instance  is NULL"));
   }

}


/*******************************************************************************
 *
 * FUNCTION: vHandleEventInHoldCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMDial::vHandleEventInHoldCall(tU16 u16EventId)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMDial::vHandleEventInHoldCall %d",u16EventId));

   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_DBUS_HOLDCALL_ACK_OK:
      {

         ETG_TRACE_USR3(("  EVENT ::FC_PHONE_SM_EVENT_DBUS_HOLDCALL_ACK_OK "));
         //update the status to hold
         if(m_poCallInstance)
         {
            m_u16State = FC_PHONE_SMDIAL_STATE_CALL_ROUTED;
            ETG_TRACE_USR2(("State Change:FC_PHONE_SMDIAL_STATE_CALL_ROUTED "));
            m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
            m_poCallInstance->m_u16CallStatusNotice = FC_PHONE_CALLINSTANCE_CALLSTATUS_ONHOLD;
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_HOLDCALL,m_poCallInstance);
            //m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
            //m_pDbusIf->bGetCallStaus(m_poCallInstance->m_achBD_Address);
         }
         else
         {
            ETG_TRACE_ERR(("Call Instance  is NULL"));
         }
      }
      break;
      case FC_PHONE_SM_EVENT_CANCELOUTGOINGCALL_OK :
      {
         ETG_TRACE_USR3((" EVENT :: FC_PHONE_SM_EVENT_CANCELOUTGOINGCALL_OK "));
         vCancelOutgoingCall();
         m_bEventConsumed = TRUE;
      }
      break;
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
      {
         ETG_TRACE_USR3((" EVENT ::FC_PHONE_SM_EVENT_PHONE_REQUEST_OK "));
         if(m_u16State_while_TransferAudio == FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIO_RELEASE_ON_TRANSFERCALLREQ_FROM_PHONE)
         {
            vHandleEventInAudioReleaseOnTransferAudioRequest(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
         }
         else if(m_u16State_while_TransferAudio == FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIO_ACQUISITION_ON_TRANSFERCALLREQ_FROM_PHONE)
         {
            vHandleEventInAudioAcquisitionOnTransferAudioRequest(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
         }
      }
      break;
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK:
      {
         ETG_TRACE_USR3((" EVENT ::FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK "));
         if(m_u16State_while_TransferAudio == FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIO_RELEASE_ON_TRANSFERCALLREQ_FROM_PHONE)
         {
            vHandleEventInAudioReleaseOnTransferAudioRequest(FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK);
         }
         else if(m_u16State_while_TransferAudio == FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIO_ACQUISITION_ON_TRANSFERCALLREQ_FROM_PHONE)
         {
            vHandleEventInAudioAcquisitionOnTransferAudioRequest(FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK);
         }
      }
      break;
      case FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK:
      {
         ETG_TRACE_USR3((" EVENT ::FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK "));
         if(m_u16State_while_TransferAudio == FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIO_RELEASE_ON_TRANSFERCALLREQ_FROM_PHONE)
         {
            vHandleEventInAudioReleaseOnTransferAudioRequest(FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK);
         }
         else if(m_u16State_while_TransferAudio == FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIO_ACQUISITION_ON_TRANSFERCALLREQ_FROM_PHONE)
         {
            vHandleEventInAudioAcquisitionOnTransferAudioRequest(FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK);
         }
      }
      break;
      default:
      {
         ETG_TRACE_USR4(("  fc_phone_tclSMDial::vHandleEventInHoldCall :: In Default "));
      }
      break;
   }

}


/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMDial::vHandleEventInResumeCall
 *
 * DESCRIPTION: Resume Hold call
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMDial::vHandleEventInResumeCall(tU16 u16EventId)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMDial::vHandleEventInResumeCall u16EventId %d",u16EventId));

   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_DBUS_RESUMECALL_ACK_OK:
      {
         ETG_TRACE_USR3(("  EVENT ::FC_PHONE_SM_EVENT_DBUS_RESUMECALL_ACK_OK "));
         if(m_poCallInstance)
         {
            m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
            //update the status to ACTIVE
            m_u16State  = FC_PHONE_SMDIAL_STATE_CALL_ROUTED;
            ETG_TRACE_USR2(("State Change:FC_PHONE_SMDIAL_STATE_CALL_ROUTED"));
            m_poCallInstance->m_u16CallStatusNotice = FC_PHONE_CALLINSTANCE_CALLSTATUS_ACTIVE;
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_RESUMECALL,m_poCallInstance);
         }
         else
         {
            ETG_TRACE_ERR(("Call Instance  is NULL"));
         }
      }
      break;
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
      {
         ETG_TRACE_USR3(("  EVENT ::FC_PHONE_SM_EVENT_PHONE_REQUEST_OK "));
         if(m_u16State_while_TransferAudio == FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIO_RELEASE_ON_TRANSFERCALLREQ_FROM_PHONE)
         {
            vHandleEventInAudioReleaseOnTransferAudioRequest(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
         }
         else if(m_u16State_while_TransferAudio == FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIO_ACQUISITION_ON_TRANSFERCALLREQ_FROM_PHONE)
         {
            vHandleEventInAudioAcquisitionOnTransferAudioRequest(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
         }
      }
      break;
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK:
      {
         ETG_TRACE_USR3(("  EVENT ::FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK "));
         if(m_u16State_while_TransferAudio == FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIO_RELEASE_ON_TRANSFERCALLREQ_FROM_PHONE)
         {
            vHandleEventInAudioReleaseOnTransferAudioRequest(FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK);
         }
         else if(m_u16State_while_TransferAudio == FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIO_ACQUISITION_ON_TRANSFERCALLREQ_FROM_PHONE)
         {
            vHandleEventInAudioAcquisitionOnTransferAudioRequest(FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK);
         }
      }
      break;
      case FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK:
      {
         ETG_TRACE_USR3(("  EVENT :: FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK "));
         if(m_u16State_while_TransferAudio == FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIO_RELEASE_ON_TRANSFERCALLREQ_FROM_PHONE)
         {
            vHandleEventInAudioReleaseOnTransferAudioRequest(FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK);
         }
         else if(m_u16State_while_TransferAudio == FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIO_ACQUISITION_ON_TRANSFERCALLREQ_FROM_PHONE)
         {
            vHandleEventInAudioAcquisitionOnTransferAudioRequest(FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK);
         }
      }
      break;
      default:
      {
         ETG_TRACE_USR4(("  fc_phone_tclSMDial::vHandleEventInResumeCall::IN DEFAULT  u16EventId %d",u16EventId));
      }
      break;
   }

}
/*******************************************************************************
 *
 * FUNCTION: vHandleEventInRoutingHandsetCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMDial::vHandleEventInRoutingHandsetCall(tU16 u16EventId)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMDial::vHandleEventInRoutingHandsetCall u16EventId %d",u16EventId));

   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK:
      {
         if(m_poCallInstance)
         {
            ETG_TRACE_USR4(("  EVENT : FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK"));
            m_poSMManager->vRestoreToActiveCallInHandset(m_poCallInstance->m_u16Id);
         }
         else
         {
            ETG_TRACE_ERR(("Call Instance  is NULL"));
         }
      }
      break;


      default:
      {
         ETG_TRACE_USR4((" fc_phone_tclSMDial::vHandleEventInRoutingHandsetCall ::IN DEFAULT u16EventId %d",u16EventId));
      }
      break;
   }




}
/*******************************************************************************
 *
 * FUNCTION: vAudioCallBack
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMDial::vAudioCallBack(tU16 u16AudioChannelId, tU16 u16RequestState)
{

   ETG_TRACE_USR4((" Entering fc_phone_tclSMDial::vAudioCallBack "));
   ETG_TRACE_USR4((" u16AudioChannelId  ::  %d",u16AudioChannelId) );
   switch (u16AudioChannelId)
   {

      case FC_PHONE_AUDIOCHANNEL_PHONE :
      {

         ETG_TRACE_USR3(("  u16AudioChannelId::FC_PHONE_AUDIOCHANNEL_PHONE "));

         if (FC_PHONE_AUDIOCHANNEL_GRANTED == u16RequestState)
         {

            ETG_TRACE_USR3(("  u16RequestState::FC_PHONE_AUDIOCHANNEL_GRANTED "));
            bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);

         }
         else
         {
            if(m_poCallInstance)
            {
               ETG_TRACE_USR3(("  u16RequestState::FC_PHONE_AUDIOCHANNEL_DENIED_SUSPENDED "));
               m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
               bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK);
            }
            else
            {
               ETG_TRACE_ERR(("Call Instance  is NULL"));
            }
         }

      }
      break;
      default:
      {
         ETG_TRACE_USR4((" fc_phone_tclSMDial::vAudioCallBack: IN DEFAULT  "));
      }
      break;
   }
}
/*******************************************************************************
 *
 * FUNCTION: vProcessAudioSignal
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMDial::vProcessAudioSignal()
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMDial::vProcessAudioSignal "));
   ETG_TRACE_USR4(("  EVENT ::FC_PHONE_CB_FID_SCOCONNECTIONSTATUS "));
   if(m_poCallInstance)
   {
      tU8 u8SCOConnectionStatus = FC_PHONE_DBUS_SCO_CONN_FAILED;
      fc_phone_tclClientHandler_BTSettings *p_clientHndler_bluetooth = (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerBTSettings;
      u8SCOConnectionStatus = p_clientHndler_bluetooth->vGetSCOConnectionStatus(const_cast<tChar *> (fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId))); //CMG3G-4847 - To solve Lint
      ETG_TRACE_USR4(("  fc_phone_tclSMDial::u8SCOConnectionStatus = %d ",u8SCOConnectionStatus));
      if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_DISCONNECTED)
      {
         ETG_TRACE_USR3(("  fc_phone_tclSMDial Receives HfReleaseAudio Signal ::FC_PHONE_CB_FID_SCOCONNECTIONSTATUS "));
         m_u16State_while_TransferAudio = FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIO_RELEASE_ON_TRANSFERCALLREQ_FROM_PHONE;
         if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_poCallInstance->m_u8AudioChannel)
         {
#ifdef PHONE_WAITINGMODE
            fc_phone_tclWaitingMode* poWaitingMode = fc_phone_tclWaitingMode::poGetInstance();
            tenFC_Phone_WaitingModeState enWaitingModeState = poWaitingMode->enGetWaitingModeState();

            //During waiting mode, phone audio source will not be in use (audio channel attributes has to be updated)
            if ((FC_PHONE_WAITINGMODE_ACTIVE == enWaitingModeState) && (FC_PHONE_AUDIOCHANNEL_PHONE == m_poCallInstance->m_u8AudioChannel))
            {
               m_poAudioManager->vUpdateChannelAttributes(m_poCallInstance->m_u8AudioChannel, FC_PHONE_REQUESTTYPE_RELEASE);
               m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
               bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
            }
            else
            {
#endif
            ETG_TRACE_USR3((" RELEASING Audio channel.. "));
            m_poAudioManager->s32ReleaseRequest( m_poCallInstance->m_u16Id,m_poCallInstance->m_u8AudioChannel,vAudioCallBackDial);
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
#ifdef PHONE_WAITINGMODE
            }
#endif
         }
         else
         {
            bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
         }
      }
      else if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_ESTABLISHED)
      {
         if((m_u16State != FC_PHONE_SMDIAL_STATE_WAIT_FOR_CANCELOUTGOINGCALL_AND_AUDIO) &&
               (m_u16State != FC_PHONE_SMDIAL_STATE_WAIT_FOR_DISCONNECT_FROM_BT))
         {
            //Fix for GMMY17-10316
            m_u16State_while_TransferAudio = FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIO_ACQUISITION_ON_TRANSFERCALLREQ_FROM_PHONE ;

            if((FC_PHONE_SMDIAL_STATE_CONNECTED_FROM_BT == m_u16State) || (FC_PHONE_SMDIAL_STATE_CALL_ROUTED == m_u16State) )
            {
               m_u16State = FC_PHONE_SMDIAL_STATE_WAIT_FOR_AM_RESPONSE_ACTIVATE_VOICE;
               ETG_TRACE_USR4((" STATE Change FC_PHONE_SMDIAL_STATE_WAIT_FOR_AM_RESPONSE_ACTIVATE_VOICE "));
               ETG_TRACE_USR4(("  fc_phone_tclSMDial Receives HfSetUpAudio Signal ::FC_PHONE_CB_FID_SCOCONNECTIONSTATUS "));
               if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED == m_poCallInstance->m_u8AudioChannel)
               {
                  m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
                  ETG_TRACE_USR3((" Requesting Audio m_poCallInstance::  AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE"));
                  m_poAudioManager->s32GetRequest(m_poCallInstance->m_u16Id,m_poCallInstance->m_u8AudioChannel,vAudioCallBackDial);
               }
               else
               {
                  bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
               }

               return;
            }

            ETG_TRACE_USR4(("  fc_phone_tclSMDial Receives HfSetUpAudio Signal ::FC_PHONE_CB_FID_SCOCONNECTIONSTATUS "));
            if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED == m_poCallInstance->m_u8AudioChannel)
            {
               m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
               ETG_TRACE_USR3((" Requesting Audio m_poCallInstance::  AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE"));
               m_poAudioManager->s32GetRequest(m_poCallInstance->m_u16Id,m_poCallInstance->m_u8AudioChannel,vAudioCallBackDial);
            }
            else
            {
               bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
            }
         }
      }
   }
   else
   {
      ETG_TRACE_ERR(("Call Instance  is NULL"));
   }
}
/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMDial::vTimerCallBack
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMDial::vTimerCallBack(tU16 u16TimerId)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMDial::vTimerCallBack "));

   if (m_poCallInstance)
   {
      if( u16TimerId == FC_PHONE_CALLINSTANCE_TIMER_ID)
      {
         vIncrementTimer(m_poCallInstance);
         ETG_TRACE_USR4(("fc_phone_tclSMDial: calling vSendStatus"));
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, m_poCallInstance);
      }
      else if((FC_PHONE_TERMINATECALLRETRY_TIMER_ID +(m_poCallInstance->m_u16Id)) == u16TimerId)
      {
         // Retry terminate call.
         vStopTerminateRetryTimer();
         vTerminateOutgoingCall();
      }
      else if( (FC_PHONE_DIAL_CALLSTATUS_FAILURE_TIMER_ID +(m_poCallInstance->m_u16Id)) == u16TimerId )
      {
         /*  No DIALING call status received for 15 Seconds Due to that
          * state machine should be deleted and release audio channel.*/
         vHandleCallstatusFailure();
      }
      else
      {
         ETG_TRACE_USR4(("Invalid timerID(Not CallInstance)"));
      }
   }
   else
   {
      ETG_TRACE_USR4(("callinstance is NULL"));
   }
}





/*******************************************************************************
 *
 * FUNCTION: vProcessOnDynamicDisconnect
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMDial::vProcessOnDynamicDisconnect(tU16 u16EventId)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMDial::vProcessOnDynamicDisconnect u16EventId %d ",u16EventId));
   //release Audio channels
   if(m_poCallInstance)
   {
      switch(u16EventId)
      {

         case FC_PHONE_SM_EVENT_SLC_OFF:
      {
           if( FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_poCallInstance->m_u8AudioChannel )
            {
               ETG_TRACE_USR3((" EVENT :: RELEASING Audio Channel "));
               //if any audio channel aquired, release it
               //m_u16State = FC_PHONE_SMDIAL_STATE_WAIT_FOR_SLC_OFF_RESPONSE;
               ETG_TRACE_USR3((" RELEASING Audio channel.. "));
               m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id,m_poCallInstance->m_u8AudioChannel,vAudioCallBackDial);
         }
         //to stop timer if active
         vStopTimer();

         vCancel();

               ETG_TRACE_USR3((" No audio channel is aquired, releasing instance "));
               //if any audio channel is not aquired , got to idle state and send the status to client

               //m_bUsingVehicleAudio false , and stop timer if running
               m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
               m_poCallInstance->m_bUsingVehicleAudio = FALSE;
               ETG_TRACE_USR3(("  UsingVehicleAudio = FALSE "));
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,\
                     m_poCallInstance);

               if(TRUE == m_bTimerRunning)
               {
                  m_poTimer->s32Stop(m_poCallInstance->m_u16TimerId); // Bugfix for GMMY16-17241
                  m_bTimerRunning = FALSE;
                  ETG_TRACE_USR3((" TimerRunning = FALSE "));
               }

               m_poCallInstance->vInit();
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,\
                     m_poCallInstance);
               //send SLC status to client
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_SLC,m_poCallInstance);
               m_poSMManager->vSMFinished(m_poCallInstance->m_u16Id);

      }
         break;
         default:
         {
            ETG_TRACE_USR4((" IN DEFAULT : vProcessOnDynamicDisconnect: wrong u16EventId= %d ",u16EventId));
         }
         break;
      }
   }
   else
   {
      ETG_TRACE_ERR(("Call Instance  is NULL"));
   }
}


/*******************************************************************************
 *
 * FUNCTION: vHandleDbusError
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMDial::vHandleDbusError(tU16 u16DbusAckType,tChar Code)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMDial::vHandleDbusError "));
   if(m_poCallInstance)
   {
      switch(u16DbusAckType)
      {
         case FC_PHONE_CB_FID_HOLDCALL:
         case FC_PHONE_CB_FID_HOLDINCOMINGCALL:
         {
            ETG_TRACE_USR2((" FC_PHONE_CB_FID_HOLDCALL:: FC_PHONE_CB_FID_HOLDINCOMINGCALL "));
            if(m_u16State == FC_PHONE_SMDIAL_STATE_WAIT_FOR_HOLDCALL)
            {
               ETG_TRACE_USR2((" FC_PHONE_CB_FID_HOLDCALL "));
               vAssignErrorCode(Code);
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_HOLDCALL,m_poCallInstance);
               m_u16State = FC_PHONE_SMDIAL_STATE_CALL_ROUTED;
               ETG_TRACE_USR2(("State Change:FC_PHONE_SMDIAL_STATE_CALL_ROUTED"));
            }
            else
            {
               ETG_TRACE_USR2((" Hold Call is not serviced in Other States"));
            }
         }
         break;
         case FC_PHONE_CB_FID_RESUMECALL:
         {
            if(m_u16State == FC_PHONE_SMDIAL_STATE_WAIT_FOR_RESUMECALL)
            {
               ETG_TRACE_USR2((" FC_PHONE_CB_FID_RESUMECALL "));
               vAssignErrorCode(Code);
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_RESUMECALL,m_poCallInstance);
               m_u16State = FC_PHONE_SMDIAL_STATE_CALL_ROUTED;
               ETG_TRACE_USR2(("State Change:FC_PHONE_SMDIAL_STATE_CALL_ROUTED"));
            }
            else
            {
               ETG_TRACE_USR2((" Resume Call is not serviced in Other States"));
            }

         }
         break;
         case FC_PHONE_CB_FID_SWAPCALL:
         {
            if((m_u16State == FC_PHONE_SMDIAL_STATE_WAIT_FOR_SWAPDBUSACK) ||
                  (m_u16State == FC_PHONE_SMDIAL_STATE_WAIT_FOR_SWAPDBUSACK_AND_CALLSTATUS))
            {
               ETG_TRACE_USR2((" FC_PHONE_CB_FID_SWAPCALL "));
               vAssignErrorCode(Code);
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_SWAPCALL,m_poCallInstance);
               m_u16State = FC_PHONE_SMDIAL_STATE_CALL_ROUTED;
               ETG_TRACE_USR2(("State Change:FC_PHONE_SMDIAL_STATE_CALL_ROUTED"));
            }
            else
            {
               ETG_TRACE_USR2((" Swap Call is not serviced in Other States"));
            }
         }
         break;
         case FC_PHONE_CB_FID_DIAL:
         {
            if(m_u16State == FC_PHONE_SMDIAL_STATE_WAIT_FOR_CONNECT_FROM_BT)
            {
               ETG_TRACE_USR2((" FC_PHONE_CB_FID_DIAL "));
               switch(Code)
               {
                  case FC_PHONE_DBUS_ERRORCODE_AG_FAILURE:
                  {
                     ETG_TRACE_USR2(("FC_PHONE_DBUS_ERRORCODE_AG_FAILURE"));
                     vSendOutGoingFailedStatus("AG failure",FC_PHONE_CALLINSTANCE_ACKERROR_NOK);
                  }
                  break;
                  case FC_PHONE_DBUS_ERRORCODE_NO_CONNECTION_TO_PHONE:
                  {
                     ETG_TRACE_USR2(("FC_PHONE_DBUS_ERRORCODE_NO_CONNECTION_TO_PHONE"));
                     vSendOutGoingFailedStatus("No connection to phone",FC_PHONE_CALLINSTANCE_ACKERROR_NOK);
                  }
                  break;
                  case FC_PHONE_DBUS_ERRORCODE_OPERATION_NOT_ALLOWED:
                  {
                     ETG_TRACE_USR2(("FC_PHONE_DBUS_ERRORCODE_OPERATION_NOT_ALLOWED"));
                     vSendOutGoingFailedStatus("Operation not allowed",FC_PHONE_CALLINSTANCE_ACKERROR_NOK);
                  }
                  break;
                  case FC_PHONE_DBUS_ERRORCODE_OPERATION_NOT_SUPPORTED:
                  {
                     ETG_TRACE_USR2(("FC_PHONE_DBUS_ERRORCODE_OPERATION_NOT_SUPPORTED"));
                     vSendOutGoingFailedStatus("Operation not supported",FC_PHONE_CALLINSTANCE_ACKERROR_NOK);
                  }
                  break;
                  case FC_PHONE_DBUS_ERRORCODE_PH_SIM_PIN_REQUIRED:
                  {
                     ETG_TRACE_USR2(("FC_PHONE_DBUS_ERRORCODE_PH_SIM_PIN_REQUIRED"));
                     vSendOutGoingFailedStatus("PH-SIM PIN required",FC_PHONE_CALLINSTANCE_ACKERROR_NOK);
                  }
                  break;
                  case FC_PHONE_DBUS_ERRORCODE_SIM_NOT_INSERTED:
                  {
                     ETG_TRACE_USR2(("FC_PHONE_DBUS_ERRORCODE_SIM_NOT_INSERTED"));
                     vSendOutGoingFailedStatus("SIM not inserted",FC_PHONE_CALLINSTANCE_ACKERROR_NOK);
                  }
                  break;
                  case FC_PHONE_DBUS_ERRORCODE_SIM_PIN_REQUIRED:
                  {
                     ETG_TRACE_USR2(("FC_PHONE_DBUS_ERRORCODE_SIM_PIN_REQUIRED"));
                     vSendOutGoingFailedStatus("SIM PIN required",FC_PHONE_CALLINSTANCE_ACKERROR_NOK);
                  }
                  break;
                  case FC_PHONE_DBUS_ERRORCODE_SIM_PUK_REQUIRED:
                  {
                     ETG_TRACE_USR2(("FC_PHONE_DBUS_ERRORCODE_SIM_PUK_REQUIRED"));
                     vSendOutGoingFailedStatus("SIM PUK required",FC_PHONE_CALLINSTANCE_ACKERROR_NOK);
                  }
                  break;
                  case FC_PHONE_DBUS_ERRORCODE_SIM_FAILURE:
                  {
                     ETG_TRACE_USR2(("FC_PHONE_DBUS_ERRORCODE_SIM_FAILURE"));
                     vSendOutGoingFailedStatus("SIM failure",FC_PHONE_CALLINSTANCE_ACKERROR_NOK);
                  }
                  break;
                  case FC_PHONE_DBUS_ERRORCODE_SIM_BUSY:
                  {
                     ETG_TRACE_USR2(("FC_PHONE_DBUS_ERRORCODE_SIM_BUSY"));
                     vSendOutGoingFailedStatus("SIM busy",FC_PHONE_CALLINSTANCE_ACKERROR_NOK);
                  }
                  break;
                  case FC_PHONE_DBUS_ERRORCODE_INCORRECT_PASSWORD:
                  {
                     ETG_TRACE_USR2(("FC_PHONE_DBUS_ERRORCODE_INCORRECT_PASSWORD"));
                     vSendOutGoingFailedStatus("Incorrect password",FC_PHONE_CALLINSTANCE_ACKERROR_NOK);
                  }
                  break;
                  case FC_PHONE_DBUS_ERRORCODE_SIM_PIN2_REQUIRED:
                  {
                     ETG_TRACE_USR2(("FC_PHONE_DBUS_ERRORCODE_SIM_PIN2_REQUIRED"));
                     vSendOutGoingFailedStatus("SIM PIN2 required",FC_PHONE_CALLINSTANCE_ACKERROR_NOK);
                  }
                  break;
                  case FC_PHONE_DBUS_ERRORCODE_SIM_PUK2_REQUIRED:
                  {
                     ETG_TRACE_USR2(("FC_PHONE_DBUS_ERRORCODE_SIM_PUK2_REQUIRED"));
                     vSendOutGoingFailedStatus("SIM PUK2 required",FC_PHONE_CALLINSTANCE_ACKERROR_NOK);
                  }
                  break;
                  case FC_PHONE_DBUS_ERRORCODE_MEMORY_FULL:
                  {
                     ETG_TRACE_USR2(("FC_PHONE_DBUS_ERRORCODE_MEMORY_FULL"));
                     vSendOutGoingFailedStatus("Memory full",FC_PHONE_CALLINSTANCE_ACKERROR_NOK);
                  }
                  break;
                  case FC_PHONE_DBUS_ERRORCODE_INVALID_INDEX:
                  {
                     ETG_TRACE_USR2(("FC_PHONE_DBUS_ERRORCODE_INVALID_INDEX"));
                     vSendOutGoingFailedStatus("Invalid index",FC_PHONE_CALLINSTANCE_ACKERROR_NOK);
                  }
                  break;
                  case FC_PHONE_DBUS_ERRORCODE_MEMORY_FAILURE:
                  {
                     ETG_TRACE_USR2(("FC_PHONE_DBUS_ERRORCODE_MEMORY_FAILURE"));
                     vSendOutGoingFailedStatus("Memory failure",FC_PHONE_CALLINSTANCE_ACKERROR_NOK);
                  }
                  break;
                  case FC_PHONE_DBUS_ERRORCODE_TEXTSTRING_TOOLONG:
                  {
                     ETG_TRACE_USR2(("FC_PHONE_DBUS_ERRORCODE_TEXTSTRING_TOOLONG"));
                     vSendOutGoingFailedStatus("Text string too long",FC_PHONE_CALLINSTANCE_ACKERROR_NOK);
                  }
                  break;
                  case FC_PHONE_DBUS_ERRORCODE_INVALIDCHAR_TEXTSTRING:
                  {
                     ETG_TRACE_USR2(("FC_PHONE_DBUS_ERRORCODE_INVALIDCHAR_TEXTSTRING"));
                     vSendOutGoingFailedStatus("Invalid characters in text string",FC_PHONE_CALLINSTANCE_ACKERROR_NOK);
                  }
                  break;
                  case FC_PHONE_DBUS_ERRORCODE_DIAL_STRING_TOOLONG:
                  {
                     ETG_TRACE_USR2(("FC_PHONE_DBUS_ERRORCODE_DIAL_STRING_TOOLONG"));
                     vSendOutGoingFailedStatus("Dial string too long",FC_PHONE_CALLINSTANCE_ACKERROR_NOK);
                  }
                  break;
                  case FC_PHONE_DBUS_ERRORCODE_INVALIDCHAR_DIALSTRING:
                  {
                     ETG_TRACE_USR2(("FC_PHONE_DBUS_ERRORCODE_INVALIDCHAR_DIALSTRING"));
                     vSendOutGoingFailedStatus("Invalid characters in dial string",FC_PHONE_CALLINSTANCE_ACKERROR_NOK);
                  }
                  break;
                  case FC_PHONE_DBUS_ERRORCODE_NO_NETWORK_SERVICE:
                  {
                     ETG_TRACE_USR2(("FC_PHONE_DBUS_ERRORCODE_NO_NETWORK_SERVICE"));
                     vSendOutGoingFailedStatus("No network service",FC_PHONE_CALLINSTANCE_ACKERROR_NOK);
                  }
                  break;
                  case FC_PHONE_DBUS_ERRORCODE_NETWORK_TIMEOUT:
                  {
                     ETG_TRACE_USR2(("FC_PHONE_DBUS_ERRORCODE_NETWORK_TIMEOUT"));
                     vSendOutGoingFailedStatus("Network timeout",FC_PHONE_CALLINSTANCE_ACKERROR_NOK);
                  }
                  break;
                  case FC_PHONE_DBUS_ERRORCODE_EMERGENCY_CALLS_ONLY:
                  {
                     ETG_TRACE_USR2(("FC_PHONE_DBUS_ERRORCODE_EMERGENCY_CALLS_ONLY"));
                     vSendOutGoingFailedStatus("Network not allowed - Emergency calls only",FC_PHONE_CALLINSTANCE_ACKERROR_NOK);
                  }
                  break;
                  case FC_PHONE_DBUS_ERRORCODE_ERR_BUSY:
                  case FC_PHONE_DBUS_ERRORCODE_STATE_ERROR:
                  default:
                  {
                     ETG_TRACE_USR4((" This Error Code is [0x%x] ",Code) );
                     m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
                  }
                  break;
               }
               /*Sending Method Error for Dial and speed dial*/
               if(FC_PHONE_DIALTYPE_DIAL == m_en_dialType){
                  ETG_TRACE_USR4((" Sending Dial Method Result"));
                  m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_DIAL,m_poCallInstance);
               }
               else if(FC_PHONE_DIALTYPE_SPEEDDIAL == m_en_dialType){
                  ETG_TRACE_USR4((" Sending SpeedDial Method Result"));
                  m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_SPEEDDIAL,m_poCallInstance);
               }
               else if(FC_PHONE_DIALTYPE_DIALEXTENDED == m_en_dialType){
                  ETG_TRACE_USR4((" Sending DialExtended Method Result"));
                  m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_DIALEXTENDED,m_poCallInstance);
               }
               //release ringtone/Alert audio channel ,if in use
  

               // channel itself is not aquired. so no need to release

               //to stop timer if active
               vStopTimer();
               vCancel();
               m_poCallInstance->vInit();
               //send status to client : now status is IDLE
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
               m_poSMManager->vSMFinished(m_poCallInstance->m_u16Id);
            }
            else
            {
               ETG_TRACE_USR4((" Dial Call is not serviced in Other States"));
            }
         }
         break;
         case FC_PHONE_CB_FID_TERMINATE:
         {
            //Send Cancel outgoing call Method result eventhough receiving error for
            //terminate request from Phone device(Example: Blackberry) GMMY15-6691
            m_bTerminateCallPosted = FALSE;
            if(m_u16State == FC_PHONE_SMDIAL_STATE_WAIT_FOR_DISCONNECT_FROM_BT )
            {
               ETG_TRACE_USR2((" FC_PHONE_CB_FID_TERMINATE "));
               if ( m_u8RetryCount < 5 )
               {

                  ETG_TRACE_USR4((" m_u8RetryCount = %d", m_u8RetryCount));
                  m_bTerminateCallTimerRunning = TRUE;
                  ETG_TRACE_USR3((" m_bTerminateCallTimerRunning = TRUE"));
                  ETG_TRACE_USR3((" m_poCallInstance->m_u16TimerId %d", m_poCallInstance->m_u16Id ));
                  m_poTimer->s32Start(static_cast<tU16>(FC_PHONE_TERMINATECALLRETRY_TIMER_ID + m_poCallInstance->m_u16Id)
                        ,FC_PHONE_THREEHUNDRED_MILLISECOND,vCallInstanceTimerCallBack);
               }
               else
               {
                  ETG_TRACE_USR4((" Stop retrying!!!!!"));
                  // Stop both the timer
                  vStopTerminateRetryTimer();
                  vStopTimer();
                  m_u8RetryCount = 0;
                  vCancel();

                  vAssignErrorCode(Code);

                  m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_CANCELOUTGOINGCALL,m_poCallInstance);
               }
            }
            else if(m_u16State == FC_PHONE_SMDIAL_STATE_WAIT_FOR_CANCELOUTGOINGCALL_AND_AUDIO)
            {
               ETG_TRACE_USR3((" FC_PHONE_CB_FID_TERMINATE "));
               vAssignErrorCode(Code);
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_CANCELOUTGOINGCALL,m_poCallInstance);
               m_u16State = m_u16State_CurrentState;
               ETG_TRACE_USR2(("State Change:m_u16State_CurrentState"));
            }
            else
            {
               ETG_TRACE_USR4((" Terminate Call is not serviced in Other States"));
            }
         }
         break;
         case FC_PHONE_CB_FID_AUDIOTRANSFER:
         {
            ETG_TRACE_USR3((" FC_PHONE_CB_FID_AUDIOTRANSFER "));
            vAssignErrorCode(Code);
            if(m_bTransferCallToVehicleRequest == TRUE)
            {
               m_bTransferCallToVehicleRequest = FALSE;
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSFREE,m_poCallInstance);
            }
            /*It should not come to this case*/
            if(m_u16State == FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIOTRANSFER_ONDIAL)
            {
               ETG_TRACE_USR4((" Failure of audio transfer of another call"));
               vCancel();
               m_poCallInstance->vInit();
               //send status to client : now status is IDLE
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
               m_poSMManager->vSMFinished(m_poCallInstance->m_u16Id);
               break;
            }
            if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED == m_poCallInstance->m_u8AudioChannel)
            {
               m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
               ETG_TRACE_USR3((" Requesting Audio m_poCallInstance::  AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE"));
               m_poAudioManager->s32GetRequest(m_poCallInstance->m_u16Id,FC_PHONE_AUDIOCHANNEL_PHONE,vAudioCallBackDial);
               m_poCallInstance->m_bUsingVehicleAudio = TRUE;
               ETG_TRACE_USR3(("  UsingVehicleAudio = TRUE "));
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
            }
            m_u16State = FC_PHONE_SMDIAL_STATE_CALL_ROUTED;
            ETG_TRACE_USR2(("State Change:FC_PHONE_SMDIAL_STATE_CALL_ROUTED"));
         }
         break;
         case FC_PHONE_CB_FID_SENDDTMF:
         {
            //Targeted to SM hence dont care of States
            ETG_TRACE_USR3((" FC_PHONE_CB_FID_SENDDTMF "));
            vAssignErrorCode(Code);
            (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vSetDtmfStatus(FALSE);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_PLAYDTMF,m_poCallInstance);
            m_u16State = FC_PHONE_SMDIAL_STATE_CALL_ROUTED;
            ETG_TRACE_USR2(("State Change:FC_PHONE_SMDIAL_STATE_CALL_ROUTED"));
         }
         break;
         default:
         {
            ETG_TRACE_USR4((" This Event ID is not supported yet"));
            break;
         }
      }
   }
   else
   {
      ETG_TRACE_ERR(("Call Instance  is NULL"));
   }
}

/*******************************************************************************
 *
 * FUNCTION: vAssignErrorCode
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMDial::vAssignErrorCode(tChar Code)
{
   if(m_poCallInstance)
   {
      switch(Code)
      {
         case FC_PHONE_DBUS_ERRORCODE_STATE_ERROR:
         {
            m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACK_STATE_ERROR;
         }
         break;
         case FC_PHONE_DBUS_ERRORCODE_OPERATION_NOT_ALLOWED:
         case FC_PHONE_DBUS_ERRORCODE_OPERATION_NOT_SUPPORTED:
         {
            m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOTAVAILABLE;
         }
         break;
         default:
         {
            ETG_TRACE_USR4((" IN DEFAULT This Error Code [0x%x] is not supported yet",Code) );
            m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
         }
         break;
      }
   }
   else
   {
      ETG_TRACE_ERR(("Call Instance  is NULL"));
   }
}

/*******************************************************************************
 *
 * FUNCTION: vSetDtmfLength
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMDial::vSetDtmfLength(tU16 u16DtmfLength)
{
   ETG_TRACE_USR4(("Entering fc_phone_tclSMDial::vSetDtmfLength "));
   m_u16DTMFCharLength = u16DtmfLength;
}



/*******************************************************************************
 * FUNCTION: vTerminateOutgoingCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMDial::vTerminateOutgoingCall()
{
   ETG_TRACE_USR4(("Entering fc_phone_tclSMDial::vTerminateOutgoingCall "));
   FCPhoneDbusClient_TerminateType_t enTerminateType = FC_PHONE_DBUS_TERMINATETYPE_SINGLECALL;
   tU16 u16SMCount = 0;

   // gmmy15-8470- when cancel outgoing event is received after posting dial for second call and callstatus for second call not received.
   for (tU16 indx = 0; indx < FC_PHONE_SMMANAGER_MAX_SM_SUPPORTED; indx++)
   {
      if (m_poSMManager)
      {
         ETG_TRACE_USR4(("Checking the call object state of current call instance"));
         if(FC_PHONE_CALLINSTANCE_OBJECTSTATE_ACTIVE == m_poSMManager->u8GetCallObjectState(indx))
         {
            ETG_TRACE_USR4((" FC_PHONE_CALLINSTANCE_OBJECTSTATE_ACTIVE "));
            u16SMCount++;
         }
      }
   }
   ETG_TRACE_USR3(("SMCount is:  %d", u16SMCount));

   if (m_poCallInstance)
   {
      if (!m_bTerminateCallPosted)
      {
         if (fc_phone_tclCallManager::m_u16Count > 1 || u16SMCount > 1)
         {
            ETG_TRACE_USR4(("Terminating ACTIVE Call"));
            //send property status to client
            m_poCallInstance->m_u16CallStatusNotice = FC_PHONE_CALLINSTANCE_CALLSTATUS_DIALING;
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, m_poCallInstance);
            m_u16State = FC_PHONE_SMDIAL_STATE_WAIT_FOR_DISCONNECT_FROM_BT;
            ETG_TRACE_USR2(("State Change:FC_PHONE_SMDIAL_STATE_WAIT_FOR_DISCONNECT_FROM_BT"));
            m_bTerminateCallPosted = TRUE;
            ETG_TRACE_USR4((" enTerminateType :; %d", enTerminateType));
            m_u8RetryCount++;
#ifndef BLUETOOTH_DISABLE_ENHANCED_CALL_CTRL // Disabled enhanced call control in BT_Stack
            //GMMY15-9890 To cancel the second outgoing call using HfReleaseSpecCall when ENDTARGETCALL is supported by the device
            if (((fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->getAgThreeWayCallSuppFeatures()) & FC_PHONE_ENHANCECALLCTRL_ENDTARGETCALL_MASK)
            {
               fc_phone_tclCallManager *p_callManagerInstance = (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->m_poCallManager;
               if (p_callManagerInstance)
               {
                  //GMMY16-2960 - to find corresponding instance to be sent to DBus
                  tU16 u16DbusCallInstance = p_callManagerInstance->u16GetDbusCallInstanceFromCM(m_poCallInstance->m_u16Id);
                  ETG_TRACE_USR2(("u16DbusCallInstance %d", u16DbusCallInstance));
                  enTerminateType = FC_PHONE_DBUS_TERMINATETYPE_THREEWAYCALL_SPECIFIC_CANCEL_OUTGOING;
                  ETG_TRACE_USR4((" enTerminateType :; %d", enTerminateType));
                  m_pDbusIf->bReleaseSpecCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId), enTerminateType, (const unsigned char) u16DbusCallInstance);
                  return;
               }
               else
               {
                  ETG_TRACE_ERR(("The p_callManagerInstance is NULL. Hence not terminating the call."));
               }
            }
#endif // Disabled enhanced call control in BT_Stack
            if ((fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->bIsAgThreeWayCallSupported())
            {
               enTerminateType = FC_PHONE_DBUS_TERMINATETYPE_MULTIPLECALL_ACTIVE;
            }
            ETG_TRACE_USR4((" enTerminateType :; %d", enTerminateType));
            m_pDbusIf->bTerminateCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId), enTerminateType);
         }
         /*Ending a single call*/
         else if ((fc_phone_tclCallManager::m_u16Count == 1) && (m_poCallInstance->m_u16CallStatusNotice == FC_PHONE_CALLINSTANCE_CALLSTATUS_DIALING))
         {
            //send property status to client
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, m_poCallInstance);
            m_u16State = FC_PHONE_SMDIAL_STATE_WAIT_FOR_DISCONNECT_FROM_BT;
            ETG_TRACE_USR2(("State Change:FC_PHONE_SMDIAL_STATE_WAIT_FOR_DISCONNECT_FROM_BT"));
            ETG_TRACE_USR4(("Terminating Single Call"));
            m_bTerminateCallPosted = TRUE;
            m_u8RetryCount++;
            m_pDbusIf->bTerminateCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId), enTerminateType);
         }
         //Received Cancel outgoing call before receiving call status from Phone device (Example: Blackberry) GMMY15-6691
         else if (fc_phone_tclCallManager::m_u16Count == 0 && (m_poCallInstance->m_u16CallStatusNotice == FC_PHONE_CALLINSTANCE_CALLSTATUS_DIALING))
         {
            ETG_TRACE_USR4(("Terminating single call"));
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, m_poCallInstance);
            m_u16State = FC_PHONE_SMDIAL_STATE_WAIT_FOR_DISCONNECT_FROM_BT;
            ETG_TRACE_USR2(("State Change:FC_PHONE_SMDIAL_STATE_WAIT_FOR_DISCONNECT_FROM_BT"));
            m_bTerminateCallPosted = TRUE;
            m_u8RetryCount++;
            m_pDbusIf->bTerminateCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId), enTerminateType);
         }
         else
         {
            ETG_TRACE_ERR(("Call Count doesn't Match"));
         }
      }
   }
   else
   {
      ETG_TRACE_ERR(("Call Instance  is NULL"));
   }
}



/*******************************************************************************
 *
 * FUNCTION: vCancelOutgoingCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMDial::vCancelOutgoingCall()
{
   if(m_poCallInstance)
   {
      ETG_TRACE_USR2(("fc_phone_tclSMDial::vCancelOutgoingCall Entered "));
      //update the state
      m_u16State = FC_PHONE_SMDIAL_STATE_WAIT_FOR_CANCELOUTGOINGCALL_AND_AUDIO ;
      ETG_TRACE_USR2(("State Change:FC_PHONE_SMDIAL_STATE_WAIT_FOR_CANCELOUTGOINGCALL_AND_AUDIO "));
      //send property status to client
      m_poCallInstance->m_u16CallStatusNotice = FC_PHONE_CALLINSTANCE_CALLSTATUS_DIALING;
      m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);

      //release ringtone/Alert audio channel, if in use
      if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED !=  m_poCallInstance->m_u8AudioChannel )
      {	//posted for channel release to audiomanager with dummy call back so that the ACK is not processed in state machines.
         ETG_TRACE_USR3((" RELEASING Audio channel.. "));
         if(m_poAudioManager)
         {
            m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id, m_poCallInstance->m_u8AudioChannel,vAudioCallBackDummy);
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
            m_poCallInstance->m_bUsingVehicleAudio = FALSE;
            ETG_TRACE_USR3(("  UsingVehicleAudio = FALSE "));
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
         }
         else
         {
            ETG_TRACE_USR3((" Audio Manager instance is not Null"));
         }
      }
      //Deallocation will be done by AV_Manager , Phone F-block is not waiting for response
      // and proceeds to corresponding internal state with deallocation as success.
      bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
   }
   else
   {
      ETG_TRACE_ERR(("Call Instance  is NULL"));
   }
}


/*******************************************************************************
 *
 * FUNCTION: vStopTerminateRetryTimer
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMDial::vStopTerminateRetryTimer()
{
   ETG_TRACE_USR4(("Entering fc_phone_tclSMDial::vStopTerminateRetryTimer,m_bTerminateCallTimerRunning : %d ",m_bTerminateCallTimerRunning));

   if(( m_poCallInstance ) && ( TRUE == m_bTerminateCallTimerRunning ) )
   {
      ETG_TRACE_USR4((" Stopping TIMER - FC_PHONE_TERMINATECALLRETRY_TIMER_ID"));
      m_poTimer->s32Stop(static_cast<tU16>(m_poCallInstance->m_u16Id + FC_PHONE_TERMINATECALLRETRY_TIMER_ID ));
      m_bTerminateCallTimerRunning = FALSE;
      ETG_TRACE_USR4((" m_bTerminateCallTimerRunning = FALSE"));
   }
}
/*******************************************************************************
 *
 * FUNCTION: vHandleCallstatusFailure
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMDial::vHandleCallstatusFailure()
{
   ETG_TRACE_USR4(("Entering fc_phone_tclSMDial::vHandleCallstatusFailure"));

   vStopCallStatusFailureTimer();
   if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_poCallInstance->m_u8AudioChannel )
   {
      ETG_TRACE_USR3((" RELEASING Audio channel.. "));
      m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id, m_poCallInstance->m_u8AudioChannel,vAudioCallBackDial);
   }
   //Update the audio channel status
   m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED ;
   m_poCallInstance->m_bUsingVehicleAudio = FALSE;
   ETG_TRACE_USR3(("  UsingVehicleAudio = FALSE "));
   m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);

   //to stop timer if active
   vStopTimer();

   vStopTerminateRetryTimer(); //Start terminate retry timer if running.
   m_u8RetryCount = 0;

   vCancel();
   m_poCallInstance->vInit();
   //send status to client : now status is IDLE
   m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
   m_poSMManager->vSMFinished(m_poCallInstance->m_u16Id);
}
/*******************************************************************************
 *
 * FUNCTION: vHandleCallstatusFailure
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMDial::vStopCallStatusFailureTimer()
{
   ETG_TRACE_USR4(("Entering fc_phone_tclSMDial::vStopCallStatusFailureTimer"));
   if ( m_bCallStatusFailureTimerRunning )
   {
      ETG_TRACE_USR4((" Call status timer failure timer stopped"));
      m_poTimer->s32Stop(static_cast<tU16>(FC_PHONE_DIAL_CALLSTATUS_FAILURE_TIMER_ID + m_poCallInstance->m_u16Id));
      m_bCallStatusFailureTimerRunning = FALSE;
   }
}

 /*******************************************************************************
 *
 * FUNCTION: vCancelSMReleaseChannel
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMDial::vCancelSMReleaseChannel()
{
   ETG_TRACE_USR4(("Entering fc_phone_tclSMDial::vCancelSMReleaseChannel"));
   if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_poCallInstance->m_u8AudioChannel )
   {
      ETG_TRACE_USR3((" RELEASING Audio channel.. "));
      m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id, m_poCallInstance->m_u8AudioChannel,vAudioCallBackDial);
   }
   //Update the audio channel status
   m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED ;
   m_poCallInstance->m_bUsingVehicleAudio = FALSE;
   ETG_TRACE_USR3(("  UsingVehicleAudio = FALSE "));
   m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);

   //to stop timer if active
   vStopTimer();

   vStopTerminateRetryTimer(); //Start terminate retry timer if running.
   m_u8RetryCount = 0;
   vCancel();
   m_poCallInstance->vInit();
   //send status to client : now status is IDLE
   m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
   m_poSMManager->vSMFinished(m_poCallInstance->m_u16Id);

}

/*******************************************************************************
 *
 * FUNCTION: vSendOutGoingFailedStatus
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMDial::vSendOutGoingFailedStatus(tCString ErrorInfo,tU8 u8DbusAckType)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMDial::vSendOutGoingFailedStatus with u8DbusAckType :%d",u8DbusAckType));
   m_poCallInstance->m_AckError = u8DbusAckType;
   vStringCopy(m_poCallInstance->m_strDialCallFailedReason,ErrorInfo,PHONE_CALLNUMBER_LENGTH);
   m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_OUTGOING_FAILED,m_poCallInstance);
}
