/******************************************************************************
 *
 * FILE:          FC_Phone_SMConferenceCall.cpp
 *
 * SW-COMPONENT:  FC_Phone application
 *
 * PROJECT:
 *
 * DESCRIPTION:   CCA service Telephone.
 *
 * AUTHOR:
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

#include "FC_Phone_SMIncludes.h"
#include "../HelperClasses/FC_Phone_CallManager.h"
#include "../FC_Phone_service_Telephone.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_PHONE_APPLICATION
#include "trcGenProj/Header/FC_Phone_SMConferenceCall.cpp.trc.h"
#endif


tVoid vAudioCallBackConfCall(tU16 u16AudioReqID,tU16 u16AudioChannelId, tU16 u16RequestState)
{
   ETG_TRACE_USR4((" ENTER: vAudioCallBackConfCall"));

   fc_phone_tclSM* pSMInstance;
   pSMInstance = fc_phone_tclSMManager::GetSM_FromAudioRequestorId(u16AudioReqID);
   if(pSMInstance)
   {
      pSMInstance->vAudioCallBack(u16AudioChannelId,u16RequestState);
   }
   else
   {
      ETG_TRACE_ERR((" ERROR:: could not get SM for u16TimerId %d",u16AudioReqID));
   }

   ETG_TRACE_USR4((" EXIT: vAudioCallBackConfCall"));
}

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMConferenceCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
fc_phone_tclSMConferenceCall::fc_phone_tclSMConferenceCall(fc_phone_tclCallInstance *rfpCallInstance[]):
        					      fc_phone_tclSM(rfpCallInstance)

{
   ETG_TRACE_USR4((" ENTER: fc_phone_tclSMConferenceCall::fc_phone_tclSMConferenceCall"));

   m_u16State = FC_PHONE_CONFERENCECALL_STATE_CONFERENCE_CALL_STARTED;
   ETG_TRACE_USR2((" State Change: FC_PHONE_CONFERENCECALL_STATE_CONFERENCE_CALL_STARTED"));
   m_bEventConsumed = FALSE ;
   m_bTimerRunning = FALSE ;
   ETG_TRACE_USR3((" TimerRunning = FALSE "));
   //m_numberOfCalls = FC_PHONE_MAX_CALLINSTANCES;
   m_splitCallInstanceID  = 0;
   m_releaseCallInstanceID = 0;
   m_pReleaseCallInstance = NULLPTR;
   m_bHangUpMethodStart = FALSE;
   m_bHangUpAllMethodStart = FALSE;
   m_u16State_while_TransferAudio = 0;
   m_isConfFromCallStatus = FALSE;
   m_isConfFromHmiCallInHandset = FALSE;
   m_u8CallTransferDirection = FC_PHONE_CALLTRANSFER_DIRECTION_UNKNOWN;
   m_SlcOff = FALSE;
   m_u16SentDtmfCounter  = 0;
   m_u16DTMFCharLength   = 0;
   u16_oneTimeDTMFCalculation = 0;
   m_bSplitMethodResultSent = FALSE;
   ETG_TRACE_USR4((" EXIT: fc_phone_tclSMConferenceCall::fc_phone_tclSMConferenceCall"));
}

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMConferenceCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
fc_phone_tclSMConferenceCall::fc_phone_tclSMConferenceCall(fc_phone_tclCallInstance *rfpCallInstance[], tVoid *vArg):
                                                      fc_phone_tclSM(rfpCallInstance)

{
   ETG_TRACE_USR4((" ENTER: fc_phone_tclSMConferenceCall::fc_phone_tclSMConferenceCall with args"));

   FCPhoneConf_InputParamStruct *pst_inparam = (FCPhoneConf_InputParamStruct *)vArg;

   if (pst_inparam->isConfFromCallStatus)
   {
      ETG_TRACE_USR4((" m_isConfFromCallStatus is true"));
      m_isConfFromCallStatus = TRUE;
      m_isConfFromHmiCallInHandset = TRUE;
      vSetCallStatusConference();

      if (m_poCallInstance)
      {
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, m_poCallInstance);
      }

      if (m_poCallInstance2)
      {
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, m_poCallInstance2);
      }
   }
   else
   {
      ETG_TRACE_USR4((" m_isConfFromCallStatus is false"));
      m_isConfFromCallStatus = FALSE;
      m_isConfFromHmiCallInHandset = TRUE;
   }

   m_u16State = FC_PHONE_CONFERENCECALL_STATE_CONFERENCE_CALL_STARTED;
   ETG_TRACE_USR2((" State Change: FC_PHONE_CONFERENCECALL_STATE_CONFERENCE_CALL_STARTED"));
   m_bEventConsumed = FALSE ;
   m_bTimerRunning = FALSE ;
   ETG_TRACE_USR3((" TimerRunning = FALSE "));
   //m_numberOfCalls = FC_PHONE_MAX_CALLINSTANCES;
   m_splitCallInstanceID  = 0;
   m_releaseCallInstanceID = 0;
   m_pReleaseCallInstance = NULLPTR;
   m_bHangUpMethodStart = FALSE;
   m_bHangUpAllMethodStart = FALSE;
   m_SlcOff = FALSE;
   m_u16State_while_TransferAudio = 0;
   m_u16SentDtmfCounter  = 0;
   m_u16DTMFCharLength   = 0;
   u16_oneTimeDTMFCalculation = 0;
   m_bSplitMethodResultSent = FALSE;
   m_u8CallTransferDirection = FC_PHONE_CALLTRANSFER_DIRECTION_UNKNOWN;
   ETG_TRACE_USR4((" EXIT: fc_phone_tclSMConferenceCall::fc_phone_tclSMConferenceCall"));
}

/*******************************************************************************
 *
 * FUNCTION: ~fc_phone_tclSMConferenceCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
/* Destructor */
fc_phone_tclSMConferenceCall::~fc_phone_tclSMConferenceCall()
{
   ETG_TRACE_USR4((" ENTER: fc_phone_tclSMConferenceCall::~fc_phone_tclSMConferenceCall"));
   //GMMY16-23481
   (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vSetConfSMStatus(FALSE);
   m_pReleaseCallInstance = NULLPTR;


}
/*******************************************************************************
 *
 * FUNCTION: vCancel
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMConferenceCall::vCancel(tVoid)
{
   ETG_TRACE_USR4((" ENTER: fc_phone_tclSMConferenceCall::vCancel"));

   if (m_bTimerRunning == TRUE)
   {
      //to stop timer if running
      if (m_poCallInstance)
      {
         m_poTimer->s32Stop(m_poCallInstance->m_u16TimerId); // Bugfix for GMMY16-17241
      }

      if (m_poCallInstance2)
      {
         m_poTimer->s32Stop(m_poCallInstance2->m_u16TimerId); // Bugfix for GMMY16-17241
      }

      m_bTimerRunning = FALSE;
      ETG_TRACE_USR3((" TimerRunning = FALSE "));
   }
   m_u16State_while_TransferAudio = 0;

   // If DTMF sending is not finished , send method error
   if (m_u16SentDtmfCounter != m_u16DTMFCharLength)
   {
      ETG_TRACE_USR4((" sending Methos Error to client"));
      u16_oneTimeDTMFCalculation = 0;
      m_u16SentDtmfCounter  = 0;
      m_u16DTMFCharLength   = 0;
      if (m_poCallInstance)
      {
         m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_PLAYDTMF,m_poCallInstance);
      }
      else if (m_poCallInstance2)
      {
         m_poCallInstance2->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_PLAYDTMF,m_poCallInstance2);
      }
   }
}
/*******************************************************************************
 *
 * FUNCTION: vExecute
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMConferenceCall::vExecute()
{
   ETG_TRACE_USR4((" ENTER: fc_phone_tclSMConferenceCall::vExecute"));

   m_bTimerRunning = TRUE ;
   ETG_TRACE_USR3((" TimerRunning = TRUE "));
   /* Delegate it to Dbus */
   //m_u16State = FC_PHONE_CONFERENCECALL_STATE_WAIT_FOR_CONNECT_FROM_BT;
   m_u16State = FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED;
   ETG_TRACE_USR2((" State Change: FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED"));

   if (!m_isConfFromCallStatus)
   {
      if(m_poCallInstance)
      {
         ETG_TRACE_USR4((" fc_phone_tclSMConferenceCall::calling DBUS bConfCall"));
         m_pDbusIf->bConfCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId));
      }
   }
   else
   {
      ETG_TRACE_USR4((" fc_phone_tclSMConferenceCall::Conf from call status"));
   }

}

/*******************************************************************************
 *
 * FUNCTION: bProcessEvent
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/

tBool fc_phone_tclSMConferenceCall::bProcessEvent(tU16 u16EventId,tVoid *varg)
{
   ETG_TRACE_USR4((" ENTER: fc_phone_tclSMConferenceCall::bProcessEvent with arg"));

   tBool bRetVal= FALSE ;

   FcPhone_processEventArg   *ptProcessEventArg = (FcPhone_processEventArg *) varg;
   //if dbus call is not success , update the error code

   if(TRUE == ptProcessEventArg->bIsItDbusAck )
   {
      ETG_TRACE_USR4((" Status :: %d  Code :: 0x%x",ptProcessEventArg->Status,ptProcessEventArg->Code));
      if(ptProcessEventArg->u16DbusAckType == FC_PHONE_CB_FID_AUDIOTRANSFER)
      {
         if(ptProcessEventArg->Status == CALLTRANSFER_FAILURE)
         {
            ETG_TRACE_USR4(("DBUS TransferCall  FAILS"));
            vHandleDbusError(ptProcessEventArg->u16DbusAckType,ptProcessEventArg->Code);
         }
         else
         {
            ETG_TRACE_USR4(("DBUS TransferCall  SUCCESS"));
            bRetVal = bProcessEvent(u16EventId);
         }
      }
      else
      {

         if(FC_PHONE_DBUS_STATUS_SUCCESS != ptProcessEventArg->Status)
         {
            ETG_TRACE_USR4((" DBUS Call is not succeed, updating error code"));
            vHandleDbusError(ptProcessEventArg->u16DbusAckType, ptProcessEventArg->Code);
         }
         else
         {
            ETG_TRACE_USR4((" DBUS Call is  succeeded "));
            bRetVal = bProcessEvent(u16EventId) ;
         }
      }
   }
   else
   {
      if (u16EventId == FC_PHONE_SM_EVENT_SPLITCALL_OK)
      {
         ETG_TRACE_USR4((" u16CallInstanceID :: %d  m_splitCallInstanceID :: %d",ptProcessEventArg->u16CallInstanceID,m_splitCallInstanceID));
         m_splitCallInstanceID = ptProcessEventArg->u16CallInstanceID;
      }
      else if(u16EventId == FC_PHONE_SM_EVENT_HANGUPCALL_OK)
      {
         ETG_TRACE_USR4((" u16CallInstanceID :: %d",ptProcessEventArg->u16CallInstanceID));
         m_releaseCallInstanceID = ptProcessEventArg->u16CallInstanceID;

         if(m_poCallInstance)
         {
            if (m_releaseCallInstanceID == m_poCallInstance->m_u16Id)
            {
               m_pReleaseCallInstance = m_poCallInstance ;

            }
         }

         if(m_poCallInstance2)
         {
            if (m_releaseCallInstanceID == m_poCallInstance2->m_u16Id)
            {
               m_pReleaseCallInstance = m_poCallInstance2 ;

            }
         }
         ETG_TRACE_USR4((" m_releaseCallInstanceID :: %d",m_releaseCallInstanceID));
      }
      bRetVal = bProcessEvent(u16EventId) ;
   }
   ETG_TRACE_USR4((" EXIT : fc_phone_tclSMConferenceCall::bProcessEvent with arg"));
   m_bEventConsumed = FALSE;
   return bRetVal ;
}

/*******************************************************************************
 *
 * FUNCTION: bProcessEvent
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tBool fc_phone_tclSMConferenceCall::bProcessEvent(tU16 u16EventId)
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMConferenceCall::bProcessEvent with EventID %d", u16EventId));

   switch (m_u16State)
   {
      case FC_PHONE_CONFERENCECALL_STATE_WAIT_FOR_CONNECT_FROM_BT:
      {
         ETG_TRACE_USR2((" STATE :: FC_PHONE_CONFERENCECALL_STATE_WAIT_FOR_CONNECT_FROM_BT "));
         vHandleEventInConferenceCall(u16EventId);
      }
      break;

      case FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED:
      {
         ETG_TRACE_USR2((" STATE :: FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED "));
         vHandleEventInCallRouted(u16EventId);
      }
      break;

      case FC_PHONE_CONFERENCECALL_STATE_WAIT_FOR_SPLITCALL:
      {
         ETG_TRACE_USR2((" STATE :: FC_PHONE_CONFERENCECALL_STATE_WAIT_FOR_SPLITCALL "));
         vHandleEventInSplitCall(u16EventId);
      }
      break;
      //Single Hangup sequence
      case FC_PHONE_CONFERENCECALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE:
      {
         ETG_TRACE_USR2(("STATE :: FC_PHONE_CONFERENCECALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE "));
         vHandleAudioReleaseCallInstance(u16EventId);
      }
      break;

      case FC_PHONE_CONFERENCECALL_STATE_HANGUPSINGLE:
      {
         ETG_TRACE_USR2((" STATE :: FC_PHONE_CONFERENCECALL_STATE_HANGUPSINGLE "));
         vHandleEventHangUpSingleCall(u16EventId);
      }
      break;

      //Restore conference after transfer call to vehicle
      case FC_PHONE_SMCONFERENCECALL_STATE_WAIT_FOR_AUDIOACTIVATION_ON_RESTORECONFERENCESM_CALLINSTANCE1:
      {
         ETG_TRACE_USR2((" STATE :: FC_PHONE_SMCONFERENCECALL_STATE_WAIT_FOR_AUDIOACTIVATION_ON_RESTORECONFERENCESM_CALLINSTANCE1 "));
         vHandleEventInAudioAcquisitionOnRestoreConferenceSMCallInstance1(u16EventId);
      }
      break;

      case FC_PHONE_SMCONFERENCECALL_STATE_WAIT_FOR_AUDIOACTIVATION_ON_RESTORECONFERENCESM_CALLINSTANCE2:
      {
         ETG_TRACE_USR2((" STATE :: FC_PHONE_SMCONFERENCECALL_STATE_WAIT_FOR_AUDIOACTIVATION_ON_RESTORECONFERENCESM_CALLINSTANCE2 "));
         vHandleEventInAudioAcquisitionOnRestoreConferenceSMCallInstance2(u16EventId);
      }
      break;

      //FIX GMMY15-8315 [CT]Cannot place conference call on hold
      //Hold request was not handled in this state machine, hence conference call was not possible to be put on hold.
      //This is state that handles acknowledgement for Hold call
      case FC_PHONE_SMCONFERENCECALL_STATE_WAIT_FOR_HOLDCALL_ACK:
      {
         ETG_TRACE_USR2((" STATE :: FC_PHONE_SMCONFERENCECALL_STATE_WAIT_FOR_HOLDCALL_ACK "));
         vHandleEventInHoldCallAck(u16EventId);
      }
      break;

      case FC_PHONE_SMCONFERENCECALL_STATE_WAIT_FOR_RESUMECALL_ACK:
      {
         ETG_TRACE_USR2((" STATE :: FC_PHONE_SMCONFERENCECALL_STATE_WAIT_FOR_RESUMECALL_ACK "));
         vHandleEventInResumeCallAck(u16EventId);
      }
      break;
      //End of fix

      default:
      {
         ETG_TRACE_USR4((" fc_phone_tclSMConferenceCall::bProcessEvent DEFAULT  "));

      }
      break;
   }


   m_bEventConsumed |= m_bEventConsumed;
   ETG_TRACE_USR4((" EXIT : fc_phone_tclSMConferenceCall::bProcessEvent"));

   return m_bEventConsumed ;

}

/*******************************************************************************
 *
 * FUNCTION: vHandleConfCallError
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMConferenceCall::vHandleConfCallError()
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMConferenceCall::vHandleConfCallError"));

   //update status
   if(m_poCallInstance)
   {
      m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_CONFCALL,m_poCallInstance);
   }
   ETG_TRACE_USR4((" EXIT : fc_phone_tclSMConferenceCall::vHandleConfCallError"));
}

/*******************************************************************************
 *
 * FUNCTION: vHandleSplitCallError
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMConferenceCall::vHandleSplitCallError()
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMConferenceCall::vHandleSplitCallError"));

   m_u16State = FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED ;
   ETG_TRACE_USR2((" State Change: FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED"));
   //update status
   if(m_poCallInstance)
   {
      m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_SPLITCALL,m_poCallInstance);
   }

   ETG_TRACE_USR4((" EXIT : fc_phone_tclSMConferenceCall::vHandleSplitCallError"));
}

/*******************************************************************************
 *
 * FUNCTION: vHandleHangUpCallError
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMConferenceCall::vHandleHangUpCallError()
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMConferenceCall::vHandleHangUpCallError"));

   m_u16State = FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED ;
   ETG_TRACE_USR2((" State Change: FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED"));
   //update status
   if(m_poCallInstance)
   {
      m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_HANGUP,m_poCallInstance);
   }
   m_u16State_while_TransferAudio = 0;
   if(m_poCallInstance)
   {
      if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED == m_poCallInstance->m_u8AudioChannel)
      {
         ETG_TRACE_USR4((" ENTER : fc_phone_tclSMConferenceCall::acquire Phone Channel"));
         m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
         ETG_TRACE_USR3((" Requesting Audio m_poCallInstance ::AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE"));
         m_poAudioManager->s32GetRequest(m_poCallInstance->m_u16Id, m_poCallInstance->m_u8AudioChannel, vAudioCallBackConfCall);
         m_poCallInstance->m_bUsingVehicleAudio = TRUE;
         ETG_TRACE_USR3((" UsingVehicleAudio = TRUE"));
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO, m_poCallInstance);
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
      }
   }
   if(m_poCallInstance2)
   {
      if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED == m_poCallInstance2->m_u8AudioChannel)
      {
         ETG_TRACE_USR4((" ENTER : fc_phone_tclSMConferenceCall::acquire Phone Channel"));
         m_poCallInstance2->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
         ETG_TRACE_USR3((" Requesting Audio m_poCallInstance ::AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE "));
         m_poAudioManager->s32GetRequest(m_poCallInstance2->m_u16Id,m_poCallInstance2->m_u8AudioChannel,vAudioCallBackConfCall);
         m_poCallInstance2->m_bUsingVehicleAudio = TRUE;
         ETG_TRACE_USR3((" UsingVehicleAudio = TRUE"));
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO, m_poCallInstance2);
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance2);
      }
   }

   ETG_TRACE_USR4((" EXIT : fc_phone_tclSMConferenceCall::vHandleHangUpCallError"));
}

/*******************************************************************************
 *
 * FUNCTION: vRecreateSM
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMConferenceCall::vRestoreSM()
{
   ETG_TRACE_USR4((" ENTER: fc_phone_tclSMConferenceCall::vRestoreSM"));

   fc_phone_tclCallInstance *pCallInstance[FC_PHONE_MAX_CALLINSTANCES];
   pCallInstance[0] = m_poCallInstance;
   pCallInstance[1] = m_poCallInstance2;

   (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vSetConfSMStatus(FALSE);

   //Revert to corresponding State Machine
   m_poSMManager->vRevertStateMachine(pCallInstance);

   ETG_TRACE_USR4((" EXIT: fc_phone_tclSMConferenceCall::vRestoreSM"));
}

/*******************************************************************************
 *
 * FUNCTION: vRestore
 *
 * DESCRIPTION:Restore Conference call SM once conference call is transferred from Handset to Vehicle
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMConferenceCall::vRestore(tVoid)
{
   m_bTimerRunning = TRUE;
   ETG_TRACE_USR3((" TimerRunning = TRUE "));
   ETG_TRACE_USR4((" Restore Conference Call State Machine"));

   if(m_poCallInstance)
   {
      tU8 u8SCOConnectionStatus = FC_PHONE_DBUS_SCO_CONN_FAILED;
      fc_phone_tclClientHandler_BTSettings *p_clientHndler_bluetooth = (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerBTSettings;
      u8SCOConnectionStatus = p_clientHndler_bluetooth->vGetSCOConnectionStatus(const_cast<tChar *> (fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId))); //CMG3G-4847 - To solve Lint
      //only if sco is connected request for channel
      if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_ESTABLISHED)
      {
         if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED == m_poCallInstance->m_u8AudioChannel)
         {
            /*When already call is in handset and in Conference, user request for transfer call to vehicle*/
            m_u16State = FC_PHONE_SMCONFERENCECALL_STATE_WAIT_FOR_AUDIOACTIVATION_ON_RESTORECONFERENCESM_CALLINSTANCE1;
            ETG_TRACE_USR2((" State Change: FC_PHONE_SMCONFERENCECALL_STATE_WAIT_FOR_AUDIOACTIVATION_ON_RESTORECONFERENCESM_CALLINSTANCE1"));
            ETG_TRACE_USR4((" Set to FC_PHONE_SMCONFERENCECALL_STATE_WAIT_FOR_AUDIOACTIVATION_ON_RESTORECONFERENCESM_CALLINSTANCE1 state"));
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
            ETG_TRACE_USR3((" Requesting Audio m_poCallInstance ::AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE "));
            m_poAudioManager->s32GetRequest(m_poCallInstance->m_u16Id,FC_PHONE_AUDIOCHANNEL_PHONE,vAudioCallBackConfCall);
         }
         else
         {
            /*Call is transferred from handset(Transferred conference call  from Vehicle to Handset) to Vehicle*/
            ETG_TRACE_USR4((" Set to FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED state"));
            m_u16State = FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED;
            ETG_TRACE_USR2((" State Change: FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED"));
         }
      }
      else
      {
         ETG_TRACE_USR4(("SCOConnectionStatus is disconnected channel will be allocated when SCO is connected later"));
         m_u16State = FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED;
         ETG_TRACE_USR2((" State Change: FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED"));
      }
   }
   else if(m_poCallInstance2)
   {
      tU8 u8SCOConnectionStatus = FC_PHONE_DBUS_SCO_CONN_FAILED;
      fc_phone_tclClientHandler_BTSettings *p_clientHndler_bluetooth = (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerBTSettings;
      u8SCOConnectionStatus = p_clientHndler_bluetooth->vGetSCOConnectionStatus(const_cast<tChar *> (fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance2->m_u8BDAddressId))); //CMG3G-4847 - To solve Lint
      //only if sco is connected request for channel
      if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_ESTABLISHED)
      {
         if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED == m_poCallInstance2->m_u8AudioChannel)
         {
            /*When already call is in handset and in Conference, user request for transfer call to vehicle*/

            m_u16State = FC_PHONE_SMCONFERENCECALL_STATE_WAIT_FOR_AUDIOACTIVATION_ON_RESTORECONFERENCESM_CALLINSTANCE2;
            ETG_TRACE_USR2((" State Change:FC_PHONE_SMCONFERENCECALL_STATE_WAIT_FOR_AUDIOACTIVATION_ON_RESTORECONFERENCESM_CALLINSTANCE2"));
            ETG_TRACE_USR4((" Set to FC_PHONE_SMCONFERENCECALL_STATE_WAIT_FOR_AUDIOACTIVATION_ON_RESTORECONFERENCESM_CALLINSTANCE2 state"));
            m_poCallInstance2->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
            ETG_TRACE_USR3((" Requesting Audio m_poCallInstance ::AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE "));
            m_poAudioManager->s32GetRequest(m_poCallInstance2->m_u16Id,FC_PHONE_AUDIOCHANNEL_PHONE,vAudioCallBackConfCall);
         }
         else
         {
            /*Call is transferred from handset(Transferred conference call  from Vehicle to Handset) to Vehicle*/
            ETG_TRACE_USR4((" Set to FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED state"));
            m_u16State = FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED;
            ETG_TRACE_USR2((" State Change:FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED"));
         }
      }
      else
      {
         ETG_TRACE_USR4(("SCOConnectionStatus is disconnected channel will be allocated when SCO is connected later"));
         m_u16State = FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED;
         ETG_TRACE_USR2((" State Change:FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED"));
      }
   }
   else
   {
      /*Call is transferred from handset(Transferred conference call  from Vehicle to Handset) to Vehicle*/
      ETG_TRACE_USR4((" Set to FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED state"));
      m_u16State = FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED;
      ETG_TRACE_USR2((" State Change:FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED"));
   }

}

/*******************************************************************************
 *
 * FUNCTION: vHandleEventInAudioAcquisitionOnRestoreConferenceSMCallInstance1
 *
 * DESCRIPTION: Call is in conference in handset(walked in with conference->assuming active call in handset
  m/s is running) and transferring to vehicle
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/

tVoid fc_phone_tclSMConferenceCall::vHandleEventInAudioAcquisitionOnRestoreConferenceSMCallInstance1(tU16 u16EventId)
{
   ETG_TRACE_USR4((" ENTER: fc_phone_tclSMConferenceCall::vHandleEventInAudioAcquisitionOnRestoreConferenceSMCallInstance1"));
   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
      {
         ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_PHONE_REQUEST_OK"));
         if (m_poCallInstance)
         {
            m_poCallInstance->m_bUsingVehicleAudio = TRUE;
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
         }

         if (m_poCallInstance2)
         {
            if(m_poCallInstance2->m_bUsingVehicleAudio == FALSE)
            {
               /*When already call is in handset and in Conference, user request for transfer call to vehicle*/
               m_u16State = FC_PHONE_SMCONFERENCECALL_STATE_WAIT_FOR_AUDIOACTIVATION_ON_RESTORECONFERENCESM_CALLINSTANCE2;
               ETG_TRACE_USR2((" State Change:FC_PHONE_SMCONFERENCECALL_STATE_WAIT_FOR_AUDIOACTIVATION_ON_RESTORECONFERENCESM_CALLINSTANCE2"));
               m_poCallInstance2->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
               ETG_TRACE_USR3((" Requesting Audio m_poCallInstance ::AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE "));
               m_poAudioManager->s32GetRequest(m_poCallInstance2->m_u16Id,FC_PHONE_AUDIOCHANNEL_PHONE,vAudioCallBackConfCall);
               break;
            }
         }
         m_u16State = FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED;
         ETG_TRACE_USR2((" State Change:FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED"));
      }
      break;
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK:
      {
         ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK"));
         ETG_TRACE_ERR(("  ERROR :: PHONE CHANNEL IS NOT AQUIRED and not TRANSFERING CALL TO HANDSET  currently"));
         if (m_poCallInstance)
         {
            m_poCallInstance->m_bUsingVehicleAudio = FALSE;
            ETG_TRACE_USR3((" UsingVehicleAudio = FALSE"));
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
         }
         //TODO TransferAudio from Handsfree to Handset,conference call and active call in handset cannot handle
      }
      break;
      default:
      {
         ETG_TRACE_USR4((" fc_phone_tclSMConferenceCall::vHandleEventInAudioAcquisitionOnRestoreConferenceSMCallInstance1"
               " DEFAULT : Wrong Event ID u16EventId: %d",u16EventId));
      }
      break;
   }
   ETG_TRACE_USR4((" EXIT: fc_phone_tclSMConferenceCall::vHandleEventInConferenceCall"));
}
/*******************************************************************************
 *
 * FUNCTION: vHandleEventInAudioAcquisitionOnRestoreConferenceSMCallInstance1
 *
 * DESCRIPTION: Call is in conference in handset(walked in with conference->assuming active call in handset
  m/s is running) and transferring to vehicle
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/

tVoid fc_phone_tclSMConferenceCall::vHandleEventInAudioAcquisitionOnRestoreConferenceSMCallInstance2(tU16 u16EventId)
{
   ETG_TRACE_USR4((" ENTER: fc_phone_tclSMConferenceCall::vHandleEventInAudioAcquisitionOnRestoreConferenceSMCallInstance2"));
   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
      {
         ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_PHONE_REQUEST_OK"));
         if (m_poCallInstance2)
         {
            m_poCallInstance2->m_bUsingVehicleAudio = TRUE;
            ETG_TRACE_USR3((" UsingVehicleAudio = TRUE"));
            m_poCallInstance2->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
            ETG_TRACE_USR3((" AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE"));
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance2);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance2);
         }
         m_u16State = FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED;
         ETG_TRACE_USR2((" State Change:FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED"));
      }
      break;
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK:
      {
         ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK"));
         ETG_TRACE_ERR(("  ERROR :: PHONE CHANNEL IS NOT AQUIRED and not TRANSFERING CALL TO HANDSET  currently"));
         if (m_poCallInstance2)
         {
            m_poCallInstance2->m_bUsingVehicleAudio = FALSE;
            ETG_TRACE_USR3((" UsingVehicleAudio = FALSE"));
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance2);
         }
         //TODO TransferAudio from Handsfree to Handset,conference call and active call in handset cannot handle
      }
      break;
      default:
      {
         ETG_TRACE_USR4((" fc_phone_tclSMConferenceCall::vHandleEventInAudioAcquisitionOnRestoreConferenceSMCallInstance2"
               " DEFAULT : Wrong Event ID u16EventId: %d",u16EventId));
      }
      break;
   }
   ETG_TRACE_USR4((" EXIT: fc_phone_tclSMConferenceCall::vHandleEventInConferenceCall"));
}
/*******************************************************************************
 *
 * FUNCTION: vHandleEventInConferenceCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/

tVoid fc_phone_tclSMConferenceCall::vHandleEventInConferenceCall(tU16 u16EventId)
{
   ETG_TRACE_USR4((" ENTER: fc_phone_tclSMConferenceCall::vHandleEventInConferenceCall"));

   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_DBUS_CONFCALL_ACK_OK :
      {
         ETG_TRACE_USR3((" EVENT :: FC_PHONE_SM_EVENT_DBUS_CONFCALL_ACK_OK"));

         m_u16State = FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED ;
         ETG_TRACE_USR2((" State Change:FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED"));

         //update status
         if(m_poCallInstance)
         {
            m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_CONFCALL,m_poCallInstance);
         }

      }
      break;

      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMConferenceCall::vHandleEventInConferenceCall DEFAULT "));
      }


      break;
   }

   ETG_TRACE_USR4((" EXIT: fc_phone_tclSMConferenceCall::vHandleEventInConferenceCall"));
}

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMConferenceCall::vNewCallStatus
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMConferenceCall::vNewCallStatus(const T_CallData* const prCallData, tU16 u16_callInstance)
{
   ETG_TRACE_USR4((" ENTER: fc_phone_tclSMConferenceCall::vNewCallStatus"));

   fc_phone_tclCallInstance* poCallInstance_current = NULLPTR;

   if (m_poCallInstance)
   {
      if (m_poCallInstance->m_u16Id == u16_callInstance)
      {
         poCallInstance_current = m_poCallInstance;
      }
   }

   if (m_poCallInstance2)
   {
      if (m_poCallInstance2->m_u16Id == u16_callInstance)
      {
         poCallInstance_current = m_poCallInstance2;
      }
   }

   NULL_CHECK(poCallInstance_current)

      if(TRUE == m_bHangUpMethodStart)
      {
         ETG_TRACE_USR4(("m_releaseCallInstanceID %d ",m_releaseCallInstanceID));
         if(m_releaseCallInstanceID == u16_callInstance)
         {
            if(PHONE_CALLSTATE_IDLE != prCallData->rCallStatus.u8CallState)
            {
               poCallInstance_current->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_HANGUP,poCallInstance_current);
               ETG_TRACE_USR4((" Set m_bHangUpMethodStart to FALSE"));

            }
            else
            {
               poCallInstance_current->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_HANGUP,poCallInstance_current);
            }
            m_bHangUpMethodStart = FALSE;
         }
         else
         {
            ETG_TRACE_USR4(("Call status update received for Active call Instance"));
         }
      }
      else if(TRUE == m_bHangUpAllMethodStart)
      {
         if(PHONE_CALLSTATE_IDLE != prCallData->rCallStatus.u8CallState)
         {
            poCallInstance_current->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_HANGUP,poCallInstance_current);
            ETG_TRACE_USR4((" Set m_bHangUpMethodStart to FALSE"));

         }
         else
         {
            poCallInstance_current->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_HANGUP,poCallInstance_current);
         }
         m_bHangUpAllMethodStart = FALSE;
      }

      /* Send Call status notification and act on Call Status accordingly */
      switch (m_u16State)
      {
      case FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED:
         {
            ETG_TRACE_USR2((" vNewCallStatus - FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED"));

            if ((PHONE_CALLSTATE_IDLE == prCallData->rCallStatus.u8CallState) && (0 == prCallData->rCallStatus.u8CallTotal))
            {
#ifdef PHONE_WAITINGMODE
               fc_phone_tclWaitingMode* poWaitingMode = fc_phone_tclWaitingMode::poGetInstance();
               tenFC_Phone_WaitingModeState enWaitingModeState = poWaitingMode->enGetWaitingModeState();

               //Both calls/single call came to an end during waiting mode
               if (FC_PHONE_WAITINGMODE_IDLE != enWaitingModeState)
               {
                  poWaitingMode->bProcessEvent(FC_PHONE_WAITING_MODE_EVENT_END_OF_ACTIVE_CALLS);
               }
#endif

               ETG_TRACE_USR4((" vNewCallStatus:: Call vStartIdleAndSMFinished"));

               vStartIdleAndSMFinished();
            }
			//if a single call in conference is disconnected in case of more than 2 calls in phone device restore SM
            else if ((PHONE_CALLSTATE_IDLE == prCallData->rCallStatus.u8CallState) /*&& ((FC_PHONE_MAX_CALLINSTANCES-1) == prCallData->rCallStatus.u8CallTotal)*/)
            {
               ETG_TRACE_USR4((" vNewCallStatus:: Call vStarIdleAndRestoreSM"));
               vStartIdleAndRestoreSM(poCallInstance_current);
            }
            else if (((FC_PHONE_CALLINSTANCE_CALLSTATUS_ACTIVE == poCallInstance_current->m_u16CallStatusNotice)
               &&(PHONE_CALLSTATE_HELD == prCallData->rCallStatus.u8CallState)))
            {
               ETG_TRACE_USR4((" Call status received for split for calls in vehicle - Restore SM"));
               vSendCallStatusSplit(poCallInstance_current, prCallData);
            }
            else if (((FC_PHONE_CALLINSTANCE_CALLSTATUS_CONFERENCE == poCallInstance_current->m_u16CallStatusNotice)
               &&(PHONE_CALLSTATE_HELD == prCallData->rCallStatus.u8CallState)))
            {
               ETG_TRACE_USR4((" Call status received for split for calls in handset - Restore SM"));
               vSendCallStatusSplit(poCallInstance_current, prCallData);
            }
            else
            {
               ETG_TRACE_USR4((" vNewCallStatus:: Send Status"));
               vCopyCallData(prCallData,poCallInstance_current);

               if (m_isConfFromHmiCallInHandset)
               {
                  // Call status is due to merge from hmi when calls are in handset
                  // So send call status as conference
                  vSetCallStatusConference();
               }

               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, poCallInstance_current);
            }
         }
         break;

      default:
         {
            ETG_TRACE_USR4((" vNewCallStatus - default case"));

            if (PHONE_CALLSTATE_IDLE == prCallData->rCallStatus.u8CallState)
            {
               ETG_TRACE_USR2((" vNewCallStatus - PHONE_CALLSTATE_IDLE"));
               if((poCallInstance_current) && (FC_PHONE_CALLINSTANCE_CALLSTATUS_IDLE !=  poCallInstance_current->m_u16CallStatusNotice))
               {
                  ETG_TRACE_USR4((" vNewCallStatus:: Call vStarIdleAndRestoreSM"));
                  vStartIdleAndRestoreSM(poCallInstance_current);
               }
            }
            else
            {
               ETG_TRACE_USR4((" vNewCallStatus:: Send Status"));
               vCopyCallData(prCallData,poCallInstance_current);

               if (m_isConfFromHmiCallInHandset)
               {
                  // Call status is due to merge from hmi when calls are in handset
                  // So send call status as conference
                  vSetCallStatusConference();
               }

               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, poCallInstance_current);
            }
         }
         break;
      }


      ETG_TRACE_USR4((" EXIT: fc_phone_tclSMConferenceCall::vNewCallStatus"));
}


/*******************************************************************************
 *
 * FUNCTION: vTimerCallBack
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMConferenceCall::vTimerCallBack(tU16 u16TimerId)
{
   ETG_TRACE_USR4((" ENTER: fc_phone_tclSMConferenceCall::vTimerCallBack u16TimerId = %d",u16TimerId));

   if(u16TimerId == FC_PHONE_CALLINSTANCE_TIMER_ID)
   {
      if (m_poCallInstance)
      {
         vIncrementTimer(m_poCallInstance);
      }
      if (m_poCallInstance2)
      {
         vIncrementTimer(m_poCallInstance2);
      }

      ETG_TRACE_USR4(("fc_phone_tclSMConferenceCall Sending callstatus"));
      m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, m_poCallInstance);
   }
   else
   {
      ETG_TRACE_USR4(("Invalid timerID(Not CallInstance)"));
   }
}

/*******************************************************************************
 *
 * FUNCTION: vAudioCallBack
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMConferenceCall::vAudioCallBack(tU16 u16AudioChannelId, tU16 u16RequestState)
{
   ETG_TRACE_USR4((" ENTER: fc_phone_tclSMConferenceCall::vAudioCallBack"));

   switch (u16AudioChannelId)
   {
      case FC_PHONE_AUDIOCHANNEL_ALERTTONE:
      {
         ETG_TRACE_USR3((" u16AudioChannelId::FC_PHONE_AUDIOCHANNEL_ALERTTONE"));
         if (FC_PHONE_AUDIOCHANNEL_GRANTED == u16RequestState)
         {
            ETG_TRACE_USR3((" u16RequestState::FC_PHONE_AUDIOCHANNEL_GRANTED"));
            bProcessEvent(FC_PHONE_SM_EVENT_ALERT_REQUEST_OK);

         }
         else
         {
            ETG_TRACE_USR3((" u16RequestState::FC_PHONE_AUDIOCHANNEL_DENIED_SUSPENDED"));
            bProcessEvent(FC_PHONE_SM_EVENT_ALERT_REQUEST_NOK);
         }
      }
      break;

      case FC_PHONE_AUDIOCHANNEL_PHONE :
      {
         ETG_TRACE_USR3((" u16AudioChannelId::FC_PHONE_AUDIOCHANNEL_PHONE"));
         if (FC_PHONE_AUDIOCHANNEL_GRANTED == u16RequestState)
         {
            ETG_TRACE_USR3((" u16RequestState::FC_PHONE_AUDIOCHANNEL_GRANTED"));
            bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);

         }
         else
         {
            ETG_TRACE_USR3((" u16RequestState::FC_PHONE_AUDIOCHANNEL_DENIED_SUSPENDED"));
            bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK);
         }
      }
      break;
      default:
      {
         ETG_TRACE_USR4((" fc_phone_tclSMConferenceCall::vAudioCallBack: DEFAULT "));
      }
      break;
   }

   ETG_TRACE_USR4((" EXIT: fc_phone_tclSMConferenceCall::vAudioCallBack"));
}

/*******************************************************************************
 *
 * FUNCTION: vHandleEventInCallRouted
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMConferenceCall::vHandleEventInCallRouted(tU16 u16EventId)
{
   ETG_TRACE_USR4((" ENTER: fc_phone_tclSMConferenceCall::vHandleEventInCallRouted "));

   tU8 u8SCOConnectionStatus = FC_PHONE_DBUS_SCO_CONN_FAILED;
   fc_phone_tclClientHandler_BTSettings *p_clientHndler_bluetooth = (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerBTSettings;

   if(m_poCallInstance)
      u8SCOConnectionStatus = p_clientHndler_bluetooth->vGetSCOConnectionStatus(const_cast<tChar *> (fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId))); //CMG3G-4847 - To solve Lint
   else if(m_poCallInstance2)
      u8SCOConnectionStatus = p_clientHndler_bluetooth->vGetSCOConnectionStatus(const_cast<tChar *> (fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance2->m_u8BDAddressId))); //CMG3G-4847 - To solve Lint

   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_DBUS_CONFCALL_ACK_OK :
      {
         ETG_TRACE_USR3((" EVENT :: FC_PHONE_SM_EVENT_DBUS_CONFCALL_ACK_OK"));

         //update status
         if(m_poCallInstance)
         {
            m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_CONFCALL,m_poCallInstance);
         }
      }
      break;

      case FC_PHONE_SM_EVENT_DBUS_SPLITCALL_ACK_OK:
      {
         ETG_TRACE_USR3(("  EVENT ::FC_PHONE_SM_EVENT_DBUS_SPLITCALL_ACK_OK "));

         if(m_poCallInstance)
         {
            m_bSplitMethodResultSent = TRUE;
            ETG_TRACE_USR3((" m_bSplitMethodResultSent = TRUE "));
            m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_SPLITCALL, m_poCallInstance);
         }
      }
      break;

      case FC_PHONE_SM_EVENT_SPLITCALL_OK :
      {
         ETG_TRACE_USR3((" FC_PHONE_SM_EVENT_SPLITCALL_OK :; calling dbus split call "));

         tU16 u16DbusCallInstance ;
         //m_u16State = FC_PHONE_CONFERENCECALL_STATE_WAIT_FOR_SPLITCALL;

         ETG_TRACE_USR4((" mm_splitCallInstanceID :: %d",m_splitCallInstanceID));

         fc_phone_tclCallManager *p_callManagerInstance = (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->m_poCallManager ;

         u16DbusCallInstance = p_callManagerInstance->u16GetDbusCallInstanceFromCM(m_splitCallInstanceID);

         ETG_TRACE_USR4((" u16DbusCallInstance :: %d",u16DbusCallInstance));

         if(m_poCallInstance)
         {
            m_pDbusIf->bSplitCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId), (const unsigned char) u16DbusCallInstance);
         }
      }
      break;

      case FC_PHONE_SM_EVENT_HANGUPCALLALL_OK :
      {
         ETG_TRACE_USR3((" FC_PHONE_SM_EVENT_HANGUPCALLALL_OK"));
         m_bEventConsumed = TRUE ;
         m_bHangUpAllMethodStart = TRUE;
         vReleaseAudioHangUp();
      }
      break;

      case FC_PHONE_SM_EVENT_HANGUPCALL_OK :
      {
         ETG_TRACE_USR3((" FC_PHONE_SM_EVENT_HANGUPCALL_OK"));
         m_bEventConsumed = TRUE ;
         m_bHangUpMethodStart = TRUE;
         vReleaseAudioSingleCall();
      }
      break;

      case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
      {
         ETG_TRACE_USR3((" FC_PHONE_SM_EVENT_PHONE_REQUEST_OK"));
         if(m_u16State_while_TransferAudio == FC_PHONE_CONFERENCECALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE1_TRANSFERAUDIOREQUEST_FROMPHONE)
         {
            vHandleAudioReleaseForTransferAudioOfCallInstance1(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
         }
         else if(m_u16State_while_TransferAudio == FC_PHONE_CONFERENCECALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE2_TRANSFERAUDIOREQUEST_FROMPHONE)
         {
            vHandleAudioReleaseForTransferAudioOfCallInstance2(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
         }
         else if(m_u16State_while_TransferAudio == FC_PHONE_CONFERENCECALL_STATE_WAITFOR_AUDIOACQUISITION_ON_TRANSFERAUDIOREQUEST_FROMPHONE) //lint fix
         {
            vHandleAudioAcqusitionOnTransferAudioFromPhone(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
         }
         // Fix for (Bug 161848: Unable to switch from HF mode to HS mode after ACC OFF and ON  in conference call)
         // Vehicle Audio not updated on Bootup with a conference call in BT-Connected Phone.
         // The event "FC_PHONE_SM_EVENT_PHONE_REQUEST_OK" should not get missed out of all the above if statements
         // during Bootup with a conference call in BT-Connected Phone.
         else
         {
            if (m_poCallInstance && m_poCallInstance2)
            {
               if(FC_PHONE_AUDIOCHANNEL_PHONE == m_poCallInstance->m_u8AudioChannel && \
                     FC_PHONE_AUDIOCHANNEL_PHONE == m_poCallInstance2->m_u8AudioChannel)
               {
                  m_poCallInstance->m_bUsingVehicleAudio = m_poCallInstance2->m_bUsingVehicleAudio = true;
               }
               else
               {
                  m_poCallInstance->m_bUsingVehicleAudio = m_poCallInstance2->m_bUsingVehicleAudio = false;
               }
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
            }
            else
            {
               ETG_TRACE_USR2((" m_poCallInstance or m_poCallInstance2 is NULL. This else should not get executed in Conf call scenario "));
            }
         }
      }
      break;

      case FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK:
      {
         ETG_TRACE_USR3((" EVENT: FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK"));
         if(m_u16State_while_TransferAudio == FC_PHONE_CONFERENCECALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE1_TRANSFERAUDIOREQUEST_FROMPHONE)
         {
            vHandleAudioReleaseForTransferAudioOfCallInstance1(FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK);
         }
         else if(m_u16State_while_TransferAudio == FC_PHONE_CONFERENCECALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE2_TRANSFERAUDIOREQUEST_FROMPHONE)
         {
            vHandleAudioReleaseForTransferAudioOfCallInstance2(FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK);
         }
         //TODO:
         // Fix for (Bug 161848: Unable to switch from HF mode to HS mode after ACC OFF and ON  in conference call)
         // Vehicle Audio not updated on Bootup with a conference call in BT-Connected Phone.
         // The event "FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK" should not get missed out of all the above if statements
         // during Bootup with a conference call in BT-Connected Phone.
      }
      break;

      case FC_PHONE_SM_EVENT_TRANSFERCALLVEHICLE_REQUEST_OK:
      {
         ETG_TRACE_USR3(("EVENT: FC_PHONE_SM_EVENT_TRANSFERCALLVEHICLE_REQUEST_OK. "));
         m_bEventConsumed = TRUE;
         m_u8CallTransferDirection = FC_PHONE_CALLTRANSFER_FROMHANDSET_TOHANSFREE;
         if(m_poCallInstance)
         {
            if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_DISCONNECTED)
            {
               ETG_TRACE_USR3(("FC_PHONE_DBUS_SCO_CONN_DISCONNECTED. "));
               m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId),FC_PHONE_CALLTRANSFER_FROMHANDSET_TOHANSFREE);
            }
            // GMMY15-813 Cannot switch call to handsfree from radio if incoming call answered from Bluetooth phone
            else if (u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_STATUS_UNKNOWN)
            {
               ETG_TRACE_USR3(("FC_PHONE_DBUS_SCO_CONN_STATUS_UNKNOWN. "));
               m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId),FC_PHONE_CALLTRANSFER_FROMHANDSET_TOHANSFREE);
            }
            else
            {
               //Method error for transfer call to Vehicle
               m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSFREE,m_poCallInstance);
            }
         }
         else if(m_poCallInstance2)
         {
            if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_DISCONNECTED)
            {
               ETG_TRACE_USR3(("FC_PHONE_DBUS_SCO_CONN_DISCONNECTED. "));
               m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance2->m_u8BDAddressId),FC_PHONE_CALLTRANSFER_FROMHANDSET_TOHANSFREE);
            }
            // GMMY15-813 Cannot switch call to handsfree from radio if incoming call answered from Bluetooth phone
            else if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_STATUS_UNKNOWN)
            {
               ETG_TRACE_USR3(("FC_PHONE_DBUS_SCO_CONN_STATUS_UNKNOWN. "));
               m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance2->m_u8BDAddressId),FC_PHONE_CALLTRANSFER_FROMHANDSET_TOHANSFREE);
            }
            else
            {
               //Method error for transfer call to Vehicle
               m_poCallInstance2->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSFREE,m_poCallInstance2);
            }
         }
      }
      break;

      case FC_PHONE_SM_EVENT_TRANSFERCALLHANDSET_REQUEST_OK:
      {
         ETG_TRACE_USR3(("EVENT: FC_PHONE_SM_EVENT_TRANSFERCALLHANDSET_REQUEST_OK. "));
         m_bEventConsumed = TRUE;
         m_u8CallTransferDirection = FC_PHONE_CALLTRANSFER_FROMHANSFREE_TOHANDSET;
         if(m_poCallInstance)
         {
            if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_ESTABLISHED)
            {
               ETG_TRACE_USR3(("FC_PHONE_DBUS_SCO_CONN_ESTABLISHED"));
               m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId),FC_PHONE_CALLTRANSFER_FROMHANSFREE_TOHANDSET);
            }
            // GMMY15-813 Cannot switch call to handsfree from radio if incoming call answered from Bluetooth phone
            else if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_STATUS_UNKNOWN)
            {
               ETG_TRACE_USR3(("FC_PHONE_DBUS_SCO_CONN_STATUS_UNKNOWN"));
               m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId),FC_PHONE_CALLTRANSFER_FROMHANSFREE_TOHANDSET);
            }
            else
            {
               //Method error for transfer call to handset
               m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSET,m_poCallInstance);
            }
         }
         else if(m_poCallInstance2)
         {
            if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_ESTABLISHED)
            {
               ETG_TRACE_USR3(("FC_PHONE_DBUS_SCO_CONN_ESTABLISHED"));
               m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance2->m_u8BDAddressId),FC_PHONE_CALLTRANSFER_FROMHANSFREE_TOHANDSET);
            }
            // GMMY15-813 Cannot switch call to handsfree from radio if incoming call answered from Bluetooth phone
            else if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_STATUS_UNKNOWN)
            {
               ETG_TRACE_USR3(("FC_PHONE_DBUS_SCO_CONN_STATUS_UNKNOWN"));
               m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance2->m_u8BDAddressId),FC_PHONE_CALLTRANSFER_FROMHANSFREE_TOHANDSET);
            }
            else
            {
               //Method error for transfer call to handset
               m_poCallInstance2->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSET,m_poCallInstance2);
            }
         }
      }
      break;

      case FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK :
      {
         ETG_TRACE_USR3((" EVENT: FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK"));
         if(m_u8CallTransferDirection == FC_PHONE_CALLTRANSFER_FROMHANDSET_TOHANSFREE)
         {
            vHandleTransferCallToVehicle();
            m_u8CallTransferDirection = FC_PHONE_CALLTRANSFER_DIRECTION_UNKNOWN;
         }
         else if(m_u8CallTransferDirection == FC_PHONE_CALLTRANSFER_FROMHANSFREE_TOHANDSET)
         {
            vHandleTransferCallToHandset();
            m_u8CallTransferDirection = FC_PHONE_CALLTRANSFER_DIRECTION_UNKNOWN;
         }
      }
      break;

      case FC_PHONE_SM_EVENT_SENDDTMF:
      {
         ETG_TRACE_USR3(("  EVENT ::FC_PHONE_SM_EVENT_SENDDTMF "));
         if(0 == u16_oneTimeDTMFCalculation)
         {
            u16_oneTimeDTMFCalculation = 1;
            if (m_poCallInstance)
            {
               m_u16DTMFCharLength  = static_cast<tU16>(OSAL_u32StringLength(m_poCallInstance->DTMFChar));
            }
            else if (m_poCallInstance2)
            {
               m_u16DTMFCharLength  = static_cast<tU16>(OSAL_u32StringLength(m_poCallInstance2->DTMFChar));
            }

            m_u16SentDtmfCounter  = 0;
            (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vSetDtmfStatus(TRUE);
            ETG_TRACE_USR4(("  m_u16DTMFCharLength :: %d ",m_u16DTMFCharLength));
         }

         if (m_poCallInstance)
         {
            tU8 u8DtmfValue = (tU8)m_poCallInstance->DTMFChar[m_u16SentDtmfCounter];
            m_pDbusIf->bSendDTMF(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId),u8DtmfValue);
         }
         else if (m_poCallInstance2)
         {
            tU8 u8DtmfValue = (tU8)m_poCallInstance2->DTMFChar[m_u16SentDtmfCounter];
            m_pDbusIf->bSendDTMF(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance2->m_u8BDAddressId),u8DtmfValue);
         }
      }
      break;

      case FC_PHONE_SM_EVENT_DBUS_DTMF_ACK_OK:
      {
         ETG_TRACE_USR3(("  EVENT ::FC_PHONE_SM_EVENT_DBUS_DTMF_ACK_OK "));

         //Update Method Status
         m_u16SentDtmfCounter++;

         if(m_u16SentDtmfCounter == m_u16DTMFCharLength)
         {
            ETG_TRACE_USR4(("  SENDING DTMF SUCCESS ,sending MR to client"));
            u16_oneTimeDTMFCalculation = 0;
            m_u16SentDtmfCounter  = 0;
            m_u16DTMFCharLength   = 0;
            if (m_poCallInstance)
            {
               m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_PLAYDTMF,m_poCallInstance);
            }
            else if (m_poCallInstance2)
            {
               m_poCallInstance2->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_PLAYDTMF,m_poCallInstance2);
            }

            (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vSetDtmfStatus(FALSE);
         }
         else
         {
            ETG_TRACE_USR4((" Previous DTMF sent, processing for next  "));
            bProcessEvent(FC_PHONE_SM_EVENT_SENDDTMF);
         }
      }
      break;

      case FC_PHONE_SM_EVENT_SWAPCALL_OK :
      {
         ETG_TRACE_USR3((" EVENT: FC_PHONE_SM_EVENT_SWAPCALL_OK :; calling dbus swapcall "));
         m_bEventConsumed = TRUE ;
         if (m_poCallInstance)
         {
            m_pDbusIf->bSwapCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId));
         }
      }
      break ;

      case FC_PHONE_SM_EVENT_DBUS_SWAPCALL_ACK_OK :
      {
         ETG_TRACE_USR3(("  EVENT: FC_PHONE_SM_EVENT_DBUS_SWAPCALL_ACK_OK"));
         if (m_poCallInstance)
         {
            m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_SWAPCALL,m_poCallInstance);
         }
      }
      break;

      //FIX GMMY15-8315 [CT]Cannot place conference call on hold
      //Hold request was not handled in this state machine, hence conference call was not possible to be put on hold.
      //Event Hold will be handled here and we send request to DBus for Holding the conference call.
      case FC_PHONE_SM_EVENT_HOLDCALL_REQUEST :
      {
         ETG_TRACE_USR3(("  EVENT: FC_PHONE_SM_EVENT_HOLDCALL_REQUEST"));
         m_u16State = FC_PHONE_SMCONFERENCECALL_STATE_WAIT_FOR_HOLDCALL_ACK;
         ETG_TRACE_USR2(("State change: FC_PHONE_SMCONFERENCECALL_STATE_WAIT_FOR_HOLDCALL_ACK"));
         if (m_poCallInstance)
            m_pDbusIf->bHoldCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId));
      }
      break;

      //Event Resume will be handled here and we send request to DBus for Resuming the conference call.
      case FC_PHONE_SM_EVENT_RESUMECALL_REQUEST:
      {
         ETG_TRACE_USR3(("  EVENT ::FC_PHONE_SM_EVENT_RESUMECALL_REQUEST "));
         /* Forward Resume Request to DBus */
         m_u16State = FC_PHONE_SMCONFERENCECALL_STATE_WAIT_FOR_RESUMECALL_ACK;
         ETG_TRACE_USR2((" State Change: FC_PHONE_SMCONFERENCECALL_STATE_WAIT_FOR_RESUMECALL_ACK  "));
         if (m_poCallInstance)
            m_pDbusIf->bResumeCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId));
      }
      break;
      //End of fix

#ifdef PHONE_WAITINGMODE
      case FC_PHONE_SM_EVENT_START_WAITING_MODE:
      {
         ETG_TRACE_USR3((" EVENT:: FC_PHONE_SM_EVENT_START_WAITING_MODE "));

         m_bEventConsumed = TRUE;

         if (FALSE ==
               ((fc_phone_tclApp::m_poMainAppInstance)->m_poPhoneAudioRouting->vTriggerPhoneAudioAllocation(
                     FC_PHONE_AUDIOCHANNEL_PHONEWAIT)))
         {
            ETG_TRACE_ERR(("Audio Route request posting failed!"));

            fc_phone_tclWaitingMode* poWaitingMode = fc_phone_tclWaitingMode::poGetInstance();
            poWaitingMode->bProcessEvent(FC_PHONE_WAITING_MODE_EVENT_PHONEWAIT_SRC_ROUTING_FAILED);
         }
      }
      break;
#endif

      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMConferenceCall::vHandleEventInCallRouted Default. "));
         m_bEventConsumed = FALSE ;
      }
      break;
   }

   ETG_TRACE_USR4((" EXIT: fc_phone_tclSMConferenceCall::vHandleEventInCallRouted "));
}

/*******************************************************************************
 *
 * FUNCTION: vHandleDbusError
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMConferenceCall::vHandleDbusError(tU16 u16DbusAckType,tChar Code)
{
   ETG_TRACE_USR4((" ENTER: fc_phone_tclSMConferenceCall::vHandleDbusError "));

   switch(u16DbusAckType)
   {
      case FC_PHONE_CB_FID_CONFCALL :
      {
         ETG_TRACE_USR4((" ack type is conf call "));
         vAssignErrorCode(Code);
         vHandleConfCallError();
         vRestoreSM();
      }
      break;

      case FC_PHONE_CB_FID_SPLITCALL :
      {
         ETG_TRACE_USR4((" ack type is split call "));
         vAssignErrorCode(Code);
         vHandleSplitCallError();
      }
      break;

      case FC_PHONE_CB_FID_HANGUPCALL :
      {
         ETG_TRACE_USR4((" ack type is hang up call "));
         vAssignErrorCode(Code);
         vHandleHangUpCallError();
      }
      break;

      case FC_PHONE_CB_FID_SWAPCALL:
      {
         ETG_TRACE_USR4(("ack type is swap cal; "));
         vAssignErrorCode(Code);
         if (m_poCallInstance)
         {
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_SWAPCALL,m_poCallInstance);
         }
         m_u16State = FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED;
         ETG_TRACE_USR2((" State Change:FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED"));
      }
      break;

      case FC_PHONE_CB_FID_AUDIOTRANSFER:
      {
         ETG_TRACE_USR4((" FC_PHONE_CB_FID_AUDIOTRANSFER "));
         vAssignErrorCode(Code);
         if(m_u8CallTransferDirection == FC_PHONE_CALLTRANSFER_FROMHANDSET_TOHANSFREE)
         {
            m_u8CallTransferDirection = FC_PHONE_CALLTRANSFER_DIRECTION_UNKNOWN;
            if(m_poCallInstance)
            {
               m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSFREE,m_poCallInstance);
            }
            else if(m_poCallInstance2)
            {
               m_poCallInstance2->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSFREE,m_poCallInstance2);
            }
         }
         else if(m_u8CallTransferDirection == FC_PHONE_CALLTRANSFER_FROMHANSFREE_TOHANDSET)
         {
            m_u8CallTransferDirection = FC_PHONE_CALLTRANSFER_DIRECTION_UNKNOWN;
            if(m_poCallInstance)
            {
               m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSET,m_poCallInstance);
            }
            else if(m_poCallInstance2)
            {
               m_poCallInstance2->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSET,m_poCallInstance2);
            }

         }
         m_u16State = FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED;
         ETG_TRACE_USR2((" State Change:FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED"));
      }
      break;

      case FC_PHONE_CB_FID_SENDDTMF:
      {
         //Targeted to SM hence dont care of States
         ETG_TRACE_USR4((" FC_PHONE_CB_FID_SENDDTMF "));
         vAssignErrorCode(Code);
         (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vSetDtmfStatus(FALSE);
         if(m_poCallInstance)
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_PLAYDTMF,m_poCallInstance);
         else if(m_poCallInstance2)
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_PLAYDTMF,m_poCallInstance2);

         m_u16State = FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED;
         ETG_TRACE_USR2((" State Change:FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED"));
      }
      break;

      //FIX GMMY15-8315 [CT]Cannot place conference call on hold
      //Handling error for Hold and Resume
      case FC_PHONE_CB_FID_HOLDCALL:
      {
         ETG_TRACE_USR4(("FC_PHONE_CB_FID_HOLDCALL"));
         vAssignErrorCode(Code);
         if (m_poCallInstance)
         {
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_HOLDCALL,m_poCallInstance);
         }
         m_u16State = FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED;
         ETG_TRACE_USR2((" State Change:FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED"));
      }
      break;

      case FC_PHONE_CB_FID_RESUMECALL:
      {
         ETG_TRACE_USR4(("FC_PHONE_CB_FID_RESUMECALL"));
         vAssignErrorCode(Code);
         if (m_poCallInstance)
         {
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_RESUMECALL,m_poCallInstance);
         }
         m_u16State = FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED;
         ETG_TRACE_USR2((" State Change:FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED"));
      }
      break;
      //End of fix

      default:
      {
         ETG_TRACE_USR4((" This Event ID is not supported yet"));
      }
      break;
   }

   ETG_TRACE_USR4((" EXIT:fc_phone_tclSMConferenceCall::vHandleDbusError "));
}

/*******************************************************************************
 *
 * FUNCTION: vHandleEventInHoldCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMConferenceCall::vHandleEventInSplitCall(tU16 u16EventId)
{
   ETG_TRACE_USR4((" ENTER: fc_phone_tclSMConferenceCall::vHandleEventInSplitCall "));

   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_DBUS_SPLITCALL_ACK_OK:
      {

         ETG_TRACE_USR3(("  EVENT ::FC_PHONE_SM_EVENT_DBUS_SPLITCALL_ACK_OK "));

         m_u16State = FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED;
         ETG_TRACE_USR2((" State Change:FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED"));
         if(m_poCallInstance)
         {
            m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_SPLITCALL, m_poCallInstance);
         }

         //vRestoreSM();

      }
      break;
      case FC_PHONE_SM_EVENT_HANGUPCALLALL_OK :
      {
         ETG_TRACE_USR3(("EVENT :: FC_PHONE_SM_EVENT_HANGUPCALLALL_OK"));
         m_bEventConsumed = TRUE ;
         m_bHangUpAllMethodStart = TRUE;
         vReleaseAudioHangUp();
      }
      break;
      case FC_PHONE_SM_EVENT_HANGUPCALL_OK :
      {
         ETG_TRACE_USR3((" EVENT ::FC_PHONE_SM_EVENT_HANGUPCALL_OK"));
         m_bEventConsumed = TRUE ;
         m_bHangUpMethodStart = TRUE;
         vReleaseAudioSingleCall();
      }
      break;
      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMConferenceCall::vHandleEventInSplitCall DEFAULT "));
      }

      break;
   }

   ETG_TRACE_USR4((" EXIT: fc_phone_tclSMConferenceCall::vHandleEventInSplitCall "));
}

/*******************************************************************************
 *
 * FUNCTION: vReleaseAudioHangUp
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMConferenceCall::vReleaseAudioHangUp()
{
   ETG_TRACE_USR4((" ENTER: tVoid fc_phone_tclSMConferenceCall::vReleaseAudioHangUp"));

   //Get call instance
   fc_phone_tclCallInstance* poCurrentCallInstance = NULLPTR;
   poCurrentCallInstance = (m_poCallInstance != NULLPTR)? m_poCallInstance : m_poCallInstance2;

   //Forward request to end calls to Dbus
   if(poCurrentCallInstance)
   {
      FCPhoneDbusClient_TerminateType_t enTerminateType = FC_PHONE_DBUS_TERMINATETYPE_SINGLECALL;
      if((fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->bIsAgThreeWayCallSupported())
      {
         enTerminateType = FC_PHONE_DBUS_TERMINATETYPE_ALL;
      }
      ETG_TRACE_USR4((" enTerminateType:: %d",enTerminateType));
      m_pDbusIf->bHangUpCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(poCurrentCallInstance->m_u8BDAddressId),enTerminateType);
   }
   else
   {
      ETG_TRACE_ERR((" ERROR :: m_poCallInstance & m_poCallInstance2 is NULL"));
      return;
   }

   m_u16State = FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED;
   ETG_TRACE_USR2((" State Change:FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED"));

   //Release audio for both call instances
   if(m_poCallInstance)
   {
      if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_poCallInstance->m_u8AudioChannel)
      {
         ETG_TRACE_USR3(("Release audio m_poCallInstance "));
         m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id,m_poCallInstance->m_u8AudioChannel,vAudioCallBackDummy);
         m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
         ETG_TRACE_USR3((" AudioChannel =  FC_PHONE_AUDIOCHANNEL_ID_UNUSED"));
      }

      m_poCallInstance->m_bUsingVehicleAudio = FALSE;
      ETG_TRACE_USR3((" UsingVehicleAudio = FALSE"));
      m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO, m_poCallInstance);

      //Fix for GMNGA-45763 : [Handset] SK changed to [Handsfree] when end a conference call.
      //Send call disconnecting status
      m_poCallInstance->m_u16CallStatusNotice = FC_PHONE_CALLINSTANCE_CALLSTATUS_DISCONNECTING;
      m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
   }

   if(m_poCallInstance2)
   {
      if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_poCallInstance2->m_u8AudioChannel)
      {
         ETG_TRACE_USR3(("Release audio m_poCallInstance2 "));
         m_poAudioManager->s32ReleaseRequest(m_poCallInstance2->m_u16Id,m_poCallInstance2->m_u8AudioChannel,vAudioCallBackDummy);
         m_poCallInstance2->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
         ETG_TRACE_USR3((" AudioChannel =  FC_PHONE_AUDIOCHANNEL_ID_UNUSED"));
      }

      m_poCallInstance2->m_bUsingVehicleAudio = FALSE;
      ETG_TRACE_USR3((" UsingVehicleAudio = FALSE"));
      m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO, m_poCallInstance2);

      //Fix for GMNGA-45763 : [Handset] SK changed to [Handsfree] when end a conference call.
      //Send call disconnecting status
      m_poCallInstance2->m_u16CallStatusNotice = FC_PHONE_CALLINSTANCE_CALLSTATUS_DISCONNECTING;
      m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance2);
   }

   ETG_TRACE_USR4((" EXIT: tVoid fc_phone_tclSMConferenceCall::vReleaseAudioHangUp"));
}

/*******************************************************************************
 *
 * FUNCTION: vReleaseAudioSingleCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/

tVoid fc_phone_tclSMConferenceCall::vReleaseAudioSingleCall()
{
   ETG_TRACE_USR4((" ENTER: tVoid fc_phone_tclSMConferenceCall::vReleaseAudioSingleCall"));

   if (m_pReleaseCallInstance)
   {
      ETG_TRACE_USR4(("Release audio - m_pReleaseCallInstance"));
      m_u16State = FC_PHONE_CONFERENCECALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE;
      ETG_TRACE_USR2((" State Change:FC_PHONE_CONFERENCECALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE"));
      if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_pReleaseCallInstance->m_u8AudioChannel)
      {
         ETG_TRACE_USR3(("Release audiom_poCallInstance "));
         m_poAudioManager->s32ReleaseRequest(m_pReleaseCallInstance->m_u16Id, m_pReleaseCallInstance->m_u8AudioChannel, vAudioCallBackConfCall);
         m_pReleaseCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
         ETG_TRACE_USR3((" AudioChannel =  FC_PHONE_AUDIOCHANNEL_ID_UNUSED"));
      }
      else
      {
         bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
      }
   }
   else
   {
      ETG_TRACE_ERR((" ERROR ::m_pReleaseCallInstance is NULL"));

   }

   ETG_TRACE_USR4((" EXIT: tVoid fc_phone_tclSMConferenceCall::vReleaseAudioSingleCall"));
}


/*******************************************************************************
 *
 * FUNCTION: vHandleAudioReleaseForTransferAudioOfCallInstance1
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMConferenceCall::vHandleAudioReleaseForTransferAudioOfCallInstance1(tU16 u16EventId)
{
   ETG_TRACE_USR4((" ENTER: tVoid fc_phone_tclSMConferenceCall::vHandleAudioReleaseForTransferAudioOfCallInstance1"));

   switch(u16EventId)
   {
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
      {
         ETG_TRACE_USR4((" vHandleAudioReleaseForTransferAudioOfCallInstance1: FC_PHONE_SM_EVENT_PHONE_REQUEST_OK"));
         m_u16State_while_TransferAudio = FC_PHONE_CONFERENCECALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE2_TRANSFERAUDIOREQUEST_FROMPHONE;
         if(m_poCallInstance)
         {
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
            ETG_TRACE_USR3((" AudioChannel =  FC_PHONE_AUDIOCHANNEL_ID_UNUSED"));
            m_poCallInstance->m_bUsingVehicleAudio = FALSE;
            ETG_TRACE_USR3((" UsingVehicleAudio = FALSE"));
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
            m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
         }
         if(m_poCallInstance2)
         {
            ETG_TRACE_USR4((" m_poCallInstance2->m_u8AudioChannel = %d",m_poCallInstance2->m_u8AudioChannel));
            if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_poCallInstance2->m_u8AudioChannel)
            {
               ETG_TRACE_USR3(("Release audio m_poCallInstance2 "));
               m_poAudioManager->s32ReleaseRequest(m_poCallInstance2->m_u16Id,m_poCallInstance2->m_u8AudioChannel,vAudioCallBackConfCall);
               m_poCallInstance2->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
               ETG_TRACE_USR3((" AudioChannel =  FC_PHONE_AUDIOCHANNEL_ID_UNUSED"));
            }
            else
            {
               bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
            }
         }
         else
         {
            ETG_TRACE_USR4(("No call instance is active hence audio is released and transfer call is done"));
            m_u16State = FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED;
            ETG_TRACE_USR2((" State Change:FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED"));
            m_u16State_while_TransferAudio = 0;
         }
         break;
      }
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK:
      {
         ETG_TRACE_USR4((" vHandleAudioReleaseCallInstance1: FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK"));
         if (m_poCallInstance)
         {
            m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId), FC_PHONE_CALLTRANSFER_FROMHANDSET_TOHANSFREE);
            m_poCallInstance->m_bUsingVehicleAudio = TRUE;
            ETG_TRACE_USR3((" UsingVehicleAudio = TRUE"));
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_ACTIVECALLINHANDSET,m_poCallInstance);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
         }
      }
      break;
      case FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK:
      {
         m_u16State_while_TransferAudio = 0;
      }
      break;
      default:
      {
         ETG_TRACE_USR4((" fc_phone_tclSMConferenceCall::vHandleAudioReleaseForTransferAudioOfCallInstance1::default "));
         break;
      }
   }
}
/*******************************************************************************
 *
 * FUNCTION: vHandleAudioReleaseForTransferAudioOfCallInstance2
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMConferenceCall::vHandleAudioReleaseForTransferAudioOfCallInstance2(tU16 u16EventId)
{
   ETG_TRACE_USR4(("ENTER: fc_phone_tclSMConferenceCall::vHandleAudioReleaseForTransferAudioOfCallInstance2"));

   switch(u16EventId)
   {
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
      {
         ETG_TRACE_USR3(("vHandleAudioReleaseForTransferAudioOfCallInstance2: FC_PHONE_SM_EVENT_PHONE_REQUEST_OK"));
         if(m_poCallInstance2)
         {
            m_poCallInstance2->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
            m_poCallInstance2->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
            ETG_TRACE_USR3((" AudioChannel =  FC_PHONE_AUDIOCHANNEL_ID_UNUSED"));
            m_poCallInstance2->m_bUsingVehicleAudio = FALSE;
            ETG_TRACE_USR3((" UsingVehicleAudio = FALSE"));
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance2);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_ACTIVECALLINHANDSET,m_poCallInstance2);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance2);
            m_u16State_while_TransferAudio = 0;
         }
      }
      break;
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK:
      {
         ETG_TRACE_USR3(("vHandleAudioReleaseCallInstance2: FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK"));
         if(m_poCallInstance2)
         {
            m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance2->m_u8BDAddressId), FC_PHONE_CALLTRANSFER_FROMHANDSET_TOHANSFREE);
            m_poCallInstance2->m_bUsingVehicleAudio = TRUE;
            ETG_TRACE_USR3((" UsingVehicleAudio = TRUE"));
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance2);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_ACTIVECALLINHANDSET,m_poCallInstance2);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance2);

         }
      }
      break;
      case FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK"));
         m_u16State_while_TransferAudio = 0;
      }
      break;
      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMConferenceCall::vHandleAudioReleaseForTransferAudioOfCallInstance2 ::DEFAULT"));
         break;
      }
   }
}


/*******************************************************************************
 *
 * FUNCTION: vHandleAudioAcqusitionOnTransferAudioFromPhone
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMConferenceCall::vHandleAudioAcqusitionOnTransferAudioFromPhone(tU16 u16EventId)
{
   ETG_TRACE_USR4((" ENTER: tVoid fc_phone_tclSMConferenceCall::vHandleAudioAcqusitionOnTransferAudioFromPhone"));
   switch(u16EventId)
   {
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
      {
         ETG_TRACE_USR3((" vHandleAudioAcqusitionOnTransferAudioFromPhone: FC_PHONE_SM_EVENT_PHONE_REQUEST_OK"));
         if(m_poCallInstance)
         {
            m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
            ETG_TRACE_USR3((" AudioChannel =  FC_PHONE_AUDIOCHANNEL_PHONE"));
            m_poCallInstance->m_bUsingVehicleAudio = TRUE;
            ETG_TRACE_USR3((" UsingVehicleAudio = TRUE"));
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_ACTIVECALLINHANDSET,m_poCallInstance);
         }
         if(m_poCallInstance2)
         {
            if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED == m_poCallInstance2->m_u8AudioChannel)
            {
               m_poCallInstance2->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
               ETG_TRACE_USR3((" Requesting Audio m_poCallInstance ::AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE "));
               m_poAudioManager->s32GetRequest(m_poCallInstance2->m_u16Id,FC_PHONE_AUDIOCHANNEL_PHONE,vAudioCallBackConfCall);
            }
            m_poCallInstance2->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
            m_poCallInstance2->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
            ETG_TRACE_USR3((" AudioChannel =  FC_PHONE_AUDIOCHANNEL_PHONE"));
            m_poCallInstance2->m_bUsingVehicleAudio = TRUE;
            ETG_TRACE_USR3((" UsingVehicleAudio = TRUE"));
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance2);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_ACTIVECALLINHANDSET,m_poCallInstance2);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance2);
         }
         else
         {
            m_u16State = FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED;
            ETG_TRACE_USR2((" State Change:FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED"));
            m_u16State_while_TransferAudio = 0;
         }
         break;
      }
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK:
      {
         ETG_TRACE_USR3((" vHandleAudioReleaseCallInstance1: FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK"));
         if (m_poCallInstance)
         {
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
            ETG_TRACE_USR3((" AudioChannel =   FC_PHONE_AUDIOCHANNEL_ID_UNUSED"));
            m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId),FC_PHONE_CALLTRANSFER_FROMHANSFREE_TOHANDSET);
            m_poCallInstance->m_bUsingVehicleAudio = TRUE;
            ETG_TRACE_USR3((" UsingVehicleAudio = TRUE"));
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_ACTIVECALLINHANDSET,m_poCallInstance);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
         }
         if(m_poCallInstance2)
         {
            m_poCallInstance2->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
            ETG_TRACE_USR3((" AudioChannel =   FC_PHONE_AUDIOCHANNEL_ID_UNUSED"));
            m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance2->m_u8BDAddressId), FC_PHONE_CALLTRANSFER_FROMHANSFREE_TOHANDSET);
            m_poCallInstance2->m_bUsingVehicleAudio = TRUE;
            ETG_TRACE_USR3((" UsingVehicleAudio = TRUE"));
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance2);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_ACTIVECALLINHANDSET,m_poCallInstance2);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance2);
         }
      }
      break;
      case FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK:
      {
         m_u16State_while_TransferAudio = 0;
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK"));
      }
      break;
      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMConferenceCall::vHandleAudioAcqusitionOnTransferAudioFromPhone DEFAULT "));
         break;
      }
   }
}
/*******************************************************************************
 *
 * FUNCTION: vHandleAudioReleaseCallInstance
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMConferenceCall::vHandleAudioReleaseCallInstance(tU16 u16EventId)
{
   ETG_TRACE_USR4(("ENTER: fc_phone_tclSMConferenceCall::vHandleAudioReleaseCallInstance"));

   switch(u16EventId)
   {
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
      {
         ETG_TRACE_USR3(("vHandleAudioReleaseCallInstance: FC_PHONE_SM_EVENT_PHONE_REQUEST_OK"));
         m_u16State = FC_PHONE_CONFERENCECALL_STATE_HANGUPSINGLE;
         ETG_TRACE_USR2((" State Change:FC_PHONE_CONFERENCECALL_STATE_HANGUPSINGLE"));

         if (m_pReleaseCallInstance)
         {
            m_pReleaseCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
            ETG_TRACE_USR3((" AudioChannel =   FC_PHONE_AUDIOCHANNEL_ID_UNUSED"));
            m_pReleaseCallInstance->m_bUsingVehicleAudio = FALSE;
            ETG_TRACE_USR3((" UsingVehicleAudio = FALSE"));
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_pReleaseCallInstance);
            //Sending processEvent for SM continuity
            bProcessEvent(FC_PHONE_SM_EVENT_SINGLE_CALL_HANGUP);
         }
         else
         {
            ETG_TRACE_ERR(("ERROR :: m_pReleaseCallInstance is NULL "));
         }


         break;
      }
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK:
      {
         ETG_TRACE_USR3(("vHandleAudioReleaseCallInstance: FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK"));

         break;
      }
      default:
      {
         ETG_TRACE_USR4((" fc_phone_tclSMConferenceCall::vHandleAudioReleaseCallInstance:: DEFAULT"));
         break;
      }
   }

   ETG_TRACE_USR4(("EXIT: fc_phone_tclSMConferenceCall::vHandleAudioReleaseCallInstance"));
}
/*******************************************************************************
 *
 * FUNCTION: vHandleEventHangUpSingleCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMConferenceCall::vHandleEventHangUpSingleCall(tU16 u16EventId)
{
   ETG_TRACE_USR4((" ENTER: fc_phone_tclSMConferenceCall::vHandleEventHangUpSingleCall"));

   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_SINGLE_CALL_HANGUP:
      {
         ETG_TRACE_USR3((" vHandleEventHangUpSingleCall: FC_PHONE_SM_EVENT_SINGLE_CALL_HANGUP"));
         m_u16State = FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED;
         ETG_TRACE_USR2((" State Change:FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED"));
         ETG_TRACE_USR4((" m_releaseCallInstanceID :: %d",m_releaseCallInstanceID));
         if (m_pReleaseCallInstance)
         {
#ifndef BLUETOOTH_DISABLE_ENHANCED_CALL_CTRL // Disabled enhanced call control in BT_Stack
            //GMMY15-9890 To cancel the second outgoing call using HfReleaseSpecCall when ENDTARGETCALL is supported by the device
            if(((fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->getAgThreeWayCallSuppFeatures()) & FC_PHONE_ENHANCECALLCTRL_ENDTARGETCALL_MASK)
            {
               fc_phone_tclCallManager *p_callManagerInstance = (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->m_poCallManager ;
               if(p_callManagerInstance)
               {
                  tU16 u16DbusCallInstance = p_callManagerInstance->u16GetDbusCallInstanceFromCM(m_releaseCallInstanceID);
                  ETG_TRACE_USR4((" u16DbusCallInstance :: %d",u16DbusCallInstance));
                  m_pDbusIf->bReleaseSpecCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_pReleaseCallInstance->m_u8BDAddressId), FC_PHONE_DBUS_TERMINATETYPE_THREEWAYCALL_SPECIFIC, (const unsigned char) u16DbusCallInstance);
               }
               else
               {
                  ETG_TRACE_USR2((" Invalid p_callManagerInstance"));
               }
               break;
            }
#endif
            //cannot end individual call -MULTIPLECALL_INACTIVE , MULTIPLECALL_ACTIVE as terminate type yeilds the same. 
            //Here SM would be in conference only if both CS are Active /hold.
            ETG_TRACE_USR2(("Terminate single call not supported in Phone device so terminate all call"));
            m_pDbusIf->bHangUpCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_pReleaseCallInstance->m_u8BDAddressId),FC_PHONE_DBUS_TERMINATETYPE_ALL);
         }
         else
         {
            ETG_TRACE_USR2((" Invalid m_pReleaseCallInstance"));
         }
      }
      break;

   default:
      {
         ETG_TRACE_USR4((" fc_phone_tclSMConferenceCall::vHandleEventHangUpSingleCall:: DEFAULT"));
      }
      break;
   }

   ETG_TRACE_USR4((" EXIT: fc_phone_tclSMConferenceCall::vHandleEventHangUpSingleCall"));
}
/*******************************************************************************
 *
 * FUNCTION: vProcessOnDynamicDisconnect
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMConferenceCall::vProcessOnDynamicDisconnect(tU16 u16EventId)
{
   ETG_TRACE_USR4((" ENTER: fc_phone_tclSMConferenceCall::vProcessOnDynamicDisconnect"));

   //release Audio channels
   switch(u16EventId)
   {
      case FC_PHONE_SM_EVENT_SLC_OFF:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_SLC_OFF"));

         m_SlcOff = TRUE;
         if(m_poCallInstance)
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_SLC,m_poCallInstance);
         if(m_poCallInstance2)
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_SLC,m_poCallInstance2);
         vStartIdleAndSMFinished();
      }
      break;
      default:
      {
         ETG_TRACE_USR4(("IN DEFAULT : vProcessOnDynamicDisconnect: wrong u16EventId= %d ",u16EventId));
      }
      break;
   }
   ETG_TRACE_USR4((" EXIT: fc_phone_tclSMConferenceCall::vProcessOnDynamicDisconnect"));
}

/*******************************************************************************
 *
 * FUNCTION: vStarIdleAndRestoreSM
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMConferenceCall::vStartIdleAndRestoreSM(fc_phone_tclCallInstance*& rfpCallInstance)
{
   ETG_TRACE_USR4(("ENTER: fc_phone_tclSMConferenceCall::vStartIdleAndRestoreSM"));

   fc_phone_tclCallInstance *pCallInstance[FC_PHONE_MAX_CALLINSTANCES] = {NULLPTR};

   if (rfpCallInstance)
   {
      m_poTimer->s32Stop(rfpCallInstance->m_u16TimerId); // Bugfix for GMMY16-17241

      ETG_TRACE_USR4((" Release audio poCallInstance_current - vStartIdleAndRestoreSM"));
      if (FC_PHONE_AUDIOCHANNEL_ID_UNUSED != rfpCallInstance->m_u8AudioChannel)
      {
         ETG_TRACE_USR3(("Release audio "));
         m_poAudioManager->s32ReleaseRequest(rfpCallInstance->m_u16Id, rfpCallInstance->m_u8AudioChannel, vAudioCallBackConfCall);
      }

      rfpCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
      ETG_TRACE_USR3((" AudioChannel =   FC_PHONE_AUDIOCHANNEL_ID_UNUSED"));
      rfpCallInstance->m_bUsingVehicleAudio = FALSE;
      ETG_TRACE_USR3((" UsingVehicleAudio = FALSE"));
      m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO, rfpCallInstance);


      rfpCallInstance->vInit();
      m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, rfpCallInstance);
   }

   if (rfpCallInstance == m_poCallInstance)
   {
      ETG_TRACE_USR4(("m_poCallInstance matches with rfpCallInstance"));
      if (m_poCallInstance2)
      {
         //revert back the callstatus as call is no longer in conference, updated as active as if it was not active SM would already have restored.
         m_poCallInstance2->m_u16CallStatusNotice = FC_PHONE_CALLINSTANCE_CALLSTATUS_ACTIVE;
         pCallInstance[1] = m_poCallInstance2;
      }
      else
      {
         ETG_TRACE_FATAL(("FATAL : m_poCallInstance2 is NULL"));
      }
      pCallInstance[0] = rfpCallInstance;
   }

   if (rfpCallInstance == m_poCallInstance2)
   {
      ETG_TRACE_USR4(("m_poCallInstance2 matches with rfpCallInstance"));
      if (m_poCallInstance)
      {
         //revert back the callstatus as call is no longer in conference, updated as active as if it was not active SM would already have restored.
         m_poCallInstance->m_u16CallStatusNotice = FC_PHONE_CALLINSTANCE_CALLSTATUS_ACTIVE;
         pCallInstance[0] = m_poCallInstance;
      }
      else
      {
         ETG_TRACE_FATAL(("FATAL : m_poCallInstance is NULL"));
      }
      pCallInstance[1] = rfpCallInstance;
   }

   // Reset conf flags
   (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vSetConfSMStatus(FALSE);

   //Revert to corresponding State Machine
   m_poSMManager->vRevertStateMachine(pCallInstance);

   ETG_TRACE_USR4((" EXIT: fc_phone_tclSMConferenceCall::vStartIdleAndRestoreSM"));
}

/*******************************************************************************
 *
 * FUNCTION: vStarIdleAndSMFinished
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMConferenceCall::vStartIdleAndSMFinished()
{
   ETG_TRACE_USR4((" ENTER: fc_phone_tclSMConferenceCall::vStartIdleAndSMFinished"));

   vCancel();

   if (m_poCallInstance)
   {
      (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vSetConfSMStatus(FALSE);

      ETG_TRACE_USR3((" Release audio m_poCallInstance - vStartIdleAndSMFinished"));
      if (FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_poCallInstance->m_u8AudioChannel)
      {
         ETG_TRACE_USR3(("Release audio m_poCallInstance"));
         m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id,m_poCallInstance->m_u8AudioChannel,vAudioCallBackConfCall);
      }
      else
      {
         ETG_TRACE_USR3((" Audio not acquired m_poCallInstance - vStartIdleAndSMFinished"));
      }

      m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
      ETG_TRACE_USR3((" AudioChannel =   FC_PHONE_AUDIOCHANNEL_ID_UNUSED"));
      m_poCallInstance->m_bUsingVehicleAudio = FALSE;
      ETG_TRACE_USR3((" UsingVehicleAudio = FALSE"));
      m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO, m_poCallInstance);


      m_poCallInstance->vInit();
      m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, m_poCallInstance);
   }

   if (m_poCallInstance2)
   {
      if (FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_poCallInstance2->m_u8AudioChannel)
      {
         ETG_TRACE_USR3((" Release audio m_poCallInstance2 - vStartIdleAndSMFinished"));
         m_poAudioManager->s32ReleaseRequest(m_poCallInstance2->m_u16Id,m_poCallInstance2->m_u8AudioChannel,vAudioCallBackConfCall);
      }
      else
      {
         ETG_TRACE_USR3((" Audio not acquired m_poCallInstance2 - vStartIdleAndSMFinished"));
      }

      m_poCallInstance2->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
      ETG_TRACE_USR3((" AudioChannel =   FC_PHONE_AUDIOCHANNEL_ID_UNUSED"));
      m_poCallInstance2->m_bUsingVehicleAudio = FALSE;
      ETG_TRACE_USR3((" UsingVehicleAudio = FALSE"));
      m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO, m_poCallInstance2);


      m_poCallInstance2->vInit();
      m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, m_poCallInstance2);
   }
   // send request terminate alert first for call with maximum duration....
   //	put check if its possible for instance one to have call duration less than instance 2.


   if(m_poCallInstance || m_poCallInstance2 )
   {
      m_SlcOff = FALSE;

      fc_phone_tclCallInstance *pCallInstance[FC_PHONE_MAX_CALLINSTANCES];
      pCallInstance[0] = m_poCallInstance;
      pCallInstance[1] = m_poCallInstance2;
      m_poSMManager->vRevertStateMachine(pCallInstance);

      //        m_poSMManager->vSMFinished(m_poCallInstance->m_u16Id);
   }

   ETG_TRACE_USR4((" EXIT: fc_phone_tclSMConferenceCall::vStartIdleAndSMFinished"));
}


/*******************************************************************************
 *
 * FUNCTION: vProcessAudioSignal
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMConferenceCall::vProcessAudioSignal()
{
   ETG_TRACE_USR4(("fc_phone_tclSMConferenceCall::vProcessAudioSignal "));
   tU8 u8SCOConnectionStatus = FC_PHONE_DBUS_SCO_CONN_FAILED;
   fc_phone_tclClientHandler_BTSettings *p_clientHndler_bluetooth = (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerBTSettings;
   if (m_poCallInstance)
   {
      u8SCOConnectionStatus = p_clientHndler_bluetooth->vGetSCOConnectionStatus(const_cast<tChar *> (fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId))); //CMG3G-4847 - To solve Lint
   }
   ETG_TRACE_USR4(("  fc_phone_tclSMConferenceCall::u8SCOConnectionStatus: = %d received in Routed state ",u8SCOConnectionStatus));
   /*HfReleaseAudio Signal is triggered when call becomes alerting for Nexus */

   if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_DISCONNECTED)
   {
      //Release Audio and wait in the same state
      if((m_poCallInstance) && (m_poCallInstance2))
      {
         ETG_TRACE_USR3((" fc_phone_tclSMConferenceCall:: FC_PHONE_SMConferenceCall_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE1"));
         m_u16State_while_TransferAudio = FC_PHONE_CONFERENCECALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE1_TRANSFERAUDIOREQUEST_FROMPHONE;
         if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_poCallInstance->m_u8AudioChannel)
         {
#ifdef PHONE_WAITINGMODE
            fc_phone_tclWaitingMode* poWaitingMode = fc_phone_tclWaitingMode::poGetInstance();
            tenFC_Phone_WaitingModeState enWaitingModeState = poWaitingMode->enGetWaitingModeState();

            //During waiting mode, phone audio source will not be in use (audio channel attributes has to be updated)
            if ((FC_PHONE_WAITINGMODE_ACTIVE == enWaitingModeState) && (FC_PHONE_AUDIOCHANNEL_PHONE == m_poCallInstance->m_u8AudioChannel))
            {
               m_poAudioManager->vUpdateChannelAttributes(m_poCallInstance->m_u8AudioChannel, FC_PHONE_REQUESTTYPE_RELEASE);
               m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
               bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
            }
            else
            {
#endif
            ETG_TRACE_USR3(("Release audio m_poCallInstance"));
            m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id, FC_PHONE_AUDIOCHANNEL_PHONE, vAudioCallBackConfCall);
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
            ETG_TRACE_USR3((" AudioChannel =   FC_PHONE_AUDIOCHANNEL_ID_UNUSED"));
#ifdef PHONE_WAITINGMODE
            }
#endif
         }
         else
         {
            bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
         }
      }
   }
   //HfSetUpAudio comes in routed state
   else if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_ESTABLISHED)
   {
      //Acquire Audio and wait here
      if((m_poCallInstance) && (m_poCallInstance2))
      {
         ETG_TRACE_USR3((" fc_phone_tclSMConferenceCall:: FC_PHONE_SMConferenceCall_STATE_WAITFOR_AUDIOACQUISITION_CALLINSTANCE1"));
         m_u16State_while_TransferAudio = FC_PHONE_CONFERENCECALL_STATE_WAITFOR_AUDIOACQUISITION_ON_TRANSFERAUDIOREQUEST_FROMPHONE;
         if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED == m_poCallInstance->m_u8AudioChannel)
         {
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
            ETG_TRACE_USR3((" Requesting Audio m_poCallInstance ::AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE "));
            m_poAudioManager->s32GetRequest(m_poCallInstance->m_u16Id, m_poCallInstance->m_u8AudioChannel, vAudioCallBackConfCall);
         }
         else
         {
            bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
         }
      }
   }
}


/*******************************************************************************
 *
 * FUNCTION: vAssignErrorCode
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMConferenceCall::vAssignErrorCode(tChar Code)
{
   switch(Code)
   {
      case FC_PHONE_DBUS_ERRORCODE_STATE_ERROR:
      {
         ETG_TRACE_USR4((" FC_PHONE_DBUS_ERRORCODE_STATE_ERROR"));
         if(m_poCallInstance)
            m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACK_STATE_ERROR;
         if(m_poCallInstance2)
            m_poCallInstance2->m_AckError = FC_PHONE_CALLINSTANCE_ACK_STATE_ERROR;

      }
      break;
      case FC_PHONE_DBUS_ERRORCODE_OPERATION_NOT_ALLOWED:
      case FC_PHONE_DBUS_ERRORCODE_OPERATION_NOT_SUPPORTED:
      {
         ETG_TRACE_USR4((" FC_PHONE_DBUS_ERRORCODE_OPERATION_NOT_ALLOWED :FC_PHONE_DBUS_ERRORCODE_OPERATION_NOT_SUPPORTED"));
         if(m_poCallInstance)
            m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOTAVAILABLE;
         if(m_poCallInstance2)
            m_poCallInstance2->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOTAVAILABLE;

      }
      break;
      default:
      {
         ETG_TRACE_USR4((" IN DEFAULT This Error Code [0x%x] is not supported yet",Code) );
         if(m_poCallInstance)
            m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
         if(m_poCallInstance2)
            m_poCallInstance2->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
      }
      break;
   }

}

/*************************************************************
 *
 * FUNCTION: vSetCallStatusConference
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 **************************************************************/
tVoid fc_phone_tclSMConferenceCall::vSetCallStatusConference()
{
   ETG_TRACE_USR4((" ENTER: fc_phone_tclSMConferenceCall::vSetCallStatusConference"));

   if (m_poCallInstance)
   {
      m_poCallInstance->m_u16CallStatusNotice  = FC_PHONE_CALLINSTANCE_CALLSTATUS_CONFERENCE;
   }

   if (m_poCallInstance2)
   {
      m_poCallInstance2->m_u16CallStatusNotice  = FC_PHONE_CALLINSTANCE_CALLSTATUS_CONFERENCE;
   }
}

/*************************************************************
 *
 * FUNCTION: vSendCallStatusSplit
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 **************************************************************/
tVoid fc_phone_tclSMConferenceCall::vSendCallStatusSplit(fc_phone_tclCallInstance*& rfpCallInstance,
      const T_CallData* const prCallData)
{
   ETG_TRACE_USR4((" ENTER: fc_phone_tclSMConferenceCall::vSendCallStatusSplit"));

   if (m_poCallInstance && m_poCallInstance2 && rfpCallInstance)
   {
      if(m_bSplitMethodResultSent == FALSE)
      {
         ETG_TRACE_USR4((" calling FC_PHONE_SM_EVENT_DBUS_SPLITCALL_ACK_OK"));
         bProcessEvent(FC_PHONE_SM_EVENT_DBUS_SPLITCALL_ACK_OK);
      }

      if (m_poCallInstance->m_u16Id == rfpCallInstance->m_u16Id)
      {
         vCopyCallData(prCallData,rfpCallInstance);
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, rfpCallInstance);
         m_poCallInstance2->m_u16CallStatusNotice = FC_PHONE_CALLINSTANCE_CALLSTATUS_ACTIVE;
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, m_poCallInstance2);
      }
      else if (m_poCallInstance2->m_u16Id == rfpCallInstance->m_u16Id)
      {
         vCopyCallData(prCallData,rfpCallInstance);
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, rfpCallInstance);
         m_poCallInstance->m_u16CallStatusNotice = FC_PHONE_CALLINSTANCE_CALLSTATUS_ACTIVE;
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, m_poCallInstance);
      }
   }

   vRestoreSM();
}

/*************************************************************
 *
 * FUNCTION: vHandleTransferCallToVehicle
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 **************************************************************/
tVoid fc_phone_tclSMConferenceCall::vHandleTransferCallToVehicle()
{
   ETG_TRACE_USR4((" ENTER: fc_phone_tclSMConferenceCall::vHandleTransferCallToVehicle"));
   if(((fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vGetAudioTransferStatus() == FC_PHONE_DBUS_SCO_CONN_ESTABLISHED))
   {
      ETG_TRACE_USR4((" SCO Connection Established"));
      ETG_TRACE_USR3((" EVENT :: FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK "));
      if(m_poCallInstance)
      {
         m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSFREE,m_poCallInstance);
      }
      else if(m_poCallInstance2)
      {
         m_poCallInstance2->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSFREE,m_poCallInstance2);
      }
   }
   else
   {
      ETG_TRACE_USR4((" SCO Connection is not Established in conference SM"));
      if(m_poCallInstance)
      {
         m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSFREE,m_poCallInstance);
      }
      else if(m_poCallInstance2)
      {
         m_poCallInstance2->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSFREE,m_poCallInstance2);
      }
   }
}

/*************************************************************
 *
 * FUNCTION: vHandleTransferCallToHandset
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 **************************************************************/
tVoid fc_phone_tclSMConferenceCall::vHandleTransferCallToHandset()
{
   ETG_TRACE_USR4((" ENTER: fc_phone_tclSMConferenceCall::vHandleTransferCallToHandset"));
   if(((fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vGetAudioTransferStatus() == FC_PHONE_DBUS_SCO_CONN_DISCONNECTED))
   {
      ETG_TRACE_USR4((" SCO Connection Disconnected"));
      ETG_TRACE_USR3((" EVENT :: FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK "));
      if(m_poCallInstance)
      {
         m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSET,m_poCallInstance);
      }
      else if(m_poCallInstance2)
      {
         m_poCallInstance2->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSET,m_poCallInstance2);
      }
   }
   else
   {
      ETG_TRACE_USR4((" SCO Connection is still Established in conference SM"));
      if(m_poCallInstance)
      {
         m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSET,m_poCallInstance);
      }
      else if(m_poCallInstance2)
      {
         m_poCallInstance2->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSET,m_poCallInstance2);
      }
   }
}

/*******************************************************************************
 *
 * FUNCTION: vSetDtmfLength
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMConferenceCall::vSetDtmfLength(tU16 u16DtmfLength)
{
   ETG_TRACE_USR4((" ENTER: fc_phone_tclSMConferenceCall::vSetDtmfLength"));
   m_u16DTMFCharLength = u16DtmfLength;
}

//FIX GMMY15-8315 [CT]Cannot place conference call on hold
//Hold request was not handled in this state machine, hence conference call was not possible to be put on hold.
//This is Event handler for Hold call acknowledgement
/*************************************************************
 *
 * FUNCTION: vHandleEventInHoldCallAck
 *
 * DESCRIPTION: Event Handler for Hold call acknowledgement from DBus
 *
 * PARAMETER: Event ID
 *
 * RETURNVALUE: None.
 *
 **************************************************************/
tVoid fc_phone_tclSMConferenceCall::vHandleEventInHoldCallAck(tU16 u16EventId)
{
   ETG_TRACE_USR4((" ENTER: fc_phone_tclSMConferenceCall::vHandleEventInHoldCallAck"));

   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_DBUS_HOLDCALL_ACK_OK:
      {
         ETG_TRACE_USR3(("  EVENT ::FC_PHONE_SM_EVENT_DBUS_HOLDCALL_ACK_OK "));
         m_u16State = FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED;
         ETG_TRACE_USR2(("State change:FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED"));
         m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;

         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_HOLDCALL,m_poCallInstance);
      }
      break;

      default:
      {
         ETG_TRACE_USR4((" fc_phone_tclSMAcceptCall::vHandleEventInHoldCall IN DEFAULT"));
      }
      break;
   }
}
/*************************************************************
 *
 * FUNCTION: vHandleEventInResumeCallAck
 *
 * DESCRIPTION: Event Handler for Resume call acknowledgement from DBus
 *
 * PARAMETER: Event ID
 *
 * RETURNVALUE: None.
 *
 **************************************************************/
tVoid fc_phone_tclSMConferenceCall::vHandleEventInResumeCallAck(tU16 u16EventId)
{
   ETG_TRACE_USR4((" ENTER: fc_phone_tclSMConferenceCall::vHandleEventInResumeCallAck"));

   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_DBUS_RESUMECALL_ACK_OK:
      {
         ETG_TRACE_USR3(("  EVENT ::FC_PHONE_SM_EVENT_DBUS_RESUMECALL_ACK_OK "));
         m_u16State = FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED;
         ETG_TRACE_USR2(("State change:FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED"));
         m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;

         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_RESUMECALL,m_poCallInstance);
      }
      break;

      default:
      {
         ETG_TRACE_USR4((" fc_phone_tclSMAcceptCall::vHandleEventInResumeCallAck IN DEFAULT"));
      }
      break;
   }
}
//End of fix
