

/*******************************************************************************
*
* FILE:          FC_Phone_SMAcceptCall.h
*
* SW-COMPONENT:  FC_Phone application
*
* PROJECT:
*
* DESCRIPTION:   Abstracts a statemachine
*
* AUTHOR:        Guruprasad G R
*
* COPYRIGHT:    (c)Celestial Systems, Bangalore, India
*
*******************************************************************************/

#ifndef _FC_PHONE_SMACCEPTCALL_H_
#define _FC_PHONE_SMACCEPTCALL_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
/* Define the states that this machine can take */

#define FC_PHONE_SMACCEPTCALL_STATE_ACCEPT_CALL_STARTED                                  0
#define FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_CONNECT_FROM_BT                             1 
#define FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AM_RESPONSE_DEACTIVATE_RINGING_INCOMINGCALL 2
//#define FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AM_RESPONSE_ACTIVATE_VOICE_INCOMINGCALL     3
#define FC_PHONE_SMACCEPTCALL_STATE_CALL_ROUTED                                          4
#define FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_MICROPHONE_MUTE                             5
#define FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_MICROPHONE_UNMUTE                           6
#define FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_HOLDCALL                                    7
#define FC_PHONE_SMACCEPTCALL_STATE_ONHOLD                                               8
#define FC_PHONE_SMACCEPTCALL_STATE_MICROMUTED                                           9
//#define FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_SRCACTIVITY_ON                              10

#define FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIOACTIVATED                              11

#define FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_SLC_OFF_RESPONSE                            12
#define FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_NOSIGNAL_RESPONSE                           13

#define FC_PHONE_SMACCEPTCALL_STATE_CALL_TRANSFERTOHANDSET                               14
#define FC_PHONE_SMACCEPTCALL_STATE_ROUTING_CALL_IN_HANDSET                              15
#define FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIO_RELEASE_AND_INIT_IDLE                 16

#define FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_RESUMECALL                                    17
#define FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_SWAPDBUSACK_AND_CALLSTATUS                    18
#define FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_SWAPDBUSACK                                   19
#define FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_CALLSTATUS                                    20

#define FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIO_RELEASE_AND_AUDIOTRANSFER_DBUS_CALL     21
#define FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_CONNECT_FROM_BT_FOR_TRANSFERAUDIO             22
#define FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_BT_CHANGEDEVICESTATE_RESPONSE_ONINCOMINGCALL         23
#define FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_BT_CHANGEDEVICESTATE_RESPONSE_ONCALLEND         24
#define FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIOACTIVATION_FOR_RESTOREACCEPTSM         25
#define FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIO_RELEASE_ON_TRANSFERCALLREQ_FROM_PHONE 26
#define FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIO_ACQUISITION_ON_TRANSFERCALLREQ_FROM_PHONE 27
#define FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_HANGUP_ONSTARCALL 28
#define FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIOTRANSFER_ONACCEPT 29
#define FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIOACTIVATED_WAIT_FOR_DBUS_CONNECT 30
#define FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIOACTIVATED_WAIT_FOR_SRCACTIVITY_RESPONSE 31
#define FC_PHONE_SMACCEPTCALL_STATE_CHANNEL_ACQUISITION_FAILED_WAIT_FOR_CS 32
#define FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_RINGTONEACT_TOHANDLE_WAITINGMODE 33
#define FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_SRC_ON_FOR_WAITMODE 34

class fc_phone_tclSMManager;
/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class fc_phone_tclSMAcceptCall : public fc_phone_tclSM 
{
public:

   /* Constructor */
   fc_phone_tclSMAcceptCall(fc_phone_tclCallInstance*&  rfpCallInstance);

   /* Destructor */
   virtual ~fc_phone_tclSMAcceptCall();
   virtual tVoid vCancel(tVoid) FINAL;
   virtual tVoid vExecute(tVoid);
   virtual tBool bProcessEvent(tU16 u16EventId) FINAL;
   virtual tBool bProcessEvent(tU16 u16EventId,tVoid *varg);

   virtual tVoid vTimerCallBack(tU16 u16TimerId);
   virtual tVoid vAudioCallBack(tU16 u16AudioChannelId, tU16 u16RequestState);
   virtual tVoid vNewCallStatus(const T_CallData* const prCallData,tU16 u16_callInstance);
   virtual tVoid vProcessOnDynamicDisconnect(tU16 u16EventId);
   virtual tVoid vRestore(tVoid);
   virtual tVoid vProcessAudioSignal();
   virtual tU16 u16GetSMID();
   virtual tVoid vSetDtmfLength(tU16 u16DtmfLength);
private:
   tBool m_bTimerRunning;
   tU16 m_u16State_while_MicroPhoneMute ;
   tU16 m_u16State_while_Hold ;
   tU16 m_u16State_while_TransferAudio;
   //DTMF attributes
   tU16 m_u16DTMFCharLength ;
   tU16 m_u16SentDtmfCounter ;
   tU16 u16_oneTimeDTMFCalculation;
   tBool m_bEventConsumed ;
   tU16 m_u16SMID;
   tBool m_bTransferCallToVehicleRequest;
   tBool m_bSrcActMethodRxd;
   tU8 m_u8WaitForAudioResponse ;

   tVoid vHandleEventInAMInDeactivateRingCall(tU16 u16EventId);
   tVoid vHandleEventInVoiceActivated(tU16 u16EventId);
   tVoid vHandleEventInAcceptBTInCall(tU16 u16EventId);

   tVoid vHandleEventInHoldCall(tU16 u16EventId);
   tVoid vHandleEventInCallRouted(tU16 u16EventId);
   tVoid vHandleEventInNoSignalResponse(tU16 u16EventId);
   tVoid vHandleEventInRoutingHandsetCall(tU16 u16EventId);
   tVoid vHandleEventInReleasingAudioAndReInitIdle(tU16 u16EventId);
   tVoid vHandleEventInResumeCall(tU16 u16EventId);
   tVoid vHandleEventInSwapDbusAckOrCallStatus(tU16 u16EventId);
   tVoid vHandleEventInSwapCall(tU16 u16EventId);
   tVoid vHandleEventInReleaseAudioAndTransferAudio(tU16 u16EventId);
   tVoid vHandleEventInAudioActivationOnRestoreAcceptCallSM(tU16 u16EventId);
   tVoid vHandleEventInAudioReleaseOnTransferAudioRequest(tU16 u16EventId);
   tVoid vHandleEventInAudioAcquisitionOnTransferAudioRequest(tU16 u16EventId);
   tVoid vHandleDbusError(tU16 u16DbusAckType,tChar Code);
   tVoid vStartTimerAndSendAck();
   tVoid vActOnCallStatusActive(const T_CallData* const prCallData);
   tVoid vAssignErrorCode(tChar Code);
   tVoid vStopTimer(tVoid);
   tVoid vHandleEventInAudioTransferOnAccept(tU16 u16EventId);
   tVoid vTransferCallOrReleaseRingtone();
   tVoid vCallStatusRxdActive();
   tVoid vHandleEventInAudioAcquireAndDbusConnect(tU16 u16EventId);
   tVoid vHandleEventInWaitForSrcActivityResponse(tU16 u16EventId);
   tVoid vHandleEventAudioAcquisitionFailed(tU16 u16EventId);
#ifdef PHONE_WAITINGMODE
   tVoid vProcessWaitingModeRequest();
   tVoid vProcessWaitModeOnCallAccepted();
   tVoid vHandleEventWaitForRingtoneActivatedToHandleWaitingMode(tU16 u16EventId);
   tVoid vHandleEventWaitForSrcOnForWaitmode(tU16 u16EventId);
#endif
};

#endif // _FC_PHONE_SMACCEPTCALL_H_


