/******************************************************************************
 *
 * FILE:          FC_Phone_SMAcceptCall.cpp
 *
 * SW-COMPONENT:  FC_Phone application
 *
 * PROJECT:
 *
 * DESCRIPTION:   CCA service Telephone.
 *
 * AUTHOR:
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

#include "FC_Phone_SMIncludes.h"
#include "../FC_Phone_clienthandler_BTSettings.h"
#include "stdio.h"
#include "../HelperClasses/FC_Phone_CallManager.h"
#ifdef PHONE_WAITINGMODE
#include "../WaitingMode/FC_Phone_WaitingMode.h"
#endif

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_PHONE_STATEMACHINE
#include "trcGenProj/Header/FC_Phone_SMAcceptCall.cpp.trc.h"
#endif

/*******************************************************************************
 *
 * FUNCTION: vAudioCallBackAcceptCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid vAudioCallBackAcceptCall(tU16 u16AudioReqID,tU16 u16AudioChannelId, tU16 u16RequestState)
{
   ETG_TRACE_USR4(("Entering vAudioCallBackAcceptCall with u16AudioReqID %d,u16AudioChannelId %d,u16RequestState %d",u16AudioReqID,u16AudioChannelId,u16RequestState));
   fc_phone_tclSM* pSMInstance ;
   pSMInstance = fc_phone_tclSMManager::GetSM_FromAudioRequestorId(u16AudioReqID) ;   

   if(pSMInstance)
   {
      pSMInstance->vAudioCallBack(u16AudioChannelId, u16RequestState);
   }
   else
   {
      ETG_TRACE_ERR(("ERROR:: could not get SM for u16TimerId %d",u16AudioReqID));
   }

   // fc_phone_tclSMAcceptCall::m_poInstance ->vAudioCallBack(u16AudioChannelId, u16RequestState);
}

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMAcceptCall::fc_phone_tclSMAcceptCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
fc_phone_tclSMAcceptCall::fc_phone_tclSMAcceptCall(fc_phone_tclCallInstance*&  rfpCallInstance):
                  fc_phone_tclSM(rfpCallInstance)
{
   ETG_TRACE_USR4((" Entering constructor fc_phone_tclSMAcceptCall::fc_phone_tclSMAcceptCall"));
   m_u16State      = FC_PHONE_SMACCEPTCALL_STATE_ACCEPT_CALL_STARTED;
   ETG_TRACE_USR2(("State change: FC_PHONE_SMACCEPTCALL_STATE_ACCEPT_CALL_STARTED"));
   m_bTimerRunning = FALSE;
   ETG_TRACE_USR3((" INITIALISED : m_bTimerRunning = FALSE "));
   //m_poInstance    = this;
   m_u16State_while_MicroPhoneMute =  0 ;
   m_u16State_while_Hold = 0;
   m_u16SentDtmfCounter  = 0;
   m_u16DTMFCharLength   = 0;
   u16_oneTimeDTMFCalculation = 0;
   m_bEventConsumed  = FALSE ;
   m_u16State_while_TransferAudio = 0;
   m_bTransferCallToVehicleRequest = FALSE;
   m_u16SMID = FC_PHONE_SMMANAGER_SMID_ACCEPTCALL;
   m_bSrcActMethodRxd = FALSE;
   m_u8WaitForAudioResponse = FALSE;
}
/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMAcceptCall::fc_phone_tclSMAcceptCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
/* Destructor */
fc_phone_tclSMAcceptCall::~fc_phone_tclSMAcceptCall()
{
   ETG_TRACE_USR4((" Entering destructor fc_phone_tclSMAcceptCall::~fc_phone_tclSMAcceptCall"));
   m_bTimerRunning = FALSE;
   m_u16State_while_MicroPhoneMute =  0 ;
   m_u16State_while_Hold = 0;
   m_bTransferCallToVehicleRequest = FALSE;
   m_u16SMID = FC_PHONE_SMMANAGER_SMID_UNKNOWN;
}
/*******************************************************************************
 *
 * FUNCTION: vCancel
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMAcceptCall::vCancel(tVoid)
{
   ETG_TRACE_USR4(("entering  fc_phone_tclSMAcceptCall::vCancel"));

   //If DTMF sending is not finished , send method error
   if(m_u16SentDtmfCounter != m_u16DTMFCharLength)
   {
      ETG_TRACE_USR4((" sending Methos Error to client"));
      u16_oneTimeDTMFCalculation = 0;
      m_u16SentDtmfCounter  = 0;
      m_u16DTMFCharLength   = 0;
      m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
      m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_PLAYDTMF,m_poCallInstance);
   }
   m_u16State_while_TransferAudio = 0;
}

/*******************************************************************************
 *
 * FUNCTION: vStopTimer
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMAcceptCall::vStopTimer(tVoid)
{
   ETG_TRACE_USR4(("Entering fc_phone_tclSMAcceptCall::vStopTimer"));

   if (TRUE == m_bTimerRunning)
   {
      ETG_TRACE_USR4((" stopping TIMER"));
      m_poTimer->s32Stop(m_poCallInstance->m_u16TimerId); // Bugfix for GMMY16-17241
      m_bTimerRunning = FALSE;
      ETG_TRACE_USR3((" m_bTimerRunning = FALSE "));
   }
}

/*******************************************************************************
 *
 * FUNCTION: vRestore
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMAcceptCall::vRestore(tVoid)
{
   m_bTimerRunning = TRUE;
   ETG_TRACE_USR4(("Entering  Restore Accept Call State Machine"));
   ETG_TRACE_USR3((" m_bTimerRunning = TRUE "));
   tU8 u8SCOConnectionStatus = FC_PHONE_DBUS_SCO_CONN_FAILED;
   fc_phone_tclClientHandler_BTSettings *p_clientHndler_bluetooth = (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerBTSettings;
   u8SCOConnectionStatus = p_clientHndler_bluetooth->vGetSCOConnectionStatus(const_cast<tChar *> (fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId))); //CMG3G-4847 - To solve Lint
   //Dbus call for transferring call to handset 
   if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_ESTABLISHED)
   {
      if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED == m_poCallInstance->m_u8AudioChannel)
      {
         m_u16State = FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIOACTIVATION_FOR_RESTOREACCEPTSM;
         ETG_TRACE_USR2(("State change: FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIOACTIVATION_FOR_RESTOREACCEPTSM"));
         m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
         ETG_TRACE_USR3((" Requesting for acquiring channel to audio manager:: AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE"));
         m_poAudioManager->s32GetRequest(m_poCallInstance->m_u16Id,FC_PHONE_AUDIOCHANNEL_PHONE,vAudioCallBackAcceptCall);
      }
      else
      {     
         m_u16State = FC_PHONE_SMACCEPTCALL_STATE_CALL_ROUTED;
         m_poCallInstance->m_bUsingVehicleAudio = TRUE;
         ETG_TRACE_USR3(("  m_bUsingVehicleAudio = TRUE "));
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
         ETG_TRACE_USR2(("State change: FC_PHONE_SMACCEPTCALL_STATE_CALL_ROUTED"));
      }
   }
   else
   {
      ETG_TRACE_USR2(("SCO Disconnected and no channel available"));
      m_u16State = FC_PHONE_SMACCEPTCALL_STATE_CALL_ROUTED;
      m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
      ETG_TRACE_USR2(("State change: FC_PHONE_SMACCEPTCALL_STATE_CALL_ROUTED"));
   }
}

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMAcceptCall::vExecute
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMAcceptCall::vExecute()
{
   ETG_TRACE_USR4(("Entering fc_phone_tclSMAcceptCall::vExecute"));

   m_u8WaitForAudioResponse = FALSE;

   vTransferCallOrReleaseRingtone();
}

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMAcceptCall::bProcessEvent
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tBool fc_phone_tclSMAcceptCall::bProcessEvent(tU16 u16EventId,tVoid *varg)
{
   ETG_TRACE_USR4(("Entering fc_phone_tclSMAcceptCall::bProcessEvent with u16EventId %d ",u16EventId));
   (tVoid)varg;
   FcPhone_processEventArg   *ptProcessEventArg = (FcPhone_processEventArg *) varg;
   tBool bRetVal = FALSE;
   if(TRUE == ptProcessEventArg->bIsItDbusAck)
   {
      ETG_TRACE_USR4((" Status :: %d  Code :: 0x%x ",ptProcessEventArg->Status,ptProcessEventArg->Code));
      if(ptProcessEventArg->u16DbusAckType == FC_PHONE_CB_FID_AUDIOTRANSFER)
      {
         if(ptProcessEventArg->Status == CALLTRANSFER_FAILURE)
         {
            ETG_TRACE_USR4(("DBUS TransferCall  FAILS"));
            vHandleDbusError(ptProcessEventArg->u16DbusAckType,ptProcessEventArg->Code);
         }
         else
         {
            ETG_TRACE_USR4(("DBUS TransferCall  SUCCESS"));
            bRetVal = bProcessEvent(u16EventId);
         }
      }
      else
      {
         if(FC_PHONE_DBUS_STATUS_SUCCESS != ptProcessEventArg->Status)
         {
            ETG_TRACE_USR4((" DBUS Call is not succeed, updating error code "));
            vHandleDbusError(ptProcessEventArg->u16DbusAckType,ptProcessEventArg->Code);
         }
         else
         {
            ETG_TRACE_USR4((" DBUS Call is  succeeded "));
            bRetVal = bProcessEvent(u16EventId) ;
         }
      }
   }
   else
   {
      bRetVal = bProcessEvent(u16EventId) ;
   }
   return bRetVal ;
}
/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMAcceptCall::bProcessEvent
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tBool fc_phone_tclSMAcceptCall::bProcessEvent(tU16 u16EventId)
{
   ETG_TRACE_USR4(("Entering fc_phone_tclSMAcceptCall::bProcessEvent with eventId: %d ",u16EventId));
   switch(m_u16State)
   {  
      case FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AM_RESPONSE_DEACTIVATE_RINGING_INCOMINGCALL:
      {
         ETG_TRACE_USR2((" STATE :: FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AM_RESPONSE_DEACTIVATE_RINGING_INCOMINGCALL "));
         vHandleEventInAMInDeactivateRingCall(u16EventId);
      }
      break;
      case FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIOACTIVATED :
      {
         ETG_TRACE_USR2((" STATE :: FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIOACTIVATED "));
         vHandleEventInVoiceActivated(u16EventId);
      }
      break;
      case FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_CONNECT_FROM_BT:
      {
         ETG_TRACE_USR2((" STATE :: FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_CONNECT_FROM_BT "));
         vHandleEventInAcceptBTInCall(u16EventId);
      }
      break;
      case FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_HOLDCALL:
      {
         ETG_TRACE_USR2((" STATE :: FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_HOLDCALL "));
         vHandleEventInHoldCall(u16EventId);
      }
      break;
      case FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_RESUMECALL :
      {
         ETG_TRACE_USR2((" STATE :: FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_RESUMECALL "));
         vHandleEventInResumeCall(u16EventId);
      }
      break ;
      case FC_PHONE_SMACCEPTCALL_STATE_CALL_ROUTED:
      {
         ETG_TRACE_USR2((" STATE :: FC_PHONE_SMACCEPTCALL_STATE_CALL_ROUTED "));
         vHandleEventInCallRouted(u16EventId);
      }
      break;
      case FC_PHONE_SMACCEPTCALL_STATE_CALL_TRANSFERTOHANDSET :
      {
         ETG_TRACE_USR2((" STATE :: FC_PHONE_SMACCEPTCALL_STATE_CALL_TRANSFERTOHANDSET "));
         vHandleEventInRoutingHandsetCall(u16EventId);
      }
      break;
      case FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIO_RELEASE_AND_INIT_IDLE :
      {
         ETG_TRACE_USR2((" STATE :: FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIO_RELEASE_AND_INIT_IDLE "));
         vHandleEventInReleasingAudioAndReInitIdle(u16EventId);
      }
      break;
      case FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_SWAPDBUSACK_AND_CALLSTATUS :
      {
         ETG_TRACE_USR2((" STATE :: FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_SWAPDBUSACK_AND_CALLSTATUS "));
         vHandleEventInSwapDbusAckOrCallStatus(u16EventId);
      }
      break;
      case FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_SWAPDBUSACK :
      case FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_CALLSTATUS :
      {
         ETG_TRACE_USR2((" STATE :: FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_SWAPDBUSACK :: FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_CALLSTATUS "));
         vHandleEventInSwapCall(u16EventId);
      }
      break;
      case FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIO_RELEASE_AND_AUDIOTRANSFER_DBUS_CALL :
      {
         ETG_TRACE_USR2((" STATE :: FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIO_RELEASE_AND_AUDIOTRANSFER_DBUS_CALL  "));
         vHandleEventInReleaseAudioAndTransferAudio(u16EventId);
      }
      break ;
      case FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIOACTIVATION_FOR_RESTOREACCEPTSM:
      {
         ETG_TRACE_USR2((" STATE :: FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIOACTIVATION_FOR_RESTOREACCEPTSM"));
         vHandleEventInAudioActivationOnRestoreAcceptCallSM(u16EventId);
      }
      break;
      case FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIOTRANSFER_ONACCEPT:
      {           
         ETG_TRACE_USR2(("STATE :: FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIOTRANSFER_ONACCEPT "));
         vHandleEventInAudioTransferOnAccept(u16EventId);
      }
      break;
      case FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIOACTIVATED_WAIT_FOR_DBUS_CONNECT:
      { 
         ETG_TRACE_USR2((" STATE :: FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIOACTIVATED_WAIT_FOR_DBUS_CONNECT  "));
         vHandleEventInAudioAcquireAndDbusConnect(u16EventId);

      }
      break;
      case FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIOACTIVATED_WAIT_FOR_SRCACTIVITY_RESPONSE:
      { 
         ETG_TRACE_USR2((" STATE :: FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIOACTIVATED_WAIT_FOR_SRCACTIVITY_RESPONSE  "));
         vHandleEventInWaitForSrcActivityResponse(u16EventId);
      }
      break;
      case FC_PHONE_SMACCEPTCALL_STATE_CHANNEL_ACQUISITION_FAILED_WAIT_FOR_CS:
      {
         ETG_TRACE_USR2(("STATE: FC_PHONE_SMACCEPTCALL_STATE_CHANNEL_ACQUISITION_FAILED_WAIT_FOR_CS"));
         vHandleEventAudioAcquisitionFailed(u16EventId);
      }
      break;

#ifdef PHONE_WAITINGMODE
      case FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_RINGTONEACT_TOHANDLE_WAITINGMODE:
      {
         ETG_TRACE_USR2(("STATE: FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_RINGTONEACT_TOHANDLE_WAITINGMODE"));
         vHandleEventWaitForRingtoneActivatedToHandleWaitingMode(u16EventId);
      }
      break;
      case FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_SRC_ON_FOR_WAITMODE:
      {
         ETG_TRACE_USR2(("FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_SRC_ON_FOR_WAITMODE"));
         vHandleEventWaitForSrcOnForWaitmode(u16EventId);
      }
      break;
#endif
      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMAcceptCall::bProcessEvent IN DEFAULT"));
      }
      break;
   }
   tBool bRetVal= m_bEventConsumed;
   m_bEventConsumed = FALSE;
   return bRetVal ;
}

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMAcceptCall::vHandleEventInAudioAcquisitionOnTransferAudioRequest
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMAcceptCall::vHandleEventInAudioAcquisitionOnTransferAudioRequest(tU16 u16EventId)
{
   ETG_TRACE_USR4(("Entering fc_phone_tclSMAcceptCall : vHandleEventInAudioAcquisitionOnTransferAudioRequest with eventId %d",u16EventId));
   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
      {
         ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_PHONE_REQUEST_OK"));
         m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE ;
         ETG_TRACE_USR3((" AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE"));
         m_poCallInstance->m_bUsingVehicleAudio = TRUE;
         ETG_TRACE_USR3(("  m_bUsingVehicleAudio = TRUE "));
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
         m_u16State = FC_PHONE_SMACCEPTCALL_STATE_CALL_ROUTED;
         ETG_TRACE_USR2(("State change: FC_PHONE_SMACCEPTCALL_STATE_CALL_ROUTED"));
         if(m_bTransferCallToVehicleRequest == TRUE)
         {
            m_bTransferCallToVehicleRequest = FALSE;
            //Send Method result for Transfer call to Vehicle
            m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSFREE,m_poCallInstance);
         }
         m_u16State_while_TransferAudio = 0;
      }
      break;
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK:
      {
         ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK"));
         m_u16State_while_TransferAudio = FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIO_RELEASE_ON_TRANSFERCALLREQ_FROM_PHONE;
         if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_poCallInstance->m_u8AudioChannel)
         {
			ETG_TRACE_USR3((" Requesting for release to audio manager "));
			m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id,FC_PHONE_AUDIOCHANNEL_PHONE,vAudioCallBackAcceptCall);
         }
         m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED ;
         m_poCallInstance->m_bUsingVehicleAudio = FALSE;
         ETG_TRACE_USR3(("  m_bUsingVehicleAudio = FALSE "));
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
         m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId), FC_PHONE_CALLTRANSFER_FROMHANSFREE_TOHANDSET);
      }
      break;
      case FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK:
      {
         ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK"));
         if(m_bTransferCallToVehicleRequest == TRUE)
         {
            m_bTransferCallToVehicleRequest = FALSE;
            //Send Method result for Transfer call to Vehicle
            m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSFREE,m_poCallInstance);
         }
         else
         {
            m_u16State_while_TransferAudio = 0;
         }
         m_u16State = FC_PHONE_SMACCEPTCALL_STATE_CALL_ROUTED;
         ETG_TRACE_USR2(("State change: FC_PHONE_SMACCEPTCALL_STATE_CALL_ROUTED"));
      }
      break;
      default:
      {
         ETG_TRACE_ERR(("fc_phone_tclSMAcceptCall::vHandleEventInAudioAcquisitionOnTransferAudioRequest"
               " IN DEFAULT : Wrong Event ID u16EventId: %d",u16EventId));
      }
      break;
   }
}

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMAcceptCall::vHandleEventInAudioAudioReleaseOnTransferAudioRequest
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMAcceptCall::vHandleEventInAudioReleaseOnTransferAudioRequest(tU16 u16EventId)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMAcceptCall : vHandleEventInAudioAudioReleaseOnTransferAudioRequest with u16EventId %d ",u16EventId));
   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
      {
         ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_PHONE_REQUEST_OK"));
         m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED ;
         m_poCallInstance->m_bUsingVehicleAudio = FALSE;
         ETG_TRACE_USR3(("  m_bUsingVehicleAudio = FALSE "));
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
         //m_poSMManager->vRestoreToActiveCallInHandset(m_poCallInstance->m_u16Id);
         m_u16State_while_TransferAudio = 0;
      }
      break;
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK:
      {
         ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK"));
         //AcquireAudioChannel and transfer audio to handsfree
         m_u16State_while_TransferAudio = FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIO_ACQUISITION_ON_TRANSFERCALLREQ_FROM_PHONE;
         m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
         if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED == m_poCallInstance->m_u8AudioChannel)
         {
            ETG_TRACE_USR3((" Requesting for acquiring channel to audio manager:: AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE"));
            m_poAudioManager->s32GetRequest(m_poCallInstance->m_u16Id,FC_PHONE_AUDIOCHANNEL_PHONE,vAudioCallBackAcceptCall);
         }
         m_poCallInstance->m_bUsingVehicleAudio = TRUE;
         ETG_TRACE_USR3(("  m_bUsingVehicleAudio = TRUE "));
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
         m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId), FC_PHONE_CALLTRANSFER_FROMHANDSET_TOHANSFREE);
      }
      break;
      case FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK:
      {
         ETG_TRACE_USR3(("  EVENT :  FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK"));
         m_u16State_while_TransferAudio = 0;
         m_u16State = FC_PHONE_SMACCEPTCALL_STATE_CALL_ROUTED;
         ETG_TRACE_USR2(("State change: FC_PHONE_SMACCEPTCALL_STATE_CALL_ROUTED"));
      }
      break;
      default:
      {
         ETG_TRACE_ERR(("fc_phone_tclSMAcceptCall::vHandleEventInAudioReleaseOnTransferAudioRequest DEFAULT : Wrong Event ID u16EventId: %d",u16EventId));
      }
      break;
   }
}

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMAcceptCall::vHandleEventInAudioActivationOnRestoreAcceptCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMAcceptCall::vHandleEventInAudioActivationOnRestoreAcceptCallSM(tU16 u16EventId)
{
   ETG_TRACE_USR4(("Entering fc_phone_tclSMAcceptCall::vHandleEventInAudioActivationOnRestoreAcceptCallSM with u16EventId %d",u16EventId));
   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
      {
         ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_PHONE_REQUEST_OK"));
         m_poCallInstance->m_bUsingVehicleAudio = TRUE;
         ETG_TRACE_USR3(("  m_bUsingVehicleAudio = TRUE "));
         m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
         ETG_TRACE_USR3((" AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE"));
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
         m_u16State = FC_PHONE_SMACCEPTCALL_STATE_CALL_ROUTED;
         ETG_TRACE_USR2(("State change: FC_PHONE_SMACCEPTCALL_STATE_CALL_ROUTED"));
      }
      break;
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK:
      {
         ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK"));
         ETG_TRACE_ERR(("  ERROR :: PHONE CHANNEL IS NOT AQUIRED TRANSFERING CALL TO HANDSET   "));
         /* Transfer the call to handset */
         m_poCallInstance->m_bUsingVehicleAudio = FALSE;
         ETG_TRACE_USR3(("  m_bUsingVehicleAudio = FALSE "));
         m_u16State = FC_PHONE_SMACCEPTCALL_STATE_CALL_TRANSFERTOHANDSET;
         ETG_TRACE_USR2(("State change: FC_PHONE_SMACCEPTCALL_STATE_CALL_TRANSFERTOHANDSET"));
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
         //Dbus call for transferring call to handset
         m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId), FC_PHONE_CALLTRANSFER_FROMHANSFREE_TOHANDSET);
      }
      break;
      default:
      {
         ETG_TRACE_ERR((" fc_phone_tclSMAcceptCall::vHandleEventInAudioActivationOnRestoreAcceptCallSM  DEFAULT : Wrong Event ID u16EventId: %d",u16EventId));
      }
      break;
   }
}
/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMAcceptCall::vHandleEventInAMInDeactivateRingCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMAcceptCall::vHandleEventInAMInDeactivateRingCall(tU16 u16EventId)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMAcceptCall::vHandleEventInAMInDeactivateRingCall with EventId %d ",u16EventId));
   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_ALERT_REQUEST_OK :
      case FC_PHONE_SM_EVENT_INCOMINGCALL_REQUEST_OK:
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
         {
            ETG_TRACE_USR3((" EVENT : FC_PHONE_SM_EVENT_ALERT_REQUEST_OK:: FC_PHONE_SM_EVENT_INCOMINGCALL_REQUEST_OK"));
            fc_phone_tclClientHandler_BTSettings *p_clientHndler_bluetooth = (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerBTSettings;
            if((p_clientHndler_bluetooth->vIsInBandRingtone()) && FC_PHONE_AUDIOCHANNEL_PHONE == m_poCallInstance->m_u8AudioChannel)
            {
               // phone channel already allocated, so change the state and post event - phone req ok
               ETG_TRACE_ERR(("For InbandRingtone ringtone"));
               m_u16State = FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIOACTIVATED;
               ETG_TRACE_USR2(("State change: FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIOACTIVATED"));
               bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
               break;
            }

            m_poCallInstance->m_bUsingVehicleAudio = FALSE;
            ETG_TRACE_USR3(("  m_bUsingVehicleAudio = FALSE "));
            //If hfsetup audio is received before complete processing of Incoming ringtone/alert tone then LC_Phone channel will be allocated
            //so when method result is received for incoming ringtone / alert tone if m_u8AudioChannel is set to default value then request for LC_Phone channel will be posted again

            if(FC_PHONE_AUDIOCHANNEL_ALERTTONE == m_poCallInstance->m_u8AudioChannel || FC_PHONE_AUDIOCHANNEL_INCOMINGRINGTONE == m_poCallInstance->m_u8AudioChannel )
            {
               m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
            }

            if(FALSE ==  m_poCallInstance->m_bcallWaitingState)
            {
               // channel needs to be allocated from ARL/AV-Manager.
               m_u16State = FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIOACTIVATED_WAIT_FOR_SRCACTIVITY_RESPONSE;
               ETG_TRACE_USR2(("State change: FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIOACTIVATED_WAIT_FOR_SRCACTIVITY_RESPONSE"));
               m_u8WaitForAudioResponse = TRUE;
               ETG_TRACE_USR2(("m_u8WaitForAudioResponse = TRUE"));
            }
            else
            {
               // channel already allocated from ARL/AV-Manager so fc-phone just receives fake ack.
               // so no need to wait for ARL/AV-Manage response.
               m_u16State = FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIOACTIVATED;
               ETG_TRACE_USR2(("State change: FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIOACTIVATED"));
               m_u8WaitForAudioResponse = FALSE;
               ETG_TRACE_USR2(("m_u8WaitForAudioResponse = FALSE"));
            }

            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
            //Update the audio channel status
            if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED == m_poCallInstance->m_u8AudioChannel)
            {
               m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
               ETG_TRACE_USR3((" Requesting for acquiring channel to audio manager:: AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE"));
               m_poAudioManager->s32GetRequest(m_poCallInstance->m_u16Id,FC_PHONE_AUDIOCHANNEL_PHONE,vAudioCallBackAcceptCall);
            }
            else
            {
               bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
            }
         }
      break;
      case FC_PHONE_SM_EVENT_ALERT_REQUEST_NOK :
      case FC_PHONE_SM_EVENT_INCOMINGCALL_REQUEST_NOK:
      {
         ETG_TRACE_USR3(("  EVENT :FC_PHONE_SM_EVENT_ALERT_REQUEST_NOK::  FC_PHONE_SM_EVENT_INCOMINGCALL_REQUEST_NOK"));

         /* TO DO:Trasfer the call to handset */
         m_u8WaitForAudioResponse = FALSE;
         m_poCallInstance->m_bUsingVehicleAudio = FALSE;
         ETG_TRACE_USR3(("  m_bUsingVehicleAudio = FALSE "));
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,\
               m_poCallInstance);
      };
      break;
      case FC_PHONE_SM_EVENT_HOLDCALL_REQUEST:
      {
         ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_HOLDCALL_REQUEST"));
         /* Forward Hold Request to DBus */
         m_u16State_while_Hold = m_u16State ;
         m_u16State = FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_HOLDCALL;
         ETG_TRACE_USR2(("State change: FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_HOLDCALL"));
         m_pDbusIf->bHoldCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId));

      }
      break;

#ifdef PHONE_WAITINGMODE
      case FC_PHONE_SM_EVENT_ARL_PHONEWAIT_SRC_ON:
      {
         ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_ARL_PHONEWAIT_SRC_ON"));

         m_u16State = FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIOACTIVATED;
         ETG_TRACE_USR2(("State change: FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIOACTIVATED"));

         //Phone channel attributes are sent (in case if call is resumed, channel attributes are upto date)
         m_poAudioManager->vUpdateChannelAttributes(m_poCallInstance->m_u8AudioChannel, FC_PHONE_REQUESTTYPE_GET);
         bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK); //posts accept call request to Phone device
      }
      break;
#endif

      default:
      {
         ETG_TRACE_ERR(("  ERROR ::IN DEFAULT : vHandleEventInAMInDeactivateRingCall"));
      }
      break;
   }
}


/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMAcceptCall::vHandleEventInVoiceActivated
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMAcceptCall::vHandleEventInVoiceActivated(tU16 u16EventId)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMAcceptCall::vHandleEventInVoiceActivated with EventId %d ",u16EventId));

   switch (u16EventId)
   {

      case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
      {

         ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_PHONE_REQUEST_OK"));

         /* Recieving audio channel is complete */
         //Update the audio channel status
         m_poCallInstance->m_bUsingVehicleAudio = TRUE;
         ETG_TRACE_USR3(("  m_bUsingVehicleAudio = TRUE"));
         m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
         ETG_TRACE_USR3((" AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE"));
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,\
               m_poCallInstance);
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
         //voice channel aquired , wait for connect from BT
         m_u16State = FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_CONNECT_FROM_BT;
         ETG_TRACE_USR2(("State change: FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_CONNECT_FROM_BT"));
         if(TRUE ==  m_poCallInstance->m_bcallWaitingState)
         {
            m_pDbusIf->bAcceptCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId), FC_PHONE_DBUS_ACCEPT_SECOND_WAITINGCALL);
         }
         else
         {
            m_pDbusIf->bAcceptCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId) , FC_PHONE_DBUS_ACCEPT_SINGLECALL);
         }


      }
      break;

      case FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK:
      {

         ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK"));
         ETG_TRACE_ERR(("  ERROR :: PHONE CHANNEL IS NOT AQUIRED TRANSFERING CALL TO HANDSET   "));

         /* Transfer the call to handset */
         m_poCallInstance->m_bUsingVehicleAudio = FALSE;
         ETG_TRACE_USR3(("  m_bUsingVehicleAudio = FALSE"));
         m_u16State = FC_PHONE_SMACCEPTCALL_STATE_CALL_TRANSFERTOHANDSET;
         ETG_TRACE_USR2(("State change: FC_PHONE_SMACCEPTCALL_STATE_CALL_TRANSFERTOHANDSET"));
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,\
               m_poCallInstance);
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
         tU8 u8SCOConnectionStatus = FC_PHONE_DBUS_SCO_CONN_FAILED;
         fc_phone_tclClientHandler_BTSettings *p_clientHndler_bluetooth = (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerBTSettings;
         u8SCOConnectionStatus = p_clientHndler_bluetooth->vGetSCOConnectionStatus(const_cast<tChar *> (fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId))); //CMG3G-4847 - To solve Lint
         //Dbus call for transferring call to handset
         if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_ESTABLISHED)
         {
            ETG_TRACE_USR4((" Calling Audio Transfer after receiving SCO Connection Status"));
            m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId),FC_PHONE_CALLTRANSFER_FROMHANSFREE_TOHANDSET);
         }
         //GMMY15-813 Cannot switch call to handsfree from radio if incoming call answered from Bluetooth phone
         else if (u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_STATUS_UNKNOWN)
         {
            ETG_TRACE_USR4(( "EVENT : FC_PHONE_DBUS_SCO_CONN_STATUS_UNKNOWN"));
            m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId),FC_PHONE_CALLTRANSFER_FROMHANSFREE_TOHANDSET);
         }
         else
         {
            bProcessEvent(FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK);
         }
      }
      if((fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->m_bAcceptMethodStartFlag == TRUE)
      {
         m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACK_NO_AUDIO_CHANNEL;
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_ACCEPTCALL,m_poCallInstance);
      }
      break;

      case FC_PHONE_SM_EVENT_HOLDCALL_REQUEST:
      {
         ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_HOLDCALL_REQUEST"));
         /* Forward Hold Request to DBus */
         m_u16State_while_Hold = m_u16State ;
         m_u16State = FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_HOLDCALL;
         m_pDbusIf->bHoldCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId));

      }
      break;

      default:
      {
         ETG_TRACE_USR4((" fc_phone_tclSMAcceptCall::vHandleEventInVoiceActivated  DEFAULT : Wrong Event ID u16EventId: %d",u16EventId));
      }
      break;
   }
}


/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMAcceptCall::vHandleEventInAcceptBTInCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/

tVoid fc_phone_tclSMAcceptCall::vHandleEventInAcceptBTInCall(tU16 u16EventId)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMAcceptCall::vHandleEventInAcceptBTInCall with u16EventId %d ",u16EventId));

   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_DBUS_ACCEPTCALL_ACK_OK :
      {
         ETG_TRACE_USR3((" EVENT::FC_PHONE_SM_EVENT_DBUS_ACCEPTCALL_ACK_OK"));

#ifdef PHONE_WAITINGMODE
         fc_phone_tclWaitingMode* poWaitingMode = fc_phone_tclWaitingMode::poGetInstance();
         tenFC_Phone_WaitingModeState enWaitingModeState = poWaitingMode->enGetWaitingModeState();

         if (FC_PHONE_WAITINGMODE_START_IN_PROGRESS == enWaitingModeState)
         {
            vProcessWaitModeOnCallAccepted();
         }
         else
         {
#endif
         if (!m_bTimerRunning)
         {
            vStartTimerAndSendAck();
            }
#ifdef PHONE_WAITINGMODE
         }
#endif
      }
      break;
      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMAcceptCall::vHandleEventInAcceptBTInCall IN DEFAULT"));
      }
      break;
   }
}

#ifdef PHONE_WAITINGMODE
tVoid fc_phone_tclSMAcceptCall::vProcessWaitModeOnCallAccepted()
{
   ETG_TRACE_USR4(("fc_phone_tclSMAcceptCall::vProcessWaitModeOnCallAccepted entered"));

   if (FC_PHONE_CALLINSTANCE_INCOMINGCALLEVENT_RINGING == m_poCallInstance->m_u16IncomingCallEvent)
   {
      ETG_TRACE_USR4(("Sending InComingCallEvent(IDLE) property update to clients"));

      m_poCallInstance->m_u16IncomingCallEvent = FC_PHONE_CALLINSTANCE_INCOMINGCALLEVENT_IDLE;
      m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_INCOMINGCALL, m_poCallInstance);
   }
   m_u16State = FC_PHONE_SMACCEPTCALL_STATE_CALL_ROUTED;
   ETG_TRACE_USR2(("State change: FC_PHONE_SMACCEPTCALL_STATE_CALL_ROUTED"));

   m_bTimerRunning = TRUE;
   ETG_TRACE_USR3((" m_bTimerRunning = TRUE "));
   m_poCallInstance->m_u16TimerId = FC_PHONE_CALLINSTANCE_TIMER_ID;
   m_poTimer->s32Start(m_poCallInstance->m_u16TimerId, FC_PHONE_ONE_SECOND, vCallInstanceTimerCallBack);

   fc_phone_tclWaitingMode* poWaitingMode = fc_phone_tclWaitingMode::poGetInstance();
   poWaitingMode->bProcessEvent(FC_PHONE_WAITING_MODE_EVENT_PHONEWAIT_SRC_ON);
}
#endif


/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMAcceptCall::vHandleEventInHoldCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMAcceptCall::vHandleEventInHoldCall(tU16 u16EventId)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMAcceptCall::vHandleEventInHoldCall with event ID %d ",u16EventId));

   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_DBUS_HOLDCALL_ACK_OK:
      {

         ETG_TRACE_USR3(("  EVENT ::FC_PHONE_SM_EVENT_DBUS_HOLDCALL_ACK_OK "));
         //update the status to hold
         m_u16State = FC_PHONE_SMACCEPTCALL_STATE_CALL_ROUTED;
         ETG_TRACE_USR2(("State change:FC_PHONE_SMACCEPTCALL_STATE_CALL_ROUTED"));
         m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;

         // Bugfix GMMY15-6638 - Get the NewCallStatus Immediately to update the CallStatus
         if(FC_PHONE_CALLINSTANCE_CALLSTATUS_ACTIVE == m_poCallInstance->m_u16CallStatusNotice)
         {
            (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vSwapHoldCallStatus();
         }
         else
         {
            m_poCallInstance->m_u16CallStatusNotice = FC_PHONE_CALLINSTANCE_CALLSTATUS_ONHOLD;
         }

         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_HOLDCALL,m_poCallInstance);
         //m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
         //m_pDbusIf->bGetCallStaus(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList());
      }
      break;

      default:
      {
         ETG_TRACE_USR4((" fc_phone_tclSMAcceptCall::vHandleEventInHoldCall IN DEFAULT"));
      }
      break;
   }

}


/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMAcceptCall::vHandleEventInResumeCall
 *
 * DESCRIPTION: Resume Hold call
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMAcceptCall::vHandleEventInResumeCall(tU16 u16EventId)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMAcceptCall::vHandleEventInResumeCall with eventId %d",u16EventId));

   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_DBUS_RESUMECALL_ACK_OK:
      {

         ETG_TRACE_USR3(("  EVENT ::FC_PHONE_SM_EVENT_DBUS_RESUMECALL_ACK_OK "));

         m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;

         //update the status to ACTIVE
         m_u16State = FC_PHONE_SMACCEPTCALL_STATE_CALL_ROUTED;
         ETG_TRACE_USR2(("State change:FC_PHONE_SMACCEPTCALL_STATE_CALL_ROUTED"));
         m_poCallInstance->m_u16CallStatusNotice = FC_PHONE_CALLINSTANCE_CALLSTATUS_ACTIVE;
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_RESUMECALL,m_poCallInstance);
      }
      break;

      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMAcceptCall::vHandleEventInResumeCall DEFAULT  u16EventId :: %d",u16EventId));
      }
      break;
   }

}


/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMAcceptCall::vHandleEventInCallRouted
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMAcceptCall::vHandleEventInCallRouted(tU16 u16EventId)
{    
   ETG_TRACE_USR4((" Entering fc_phone_tclSMAcceptCall::vHandleEventInCallRouted with EventId %d",u16EventId));
   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_HOLDCALL_REQUEST:
      {
         ETG_TRACE_USR3(("  EVENT ::FC_PHONE_SM_EVENT_HOLDCALL_REQUEST "));
         /* Forward Hold Request to DBus */
         m_u16State = FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_HOLDCALL;
         ETG_TRACE_USR2(("State change: FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_HOLDCALL"));
         m_pDbusIf->bHoldCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId));
      }
      break;

      case FC_PHONE_SM_EVENT_SENDDTMF:
      {
         ETG_TRACE_USR3(("  EVENT ::FC_PHONE_SM_EVENT_SENDDTMF "));
         ETG_TRACE_USR4(("u16_oneTimeDTMFCalculation:: %d ",u16_oneTimeDTMFCalculation));

         if(0 == u16_oneTimeDTMFCalculation)
         {
            u16_oneTimeDTMFCalculation = 1;
            m_u16DTMFCharLength  = static_cast<tU16>(OSAL_u32StringLength(m_poCallInstance->DTMFChar));
            m_u16SentDtmfCounter  = 0;
            (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vSetDtmfStatus(TRUE);
            ETG_TRACE_USR4(("  m_u16DTMFCharLength :: %d ",m_u16DTMFCharLength));
         }


         tU8 u8DtmfValue = (tU8)m_poCallInstance->DTMFChar[m_u16SentDtmfCounter];
         m_pDbusIf->bSendDTMF(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId),u8DtmfValue);
      }
      break;

      case FC_PHONE_SM_EVENT_DBUS_DTMF_ACK_OK:
      {
         ETG_TRACE_USR3(("  EVENT ::FC_PHONE_SM_EVENT_DBUS_DTMF_ACK_OK "));

         //Update Method Status
         m_u16SentDtmfCounter++;

         if(m_u16SentDtmfCounter == m_u16DTMFCharLength)
         {
            ETG_TRACE_USR4(("  SENDING DTMF SUCCESS ,sending MR to client"));
            u16_oneTimeDTMFCalculation = 0;
            m_u16SentDtmfCounter  = 0;
            m_u16DTMFCharLength   = 0;
            m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_PLAYDTMF,m_poCallInstance);
            (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vSetDtmfStatus(FALSE);
         }
         else
         {
            ETG_TRACE_USR4((" Previous DTMF sent, processing for next  "));
            bProcessEvent(FC_PHONE_SM_EVENT_SENDDTMF);
         }
      }
      break;

      case FC_PHONE_SM_EVENT_SWAPCALL_OK :
      {
         ETG_TRACE_USR3((" FC_PHONE_SM_EVENT_SWAPCALL_OK :; calling dbus swapcall "));

         m_bEventConsumed = TRUE ;
         m_u16State = FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_SWAPDBUSACK_AND_CALLSTATUS ;
         ETG_TRACE_USR2(("State change:  FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_SWAPDBUSACK_AND_CALLSTATUS"));
         m_pDbusIf->bSwapCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId));
      }
      break ;

      case FC_PHONE_SM_EVENT_IF_VEHICLECALL_TRANSFER_TOHANTSET :
      {
         ETG_TRACE_USR3((" EVENT: FC_PHONE_SM_EVENT_IF_VEHICLECALL_TRANSFER_TOHANTSET"));

         //release audio
         //Send Dbus method for audio Transfer
         //Start ActiveCall In Handset SM
         m_u16State = FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIO_RELEASE_AND_AUDIOTRANSFER_DBUS_CALL ;
         ETG_TRACE_USR2(("State change:  FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIO_RELEASE_AND_AUDIOTRANSFER_DBUS_CALL"));
         if(m_poCallInstance->m_u8AudioChannel != FC_PHONE_AUDIOCHANNEL_ID_UNUSED)
         {
            ETG_TRACE_USR3((" Requesting for release to audio manager"));
            m_poAudioManager->s32ReleaseRequest( m_poCallInstance->m_u16Id,m_poCallInstance->m_u8AudioChannel,vAudioCallBackAcceptCall);
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
         }
         else
         {
            bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
         }
      }
      break ;

      case FC_PHONE_SM_EVENT_RESUMECALL_REQUEST:
      {
         ETG_TRACE_USR3(("  EVENT ::FC_PHONE_SM_EVENT_RESUMECALL_REQUEST "));
         /* Forward Resume Call Request to DBus */
         m_u16State = FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_RESUMECALL;
         ETG_TRACE_USR2(("State change:  FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_RESUMECALL"));
         m_pDbusIf->bResumeCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId));
      }
      break;

      case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
      {
         ETG_TRACE_USR3(("  EVENT ::FC_PHONE_SM_EVENT_PHONE_REQUEST_OK "));
         if(m_u16State_while_TransferAudio == FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIO_RELEASE_ON_TRANSFERCALLREQ_FROM_PHONE)
         {
            vHandleEventInAudioReleaseOnTransferAudioRequest(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
         }
         else if(m_u16State_while_TransferAudio == FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIO_ACQUISITION_ON_TRANSFERCALLREQ_FROM_PHONE)
         {
            vHandleEventInAudioAcquisitionOnTransferAudioRequest(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
         }
         else
         {
            ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_PHONE_REQUEST_OK"));
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE ;
            ETG_TRACE_USR3((" AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE"));
            m_poCallInstance->m_bUsingVehicleAudio = TRUE;
            ETG_TRACE_USR3(("  m_bUsingVehicleAudio = TRUE "));
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
            m_u16State = FC_PHONE_SMACCEPTCALL_STATE_CALL_ROUTED;
            ETG_TRACE_USR2(("State change: FC_PHONE_SMACCEPTCALL_STATE_CALL_ROUTED"));
         }

      }
      break;

      case FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK:
      {
         ETG_TRACE_USR3(("  EVENT ::FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK "));
         if(m_u16State_while_TransferAudio == FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIO_RELEASE_ON_TRANSFERCALLREQ_FROM_PHONE)
         {
            vHandleEventInAudioReleaseOnTransferAudioRequest(FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK);
         }
         else if(m_u16State_while_TransferAudio == FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIO_ACQUISITION_ON_TRANSFERCALLREQ_FROM_PHONE)
         {
            vHandleEventInAudioAcquisitionOnTransferAudioRequest(FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK);
         }
         else
         {
            ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK"));
            if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_poCallInstance->m_u8AudioChannel)
            {
               ETG_TRACE_USR3((" Requesting for release to audio manager "));
               m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id,FC_PHONE_AUDIOCHANNEL_PHONE,vAudioCallBackAcceptCall);
            }
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED ;
            m_poCallInstance->m_bUsingVehicleAudio = FALSE;
            ETG_TRACE_USR3(("  m_bUsingVehicleAudio = FALSE "));
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
            m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId), FC_PHONE_CALLTRANSFER_FROMHANSFREE_TOHANDSET);
         }
      }
      break;

      case FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK:
      {
         ETG_TRACE_USR3(("  EVENT :: FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK "));
         if(m_u16State_while_TransferAudio == FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIO_RELEASE_ON_TRANSFERCALLREQ_FROM_PHONE)
         {
            vHandleEventInAudioReleaseOnTransferAudioRequest(FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK);
         }
         else if(m_u16State_while_TransferAudio == FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIO_ACQUISITION_ON_TRANSFERCALLREQ_FROM_PHONE)
         {
            vHandleEventInAudioAcquisitionOnTransferAudioRequest(FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK);
         }
      }
      break;

      case FC_PHONE_SM_EVENT_TRANSFERCALLVEHICLE_REQUEST_OK:
      {
         ETG_TRACE_USR3(("EVENT :FC_PHONE_SM_EVENT_TRANSFERCALLVEHICLE_REQUEST_OK"));
         //Act like for SetUpAudio
         if(m_poCallInstance->m_bUsingVehicleAudio == FALSE)
         {
            m_bEventConsumed = TRUE;
            m_bTransferCallToVehicleRequest = TRUE;
            m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId), FC_PHONE_CALLTRANSFER_FROMHANDSET_TOHANSFREE);
         }
         else
         {
            //Send Method Error for Transfer call to Vehicle
            m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSFREE,m_poCallInstance);
         }
      }
      break;
      case FC_PHONE_SM_EVENT_DBUS_SWAPCALL_ACK_OK:
      {
         ETG_TRACE_USR3((" EVENT:: FC_PHONE_SM_EVENT_DBUS_SWAPCALL_ACK_OK "));
         //Post method result on dbus ack
         m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_SWAPCALL,m_poCallInstance);
      }
      break;

#ifdef PHONE_WAITINGMODE
      case FC_PHONE_SM_EVENT_START_WAITING_MODE:
      {
         ETG_TRACE_USR3((" EVENT:: FC_PHONE_SM_EVENT_START_WAITING_MODE "));

         m_bEventConsumed = TRUE;

         if (FALSE ==
               ((fc_phone_tclApp::m_poMainAppInstance)->m_poPhoneAudioRouting->vTriggerPhoneAudioAllocation(
                     FC_PHONE_AUDIOCHANNEL_PHONEWAIT)))
         {
            ETG_TRACE_ERR(("Audio Route request posting failed!"));

            fc_phone_tclWaitingMode* poWaitingMode = fc_phone_tclWaitingMode::poGetInstance();
            poWaitingMode->bProcessEvent(FC_PHONE_WAITING_MODE_EVENT_PHONEWAIT_SRC_ROUTING_FAILED);
         }
      }
      break;
#endif

      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMAcceptCall::vHandleEventInCallRouted  Default. "));
         m_bEventConsumed = FALSE ;
      }
      break;
   }
}



/*******************************************************************************
 *
 * FUNCTION: vHandleEventInSwapDbusAckOrCallStatus
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMAcceptCall::vHandleEventInSwapDbusAckOrCallStatus(tU16 u16EventId)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMAcceptCall::vHandleEventInSwapDbusAckOrCallStatus with eventId %d",u16EventId));

   switch (u16EventId)
   {

   case FC_PHONE_SM_EVENT_DBUS_SWAPCALL_ACK_OK :
      {
         ETG_TRACE_USR3((" EVENT:: FC_PHONE_SM_EVENT_DBUS_SWAPCALL_ACK_OK "));
         m_u16State = FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_CALLSTATUS ;
         ETG_TRACE_USR2(("State change:  FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_CALLSTATUS"));
         //Post method result on dbus ack
         m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_SWAPCALL,m_poCallInstance);
      }
      break ;

      case FC_PHONE_SM_EVENT_CALLSTATUS_UPDATE :
      {
         ETG_TRACE_USR3(("  FC_PHONE_SM_EVENT_DBUS_SWAPCALL_ACK_OK "));
         m_u16State = FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_SWAPDBUSACK ;
         ETG_TRACE_USR2(("State change:   FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_SWAPDBUSACK"));
      }
      break ;



      default:
      {
         ETG_TRACE_USR4((" fc_phone_tclSMAcceptCall::vHandleEventInSwapDbusAckOrCallStatus Default. u16EventId:: %d",u16EventId));
      }
      break;
   }
}

/*******************************************************************************
 *
 * FUNCTION: vHandleEventInSwapCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMAcceptCall::vHandleEventInSwapCall(tU16 u16EventId)
{
   ETG_TRACE_USR4((" Entering  fc_phone_tclSMAcceptCall::vHandleEventInSwapCall with EventId %d",u16EventId));

   switch (u16EventId)
   {

   case FC_PHONE_SM_EVENT_DBUS_SWAPCALL_ACK_OK :
      {
         ETG_TRACE_USR3((" EVENT:: FC_PHONE_SM_EVENT_DBUS_SWAPCALL_ACK_OK "));
         //Post method result on dbus ack
         m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_SWAPCALL,m_poCallInstance);
      }
      //Break not required here as state has to be changed to routed.
   case FC_PHONE_SM_EVENT_CALLSTATUS_UPDATE :
      {
         ETG_TRACE_USR3(("   SENDING SWAPCALL MR to client"));
         m_u16State = FC_PHONE_SMACCEPTCALL_STATE_CALL_ROUTED ;
         ETG_TRACE_USR2(("State change:  FC_PHONE_SMACCEPTCALL_STATE_CALL_ROUTED"));
      }
      break ;
   default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMAcceptCall::vHandleEventInSwapCall  Default. u16EventId:: %d",u16EventId));
      }
      break;
   }




}

/*******************************************************************************
 *
 * FUNCTION: vHandleEventInReleaseAudioAndTransferAudio
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMAcceptCall::vHandleEventInReleaseAudioAndTransferAudio(tU16 u16EventId)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMAcceptCall::vHandleEventInReleaseAudioAndTransferAudio with EventId %d",u16EventId));

   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
      {
         ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_PHONE_REQUEST_OK"));

         //Update the audio channel status
         m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED ;
         m_poCallInstance->m_bUsingVehicleAudio = FALSE;
         ETG_TRACE_USR3(("  m_bUsingVehicleAudio = FALSE"));
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,\
               m_poCallInstance);
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);


         m_poSMManager->vRestoreToActiveCallInHandset(m_poCallInstance->m_u16Id);

      }
      break;

      case FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK:
      {

         ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK"));
         m_u16State = FC_PHONE_SMACCEPTCALL_STATE_CALL_ROUTED;
         ETG_TRACE_USR2(("State change:  FC_PHONE_SMACCEPTCALL_STATE_CALL_ROUTED"));
         m_poCallInstance->m_bUsingVehicleAudio = TRUE;
         ETG_TRACE_USR3(("  m_bUsingVehicleAudio = TRUE"));
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,\
               m_poCallInstance);
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);

      }
      break;


      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMAcceptCall::vHandleEventInReleaseAudioAndTransferAudio DEFAULT"));
      }
      break;
   }


}


/*******************************************************************************
 *
 * FUNCTION: vHandleEventInRoutingHandsetCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMAcceptCall::vHandleEventInRoutingHandsetCall(tU16 u16EventId)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMAcceptCall::vHandleEventInRoutingHandsetCall with EventId %d",u16EventId));

   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK:
      {
         ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK"));
         m_poSMManager->vRestoreToActiveCallInHandset(m_poCallInstance->m_u16Id);
      }
      break;


      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMAcceptCall::vHandleEventInRoutingHandsetCall DEFAULT"));
      }
      break;
   }
}


/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMAcceptCall::vAudioCallBack
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMAcceptCall::vAudioCallBack(tU16 u16AudioChannelId, tU16 u16RequestState)
{

   ETG_TRACE_USR4((" Entering fc_phone_tclSMAcceptCall::vAudioCallBack with AudioChannelId %d ",u16AudioChannelId));

   switch (u16AudioChannelId)
   {
      case FC_PHONE_AUDIOCHANNEL_INCOMINGRINGTONE:
      case FC_PHONE_AUDIOCHANNEL_ALERTTONE:
      {
         ETG_TRACE_USR3(("  EVENT : FC_PHONE_AUDIOCHANNEL_INCOMINGRINGTONE "));
         ETG_TRACE_USR3(("  EVENT : FC_PHONE_AUDIOCHANNEL_ALERTTONE "));

         if (FC_PHONE_AUDIOCHANNEL_GRANTED == u16RequestState)
         {
            ETG_TRACE_USR4(("  u16RequestState::FC_PHONE_AUDIOCHANNEL_GRANTED "));
            bProcessEvent(FC_PHONE_SM_EVENT_INCOMINGCALL_REQUEST_OK);

         }
         else
         {
            ETG_TRACE_USR4(("  u16RequestState::FC_PHONE_AUDIOCHANNEL_DENIED_SUSPENDED "));
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
            bProcessEvent(FC_PHONE_SM_EVENT_INCOMINGCALL_REQUEST_NOK);

         }

      }
      break;
      case FC_PHONE_AUDIOCHANNEL_PHONE:
      {
         ETG_TRACE_USR4(("  u16AudioChannelId::FC_PHONE_AUDIOCHANNEL_PHONE "));

         if (FC_PHONE_AUDIOCHANNEL_GRANTED == u16RequestState)
         {
            ETG_TRACE_USR4(("  u16RequestState::FC_PHONE_AUDIOCHANNEL_GRANTED "));
            bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);

         }
         else
         {
            ETG_TRACE_USR4(("  u16RequestState::FC_PHONE_AUDIOCHANNEL_DENIED_SUSPENDED "));
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
            bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK);
         }

      }
      break;
      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMAcceptCall::vAudioCallBack DEFAULT CASE : wrong u16AudioChannelId = %d",u16AudioChannelId));
      }
      break;
   }
}
/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMAcceptCall::vTimerCallBack
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMAcceptCall::vTimerCallBack(tU16 u16TimerId)
{

   //     (tVoid) u16TimerId ; //for removing warning
   ETG_TRACE_USR4((" Entering fc_phone_tclSMAcceptCall::vTimerCallBack with TimerID %d",u16TimerId));
   if (u16TimerId == FC_PHONE_CALLINSTANCE_TIMER_ID)
   {
      vIncrementTimer(m_poCallInstance);
      ETG_TRACE_USR4(("fc_phone_tclSMAcceptCall: calling vSendStatus"));
      m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, m_poCallInstance);
   }
   else
   {
      ETG_TRACE_USR4(("Invalid timerID(Not CallInstance)"));
   }
}
/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMAcceptCall::vNewCallStatus
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMAcceptCall::vNewCallStatus(const T_CallData* const prCallData, tU16 /*u16_callInstance*/)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMAcceptCall::vNewCallStatus  "));


   //FIX GMMY15-4487 Variables m_poAudioManager m_poCallInstance and prCallData were accessed without checking if they are NULL; which is wrong.
   if(prCallData && m_poCallInstance && m_poAudioManager)
   {
      vActOnCallStatusActive(prCallData);
      /* Send Call status notification and act on Call Status accordingly */
      switch (m_u16State)
      {
         case FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_SWAPDBUSACK_AND_CALLSTATUS :
         case FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_CALLSTATUS :
         case FC_PHONE_SMACCEPTCALL_STATE_CHANNEL_ACQUISITION_FAILED_WAIT_FOR_CS:
         {
            if((FC_PHONE_CALLINSTANCE_CALLSTATUS_IDLE != m_poCallInstance->m_u16CallStatusNotice) &&(PHONE_CALLSTATE_IDLE == prCallData->rCallStatus.u8CallState))
            {
               ETG_TRACE_USR4(("Call Status Came Idle while Swapping "));
               m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_SWAPCALL,m_poCallInstance);
               //For which Device CallStatus Comes

               /* Call got hung up at the receiver end,so delete the call Instance */
               m_u16State = FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIO_RELEASE_AND_INIT_IDLE ;
               ETG_TRACE_USR2(("State change: FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIO_RELEASE_AND_INIT_IDLE"));
               //release ringtone/Alert audio channel ,if in use
               if( FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_poCallInstance->m_u8AudioChannel)
               {
                  ETG_TRACE_USR3((" Requesting for release to audio manager"));
                  m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id, m_poCallInstance->m_u8AudioChannel,vAudioCallBackAcceptCall);
                  m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
               }
               else
               {
                  //No audio channel engaged, so going to next step by faking FC_PHONE_SM_EVENT_PHONE_REQUEST_OK
                  bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
               }
            }
            else
            {
               ETG_TRACE_USR1(("UPDATING CALL STATUS TO Cleint "));
               vCopyCallData(prCallData);
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
               bProcessEvent(FC_PHONE_SM_EVENT_CALLSTATUS_UPDATE);
            }
         }
         break ;
         case FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIOACTIVATED_WAIT_FOR_DBUS_CONNECT:
            {
               ETG_TRACE_USR4(("FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIOACTIVATED_WAIT_FOR_DBUS_CONNECT "));
               if((FC_PHONE_CALLINSTANCE_CALLSTATUS_RINGTONE == m_poCallInstance->m_u16CallStatusNotice) && ((PHONE_CALLSTATE_ACTIVE == prCallData->rCallStatus.u8CallState)
                  ||(PHONE_CALLSTATE_HELD == prCallData->rCallStatus.u8CallState)/* if callstatus is received as Held from phone device after hf-incomingcallact*/)
                  )
               {
                  ETG_TRACE_USR4(("Call got active  "));
                  if(m_bSrcActMethodRxd)  /* althuh call is active, check if response is received from AV/ARL  */
                  {
                     //post MR to ARL
                     (fc_phone_tclApp::m_poMainAppInstance)->m_poPhoneAudioRouting->vPostSrcActivityMRToARL(TRUE);

                     m_bSrcActMethodRxd = FALSE;
                  }
               }
               if((FC_PHONE_CALLINSTANCE_CALLSTATUS_IDLE != m_poCallInstance->m_u16CallStatusNotice) &&(PHONE_CALLSTATE_IDLE == prCallData->rCallStatus.u8CallState))
               {
                  m_u16State = FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIO_RELEASE_AND_INIT_IDLE ;
                  bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
                  if((fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->m_bAcceptMethodStartFlag == TRUE)
                  {
                     m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOTAVAILABLE;
                     m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_ACCEPTCALL,m_poCallInstance);
                  }
                  (fc_phone_tclApp::m_poMainAppInstance)->m_poPhoneAudioRouting->vPostSrcActivityMRToARL(FALSE);
                  m_bSrcActMethodRxd = FALSE;
               }
               else
               {
               vCopyCallData(prCallData);
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
             }
            }
            break;
         default:
         {
            ETG_TRACE_USR4((" fc_phone_tclSMAcceptCall::vNewCallStatus  IN DEFAULT"));
            if((FC_PHONE_CALLINSTANCE_CALLSTATUS_IDLE != m_poCallInstance->m_u16CallStatusNotice) &&(PHONE_CALLSTATE_IDLE == prCallData->rCallStatus.u8CallState))
            {
#ifdef PHONE_WAITINGMODE
               fc_phone_tclWaitingMode* poWaitingMode = fc_phone_tclWaitingMode::poGetInstance();
               tenFC_Phone_WaitingModeState enWaitingModeState = poWaitingMode->enGetWaitingModeState();

               //Both calls/single call came to an end during waiting mode
               if ((FC_PHONE_WAITINGMODE_IDLE != enWaitingModeState) && (0 == prCallData->rCallStatus.u8CallTotal))
               {
                  poWaitingMode->bProcessEvent(FC_PHONE_WAITING_MODE_EVENT_END_OF_ACTIVE_CALLS);
               }
#endif
               /* Call got hung up at the receiver end,so delete the call Instance */
               //m_u16State = FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIO_RELEASE_AND_INIT_IDLE ;
               //release ringtone/Alert audio channel ,if in use
               if( FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_poCallInstance->m_u8AudioChannel)
               {
                  ETG_TRACE_USR3((" Requesting for release to audio manager"));
                  m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id, m_poCallInstance->m_u8AudioChannel,vAudioCallBackAcceptCall);
               }

               if((fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->m_bAcceptMethodStartFlag == TRUE)
               {
                  m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
                  m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_ACCEPTCALL,m_poCallInstance);
               }
               //Update the audio channel status
               m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED ;
               m_poCallInstance->m_bUsingVehicleAudio = FALSE;
               ETG_TRACE_USR3(("  m_bUsingVehicleAudio = FALSE"));
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
               //to stop timer if active
               vStopTimer();
               vCancel();
               m_poCallInstance->vInit();
               //send status to client : now status is IDLE
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
               m_poSMManager->vSMFinished(m_poCallInstance->m_u16Id);
            }
            else
            {
               vCopyCallData(prCallData);
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
            }
         }
         break;
      }
   }
}


/*******************************************************************************
 *
 * FUNCTION: vProcessAudioSignal
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMAcceptCall::vProcessAudioSignal()
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMAcceptCall::vProcessAudioSignal "));
   tU8 u8SCOConnectionStatus = FC_PHONE_DBUS_SCO_CONN_FAILED;
   fc_phone_tclClientHandler_BTSettings *p_clientHndler_bluetooth = (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerBTSettings;
   u8SCOConnectionStatus = p_clientHndler_bluetooth->vGetSCOConnectionStatus(const_cast<tChar *> (fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId))); //CMG3G-4847 - To solve Lint
   ETG_TRACE_USR4(("  fc_phone_tclSMAcceptCall::u8SCOConnectionStatus = %d ",u8SCOConnectionStatus));
   if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_DISCONNECTED)
   {
      ETG_TRACE_USR4(("  fc_phone_tclSMAcceptCall Receives HfReleaseAudio Signal ::FC_PHONE_CB_FID_SCOCONNECTIONSTATUS "));
      m_u16State_while_TransferAudio = FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIO_RELEASE_ON_TRANSFERCALLREQ_FROM_PHONE;
      ETG_TRACE_USR3((" m_poCallInstance->m_u16CallStatusNotice %d",m_poCallInstance->m_u16CallStatusNotice));
      if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_poCallInstance->m_u8AudioChannel)
      {
#ifdef PHONE_WAITINGMODE
         fc_phone_tclWaitingMode* poWaitingMode = fc_phone_tclWaitingMode::poGetInstance();
         tenFC_Phone_WaitingModeState enWaitingModeState = poWaitingMode->enGetWaitingModeState();

         //During waiting mode, phone audio source will not be in use (audio channel attributes has to be updated)
         if ((FC_PHONE_WAITINGMODE_ACTIVE == enWaitingModeState) && (FC_PHONE_AUDIOCHANNEL_PHONE == m_poCallInstance->m_u8AudioChannel))
         {
            m_poAudioManager->vUpdateChannelAttributes(m_poCallInstance->m_u8AudioChannel, FC_PHONE_REQUESTTYPE_RELEASE);
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
            bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
         }
         else
         {
#endif
         ETG_TRACE_USR3((" Requesting for release to audio manager"));
         m_poAudioManager->s32ReleaseRequest( m_poCallInstance->m_u16Id,m_poCallInstance->m_u8AudioChannel,vAudioCallBackAcceptCall);
         m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
#ifdef PHONE_WAITINGMODE
         }
#endif
      }
      else
      {
         bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
      }
   }
   else if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_ESTABLISHED)
   {
      ETG_TRACE_USR4(("  fc_phone_tclSMAcceptCall Receives HfSetUpAudio Signal ::FC_PHONE_CB_FID_SCOCONNECTIONSTATUS "));

      if(FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_RINGTONEACT_TOHANDLE_WAITINGMODE == m_u16State)
      {
         ETG_TRACE_USR3((" LC_Phone channel acquisition is in Progress. And FC_Phone is waiting to acquire WaitingMode channel."));
         return;
      }

      //Fix for PSARCC30-1590 but accept call is done from HMI initially.
      //Phone channel acquisition failed during Acceptcall_MS and hence ME is sent.
      //But the call is accepted from Phone and SCO is established before receiving Callstatus.
      //Hence disconnecting this SCO.
      else if(FC_PHONE_SMACCEPTCALL_STATE_CHANNEL_ACQUISITION_FAILED_WAIT_FOR_CS == m_u16State)
      {
         ETG_TRACE_USR3(("Channel acquisition failed already. Hence SCO should be released"));
         m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId), FC_PHONE_CALLTRANSFER_FROMHANSFREE_TOHANDSET);
         return;
      }

      m_u16State_while_TransferAudio = FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIO_ACQUISITION_ON_TRANSFERCALLREQ_FROM_PHONE;
      if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED == m_poCallInstance->m_u8AudioChannel)
      {
         m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
         ETG_TRACE_USR3((" Requesting for acquiring channel to audio manager:: AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE"));
         m_poAudioManager->s32GetRequest( m_poCallInstance->m_u16Id,m_poCallInstance->m_u8AudioChannel,vAudioCallBackAcceptCall);
      }
      else
      {
         //as channel aquisition is still in progress so no need to post back to "wait for audio state" and change state to "routed" as
         // Wait for audio state handles set play MR which is not handled in AUdio Routed state.

         m_poCallInstance->m_bUsingVehicleAudio = TRUE;
         ETG_TRACE_USR3(("  m_bUsingVehicleAudio = TRUE "));
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);

         if(m_u16State != FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIOACTIVATED_WAIT_FOR_DBUS_CONNECT)
         {
            bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
         }
      }
   }
}
/*******************************************************************************
 *
 * FUNCTION: vProcessOnDynamicDisconnect
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMAcceptCall::vProcessOnDynamicDisconnect(tU16 u16EventId)
{
   ETG_TRACE_USR4(("Entering fc_phone_tclSMIdle::vProcessOnDynamicDisconnect with u16EventId %d",u16EventId));
   //release Audio channels

   switch(u16EventId)
   {

      case FC_PHONE_SM_EVENT_SLC_OFF:
      {
         if ( FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_poCallInstance->m_u8AudioChannel)
         {
            ETG_TRACE_USR3((" EVENT :: RELEASING Audio Channel "));
            //if any audio channel aquired, release it
            //m_u16State = FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_SLC_OFF_RESPONSE;
            ETG_TRACE_USR3((" Requesting for release to audio manager"));
            m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id, m_poCallInstance->m_u8AudioChannel, vAudioCallBackAcceptCall);
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
         }
         //to stop timer if active
         vStopTimer();

         vCancel();

            ETG_TRACE_USR4((" No audio channel is aquired, releasing instance "));
            //if any audio channel is not aquired , got to idle state and send the status to client

            //m_bUsingVehicleAudio false , and stop timer if running
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
            m_poCallInstance->m_bUsingVehicleAudio = FALSE;
            ETG_TRACE_USR3(("  m_bUsingVehicleAudio = FALSE"));
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,\
                  m_poCallInstance);

            if(TRUE == m_bTimerRunning)
            {
               m_poTimer->s32Stop(m_poCallInstance->m_u16TimerId); // Bugfix for GMMY16-17241
               m_bTimerRunning = FALSE;
               ETG_TRACE_USR3((" m_bTimerRunning = FALSE "));
            }

            m_poCallInstance->vInit();
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,\
                  m_poCallInstance);
            //send SLC status to client
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_SLC,m_poCallInstance);
            m_poSMManager->vSMFinished(m_poCallInstance->m_u16Id);
      }
      break;
      default:
      {
         ETG_TRACE_USR4((" IN DEFAULT : vProcessOnDynamicDisconnect: wrong u16EventId= %d ",u16EventId));
      }
      break;
   }
}


/*******************************************************************************
 *
 * FUNCTION: vHandleEventInReleasingAudioAndReInitIdle
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMAcceptCall::vHandleEventInReleasingAudioAndReInitIdle(tU16 u16EventId)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMAcceptCall::vHandleEventInReleasingAudioAndReinitIdle with  EventId %d ",u16EventId));

   switch (u16EventId)
   {

      case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
      {

         ETG_TRACE_USR3((" EVENT : OR FC_PHONE_SM_EVENT_PHONE_REQUEST_OK"));

         //Update the audio channel status
         m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED ;
         m_poCallInstance->m_bUsingVehicleAudio = FALSE;
         ETG_TRACE_USR3(("  m_bUsingVehicleAudio = FALSE"));
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,
               m_poCallInstance);

         //to stop timer if active
         vStopTimer();

         vCancel();

         m_poCallInstance->vInit();
         //send status to client : now status is IDLE
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,\
               m_poCallInstance);
         m_poSMManager->vSMFinished(m_poCallInstance->m_u16Id);
      }
      break;


      case FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK:
      {


         ETG_TRACE_USR3((" EVENT :OR  FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK"));
         /* TO DO:Transfer the call to handset */
         m_poCallInstance->m_bUsingVehicleAudio = FALSE;
         ETG_TRACE_USR3(("  m_bUsingVehicleAudio = FALSE"));
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,
               m_poCallInstance);
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);

      }
      break;


      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMAcceptCall::vHandleEventInNoSignalResponse  DEFAULT"));
      }
      break;
   }

}

/*******************************************************************************
 *
 * FUNCTION: vStartTimerAndSendAck
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMAcceptCall::vStartTimerAndSendAck()
{
   ETG_TRACE_USR4(("fc_phone_tclSMAcceptCall::vStartTimerAndSendAck"));
      /* Send Accept Call accepted status, send method result */

   //AcceptCall_MR should only be sent when there is a AcceptCall_MS
   if ((fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->m_bAcceptMethodStartFlag == TRUE)
   {
      m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
      m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_ACCEPTCALL, m_poCallInstance);
   }

      if (FC_PHONE_CALLINSTANCE_INCOMINGCALLEVENT_RINGING == m_poCallInstance->m_u16IncomingCallEvent)
      {
         ETG_TRACE_USR4((" Sending u16IncomingCallEvent IDLE in INCOMING CALL STATUS to HMI "));

         m_poCallInstance->m_u16IncomingCallEvent = FC_PHONE_CALLINSTANCE_INCOMINGCALLEVENT_IDLE;
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_INCOMINGCALL, m_poCallInstance);
      }
   if (!m_u8WaitForAudioResponse)
   {
      m_u16State = FC_PHONE_SMACCEPTCALL_STATE_CALL_ROUTED;
      ETG_TRACE_USR2(("State change: FC_PHONE_SMACCEPTCALL_STATE_CALL_ROUTED"));
   }

   m_bTimerRunning = TRUE;
   ETG_TRACE_USR3((" m_bTimerRunning = TRUE "));
   m_poCallInstance->m_u16TimerId = FC_PHONE_CALLINSTANCE_TIMER_ID;
   m_poTimer->s32Start(m_poCallInstance->m_u16TimerId, FC_PHONE_ONE_SECOND, vCallInstanceTimerCallBack);
}

/*******************************************************************************
 *
 * FUNCTION: vActOnCallStatusActive
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMAcceptCall::vActOnCallStatusActive(const T_CallData* const prCallData)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMAcceptCall::vActOnCallStatusActive  "));
   if ((FC_PHONE_CALLINSTANCE_CALLSTATUS_IDLE != m_poCallInstance->m_u16CallStatusNotice)
         &&((PHONE_CALLSTATE_ACTIVE == prCallData->rCallStatus.u8CallState)
         ||(PHONE_CALLSTATE_HELD == prCallData->rCallStatus.u8CallState)))
   {
      if (!m_bTimerRunning)
      {
         vCallStatusRxdActive();
      }
   }
}
/*******************************************************************************
 *
 * FUNCTION: vHandleDbusError
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMAcceptCall::vHandleDbusError(tU16 u16DbusAckType,tChar Code)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMAcceptCall::vHandleDbusError "));

   switch(u16DbusAckType)
   {
      case FC_PHONE_CB_FID_ACCEPTCALL:
      {
         if(m_u16State == FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_CONNECT_FROM_BT || m_u16State == FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIOACTIVATED_WAIT_FOR_DBUS_CONNECT)
         {
            ETG_TRACE_USR4((" FC_PHONE_CB_FID_ACCEPTCALL m_u16State %d",m_u16State));
            vAssignErrorCode(Code);
#ifdef PHONE_WAITINGMODE
            fc_phone_tclWaitingMode* poWaitingMode = fc_phone_tclWaitingMode::poGetInstance();
            tenFC_Phone_WaitingModeState enWaitingModeState = poWaitingMode->enGetWaitingModeState();

            if (FC_PHONE_WAITINGMODE_START_IN_PROGRESS == enWaitingModeState)
            {
               poWaitingMode->bProcessEvent(FC_PHONE_WAITING_MODE_EVENT_ACCEPTCALL_ERROR);
            }
            else
            {
#endif
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_ACCEPTCALL,m_poCallInstance);
            if(m_u16State == FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_CONNECT_FROM_BT)
            {
            if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_poCallInstance->m_u8AudioChannel)
            {
               ETG_TRACE_USR3((" Requesting for release to audio manager"));
               m_poAudioManager->s32ReleaseRequest( m_poCallInstance->m_u16Id,m_poCallInstance->m_u8AudioChannel,vAudioCallBackAcceptCall);
               }
            }
            else
            {
               (fc_phone_tclApp::m_poMainAppInstance)->m_poPhoneAudioRouting->vPostSrcActivityMRToARL(FALSE);
            }
#ifdef PHONE_WAITINGMODE
            }
#endif
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED ;
            m_poCallInstance->m_bUsingVehicleAudio = FALSE;
            ETG_TRACE_USR3(("  m_bUsingVehicleAudio = FALSE"));
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
            //to stop timer if active
            vStopTimer();
            vCancel();
            //m_poCallInstance->vInit();
            //send status to client : now status is IDLE
            m_poSMManager->vSMFinished(m_poCallInstance->m_u16Id);
         }
         else
         {
            ETG_TRACE_USR4((" Accept Call is not serviced in Other States"));
         }
      }
      break;
      case FC_PHONE_CB_FID_HOLDCALL:
      case FC_PHONE_CB_FID_HOLDINCOMINGCALL:
      {
         if(m_u16State == FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_HOLDCALL)
         {
            ETG_TRACE_USR4((" FC_PHONE_CB_FID_HOLDCALL "));
            vAssignErrorCode(Code);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_HOLDCALL,m_poCallInstance);
            m_u16State = FC_PHONE_SMACCEPTCALL_STATE_CALL_ROUTED;
            ETG_TRACE_USR2(("State change: FC_PHONE_SMACCEPTCALL_STATE_CALL_ROUTED"));
         }
         else
         {
            ETG_TRACE_USR4((" Hold Call is not serviced in Other States"));
         }
      }
      break;
      case FC_PHONE_CB_FID_RESUMECALL:
      {
         if(m_u16State == FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_RESUMECALL)
         {
            ETG_TRACE_USR4((" FC_PHONE_CB_FID_RESUMECALL "));
            vAssignErrorCode(Code);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_RESUMECALL,m_poCallInstance);
            m_u16State = FC_PHONE_SMACCEPTCALL_STATE_CALL_ROUTED;
            ETG_TRACE_USR2(("State change: FC_PHONE_SMACCEPTCALL_STATE_CALL_ROUTED"));
         }
         else
         {
            ETG_TRACE_USR4((" Resume Call is not serviced in Other States"));
         }
      }
      break;
      case FC_PHONE_CB_FID_SWAPCALL:
      {
         if((m_u16State == FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_SWAPDBUSACK_AND_CALLSTATUS) ||
               (m_u16State == FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_SWAPDBUSACK))
         {
            ETG_TRACE_USR4((" FC_PHONE_CB_FID_SWAPCALL "));
            vAssignErrorCode(Code);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_SWAPCALL,m_poCallInstance);
            m_u16State = FC_PHONE_SMACCEPTCALL_STATE_CALL_ROUTED;
            ETG_TRACE_USR2(("State change: FC_PHONE_SMACCEPTCALL_STATE_CALL_ROUTED"));
         }
         else
         {
            ETG_TRACE_USR4((" Swap Call is not serviced in Other States"));
         }
      }
      break;
      case FC_PHONE_CB_FID_AUDIOTRANSFER:
      {
         ETG_TRACE_USR4((" FC_PHONE_CB_FID_AUDIOTRANSFER "));
         vAssignErrorCode(Code);
         //One in few states its required// TODo yet to filter
         if(m_bTransferCallToVehicleRequest == TRUE)
         {
            m_bTransferCallToVehicleRequest = FALSE;
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSFREE,m_poCallInstance);
         }
         /*It should not come to this case*/
         if(m_u16State == FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIOTRANSFER_ONACCEPT)
         {
            ETG_TRACE_USR4((" Failure of audio transfer of another call"));
            vCancel();
            m_poSMManager->vSMFinished(m_poCallInstance->m_u16Id);
            break;
         }
         if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED == m_poCallInstance->m_u8AudioChannel)
         {
            ETG_TRACE_USR3((" Requesting for acquiring channel to audio manager"));
            m_poAudioManager->s32GetRequest(m_poCallInstance->m_u16Id,FC_PHONE_AUDIOCHANNEL_PHONE,vAudioCallBackAcceptCall);
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
            ETG_TRACE_USR3((" AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE"));
            m_poCallInstance->m_bUsingVehicleAudio = TRUE;
            ETG_TRACE_USR3(("  m_bUsingVehicleAudio = TRUE"));
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
         }
         m_u16State = FC_PHONE_SMACCEPTCALL_STATE_CALL_ROUTED;
         ETG_TRACE_USR2(("State change: FC_PHONE_SMACCEPTCALL_STATE_CALL_ROUTED"));
      }
      break;
      case FC_PHONE_CB_FID_SENDDTMF:
      {
         //Targeted to SM hence dont care of States
         ETG_TRACE_USR4((" FC_PHONE_CB_FID_SENDDTMF "));
         vAssignErrorCode(Code);
         (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vSetDtmfStatus(FALSE);
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_PLAYDTMF,m_poCallInstance);
         m_u16State = FC_PHONE_SMACCEPTCALL_STATE_CALL_ROUTED;
         ETG_TRACE_USR2(("State change: FC_PHONE_SMACCEPTCALL_STATE_CALL_ROUTED"));
      }
      break;
      default:
      {
         ETG_TRACE_USR4((" fc_phone_tclSMAcceptCall::vHandleDbusError This Event ID is not supported yet"));
         break;
      }
   }
}

/*******************************************************************************
 *
 * FUNCTION: vAssignErrorCode
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMAcceptCall::vAssignErrorCode(tChar Code)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMAcceptCall::vAssignErrorCode "));
   switch(Code)
   {
      case FC_PHONE_DBUS_ERRORCODE_STATE_ERROR:
      {
         ETG_TRACE_USR4((" FC_PHONE_DBUS_ERRORCODE_STATE_ERROR"));
         m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACK_STATE_ERROR;
      }
      break;
      case FC_PHONE_DBUS_ERRORCODE_OPERATION_NOT_ALLOWED:
      case FC_PHONE_DBUS_ERRORCODE_OPERATION_NOT_SUPPORTED:
      {
         ETG_TRACE_USR4(("FC_PHONE_DBUS_ERRORCODE_OPERATION_NOT_ALLOWED:       FC_PHONE_DBUS_ERRORCODE_OPERATION_NOT_SUPPORTED:"));
         m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOTAVAILABLE;
      }
      break;
      default:
      {
         ETG_TRACE_USR4((" IN DEFAULT This Error Code [0x%x] is not supported yet",Code) );
         m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
      }
      break;
   }
}

/*******************************************************************************
 *
 * FUNCTION: u16GetSMID
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tU16 fc_phone_tclSMAcceptCall::u16GetSMID()
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMAcceptCall::u16GetSMID "));
   return m_u16SMID;
}

/*******************************************************************************
 *
 * FUNCTION: vSetDtmfLength
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMAcceptCall::vSetDtmfLength(tU16 u16DtmfLength)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMAcceptCall::vSetDtmfLength "));
   m_u16DTMFCharLength = u16DtmfLength;
}

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMAcceptCall::vHandleEventInAudioTransferOnAccept
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMAcceptCall::vHandleEventInAudioTransferOnAccept(tU16 u16EventId)
{    
   ETG_TRACE_USR4((" Entering fc_phone_tclSMAcceptCall : vHandleEventInAudioTransferOnAccept with eventId %d ",u16EventId));

   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK"));

         /* Request to Deactivation of Incoming call Channel */
         m_u16State = FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AM_RESPONSE_DEACTIVATE_RINGING_INCOMINGCALL;
         ETG_TRACE_USR2(("State change: FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AM_RESPONSE_DEACTIVATE_RINGING_INCOMINGCALL"));
		 //GMMY16-22886 since alert tone channel is released after playing the file, there is a chance that already allocated LC_Phone might get released.
         if((FC_PHONE_AUDIOCHANNEL_ALERTTONE == m_poCallInstance->m_u8AudioChannel) || (FC_PHONE_AUDIOCHANNEL_INCOMINGRINGTONE == m_poCallInstance->m_u8AudioChannel))
         {
            ETG_TRACE_USR3((" Requesting for release to audio manager"));
            m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id,m_poCallInstance->m_u8AudioChannel,vAudioCallBackAcceptCall);
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
         }
         else
         {
            ETG_TRACE_ERR(("ERROR :: Any channel Ringtone/Alert is not aquired, faking the ACK"));
            bProcessEvent(FC_PHONE_SM_EVENT_INCOMINGCALL_REQUEST_OK);
         }
      }
      break;
      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMAcceptCall::vHandleEventInAudioTransferOnAccept DEFAULT : Wrong Event ID u16EventId: %d",u16EventId));
      }
      break;
   }
}

/*******************************************************************************
 *
 * FUNCTION: vTransferCallOrReleaseRingtone
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMAcceptCall::vTransferCallOrReleaseRingtone()
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMAcceptCall::vTransferCallOrReleaseRingtone "));

   //If any ActiveCallInHandset is going on ,transfer it to Vehicle
   if (fc_phone_tclCallManager::m_u16Count == 2)
   {
      //Check whether Other call uses Vehicle Audio or not.
      tU8 u8SCOConnectionStatus = FC_PHONE_DBUS_SCO_CONN_FAILED;
      fc_phone_tclClientHandler_BTSettings *p_clientHndler_bluetooth = (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerBTSettings;
      u8SCOConnectionStatus = p_clientHndler_bluetooth->vGetSCOConnectionStatus(const_cast<tChar *> (fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId))); //CMG3G-4847 - To solve Lint
      if (u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_DISCONNECTED)
      {
         ETG_TRACE_USR4(("fc_phone_tclSMAcceptCall::Other Call Doesnt Use Vehicle audio "));
         fc_phone_tclCallInstance* pCallInstance = (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vGetCallInstanceOfOtherSM(m_poCallInstance);
         if (pCallInstance)
         {
            m_u16State = FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIOTRANSFER_ONACCEPT;
            ETG_TRACE_USR2(("State change: FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIOTRANSFER_ONACCEPT"));
            m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId), FC_PHONE_CALLTRANSFER_FROMHANDSET_TOHANSFREE);
            fc_phone_tclCallInstance *poCallInstance[FC_PHONE_MAX_CALLINSTANCES];
            poCallInstance[0] = pCallInstance;
            poCallInstance[1] = NULLPTR;
            m_poSMManager->vRevertStateMachine(poCallInstance);
            return;
         }
         else
         {
            ETG_TRACE_USR4(("fc_phone_tclSMAcceptCall::Couldnt Find Call instance of another SM"));
         }
      }
      else
      {
         ETG_TRACE_USR4(("FC_PHONE_DBUS_SCO_CONN_ESTABLISHED"));
      }
   }



   /* Request to Deactivation of Incoming call Channel */
   m_u16State = FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AM_RESPONSE_DEACTIVATE_RINGING_INCOMINGCALL;
   ETG_TRACE_USR2(("State change: FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AM_RESPONSE_DEACTIVATE_RINGING_INCOMINGCALL"));

#ifdef PHONE_WAITINGMODE
   fc_phone_tclWaitingMode* poWaitingMode = fc_phone_tclWaitingMode::poGetInstance();
   tenFC_Phone_WaitingModeState enWaitingModeState = poWaitingMode->enGetWaitingModeState();

   //During waiting mode, phone audio source will not be in use (audio channel attributes has to be updated)
   if (FC_PHONE_WAITINGMODE_START_IN_PROGRESS == enWaitingModeState)
   {
      if(false == (fc_phone_tclApp::m_poMainAppInstance)->m_poAudioManager->bIsPhoneOrRingtoneChannelAcquistionIdle())
      {
         m_u16State = FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_RINGTONEACT_TOHANDLE_WAITINGMODE;
      }
      else
      {
         vProcessWaitingModeRequest();
      }
   }
   else
   {
#endif
   fc_phone_tclClientHandler_BTSettings *p_clientHndler_bluetooth = (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerBTSettings;
      tU16 bInBandRingtone = p_clientHndler_bluetooth->vIsInBandRingtone();

   if((bInBandRingtone && (FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_poCallInstance->m_u8AudioChannel)) && FALSE == p_clientHndler_bluetooth->bIsSuppressRingtoneEnabled())
   {
      if(FALSE ==  m_poCallInstance->m_bcallWaitingState)
      {
         if(true == m_poAudioManager->bIsPhoneOrRingtoneChannelAcquistionIdle())
         {
            // allocation for the first call hence bypass the state as LC_Phone is already acquired.
            ETG_TRACE_ERR(("For InbandRingtone ringtone"));
            bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
         }
         // RTC-716807: PHONE channel is requested in Idle SM and waiting for the AUDIO update.
         // Hence changing the state to FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIOACTIVATED
         // and wait for the AUDIO update.
         else
         {
            if(FC_PHONE_AUDIOCHANNEL_PHONE == m_poCallInstance->m_u8AudioChannel)
            {
               m_u16State = FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIOACTIVATED;
               ETG_TRACE_USR2(("State change: FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIOACTIVATED"));
            }
         }
      }
      else
      {
          // allocation for the second call hence release ALERT-TONE channel
         if(FC_PHONE_AUDIOCHANNEL_ALERTTONE == m_poCallInstance->m_u8AudioChannel)
         {
            ETG_TRACE_USR3((" Requesting for release alert tone"));
            m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id,m_poCallInstance->m_u8AudioChannel,vAudioCallBackAcceptCall);
         }
         else
         {
            bProcessEvent(FC_PHONE_SM_EVENT_ALERT_REQUEST_OK);
         }
      }
   }
   else
   {
      if(FALSE ==  m_poCallInstance->m_bcallWaitingState)
      {
         m_u8WaitForAudioResponse = TRUE;
         ETG_TRACE_USR2(("m_u8WaitForAudioResponse = TRUE"));
      }

      // 2HFP- Passive Device- Accept call. Hence the LC_Phone channel will be already with FC_Phone
      if(FC_PHONE_AUDIOCHANNEL_PHONE == m_poCallInstance->m_u8AudioChannel)
      {
         ETG_TRACE_USR3(("LC_Phone channel is already acquired (Accept for Passive Device when Active call in Active device)"));
         m_u16State = FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIOACTIVATED;
         //NCG3D-159150 Hold call for passive device
         m_u8WaitForAudioResponse = FALSE;
         ETG_TRACE_USR2(("m_u8WaitForAudioResponse = FALSE"));

         bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
      }
      else if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_poCallInstance->m_u8AudioChannel)
      {
         ETG_TRACE_USR3((" Requesting for release to BT"));
         m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id,m_poCallInstance->m_u8AudioChannel,vAudioCallBackAcceptCall);
      }
      else
      {
         bProcessEvent(FC_PHONE_SM_EVENT_INCOMINGCALL_REQUEST_OK);
      }
   }
#ifdef PHONE_WAITINGMODE
   }
#endif
}

#ifdef PHONE_WAITINGMODE
tVoid fc_phone_tclSMAcceptCall::vProcessWaitingModeRequest()
{
   ETG_TRACE_USR4(("fc_phone_tclSMAcceptCall::vProcessWaitingModeRequest entered"));

   if(FC_PHONE_AUDIOCHANNEL_INCOMINGRINGTONE == m_poCallInstance->m_u8AudioChannel)
   {
      (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerBTSettings->vStopRingtone();
      m_poAudioManager->vUpdateChannelAttributes(m_poCallInstance->m_u8AudioChannel, FC_PHONE_REQUESTTYPE_RELEASE);
   }
   else if((FC_PHONE_AUDIOCHANNEL_PHONE == m_poCallInstance->m_u8AudioChannel)
         || (FC_PHONE_AUDIOCHANNEL_ALERTTONE == m_poCallInstance->m_u8AudioChannel))
   {
      //Phone channel will be released on acquisition of PhoneWaitChannel
      //Alert tone not supported in G3G, both get/release requests can be bypassed
      m_poAudioManager->vUpdateChannelAttributes(m_poCallInstance->m_u8AudioChannel, FC_PHONE_REQUESTTYPE_RELEASE);
   }

   if (FALSE == ((fc_phone_tclApp::m_poMainAppInstance)->m_poPhoneAudioRouting->vTriggerPhoneAudioAllocation(
         FC_PHONE_AUDIOCHANNEL_PHONEWAIT)))
   {
      ETG_TRACE_ERR(("Audio Route request (PhoneWait source) posting failed!"));

      fc_phone_tclWaitingMode* poWaitingMode = fc_phone_tclWaitingMode::poGetInstance();
      poWaitingMode->bProcessEvent(FC_PHONE_WAITING_MODE_EVENT_PHONEWAIT_SRC_ROUTING_FAILED);

      if(FC_PHONE_AUDIOCHANNEL_PHONE == m_poCallInstance->m_u8AudioChannel)
      {
         m_poAudioManager->vUpdateChannelAttributes(m_poCallInstance->m_u8AudioChannel, FC_PHONE_REQUESTTYPE_GET);
      }
      //If this ever happens, then update channel attributes and Transfer call to handset
   }
   else
   {
      /* Fix for PSARCCB-7309. If the incoming call is put in waiting mode the WAITING MODE CHANNEL is acquired
       * and since there is no seperate attribute maintained for PHONE_WAIT channel, update the channel attribute
       * as PHONE channel instead.
       */
      ETG_TRACE_USR2((" STATE :: FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_SRC_ON_FOR_WAITMODE "));
      m_u16State = FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_SRC_ON_FOR_WAITMODE;
      m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
   }
}
#endif

/*******************************************************************************
 *
 * FUNCTION: vCallStatusRxdActive
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMAcceptCall::vCallStatusRxdActive()
{
   ETG_TRACE_USR4((" vCallStatusRxdActive "));
   switch(m_u16State)
   {  
      case FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AM_RESPONSE_DEACTIVATE_RINGING_INCOMINGCALL:
      {
         ETG_TRACE_USR2((" STATE :: FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AM_RESPONSE_DEACTIVATE_RINGING_INCOMINGCALL "));
         m_poCallInstance->m_bUsingVehicleAudio = FALSE; 
         ETG_TRACE_USR3(("  m_bUsingVehicleAudio = FALSE "));
         //If hfsetup audio is received before complete processing of Incoming ringtone/alert tone then LC_Phone channel will be allocated
         //so when method result is received for incoming ringtone / alert tone if m_u8AudioChannel is set to default value then request for LC_Phone channel will be posted again

         if(FC_PHONE_AUDIOCHANNEL_ALERTTONE == m_poCallInstance->m_u8AudioChannel || FC_PHONE_AUDIOCHANNEL_INCOMINGRINGTONE == m_poCallInstance->m_u8AudioChannel )
         {
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
         }
         if(m_u8WaitForAudioResponse)
         {
            m_u16State = FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIOACTIVATED_WAIT_FOR_DBUS_CONNECT;
         }
      }
      break;
      case FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIOACTIVATED_WAIT_FOR_SRCACTIVITY_RESPONSE:
         {
         //audio requested ... and is in processing,, set play  MR not yet received. call status active
          // wait for setpay mr.. post src activity mr

         ETG_TRACE_USR2((" STATE :: FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIOACTIVATED_WAIT_FOR_SRCACTIVITY_RESPONSE "));
         m_u16State = FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIOACTIVATED_WAIT_FOR_DBUS_CONNECT;
      }
      break;

      case FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIOACTIVATED :
      {
         ETG_TRACE_USR2((" STATE :: FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIOACTIVATED "));
         //vHandleEventInVoiceActivated(u16EventId);
      }
      break;
      case FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_CONNECT_FROM_BT:
      {
         ETG_TRACE_USR2((" STATE :: FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_CONNECT_FROM_BT "));
         //vHandleEventInAcceptBTInCall(u16EventId);
      }
      break;
      default:
         break;
   }

   if((fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->m_bAcceptMethodStartFlag == TRUE)
   {
      /* Send Accept Call accepted status, send method result */
      m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
      m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_ACCEPTCALL,m_poCallInstance);
   }

   if(FC_PHONE_CALLINSTANCE_INCOMINGCALLEVENT_RINGING == m_poCallInstance->m_u16IncomingCallEvent)
   {
      ETG_TRACE_USR4((" Sending u16IncomingCallEvent IDLE in INCOMING CALL STATUS to HMI "));

      m_poCallInstance->m_u16IncomingCallEvent = FC_PHONE_CALLINSTANCE_INCOMINGCALLEVENT_IDLE;
      m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_INCOMINGCALL, m_poCallInstance);
   }
   if(!m_u8WaitForAudioResponse)
   {
      m_u16State = FC_PHONE_SMACCEPTCALL_STATE_CALL_ROUTED;
   }

   if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED == m_poCallInstance->m_u8AudioChannel)
   {
      m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
      ETG_TRACE_USR3((" Requesting for acquiring channel to audio manager:: AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE"));
      m_poAudioManager->s32GetRequest(m_poCallInstance->m_u16Id,FC_PHONE_AUDIOCHANNEL_PHONE,vAudioCallBackAcceptCall);
   }
   else
   {
      if(!m_u8WaitForAudioResponse)
      {
         bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
      }
   }

   ETG_TRACE_USR2(("State change: FC_PHONE_SMACCEPTCALL_STATE_CALL_ROUTED"));

   m_bTimerRunning = TRUE;
   ETG_TRACE_USR3((" m_bTimerRunning = TRUE "));
   m_poCallInstance->m_u16TimerId = FC_PHONE_CALLINSTANCE_TIMER_ID;
   m_poTimer->s32Start(m_poCallInstance->m_u16TimerId,FC_PHONE_ONE_SECOND,vCallInstanceTimerCallBack);
}
/*******************************************************************************
*
* FUNCTION: vHandleEventInAudioAcquireAndDbusConnect
*
* DESCRIPTION:
*
* PARAMETER:
*
* RETURNVALUE: None.
*
********************************************************************************/
tVoid fc_phone_tclSMAcceptCall::vHandleEventInAudioAcquireAndDbusConnect(tU16 u16EventId)
{
   ETG_TRACE_USR3(("  fc_phone_tclSMAcceptCall::vHandleEventInAudioAcquireAndDbusConnect Entered"));
   switch(u16EventId)
   {

   case FC_PHONE_SM_EVENT_DBUS_ACCEPTCALL_ACK_OK :
      {
         ETG_TRACE_USR3((" EVENT::FC_PHONE_SM_EVENT_DBUS_ACCEPTCALL_ACK_OK"));
         // need to check if timer needs to be added.
         // need to post accept call MR and source activity metho result.
         if (!m_bTimerRunning)
         {
            vStartTimerAndSendAck();
         }
      }
      break;

   case FC_PHONE_SM_EVENT_ARL_SRCACTIVITY_ON:

      {
         ETG_TRACE_USR3((" FC_PHONE_SM_EVENT_SETPLAY_MR "));
         m_bSrcActMethodRxd = TRUE;
         if(m_poCallInstance->m_u16CallStatusNotice == FC_PHONE_CALLINSTANCE_CALLSTATUS_ACTIVE || m_poCallInstance->m_u16CallStatusNotice == FC_PHONE_CALLINSTANCE_CALLSTATUS_ONHOLD/*in case if callstatus received as HEld from device*/)
         {  //post srcactivity MR
            //send source activity method result.
            //post MR to ARL
            (fc_phone_tclApp::m_poMainAppInstance)->m_poPhoneAudioRouting->vPostSrcActivityMRToARL(TRUE);
            m_bSrcActMethodRxd = FALSE;
         }
         else
         {
            //channel acquring in progress , wait for connect from BT
            if(TRUE ==  m_poCallInstance->m_bcallWaitingState)
            {
               m_pDbusIf->bAcceptCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId), FC_PHONE_DBUS_ACCEPT_SECOND_WAITINGCALL);
            }
            else
            {
               m_pDbusIf->bAcceptCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId) , FC_PHONE_DBUS_ACCEPT_SINGLECALL);
            }
         }
         m_bEventConsumed = TRUE;
         ETG_TRACE_USR4((" m_bEventConsumed = TRUE "));
      }
      break;
   case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
      {
         // when hf setup/ release audio is received in this state
         ETG_TRACE_USR3(("  EVENT ::FC_PHONE_SM_EVENT_PHONE_REQUEST_OK "));
         if(m_u16State_while_TransferAudio == FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIO_RELEASE_ON_TRANSFERCALLREQ_FROM_PHONE)
         {
            vHandleEventInAudioReleaseOnTransferAudioRequest(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
         }
         else if(m_u16State_while_TransferAudio == FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIO_ACQUISITION_ON_TRANSFERCALLREQ_FROM_PHONE)
         {
            vHandleEventInAudioAcquisitionOnTransferAudioRequest(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
         }
         else
         {
             tU8 u8SCOConnectionStatus = FC_PHONE_DBUS_SCO_CONN_FAILED;
             fc_phone_tclClientHandler_BTSettings *p_clientHndler_bluetooth = (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerBTSettings;
             u8SCOConnectionStatus = p_clientHndler_bluetooth->vGetSCOConnectionStatus(const_cast<tChar *> (fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId))); //CMG3G-4847 - To solve Lint
            ETG_TRACE_USR4(("  fc_phone_tclSMAcceptCall::u8SCOConnectionStatus = %d ",u8SCOConnectionStatus));
            if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_ESTABLISHED)
            {
               ETG_TRACE_USR3(("  EVENT : FC_PHONE_DBUS_SCO_CONN_ESTABLISHED"));
               m_poCallInstance->m_bUsingVehicleAudio = TRUE;
               ETG_TRACE_USR3(("  m_bUsingVehicleAudio = TRUE "));
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
            }
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE ;
            ETG_TRACE_USR3((" AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE"));
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
            m_u16State = FC_PHONE_SMACCEPTCALL_STATE_CALL_ROUTED;
            ETG_TRACE_USR2(("State change: FC_PHONE_SMACCEPTCALL_STATE_CALL_ROUTED"));
         }
      }
      break;
   case FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK:
      {
         ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK"));
         ETG_TRACE_ERR(("  ERROR :: PHONE CHANNEL IS NOT AQUIRED TRANSFERING CALL TO HANDSET   "));

         /* Transfer the call to handset */
         m_poCallInstance->m_bUsingVehicleAudio = FALSE;
         ETG_TRACE_USR3(("  m_bUsingVehicleAudio = FALSE"));
         m_u16State = FC_PHONE_SMACCEPTCALL_STATE_CALL_TRANSFERTOHANDSET;
         ETG_TRACE_USR2(("State change: FC_PHONE_SMACCEPTCALL_STATE_CALL_TRANSFERTOHANDSET"));
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,\
            m_poCallInstance);
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
         tU8 u8SCOConnectionStatus = FC_PHONE_DBUS_SCO_CONN_FAILED;
         fc_phone_tclClientHandler_BTSettings *p_clientHndler_bluetooth = (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerBTSettings;
         u8SCOConnectionStatus = p_clientHndler_bluetooth->vGetSCOConnectionStatus(const_cast<tChar *> (fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId))); //CMG3G-4847 - To solve Lint
         //Dbus call for transferring call to handset
         if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_ESTABLISHED)
         {
            ETG_TRACE_USR4((" Calling Audio Transfer after receiving SCO Connection Status"));
            m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId),FC_PHONE_CALLTRANSFER_FROMHANSFREE_TOHANDSET);
         }
         //GMMY15-813 Cannot switch call to handsfree from radio if incoming call answered from Bluetooth phone
         else if (u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_STATUS_UNKNOWN)
         {
            ETG_TRACE_USR4(( "EVENT : FC_PHONE_DBUS_SCO_CONN_STATUS_UNKNOWN"));
            m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId),FC_PHONE_CALLTRANSFER_FROMHANSFREE_TOHANDSET);
         }
         else
         {
            bProcessEvent(FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK);
         }
          if(FC_PHONE_CALLINSTANCE_INCOMINGCALLEVENT_RINGING == m_poCallInstance->m_u16IncomingCallEvent)
          {
             ETG_TRACE_USR4((" Sending u16IncomingCallEvent IDLE in INCOMING CALL STATUS to HMI "));
             m_poCallInstance->m_u16IncomingCallEvent = FC_PHONE_CALLINSTANCE_INCOMINGCALLEVENT_IDLE;
             m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_INCOMINGCALL, m_poCallInstance);
          }
         if((fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->m_bAcceptMethodStartFlag == TRUE)
         {
            m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACK_NO_AUDIO_CHANNEL;
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_ACCEPTCALL,m_poCallInstance);
         }
      }
      break;

   case FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK:
      {
         ETG_TRACE_USR3(("  EVENT :: FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK "));
         if(m_u16State_while_TransferAudio == FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIO_RELEASE_ON_TRANSFERCALLREQ_FROM_PHONE)
         {
            vHandleEventInAudioReleaseOnTransferAudioRequest(FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK);
         }
         else if(m_u16State_while_TransferAudio == FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIO_ACQUISITION_ON_TRANSFERCALLREQ_FROM_PHONE)
         {
            vHandleEventInAudioAcquisitionOnTransferAudioRequest(FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK);
         }
      }
      break;

   case FC_PHONE_SM_EVENT_TRANSFERCALLVEHICLE_REQUEST_OK:
      {
         ETG_TRACE_USR3(("EVENT :FC_PHONE_SM_EVENT_TRANSFERCALLVEHICLE_REQUEST_OK"));
         //Act like for SetUpAudio
         if(m_poCallInstance->m_bUsingVehicleAudio == FALSE)
         {
            m_bEventConsumed = TRUE;
            m_bTransferCallToVehicleRequest = TRUE;
            m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId), FC_PHONE_CALLTRANSFER_FROMHANDSET_TOHANSFREE);
         }
         else
         {
            //Send Method Error for Transfer call to Vehicle
            m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSFREE,m_poCallInstance);
         }
      }
      break;

   default:   ETG_TRACE_USR3((" vHandleEventInAudioAcquireAndDbusConnect default"));
   }
}



/*******************************************************************************
*
* FUNCTION: vHandleEventInAudioAcquireWaitForSetPlayResponse
*
* DESCRIPTION:
*
* PARAMETER:
*
* RETURNVALUE: None.
*
********************************************************************************/
tVoid fc_phone_tclSMAcceptCall::vHandleEventInWaitForSrcActivityResponse(tU16 u16EventId)
{
   ETG_TRACE_USR3(("  fc_phone_tclSMAcceptCall::vHandleEventInWaitForSrcActivityResponse Entered"));
   switch(u16EventId)
   {
   case FC_PHONE_SM_EVENT_ARL_SRCACTIVITY_ON:
      {
         ETG_TRACE_USR3((" FC_PHONE_SM_EVENT_SETPLAY_MR | FC_PHONE_SM_EVENT_ARL_SRCACTIVITY_ON"));
         //channel acquring in progress , wait for connect from BT
         m_bSrcActMethodRxd = TRUE;
         m_u16State = FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIOACTIVATED_WAIT_FOR_DBUS_CONNECT;
         if(TRUE ==  m_poCallInstance->m_bcallWaitingState)
         {
            m_pDbusIf->bAcceptCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId), FC_PHONE_DBUS_ACCEPT_SECOND_WAITINGCALL);
         }
         else
         {
            m_pDbusIf->bAcceptCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId) , FC_PHONE_DBUS_ACCEPT_SINGLECALL);
         }
         m_bEventConsumed = TRUE;
         ETG_TRACE_USR4((" m_bEventConsumed = TRUE "));
      }
      break;

   case FC_PHONE_SM_EVENT_SETPLAY_ME:
      {
         // no need to post bAcceptCall as channel  aquisition failed.
         // When Set play fails activation Denied will be received to SMs where PHONE-NOK is handled in wait-for-dbus state
         ETG_TRACE_USR4((" FC_PHONE_SM_EVENT_SETPLAY_ME "));
         ETG_TRACE_USR4((" Channel acquisition failed...Send Src Activity Method error posted "));
         m_u16State = FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIOACTIVATED_WAIT_FOR_DBUS_CONNECT;
         // need to check error handling.
          //it shall Update CallStatus for this Callinstance, and continue updating CallStatus.
        /* if(TRUE ==  m_poCallInstance->m_bcallWaitingState)
         {
            m_pDbusIf->bAcceptCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId), FC_PHONE_DBUS_ACCEPT_SECOND_WAITINGCALL);
         }
         else
         {
            m_pDbusIf->bAcceptCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId) , FC_PHONE_DBUS_ACCEPT_SINGLECALL);
         }*/
         m_bEventConsumed = TRUE;
         ETG_TRACE_USR4((" m_bEventConsumed = TRUE "));
      }
      break;

   case FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK:
      {
         ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK"));
         m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED ;
         m_poCallInstance->m_bUsingVehicleAudio = FALSE;
         ETG_TRACE_USR3(("  m_bUsingVehicleAudio = FALSE "));
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);

         m_u16State = FC_PHONE_SMACCEPTCALL_STATE_CHANNEL_ACQUISITION_FAILED_WAIT_FOR_CS;
         ETG_TRACE_USR2(("State change: FC_PHONE_SMACCEPTCALL_STATE_CHANNEL_ACQUISITION_FAILED_WAIT_FOR_CS"));
         fc_phone_tclClientHandler_BTSettings *p_clientHndler_bluetooth = (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerBTSettings;
         tU8 u8SCOConnectionStatus = p_clientHndler_bluetooth->vGetSCOConnectionStatus(const_cast<tChar *> (fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId))); //CMG3G-4847 - To solve Lint
         // if inband, sco would have been establised in that case, transfer audio to handset and restore to active call in handset SM
         if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_ESTABLISHED)
         {
            ETG_TRACE_USR4((" Calling Audio Transfer after receiving SCO Connection Status"));
            m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId),FC_PHONE_CALLTRANSFER_FROMHANSFREE_TOHANDSET);
         }
         else
         {
            ETG_TRACE_USR4((" Wait for callstatus to be received from Phone device."));
         }
         if((fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->m_bAcceptMethodStartFlag == TRUE)
         {
            m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACK_NO_AUDIO_CHANNEL;
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_ACCEPTCALL,m_poCallInstance);
         }
         m_bEventConsumed = TRUE;
      }
      break;

   default: ETG_TRACE_USR4((" vHandleEventInWaitForSrcActivityResponse Default "));
   }
}


/*******************************************************************************
*
* FUNCTION: vHandleEventAudioAcquisitionFailed
*
* DESCRIPTION:
*
* PARAMETER:
*
* RETURNVALUE: None.
*
********************************************************************************/
tVoid fc_phone_tclSMAcceptCall::vHandleEventAudioAcquisitionFailed(tU16 u16EventId)
{
   ETG_TRACE_USR4((" vHandleEventAudioAcquisitionFailed  "));
   switch(u16EventId)
   {
   case FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK:
      {
         ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK"));
      }
      break;
   case FC_PHONE_SM_EVENT_CALLSTATUS_UPDATE :
      {

         // channel acquisition failed but call is accepted in phone device. so revert to ActiveCallinHandsetSM
         ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_CALLSTATUS_UPDATE"));
         if((FC_PHONE_CALLINSTANCE_CALLSTATUS_ACTIVE == m_poCallInstance->m_u16CallStatusNotice) ||
            (FC_PHONE_CALLINSTANCE_CALLSTATUS_ONHOLD == m_poCallInstance->m_u16CallStatusNotice))
         {
            m_poSMManager->vRestoreToActiveCallInHandset(m_poCallInstance->m_u16Id);
         }
      }
      break;
   default:
      ETG_TRACE_USR3((" In default: vHandleEventAudioAcquisitionFailed"));
   }
}

#ifdef PHONE_WAITINGMODE
/*******************************************************************************
*
* FUNCTION: vHandleEventWaitForRingtoneActivatedToHandleWaitingMode
*
* DESCRIPTION:
*
* PARAMETER:
*
* RETURNVALUE: None.
*
********************************************************************************/
tVoid fc_phone_tclSMAcceptCall::vHandleEventWaitForRingtoneActivatedToHandleWaitingMode(tU16 u16EventId)
{
   ETG_TRACE_USR4((" vHandleEventWaitForRingtoneActivatedToHandleWaitingMode  "));
   switch(u16EventId)
   {
      case FC_PHONE_SM_EVENT_ALERT_REQUEST_OK :
      case FC_PHONE_SM_EVENT_INCOMINGCALL_REQUEST_OK:
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
      {
         ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_PHONE_REQUEST_OK"));
         m_u16State = FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AM_RESPONSE_DEACTIVATE_RINGING_INCOMINGCALL;
         vProcessWaitingModeRequest();
      }
      break;

      case FC_PHONE_SM_EVENT_ALERT_REQUEST_NOK :
      case FC_PHONE_SM_EVENT_INCOMINGCALL_REQUEST_NOK:
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK:
      {
         ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK"));
         m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
         m_u16State = FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AM_RESPONSE_DEACTIVATE_RINGING_INCOMINGCALL;
         vProcessWaitingModeRequest();
      }
      break;
      //RTC-665189: This state was not handled the Hangup call when WaitingMode is in progress.
      // When hangupcall is received, the waitingmode state would be set to IDLE.
      case FC_PHONE_SM_EVENT_HANGUPCALL_OK:
      {
         ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_HANGUPCALL_OK"));
         fc_phone_tclWaitingMode* poWaitingMode = fc_phone_tclWaitingMode::poGetInstance();
         poWaitingMode->vSetWaitingModeState(FC_PHONE_WAITINGMODE_IDLE);
      }
      break;

      default:
         ETG_TRACE_USR3((" In default: vHandleEventWaitForRingtoneActivatedToHandleWaitingMode"));
   }
}

/*******************************************************************************
*
* FUNCTION: vHandleEventWaitForSrcOnForWaitmode
*
* DESCRIPTION:
*
* PARAMETER:
*
* RETURNVALUE: None.
*
********************************************************************************/
tVoid fc_phone_tclSMAcceptCall::vHandleEventWaitForSrcOnForWaitmode(tU16 u16EventId)
{
   ETG_TRACE_USR4((" vHandleEventWaitForSrcOnForWaitmode  "));
   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_ARL_PHONEWAIT_SRC_ON:
      {
         ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_ARL_PHONEWAIT_SRC_ON"));

         m_u16State = FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIOACTIVATED;
         ETG_TRACE_USR2(("State change: FC_PHONE_SMACCEPTCALL_STATE_WAIT_FOR_AUDIOACTIVATED"));

         //Phone channel attributes are sent (in case if call is resumed, channel attributes are upto date)
         m_poAudioManager->vUpdateChannelAttributes(m_poCallInstance->m_u8AudioChannel, FC_PHONE_REQUESTTYPE_GET);
         bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK); //posts accept call request to Phone device
      }
      break;
      default:
         ETG_TRACE_USR3((" In default: vHandleEventWaitForSrcOnForWaitmode"));
   }
}
#endif
