
/*******************************************************************************
 *
 * FILE:          FC_Phone_SM.h
 *
 * SW-COMPONENT:  FC_Phone application
 *
 * PROJECT:
 *
 * DESCRIPTION:   Abstracts a statemachine
 *
 * AUTHOR:        Guruprasad G R
 *
 * COPYRIGHT:    (c)Celestial Systems, Bangalore, India
 *
 *******************************************************************************/

#ifndef _FC_PHONE_SM_H_
#define _FC_PHONE_SM_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/

/* Define the states that this machine can take */

#define FC_PHONE_SM_STATE_IDLE 0

#define FC_PHONE_VOICE_RECOGNITION_ACTIVATE   0x01
#define FC_PHONE_VOICE_RECOGNITION_DEACTIVATE 0x00
tVoid vCallInstanceTimerCallBack(tU16 u16TimerId); // This  function same  for all vTimerCallBack()
/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class fc_phone_tclSM
{
public:

   /* This constructor is always used */
   fc_phone_tclSM();
   fc_phone_tclSM(fc_phone_tclCallInstance*& rfpCallInstance);
   fc_phone_tclSM(fc_phone_tclCallInstance *rfpCallInstance[]);

   /* Destructor */
   virtual ~fc_phone_tclSM();

   tVoid vIncrementTimer(fc_phone_tclCallInstance*& rfpCallInstance); //  To incemrnt the Current call time
   tVoid vHandleSourceActivityOffEvent();
   tBool bProcessAllEvents(tU16 u16EventId,tVoid *varg);


   /* Pointer to StateMachineManager */
   static fc_phone_tclSMManager* m_poSMManager;
   static fc_phone_tclTimer* m_poTimer;
   static fc_phone_tclAudioManager* m_poAudioManager;
   static _CCA_dbus_interfaces* m_pDbusIf;


   /* Reference to Call Instance */
   fc_phone_tclCallInstance* m_poCallInstance;
   fc_phone_tclCallInstance* m_poCallInstance2;

   virtual tVoid vCancel(tVoid);
   virtual tVoid vExecute(tVoid);
   virtual tVoid vExecute(tVoid *varg);


   virtual tBool bProcessEvent(tU16 u16EventId);
   virtual tBool bProcessEvent(tU16 u16EventId,tVoid *varg);
   virtual tVoid vNewCallStatus(const T_CallData* const prCallData,tU16 u16_callInstance);
   virtual tVoid vProcessAudioSignal();
   tVoid vCopyCallData(const T_CallData* const prCallData);
   static tVoid vCopyCallData(const T_CallData* const prCallData,fc_phone_tclCallInstance*& rfpCallInstance);
   virtual tVoid vTimerCallBack(tU16 u16TimerId);
   virtual tVoid vAudioCallBack(tU16 u16AudioChannelId, tU16 u16RequestState);
   virtual tVoid vProcessOnDynamicDisconnect(tU16 u16EventId);
   virtual tVoid vRestore(tVoid);
   virtual tU16 u16GetSMID();
   virtual tVoid vSetDtmfLength(tU16 u16DtmfLength);
protected:
   tU16 m_u16State;
};

#endif // _FC_PHONE_SM_H_


