/******************************************************************************
 *
 * FILE:          FC_Phone_SM.cpp
 *
 * SW-COMPONENT:  FC_Phone application
 *
 * PROJECT:
 *
 * DESCRIPTION:   CCA service Telephone.
 *
 * AUTHOR:
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

#include "FC_Phone_SMIncludes.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_PHONE_STATEMACHINE
#include "trcGenProj/Header/FC_Phone_SM.cpp.trc.h"
#endif

fc_phone_tclSMManager*    fc_phone_tclSM::m_poSMManager = NULLPTR;
fc_phone_tclTimer*        fc_phone_tclSM::m_poTimer = NULLPTR;
fc_phone_tclAudioManager* fc_phone_tclSM::m_poAudioManager = NULLPTR;
_CCA_dbus_interfaces*     fc_phone_tclSM::m_pDbusIf = NULLPTR;
//fc_phone_tclSM*            fc_phone_tclSM::m_poInstance = OSAL_NULL;
/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSM
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
fc_phone_tclSM::fc_phone_tclSM()
{
   ETG_TRACE_USR4(("  fc_phone_tclSM::fc_phone_tclSM"));
   m_poCallInstance = NULLPTR;
   m_poCallInstance2 = NULLPTR ;
   m_u16State = 0;
}

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSM
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
fc_phone_tclSM::fc_phone_tclSM(fc_phone_tclCallInstance*& rfpCallInstance)
{
   ETG_TRACE_USR4((" Entering... fc_phone_tclSM::fc_phone_tclSM "));
   m_poCallInstance = rfpCallInstance;
   m_poCallInstance2 = NULLPTR ;
   m_u16State = 0;
   // m_poInstance = this;
}
/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSM
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
fc_phone_tclSM::fc_phone_tclSM(fc_phone_tclCallInstance *rfpCallInstance[])
{
   ETG_TRACE_USR4((" Entering... fc_phone_tclSM::fc_phone_tclSM"));
   m_poCallInstance = rfpCallInstance[0];
   m_poCallInstance2 = rfpCallInstance[1];
   m_u16State = 0;
   //m_poInstance = this;
}
/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSM
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
/* Destructor */
fc_phone_tclSM::~fc_phone_tclSM()
{
   ETG_TRACE_USR4((" Entering... fc_phone_tclSM::~fc_phone_tclSM"));
   //do not make call instance NULL
   //GMMY16-20079- Reset issue.
   //m_poCallInstance = NULL;
   //m_poCallInstance2 = NULL ;
}
/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSM
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
tVoid fc_phone_tclSM::vCancel(tVoid)
{
   /* Should be overwritten */

}
/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSM
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSM::vExecute(tVoid)
{
   /* Should be Overwritten */
}

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSM
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSM::vExecute(tVoid *varg)
{
   (tVoid)varg;
   /* Should be Overwritten */
}
/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSM::bProcessAllEvents
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/

tBool fc_phone_tclSM::bProcessAllEvents(tU16 u16EventId,tVoid *varg)
{
   ETG_TRACE_USR4((" Entering... fc_phone_tclSM::bProcessAllEvents "));
   tBool bConsumed = FALSE;
   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_SA_OFF:
         // This event should only be handled once
      {
         ETG_TRACE_USR4(("bProcessAllEvents :: FC_PHONE_SM_EVENT_SA_OFF"));
         bConsumed = TRUE;
         vHandleSourceActivityOffEvent();
      }
      break;
      default:
         bConsumed = bProcessEvent(u16EventId,varg);
         break;
   }
   ETG_TRACE_USR4((" bConsumed  %d ",bConsumed));
   return bConsumed; 
}


/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSM::bProcessEvent
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tBool fc_phone_tclSM::bProcessEvent(tU16 u16EventId)
{
   /* Should be Overwritten */
   (tVoid)u16EventId;
   return FALSE;
}
/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSM::bProcessEvent
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tBool fc_phone_tclSM::bProcessEvent(tU16 u16EventId,tVoid *varg)
{
   (tVoid)u16EventId;
   (tVoid)varg;
   /* Should be Overwritten */
   ETG_TRACE_USR4((" INSIDE  fc_phone_tclSM::bProcessEvent with args "));

   return FALSE;
}

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSM::u16GetSMID
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tU16 fc_phone_tclSM::u16GetSMID()
{
   /* Should be Overwritten */
   return FALSE;
}

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSM::vSetDtmfLength
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSM::vSetDtmfLength(tU16 u16DtmfLength)
{
   (tVoid) u16DtmfLength;
   /* Should be Overwritten */
}

/*************************************************************************
 *
 * FUNCTION: fc_phone_tclSM::vCopyCallData
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE:
 *
 ***************************************************************************/
tVoid fc_phone_tclSM::vCopyCallData(const T_CallData* const prCallData)
{
   ETG_TRACE_USR4((" Entering... fc_phone_tclSM::vCopyCallData"));
   NULL_CHECK(m_poCallInstance)
   /* Copy Call Number*/
   vStringCopy(m_poCallInstance->m_strCellNumber, \
         prCallData->rCallStatus.achCallNumber,
         FC_PHONE_MAXSTRINGLENGTH);


   /* Copy DeviceName*/
   vStringCopy(m_poCallInstance->m_strCellDeviceName, \
         prCallData->achCellDeviceName,
         FC_PHONE_MAXSTRINGLENGTH);

   /* Copy BD_Address*/
   m_poCallInstance->m_u8BDAddressId = fc_phone_tclDeviceList::getInstance()->u8AddDeviceToDeviceList(prCallData->BD_Address);

   m_poCallInstance->m_u8CallDirection = prCallData->rCallStatus.u8CallDirection;

   /* Copy Call Status */
   switch(prCallData->rCallStatus.u8CallState)
   {
      case PHONE_CALLSTATE_IDLE:
      {
         m_poCallInstance->m_u16CallStatusNotice = \
               FC_PHONE_CALLINSTANCE_CALLSTATUS_IDLE;

      }
      break;
      case PHONE_CALLSTATE_ACTIVE:
      {
         m_poCallInstance->m_u16CallStatusNotice = \
               FC_PHONE_CALLINSTANCE_CALLSTATUS_ACTIVE;

      }
      break;
      case PHONE_CALLSTATE_HELD:
      {
         m_poCallInstance->m_u16CallStatusNotice = \
               FC_PHONE_CALLINSTANCE_CALLSTATUS_ONHOLD;

      }
      break;
      case PHONE_CALLSTATE_DIALING:
      {
         m_poCallInstance->m_u16CallStatusNotice = \
               FC_PHONE_CALLINSTANCE_CALLSTATUS_DIALING;

      }
      break;
      case PHONE_CALLSTATE_ALERTING:
      {
         // TO DO: At the moment there is no corresponding state in most_TelFi
         //m_oCallInstances[u16CallInstanceIndex].m_u16CallStatusNotice =
         //    FC_PHONE_CALLINSTANCE_CALLSTATUS_IDLE;
         m_poCallInstance->m_u16CallStatusNotice = \
               FC_PHONE_CALLINSTANCE_CALLSTATUS_DIALING;
      }
      break;
      case PHONE_CALLSTATE_INCOMING:
      {
         m_poCallInstance->m_u16CallStatusNotice = \
               FC_PHONE_CALLINSTANCE_CALLSTATUS_RINGTONE;

      }
      break;
      case PHONE_CALLSTATE_WAITING:
      {
         m_poCallInstance->m_u16CallStatusNotice = \
               FC_PHONE_CALLINSTANCE_CALLSTATUS_RINGTONE;

      }
      break;
      case PHONE_CALLSTATE_RESPONSE_AND_HOLD:
      {
         // TO DO: At the moment there is no corresponding state in most_TelFi
         // m_oCallInstances[u16CallInstanceIndex].m_u16CallStatusNotice =
         //     FC_PHONE_CALLINSTANCE_CALLSTATUS_IDLE;
      }
      break;
      case PHONE_CALLSTATE_UNKNOWN:
      {
         // TO DO: At the moment there is no corresponding state in most_TelFi
         // Stay in the same state
      }
      break;

      default:
      {
         ETG_TRACE_USR4((" In default"));
      }
      break;
   }
}
/*************************************************************************
 *
 * FUNCTION: fc_phone_tclSM::vCopyCallData
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE:
 *
 ***************************************************************************/
tVoid fc_phone_tclSM::vCopyCallData(const T_CallData* const prCallData,fc_phone_tclCallInstance*& rfpCallInstance)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSM::vCopyCallData"));
   /* Copy Call Number*/
   vStringCopy(rfpCallInstance->m_strCellNumber, \
         prCallData->rCallStatus.achCallNumber,
         FC_PHONE_MAXSTRINGLENGTH);

   /* Copy DeviceName*/
   vStringCopy(rfpCallInstance->m_strCellDeviceName, \
         prCallData->achCellDeviceName,
         FC_PHONE_MAXSTRINGLENGTH);
   /* Copy BD_Address*/
   rfpCallInstance->m_u8BDAddressId = fc_phone_tclDeviceList::getInstance()->u8AddDeviceToDeviceList(prCallData->BD_Address);
   rfpCallInstance->m_u8CallDirection = prCallData->rCallStatus.u8CallDirection;
   /* Copy Call Status */
   switch(prCallData->rCallStatus.u8CallState)
   {
      case PHONE_CALLSTATE_IDLE:
      {
         rfpCallInstance->m_u16CallStatusNotice = \
               FC_PHONE_CALLINSTANCE_CALLSTATUS_IDLE;

      }
      break;
      case PHONE_CALLSTATE_ACTIVE:
      {
         rfpCallInstance->m_u16CallStatusNotice = \
               FC_PHONE_CALLINSTANCE_CALLSTATUS_ACTIVE;
      }
      break;
      case PHONE_CALLSTATE_HELD:
      {
         rfpCallInstance->m_u16CallStatusNotice = \
               FC_PHONE_CALLINSTANCE_CALLSTATUS_ONHOLD;
      }
      break;
      case PHONE_CALLSTATE_DIALING:
      {
         rfpCallInstance->m_u16CallStatusNotice = \
               FC_PHONE_CALLINSTANCE_CALLSTATUS_DIALING;
      }
      break;
      case PHONE_CALLSTATE_ALERTING:
      {
         // TO DO: At the moment there is no corresponding state in most_TelFi
         //m_oCallInstances[u16CallInstanceIndex].m_u16CallStatusNotice =
         //    FC_PHONE_CALLINSTANCE_CALLSTATUS_IDLE;
         rfpCallInstance->m_u16CallStatusNotice = \
               FC_PHONE_CALLINSTANCE_CALLSTATUS_DIALING;
      }
      break;
      case PHONE_CALLSTATE_INCOMING:
      {
         rfpCallInstance->m_u16CallStatusNotice = \
               FC_PHONE_CALLINSTANCE_CALLSTATUS_RINGTONE;
      }
      break;
      case PHONE_CALLSTATE_WAITING:
      {
         //sandeep :: have to confirm from guru
         rfpCallInstance->m_u16CallStatusNotice = \
               FC_PHONE_CALLINSTANCE_CALLSTATUS_BUSY;
      }
      break;
      case PHONE_CALLSTATE_RESPONSE_AND_HOLD:
      {
         // TO DO: At the moment there is no corresponding state in most_TelFi
         // m_oCallInstances[u16CallInstanceIndex].m_u16CallStatusNotice =
         //     FC_PHONE_CALLINSTANCE_CALLSTATUS_IDLE;
      }
      break;
      case PHONE_CALLSTATE_UNKNOWN:
      {
         // TO DO: At the moment there is no corresponding state in most_TelFi
         // Stay in the same state
      }
      break;
      default:
      {
         ETG_TRACE_USR4((" In default"));
      }
      break;
   }
}
/*************************************************************************
 *
 * FUNCTION: fc_phone_tclSM::vNewCallStatus
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE:
 *
 ***************************************************************************/
tVoid fc_phone_tclSM::vNewCallStatus(const T_CallData* const prCallData,tU16 u16_callInstance)
{

   (tVoid)u16_callInstance ;
   vCopyCallData(prCallData);
   //this function have to be oveloaded
}
/*************************************************************************
 *
 * FUNCTION: fc_phone_tclSM::vHandleAudioSignal
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE:
 *
 ***************************************************************************/
tVoid fc_phone_tclSM::vProcessAudioSignal()
{
   //this function have to be oveloaded
}
/*************************************************************************
 *
 * FUNCTION: fc_phone_tclSM::vTimerCallBack
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE:
 *
 ***************************************************************************/
tVoid fc_phone_tclSM::vTimerCallBack(tU16 u16TimerId)
{
   (tVoid)u16TimerId;
   /* Should be overridden */
}

/*************************************************************************
 *
 * FUNCTION: fc_phone_tclSM::vAudioCallBack
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE:
 *
 ***************************************************************************/
tVoid fc_phone_tclSM::vAudioCallBack(tU16 u16AudioChannelId, tU16 u16RequestState)
{
   (tVoid)u16AudioChannelId;
   (tVoid)u16RequestState ;
   /* Should be overridden */
}


/*************************************************************************
 *
 * FUNCTION: fc_phone_tclSM::vProcessOnSLCDisconnect
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE:
 *
 ***************************************************************************/
tVoid fc_phone_tclSM::vProcessOnDynamicDisconnect(tU16 u16EventId)
{
   (tVoid)u16EventId;
   /* Should be overridden */
   ETG_TRACE_USR4((" fc_phone_tclSM::vProcessOnDynamicDisconnect "));
}

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSM
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
tVoid fc_phone_tclSM::vRestore(tVoid)
{
   /* Should be overwritten */

}
/*******************************************************************************
 *
 * FUNCTION: vCallInstanceTimerCallBack
 *
 * DESCRIPTION: It's common timer callback function for call state
 *
 * PARAMETER: u16TimerId
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/

tVoid vCallInstanceTimerCallBack(tU16 u16TimerId)
{

   ETG_TRACE_USR4((" vCallInstanceTimerCallBack u16TimerId %d",u16TimerId));

   //fc_phone_tclSMAcceptCall::m_poInstance->vTimerCallBack(u16TimerId);
   if(u16TimerId == FC_PHONE_CALLINSTANCE_TIMER_ID)
   {
      fc_phone_tclSMManager::vCallTimerCallBack(u16TimerId) ;
   }
   else
   {
      fc_phone_tclSM* pSMInstance;
      pSMInstance = fc_phone_tclSMManager::GetSM_FromTimerID(u16TimerId) ;
      if(pSMInstance)
      {
         pSMInstance->vTimerCallBack(u16TimerId);
      }
      else
      {
         ETG_TRACE_USR4(("ERROR:: could not get SM for u16TimerId %d",u16TimerId));
      }
   }
}
/*******************************************************************************
 *
 * FUNCTION: vIncrementTimer
 *
 * DESCRIPTION: to incement the call time of the active call
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSM::vIncrementTimer(fc_phone_tclCallInstance*& rfpCallInstance)
{
   ETG_TRACE_USR4((" Entered vIncrementTimer "));

   if (rfpCallInstance)
   {
      rfpCallInstance->m_rCallDuration.u8Seconds++;

      if ( rfpCallInstance->m_rCallDuration.u8Seconds == 60)
      {
         rfpCallInstance->m_rCallDuration.u8Seconds = 0;

         rfpCallInstance->m_rCallDuration.u8Minutes++;

         if (rfpCallInstance->m_rCallDuration.u8Minutes == 60)
         {
            rfpCallInstance->m_rCallDuration.u8Minutes = 0;
            rfpCallInstance->m_rCallDuration.u8Seconds = 0;
            rfpCallInstance->m_rCallDuration.u8Hours++;
         }
      }
      ETG_TRACE_USR4(("vIncrementTimer Incrementedtime Hour %d",rfpCallInstance->m_rCallDuration.u8Hours));
      ETG_TRACE_USR4(("vIncrementTimer Incrementedtime Minute %d",rfpCallInstance->m_rCallDuration.u8Minutes));
      ETG_TRACE_USR4(("vIncrementTimer Incrementedtime Second %d",rfpCallInstance->m_rCallDuration.u8Seconds));
   }
   else
   {
      ETG_TRACE_USR4(("ERROR:: CallInstance NULL "));
   }
}
/*******************************************************************************
 *
 * FUNCTION: vHandleSourceActivityOff
 *
 * DESCRIPTION: to incement the call time of the active call
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSM::vHandleSourceActivityOffEvent()
{
   ETG_TRACE_USR4((" INSIDE  fc_phone_tclSM::vHandleSourceActivityOffEvent "));
   if(FALSE == m_poAudioManager->bIsPhoneOrRingtoneChannelAcquistionInRelease())
   {
      ETG_TRACE_USR3((" Transfer not handled in state machine, hence transfering here"));
      (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vTransferCallToHandset();
   }
}
