/*******************************************************************************
 *
 * FILE:          FC_Phone_Timer.h
 *
 * SW-COMPONENT:  FC_Phone application
 *
 * PROJECT:
 *
 * DESCRIPTION:   Abstracts timer service  provided by PhoneService class
 *
 * AUTHOR:        Guruprasad G R
 *
 * COPYRIGHT:    (c)Celestial Systems, Bangalore, India
 *
 *******************************************************************************/

#ifndef _FC_PHONE_TIMER_H_
#define _FC_PHONE_TIMER_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
typedef tVoid (*TimerCallBack)(tU16);
/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/

typedef struct _TimerIdCallBackMap
{
   tU16 u16TimerId;
   TimerCallBack FpCallBack;
} TimerIdCallBackMap;


#define FC_PHONE_TIMER_LIMIT              5     /* Maximum of 5 timers are allowed to be used by an app */
#define FC_PHONE_MAX_COUNT_CONFERENCE     2     /* Waits for 3 seconds for the second call status after swap */

#define FC_PHONE_TIMER_ID_UNUSED                         0xFF
#define FC_PHONE_TIMER_OK                                0x00
#define FC_PHONE_TIMER_ID_INVALID                        0x01
#define FC_PHONE_TIMER_LIMIT_EXCEEDED                    0x02
#define FC_PHONE_TIMER_APPLICATION_SERVICE_FAILED        0x03
#define FC_PHONE_TIMER_RUNNING                           0x04     /* To get current Timer */

#define FC_PHONE_SMACH_ALERT_TIMER_ID                             200
#define FC_PHONE_CONFERENCE_TIMER_ID                              6
#define FC_PHONE_CALLINSTANCE_TIMER_ID                            400      /* To get the current state of the instance */
#define FC_PHONE_SMTRANSFERCALL_AUDIOTRANSFER_TIMER_ID            8
#define FC_PHONE_SMACH_AUDIOTRANSFER_TIMER_ID                     10
#define FC_PHONE_ACQUIRETELEPHONENUMBER_TIMER_ID                  15
#define FC_PHONE_INCOMINGCALLALERT_TIMER_ID                       20    /* Fix for GMMY15-10552:PB response is late */
#define FC_PHONE_TERMINATECALLRETRY_TIMER_ID                      25
#define FC_PHONE_DIAL_CALLSTATUS_FAILURE_TIMER_ID                 30

// CMG3G-7982- Extend VR session
#define FC_PHONE_EXTEND_VR_SESSION_TIMER_ID                       35

//NCG3D-3221- Hold the HfReleaseAudio signal for 500ms.
#define FC_PHONE_SCO_CHANNEL_RELEASE_TIMER_ID                     40

//NCG3D-18758. Timer introduced to release the channel in case no response from ARL after 3.5 secs
#define FC_PHONE_WAITFOR_ARL_RESPONSE_TIMER_ID                    45
#define FC_PHONE_WAITFOR_ARL_RESPONSE_DURATION                    3500   //3.5 secs

#define FC_PHONE_HELD_TO_ACTIVE_SWAP_TIMER_ID                    50
//Bugfix for GMMY16-12538: [CT]Inconsistencies with Siri
#ifdef PHONE_SIRI
   #define FC_PHONE_SIRISTATUS_RETRY_TIMER_ID                     500
   #define FC_PHONE_SIRINRSTATUS_RETRY_TIMER_ID                   501
   #define FC_PHONE_SIRISTATUS_MAXRETRY_COUNT                     15
   #define FC_PHONE_TWOHUNDRED_MILLISECOND                        200

#endif //PHONE_SIRI

#ifdef EVO_TESTING //Testing
#define FC_PHONE_MODEM_TIMER_ID                     250
#define FC_PHONE_THREE_MINUTES                     (2000 * 60)
#endif //EVO_TESTING

#define FC_PHONE_ONE_SECOND                                       1000
#define FC_PHONE_THREEHUNDRED_MILLISECOND                         300

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class fc_phone_tclTimer FINAL
{

public:
   fc_phone_tclTimer(fc_phone_tclApp*& rfpApp);
   virtual ~fc_phone_tclTimer();

   tS32 s32Start(tU16 u16TimerId, tU32 u32TimeInMilliSeconds, TimerCallBack fpCallBack);
   tS32 s32Stop(tU16 u16TimerId);
   tVoid vTimerExpired(tU16 u16TimerId);
   tVoid OsalTimerCallBack(tVoid* vTimerId);
   static fc_phone_tclTimer* pGetInstance(tVoid);
   tVoid vStopAll(tVoid);
   tBool s32GetAliveTimerId(tU16 u16TimerId);

private:
   tU8 m_u8RefCount; /* To count the timer of the CallLinstance */
   TimerIdCallBackMap m_rTimerCallBackMap[FC_PHONE_TIMER_LIMIT];
   fc_phone_tclApp* m_poApp;
   static fc_phone_tclTimer* m_poInstance;

   ahl_tclExCallbackTimer<fc_phone_tclTimer> m_oOsalTimer[FC_PHONE_TIMER_LIMIT];
   tS32 s32GetNextTimerSlot(tU16& rfSlotId, tU16 u16TimerId);
   tS32 s32GetSlotIdFromTimerId(tU16 u16TimerId, tU16& rfSlotId);
};

#endif // _FC_PHONE_TIMER_H_
