/*******************************************************************************
 *
 * FILE:          FC_Phone_PhoneData.h
 *
 * SW-COMPONENT:  FC_Phone application
 *
 * PROJECT:
 *
 * DESCRIPTION:   Abstracts Phone Data
 *
 * AUTHOR:        Guruprasad G R
 *
 * COPYRIGHT:    (c)Celestial Systems, Bangalore, India
 *
 *******************************************************************************/

#ifndef _FC_PHONE_PHONEDATA_H_
#define _FC_PHONE_PHONEDATA_H_

#include"../Interface/FC_Phone_DBusInterface.h"
/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/

/* Values for the attribute m_u8NetworkStatus */
#define FC_PHONE_PHONEDATA_NWSTATUS_NOTAVAILABLE         0x00
#define FC_PHONE_PHONEDATA_NWSTATUS_AVAILABLE            0x01
#define FC_PHONE_PHONEDATA_NWSTATUS_UNKNOWN              0xFF

/* Values for the attribute m_u8RoamingStatus */
#define FC_PHONE_PHONEDATA_ROAMINGSTATUS_FALSE           0x00
#define FC_PHONE_PHONEDATA_ROAMINGSTATUS_TRUE            0x01      

/* Values for the attribute m_u8Charge */   
#define FC_PHONE_PHONEDATA_CHARGE_INDENT_UNKNOWN        0xFF


/* Values for the attribute m_u8SignalStrength */ 
#define FC_PHONE_PHONEDATA_SIGNALSTRENGTH_INDENT_UNKNOWN   0xFF


#define FC_PHONE_PHONEDATA_THREEWAYCALL_UNKNOWN   0xFF
#define FC_PHONE_PHONEDATA_CALLWAITING_UNKNOWN    0xFF
#define FC_PHONE_PHONEDATA_INBANDRINGTONE_UNKNOWN 0xFF
#define FC_PHONE_PHONEDATA_BT_VOICE_RECOGNITION_UNKNOWN 0xFF

/* Masks to get update changes */

#define FC_PHONE_PHONEDATA_MASK_NWSTATUS              0x0001
#define FC_PHONE_PHONEDATA_MASK_ROAMINGSTATUS         0x0002
#define FC_PHONE_PHONEDATA_MASK_CHARGE                0x0004
#define FC_PHONE_PHONEDATA_MASK_SIGNALSTRENGTH        0x0008
#define FC_PHONE_PHONEDATA_MASK_NWOPNAME              0x0010
#define FC_PHONE_PHONEDATA_MASK_CALLWAITING           0x0020
#define FC_PHONE_PHONEDATA_MASK_THREEWAYCALL          0x0040
#define FC_PHONE_PHONEDATA_MASK_VR                    0x0080
#define FC_PHONE_PHONEDATA_MASK_ENHANCECALLCTRL       0x0100

#define FC_PHONE_THREEWAYCALL_SUPPORT_MASK            0x00000001
#define FC_PHONE_ENHANCECALLCTRL_ENDTARGETCALL_MASK   0x04
#define FC_PHONE_ENHANCECALLCTRL_SPLITMERGECALLS_MASK 0x10
#define FC_PHONE_ENHANCECALLCTRL_UNKNOWN			  0xFF

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

#define FC_PHONE_STRING_LENGTH_MAX  255
#define FC_PHONE_MAX_CONNECTED_DEVICE 2
#define INVALID_BDADDRESS_ID 255

#ifdef PHONE_SIRI
#define FC_PHONE_ENABLED  0x01
#define FC_PHONE_DISABLED 0x00
#endif //PHONE_SIRI

class fc_phone_tclDeviceList
{
   fc_phone_tclDeviceList();
   tChar  m_BD_Address[FC_PHONE_MAX_CONNECTED_DEVICE][FC_PHONE_STRING_LENGTH_MAX];
   static fc_phone_tclDeviceList *m_pInstance;
public:
   static fc_phone_tclDeviceList* getInstance();
   static void destroy();
   tU8 u8AddDeviceToDeviceList(const tChar *pDeviceAddress);
   tBool u8DeleteDeviceFromDeviceList(tU8 u8BDAddressId);
   const tChar *u8GetBDAddressFromDeviceList(tU8 u8BDAddressId); //CMG3G-4847 - To solve Lint
   tS32 s32GetConnectedDevNumFromDeviceList();
   tU8 u8GetBDAddressIdFromBDAddress(const tChar *pDeviceAddress);
   tVoid vPrintDeviceList();
};


class fc_phone_tclPhoneData FINAL
{
public:

   /* Default Constructor */
   fc_phone_tclPhoneData();

   /* Overloaded Constructor */
   fc_phone_tclPhoneData(const T_PhoneStatus* const prPhoneData);
   fc_phone_tclPhoneData(const fc_phone_tclPhoneData& rfPhoneData);

   /* Overload = operator */

   fc_phone_tclPhoneData& operator=(const fc_phone_tclPhoneData& rfPhoneData); //Info 1720: assignment operator for class 'fc_phone_tclPhoneData' has non-const parameter

   /* Destructor */
   virtual ~fc_phone_tclPhoneData();

   tU16 u16Compare(fc_phone_tclPhoneData& rfPhoneData);
   //private:
   tVoid vInit(tVoid);
   tU8 m_u8NetworkStatus;
   tU8 m_u8RoamingStatus;
   tU8 m_u8Charge;
   tU8 m_u8SignalStrength;
   tChar  m_achCellDeviceName[FC_PHONE_STRING_LENGTH_MAX];

   tU8  m_u8BDAddressId;
   tChar m_NetworkOperatorName[FC_PHONE_STRING_LENGTH_MAX];
   tBool m_bThreeWayCallSupport ;
   tBool m_bCallWaitingSupport ;
   tU16 m_bInBandRingtoneSupport;
   tU16 m_bBtVoiceRecSupport;
   tU8 AudioOutStatus;
   tChar m_SubscriberMSISDN[FC_PHONE_STRING_LENGTH_MAX];
   tU8 m_u8AgThreeWayCallSuppFeatures;
};

// CMG3G-7861 - Siri availability status
// The ENUM reflects the ucStatus received as part of BT_APPL_SIRI_AplSiri_IND
typedef enum 
{
   NOT_AVAILABLE = 0,
   AVAILABLE_ENABLED = 1,
   AVAILABLE_DISABLED = 2
}T_eAplSiriState;

#ifdef PHONE_SIRI

typedef enum 
{
   IDLE = 0,
   ACTIVE = 1,
   INACTIVE = 2

}T_eSiriStates;

class fc_phone_tclSiriData FINAL
{
public:
   /* Default Constructor */
   fc_phone_tclSiriData();
   /* Destructor */
   virtual ~fc_phone_tclSiriData();

   tVoid vSetSiriStatus(tU8 status);
   tVoid vEnableSiri(char *pActiveDeviceAddress);
   tVoid vSetSiriNrStatus(tU8 status);
   tVoid vDisableSiri();
   tVoid vSetSiriState(T_eSiriStates state);
   tVoid vSiriNRCallback();
   tVoid vGetActiveDeviceAddress(char *pActiveDeviceAddress);
   tBool bIsSiriStateActive();
   // CMG3G-7861 - Siri availability status
   T_eAplSiriState eGetAplSiriState();
private:
   tBool m_bSiriAvailable;
   tBool m_bSiriEnable;
   tU8  m_u8SiriNrStatus;
   T_eSiriStates m_eSiriState;
   // CMG3G-7861 - Siri availability status
   T_eAplSiriState m_eAplSiriState;
   tU8 m_u8BDAddressID;

};
#endif // PHONE_SIRI

#endif // _FC_PHONE_PHONEDATA_H
