/******************************************************************************
 *
 * FILE:          FC_Phone_PhoneData.cpp
 *
 * SW-COMPONENT:  FC_Phone application
 *
 * PROJECT:
 *
 * DESCRIPTION:   Implements class fc_phone_tclPhoneData
 *
 * AUTHOR:
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

#include "FC_Phone_PhoneData.h"
#include "../StateMachines/FC_Phone_SMIncludes.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_PHONE_APPLICATION
#include "trcGenProj/Header/FC_Phone_PhoneData.cpp.trc.h"
#endif

fc_phone_tclDeviceList* fc_phone_tclDeviceList::m_pInstance = NULLPTR;


/*******************************************************************************
 ** FUNCTION:   s32AddDeviceToSLCDeviceList
 *******************************************************************************/
/* DESCRIPTION:
 *  Add device address in connected device list
 *
 *  PARAMETERS:
 *          IN tChar *pDeviceAddress : device address
 *  RETURNVALUE: tS32
 *******************************************************************************/


fc_phone_tclDeviceList::fc_phone_tclDeviceList()
{
   for(tU16 u16Index= 0 ;u16Index <FC_PHONE_MAX_CONNECTED_DEVICE ;u16Index++)
   {
      memset(m_BD_Address[u16Index],0,FC_PHONE_STRING_LENGTH_MAX);
   }
}
fc_phone_tclDeviceList* fc_phone_tclDeviceList::getInstance() //CMG3G-4847 - To solve Lint
{
   if(!m_pInstance)
   {  m_pInstance = new fc_phone_tclDeviceList();}

   return m_pInstance;

}
void fc_phone_tclDeviceList::destroy()
{
   delete m_pInstance;
   m_pInstance = NULLPTR;
}

tU8 fc_phone_tclDeviceList::u8AddDeviceToDeviceList(const tChar *pDeviceAddress)
{
   ETG_TRACE_USR4((" fc_phone_tclDeviceList::u8AddDeviceToDeviceList ENTERED"));
   //check if This device address is already added
   for(tU8 u8Index= 0 ;u8Index <FC_PHONE_MAX_CONNECTED_DEVICE ;u8Index++)
   {
      if(0 == u8StringCompare((const char*)m_BD_Address[u8Index],(const char*)pDeviceAddress))
      {
         ETG_TRACE_USR3((" this device Address is Already added at index ::%d",u8Index));
         return u8Index;
      }
   }

   //If Device address is not already in the list
   //Get empty slot and copy the Address
   for(tU8 u8Index= 0 ;u8Index <FC_PHONE_MAX_CONNECTED_DEVICE ;u8Index++)
   {
      if(m_BD_Address[u8Index][0] == 0)
      {
         ETG_TRACE_USR3((" Adding deviceAddress in SCLdeviceList at index ::%d",u8Index));
         vStringCopy(m_BD_Address[u8Index], pDeviceAddress, FC_PHONE_STRING_LENGTH_MAX);
         vPrintDeviceList();
         return u8Index;
      }
   }
   ETG_TRACE_ERR((" ERROR:: no free deviceList Slot found"));
   vPrintDeviceList();
   return INVALID_BDADDRESS_ID;
}

/*******************************************************************************
 ** FUNCTION:   u8GetBDAddressIdFromBDAddress
 *******************************************************************************/
/* DESCRIPTION:
 *  returns the uniqueId for the corresponding BDAddress
 *
 *  PARAMETERS:
 *          IN tChar *pDeviceAddress : device address
 *  RETURNVALUE:
 *            tU8 : BDAddressId
 *******************************************************************************/


tU8 fc_phone_tclDeviceList::u8GetBDAddressIdFromBDAddress(const tChar *pDeviceAddress)

{
   ETG_TRACE_USR4((" fc_phone_tclDeviceList::u8GetBDAddressIdFromBDAddress ENTERED with DeviceAddress : %s",pDeviceAddress));
   tU8 u8BD_AddressId = INVALID_BDADDRESS_ID;
   for(tU8 u8Index= 0 ;u8Index <FC_PHONE_MAX_CONNECTED_DEVICE ;u8Index++)
   {
      if(0 == u8StringCompare((const char*)m_BD_Address[u8Index],(const char*)pDeviceAddress))
      {
         ETG_TRACE_USR4(("BDAddress is Found in the list at the index: %d", u8Index));
         u8BD_AddressId = u8Index;
         break;
      }
   }
   return u8BD_AddressId;
}



/*******************************************************************************
 ** FUNCTION:   s32DeleteDeviceFromSLCDeviceList
 *******************************************************************************/
/* DESCRIPTION:
 *  delete device address in connected device list
 *
 *  PARAMETERS:
 *          IN tChar *pDeviceAddress : device address
 *  RETURNVALUE: tS32
 *******************************************************************************/

tBool fc_phone_tclDeviceList::u8DeleteDeviceFromDeviceList(tU8 u8BDAddressId)
{
   ETG_TRACE_USR4((" fc_phone_tclDeviceList::u8DeleteDeviceFromDeviceList ENTERED with u8BDAddressId : %d",u8BDAddressId));
   //  ETG_TRACE_USR2((" Delete Entry for deviceAddress ::%s",pDeviceAddress));
   tBool bSuccess = FALSE;

   if(u8BDAddressId < FC_PHONE_MAX_CONNECTED_DEVICE)
   {
      m_BD_Address[u8BDAddressId][0] = '\0';
      bSuccess = TRUE;
   }
   else
   {
      ETG_TRACE_ERR((" Error ::Input DeviceAddress Not found in SLC Device List"));
   }
   vPrintDeviceList();

   return bSuccess;
}



/*******************************************************************************
 ** FUNCTION:   s32GetConnectedDevNumFromSLCDeviceList
 *******************************************************************************/
/* DESCRIPTION:
 *  delete device address in connected device list
 *
 *  PARAMETERS:
 *          IN tChar *pDeviceAddress : device address
 *  RETURNVALUE: tS32
 *******************************************************************************/


tS32 fc_phone_tclDeviceList::s32GetConnectedDevNumFromDeviceList()
{
   ETG_TRACE_USR4((" fc_phone_tclDeviceList::s32GetConnectedDevNumFromDeviceList ENTERED"));
   tS32 s32Counter = 0;
   for(tU8 u8Index= 0 ;u8Index <FC_PHONE_MAX_CONNECTED_DEVICE ;u8Index++)
   {
      if('\0' != m_BD_Address[u8Index][0] )
      {
         s32Counter++ ;
      }
   }

   return s32Counter ;
}


/*******************************************************************************
 ** FUNCTION:   vPrintDeviceList
 *******************************************************************************/
/* DESCRIPTION:
 *  delete device address in connected device list
 *
 *  PARAMETERS:
 *          IN : none
 *  RETURNVALUE: none
 *******************************************************************************/
tVoid fc_phone_tclDeviceList::vPrintDeviceList()
{
   ETG_TRACE_USR4((" fc_phone_tclDeviceList::vPrintDeviceList ENTERED"));

   for(tU8 u8Index= 0 ;u8Index <FC_PHONE_MAX_CONNECTED_DEVICE ;u8Index++)
   {
      ETG_TRACE_USR3((" BD_Address[%d] :: %s",u8Index,m_BD_Address[u8Index]));
   }
}


/*******************************************************************************
 ** FUNCTION:   u8GetBDAddressFromDeviceList
 *******************************************************************************/
/* DESCRIPTION:
 * get device address from connected device list using BDAddressId
 *
 *  PARAMETERS:
 *          IN : u8BDAddressId
 *  RETURNVALUE: BDAddress
 *******************************************************************************/
const tChar *fc_phone_tclDeviceList::u8GetBDAddressFromDeviceList(tU8 u8BDAddressId) //CMG3G-4847 - To solve Lint
{
   ETG_TRACE_USR4((" fc_phone_tclDeviceList::u8GetBDAddressFromDeviceList ENTERED with BDAddress ID : %d ",u8BDAddressId));

   if(u8BDAddressId < FC_PHONE_MAX_CONNECTED_DEVICE)
   {
      return (tChar*)m_BD_Address[u8BDAddressId];
   }
   ETG_TRACE_ERR((" Invalid BDAddressId : %d ", u8BDAddressId));
   return NULLPTR;
}

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclPhoneData
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
fc_phone_tclPhoneData::fc_phone_tclPhoneData(tVoid)
{
   vInit();
}
/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclPhoneData
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/

fc_phone_tclPhoneData::fc_phone_tclPhoneData(const T_PhoneStatus* const prPhoneData)
{
   ETG_TRACE_USR4(("fc_phone_tclPhoneData::fc_phone_tclPhoneData ENTERED "));
   vInit();
   m_u8NetworkStatus  = prPhoneData->u8PhoneService;
   m_u8RoamingStatus  = prPhoneData->u8PhoneRoaming;
   m_u8Charge         = prPhoneData->u8PhoneBattery;
   m_u8SignalStrength = prPhoneData->u8PhoneSignal;
   m_u8BDAddressId = fc_phone_tclDeviceList::getInstance()->u8AddDeviceToDeviceList(prPhoneData->BD_Address);
   vStringCopy(m_NetworkOperatorName,prPhoneData->achPhoneOperatorName, FC_PHONE_STRING_LENGTH_MAX);

   m_bThreeWayCallSupport = (prPhoneData->u32PhoneSuppFeature & FC_PHONE_THREEWAYCALL_SUPPORT_MASK) ;
   m_bCallWaitingSupport = (prPhoneData->u32PhoneSuppFeature & FC_PHONE_THREEWAYCALL_SUPPORT_MASK) ;
   m_bInBandRingtoneSupport = (prPhoneData->u32PhoneSuppFeature & (1<<3)); 
   m_bBtVoiceRecSupport = (prPhoneData->u32PhoneSuppFeature & (1<<2));
   m_u8AgThreeWayCallSuppFeatures = prPhoneData->u8AgThreeWayCallSuppFeatures;
}
/*******************************************************************************
 *
 * FUNCTION: ~fc_phone_tclPhoneData
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
/* Destructor */
fc_phone_tclPhoneData::~fc_phone_tclPhoneData()
{

}
/*******************************************************************************
 *
 * FUNCTION: vInit
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
tVoid fc_phone_tclPhoneData::vInit(tVoid)
{
   ETG_TRACE_USR4(("fc_phone_tclPhoneData::vInit ENTERED "));
   m_u8NetworkStatus = FC_PHONE_PHONEDATA_NWSTATUS_UNKNOWN;
   m_u8RoamingStatus = \
         FC_PHONE_PHONEDATA_ROAMINGSTATUS_FALSE;

   m_u8Charge = FC_PHONE_PHONEDATA_CHARGE_INDENT_UNKNOWN;
   m_u8SignalStrength = \
         FC_PHONE_PHONEDATA_SIGNALSTRENGTH_INDENT_UNKNOWN;

   memset(m_achCellDeviceName,'\0',sizeof(m_achCellDeviceName));
   //memset(m_BD_Address,0,sizeof(m_BD_Address));
   m_u8BDAddressId=INVALID_BDADDRESS_ID;
   memset(m_NetworkOperatorName,'\0',sizeof(m_NetworkOperatorName));
   memset(m_SubscriberMSISDN,'\0',sizeof(m_SubscriberMSISDN));

   m_bThreeWayCallSupport = FALSE ;
   m_bCallWaitingSupport = FALSE ;
   m_bInBandRingtoneSupport = FC_PHONE_PHONEDATA_INBANDRINGTONE_UNKNOWN;
   m_bBtVoiceRecSupport = 0;
   AudioOutStatus = 0;
   m_u8AgThreeWayCallSuppFeatures = 0;
}
/*******************************************************************************
 *
 * FUNCTION: Copy Constructor
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/

fc_phone_tclPhoneData::fc_phone_tclPhoneData(const fc_phone_tclPhoneData& rfPhoneData)
{
   ETG_TRACE_USR4(("fc_phone_tclPhoneData::fc_phone_tclPhoneData ENTERED "));
   vInit();
   m_u8NetworkStatus  = rfPhoneData.m_u8NetworkStatus;
   m_u8RoamingStatus  = rfPhoneData.m_u8RoamingStatus;
   m_u8Charge         = rfPhoneData.m_u8Charge;
   m_u8SignalStrength = rfPhoneData.m_u8SignalStrength;
   m_u8BDAddressId=rfPhoneData.m_u8BDAddressId;
   vStringCopy(m_NetworkOperatorName,rfPhoneData.m_NetworkOperatorName, FC_PHONE_STRING_LENGTH_MAX);

   m_bThreeWayCallSupport = rfPhoneData.m_bThreeWayCallSupport ;
   m_bCallWaitingSupport  = rfPhoneData.m_bCallWaitingSupport ;
   m_bInBandRingtoneSupport = rfPhoneData.m_bInBandRingtoneSupport;
   m_bBtVoiceRecSupport = rfPhoneData.m_bBtVoiceRecSupport;
   m_u8AgThreeWayCallSuppFeatures = rfPhoneData.m_u8AgThreeWayCallSuppFeatures;
   AudioOutStatus = rfPhoneData.AudioOutStatus;
   vStringCopy(m_achCellDeviceName, rfPhoneData.m_achCellDeviceName, FC_PHONE_STRING_LENGTH_MAX);
   vStringCopy(m_SubscriberMSISDN, rfPhoneData.m_SubscriberMSISDN, FC_PHONE_STRING_LENGTH_MAX);
}

/*******************************************************************************
 *
 * FUNCTION: operator=
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: fc_phone_tclPhoneData&.
 *
 *******************************************************************************/
fc_phone_tclPhoneData& fc_phone_tclPhoneData::operator=(const fc_phone_tclPhoneData& rfPhoneData) //Info 1720: assignment operator for class 'fc_phone_tclPhoneData' has non-const parameter
{
   // To remove LInt warning 1529
   if( &rfPhoneData == this)
   {
      return *this;
   }

   m_u8NetworkStatus  = rfPhoneData.m_u8NetworkStatus;
   m_u8RoamingStatus  = rfPhoneData.m_u8RoamingStatus;
   m_u8Charge         = rfPhoneData.m_u8Charge;
   m_u8SignalStrength = rfPhoneData.m_u8SignalStrength;
   m_u8BDAddressId=rfPhoneData.m_u8BDAddressId;
   vStringCopy(m_NetworkOperatorName,rfPhoneData.m_NetworkOperatorName, FC_PHONE_STRING_LENGTH_MAX);

   m_bThreeWayCallSupport = rfPhoneData.m_bThreeWayCallSupport ;
   m_bCallWaitingSupport  = rfPhoneData.m_bCallWaitingSupport ;
   m_bInBandRingtoneSupport = rfPhoneData.m_bInBandRingtoneSupport;
   m_bBtVoiceRecSupport = rfPhoneData.m_bBtVoiceRecSupport;
   m_u8AgThreeWayCallSuppFeatures = rfPhoneData.m_u8AgThreeWayCallSuppFeatures;
   // To remove LInt warning 1745
   AudioOutStatus = rfPhoneData.AudioOutStatus;
   vStringCopy(m_achCellDeviceName, rfPhoneData.m_achCellDeviceName, FC_PHONE_STRING_LENGTH_MAX);
   vStringCopy(m_SubscriberMSISDN, rfPhoneData.m_SubscriberMSISDN, FC_PHONE_STRING_LENGTH_MAX);

   return *this;
}


/*******************************************************************************
 *
 * FUNCTION: u16Notifications
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
tU16 fc_phone_tclPhoneData::u16Compare(  
      fc_phone_tclPhoneData& rfPhoneData)
{

   tU16 u16Notifications = 0x0000;

   if(m_u8NetworkStatus != rfPhoneData.m_u8NetworkStatus)
   {
      u16Notifications |= FC_PHONE_PHONEDATA_MASK_NWSTATUS;
   }

   if(m_u8RoamingStatus!= rfPhoneData.m_u8RoamingStatus)
   {
      u16Notifications |= FC_PHONE_PHONEDATA_MASK_ROAMINGSTATUS;
   }

   if(m_u8Charge != rfPhoneData.m_u8Charge)
   {
      ETG_TRACE_USR4(("fc_phone_tclSiriData::m_u8Charge != rfPhoneData.m_u8Charge "));
      u16Notifications |= FC_PHONE_PHONEDATA_MASK_CHARGE;
   }


   if(m_u8SignalStrength != rfPhoneData.m_u8SignalStrength)
   {
      ETG_TRACE_USR4(("fc_phone_tclSiriData::m_u8SignalStrength != rfPhoneData.m_u8SignalStrength "));
      u16Notifications |= FC_PHONE_PHONEDATA_MASK_SIGNALSTRENGTH;
   }

   if(OSAL_s32StringCompare(m_NetworkOperatorName,rfPhoneData.m_NetworkOperatorName) != 0)
   {
      u16Notifications |= FC_PHONE_PHONEDATA_MASK_NWOPNAME;

   }

   if(m_bCallWaitingSupport != rfPhoneData.m_bCallWaitingSupport )
   {
      u16Notifications |= FC_PHONE_PHONEDATA_MASK_CALLWAITING;
   }

   if(m_bThreeWayCallSupport != rfPhoneData.m_bThreeWayCallSupport )
   {
      u16Notifications |= FC_PHONE_PHONEDATA_MASK_THREEWAYCALL;
   }


   if(m_bBtVoiceRecSupport != rfPhoneData.m_bBtVoiceRecSupport )
   {
      u16Notifications |= FC_PHONE_PHONEDATA_MASK_VR;
   }

   if(m_u8AgThreeWayCallSuppFeatures != rfPhoneData.m_u8AgThreeWayCallSuppFeatures
         && m_u8AgThreeWayCallSuppFeatures != FC_PHONE_ENHANCECALLCTRL_UNKNOWN)
   {
      if( (m_u8AgThreeWayCallSuppFeatures & FC_PHONE_ENHANCECALLCTRL_ENDTARGETCALL_MASK)
            != (rfPhoneData.m_u8AgThreeWayCallSuppFeatures & FC_PHONE_ENHANCECALLCTRL_ENDTARGETCALL_MASK) )
         u16Notifications |= FC_PHONE_PHONEDATA_MASK_ENHANCECALLCTRL;
      else if( (m_u8AgThreeWayCallSuppFeatures & FC_PHONE_ENHANCECALLCTRL_SPLITMERGECALLS_MASK)
            != (rfPhoneData.m_u8AgThreeWayCallSuppFeatures & FC_PHONE_ENHANCECALLCTRL_SPLITMERGECALLS_MASK) )
         u16Notifications |= FC_PHONE_PHONEDATA_MASK_ENHANCECALLCTRL;
   }

   return(u16Notifications);
}

#ifdef PHONE_SIRI


/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSiriData
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
fc_phone_tclSiriData::fc_phone_tclSiriData(tVoid)
{
   ETG_TRACE_USR4(("fc_phone_tclSiriData::fc_phone_tclSiriData() ENTERED "));
   m_bSiriAvailable = false;
   m_bSiriEnable = false;
   m_u8SiriNrStatus = FC_PHONE_ENABLED;
   m_eSiriState = INACTIVE;
   // CMG3G-7861 - Siri availability status
   m_eAplSiriState = NOT_AVAILABLE;
   m_u8BDAddressID = INVALID_BDADDRESS_ID;
}
/*******************************************************************************
 *
 * FUNCTION: ~fc_phone_tclSiriData
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
/* Destructor */
fc_phone_tclSiriData::~fc_phone_tclSiriData()
{
   ETG_TRACE_USR4(("fc_phone_tclSiriData::~fc_phone_tclSiriData() ENTERED "));
}
/*******************************************************************************
 *
 * FUNCTION: vSetSiriNrStatus
 *
 * DESCRIPTION: To set the vehicle status
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
tVoid fc_phone_tclSiriData::vSetSiriNrStatus(tU8 u8Status)
{
   ETG_TRACE_USR4(("fc_phone_tclSiriData::vSetSiriNrStatus ENTERED with status : %d", u8Status));
   if(TRUE == m_bSiriAvailable && TRUE == m_bSiriEnable )
   {
      m_u8SiriNrStatus = u8Status;
   }
   else
   {
      ETG_TRACE_USR4(("m_u8SiriNrStatus is set to FC_PHONE_ENABLED"));
      m_u8SiriNrStatus= FC_PHONE_ENABLED;
   }

}
/*******************************************************************************
 *
 * FUNCTION: vSetSiriStatusValues
 *
 * DESCRIPTION: To set the SIRI status for the corresponding device
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
tVoid fc_phone_tclSiriData::vSetSiriStatus(tU8 u8Status)
{
   ETG_TRACE_USR4(("fc_phone_tclSiriData::vSetSiriStatus ENTERED with u8Status: %d", u8Status));
   switch(u8Status)
   {
      case 0:
      {
         ETG_TRACE_USR4(("fc_phone_tclSiriData::vSetSiriStatus ENTERED with case : %d", u8Status));
         m_bSiriAvailable = false;
         m_bSiriEnable   =  false;
         break;
      }
      case 1:
      {
         ETG_TRACE_USR4(("fc_phone_tclSiriData::vSetSiriStatus ENTERED with case : %d", u8Status));

         ETG_TRACE_USR4(("m_u8BDAddressID : %u", m_u8BDAddressID));
         tChar *b_get_Device_AddressId_FromBT = const_cast<tChar *> (fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_u8BDAddressID));

         m_bSiriAvailable = true;
         m_bSiriEnable   = false;
         if((fc_phone_tclSM::m_pDbusIf) && (b_get_Device_AddressId_FromBT))
         {
            ETG_TRACE_USR4(("b_get_Device_AddressId_FromBT : %s", b_get_Device_AddressId_FromBT));
            fc_phone_tclSM::m_pDbusIf->bSetSiriNrStatus(b_get_Device_AddressId_FromBT,(const char)FC_PHONE_ENABLED);
         }
         break;
      }
      case 2:
      {
         ETG_TRACE_USR4(("fc_phone_tclSiriData::vSetSiriStatus ENTERED with case : %d", u8Status));
         m_bSiriAvailable = true;
         m_bSiriEnable    = false;
         break;
      }
      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSiriData::vSetSiriStatusValues default: ENTERED "));
      }
   }

   // CMG3G-7861 - Siri availability status
   m_eAplSiriState = static_cast<T_eAplSiriState> (u8Status);
   fc_phone_tclService_Telephone::pGetInstance()->vSendBtVRExtendedStatus(m_u8BDAddressID);
   ETG_TRACE_USR3(("m_bSiriAvailable: %d, m_bSiriEnable: %d", m_bSiriAvailable, m_bSiriEnable));
}

/*******************************************************************************
 *
 * FUNCTION: vDisableSiri
 *
 * DESCRIPTION: To vDisableSiri
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/

tVoid fc_phone_tclSiriData::vDisableSiri()
{
   ETG_TRACE_USR4(("fc_phone_tclSiriData::vDisableSiri ENTERED "));
   m_bSiriAvailable = false;
   m_bSiriEnable = false;
   m_u8SiriNrStatus = FC_PHONE_ENABLED;//1
   m_eSiriState = INACTIVE;
   m_u8BDAddressID = INVALID_BDADDRESS_ID;
   // CMG3G-7861 - Siri availability status
   m_eAplSiriState = NOT_AVAILABLE;
}

/*******************************************************************************
 *
 * FUNCTION: vSetSiriState
 *
 * DESCRIPTION: To vSetSiriState
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/

tVoid fc_phone_tclSiriData::vSetSiriState(T_eSiriStates eSiriState)
{
   ETG_TRACE_USR4(("fc_phone_tclSiriData::vSetSiriState ENTERED with eSiriState: %d", (tU16)eSiriState));

   if(m_bSiriAvailable == TRUE && m_bSiriEnable == TRUE)
   {
      m_eSiriState = eSiriState;
      ETG_TRACE_USR4(("New Siri State m_eSiriState: %d", (tU16)m_eSiriState));
   }
}

/*******************************************************************************
 *
 * FUNCTION: bIsSiriStateActive
 *
 * DESCRIPTION: To check whether SIRI state is ACTIVE
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/

tBool  fc_phone_tclSiriData::bIsSiriStateActive()
{
   ETG_TRACE_USR4(("fc_phone_tclSiriData::bIsSiriActive"));
   if(ACTIVE == m_eSiriState)
   {
      ETG_TRACE_USR4(("bIsSiriActive::ACTIVE"));
      return TRUE;
   }
   else
   {
      return FALSE;
   }

}

// CMG3G-7861 - Siri availability status
/*******************************************************************************
 *
 * FUNCTION: eGetAplSiriState
 *
 * DESCRIPTION: To check whether Siri is enabled or not
 *
 * PARAMETER: IN: NONE
 *
 * RETURNVALUE: SIRI STATE.
 * 0x00 - Siri is not available in this platform
 * 0x01  Siri is available and enabled
 * 0x02 - Siri is available but not enabled
 *
 *******************************************************************************/

T_eAplSiriState fc_phone_tclSiriData::eGetAplSiriState()
{
   ETG_TRACE_USR4(("fc_phone_tclSiriData::eGetAplSiriState"));
   return m_eAplSiriState;
}

/*******************************************************************************
 *
 * FUNCTION: vSiriNRCallback
 *
 * DESCRIPTION: To vSiriNRCallback
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/

tVoid fc_phone_tclSiriData::vSiriNRCallback()
{
   ETG_TRACE_USR4(("fc_phone_tclSiriData::vSiriNRCallback ENTERED"));

   if(true == m_bSiriAvailable && INACTIVE == m_eSiriState)
   {
      ETG_TRACE_USR3(("Siri Session is enabled"));
      m_bSiriEnable = true;

      ETG_TRACE_USR3(("EyeFreeMode to be enabled"));

      tChar *pDevAddress = const_cast<tChar *> (fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_u8BDAddressID));
      if((fc_phone_tclSM::m_pDbusIf) && (pDevAddress))
      {
         ETG_TRACE_USR4(("pDevAddress : %s", pDevAddress));
         fc_phone_tclSM::m_pDbusIf->bSetSiriEfm(pDevAddress,(const char)FC_PHONE_ENABLED);
      }
   }
   else
   {
      ETG_TRACE_USR3(("Siri Session is not enabled"));
   }
}

/*******************************************************************************
 *
 * FUNCTION: vEnableSiri
 *
 * DESCRIPTION: To Enable Siri on device connection
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
tVoid fc_phone_tclSiriData::vEnableSiri(char *pActiveDeviceAddress)
{
   ETG_TRACE_USR4(("fc_phone_tclSiriData::vEnableSiriRequest ENTERED with pActiveDeviceAddress : %s", pActiveDeviceAddress));
   VehicleInformation oDevInfo;
   (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerBTSettings->vGetDeviceInformation(oDevInfo);

   if(fc_phone_tclSM::m_pDbusIf && strlen(pActiveDeviceAddress) > 0)
   {
      m_u8BDAddressID = fc_phone_tclDeviceList::getInstance()->u8GetBDAddressIdFromBDAddress(pActiveDeviceAddress);
      if(m_u8BDAddressID != INVALID_BDADDRESS_ID)
      {
         fc_phone_tclSM::m_pDbusIf->bEnableSiri(pActiveDeviceAddress,oDevInfo);
      }
      else
      {
         ETG_TRACE_USR4(("vEnableSiriRequest with invalid BTAddressID"));
      }
   }
}

tVoid fc_phone_tclSiriData::vGetActiveDeviceAddress(char *pActiveDeviceAddress)
{
   ETG_TRACE_USR4(("fc_phone_tclSiriData::vGetActiveDeviceAddress ENTERED"));

   tU8 u8_ActiveBDAddressId = INVALID_BDADDRESS_ID;
   tChar *pBDAddress = NULLPTR;
   tBool b_getActiveDeviceAddress = fc_phone_tclService_Telephone::pGetInstance()->b_get_ActiveDevice_AddressId_FromBT(&u8_ActiveBDAddressId);
   ETG_TRACE_USR4(("b_getActiveDeviceAddress: %d ",b_getActiveDeviceAddress));
   if(TRUE == b_getActiveDeviceAddress)
      pBDAddress = const_cast<tChar *> (fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(u8_ActiveBDAddressId)); //CMG3G-4847 - To solve Lint
   else
   {
      ETG_TRACE_USR4(("m_u8BDAddressID value is :%d",m_u8BDAddressID));
      pBDAddress = const_cast<tChar *> (fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_u8BDAddressID)); //CMG3G-4847 - To solve Lint
   }
   if (pBDAddress && (pBDAddress[0] != '\0'))
   {
      vStringCopy( pActiveDeviceAddress,pBDAddress,PHONE_BDADRESS_LENGTH);
      ETG_TRACE_USR4(("u8_ActiveDeviceAddress: %s ",pActiveDeviceAddress));
   }

}
#endif
