/*******************************************************************************
 *
 * FILE:          FC_Phone_CallManager.h
 *
 * SW-COMPONENT:  FC_Phone application
 *
 * PROJECT:
 *
 * DESCRIPTION:    call handler
 *
 * AUTHOR:
 *
 * COPYRIGHT:
 *
 *******************************************************************************/

#ifndef _FC_PHONE_CALLMANAGER_H_
#define _FC_PHONE_CALLMANAGER_H_


/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/

#define FC_PHONE_MAX_CALL       2

#define FC_PHONE_CALLMANAGER_INDEX_UNKNOWN		       0xFF		
#define FC_PHONE_CALLMANAGER_CALLINSTANCE_UNKNOWN      0xFF
#define FC_PHONE_CALLMANAGER_CALLDIRECTION_UNKNOWN     0xFF
#define FC_PHONE_CALLMANAGER_CALLSTATE_UNKNOWN         0xFF
#define FC_PHONE_CALLMANAGER_CALLMODE_UNKNOWN          0xFF
#define FC_PHONE_CALLMANAGER_CALLTYPE_UNKNOWN          0xFF
#define FC_PHONE_CALLMANAGER_CALLHANDLE_UNKNOWN        0xFF

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

typedef struct
{
   tU16 u16CallInstance;
   //call status info
   tU8 u8CallState;
   tU8 u8CallMode;
   tU8 m_u8CallType;
   tU8 m_u8Handle;
}fcPhone_CallData ;

typedef enum
{
   EN_NO_MATCH,
   EN_NUM_MATCH,
   EN_CH_MATCH
}tenCSMatch;

class fc_phone_tclCallManager FINAL
{

public:
   /* Default Constructor */
   fc_phone_tclCallManager(fc_phone_tclSMManager*& rfpSMManager);
   /* Destructor */
   virtual ~fc_phone_tclCallManager();
   tVoid vNewCallStatus(const T_CallData* const prCallData);
   tVoid vPrintCallStatusHdlr_callInstanceMapTable();
   tVoid vDeleteCallHandler_callInstanceMapTableEntry(tU16 u16location);
   tU16  Find_CallHndlrToBeDeleted(const T_CallData* const prCallData) ;
   tU16  Find_CallHndlrToUpdateCallstatus(const T_CallData* const prCallData) ;
   tVoid vDeleteCallInstanceFromCMHandlerMapTable(tU16 u16CallInstance) ;
   tU16 u16GetDbusCallInstanceFromCM(tU16 u16CallInstance);
   tU8 getCallState(tU16 u16index);
   tBool bCheckCallActive(tU16 u16CallInstance);
   tVoid vUpdateCallStatusToStateMachines(const T_CallData* const prCallData,tU8 u8tHandle); //Fix for GMMY15-8000
   tBool bCheckUpdateInCallHandlerTableEntries(const T_CallData* const prCallData);
   tVoid vSendIdleCallstatusToSM(tU16 u16CallInstance,tU8 u8CallTotal =0);
   tVoid vAddEntryToCallHandlerMaptable(const T_CallData* const prCallData);
   static tU16   m_u16Count;
   tVoid vResetCallHandlerMaptable();
   tVoid vAddEntryToCallHandlerMaptablewithCIId(const T_CallData* const prCallData, tU16 u16ID);
private:
   tVoid vInit(tU16 u16index);
   tBool bCompare(const T_CallData* const prCallData,tU8 index = 0 );

   fc_phone_tclSMManager*  m_poSMManager ;
   fcPhone_CallData        m_callHandlerMaptable[FC_PHONE_MAX_CALL] ;

};

#endif // _FC_PHONE_CALLMANAGER_H_

