/******************************************************************************
 *
 * FILE:          FC_Phone_CallManager.cpp
 *
 * SW-COMPONENT:  FC_Phone application
 *
 * PROJECT:
 *
 * DESCRIPTION:   Implements class fc_phone_tclCallManager
 *
 * AUTHOR:
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/
#include "../Interface/FC_Phone_DBusInterface.h"
#include "../StateMachines/FC_Phone_SMIncludes.h"
#include "FC_Phone_CallManager.h"
#include "../WorkQueue/FC_Phone_WorkQueue.h"
#include "../WorkQueue/FC_Phone_WorkQueueScheduler.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_PHONE_APPLICATION
#include "trcGenProj/Header/FC_Phone_CallManager.cpp.trc.h"
#endif

tU16 fc_phone_tclCallManager::m_u16Count = 0;
/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclCallManager
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
fc_phone_tclCallManager::fc_phone_tclCallManager(fc_phone_tclSMManager*& rfpSMManager)
{
   ETG_TRACE_USR4((" fc_phone_tclCallManager::fc_phone_tclCallManager ENTERED "));
   m_poSMManager = rfpSMManager ;
   vResetCallHandlerMaptable();
}

/*******************************************************************************
 *
 * FUNCTION: ~fc_phone_tclCallManager
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
/* Destructor */
fc_phone_tclCallManager::~fc_phone_tclCallManager()
{
   m_poSMManager = NULLPTR;
}
/*******************************************************************************
 *
 * FUNCTION: vInit
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
tVoid fc_phone_tclCallManager::vInit(tU16 u16index)
{
   ETG_TRACE_USR4((" fc_phone_tclCallManager::vInit ENTERED "));
   m_callHandlerMaptable[u16index].u16CallInstance  = FC_PHONE_CALLMANAGER_CALLINSTANCE_UNKNOWN;
   m_callHandlerMaptable[u16index].u8CallMode  = FC_PHONE_CALLMANAGER_CALLMODE_UNKNOWN;
   m_callHandlerMaptable[u16index].u8CallState  	  = FC_PHONE_CALLMANAGER_CALLSTATE_UNKNOWN;
   m_callHandlerMaptable[u16index].m_u8CallType  	  = FC_PHONE_CALLMANAGER_CALLTYPE_UNKNOWN;
   m_callHandlerMaptable[u16index].m_u8Handle = FC_PHONE_CALLMANAGER_CALLHANDLE_UNKNOWN;
}


/*******************************************************************************
 *
 * FUNCTION: vResetCallHandlerMaptable
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
tVoid fc_phone_tclCallManager::vResetCallHandlerMaptable()
{
   ETG_TRACE_USR4((" fc_phone_tclCallManager::vResetCallHandlerMaptable ENTERED "));
   for(tU16 u16index =0 ;u16index < FC_PHONE_MAX_CALL;u16index++ )
   {
      vInit(u16index);
   }
   m_u16Count = 0;
}

/*******************************************************************************
 *
 * FUNCTION: u16Compare
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
tBool fc_phone_tclCallManager::bCompare(const T_CallData* const prCallData,tU8 indx)
{
   ETG_TRACE_USR4((" fc_phone_tclCallManager::bCompare ENTERED "));

   fc_phone_tclCallInstance* pCallInst = m_poSMManager->getCallInstancebyUniqueId(m_callHandlerMaptable[indx].u16CallInstance);

   ETG_TRACE_USR4(("m_callHandlerMaptable[indx].u8CallMode:: %d v/s prCallData->rCallStatus.u8CallMode:: %d"
         ,m_callHandlerMaptable[indx].u8CallMode,prCallData->rCallStatus.u8CallMode));
   ETG_TRACE_USR4(("m_callHandlerMaptable[indx].m_u8CallType:: %d v/s prCallData->rCallStatus.u8CallType:: %d"
         ,m_callHandlerMaptable[indx].m_u8CallType,prCallData->rCallStatus.u8CallType));
   if(pCallInst)
   {
      ETG_TRACE_USR4(("pCallInst->m_u8CallDirection:: %d v/s prCallData->rCallStatus.u8CallDirection:: %d"
            ,pCallInst->m_u8CallDirection,prCallData->rCallStatus.u8CallDirection));

      ETG_TRACE_USR4(("pCallInst->m_strCellNumber:: %s ",pCallInst->m_strCellNumber));

      ETG_TRACE_USR4((" prCallData->rCallStatus.achCallNumber:: %s",prCallData->rCallStatus.achCallNumber));

   }


   // Fix for NCG3D-76228.
   // Call mode changes from "Unknown" to "Voice" during Swapping.
   // The check for call mode and call type has been removed.
   if((pCallInst) && (pCallInst->m_u8CallDirection == prCallData->rCallStatus.u8CallDirection)
         &&(0 == u8StringCompare( pCallInst->m_strCellNumber , prCallData->rCallStatus.achCallNumber)
               &&(m_callHandlerMaptable[indx].m_u8Handle == prCallData->rCallStatus.u8CallHandle ))
   )
   {
      return TRUE ;
   }
   else
   {
      return FALSE;
   }

}


/*******************************************************************************
 *
 * FUNCTION: vPrintCallStatusHdlr_callInstanceMapTable
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclCallManager::vPrintCallStatusHdlr_callInstanceMapTable()
{
   ETG_TRACE_USR4(("PRINTING CallStatusHdlr_callInstanceMapTable STATUS"));
   ETG_TRACE_USR3(("HndlrInstanceMapTable.u16Count :: %d ",m_u16Count));

   for(tU16 indx=0; indx< FC_PHONE_MAX_CALL ;indx++)
   {
      ETG_TRACE_USR4(("m_callHandlerMaptable.u16CallInstance[%d] :: 0x%x ",indx,m_callHandlerMaptable[indx].u16CallInstance));
      ETG_TRACE_USR4(("m_callHandlerMaptable.u8CallState[%d] :: 0x%x ",indx,m_callHandlerMaptable[indx].u8CallState));
      ETG_TRACE_USR4(("m_callHandlerMaptable.u8CallMode[%d] :: 0x%x ",indx,m_callHandlerMaptable[indx].u8CallMode));
      ETG_TRACE_USR4(("m_callHandlerMaptable.m_u8CallType[%d] :: 0x%x ",indx,m_callHandlerMaptable[indx].m_u8CallType));
      ETG_TRACE_USR4(("m_callHandlerMaptable.m_u8Handle[%d] :: 0x%x ",indx,m_callHandlerMaptable[indx].m_u8Handle));
   }
}

/*******************************************************************************
 *
 * FUNCTION: vNewCallStatus
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclCallManager::vNewCallStatus(const T_CallData* const prCallData)
{
   ETG_TRACE_USR4(("fc_phone_tclCallManager::vNewCallStatus"));
   ETG_TRACE_USR4(("m_u16Count:: %d u8CallTotal:: %d", m_u16Count, prCallData->rCallStatus.u8CallTotal));
   tU16 ret_callInstance =  FC_PHONE_SMMANAGER_CALLINSTANCEID_UNKNOWN;

   if(prCallData->rCallStatus.u8CallHandle > 2)
   {
      ETG_TRACE_USR4(("Ignore CallHandle greater than 2 directly"));
      return;
   }
   //ADD:: the  count is less than callTotal
   if(m_u16Count < prCallData->rCallStatus.u8CallTotal)
   {
      //do new entry to table and update callInstance
      if((m_u16Count < prCallData->rCallStatus.u8CallHandle))
      {
         ETG_TRACE_USR4(("Adding the new entry to the call_handler_Map_table "));
         vAddEntryToCallHandlerMaptable(prCallData);

         ret_callInstance = m_callHandlerMaptable[prCallData->rCallStatus.u8CallHandle-1].u16CallInstance ;
         vPrintCallStatusHdlr_callInstanceMapTable();
         //start
         tU16 callInstance =  ret_callInstance;
         ETG_TRACE_USR4(("$$$ callInstance- %d ",callInstance));

         if((fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->oGetCallInstances()[0].m_u16Id == ret_callInstance)
            callInstance = (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->oGetCallInstances()[1].m_u16Id;
         else
            callInstance = (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->oGetCallInstances()[0].m_u16Id;

         ETG_TRACE_USR4(("$$$ callInstance- %d ",callInstance));
         if(TRUE == (fc_phone_tclApp::m_poMainAppInstance)->m_poTimer->s32GetAliveTimerId(static_cast<tU16>(FC_PHONE_DIAL_CALLSTATUS_FAILURE_TIMER_ID + callInstance)))
         {
            ETG_TRACE_USR4(("Timer running "));
            //send idle callstatus
            if(prCallData->rCallStatus.u8CallState == PHONE_CALLSTATE_INCOMING)
            {
               ETG_TRACE_USR4(("Sending CALL status Idle to the deleting callInstance "));
               vSendIdleCallstatusToSM(callInstance,prCallData->rCallStatus.u8CallTotal);
            }
         }
         else
         {
            ETG_TRACE_USR4(("Timer not running "));
         }
         //end
      }
     // mu16count is already 2 and there were 4 calls  phone device and second call is terminated..
      else  // bothered only about first two callstatus.
      {
         ret_callInstance = m_callHandlerMaptable[prCallData->rCallStatus.u8CallHandle-1].u16CallInstance ;

         // 2HFP related changes. The 1st call status is not yet inserted into m_callHandlerMaptable
         if(FC_PHONE_CALLMANAGER_CALLINSTANCE_UNKNOWN == ret_callInstance)
         {
            ETG_TRACE_USR4(("FC_PHONE_CALLMANAGER_CALLINSTANCE_UNKNOWN == ret_callInstance"));
            vAddEntryToCallHandlerMaptable(prCallData);
            ret_callInstance = m_callHandlerMaptable[prCallData->rCallStatus.u8CallHandle-1].u16CallInstance ;
         }
         else
         {
            // check if its an update for already existing call
            tBool bChangeinCS = bCheckUpdateInCallHandlerTableEntries(prCallData);

            if(bChangeinCS == FALSE)
            {
               // update for the already existing calls in maptable.
               //return the callInstance from table
               ETG_TRACE_USR4(("Count increased But this call Update is for previous call"));
               //update the call state
               m_callHandlerMaptable[prCallData->rCallStatus.u8CallHandle-1].u8CallState = prCallData->rCallStatus.u8CallState ;
            }
         }
      }
   }

   //Delete:: the  count is greater than callTotal
   else if(m_u16Count > prCallData->rCallStatus.u8CallTotal)
   {
      //delete the entry and update the handler callInstance map table and return the callInstance
      ETG_TRACE_USR4(("Deleting the one entry  Print Handler Table BEFORE deleting the Entry "));
      vPrintCallStatusHdlr_callInstanceMapTable();

      //when call Handle Received 0, send all the SM in IDLE state.
      if(prCallData->rCallStatus.u8CallHandle == 0)
      {
         //Send Idle to all the Active SMs
         ETG_TRACE_USR4(("prCallData->rCallStatus.u8CallHandle == 0 ,send Idle to all SMmanager "));
         //tU16 u16TempCounter = m_u16Count ;
         for(tU16 u16Index = 0; u16Index < FC_PHONE_MAX_CALL ; u16Index++)
         {
            ETG_TRACE_USR4(("send Idle to CallInstance ::%d ",m_callHandlerMaptable[0].u16CallInstance));
            ret_callInstance = u16Index ;//m_callHandlerMaptable[0].u16CallInstance ;
            vDeleteCallHandler_callInstanceMapTableEntry(0);
            (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vResetDiallerInfoForCallInstance(static_cast<tU8>(ret_callInstance));
            m_poSMManager->vNewCallStatus(prCallData,ret_callInstance) ;
         }

         //gmmy15-11360- unlock and reset on receiving call status IDLE
         fc_phone_tclPhoneMutex::PhoneMutexUnlock();
         (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vResetStoredCallInstance(0x00);

         m_u16Count = 0;
         if(prCallData->rCallStatus.u8CallTotal == 0)
         {
            if(((fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vGetAudioTransferStatus() == FC_PHONE_DBUS_SCO_CONN_DISCONNECTED))
            {
               ETG_TRACE_USR4(("Reset Audio Status"));
               (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vResetAudioTranferStatusOnEndCall();
            }

            (fc_phone_tclApp::m_poMainAppInstance)->m_poAudioManager->vReleaseUsedAudioChannels();
            (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vResetSMManager();
         }
      }
      // newly added to handle multiple calls.
      //  received CS doesnt match any entry in maptable, 
      else 
      {
         ETG_TRACE_USR4(("NO match for the CS with maptable entry "));
         // both the calls in maptable entry got ended. so need to clear both slots,  send idle to all SM. and add new entry to maptable for the new CS.

         tBool bChangeinCS = bCheckUpdateInCallHandlerTableEntries(prCallData);

         if(FALSE == bChangeinCS)
         {
            //find, which callHandler got disconnected.
            // check if the received CS is different from both the CS info stored in Maptable.
            // in which case IDLE should be sent to all the existing CI and new CS has to be added.

            //tBool bIsCSchange = bCheckUpdateInCallHandlerTableEntries(prCallData);
            tU16 u16_callHndlr = Find_CallHndlrToBeDeleted(prCallData) ;
            //send Idle to deleted call instance
            ETG_TRACE_USR4(("Sending CALL status Idle to the deleting callInstance "));
            //gmmy15-11360- unlock and reset  on receiving call status IDLE for single call in two call scenario
            (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vResetStoredCallInstance(0x00);
            vSendIdleCallstatusToSM(m_callHandlerMaptable[u16_callHndlr-1].u16CallInstance, prCallData->rCallStatus.u8CallTotal);
            //delete the entry from callHandler table
            vDeleteCallHandler_callInstanceMapTableEntry(static_cast<tU16>(u16_callHndlr-1));
            // 3 calls active, all 3 calls end no IDLE callstatus received but CS received for the same number which were previouslt active.
            //vUpdateCallStatusToStateMachines(prCallData,prCallData->rCallStatus.u8CallHandle-1);
            m_callHandlerMaptable[prCallData->rCallStatus.u8CallHandle-1].u8CallState = prCallData->rCallStatus.u8CallState;
            m_callHandlerMaptable[prCallData->rCallStatus.u8CallHandle-1].m_u8Handle = prCallData->rCallStatus.u8CallHandle;
         }
         fc_phone_tclPhoneMutex::PhoneMutexUnlock();
         ret_callInstance = m_callHandlerMaptable[prCallData->rCallStatus.u8CallHandle -1].u16CallInstance ;
      }
      ETG_TRACE_USR4(("Print Handler Table AFTER deleting the Entry "));
      vPrintCallStatusHdlr_callInstanceMapTable();
      /*GMMY16-7759 Not Possible to Switch to second call, if first ongoing call is ended from Handset
      When any call is ended, waiting state of the other call instance should be set to FALSE as it is not waiting any more.*/

      (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vCheckAndUpdateCallWaitingState();
      //End of fix GMMY16-7759
   }
   else
   {

      tU8 u8_MapTableIndex = FC_PHONE_CALLMANAGER_INDEX_UNKNOWN;
      //return the callInstance from table
      ETG_TRACE_USR4(("table count is equal to CallTotal, Returing the Mapped CallInstance"));
      if((m_u16Count ==  0) && (prCallData->rCallStatus.u8CallHandle == 0))
      {
         for(tU16 u16Index = 0; u16Index < FC_PHONE_MAX_CALL ; u16Index++)
         {
            ETG_TRACE_USR4(("send Idle to CallInstance ::%d ",u16Index));
            ret_callInstance = u16Index;
            (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vResetDiallerInfoForCallInstance(static_cast<tU8>(u16Index));
            m_poSMManager->vNewCallStatus(prCallData,ret_callInstance) ;
         }
      }
      else
      {
         //GMMY15-10711
         //When call  status update is received for two call scenario, Use call number to find call instance.
         if( m_u16Count == 2 )
         {
            bCheckUpdateInCallHandlerTableEntries(prCallData);
            //phone number will not be available in callinstance for a new number. so find_Callhandler would fail!
            //u8_MapTableIndex = Find_CallHndlrToUpdateCallstatus(prCallData);
         }
         // map table index is same as callhandle 
         u8_MapTableIndex = static_cast<tU8>(prCallData->rCallStatus.u8CallHandle-1);

         ETG_TRACE_USR4(("u8_MapTableIndex %d",u8_MapTableIndex));
         //Fix for GMMY15-8000
         /*Root Cause:For the call handle 2, with call total as 2, Phone F-Block didn't receive any IDLE status for the second call.
         And from the next callstatus update received the call handle was same(for both the Numbers). 
         Hence Phone Fblock doesn't know that the second call has ended and just updates the call state in callHandlerMap table. 
         Because of this the alert was not displayed for the new incoming call since F-Block treated it as an already existing call.*/

         // has to be called for both 1 call and 2 call 
         vUpdateCallStatusToStateMachines(prCallData,u8_MapTableIndex);

         ret_callInstance = m_callHandlerMaptable[u8_MapTableIndex].u16CallInstance ;
         //update the call state
         m_callHandlerMaptable[u8_MapTableIndex].u8CallState = prCallData->rCallStatus.u8CallState ;
         vPrintCallStatusHdlr_callInstanceMapTable();
      }
   }

   if(prCallData->rCallStatus.u8CallHandle != 0)
   {
      //send calldata to SMmanager to route and send to corresponding SM
      m_poSMManager->vNewCallStatus(prCallData,ret_callInstance);
   }
}


/*******************************************************************************
 *
 * FUNCTION: vDeleteCallHandler_callInstanceMapTableEntry
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/

tVoid fc_phone_tclCallManager::vDeleteCallHandler_callInstanceMapTableEntry(tU16 u16location)
{
   ETG_TRACE_USR4((" fc_phone_tclCallManager::vDeleteCallHandler_callInstanceMapTableEntry ENTERED "));
   //delete the call instance and push Up the table
   tU16 indx = u16location;
   for( indx= u16location; indx< (FC_PHONE_MAX_CALL-1) ;indx++)
   {
      m_callHandlerMaptable[indx].u16CallInstance = m_callHandlerMaptable[indx+1].u16CallInstance;

      m_callHandlerMaptable[indx].u8CallState = m_callHandlerMaptable[indx+1].u8CallState;
      m_callHandlerMaptable[indx].u8CallMode = m_callHandlerMaptable[indx+1].u8CallMode;
      m_callHandlerMaptable[indx].m_u8CallType = m_callHandlerMaptable[indx+1].m_u8CallType;
      m_callHandlerMaptable[indx].m_u8Handle = m_callHandlerMaptable[indx+1].m_u8Handle;
   }
   //update the last location of table and count
   m_callHandlerMaptable[indx].u16CallInstance =FC_PHONE_CALLMANAGER_CALLINSTANCE_UNKNOWN ;
   vInit(indx) ;
   m_u16Count--;
   /*With no active calls reset microphone to unmute state */
   if(m_u16Count == 0)
   {
      (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vMuteMicroPhone(FALSE,FALSE);
   }
}


/*******************************************************************************
 *
 * FUNCTION: Find_CallHndlrToBeDeleted
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tU16 fc_phone_tclCallManager::Find_CallHndlrToBeDeleted(const T_CallData* const prCallData)
{
   ETG_TRACE_USR4((" fc_phone_tclCallManager::Find_CallHndlrToBeDeleted ENTERED "));
   if(TRUE == bCompare(prCallData))
   {
      return 2 ;

   }
   else
   {
      return 1 ;
   }


}

/*******************************************************************************
 *
 * FUNCTION: vDeleteCallInstanceFromCMHandlerMapTable
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclCallManager::vDeleteCallInstanceFromCMHandlerMapTable(tU16 u16CallInstance)
{
   ETG_TRACE_USR4(("vDeleteCallInstanceFromCMHandlerMapTable delete u16CallInstance %d",u16CallInstance));
   ETG_TRACE_USR4(("m_u16Count :: %d",m_u16Count));

   for(tU16 u16index =0 ;u16index < m_u16Count ;u16index++)
   {
      if(u16CallInstance == m_callHandlerMaptable[u16index].u16CallInstance)
      {
         ETG_TRACE_USR4(("CallHandler MAP Table BEFORE deleting"));
         vPrintCallStatusHdlr_callInstanceMapTable();
         //delete corresponding Map Table entry
         vDeleteCallHandler_callInstanceMapTableEntry(u16index);
         ETG_TRACE_USR4(("CallHandler MAP Table AFTER deleting"));
         vPrintCallStatusHdlr_callInstanceMapTable();
      }

   }
}

/*******************************************************************************
 *
 * FUNCTION: GetDbusCallInstanceFromCM
 *
 * DESCRIPTION: 	HMI sends call instance which was active before merge as parameter for Split call method start.
				Value of which is either 0 or 1. To DBus FC_phone should send 1 or 2 for 0 or 1 received respectively.
				This function does the conversion.
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tU16 fc_phone_tclCallManager::u16GetDbusCallInstanceFromCM(tU16 u16CallInstance)
{
   ETG_TRACE_USR4(("ENTER: fc_phone_tclCallManager::u16GetDbusCallInstanceFromCM "));

   for(tU16 u16index =0 ;u16index < m_u16Count ;u16index++)
   {
      if(u16CallInstance == m_callHandlerMaptable[u16index].u16CallInstance)
      {
         //FIX GMMY15-7216 Swapping of hold and active calls during merge and unmerge of calls.
         //When there are two calls and first one is ended, the next call made by user takes index zero in m_callHandlerMaptable.
         //Hence to find corresponding instance to be sent to DBus, u16index + 1 is not correct, since it will give value as 2 instead of 1 in this case.
         //Always sent u16CallInstance+1 to Dbus; which is received call instance from HMI, plus 1.
         return (static_cast<tU16>(u16CallInstance+1)) ;
      }
   }
   ETG_TRACE_ERR(("Error :: no matching callinstance found in CallManager table "));
   return FC_PHONE_CALLINSTANCE_UNKNOWN ;
}
/*******************************************************************************
 *
 * FUNCTION: getCallState
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tU8 fc_phone_tclCallManager::getCallState(tU16 u16index)
{
   ETG_TRACE_USR4(("ENTER: fc_phone_tclCallManager::updatecallState "));
   tU8 u8CallState = 0;
   ETG_TRACE_USR4(("m_callHandlerMaptable[u16index].u8CallState = %d", m_callHandlerMaptable[u16index].u8CallState));
   u8CallState = m_callHandlerMaptable[u16index].u8CallState;
   ETG_TRACE_USR4((" u8CallState = %d", u8CallState));
   ETG_TRACE_USR4(("EXIT: fc_phone_tclCallManager::updatecallState "));
   return u8CallState;
}
/*******************************************************************************
 *
 * FUNCTION: bCheckCallActive
 *
 * DESCRIPTION: To Check whether call instance exists or not
 *
 * PARAMETER:
 *
 * RETURNVALUE:  tBool : success/failure
 *
 ********************************************************************************/
tBool fc_phone_tclCallManager::bCheckCallActive(tU16 u16CallInstance)
{
   ETG_TRACE_USR4(("ENTER: fc_phone_tclCallManager::bCheckCallActive entered with u16CallInstance: %d", u16CallInstance));
   if(0xFF == u16CallInstance)
   {
      if(m_u16Count > 0)
      {
         ETG_TRACE_USR4((" %d calls are Active ",m_u16Count));
         return TRUE ;
      }
      else
      {
         ETG_TRACE_USR4((" No Call Active for HANGUP ALL "));
      }
   }
   else
   {
      for(tU16 u16index =0 ;u16index < m_u16Count ;u16index++)
      {
         if(u16CallInstance == m_callHandlerMaptable[u16index].u16CallInstance)
         {
            ETG_TRACE_USR4(("Call Instance %d is ACTIVE ",u16CallInstance));
            return TRUE;
         }
      }
   }
   ETG_TRACE_USR4(("Call Instance %d is NOT ACTIVE ",u16CallInstance));
   //print map table in case of failure
   vPrintCallStatusHdlr_callInstanceMapTable();
   return FALSE;
}
/*******************************************************************************
 *
 * FUNCTION: vUpdateCallStatusToStateMachines
 *
 * DESCRIPTION:To check the CallCount
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclCallManager::vUpdateCallStatusToStateMachines(const T_CallData* const prCallData,tU8 u8tHandle)
{
   ETG_TRACE_USR4(("***vUpdateCallStatusToStateMachines Entered.. "));

   // gmmy15-5175 for CDMA phone
   //Fix for GMMY15-8000
	if( FC_PHONE_MAX_CALL > u8tHandle )
   {
      if( prCallData->rCallStatus.u8CallState != m_callHandlerMaptable[u8tHandle].u8CallState)
      {
         ETG_TRACE_USR4(("Previous callstate not equal to current callstate"));
         tU8 u8prCallstate= prCallData->rCallStatus.u8CallState ;

         if((u8prCallstate== PHONE_CALLSTATE_ALERTING ||u8prCallstate == PHONE_CALLSTATE_DIALING ||
               u8prCallstate == PHONE_CALLSTATE_WAITING || u8prCallstate == PHONE_CALLSTATE_INCOMING)&& (
               m_callHandlerMaptable[u8tHandle].u8CallState ==PHONE_CALLSTATE_ACTIVE 
               || m_callHandlerMaptable[u8tHandle].u8CallState ==PHONE_CALLSTATE_HELD))

         {
            ETG_TRACE_USR4(("***First ACTIVE call got ended and a new call in dialing state.. "));
            //delete the entry and update the handler callInstance map table and return the callInstance
            ETG_TRACE_USR4(("***Deleting the one entry  Print Handler Table BEFORE deleting the Entry "));
            vPrintCallStatusHdlr_callInstanceMapTable();

            //when state changes for the same handle , send  IDLE state.
            if(prCallData->rCallStatus.u8CallTotal == 1)
            {
               //Send Idle to all the Active SMs
               ETG_TRACE_USR4(("***prCallData->rCallStatus.u8CallTotal == 1 ,send Idle to all SMmanager "));

               for(tU16 u16Index = 0; u16Index < FC_PHONE_MAX_CALL ; u16Index++)
               {
                  if(m_callHandlerMaptable[u16Index].u16CallInstance != FC_PHONE_CALLMANAGER_CALLINSTANCE_UNKNOWN)
                  {
                     ETG_TRACE_USR4(("***send Idle to CallInstance ::%d ",m_callHandlerMaptable[0].u16CallInstance));
                     vDeleteCallHandler_callInstanceMapTableEntry(0);
                     vSendIdleCallstatusToSM(u16Index);
                  }
               }
               m_u16Count = 0;

               if(((fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vGetAudioTransferStatus() == FC_PHONE_DBUS_SCO_CONN_DISCONNECTED))
               {
                  ETG_TRACE_USR4(("***Reset Audio Status"));
                  (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vResetAudioTranferStatusOnEndCall();
               }
               (fc_phone_tclApp::m_poMainAppInstance)->m_poAudioManager->vReleaseUsedAudioChannels();
               (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vResetSMManager();

            }
            else
            {
               //send Idle to deleted call instance
               vSendIdleCallstatusToSM(m_callHandlerMaptable[u8tHandle].u16CallInstance,prCallData->rCallStatus.u8CallTotal);
               //delete the entry from callHandler table
               vDeleteCallHandler_callInstanceMapTableEntry(u8tHandle);
            }
            ETG_TRACE_USR4(("***Print Handler Table AFTER deleting the Entry "));
            vPrintCallStatusHdlr_callInstanceMapTable();

            //do new entry to table and update callInstance
            vAddEntryToCallHandlerMaptable(prCallData);
            vPrintCallStatusHdlr_callInstanceMapTable();
         }
      }
   }
} //gmmy15-5175 for CDMA phone
//Fix for GMMY15-8000

//SUZUKI-22574 - To handle if there are more than 2 call in phone device.
/*******************************************************************************
*
* FUNCTION: bCheckUpdateInCallHandlerTableEntries
*
* DESCRIPTION:  
* Check whether the new call status information has update for the already 
* existing calls in call handler map table [OR]
* Whether an already existing call was terminated and a new call is added.

*
* PARAMETER: [IN] T_CallData
*            [OUT] NO

* RETURNVALUE: Bool.
*
********************************************************************************/

tBool fc_phone_tclCallManager::bCheckUpdateInCallHandlerTableEntries(const T_CallData* const prCallData)
{
   ETG_TRACE_USR4((" bCheckUpdateInCallHandlerTableEntries "));

   // check for callstatus for number and handle
   vPrintCallStatusHdlr_callInstanceMapTable();
   if((FALSE == bCompare(prCallData)) && (FALSE == bCompare(prCallData,1)))
   {
      tenCSMatch enStatus = EN_NO_MATCH;
      tU8 u8_MapTableIndexToBeDeleted = FC_PHONE_CALLMANAGER_INDEX_UNKNOWN;

      ETG_TRACE_USR4(("CallStatus received do not match with any entry in maptable "));
      //existing call has been terminated and new callstatus received.
      //delete the entry in maptable and update new entry.
      // find the slot that is to be cleared 
      for(tU8 u8MapIndex = 0;u8MapIndex <FC_PHONE_MAX_CALL ;u8MapIndex ++)
      {
         fc_phone_tclCallInstance* pCallInst = m_poSMManager->getCallInstancebyUniqueId(m_callHandlerMaptable[u8MapIndex].u16CallInstance);
         if(pCallInst)
         {
            if((0 == u8StringCompare( pCallInst->m_strCellNumber , prCallData->rCallStatus.achCallNumber))&&
               (m_callHandlerMaptable[u8MapIndex].m_u8Handle != prCallData->rCallStatus.u8CallHandle))
            {
               ETG_TRACE_USR4((" Callnumber matches, First call is disconnected. "));
               //update handle and callstate
               vPrintCallStatusHdlr_callInstanceMapTable();
               m_callHandlerMaptable[u8MapIndex].u8CallState     = prCallData->rCallStatus.u8CallState ;
               m_callHandlerMaptable[u8MapIndex].u8CallMode      = prCallData->rCallStatus.u8CallMode ;
               m_callHandlerMaptable[u8MapIndex].m_u8CallType    = prCallData->rCallStatus.u8CallType ;
               m_callHandlerMaptable[u8MapIndex].m_u8Handle      = prCallData->rCallStatus.u8CallHandle;

               vPrintCallStatusHdlr_callInstanceMapTable();
               //delete the other index.
               u8MapIndex++;
               u8_MapTableIndexToBeDeleted = (u8MapIndex % 2);
               enStatus = EN_NUM_MATCH;
               break;
            }
         }
      }
      if(EN_NUM_MATCH != enStatus)
      {
         ETG_TRACE_USR4((" Call number doesnt match check whether CallHandle matches, Second call is disconnected. "));
         for(tU8 u8MapIndex = 0;u8MapIndex <FC_PHONE_MAX_CALL ;u8MapIndex ++)
         {
            if(m_callHandlerMaptable[u8MapIndex].m_u8Handle == prCallData->rCallStatus.u8CallHandle)
            {
               ETG_TRACE_USR4((" CallHandle matches, Second call is disconnected. "));
               enStatus = EN_CH_MATCH;
               u8_MapTableIndexToBeDeleted = u8MapIndex;
               break;
            }
         }
      }

      //send idle callstatus
      if(u8_MapTableIndexToBeDeleted != FC_PHONE_CALLMANAGER_INDEX_UNKNOWN)
      {
         if(m_u16Count == FC_PHONE_MAX_CALL && prCallData->rCallStatus.u8CallTotal< m_u16Count && enStatus == EN_CH_MATCH)
         {
            // delete both entry in  table. and add new one.
            for(tU8 u8MapIndex = 0; u8MapIndex < FC_PHONE_MAX_CALL; u8MapIndex++)
            {
               // check- do we have to unlock here
               vSendIdleCallstatusToSM(m_callHandlerMaptable[0].u16CallInstance);
               vDeleteCallHandler_callInstanceMapTableEntry(0);
            }
         }  
         else
         {
            vPrintCallStatusHdlr_callInstanceMapTable();
            vSendIdleCallstatusToSM(m_callHandlerMaptable[u8_MapTableIndexToBeDeleted].u16CallInstance,prCallData->rCallStatus.u8CallTotal);
            //delete the entry from callHandler table
            vDeleteCallHandler_callInstanceMapTableEntry(u8_MapTableIndexToBeDeleted);
            vPrintCallStatusHdlr_callInstanceMapTable();
         }
      }
      // add new entry in case of callhandle match, as for callnumber its already updated.
      if(enStatus == EN_CH_MATCH)
      {
         //do new entry to table and update callInstance
         vAddEntryToCallHandlerMaptable(prCallData);
         vPrintCallStatusHdlr_callInstanceMapTable();
      }
      return TRUE;
   }
   else
   {
      // call total> mu16 count, but update is for existing call.in maptable.
      return FALSE;
   }
}

/*******************************************************************************
*
* FUNCTION: vSendIdleCallstatusToSM
*
* DESCRIPTION: Send IDLE Callstatus to the respective SM since the call is terminated
*
* PARAMETER: [IN] tU16 - u16CallInstance
*            [IN] tU8 - u8CallTotal
*
* RETURNVALUE: None.
*
********************************************************************************/

tVoid fc_phone_tclCallManager::vSendIdleCallstatusToSM(tU16 u16CallInstance,tU8 u8CallTotal)
{
   ETG_TRACE_USR4((" vSendIdleCallstatusToSM "));
   T_CallData call_data_temp ;
   call_data_temp.rCallStatus.u8CallTotal = u8CallTotal;
   call_data_temp.rCallStatus.u8CallDirection = 0 ;
   call_data_temp.rCallStatus.u8CallState = PHONE_CALLSTATE_IDLE ;
   call_data_temp.rCallStatus.u8CallMode = 0 ;
   call_data_temp.rCallStatus.u8CallType = 0 ;
   ETG_TRACE_USR4((" Sending CALL status Idle to the deleting callInstance "));
   (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vResetDiallerInfoForCallInstance(static_cast<tU8>(u16CallInstance));
   m_poSMManager->vNewCallStatus(&call_data_temp,u16CallInstance);
}

/*******************************************************************************
*
* FUNCTION: vAddEntryToCallHandlerMaptable
*
* DESCRIPTION: Add the new call status to the Call handler map table
*
* PARAMETER: [IN] T_CallData
*            [OUT] NO
*
* RETURNVALUE: None.
*
********************************************************************************/

tVoid fc_phone_tclCallManager::vAddEntryToCallHandlerMaptable(const T_CallData* const prCallData)
{
   ETG_TRACE_USR4((" vAddEntryToCallHandlerMaptable entered "));
   //get unmapped call Instance
   tU16 u16Unmapped_callInstance = m_poSMManager->u16GetUnmappedCallInstance(prCallData);

	vPrintCallStatusHdlr_callInstanceMapTable();

   tU8 u8MaptableIndex = static_cast<tU8>(prCallData->rCallStatus.u8CallHandle -1);

	if(FC_PHONE_SMMANAGER_CALLINSTANCEID_UNKNOWN != u16Unmapped_callInstance)
   {
      //update the Call Instance in table and corresponding call data
      m_callHandlerMaptable[u8MaptableIndex].u16CallInstance = u16Unmapped_callInstance ;
      m_callHandlerMaptable[u8MaptableIndex].u8CallState     = prCallData->rCallStatus.u8CallState ;
      m_callHandlerMaptable[u8MaptableIndex].u8CallMode      = prCallData->rCallStatus.u8CallMode ;
      m_callHandlerMaptable[u8MaptableIndex].m_u8CallType    = prCallData->rCallStatus.u8CallType ;
      m_callHandlerMaptable[u8MaptableIndex].m_u8Handle      = prCallData->rCallStatus.u8CallHandle;
      m_u16Count++;
   }
   else
   {
      ETG_TRACE_ERR(("Error : no unmapped CallInstance found in SM table"));
   }

	vPrintCallStatusHdlr_callInstanceMapTable();
}

/*******************************************************************************
*
* FUNCTION: vAddEntryToCallHandlerMaptablewithCIId
*
* DESCRIPTION: Add the new call status to the Call handler map table for the given call Instance ID
*
* PARAMETER: [IN] T_CallData
*            [OUT] NO
*
* RETURNVALUE: None.
*
********************************************************************************/

tVoid fc_phone_tclCallManager::vAddEntryToCallHandlerMaptablewithCIId(const T_CallData* const prCallData, tU16 u16ID)
{
   ETG_TRACE_USR4((" vAddEntryToCallHandlerMaptablewithCIId entered with u16ID: %d", u16ID));

   vPrintCallStatusHdlr_callInstanceMapTable();

   tU8 u8MaptableIndex = static_cast<tU8>(prCallData->rCallStatus.u8CallHandle -1);

   //update the Call Instance in table and corresponding call data
   m_callHandlerMaptable[u8MaptableIndex].u16CallInstance = u16ID ;
   m_callHandlerMaptable[u8MaptableIndex].u8CallState     = prCallData->rCallStatus.u8CallState ;
   m_callHandlerMaptable[u8MaptableIndex].u8CallMode      = prCallData->rCallStatus.u8CallMode ;
   m_callHandlerMaptable[u8MaptableIndex].m_u8CallType    = prCallData->rCallStatus.u8CallType ;
   m_callHandlerMaptable[u8MaptableIndex].m_u8Handle      = prCallData->rCallStatus.u8CallHandle;
   m_u16Count++;

   vPrintCallStatusHdlr_callInstanceMapTable();
}
