/*******************************************************************************
 *
 * FILE:          FC_Phone_CallInstance.h
 *
 * SW-COMPONENT:  FC_Phone application
 *
 * PROJECT:
 *
 * DESCRIPTION:   Abstracts Call Instance.
 *
 * AUTHOR:        Guruprasad G R
 *
 * COPYRIGHT:    (c)Celestial Systems, Bangalore, India
 *
 *******************************************************************************/

#ifndef _FC_PHONE_CALLINSTANCE_H_
#define _FC_PHONE_CALLINSTANCE_H_

#if __cplusplus < 201103L
#define OVERRIDE //C++03 or below
#define FINAL //C++03 or below
#else
#define OVERRIDE override //C++11 or above
#define FINAL final //C++11 or above
#endif
/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
typedef enum
{
   FC_PHONE_CALLSTATUS_MAPSTATE_IDLE               = 1,
   FC_PHONE_CALLSTATUS_MAPSTATE_SM_USING_UNMAPPED  = 2,
   FC_PHONE_CALLSTATUS_MAPSTATE_SM_USING_MAPPED    = 3
} fcPhone_CallInstCallStatusMapStateEnum ;


/* Values for the attribute m_u16IncomingCallEvent*/
#define FC_PHONE_CALLINSTANCE_INCOMINGCALLEVENT_IDLE     0
#define FC_PHONE_CALLINSTANCE_INCOMINGCALLEVENT_RINGING  1

/* Values for the attribute m_u16CallStatusNotice */
#define FC_PHONE_CALLINSTANCE_CALLSTATUS_IDLE            0
#define FC_PHONE_CALLINSTANCE_CALLSTATUS_DIALING         1
#define FC_PHONE_CALLINSTANCE_CALLSTATUS_ACTIVE          2
#define FC_PHONE_CALLINSTANCE_CALLSTATUS_ONHOLD          3
#define FC_PHONE_CALLINSTANCE_CALLSTATUS_DISCONNECTING   4
#define FC_PHONE_CALLINSTANCE_CALLSTATUS_BUSY            5
#define FC_PHONE_CALLINSTANCE_CALLSTATUS_CONFERENCE      6
#define FC_PHONE_CALLINSTANCE_CALLSTATUS_INVOICEMAIL     7
#define FC_PHONE_CALLINSTANCE_CALLSTATUS_RINGTONE        8



/* Values for the attribute m_u8CallType */
//#define FC_PHONE_CALLINSTANCE_CALLTYPE_FOREGROUND        0
//#define FC_PHONE_CALLINSTANCE_CALLTYPE_BACKGROUND        1

/* Values for the attribute m_u8ObjectState */
#define FC_PHONE_CALLINSTANCE_OBJECTSTATE_IDLE           0
#define FC_PHONE_CALLINSTANCE_OBJECTSTATE_ACTIVE         1

/* Values for the attribute m_AckError */
#define FC_PHONE_CALLINSTANCE_ACKERROR_OK                0
#define FC_PHONE_CALLINSTANCE_ACKERROR_NOK               1
#define FC_PHONE_CALLINSTANCE_ACK_STATE_ERROR            2 //State Error
#define FC_PHONE_CALLINSTANCE_ACKERROR_NOTAVAILABLE      3 //Not available
//FIX GMMY15-661
#define FC_PHONE_CALLINSTANCE_ACK_NO_AUDIO_CHANNEL		 5


/* Values for the attribute m_bAudioStatus */
#define FC_PHONE_CALLINSTANCE_AUDIOMUTED                 0
#define FC_PHONE_CALLINSTANCE_AUDIOUNMUTED               1

#define FC_PHONE_MAXSTRINGLENGTH                         255

#define FC_PHONE_MICROPHONE_MUTED  1
#define FC_PHONE_MICROPHONE_UNMUTED  0

#define FC_PHONE_RINGTONE_MUTED  1
#define FC_PHONE_RINGTONE_UNMUTED  0

#define DTMF_MAXSTR_LEN 255



#define FC_PHONE_CALLINSTANCE_UNKNOWN      0xFFFF

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

typedef struct _TCallDuration
{
   tU8 u8Seconds;
   tU8 u8Minutes;
   tU8 u8Hours;
}TCallDuration;

class fc_phone_tclCallInstance FINAL
{

public:

   /* Constructor */
   fc_phone_tclCallInstance();

   /* Destructor */
   virtual ~fc_phone_tclCallInstance();


   tVoid vInit(tVoid);
   tVoid vCreate(tU16 u16CallInstanceId, tU8 BDAddressId);


   /* BD_Address */
   //tChar   m_achBD_Address[FC_PHONE_MAXSTRINGLENGTH];
   /* BD_Address UniqueId */
   tU8     m_u8BDAddressId;

   /* This attribute holds a unique Id for a call instance */
   tU16     m_u16Id;

   /* This attribute keeps the Incoming call events status */
   tU16     m_u16IncomingCallEvent;

   /* This attribute keeps the Current Call Status */
   tU16     m_u16CallStatusNotice;

   /* This attribute keeps the Number */
   tChar    m_strCellNumber[FC_PHONE_MAXSTRINGLENGTH];

   /* This attribute keeps the call duration */
   TCallDuration m_rCallDuration;

   /* This attribute keeps the Current Call Direction Status */
   tU16     m_u8CallDirection;


   /* Holds the current timer Id */
   tU16 m_u16TimerId;

   /* This attribute keeps the device name */
   tChar   m_strCellDeviceName[FC_PHONE_MAXSTRINGLENGTH];

   /* This attribute holds whether this is a foreground call or background call */
   //    tU8     m_u8CallType;

   /* This attribute holds whether this is object is active or not */
   tU8     m_u8ObjectState;
   tBool   m_bUsingVehicleAudio;
   tU8     m_u8AudioChannel;

   tU8    m_AckError ;
   tBool m_bAudioStatus;
   tBool m_bMicroPhoneMuteStatus;
   tBool m_bRingtoneMuteStatus;
   tChar DTMFChar[DTMF_MAXSTR_LEN];
   fcPhone_CallInstCallStatusMapStateEnum  m_enCallStatusHdlr_MapState ;
   tBool m_bcallWaitingState ;
   tBool m_HangupALL_flag ;
   /* This attribute keeps the Outgoing call Failed reason */
   tChar    m_strDialCallFailedReason[FC_PHONE_MAXSTRINGLENGTH];
   /* This attribute keeps the Incoming call Rejected reason */
   tChar    m_strIncomingCallRejectReason[FC_PHONE_MAXSTRINGLENGTH];

   //tBool OutGoingSrcChanged;
};

#endif // _FC_PHONE_CALLINSTANCE_H


