/******************************************************************************
 *
 * FILE:          FC_Phone_CallInstance.cpp
 *
 * SW-COMPONENT:  FC_Phone application
 *
 * PROJECT:
 *
 * DESCRIPTION:   Implements class fc_phone_tclCallInstance
 *
 * AUTHOR:
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/
#include "../FC_Phone_main.h"
#include "FC_Phone_CallInstance.h"
#include "../Interface/FC_Phone_DBusInterface.h"
#include "../HelperClasses/FC_Phone_PhoneData.h"
#include "FC_Phone_AudioManager.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_PHONE_APPLICATION
#include "trcGenProj/Header/FC_Phone_CallInstance.cpp.trc.h"
#endif


/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclCallInstance
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
fc_phone_tclCallInstance::fc_phone_tclCallInstance(tVoid)
{
   ETG_TRACE_USR4(("fc_phone_tclCallInstance::fc_phone_tclCallInstance"));
   m_u16Id = FC_PHONE_CALLINSTANCE_UNKNOWN;
   //m_achBD_Address[0] = 0;
   m_u8BDAddressId=INVALID_BDADDRESS_ID;
   memset(DTMFChar, 0, sizeof(DTMFChar));

   vInit();
}
/*******************************************************************************
 *
 * FUNCTION: ~fc_phone_tclCallInstance
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
/* Destructor */
fc_phone_tclCallInstance::~fc_phone_tclCallInstance()
{
   ETG_TRACE_USR4(("fc_phone_tclCallInstance::~fc_phone_tclCallInstance"));
}
/*******************************************************************************
 *
 * FUNCTION: vInit
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
tVoid fc_phone_tclCallInstance::vInit(tVoid)
{
   // m_u16Id = FC_PHONE_CALLINSTANCE_UNKNOWN;
   ETG_TRACE_USR4(("fc_phone_tclCallInstance::vInit"));
   m_u16IncomingCallEvent = FC_PHONE_CALLINSTANCE_INCOMINGCALLEVENT_IDLE;
   m_u16CallStatusNotice  = FC_PHONE_CALLINSTANCE_CALLSTATUS_IDLE;
   m_rCallDuration.u8Seconds = 0x00;
   m_rCallDuration.u8Hours= 0x00;
   m_rCallDuration.u8Minutes = 0x00;
   //m_strCellNumber[0] = 0;
   memset(m_strCellNumber,0,sizeof(m_strCellNumber));
   //m_strCellDeviceName[0] = 0;
   memset(m_strCellDeviceName,0,sizeof(m_strCellDeviceName));
   memset(DTMFChar, 0, sizeof(DTMFChar));
   //m_achBD_Address[0] = 0; //Fix for not sending device handle FF
   m_u8BDAddressId=INVALID_BDADDRESS_ID;
   //    m_u8CallType    = FC_PHONE_CALLINSTANCE_CALLTYPE_BACKGROUND; //GMMY15-5423-5173
   m_u8ObjectState = FC_PHONE_CALLINSTANCE_OBJECTSTATE_IDLE;
   m_u8CallDirection = PHONE_CALLDIRECTION_UNKNOWN;
   m_bUsingVehicleAudio = FALSE;
   m_u16TimerId = 0xff; /* Some invalid Number */
   m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
   m_bAudioStatus = FC_PHONE_CALLINSTANCE_AUDIOUNMUTED;
   m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
   m_bMicroPhoneMuteStatus = FC_PHONE_MICROPHONE_UNMUTED ;
   m_enCallStatusHdlr_MapState = FC_PHONE_CALLSTATUS_MAPSTATE_SM_USING_UNMAPPED ;
   m_bcallWaitingState = FALSE ;
   m_HangupALL_flag    = FALSE ;
   memset(m_strDialCallFailedReason, 0, sizeof(m_strDialCallFailedReason));
   memset(m_strIncomingCallRejectReason, 0, sizeof(m_strIncomingCallRejectReason));
   //OutGoingSrcChanged = FALSE;
   m_bRingtoneMuteStatus = FALSE;
}
/*******************************************************************************
 *
 * FUNCTION: vCreate
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
tVoid  fc_phone_tclCallInstance::vCreate(tU16 u16CallInstanceId, tU8 BDAddressId)
{
   ETG_TRACE_USR4(("  fc_phone_tclCallInstance::vCreate"));
   //	ETG_TRACE_USR3(("fc_phone_tclCallInstance::vCreate : BD_Address %s",BD_Address));
   vInit();
   m_u16Id = u16CallInstanceId;
   m_u8ObjectState = FC_PHONE_CALLINSTANCE_OBJECTSTATE_ACTIVE;
   m_u8BDAddressId =BDAddressId;
   //  vStringCopy(m_achBD_Address, BD_Address, FC_PHONE_MAXSTRINGLENGTH);
}
