/*******************************************************************************
 *
 * FILE:          FC_Phone_main.h
 *
 * SW-COMPONENT:  FC_Phone application
 *
 * PROJECT:
 *
 * DESCRIPTION:   CCA Application.
 *
 * AUTHOR:
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

#ifndef _FC_PHONE_MAIN_H_
#define _FC_PHONE_MAIN_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/


// default value for device handle is 0
#define FC_PHONE_DEVICEHANDLE_UNKNOWN    0x00
#define FC_PHONE_MAX_DEVICECONNECTION    2

#define NAME_MAX_LENGTH 50 /* Fix for GMMY15-10552 */

#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"

#define FC_PHONE_S_IMPORT_INTERFACE_MSG
#include "FC_Phone_if.h"

#include "../Configuration/Phone/Phone_FeatureConfig.h"

#include "Audio/FC_Phone_ECNR.h"

#include "Audio/FC_Phone_Audio.h"
#include "Audio/FC_Phone_AudioHelper.h"

#include <vector>

#define STR_UCID_BT_PHONE 0x0900
#define STR_UCID_TESTMICINTOMOST 0x0901
#define STR_UCID_CALLONHOLD_ALERTTONETOMOST 0x0902
#define STR_UCID_VRFROMBTPHONE 0x0909
#define FC_PHONE_UCID_MEDIAPLAYER2 0x0201
#define FC_PHONE_MAX_CALLINSTANCES  2                  
#define FC_PHONE_AUDIOTRANSFER_TIMEOUT 4000
#define SYS_STATE_LOCAL_PHONE_ALERTID  0x3FF

#define CALLTRANSFER_SUCCESS  0
#define CALLTRANSFER_FAILURE  2
#define FC_PHONE_STATE_OFF 1
#define FC_PHONE_STATE_UNKNOWN 0
#define FC_PHONE_STATE_ON 2

#ifdef CONNECTIVITY_PROCESS_STARTUP_GEN3
#define FC_PHONE_THREAD_ID                  "FC_PHONE_THREAD"
#define FC_PHONE_DEFAULT_PRIORITY           105
#define FC_PHONE_DEFAULT_STACK_SIZE         16384
#endif //CONNECTIVITY_PROCESS_STARTUP_GEN3

#define PTHREAD_RT_PRIO                30

#define ECNR_APPID_PHONE    (unsigned char)  1
#define PHONE_DATASET_1     (unsigned short) 1 // narrow band phone
#define PHONE_DATASET_2     (unsigned short) 2 // wide band phone
#define PHONE_DATASET_3     (unsigned short) 3 // narrow band VR
#define PHONE_DATASET_4     (unsigned short) 4 // wide band VR

//Task CMG3G-7981
#define SSE_CONFIG_PHONE_SIRI_NB_FROM_FILE   (unsigned short) 5   // Narrow band Siri
#define SSE_CONFIG_PHONE_SIRI_WB_FROM_FILE   (unsigned short) 6   // Wide band Siri

#define TEST_DATASET_1     (unsigned int) 601
#define TEST_DATASET_2     (unsigned int) 602

#define VEHICLE_INFO 0

#define GET_SUBSCRIBER_NUMBERSERVICE_FAIL 0xFF

#define SYS_STATE_LOCAL_PHONE_INSTANCENUM 1
#define LOCAL_PHONE_BT_RAPTIMER_ID 4

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "Common/FC_Phone_Global.h"
#include "../Configuration/Phone/Phone_FeatureConfig.h"

#ifdef CONNECTIVITY_DIAGNOSIS_GM
/* Due to non availability of diagnosis
		library, this section will be compiled out for JAC  */
#define TELEPHONE_DIAG_ENABLE
#define DIAGLIB_INCLUDE_GENERIC
#include "diaglib_if.h"

#endif /* CONNECTIVITY_DIAGNOSIS_GM */

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
#define FC_PHONE_SYSTEMSTATE_FI_MAJOR_VERSION  SPM_COREFI_C_U16_SERVICE_MAJORVERSION //1
#define FC_PHONE_SYSTEMSTATE_FI_MINOR_VERSION  SPM_COREFI_C_U16_SERVICE_MINORVERSION //8
#define FC_PHONE_SYSTEMSTATE_FI_PATCH_VERSION  0

#define FC_PHONE_PHONEBOOK_FI_MAJOR_VERSION  MOST_PHONBKFI_C_U16_SERVICE_MAJORVERSION //1
#define FC_PHONE_PHONEBOOK_FI_MINOR_VERSION  MOST_PHONBKFI_C_U16_SERVICE_MINORVERSION //8
#define FC_PHONE_PHONEBOOK_FI_PATCH_VERSION  0

#define FC_PHONE_SERVICE_BLUETOOTHSETTINGS_FI_MAJOR_VERSION  MOST_BTSETFI_C_U16_SERVICE_MAJORVERSION //1
#define FC_PHONE_SERVICE_BLUETOOTHSETTINGS_FI_MINOR_VERSION  MOST_BTSETFI_C_U16_SERVICE_MINORVERSION //8
#define FC_PHONE_SERVICE_BLUETOOTHSETTINGS_FI_PATCH_VERSION  1

#define FC_PHONE_SERVICE_TELEPHONE_FI_MAJOR_VERSION   MOST_TELFI_C_U16_SERVICE_MAJORVERSION
#define FC_PHONE_SERVICE_TELEPHONE_FI_MINOR_VERSION   MOST_TELFI_C_U16_SERVICE_MINORVERSION
#define FC_PHONE_SERVICE_TELEPHONE_FI_PATCH_VERSION  0


enum tenTrcTraceClassFC_Phone {
   TR_CLASS_FC_PHONE_APPLICATION = TR_COMP_CONNECTIVITY + 32,
   TR_CLASS_FC_PHONE_SERVICE_TELEPHONE = TR_COMP_CONNECTIVITY + 32 + 1,
   TR_CLASS_FC_PHONE_CLIENTHANDLER_PHONEBOOK = TR_COMP_CONNECTIVITY + 32 + 2,
   TR_CLASS_FC_PHONE_CLIENTHANDLER_BLUETOOTHSETTINGS = TR_COMP_CONNECTIVITY + 32 + 3,
   TR_CLASS_FC_PHONE_CLIENTHANDLER_SYSTEMSTATE = TR_COMP_CONNECTIVITY + 32 + 4,
  TR_CLASS_FC_PHONE_STATEMACHINE = TR_COMP_CONNECTIVITY + 32 + 5
};


class VehicleInformation
{
public:
	VehicleInformation(): m_u16VendorIDSource(VEHICLE_INFO), m_u16VendorID(VEHICLE_INFO),
	m_u16ProductID(VEHICLE_INFO), m_u16ProductVersion(VEHICLE_INFO)
    {

    }
	~VehicleInformation(){}
   tU16 m_u16VendorIDSource;
   tU16 m_u16VendorID;
   tU16 m_u16ProductID;
   tU16 m_u16ProductVersion;
};

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

class ahl_tclBaseOneThreadApp;
class fc_phone_tclService_Telephone;
class fc_phone_tclClientHandler_BTSettings;
class fc_phone_tclClientHandler_PhoneBook;
class fc_phone_tclClientHandler_SystemState;
class fc_phone_tclClientHandler_MediaPlayer;

class fc_phoneaudio_tclAudioRoutingfi;

class fc_phone_tclTimer;
class fc_phone_tclAudioManager;
class Phone_DefSetHandler;

class fc_phone_tclApp : public ahl_tclBaseOneThreadApp
{
   //static fc_phone_tclApp* m_poMainAppInstance;

public:
   static fc_phone_tclApp* m_poMainAppInstance;
   tU8 m_u8FBlockState;
   fc_phone_tclApp(tVoid);
   virtual ~fc_phone_tclApp(tVoid);

   /**************************************************************************
    * Assingment Operater, will not be implemented.
    * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class 
    * 'fc_phone_tclApp' which has no assignment operator.
    * NOTE: This is a technique to disable the assignment operator for this
    * class. So if an attempt for the assignment is made compiler complains.
    **************************************************************************/
   fc_phone_tclApp& operator= (const fc_phone_tclApp &oFC_Phone);

   /**************************************************************************
    * Copy Constructor, will not be implemented.
    * Avoids Lint Prio 3 warning:Info 1733: new in constructor for class 
    * 'fc_phone_tclApp' which has no copy constructor.
    * NOTE: This is a technique to disable the copy constructor for this
    * class. So if an attempt for the assignment is made compiler complains.
    **************************************************************************/
   fc_phone_tclApp(const fc_phone_tclApp &oFC_Phone);

   /**************************************************************************
    * Overriding ahl_tclBaseOneThreadApp methods.
    **************************************************************************/
   virtual tBool bOnInit() OVERRIDE;
   virtual tVoid vOnApplicationClose() OVERRIDE;
   virtual tVoid vOnTimer(tU16 nTimerId) OVERRIDE;
   virtual tVoid vOnLoadSettings() OVERRIDE;
   virtual tVoid vOnSaveSettings() OVERRIDE;
   using ahl_tclBaseOneThreadApp::vOnLoopback;
   virtual tVoid vOnLoopback(tU16 u16ServiceID, amt_tclServiceData* poMessage) OVERRIDE;
#ifdef CONNECTIVITY_PROCESS_STARTUP_GEN3
   static fc_phone_tclApp* theServer();
   tVoid vInitializeThread();
   static tVoid vStartMainLoop(tVoid *);
#endif //CONNECTIVITY_PROCESS_STARTUP_GEN3

   //private:
#ifdef CONNECTIVITY_DIAGNOSIS_GM
   /* Due to non availability of diagnosis
		library, this section will be compiled out for JAC  */
   diaglib::tclServiceDiaglib*            m_poDiaglibService;
#endif /*  CONNECTIVITY_DIAGNOSIS_GM  */


   fc_phone_tclService_Telephone* m_poTelephone;
   fc_phone_tclClientHandler_BTSettings* m_poClientHandlerBTSettings;
   fc_phone_tclAudioManager* m_poAudioManager;
   fc_phone_tclTimer*        m_poTimer;
   fc_phone_tclClientHandler_PhoneBook *m_poClientHandlerPhoneBook ;
   fc_phone_tclClientHandler_SystemState *m_poClientHandlerSystemState;
   fc_phone_tclClientHandler_MediaPlayer *m_poClientHandlerMediaPlayer;
   fc_phoneaudio_tclAudioRoutingfi *m_poPhoneAudioRouting;
   fc_phoneaudio_utility* m_poPhoneAudioUtility;
#ifdef CONNECTIVITY_DIAGNOSIS_GM
   Phone_DefSetHandler *m_poDefSet;
#endif /*  CONNECTIVITY_DIAGNOSIS_GM  */


#ifdef CONNECTIVITY_PROCESS_STARTUP_GEN3
   OSAL_tThreadID		       m_hRxThreadId;
#endif //CONNECTIVITY_PROCESS_STARTUP_GEN3

private:

   /* GMMY15-9114 FC_Phone : logiscope code complexity value >= 20 */
   tBool bInitializeClientHandlersAndServices(tBool bSuccess);
   
}; 

#endif //_FC_PHONE_MAIN_H_

