/*******************************************************************************
 *
 * FILE:          FC_Phone_clienthandler_SystemState.cpp
 *
 * SW-COMPONENT:  FC_Phone ClientHandler for SystemState
 *
 * PROJECT:
 *
 * DESCRIPTION:   Client-handler for System State FBlock.
 *
 * AUTHOR:
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/
#include "FC_Phone_main.h"
#include "FC_Phone_service_Telephone.h"
#include "FC_Phone_clienthandler_SystemState.h"
#include "HelperClasses/FC_Phone_Timer.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_TYPES
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_FUNCTIONIDS
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_SERVICEINFO
#include "spm_fi_if.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_PHONE_APPLICATION
#include "trcGenProj/Header/FC_Phone_clienthandler_SystemState.cpp.trc.h"
#endif

/******************************************************************************/
/*									DEFINES									*/
/******************************************************************************/
tVoid vTimerCallBackSystemState(tU16 u16TimerID);
/******************************************************************************/
/*									CCA MESSAGE MAP								*/
/******************************************************************************/
BEGIN_MSG_MAP(fc_phone_tclClientHandler_SystemState,ahl_tclBaseWork)
ON_MESSAGE_SVCDATA(SPM_COREFI_C_U16_SYSTEMSTATE,AMT_C_U8_CCAMSG_OPCODE_STATUS,vHandle_SystemState_Status)
ON_MESSAGE_SVCDATA(SPM_COREFI_C_U16_ONOFFTRIGGER, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,vHandle_OnOffTrigger_MethodResult)
ON_MESSAGE_SVCDATA(SPM_COREFI_C_U16_ONOFFTRIGGER, AMT_C_U8_CCAMSG_OPCODE_ERROR,vHandle_OnOffTrigger_MethodError)
END_MSG_MAP()
/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclClientHandler_SystemState::
 *             fc_phone_tclClientHandler_SystemState(fc_phone_tclApp* poMainAppl)
 *
 * DESCRIPTION: Constructor.
 *
 *              Create an object of the base class
 *              ahl_tclBaseOneThreadClientHandler with a pointer to this
 *              application, the to be used service identifier and the service
 *              version as parameters.
 *
 * PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
 *
 * RETURNVALUE: None.
 *
 ******************************************************************************/
fc_phone_tclClientHandler_SystemState::fc_phone_tclClientHandler_SystemState(fc_phone_tclApp* poMainAppl)
: ahl_tclBaseOneThreadClientHandler(
      /* Application Pointer          */ poMainAppl,
      /* ID of used Service           */ /*CCA_C_U16_SRV_FB_SYSTEMSTATE*/ CCA_C_U16_SRV_SPM,
      /* MajorVersion of used Service */ FC_PHONE_SYSTEMSTATE_FI_MAJOR_VERSION,
      /* MinorVersion of used Service */ FC_PHONE_SYSTEMSTATE_FI_MINOR_VERSION)
{
   ETG_TRACE_USR4((" fc_phone_tclClientHandler_SystemState constructor entered."));
   m_TelService_instance = NULLPTR ;
   u16TimerID = LOCAL_PHONE_BT_RAPTIMER_ID;
   SleepFaultTimeout = FALSE;
   SystemStateAlertOnLocalPhone = FALSE;
   m_u16SystemState = DEFAULT_SYSTEM_STATE;
   vAddAutoRegisterForProperty(SPM_COREFI_C_U16_SYSTEMSTATE);
}
/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclClientHandler_SystemState::
 *             ~fc_phone_tclClientHandler_SystemState(tVoid)
 *
 * DESCRIPTION: Destructor.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
fc_phone_tclClientHandler_SystemState::~fc_phone_tclClientHandler_SystemState(tVoid)
{
   ETG_TRACE_USR4((" ~fc_phone_tclClientHandler_SystemState entered."));
   m_TelService_instance = NULLPTR ;
   u16TimerID = LOCAL_PHONE_BT_RAPTIMER_ID;
   SleepFaultTimeout = FALSE;
   SystemStateAlertOnLocalPhone = FALSE;
   m_u16SystemState = DEFAULT_SYSTEM_STATE;
}
/*******************************************************************************
 *
 * FUNCTION: tVoid fc_phone_tclClientHandler_SystemState::vOnServiceAvailable()
 *
 * DESCRIPTION: This function is called by the CCA framework when the service
 *              this client-handler has registered for has become available.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************
 * Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
 *******************************************************************************/
tVoid fc_phone_tclClientHandler_SystemState::vOnServiceAvailable()
{
   ETG_TRACE_USR4((" fc_phone_tclClientHandler_SystemState:: OnServiceAvailable Entered"));

}

/*******************************************************************************
 *
 * FUNCTION: tVoid fc_phone_tclClientHandler_SystemState::vOnServiceUnavailable()
 *
 * DESCRIPTION: This function is called by the CCA framework when the service
 *              this client-handler has registered for has become unavailable.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************
 * Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable()
 *******************************************************************************/
tVoid fc_phone_tclClientHandler_SystemState::vOnServiceUnavailable()
{
   ETG_TRACE_USR4((" vOnServiceUnavailable entered. AppID = %u.",u16GetServerAppID()));
}


/*******************************************************************************
 *
 * FUNCTION: vTimerCallBackSystemState
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid vTimerCallBackSystemState(tU16 u16TimerId)
{
   ETG_TRACE_USR4((" ENTER vTimerCallBackSystemState"));
   (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerSystemState->vTimerCallback(u16TimerId);
}
/*******************************************************************************
 ** FUNCTION:   vHandle_SystemState_Status(..)
 *******************************************************************************/
/* DESCRIPTION:
 *   This is a handler function for SystemState PropertyStatus
 *
 *  PARAMETERS:
 *     IN:   poMessage      : This is the received message from a client
 *  RETURNVALUE: None
 *******************************************************************************/
tVoid  fc_phone_tclClientHandler_SystemState::vHandle_SystemState_Status(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR4((" vHandle_SystemState_Status entered."));

   // Create a FI visitor message for the received CCA message
   fi_tclVisitorMessage oVisitorMsg(poMessage);
   spm_corefi_tclMsgSystemStateStatus oSysStateStatus;
   if (oVisitorMsg.s32GetData(oSysStateStatus,FC_PHONE_SYSTEMSTATE_FI_MAJOR_VERSION) != OSAL_ERROR)
   {
      m_u16SystemState =  oSysStateStatus.SystemState.enType;
      ETG_TRACE_USR4(("m_u16SystemState:: %u", m_u16SystemState));

      if((spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_OFF) == oSysStateStatus.SystemState.enType)
      {
         ETG_TRACE_USR4(("System State Goes to SPM_SYSTEM_OFF"));

         NULL_CHECK(m_TelService_instance)

         if(LOCAL_PHONE_BT_RAPTIMER_ID == u16TimerID)
         {
            ETG_TRACE_USR4((" Stop RAPTIMER if running during Ignition on"));
            (fc_phone_tclApp::m_poMainAppInstance)->m_poTimer->s32Stop(u16TimerID);
         }

         //Check for Active Call Instance.
         if (m_TelService_instance->sGetCallStatus())
         {
            tS32 TimerRet = 0;
            SleepFaultTimeout = FALSE;
            TimerRet = (fc_phone_tclApp::m_poMainAppInstance)->m_poTimer->s32Start(u16TimerID,(SLEEP_FAULT_TIMEOUT-BT_RAP_EXPIRY_TIMEOUT),vTimerCallBackSystemState);
            if(FC_PHONE_TIMER_OK != TimerRet)
            {
               ETG_TRACE_ERR((" error(%d) in starting timer with Timer ID(%u)",TimerRet,u16TimerID));
            }
         }
         else
         {
            ETG_TRACE_USR4((" NO ACTIVE CALL INSTANCE EXISTS "));
         }
      }
      else
      {
         ETG_TRACE_USR3(("  Property Status:System State Is not in SPM_SYSTEM_OFF "));
      }
   }
   oSysStateStatus.vDestroy();
}

/*******************************************************************************
*
* FUNCTION: vTimerCallback()
*
* DESCRIPTION:
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************/
tVoid  fc_phone_tclClientHandler_SystemState::vTimerCallback(tU16 TimerId)
{
   ETG_TRACE_USR4(("ENTER fc_phone_tclClientHandler_SystemState::vTimerCallback TimerID :: %d",TimerId));
   tS32 TimerRet = 0;
   //Sending Alert to Alert Manager and start BT Rap Timer
   if (SleepFaultTimeout == FALSE)
   {
      SleepFaultTimeout = TRUE;
      SystemStateAlertOnLocalPhone = TRUE;
      (fc_phone_tclApp::m_poMainAppInstance)->m_poTimer->s32Stop(TimerId);
      TimerRet = (fc_phone_tclApp::m_poMainAppInstance)->m_poTimer->s32Start(u16TimerID,BT_RAP_EXPIRY_TIMEOUT,vTimerCallBackSystemState);
      if (FC_PHONE_TIMER_OK != TimerRet)
      {
         ETG_TRACE_ERR((" error(%d) in starting timer with Timer ID(%u)",TimerRet,u16TimerID));
      }
   }
   else
   {
      if (m_TelService_instance)
      {
         //Time out of BT RAP TIMER
         m_TelService_instance->vTransferCallToHandset(FC_PHONE_TRANSFERCALL_EXT_TRIGGER_RELEASE_CHANNEL);
      }
   }
}
/*******************************************************************************
 *
 * FUNCTION: tVoid  fc_phone_tclClientHandler_SystemState::SystemStateAlertResponse()
 *
 * DESCRIPTION: Outcome of Alert Activated by System State Client Handler
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid  fc_phone_tclClientHandler_SystemState::vHandleSystemStateOnTransferCall()
{
   //When user Invokes TransferCall to HandSet Deactivate Alert
   ETG_TRACE_USR4(("ENTER fc_phone_tclClientHandler_SystemState::vHandleSystemStateOnTransferCall"));
   SystemStateAlertOnLocalPhone = FALSE;
   SleepFaultTimeout = FALSE;
   (fc_phone_tclApp::m_poMainAppInstance)->m_poTimer->s32Stop(u16TimerID);
}

/*******************************************************************************
 *
 * FUNCTION: tVoid  fc_phone_tclClientHandler_SystemState::vSetPhoneServiceInstance(fc_phone_tclService_Telephone*& rfpTelServiceInstance)
 *
 * DESCRIPTION: Stores reference to service
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid  fc_phone_tclClientHandler_SystemState::vSetTelServiceInstance(fc_phone_tclService_Telephone*& rfpTelServiceInstance)
{
   ETG_TRACE_USR4(("ENTER fc_phone_tclClientHandler_SystemState::vSetTelServiceInstance"));
   m_TelService_instance = rfpTelServiceInstance ;
}
/*******************************************************************************
 *
 * FUNCTION: tVoid  fc_phone_tclClientHandler_SystemState::vSendSpmSubState(tBool isPhoneActive)
 *
 * DESCRIPTION: Send SPM sub state
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid  fc_phone_tclClientHandler_SystemState::vSendSpmSubState(tBool isPhoneActive)
{
   ETG_TRACE_USR4(("ENTER fc_phone_tclClientHandler_SystemState::vSendSpmSubState"));
   ETG_TRACE_USR2((" isPhoneActive:: %d   ",isPhoneActive));
   // set parameter
   spm_corefi_tclMsgOnOffTriggerMethodStart oOnOffTrigger_MS;
   oOnOffTrigger_MS.bState = isPhoneActive;
   oOnOffTrigger_MS.eSwitchOnTrigger.enType = spm_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_PHONE;

   //Create the carrier for the message..
   fi_tclVisitorMessage oMSMsg(oOnOffTrigger_MS, FC_PHONE_SERVICE_TELEPHONE_FI_MAJOR_VERSION);

   /* Set the CCA message information */
   vInitServiceData(oMSMsg, 0, SPM_COREFI_C_U16_ONOFFTRIGGER, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

   if (oMSMsg.bIsValid())
   {
      ail_tenCommunicationError enResult =(fc_phone_tclApp::m_poMainAppInstance)->enPostMessage(&oMSMsg, TRUE);
      if (enResult != AIL_EN_N_NO_ERROR)
      {
         ETG_TRACE_ERR(( " enPostMessage failed for 'Send - OPCODE_METHODSTART' message, 'ail_tenCommunicationError' = %u       OpCodeMethodStart fail",
               (tU32)enResult ));
      }
   }
   oOnOffTrigger_MS.vDestroy();
}

/*******************************************************************************
 *
 * FUNCTION: bIsSysteminStandByState
 *
 * DESCRIPTION:
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: TRUE if System state is STANDBY, else FALSE.
 *
 ********************************************************************************/
tBool fc_phone_tclClientHandler_SystemState::bIsSysteminStandByState()
{
   ETG_TRACE_USR4(("ENTER fc_phone_tclClientHandler_SystemState::bIsSysteminStandByState"));
   if(((spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_STANDBY) == m_u16SystemState) || \
         ((spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY_RESTRICTED) == m_u16SystemState))
   {
      ETG_TRACE_USR4(("System in STANDBY state"));
      return true;
   }
   return false;
}

/*******************************************************************************
 *
 * FUNCTION:   vHandle_OnOffTrigger_MethodResult(..)
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *    IN:   poMessage        : This is the received message To client
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/

tVoid fc_phone_tclClientHandler_SystemState::vHandle_OnOffTrigger_MethodResult(amt_tclServiceData* poMessage)
{
   (tVoid) poMessage;
   ETG_TRACE_USR4((" vHandle_OnOffTrigger_MethodResult entered."));
}

/*******************************************************************************
 *
 * FUNCTION:   vHandle_OnOffTrigger_MethodError(..)
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *    IN:   poMessage        : This is the received message To client
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/

tVoid fc_phone_tclClientHandler_SystemState::vHandle_OnOffTrigger_MethodError(amt_tclServiceData* poMessage)
{
   (tVoid) poMessage;
   ETG_TRACE_USR4((" vHandle_OnOffTrigger_MethodError entered."));
}
