/*******************************************************************************
 *
 * FILE:          FC_Phone_clienthandler_PhoneBook.h
 *
 * SW-COMPONENT:  FC_Phone Blue Tooth Client
 *
 * PROJECT:
 *
 * DESCRIPTION:   FC_Phone client-handler for the Alert Settings.
 *
 * AUTHOR:
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/
#ifndef _FC_PHONE_CLIENTHANDLER_PHONEBOOK_H_
#define _FC_PHONE_CLIENTHANDLER_PHONEBOOK_H_
#include "FC_Phone_main.h"

/******************************************************************************/
/* CLASS DEFINITION                                                           */
/******************************************************************************/

//FIX GMMY16-7030 The name on incoming call alert, sent successful alert and reply view, end/send view is always sorted as "First name Last name".
//While appending name for incoming call alert, FC_Phone has to check the Preferred sort order and append accordingly.
enum enPreferredPhonebookSortOrder
{
   e8PreferredSortOrderFirstNameLastName = 0, e8PreferredSortOrderLastNameFirstName = 1, e8PreferredSortOrderInvalid = 2
};
//End of fix

typedef struct _T_PBListItem
{
   tU8 DeviceHandle;
   tU8 u8CallInstance;
   tString sFirstName;
   tString sLastName;
} T_PBListItem;

class ahl_tclBaseOneThreadClientHandler;
class fc_phone_tclService_Telephone;
class fc_phone_tclClientHandler_PhoneBook FINAL: public ahl_tclBaseOneThreadClientHandler
{
public:
   fc_phone_tclClientHandler_PhoneBook(tVoid);
   fc_phone_tclClientHandler_PhoneBook(fc_phone_tclApp* poMainAppl);
   virtual ~fc_phone_tclClientHandler_PhoneBook();

   /***************************************************************************
    * Overriding ahl_tclBaseOneThreadClientHandler methods.
    ***************************************************************************/
   virtual tVoid vOnServiceAvailable() OVERRIDE;
   virtual tVoid vOnServiceUnavailable() OVERRIDE;
   /***************************************************************************
    * Handler function declarations used by message map.
    ***************************************************************************/
   // Add your CCA message handler function prototypes here.
   /***************************************************************************
    * Message map definition macro
    ***************************************************************************/
   tVoid vSetTelServiceInstance(fc_phone_tclService_Telephone*& rfpTelServiceInstance);
   tVoid vSearchPhoneBook(tU8 u8DeviceHandle,tString pstr_phonenumber,tU16 CmdCounter);
   tVoid vGetFirstName(tString &psFirstName, tU8 DevHandle = FC_PHONE_DEVICEHANDLE_UNKNOWN); // Lint fix
   tVoid vGetLastName(tString &psLastName, tU8 DevHandle = FC_PHONE_DEVICEHANDLE_UNKNOWN); // Lint fix
   tU32   u32GetContactHandle();

   tVoid vInsertPBListItem(tU8 DevHandle);
   tVoid vRemovePBListItem(tU8 DevHandle);
   tVoid vPrintPBList();
   tVoid vUpdateSearchPBResponse(tU8 u8DevHandle);
   tVoid vSetIncomingCallInstanceinPBList(tU8 u8DevHandle, tU8 CallInstance);
   tU8 u8GetIncomingCallInstancefromPBList(tU8 u8DevHandle);

   //FIX GMMY16-7030 The name on incoming call alert, sent successful alert and reply view, end/send view is always sorted as "First name Last name".
   //While appending name for incoming call alert, FC_Phone has to check the Preferred sort order and append accordingly.
   tVoid vGetPreferredPhonebookSortOrder();
   tVoid vHandle_PreferredPhonebookSortOrder_Status(amt_tclServiceData* poMessage);
   enPreferredPhonebookSortOrder enGetPreferredPhonebookSortOrder();
   //End of fix

   DECLARE_MSG_MAP(fc_phone_tclClientHandler_PhoneBook)


private:
   /****************************************************************************
   Member variables for ClientHandler_PhoneBook
    ****************************************************************************/

   fc_phone_tclService_Telephone* m_TelService_instance;

   T_PBListItem m_PBListItems[FC_PHONE_MAX_DEVICECONNECTION];
   tU32 u32ContactHandle ;

   tVoid vHandle_SearchPhoneBook_MethodResult(amt_tclServiceData* poMessage);
   tVoid vHandle_SearchPhoneBook_MethodError(amt_tclServiceData* poMessage) ;

   //FIX GMMY16-7030 The name on incoming call alert, sent successful alert and reply view, end/send view is always sorted as "First name Last name".
   //While appending name for incoming call alert, FC_Phone has to check the Preferred sort order and append accordingly.
   enPreferredPhonebookSortOrder m_enPreferredPhonebookSortOrder;
   tU8 m_u8ActiveDevHandleReceivedforSearchPB;
   //End of fix

   tVoid vResetNameInfoFrom_PBListItems_ForIndex(tU8 u8index);
};

#endif //_FC_PHONE_CLIENTHANDLER_PHONEBOOK_H_

