/*******************************************************************************
 *
 * FILE:          FC_Phone_clienthandler_PhoneBook.cpp
 *
 * SW-COMPONENT:  FC_Phone Client Handler for PhoneBook
 *
 * PROJECT:
 *
 * DESCRIPTION:   Client-handler for PhoneBook Interface.
 *
 * AUTHOR:
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/
#include "FC_Phone_main.h"
#include "FC_Phone_clienthandler_PhoneBook.h"
#include "FC_Phone_service_Telephone.h"
#include "HelperClasses/FC_Phone_Timer.h"
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
//Include FI interface of PhoneBook Settings
#define MOST_FI_S_IMPORT_INTERFACE_MOST_PHONBKFI_TYPES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_PHONBKFI_FUNCTIONIDS
#define MOST_FI_S_IMPORT_INTERFACE_MOST_PHONBKFI_SERVICEINFO

#include "conn_most_fi_if.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_PHONE_APPLICATION
#include "trcGenProj/Header/FC_Phone_clienthandler_PhoneBook.cpp.trc.h"
#endif



/******************************************************************************/
/*									DEFINES									*/
/******************************************************************************/
/******************************************************************************/
/*									CCA MESSAGE MAP								*/
/******************************************************************************/
BEGIN_MSG_MAP(fc_phone_tclClientHandler_PhoneBook, ahl_tclBaseWork)

ON_MESSAGE_SVCDATA( MOST_PHONBKFI_C_U16_SEARCHPHONEBOOK, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT ,vHandle_SearchPhoneBook_MethodResult)
ON_MESSAGE_SVCDATA( MOST_PHONBKFI_C_U16_SEARCHPHONEBOOK, AMT_C_U8_CCAMSG_OPCODE_ERROR        ,vHandle_SearchPhoneBook_MethodError )

//FIX GMMY16-7030 The name on incoming call alert, sent successful alert and reply view, end/send view is always sorted as "First name Last name".
//While appending name for incoming call alert, FC_Phone has to check the Preferred sort order and append accordingly.
ON_MESSAGE_SVCDATA( MOST_PHONBKFI_C_U16_PREFERREDPHONEBOOKSORTORDER, AMT_C_U8_CCAMSG_OPCODE_STATUS ,vHandle_PreferredPhonebookSortOrder_Status)
//End of fix

END_MSG_MAP()
/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclClientHandler_PhoneBook::
 *             fc_phone_tclClientHandler_PhoneBook(fc_phone_tclApp* poMainAppl)
 *
 * DESCRIPTION: Constructor.
 *
 *              Create an object of the base class
 *              ahl_tclBaseOneThreadClientHandler with a pointer to this
 *              application, the to be used service identifier and the service
 *              version as parameters.
 *
 * PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
 *
 * RETURNVALUE: None.
 *
 ******************************************************************************/
fc_phone_tclClientHandler_PhoneBook::fc_phone_tclClientHandler_PhoneBook(fc_phone_tclApp* poMainAppl)
: ahl_tclBaseOneThreadClientHandler(
      /* Application Pointer          */ poMainAppl,
      /* ID of used Service           */ CCA_C_U16_SRV_FB_PHONEBOOK,
      /* MajorVersion of used Service */ FC_PHONE_PHONEBOOK_FI_MAJOR_VERSION,
      /* MinorVersion of used Service */ FC_PHONE_PHONEBOOK_FI_MINOR_VERSION)
{
   ETG_TRACE_USR4((" fc_phone_tclClientHandler_PhoneBook constructor entered."));

   /* Fix for GMMY15-10552 Incoming call alert is delayed */
   for(tU8 ind = 0; ind < FC_PHONE_MAX_DEVICECONNECTION; ++ind)
   {
      m_PBListItems[ind].sFirstName = NULLPTR;
      m_PBListItems[ind].sLastName = NULLPTR;
      m_PBListItems[ind].DeviceHandle = FC_PHONE_DEVICEHANDLE_UNKNOWN;
      m_PBListItems[ind].u8CallInstance = 0xFF;
   }

   u32ContactHandle = 0;
   m_TelService_instance = NULLPTR ;

   m_u8ActiveDevHandleReceivedforSearchPB = FC_PHONE_DEVICEHANDLE_UNKNOWN;

   //FIX GMMY16-7030 The name on incoming call alert, sent successful alert and reply view, end/send view is always sorted as "First name Last name".
   //While appending name for incoming call alert, FC_Phone has to check the Preferred sort order and append accordingly.
   m_enPreferredPhonebookSortOrder = e8PreferredSortOrderInvalid;
   vAddAutoRegisterForProperty(MOST_PHONBKFI_C_U16_PREFERREDPHONEBOOKSORTORDER); 
   //End of fix
}

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclClientHandler_PhoneBook::
 *             ~fc_phone_tclClientHandler_PhoneBook(tVoid)
 *
 * DESCRIPTION: Destructor.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
fc_phone_tclClientHandler_PhoneBook::
~fc_phone_tclClientHandler_PhoneBook(tVoid)
{
   ETG_TRACE_USR4((" ~fc_phone_tclClientHandler_PhoneBook entered."));

   /* Fix for GMMY15-10552 Incoming call alert is delayed */
   for(tU8 ind = 0; ind < FC_PHONE_MAX_DEVICECONNECTION; ++ind)
   {
      vResetNameInfoFrom_PBListItems_ForIndex(ind);
   }

   m_TelService_instance = NULLPTR ;
}


/*******************************************************************************
 *
 * FUNCTION: tVoid fc_phone_tclClientHandler_PhoneBook::vOnServiceAvailable()
 *
 * DESCRIPTION: This function is called by the CCA framework when the service
 *              this client-handler has registered for has become available.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************
 * Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
 *******************************************************************************/
tVoid fc_phone_tclClientHandler_PhoneBook::vOnServiceAvailable()
{
   ETG_TRACE_USR4((" fc_phone_tclClientHandler_PhoneBook:: OnServiceAvailable Entered"));

}

/*******************************************************************************
 *
 * FUNCTION: tVoid fc_phone_tclClientHandler_PhoneBook::vOnServiceUnavailable()
 *
 * DESCRIPTION: This function is called by the CCA framework when the service
 *              this client-handler has registered for has become unavailable.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************
 * Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable()
 *******************************************************************************/
tVoid fc_phone_tclClientHandler_PhoneBook::vOnServiceUnavailable()
{

}

/*******************************************************************************
 *
 * FUNCTION: tVoid  fc_phone_tclClientHandler_PhoneBook::vSetTelServiceInstance(fc_phone_tclService_Telephone*& rfpTelServiceInstance)
 *
 * DESCRIPTION: Stores reference to service
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid  fc_phone_tclClientHandler_PhoneBook::vSetTelServiceInstance(fc_phone_tclService_Telephone*& rfpTelServiceInstance)
{
   ETG_TRACE_USR4((" ENTER fc_phone_tclClientHandler_PhoneBook::vSetTelServiceInstance"));
   m_TelService_instance = rfpTelServiceInstance ;
}

/*******************************************************************************
 *
 * FUNCTION: tVoid  vSearchPhoneBook
 *
 * DESCRIPTION: search name in phonebook
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid  fc_phone_tclClientHandler_PhoneBook::vSearchPhoneBook(tU8 u8DeviceHandle,tString pstr_phonenumber,tU16 CmdCounter)
{
   ETG_TRACE_USR4((" fc_phone_tclClientHandler_PhoneBook:: vSearchPhoneBook Entered"));
   ETG_TRACE_USR4(("u8DeviceHandle: %d, CmdCounter: %d, pstr_phonenumber: %s", u8DeviceHandle, CmdCounter,pstr_phonenumber));

   most_phonbkfi_tclMsgSearchPhoneBookMethodStart oSearchPhoneBook_MS ;

   //fill the parameters

   //FIX CMG3GB-505 Upon disconnecting a call/call is established/entering numbers in dialpad, resets when doing handsfree operation was observed
   oSearchPhoneBook_MS.sEmailAddress.bSet(NULLPTR) ;
   //End of fix

   oSearchPhoneBook_MS.u8DeviceHandle        = u8DeviceHandle ;
   if(m_TelService_instance && (m_TelService_instance->u8GetActiveDeviceHandle() == u8DeviceHandle))
   {
      m_u8ActiveDevHandleReceivedforSearchPB = u8DeviceHandle;
   }
   //gmmy15-8189- reset issue memory allocated via OSAL_NEW later deleted via OSAL_DELETE[]- segmentation fault can occur.
   oSearchPhoneBook_MS.sPhoneNumber.bSet(pstr_phonenumber);
   ETG_TRACE_USR4((" oSearchPhoneBook_MS.sEmailAddress.szValue %s",oSearchPhoneBook_MS.sEmailAddress.szValue));



   //ETG_TRACE_USR4((" PhoneNumber To search :: %s  u8DeviceHandle :: %d ",oSearchPhoneBook_MS.sPhoneNumber.szValue,u8DeviceHandle));

   /* Get the coresponding Call Instance */
   fi_tclVisitorMessage oMSMsg(oSearchPhoneBook_MS, FC_PHONE_SERVICE_TELEPHONE_FI_MAJOR_VERSION);

   tU16 CmdCountertobeUsed = (CmdCounter == 0) ? (static_cast<tU16>(FC_PHONE_TERMINATEALERT_CMDCNTRID_OUTBOUND + u8DeviceHandle)) : (CmdCounter);
   ETG_TRACE_USR4((" CmdCountertobeUsed: %d", CmdCountertobeUsed));

   // Here the message related header information is added and by this the
   // creation of the message is completed.
   vInitServiceData( oMSMsg,                       			// ServiceDataMsg
         CmdCountertobeUsed,                                       // CmdCounter
         MOST_PHONBKFI_C_U16_SEARCHPHONEBOOK,      // Function ID
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART        // Opcode
   );

   if (oMSMsg.bIsValid())
   {

      // Post message
      ail_tenCommunicationError enResult =
            _poMainAppl->enPostMessage(&oMSMsg, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR)
      {
         ETG_TRACE_ERR((" oSearchPhoneBook_MS:Error  enResult:: %d  posting failed",enResult));

         // We can come here e.g. if the client has changed his application
         // state to OFF in the meantime. Therefore we don�t throw an assert.
         // NORMAL_M_ASSERT_ALWAYS();
      }
      else /* Fix for GMMY15-10552 */
      {
         for(tU8 ind = 0; ind < FC_PHONE_MAX_DEVICECONNECTION; ++ind)
         {
            if(m_PBListItems[ind].DeviceHandle == u8DeviceHandle)
            {
               vResetNameInfoFrom_PBListItems_ForIndex(ind);
               m_PBListItems[ind].u8CallInstance = 0xFF;
               break;
            }
         }
      }
   }
   oSearchPhoneBook_MS.vDestroy();

}
/*******************************************************************************
 *
 * FUNCTION: vHandle_SearchPhoneBook_MethodResult()
 *
 * DESCRIPTION: MethodResult Handler for SearchPhoneBook From phonebook
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid  fc_phone_tclClientHandler_PhoneBook::vHandle_SearchPhoneBook_MethodResult(amt_tclServiceData* poMessage)
{

   ETG_TRACE_USR4((" fc_phone_tclClientHandler_PhoneBook::vHandle_SearchPhoneBook_MethodResult Entered"));
   tU16 CmdCounter = FC_PHONE_COMMANDCOUNTERID_UNKNOWN;
   /* Extract the Call instance and other required info from poMessage */
   // Create a FI visitor message for the received CCA message
   fi_tclVisitorMessage oVisitorMsg( poMessage );

   // Create the (message related) FI data object
   most_phonbkfi_tclMsgSearchPhoneBookMethodResult oSearchPhoneBook_MR;
   // Unmarshal the FI visitor message to the given FI data object.
   // The parameters are copied individually from shared memory to the FI data
   // object.

   if ( oVisitorMsg.s32GetData(oSearchPhoneBook_MR, FC_PHONE_PHONEBOOK_FI_MAJOR_VERSION)
         != OSAL_ERROR)
   {
      CmdCounter = poMessage->u16GetCmdCounter();

      ETG_TRACE_USR1(("      u32ContactHandle :: %u      u8DeviceHandle :: %d",oSearchPhoneBook_MR.u32ContactHandle,oSearchPhoneBook_MR.u8DeviceHandle));
      //        ETG_TRACE_USR1(("      sFirstName :: %s      sLastName :: %s",oSearchPhoneBook_MR.sFirstName.szValue,oSearchPhoneBook_MR.sLastName.szValue));
      // ETG_TRACE_USR1(("      e8ContactDetailType :: %d",oSearchPhoneBook_MR.e8ContactDetailType));

      u32ContactHandle = oSearchPhoneBook_MR.u32ContactHandle ;

      vPrintPBList();

      tU8 u8MatchedListIndex = 0xFF;
      for(tU8 ind = 0; ind < FC_PHONE_MAX_DEVICECONNECTION; ++ind)
      {
         if(m_PBListItems[ind].DeviceHandle == oSearchPhoneBook_MR.u8DeviceHandle)
         {
            u8MatchedListIndex = ind;
            break;
         }
      }

      if(0xFF == u8MatchedListIndex)
      {
         ETG_TRACE_USR4(("The Device Handle is not in the list. Device may be disconnected"));
         return;
      }
      /* Fix for GMMY15-10552 Incoming call alert is delayed */

      vResetNameInfoFrom_PBListItems_ForIndex(u8MatchedListIndex);

      ETG_TRACE_USR1((" Received First name ::%s", oSearchPhoneBook_MR.sFirstName.szValue));

      tU32 u32ContactNameLength = static_cast<tU32>(OSAL_u32StringLength(oSearchPhoneBook_MR.sFirstName.szValue) + 1);
      ETG_TRACE_USR1((" First name u32ContactNameLength: %u", u32ContactNameLength));
      m_PBListItems[u8MatchedListIndex].sFirstName = new(std::nothrow) char[u32ContactNameLength];
      if (m_PBListItems[u8MatchedListIndex].sFirstName)
      {
         memset(m_PBListItems[u8MatchedListIndex].sFirstName, '\0', u32ContactNameLength);
         vStringCopy (m_PBListItems[u8MatchedListIndex].sFirstName, oSearchPhoneBook_MR.sFirstName.szValue, u32ContactNameLength);
      }
      else
      {
         ETG_TRACE_USR4(("m_PBListItems[u8MatchedListIndex].sFirstName is NULL"));
      }


      ETG_TRACE_USR1((" Received Last name ::%s", oSearchPhoneBook_MR.sLastName.szValue));

      u32ContactNameLength = static_cast<tU32>(OSAL_u32StringLength(oSearchPhoneBook_MR.sLastName.szValue) + 1);
      ETG_TRACE_USR1((" Last name u32ContactNameLength: %u", u32ContactNameLength));
      m_PBListItems[u8MatchedListIndex].sLastName = new(std::nothrow) char[u32ContactNameLength];
      if (m_PBListItems[u8MatchedListIndex].sLastName)
      {
         memset(m_PBListItems[u8MatchedListIndex].sLastName, '\0', u32ContactNameLength);
         vStringCopy (m_PBListItems[u8MatchedListIndex].sLastName, oSearchPhoneBook_MR.sLastName.szValue, u32ContactNameLength);
      }
      else
      {
         ETG_TRACE_USR4(("m_PBListItems[u8MatchedListIndex].sLastName is NULL"));
      }

      vPrintPBList();

      //update client for INCOMINGCALLEVENT
      ETG_TRACE_USR3((" Forward Search MR response. fc_phone_tclClientHandler_PhoneBook::CmdCounter =  %d  ",CmdCounter));
      /*Belong to Incoming call Event */
      if((CmdCounter > FC_PHONE_TERMINATEALERT_CMDCNTRID_OUTBOUND) && (CmdCounter <= FC_PHONE_TERMINATEALERT_CMDCNTRID_OUTBOUND + MAXIMUM_DEVICE_HANDLE))
      {
         vUpdateSearchPBResponse(oSearchPhoneBook_MR.u8DeviceHandle);
      }
      else
      {
         ETG_TRACE_ERR((" Error:: Command Counter ID doesnt Match"));
      }


   }
   else
   {
      ETG_TRACE_ERR((" ERROR in oSearchPhoneBook_MR message parsing"));
   }

   oSearchPhoneBook_MR.vDestroy();
}

/*******************************************************************************
 *
 * FUNCTION: vHandle_SearchPhoneBook_MethodError()
 *
 * DESCRIPTION: MethodError Handler for SearchPhoneBook From phonebook
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid  fc_phone_tclClientHandler_PhoneBook::vHandle_SearchPhoneBook_MethodError(amt_tclServiceData* poMessage)
{

   ETG_TRACE_USR4((" fc_phone_tclClientHandler_PhoneBook::vHandle_SearchPhoneBook_MethodError Entered"));
   (tVoid) poMessage ;
   tU16 CmdCounter = FC_PHONE_COMMANDCOUNTERID_UNKNOWN;
   CmdCounter = poMessage->u16GetCmdCounter();
   ETG_TRACE_USR4(("CmdCounter: %d", CmdCounter));

   //update client for INCOMINGCALLEVENT
   if((CmdCounter > FC_PHONE_TERMINATEALERT_CMDCNTRID_OUTBOUND) && (CmdCounter <= FC_PHONE_TERMINATEALERT_CMDCNTRID_OUTBOUND + MAXIMUM_DEVICE_HANDLE))
   {
      tU8 DevHandle = static_cast<tU8>(CmdCounter - FC_PHONE_TERMINATEALERT_CMDCNTRID_OUTBOUND);
      ETG_TRACE_USR4(("DevHandle: %d", DevHandle));
      vUpdateSearchPBResponse(DevHandle);
   }
   else
   {
      ETG_TRACE_ERR((" Error:: Command Counter ID doesnt Match"));
   }
}

/*******************************************************************************
 *
 * FUNCTION: vUpdateSearchPBResponse()
 *
 * DESCRIPTION: Update Search PhoneBook Response
 *
 * PARAMETER: Device Handle
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid  fc_phone_tclClientHandler_PhoneBook::vUpdateSearchPBResponse(tU8 u8DevHandle)
{
   ETG_TRACE_USR4(("ENTER  fc_phone_tclClientHandler_PhoneBook::vUpdateSearchPBResponse with u8DevHandle= %d", u8DevHandle));

   if(m_TelService_instance)
   {
      //TODO 2HFP: In case of conversion of Active device to Passive or vice-versa before receiving the response for SearchPB,
      //necessary changes has to be done.

      if(m_u8ActiveDevHandleReceivedforSearchPB == u8DevHandle)
      {
         m_TelService_instance->vUpdateSearchPhoneBookMR_ResponseToSMs();
         m_u8ActiveDevHandleReceivedforSearchPB = FC_PHONE_DEVICEHANDLE_UNKNOWN;
      }
      else
      {
         m_TelService_instance->vUpdateRingingIncomingCallEvent(u8DevHandle);
      }
   }
   else
   {
      ETG_TRACE_ERR((" Error:: m_TelService_instance is NULL"));
   }
}
/*******************************************************************************
 *
 * FUNCTION: sGetFirstName
 *
 * DESCRIPTION: return First name pointer
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: First Name pointer.
 *
 ********************************************************************************/
tVoid fc_phone_tclClientHandler_PhoneBook::vGetFirstName(tString &psFirstName, tU8 DevHandle)  // Lint fix
{
   ETG_TRACE_USR4(("ENTER  fc_phone_tclClientHandler_PhoneBook::vGetFirstName with DevHandle= %d", DevHandle));
   if(m_TelService_instance)
   {
      tU8 tempDevHandle = (DevHandle == FC_PHONE_DEVICEHANDLE_UNKNOWN) ? (m_TelService_instance->u8GetActiveDeviceHandle()): DevHandle;
      ETG_TRACE_USR4(("tempDevHandle = %d", tempDevHandle));

      for(tU8 ind = 0; ind < FC_PHONE_MAX_DEVICECONNECTION; ++ind)
      {
         if(m_PBListItems[ind].DeviceHandle == tempDevHandle)
         {
            if (psFirstName)
            {
               delete []psFirstName;
               psFirstName = NULLPTR;
            }

            if (m_PBListItems[ind].sFirstName)
            {
               tU32 u32size = static_cast<tU32>(OSAL_u32StringLength(m_PBListItems[ind].sFirstName) + 1);
               psFirstName = new(std::nothrow) char[u32size];

               if (psFirstName)
               {
                  memset(psFirstName, '\0', u32size);
                  vStringCopy(psFirstName, m_PBListItems[ind].sFirstName, u32size);
               }
            }
            break;
         }
      }
   }
   else
   {
      ETG_TRACE_USR4(("m_TelService_instance is NULL"));
   }
}

/*******************************************************************************
 *
 * FUNCTION: vGetLastName
 *
 * DESCRIPTION: return Last name pointer
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: Last Name pointer.
 *
 ********************************************************************************/
tVoid fc_phone_tclClientHandler_PhoneBook::vGetLastName(tString &psLastName, tU8 DevHandle) // Lint fix
{
   ETG_TRACE_USR4(("ENTER  fc_phone_tclClientHandler_PhoneBook::vGetLastName with DevHandle: %d", DevHandle));
   if(m_TelService_instance)
   {
      tU8 tempDevHandle = (DevHandle == FC_PHONE_DEVICEHANDLE_UNKNOWN) ? (m_TelService_instance->u8GetActiveDeviceHandle()): DevHandle;
      ETG_TRACE_USR4(("tempDevHandle = %d", tempDevHandle));

      for(tU8 ind = 0; ind < FC_PHONE_MAX_DEVICECONNECTION; ++ind)
      {
         if(m_PBListItems[ind].DeviceHandle == tempDevHandle)
         {
            if (psLastName)
            {
               delete []psLastName;
               psLastName = NULLPTR;
            }

            if (m_PBListItems[ind].sLastName)
            {
               tU32 u32size = static_cast<tU32>(OSAL_u32StringLength(m_PBListItems[ind].sLastName) + 1);
               psLastName = new(std::nothrow) char[u32size];

               if (psLastName)
               {
                  memset(psLastName, '\0', u32size);
                  vStringCopy(psLastName, m_PBListItems[ind].sLastName, u32size);
               }
            }
            break;
         }
      }
   }
   else
   {
      ETG_TRACE_USR4(("m_TelService_instance is NULL"));
   }
}

/*******************************************************************************
 *
 * FUNCTION: u32GetContactHandle
 *
 * DESCRIPTION: get contact handle
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: contact handle
 *
 ********************************************************************************/
tU32  fc_phone_tclClientHandler_PhoneBook::u32GetContactHandle()
{
   ETG_TRACE_USR4((" ENTER fc_phone_tclClientHandler_PhoneBook::u32GetContactHandle"));
   return u32ContactHandle ;

}

//FIX GMMY16-7030 The name on incoming call alert, sent successful alert and reply view, end/send view is always sorted as "First name Last name".
//While appending name for incoming call alert, FC_Phone has to check the Preferred sort order and append accordingly.
/*******************************************************************************
 *
 * FUNCTION: vGetPreferredPhonebookSortOrder()
 *
 * DESCRIPTION: To get Preferred Phonebook sort order
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclClientHandler_PhoneBook::vGetPreferredPhonebookSortOrder()
{
   ETG_TRACE_USR4(("fc_phone_tclClientHandler_PhoneBook::vGetPreferredPhonebookSortOrder Entered"));

   most_phonbkfi_tclMsgPreferredPhoneBookSortOrderGet oPreferredPhoneBookSortOrderGet;

   fi_tclVisitorMessage oMsg(oPreferredPhoneBookSortOrderGet, MOST_PHONBKFI_C_U16_SERVICE_MAJORVERSION);

   // Here the message related header information is added and by this the
   // creation of the message is completed.
   vInitServiceData(oMsg, 0, MOST_PHONBKFI_C_U16_PREFERREDPHONEBOOKSORTORDER, AMT_C_U8_CCAMSG_OPCODE_GET);

   // Post message
   ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oMsg, TRUE);

   if (enResult != AIL_EN_N_NO_ERROR)
   {
      ETG_TRACE_ERR(("enPostMessage() failed vGetPreferredPhonebookSortOrder message"));
   }
   oPreferredPhoneBookSortOrderGet.vDestroy();
}

/*******************************************************************************
 *
 * FUNCTION: vHandle_PreferredPhonebookSortOrder_Status()
 *
 * DESCRIPTION: Handler for PreferredPhonebookSortOrder Status update from FC_Phonebook
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/

tVoid  fc_phone_tclClientHandler_PhoneBook::vHandle_PreferredPhonebookSortOrder_Status(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR4(("fc_phone_tclClientHandler_PhoneBook:: vHandle_PreferredPhonebookSortOrder_Status Entered"));
   if (poMessage)
   {
      fi_tclVisitorMessage oVisitorMsg(poMessage);
      most_phonbkfi_tclMsgPreferredPhoneBookSortOrderStatus oPreferredPhonebookSortOrder_Status;

      if (oVisitorMsg.s32GetData(oPreferredPhonebookSortOrder_Status, MOST_PHONBKFI_C_U16_SERVICE_MAJORVERSION) != OSAL_ERROR)
      {
         switch(oPreferredPhonebookSortOrder_Status.e8PreferredPhoneBookSortOrder.enType)
         {
            case most_fi_tcl_e8_PhonBkPreferredPhoneBookSortOrder::FI_EN_E8PREFERRED_SORT_ORDER_FIRSTNAME:
               m_enPreferredPhonebookSortOrder = e8PreferredSortOrderFirstNameLastName;
               break;
            case most_fi_tcl_e8_PhonBkPreferredPhoneBookSortOrder::FI_EN_E8PREFERRED_SORT_ORDER_LASTNAME:
               m_enPreferredPhonebookSortOrder = e8PreferredSortOrderLastNameFirstName;
               break;
            default:
               m_enPreferredPhonebookSortOrder = e8PreferredSortOrderInvalid;
               break;
         }
         ETG_TRACE_USR4(("vHandle_PreferredPhonebookSortOrder_Status PhonebookSorderOrder: %d", m_enPreferredPhonebookSortOrder));
      }
   }
}

/*******************************************************************************
 *
 * FUNCTION: enGetPreferredPhonebookSortOrder()
 *
 * DESCRIPTION: Returns the latest preferred sort order received from FC_Phonebook
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
enPreferredPhonebookSortOrder  fc_phone_tclClientHandler_PhoneBook::enGetPreferredPhonebookSortOrder()
{
   ETG_TRACE_USR4(("fc_phone_tclClientHandler_PhoneBook:: enGetPreferredPhonebookSortOrder Entered"));
   return m_enPreferredPhonebookSortOrder;
}
//End of fix

/*******************************************************************************
 *
 * FUNCTION: vInsertPBListItem()
 *
 * DESCRIPTION: Adds the PB List Item into the list on Device Connection
 *
 * PARAMETER: DeviceHandle.
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclClientHandler_PhoneBook::vInsertPBListItem(tU8 DevHandle)
{
   ETG_TRACE_USR4(("fc_phone_tclClientHandler_PhoneBook::vInsertPBListItem Entered with DevHandle: %d", DevHandle));
   for(tU8 ind = 0; ind < FC_PHONE_MAX_DEVICECONNECTION; ++ind)
   {
      if(m_PBListItems[ind].DeviceHandle == FC_PHONE_DEVICEHANDLE_UNKNOWN)
      {
         m_PBListItems[ind].DeviceHandle = DevHandle;
         m_PBListItems[ind].u8CallInstance = 0xFF;
         vResetNameInfoFrom_PBListItems_ForIndex(ind);
         break;
      }
   }
   vPrintPBList();
}

/*******************************************************************************
 *
 * FUNCTION: vRemovePBListItem()
 *
 * DESCRIPTION: Removes the PB List Item from the list on Device Disconnection
 *
 * PARAMETER: DeviceHandle.
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclClientHandler_PhoneBook::vRemovePBListItem(tU8 DevHandle)
{
   ETG_TRACE_USR4(("fc_phone_tclClientHandler_PhoneBook::vRemovePBListItem Entered with DevHandle: %d", DevHandle));
   for(tU8 ind = 0; ind < FC_PHONE_MAX_DEVICECONNECTION; ++ind)
   {
      if(m_PBListItems[ind].DeviceHandle == DevHandle)
      {
         m_PBListItems[ind].DeviceHandle = FC_PHONE_DEVICEHANDLE_UNKNOWN;
         m_PBListItems[ind].u8CallInstance = 0xFF;
         vResetNameInfoFrom_PBListItems_ForIndex(ind);
      }
   }
   vPrintPBList();
}

/*******************************************************************************
 *
 * FUNCTION: vPrintPBList()
 *
 * DESCRIPTION: Prints the PB List
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclClientHandler_PhoneBook::vPrintPBList()
{
   ETG_TRACE_USR4(("fc_phone_tclClientHandler_PhoneBook::vPrintPBList Entered"));
   for(tU8 ind = 0; ind < FC_PHONE_MAX_DEVICECONNECTION; ++ind)
   {
      ETG_TRACE_USR4(("m_PBListItems[%d].DeviceHandle = %d", ind, m_PBListItems[ind].DeviceHandle));
      ETG_TRACE_USR4(("m_PBListItems[%d].sFirstName = %s", ind, m_PBListItems[ind].sFirstName));
      ETG_TRACE_USR4(("m_PBListItems[%d].sLastName = %s", ind, m_PBListItems[ind].sLastName));
      ETG_TRACE_USR4(("m_PBListItems[%d].u8CallInstance = %d", ind, m_PBListItems[ind].u8CallInstance));
   }
}

/*******************************************************************************
 *
 * FUNCTION: vSetIncomingCallInstanceinPBList()
 *
 * DESCRIPTION: This is to set the call instance so that IDLE INCOMINGCALL EVENT shall be sent correspondingly
 *
 * PARAMETER: tU8 u8DevHandle, tU8 CallInstance
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclClientHandler_PhoneBook::vSetIncomingCallInstanceinPBList(tU8 u8DevHandle, tU8 CallInstance)
{
   ETG_TRACE_USR4(("Entered vSetIncomingCallInstanceinPBList with u8DevHandle: %d and CallInstance: %d", u8DevHandle, CallInstance));
   for(tU8 ind = 0; ind < FC_PHONE_MAX_DEVICECONNECTION; ++ind)
   {
      if(m_PBListItems[ind].DeviceHandle == u8DevHandle)
      {
         m_PBListItems[ind].u8CallInstance = CallInstance;
      }
   }
   vPrintPBList();
}

/*******************************************************************************
 *
 * FUNCTION: u8GetIncomingCallInstancefromPBList()
 *
 * DESCRIPTION: This is to get the call instance so that IDLE INCOMINGCALL EVENT shall be sent correspondingly
 *
 * PARAMETER: tU8 u8DevHandle, tU8 CallInstance
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tU8 fc_phone_tclClientHandler_PhoneBook::u8GetIncomingCallInstancefromPBList(tU8 u8DevHandle)
{
   ETG_TRACE_USR4(("Entered u8GetIncomingCallInstancefromPBList with u8DevHandle: %d", u8DevHandle));
   vPrintPBList();

   tU8 CallInstance = 0xFF;
   for(tU8 ind = 0; ind < FC_PHONE_MAX_DEVICECONNECTION; ++ind)
   {
      if(m_PBListItems[ind].DeviceHandle == u8DevHandle)
      {
         ETG_TRACE_USR4(("m_PBListItems[%d].u8CallInstance:  %d", ind, m_PBListItems[ind].u8CallInstance));
         CallInstance =  m_PBListItems[ind].u8CallInstance;
      }
   }
   return CallInstance;
}

/*******************************************************************************
 *
 * FUNCTION: vResetNameInfoFrom_PBListItems_ForIndex()
 *
 * DESCRIPTION: This function is used to reset the Name details from the PBListItems table for the given index
 *
 * PARAMETER: tU8 index
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclClientHandler_PhoneBook::vResetNameInfoFrom_PBListItems_ForIndex(tU8 u8index)
{
   ETG_TRACE_USR4(("Entered vResetNameInfoFrom_PBListItems_ForIndex with u8index: %d", u8index));

   if (m_PBListItems[u8index].sFirstName)
   {
      delete []m_PBListItems[u8index].sFirstName;
      m_PBListItems[u8index].sFirstName = NULLPTR;
   }
   if (m_PBListItems[u8index].sLastName)
   {
      delete []m_PBListItems[u8index].sLastName;
      m_PBListItems[u8index].sLastName = NULLPTR;
   }

}
