/*******************************************************************************
*                                                                               
* FILE:          FC_Phpne_clienthandler_MediaPlayer.h
*                                                                               
* SW-COMPONENT:  FC_Phone Client Handler for MediaPlayer
*                                                                               
* PROJECT:       Bosch
*                                                                               
* DESCRIPTION:   CCA client-handler for the service MediaPlayer.
*                                                                               
* AUTHOR:
*                                                                               
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
*                                                                               
*******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
//Include FI interface of used service
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_MEDIAPLAYERFI_TYPES
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_MEDIAPLAYERFI_FUNCTIONIDS
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_MEDIAPLAYERFI_ERRORCODES
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_MEDIAPLAYERFI_SERVICEINFO

#include "mplay_fi_if.h"
#include "HelperClasses/FC_Phone_PhoneData.h"
/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                             */
/*                                                                            */
/******************************************************************************/

class ahl_tclBaseOneThreadClientHandler;


class fc_phone_tclClientHandler_MediaPlayer
      : public ahl_tclBaseOneThreadClientHandler
        {
public:

         fc_phone_tclClientHandler_MediaPlayer(tVoid);
         fc_phone_tclClientHandler_MediaPlayer(fc_phone_tclApp* poMainAppl);
         virtual ~fc_phone_tclClientHandler_MediaPlayer();


         static fc_phone_tclClientHandler_MediaPlayer* poGetInstance();

         /***************************************************************************
          * Overriding ahl_tclBaseOneThreadClientHandler methods.
          ***************************************************************************/

         virtual tVoid vOnServiceAvailable();
         virtual tVoid vOnServiceUnavailable();

         tVoid vSetTelServiceInstance(fc_phone_tclService_Telephone*& rfpTelServiceInstance);
         tBool vGetMediaPlayingStatus();

         DECLARE_MSG_MAP(fc_phone_tclClientHandler_MediaPlayer)

private:
         /****************************************************************************
                           Member variables for MediaPlayer
          ****************************************************************************/

         tVoid vHandle_ReadyToPlayStatus (amt_tclServiceData* poMessage);
         static fc_phone_tclClientHandler_MediaPlayer *poInstance;
         fc_phone_tclService_Telephone* m_TelService_instance;
         tBool m_bReadyToPlayStatus;

};
