/*******************************************************************************
*                                                                               
* FILE:          FC_Phpne_clienthandler_MediaPlayer.cpp
*                                                                               
* SW-COMPONENT:  FC_Phone Client Handler for MediaPlayer
*                                                                               
* PROJECT:       Bosch                                                              
*                                                                               
* DESCRIPTION:   CCA client-handler for the service MediaPlayer.
*                                                                               
* AUTHOR:
*                                                                               
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
*                                                                               
*******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
#include "FC_Phone_main.h"
#include "FC_Phone_clienthandler_BTSettings.h"
#include "FC_Phone_service_Telephone.h"
#include "Interface/FC_Phone_DBusInterface.h"
#include "HelperClasses/FC_Phone_AudioManager.h"
#include "FC_Phone_clienthandler_MediaPlayer.h"

//Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_PHONE_APPLICATION
#include "trcGenProj/Header/FC_Phone_clienthandler_MediaPlayer.cpp.trc.h"
#endif

fc_phone_tclClientHandler_MediaPlayer* fc_phone_tclClientHandler_MediaPlayer::poInstance = NULLPTR ;
static void set_raw_btaddr_to_formatted(char *node_name,const char *BTSetting_addr,tU32 dest_size);
/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/


/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(fc_phone_tclClientHandler_MediaPlayer, ahl_tclBaseWork)



     ON_MESSAGE_SVCDATA( MPLAY_MEDIAPLAYERFI_C_U16_READYTOPLAY,
				 		 AMT_C_U8_CCAMSG_OPCODE_STATUS ,
				 		vHandle_ReadyToPlayStatus )

END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/


/*******************************************************************************
*
* FUNCTION: fc_phone_tclClientHandler_MediaPlayer::
*          fc_phone_tclClientHandler_MediaPlayer(fc_phone_tclApp* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
fc_phone_tclClientHandler_MediaPlayer::
		fc_phone_tclClientHandler_MediaPlayer(fc_phone_tclApp* poMainAppl)
    : ahl_tclBaseOneThreadClientHandler(
       /* Application Pointer         */ poMainAppl,
       /* ID of used Service          */ CCA_C_U16_SRV_FB_MEDIAPLAYER,
      /* MajorVersion of used Service */ MPLAY_MEDIAPLAYERFI_C_U16_SERVICE_MAJORVERSION,
      /* MinorVersion of used Service */ MPLAY_MEDIAPLAYERFI_C_U16_SERVICE_MINORVERSION ,
	  /* App ID  						     */ CCA_C_U16_APP_MEDIAPLAYER)
{
   ETG_TRACE_USR4(("  fc_phone_tclClientHandler_MediaPlayer entered. "));
   poInstance = this ;

   //Registering properties
   vAddAutoRegisterForProperty(MPLAY_MEDIAPLAYERFI_C_U16_READYTOPLAY);
   m_TelService_instance = NULLPTR ;
   m_bReadyToPlayStatus = false;
}

/*******************************************************************************
*
* FUNCTION: fc_phone_tclClientHandler_MediaPlayer::
*             ~fc_phone_tclClientHandler_MediaPlayer(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
fc_phone_tclClientHandler_MediaPlayer::~fc_phone_tclClientHandler_MediaPlayer(tVoid)
{
   ETG_TRACE_USR4(("  ~fc_phone_tclClientHandler_MediaPlayer entered. "));
   m_bReadyToPlayStatus = false;
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_phone_tclClientHandler_MediaPlayer::
*							   vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid fc_phone_tclClientHandler_MediaPlayer::vOnServiceAvailable()
{
   ETG_TRACE_USR4(("  vOnServiceAvailable entered. "));
   ETG_TRACE_USR2((" vOnServiceAvailable() entered. AppID = %u.", u16GetServerAppID()));
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_phone_tclClientHandler_MediaPlayer::
					             vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid fc_phone_tclClientHandler_MediaPlayer::vOnServiceUnavailable()
{
   ETG_TRACE_USR4(("  vOnServiceUnavailable entered. "));
   ETG_TRACE_USR2((" vOnServiceAvailable() entered. AppID = %u.", u16GetServerAppID()));
}

/*******************************************************************************
*
* FUNCTION: poGetInstance()
*
* DESCRIPTION: To get instance of mediaPlayer Client Handler
*
* PARAMETER: 
*
* RETURNVALUE: - mediaPlayer Client Handler Instance
*
*******************************************************************************/
fc_phone_tclClientHandler_MediaPlayer* fc_phone_tclClientHandler_MediaPlayer::poGetInstance()
{
   ETG_TRACE_USR4(("  fc_phone_tclClientHandler_MediaPlayer::poGetInstance entered. "));
   return poInstance ;
}

/*******************************************************************************
 *
 * FUNCTION: tVoid  fc_phone_tclClientHandler_PhoneBook::vSetTelServiceInstance(fc_phone_tclService_Telephone*& rfpTelServiceInstance)
 *
 * DESCRIPTION: Stores reference to service
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid  fc_phone_tclClientHandler_MediaPlayer::vSetTelServiceInstance(fc_phone_tclService_Telephone*& rfpTelServiceInstance)
{
   ETG_TRACE_USR4((" ENTER fc_phone_tclClientHandler_MediaPlayer::vSetTelServiceInstance"));
   m_TelService_instance = rfpTelServiceInstance ;
}

/*******************************************************************************
 *
 * FUNCTION:   vHandle_ReadyToPlayStatus(..)
 *
 * DESCRIPTION:  This is a handler function for ReadyToPlay property status
 *
 * PARAMETER:
 *    IN:   poMessage        : This is the received message from mediaplayer client
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid  fc_phone_tclClientHandler_MediaPlayer::vHandle_ReadyToPlayStatus (amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR4((" vHandle_ReadyToPlayStatus entered."));
   // Extract the device address and the playbackstatus info from poMessage
   // Create a FI visitor message for the received CCA message
   fi_tclVisitorMessage oVisitorMsg( poMessage );

   // Create the (message related) FI data object

   mplay_mediaplayerfi_tclMsgReadyToPlayStatus oReadyToPlay_Status;

   // Unmarshal the FI visitor message to the given FI data object.
   // The parameters are copied individually from shared memory to the FI data object.
   if ( oVisitorMsg.s32GetData(oReadyToPlay_Status, MPLAY_MEDIAPLAYERFI_C_U16_SERVICE_MAJORVERSION)
         != OSAL_ERROR)
   {
      if((oReadyToPlay_Status.sDeviceSerialNumber == NULLPTR) || (m_TelService_instance == NULLPTR))
      {
         ETG_TRACE_USR4(("Received a NULL value"));
         oReadyToPlay_Status.vDestroy();
         return;
      }
      tU8 u8ActiveDeviceHandle = m_TelService_instance->u8GetActiveDeviceHandle();
      ETG_TRACE_USR4(("u8ActiveDeviceHandle = %d",u8ActiveDeviceHandle));

      tU8 u8BTAddressId = (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerBTSettings->u8GetBTAddressIdFromDeviceHandle(u8ActiveDeviceHandle);
      if(INVALID_BDADDRESS_ID != u8BTAddressId)
      {
         const tChar * btaddress = fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(u8BTAddressId);
         if(btaddress)
         {
            ETG_TRACE_USR4(("btaddress = %s",btaddress));
            char format_dev_addr[PHONE_BDADRESS_LENGTH] = {'\0'};
            set_raw_btaddr_to_formatted(format_dev_addr,oReadyToPlay_Status.sDeviceSerialNumber.szValue,PHONE_BDADRESS_LENGTH);
            if((u8StringCompare(btaddress,format_dev_addr)) == 0)
            {
               m_bReadyToPlayStatus = (tBool)oReadyToPlay_Status.bPlayingStatus;
               ETG_TRACE_USR1(("ReadyToPlayStatus :: %d", m_bReadyToPlayStatus));
#ifdef EXTEND_VR_SESSION
               if((m_bReadyToPlayStatus) && (m_TelService_instance))
               {
                  ETG_TRACE_USR1(("ReadyToPlayStatus Set to TRUE- STOP VR Session"));
                  m_TelService_instance->vStopExtendedVRSession();
                  m_bReadyToPlayStatus = false;
               }
#endif
            }
         }
         else
         {
            ETG_TRACE_USR4(("btaddress is NULL"));
         }
      }
      else
      {
         ETG_TRACE_USR4(("BTAddessID is INVALID_BDADDRESS_ID "));
      }
   }
   oReadyToPlay_Status.vDestroy();
}

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclClientHandler_MediaPlayer::vGetMediaPlayingStatus
 *
 * DESCRIPTION: This function is used to return the current Playing Status of the Mediaplayer
 *
 * PARAMETER: NONE
 *
 * RETURNVALUE: [OUT]:   m_bReadyToPlayStatus - Type: Boolean
 *
 ********************************************************************************/
tBool fc_phone_tclClientHandler_MediaPlayer::vGetMediaPlayingStatus()
{
   ETG_TRACE_USR4((" fc_phone_tclClientHandler_MediaPlayer::vGetMediaPlayingStatus = %d",m_bReadyToPlayStatus));
   return m_bReadyToPlayStatus;
}

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclClientHandler_MediaPlayer::set_raw_btaddr_to_formatted
 *
 * DESCRIPTION: This function is used to convert macaddress into "dev_xx_xx_xx_xx_xx_xx" format
 *
 * PARAMETER: NONE
 *
 * RETURNVALUE: [OUT]: NONE
 *
 ********************************************************************************/
static void set_raw_btaddr_to_formatted(char *node_name,const char *BTSetting_addr,
      tU32 dest_size)
{

   ETG_TRACE_USR4(("set_raw_btaddr_to_formatted entered "));
   //Reset occurs when the BTSetting_addr is NULL.So this null check is added
   if(BTSetting_addr)
   {
      if(strstr(BTSetting_addr,"dev_"))
      {
         vStringCopy(node_name, BTSetting_addr, dest_size);
      }
      else
      {
         tChar tempBD_Address[PHONE_TEMP_DEV_ADDRESS] = {'\0'};

         sscanf(BTSetting_addr, "%02x%02x%02x%02x%02x%02x",
               (tUInt *) &tempBD_Address[0], (tUInt *) &tempBD_Address[1],
               (tUInt *) &tempBD_Address[2], (tUInt *) &tempBD_Address[3],
               (tUInt *) &tempBD_Address[4], (tUInt *) &tempBD_Address[5]);

         snprintf(node_name, dest_size, "dev_%02x_%02x_%02x_%02x_%02x_%02x",
               (unsigned char)tempBD_Address[0],
               (unsigned char)tempBD_Address[1],
               (unsigned char)tempBD_Address[2],
               (unsigned char)tempBD_Address[3],
               (unsigned char)tempBD_Address[4],
               (unsigned char)tempBD_Address[5]
         );
      }
      ETG_TRACE_USR4(("node_name = %s",node_name));
   }
}
