/*******************************************************************************
 *
 * FILE:          FC_Phone_DBusClientEvo.h
 *
 * SW-COMPONENT:
 *
 * PROJECT:
 *
 * DESCRIPTION:   FC_Phone DBUS client
 *
 * AUTHOR:        Elumalai Narasimman
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

#ifndef _FB_DBUS_EVO_H
#define _FB_DBUS_EVO_H

#include <stdlib.h>
#include "../FC_Phone_main.h"
#include "../Interface/FC_Phone_DBusInterface.h"

#define BASE_CALL_PATH_EVO "/hfp/xxxxxxxxxxxx_xxxxxxxxxxxx/voicecall0"

#define BASE_EVO_HANDSFREE_SERVICE_NAME "org.ofono"
#define BASE_EVO_MANAGER_OBJECT_PATH "/"

//Handsfree
#define BASE_HANDSFREE_OBJECT_PATH_EVO "/hfp/"

#define FC_PHONE_NUMBER_OF_CALLS_SUPPORT 5
#define FC_PHONE_CALL_PATH_LENGTH 50
#define FC_PHONE_NUMBER_OF_DEVICE_CONNECTION_SUPPORT 2
#define FC_PHONE_DEVICE_CONNECTION_INVALID_SLOT 0xFF
#define FC_PHONE_DBUS_SUCCESS 0x00
#define FC_PHONE_DBUS_FAIL    0x01

#define FC_PHONE_DBUS_SERVICE_TYPE_HFP 0x00
#define FC_PHONE_DBUS_SERVICE_TYPE_AVP 0x01
#define FC_PHONE_DBUS_SERVICE_TYPE_OPP 0x02
#define FC_PHONE_DBUS_SERVICE_TYPE_SPP 0x03
#define FC_PHONE_DBUS_SERVICE_TYPE_ALL 0xFF   //for disconnect only

typedef enum
{
   FC_PHONE_DBUS_TERMINATETYPE_SINGLECALL              = 1,
   FC_PHONE_DBUS_TERMINATETYPE_MULTIPLECALL_ACTIVE     = 2,
   FC_PHONE_DBUS_TERMINATETYPE_MULTIPLECALL_INACTIVE   = 3,
   FC_PHONE_DBUS_TERMINATETYPE_ALL                     = 4,
   FC_PHONE_DBUS_TERMINATETYPE_THREEWAYCALL_SPECIFIC   = 5,
   //GMMY15-9890 To cancel the second outgoing call using HfReleaseSpecCall instead of HfReleaseActiveCall FC_Phone will make use of this enum
   FC_PHONE_DBUS_TERMINATETYPE_THREEWAYCALL_SPECIFIC_CANCEL_OUTGOING = 6,
   FC_PHONE_DBUS_TERMINATETYPE_SECONDCALL_WAITING = 7,
   FC_PHONE_DBUS_TERMINATETYPE_ACTIVECALL_ACCEPT_WAITING = 8

}FCPhoneDbusClient_TerminateType_t;


typedef enum
{
   FC_PHONE_DBUS_ACCEPT_SINGLECALL              = 1,
   FC_PHONE_DBUS_ACCEPT_SECOND_WAITINGCALL      = 2
}FCPhoneDbusClient_AcceptType_t;


typedef enum
{
   FC_PHONE_DBUS_IGNORE_SINGLECALL              = 1,
   FC_PHONE_DBUS_IGNORE_SECOND_WAITINGCALL      = 2
}FCPhoneDbusClient_IgnoreType_t;
/******************************************************************

Data Structure Name: _CCA_dbus_interfaces

Description: Exposes the interfaces pertaining to all the Call-based operations in the dbus communication layer

 *******************************************************************/

//Three Function added in the Last for Siri #if PHONE_SIRI
typedef struct CCA_dbus_interface_table
{
   void (*vInit)();
   gboolean (*bCreateProxyAndRegisterSignals)(const char *);
   gboolean (*bDeleteProxyAndDeRegisterSignals)(const char *);
   gboolean (*bAcceptCall)(const char *,FCPhoneDbusClient_AcceptType_t enAcceptType);
   gboolean (*bHoldCall)(const char *);
   gboolean (*bHangUpCall)(const char * ,FCPhoneDbusClient_TerminateType_t enTerminateType);
   gboolean (*bRejectCall)(const char *,FCPhoneDbusClient_IgnoreType_t enIgnoreType);
   gboolean (*bGetDeviceName)(const char *);
   gboolean (*bDial)(const char *,const char* );
   gboolean (*bTerminateCall)(const char *,FCPhoneDbusClient_TerminateType_t enTerminateType);
   void     (*vdiagnostic_mode_config)(int eComponent,int bool_value);
   gboolean (*bAudioTransfer)(const char *, gboolean);
   gboolean (*bQueryTelephoneNumber)(const char * );
   gboolean (*bGetPhoneStatus)(const char * );
   gboolean (*bSendDTMF)(const char*,guchar );
   gboolean (*bSpeedDial)(const char *,guint );
   gboolean (*bResumeCall)(const char *);
   gboolean (*bHoldIncomingCall)(const char *);
   gboolean (*bSwapCall)(const char *);
   gboolean (*bConfCall)(const char *);
   gboolean (*bSplitCall)(const char *, guchar);
   gboolean (*bReleaseSpecCall)(const char* ,FCPhoneDbusClient_TerminateType_t enTerminateType, guchar);
   gboolean (*bGetCallStatus)(const char * );
   gboolean (*bGetSCOConnectionStatus)(const char * );
   gboolean (*bActivateVoiceRecognition)(const char *, guchar);
   gboolean (*bAcquireTelephoneNumber)(const char * );
#ifdef PHONE_SIRI
   gboolean (*bEnableSiri)(const char *, VehicleInformation devInfo);
   gboolean (*bSetSiriNrStatus)(const char *, const guchar);
   gboolean (*bSetSiriEfm)(const char *,const guchar);
#endif

}_CCA_dbus_interfaces;

_CCA_dbus_interfaces * get_cca_evo_dbus_interface(void);
void register_cca_evo_callbacks(_T_CCA_Dbus_If *vCCA_callbacks);

void AssignBusConnection(void);
void CreateVoiceCallProxy(void);
void SetVehicleBtAddress(char* Address);
void acceptSCOConnectRequest(char* Address);

#endif //_FB_DBUS_EVO_H
