/*******************************************************************************
 *
 * FILE:          FC_Phone_Global.cpp
 *
 * SW-COMPONENT:  FC_Phone application
 *
 * PROJECT:
 *
 * DESCRIPTION:   Helper functions
 *
 * AUTHOR:
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

#include "../FC_Phone_main.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_PHONE_APPLICATION
#include "trcGenProj/Header/FC_Phone_Global.cpp.trc.h"
#endif

/*******************************************************************************
 * FUNCTION: vStringCopy
 *
 * DESCRIPTION: Does safe string copy
 *
 * PARAMETER: dest - Destination string
 *            src - Source string
 *            dest_size - size of destination string
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
void vStringCopy(char *dest, const char* src, tU32 dest_size)
{
   ETG_TRACE_USR4((" vStringCopy entered."));
   if (!src || !dest)
   {
      ETG_TRACE_USR4((" vStringCopy : src or dest is NULL"));
      return;
   }
   tU32 u32CopySize = static_cast<tU32>(strlen(src) + 1);
   if (u32CopySize > dest_size)
   {
      ETG_TRACE_USR4((" vStringCopy : src string greater that dest size"));
      u32CopySize  = dest_size ;
   }
   memmove(dest, src, u32CopySize-1);
   dest[u32CopySize-1] = '\0';
}


/*******************************************************************************
 * FUNCTION: u8StringCompare
 *
 * DESCRIPTION: Does null check before comparing strings
 *
 * PARAMETER: str1 - first string to compare
 *            str2 - second string to compare*
 *
 * RETURNVALUE: 0 - if string are equal
 *              -1, 1 if string don't match or is NULL.
 ********************************************************************************/
tS32 u8StringCompare(const char *str1, const char*str2)
{
   ETG_TRACE_USR4((" u8StringCompare entered."));
   tS32 ret = 0;

   if (!str1 || !str2)
   {
      ETG_TRACE_USR4(("u8StringCompare : str1 or str2 is NULL"));
      return -1;
   }
   //Clone Ticket GMMY15-4256(Nullpointerexception in "phone.out")
   tU32 u32Size1 = static_cast<tU32>(strlen(str1));
   tU32 u32Size2 = static_cast<tU32>(strlen(str2));
   if (u32Size1 != u32Size2)
   {
      ETG_TRACE_USR4(("u8StringCompare : Size Mismatch, not same")); //Bugfix for GMMY16-7007
      return -1;
   }

   ret = static_cast<tS32>(strncmp(str1, str2, u32Size1));

   ETG_TRACE_USR4(("u8StringCompare :: ret : %d", ret));
   return ret;
}


