
#ifndef _FC_PHONE_ECNR_H
#define _FC_PHONE_ECNR_H

#include <gio/gio.h>

#include "../Interface/FC_Phone_EcnrInterface.h"

#define ECNR_OBJECT_PATH "/"
#define ECNR_SERVICE_NAME "org.bosch.ecnr.service"
#define ECNR_INTERFACE_NAME "org.bosch.ecnr.service"
#define ALSA_SERVICE_NAME "org.bosch.ecnr.alsa"
#define DBUS_INTERFACE_NAME "org.freedesktop.DBus.Properties"

#define INTEGER_DEFAULT 255

#if __cplusplus < 201103L
#define NULLPTR NULL //C++03 or below
#else
#define NULLPTR nullptr //C++11 or above
#endif

typedef enum
{
   ECNR_INITIALIZE,
   ECNR_CONFIGURATION,
   ECNR_STARTAUDIO,
   ECNR_STOPAUDIO,
   ECNR_DESTROY
}tenECNRRequestType;
typedef struct
{
   tenECNRRequestType eventType;
   tU16 u16Data;
}tEcnrData;

void FB_ecnr_init(GDBusConnection *connection); //CMG3G-4847 - To solve Lint
void FB_ecnr_deinit(GDBusConnection *connection);
gboolean ecnrInitialize(tUInt dataset, tBool bisFromQueue = FALSE);
gboolean ecnrStartAudio( tBool bisFromQueue = FALSE); //CMG3G-4847 - To solve Lint
gboolean ecnrStopAudio( tBool bisFromQueue = FALSE); //CMG3G-4847 - To solve Lint
gboolean ecnrDestroy( tBool bisFromQueue = FALSE); //CMG3G-4847 - To solve Lint
gboolean ecnrconfiguration(tU8 u8ConfigID, tBool bisFromQueue = FALSE);
gboolean ecnrMuteSwitch(tBool ecnrSendMuteSwitch);
void register_ecnr_callbacks(_T_CCA_ECNR_If*);
void vProcessPendingRequest(void);
void clearEventBuffer();
#endif
