/*******************************************************************************
 * FILE:           fc_btaudio_AudioRoutingIf.h
 * PROJECT:        NISSAN LCN2kai
 * SW-COMPONENT:   FC_SPI
 *-------------------------------------------------------------------------------
 *
 * DESCRIPTION:    Header file for audio routing interface.
 *
 *-------------------------------------------------------------------------------
 * COPYRIGHT:      (c) 2012 RBEI
 * HISTORY:
 * Date      | Author              | Modification
 * 03.08.12  | Ganesh &Praveen              | initial version(Reference: Phone component)
 *
 *******************************************************************************/

#ifndef _FC_BTAUDIO_AUDIOROUTINGIF_H_
#define _FC_BTAUDIO_AUDIOROUTINGIF_H_

/*******************************************************************************
| includes of component-internal interfaces, if necessary
| (scope: component-local)
|-----------------------------------------------------------------------------*/
// include for audio routing lib
#ifndef ARL_S_IMPORT_INTERFACE_GENERIC
#define ARL_S_IMPORT_INTERFACE_GENERIC

#endif
#include "../FC_Phone_main.h"
#include "audio_routing_lib.h"

#define GSTPLAYER_SUCCESS 0
#define GSTPLAYER_ERROR 1

#define IPODCONTROL_ALSA_DEFAULT "hw:1,0"

#define IPODCONTROL_ALSA_DEFAULT_OUTPUT "setThisValue"

#if __cplusplus < 201103L
#define OVERRIDE  //C++03 or below
#define FINAL
#else
#define OVERRIDE override //C++11 or above
#define FINAL final
#endif

/*******************************************************************************
| class forward declarations
|-----------------------------------------------------------------------------*/


/*******************************************************************************
| class definition
|-----------------------------------------------------------------------------*/
class fc_phone_tclApp;
class PlayerInstance;
class fc_phone_tclService_Telephone;

//class CIntf_DevicePlaybackControl;
class fc_phoneaudio_tclAudioRoutingfi FINAL: public arl_tclISource/*, public fc_btaudio_tclAudioGstOutBase*//*, public CIntf_DevicePlaybackControl*/
{

private:
   //main application pointer
   fc_phone_tclApp* __poMainAppl;
   fc_phone_tclService_Telephone* m_TelService_instance;

   arl_tenSource m_enArlSrc;
   tBool m_bIsSA_Pause;

   //NCG3D-18758. Timer introduced to release the channel in case no response from ARL after 3 secs
   tBool m_bWaitForARLResponseTimerRunning;
   tU16  m_u16AudioChannelIdForRunningTimer;

protected:
   // constructor (use only inside poInstance())
   fc_phoneaudio_tclAudioRoutingfi();
   fc_phoneaudio_tclAudioRoutingfi(fc_phoneaudio_tclAudioRoutingfi & audioRouting);
   fc_phoneaudio_tclAudioRoutingfi& operator=(fc_phoneaudio_tclAudioRoutingfi & audioRouting);

public:


   fc_phoneaudio_tclAudioRoutingfi(fc_phone_tclApp* poMainAppl);
   tVoid vSetTelServiceInstance(fc_phone_tclService_Telephone*& rfpTelServiceInstance);
   // singleton of class
   static fc_phoneaudio_tclAudioRoutingfi * poInstance(tVoid);

   // destructor
   virtual ~fc_phoneaudio_tclAudioRoutingfi();

   // interfaces for audio routing lib requests / answers --- start
   virtual tBool bOnAllocate(arl_tenSource enSrcNum, const arl_tAllocRouteResult& rfcoAllocRoute) OVERRIDE;

   virtual tBool bOnDeAllocate(arl_tenSource enSrcNum) OVERRIDE;

   virtual tBool bOnSrcActivity(arl_tenSource enSrcNum, const arl_tSrcActivity& rfcoSrcActivity) OVERRIDE;

   virtual tBool bOnMuteState(arl_tenSource enSrcNum, arl_tenMuteState enMuteState) OVERRIDE;

   tBool vTriggerPhoneAudioAllocation(tU16 u16AudioChannelId);

   tBool vTriggerPhoneAudioDeAllocation(tU16 u16AudioChannelId);

   tVoid SetSourceAvailable(tBool bSourceAvailable);

   tVoid vSetSourceAvailability(arl_tenSrcAvailability srcAvailability, arl_tenAvailabilityReason availabilityReason, arl_tenSource enSource, tU16 u16SubSource = 0);
   tVoid vPostSrcActivityMRToARL(tBool bPostSuccess = TRUE);
   tVoid vProcessSourceActivity();

#if 0
   tVoid vSendAckAndSrcActivityResult(tBool bSuccess);
#endif

   tString m_szAlsaDeviceName;
   
   //NCG3D-18758. Timer introduced to release the channel in case no response from ARL after 3 secs
   tVoid vTimerCallBack(tU16 u16TimerId);
};


#endif //_FC_BTAUDIO_AUDIOROUTINGIF_H_
