/*
 * FC_Messaging_ServiceNameAccountManager.cpp
 *
 *  Created on: Dec 13, 2011
 *      Author: rakesh
 */

#include "FC_Messaging_ServiceNameAccountManager.h"
#include "../FC_Messaging_main.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_MESSAGING_APPLICATION
#include "trcGenProj/Header/FC_Messaging_ServiceNameAccountManager.cpp.trc.h"
#endif

ServiceNameAccountManager::ServiceNameAccountManager()
{
   ETG_TRACE_USR4(("ServiceNameAccountManager : Called"));
}

ServiceNameAccountManager::~ServiceNameAccountManager()
{
   ETG_TRACE_USR4(("~ServiceNameAccountManager : Called"));

   // Delete the map memory
   QMap<QString, FileSystemManager*>::iterator l_it;
   for (l_it = m_MapServiceNameFileSystemManager.begin(); l_it
   != m_MapServiceNameFileSystemManager.end(); l_it++)
   {
      delete l_it.value();
   }

   m_MapServiceNameFileSystemManager.clear();
}

QString ServiceNameAccountManager::sGetCurrentActiveSMSMMSService()
{
   ETG_TRACE_USR4(("sGetCurrentActiveSMSMMSService : Called"));

   //Bugfix for PSARCC30-1239: avoid multi thread access
   QMutexLocker oLock(&m_oCurrentActiveServiceMutex);
   return m_sCurrentActiveSMSMMSService;
}

QString ServiceNameAccountManager::sGetCurrentActiveEmailService()
{
   ETG_TRACE_USR4(("sGetCurrentActiveEmailService : Called"));

   //Bugfix for PSARCC30-1239: avoid multi thread access
   QMutexLocker oLock(&m_oCurrentActiveServiceMutex);
   return m_sCurrentActiveEmailService;
}

tVoid ServiceNameAccountManager::vSetCurrentActiveService(
        QString f_sSMSMMSService, QString f_sEmailService)
{
   ETG_TRACE_USR4(("vSetCurrentActiveService : Called"));

   //Bugfix for PSARCC30-1239: avoid multi thread access
   QMutexLocker oLock(&m_oCurrentActiveServiceMutex);
   m_sCurrentActiveSMSMMSService = f_sSMSMMSService;
   m_sCurrentActiveEmailService = f_sEmailService;
}

tVoid ServiceNameAccountManager::vCreateFileSystemManager(
        QString f_sServiceName)
{
   ETG_TRACE_USR4(("vCreateFileSystemManager : Called"));

   FileSystemManager* l_poFileSystemManager = new FileSystemManager;
   if (l_poFileSystemManager)
   {
      m_MapServiceNameFileSystemManager.insert(f_sServiceName,
            l_poFileSystemManager);
   }
   tVoid*  pCustodialLose = l_poFileSystemManager ;  //To remove LINT warning : Custodial Pointer
   (tVoid) pCustodialLose ;
}

FileSystemManager* ServiceNameAccountManager::poGetFileSystemManager(QString f_sServiceName)
{
   ETG_TRACE_USR4(("poGetFileSystemManager : Called"));

   QMap<QString, FileSystemManager*>::iterator l_it;

   l_it = m_MapServiceNameFileSystemManager.find(f_sServiceName);
   if (l_it == m_MapServiceNameFileSystemManager.end())
   {
      return NULLPTR;
   }
   else
   {
      return l_it.value();
   }
}
