/*******************************************************************************
 *
 * FILE:        	FC_Messaging_SendMessage.cpp
 *
 * SW-COMPONENT:  FC_Messaging application
 *
 * PROJECT:
 *
 * DESCRIPTION:
 *
 * AUTHOR:		Rakesh Kumar
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

#ifndef __PLACEMENT_NEW_INLINE
#define __PLACEMENT_NEW_INLINE 1
#endif

#include "FC_Messaging_SendMessage.h"
#include "../FC_Messaging_Debug.h"
#include "../DbusClient/FC_Messaging_DbusClientInterface.h"
#include "../FC_Messaging_service_Messaging.h"
#include "../FC_Messaging_main.h"
#include "../DbusClient/FC_Messaging_Macro.h"
#include "../FC_Messaging_clienthandler_Phonebook.h"
#include "../FC_Messaging_phonebook.h"
#include "../FC_Messaging_StateMachine.h"
#include <unistd.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "../MsgList/FC_Messaging_Settings.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_MESSAGING_APPLICATION
#include "trcGenProj/Header/FC_Messaging_SendMessage.cpp.trc.h"
#endif

SendMessage* SendMessage::m_poSendMessageObject = NULLPTR;

/*******************************************************************************
 * FUNCTION:  	createSendMessageObject
 * DESCRIPTION:  function is used to create SendMessage object.
 *
 * PARAMETER:
 *
 * RETURNVALUE: none
 ********************************************************************************/
tVoid SendMessage::vCreateSendMessageObject()
{
   ETG_TRACE_USR4(("vCreateSendMessageObject : Called"));
   if (!m_poSendMessageObject)
   {
      m_poSendMessageObject = new SendMessage;
   }
}

/*******************************************************************************
 * FUNCTION:  	destroySendMessageObject
 * DESCRIPTION:  function is used to destroy SendMessage object.
 *
 * PARAMETER:
 *
 * RETURNVALUE: none
 ********************************************************************************/
tVoid SendMessage::vDestroySendMessageObject()
{
   ETG_TRACE_USR4(("vDestroySendMessageObject : Called"));

   delete m_poSendMessageObject;
   m_poSendMessageObject = NULLPTR;
}

SendMessage* SendMessage::poGetSendMessageInstance()
{
   return m_poSendMessageObject;
}

/*******************************************************************************
 * FUNCTION:  	SendMessage
 * DESCRIPTION:  constructor.
 *
 * PARAMETER:
 *
 * RETURNVALUE: none
 ********************************************************************************/
SendMessage::SendMessage()
{
   m_bSaveMessageInDraft = false;
   ETG_TRACE_USR4(("SendMessage : Called"));
}

/*******************************************************************************
 * FUNCTION:  	~SendMessage
 * DESCRIPTION:  destructor.
 *
 * PARAMETER:
 *
 * RETURNVALUE: none
 ********************************************************************************/
SendMessage::~SendMessage()
{
   ETG_TRACE_USR4(("~SendMessage : Called"));
}

/*******************************************************************************
 * FUNCTION:  	setCreateMessageData
 * DESCRIPTION:  function is used to create message.
 *
 * PARAMETER:
 *
 * RETURNVALUE: true or false
 ********************************************************************************/
tVoid SendMessage::vSetCreateMessageData(
        most_msgfi_tclMsgCreateMessageMethodStart& f_roCreateMessageMethodStart)
{
   ETG_TRACE_USR4(("vSetCreateMessageData : Called"));

   m_oCreateMessageMethodStart = f_roCreateMessageMethodStart;

   //    if (most_fi_tcl_e8_MsgCreateMessageType::FI_EN_E8NEW_MESSAGE
   //            != m_oCreateMessageMethodStart.e8CreateMessageType.enType)
   //    {
   //        QMap<tU32, MessageTypeDbusMessageHandleInfo>::iterator l_it;

   //        l_it
   //                = FileSystemManager::m_DbusMessageHandleAndMostUpperHandleMap.find(
   //                    f_roCreateMessageMethodStart.oMessageHandle.u32MsgHandleUpper);

   //        m_sDbusMessageHandle = l_it.value().m_sDbusMessageHandle;
   //    }
   //    else
   //    {
   //        m_sDbusMessageHandle = "0000"; // New Message
   //    }
}

/*******************************************************************************
 * FUNCTION:  	setProvideMessageHeader
 * DESCRIPTION:  function is used to provide message header.
 *
 * PARAMETER:
 *
 * RETURNVALUE:
 ********************************************************************************/
tVoid SendMessage::vSetProvideMessageHeader(
        most_msgfi_tclMsgProvideMessageHeaderMethodStart& f_roProvideMessageHeaderMethodStart)
{
   ETG_TRACE_USR4(("vSetProvideMessageHeader : Called"));
   tU8 l_u8Index;

   // Need to do
   m_sSentMessageSubject = f_roProvideMessageHeaderMethodStart.sSubject.szValue;

   m_vRecipientInfo.clear();

   for (l_u8Index = 0; l_u8Index
         < f_roProvideMessageHeaderMethodStart.oAddressField.oItems.size(); l_u8Index++)
   {
      if (f_roProvideMessageHeaderMethodStart.oAddressField.oItems.at(
                  l_u8Index).e8AddressFieldType.enType
                != most_fi_tcl_e8_MsgAddressFieldType::FI_EN_E8ADDRESS_FIELD_FROM)
      {
         AddressInfo l_oAddressInfo;

         l_oAddressInfo.m_sEmailAddress
                 = f_roProvideMessageHeaderMethodStart.oAddressField.oItems.at(
                     l_u8Index).sEmailAddress.szValue;
         l_oAddressInfo.m_sPhoneNumber
                 = f_roProvideMessageHeaderMethodStart.oAddressField.oItems.at(
                     l_u8Index).sPhoneNumber.szValue;
         l_oAddressInfo.m_sLastName
                 = f_roProvideMessageHeaderMethodStart.oAddressField.oItems.at(
                     l_u8Index).sLastName.szValue;
         l_oAddressInfo.m_sFirstName
                 = f_roProvideMessageHeaderMethodStart.oAddressField.oItems.at(
                     l_u8Index).sFirstName.szValue;

         if (l_oAddressInfo.m_sFirstName.size() == 0)
         {
            l_oAddressInfo.m_sFirstName = BLANK;
         }
         if (l_oAddressInfo.m_sLastName.size() == 0)
         {
            l_oAddressInfo.m_sLastName = BLANK;
         }

         m_vRecipientInfo.push_back(l_oAddressInfo);
      }
      else
      {
         m_oSenderInfo.m_sEmailAddress
                 = f_roProvideMessageHeaderMethodStart.oAddressField.oItems.at(
                     l_u8Index).sEmailAddress.szValue;
         m_oSenderInfo.m_sPhoneNumber
                 = f_roProvideMessageHeaderMethodStart.oAddressField.oItems.at(
                     l_u8Index).sPhoneNumber.szValue;
         m_oSenderInfo.m_sLastName
                 = f_roProvideMessageHeaderMethodStart.oAddressField.oItems.at(
                     l_u8Index).sLastName.szValue;
         m_oSenderInfo.m_sFirstName
                 = f_roProvideMessageHeaderMethodStart.oAddressField.oItems.at(
                     l_u8Index).sFirstName.szValue;
      }
   }
}

/*******************************************************************************
 * FUNCTION:  	setProvideMessageBody
 * DESCRIPTION:  function is used to provide message body.
 *
 * PARAMETER:
 *
 * RETURNVALUE: true or false
 ********************************************************************************/
tVoid SendMessage::vSetProvideMessageBody(
        most_msgfi_tclMsgProvideMessageBodyMethodStart& f_roProvideMessageBodyMethodStart)
{
   ETG_TRACE_USR4(("vSetProvideMessageBody : Called"));
   tU32 l_u32Index;

   m_sSentMessageData.clear();

   if (m_oCreateMessageMethodStart.e8MessageType.enType
           == most_fi_tcl_e8_MsgMessageType::FI_EN_E8MSG_TYPE_EMAIL)
   {
       m_sSentMessageData = m_sSentMessageSubject + SUBJECT_TERMINATOR;
   }

   for (l_u32Index = 0; l_u32Index
        < f_roProvideMessageBodyMethodStart.oMessageBodyText.sItems.size(); l_u32Index++)
   {
      m_sSentMessageData
              += f_roProvideMessageBodyMethodStart.oMessageBodyText.sItems.at(
                  l_u32Index).szValue;
   }
}

/*******************************************************************************
 * FUNCTION:  	sendMessage
 * DESCRIPTION:  function is used to send message.
 *
 * PARAMETER:
 *
 * RETURNVALUE: true or false
 ********************************************************************************/
tVoid SendMessage::vSendMessage(
        most_msgfi_tclMsgSendMessageMethodStart& f_roSendMessageMethodStart)
{
   ETG_TRACE_USR4(("vSendMessage : Called"));

   m_oSendMessageMethodStart = f_roSendMessageMethodStart;

   m_bSaveMessageInDraft = false;

   if(f_roSendMessageMethodStart.e8FolderType.enType ==
           most_fi_tcl_e8_MsgFolderType::FI_EN_E8MSG_FOLDER_DRAFTS)
   {
      m_bSaveMessageInDraft = true;
   }

   bSendMessageMapUpload();
}

/*******************************************************************************
 * FUNCTION:  	sendMessageMapUpload
 * DESCRIPTION:  function is used to upload message parameters.
 *
 * PARAMETER:
 *
 * RETURNVALUE: true or false
 ********************************************************************************/
tBool SendMessage::bSendMessageMapUpload()
{
   ETG_TRACE_USR4(("bSendMessageMapUpload : Called"));

   tBool retVal = false;
   retVal = DbusClientInterface::getInstance().messagingMapUpload(m_oCreateMessageMethodStart.oMessageHandle.u8DeviceHandle, this);
   if (false == retVal)
   {
      vSendMessageReturn(m_oCreateMessageMethodStart.oMessageHandle.u8DeviceHandle, 0, 0, FAILURE);
   }
   return retVal;
}

/*******************************************************************************
 * FUNCTION:  	sendMessageMapUploadData
 * DESCRIPTION:  function is used to upload message data.
 *
 * PARAMETER:
 *
 * RETURNVALUE: none
 ********************************************************************************/
tVoid SendMessage::vSendMessageMapUploadData()
{
   ETG_TRACE_USR4(("vSendMessageMapUploadData : Called"));

   DbusClientInterface::getInstance().messagingMapUploadData(m_oCreateMessageMethodStart.oMessageHandle.u8DeviceHandle, this);
}

/*******************************************************************************
 * FUNCTION:  	sendTextData
 * DESCRIPTION:  function is used to send text data to dbus.
 *
 * PARAMETER:
 *
 * RETURNVALUE: none
 ********************************************************************************/
tVoid SendMessage::vSendTextData()
{
   ETG_TRACE_USR4(("vSendTextData: Called"));
    
   vSendMessageMapUploadData();
}

/*******************************************************************************
 * FUNCTION:  	sendMessageReturn
 * DESCRIPTION:  function is used to send result to HMI.
 *
 * PARAMETER:
 *
 * RETURNVALUE: none
 ********************************************************************************/
tVoid SendMessage::vSendMessageReturn(tU8 u8DeviceHandle,
                                      tU32 u32MessageHandleUpper, tU32 u32MessageHandleLower, tU8 u8Status)
{
   ETG_TRACE_USR4(("vSendMessageReturn : Called DeviceHandle = %d,MessageHandleUpper = %d, MessageHandleLower  = %d, u8Status = %d",u8DeviceHandle, u32MessageHandleUpper,  u32MessageHandleLower, u8Status));

   most_msgfi_tclMsgSendMessageMethodResult l_oSendMessageMethodResult_MR;

   if (!m_poSendMessageObject)
   {
      return;
   }

   l_oSendMessageMethodResult_MR.oMessageHandle.u8DeviceHandle
           = u8DeviceHandle;
   l_oSendMessageMethodResult_MR.oMessageHandle.u32MsgHandleUpper
           = u32MessageHandleUpper;
   l_oSendMessageMethodResult_MR.oMessageHandle.u32MsgHandleLower
           = u32MessageHandleLower;

   if (u8Status == SUCCESS)
   {
      ETG_TRACE_USR3(("Message Delivered"));

      l_oSendMessageMethodResult_MR.e8SentMessageStatus.enType
              = most_fi_tcl_e8_MsgSentMessageStatus::FI_EN_E8MSG_SENT_STATUS_SUCCESS;
   }
   else
   {
      ETG_TRACE_USR3(("Message not Delivered"));

      l_oSendMessageMethodResult_MR.e8SentMessageStatus.enType
              = most_fi_tcl_e8_MsgSentMessageStatus::FI_EN_E8MSG_SENT_STATUS_ERROR;
   }

   fc_messaging_tclService_Messaging::m_poMessagingService->vHandle_SendMessage_Return(
               l_oSendMessageMethodResult_MR);
}

tVoid SendMessage::vRecentlySentMessageInfo(tU8 f_u8DeviceHandle,
                                            QString f_sServiceName, MsgListing_t* f_poMessageList) // DeviceHandle
{
   ETG_TRACE_USR4(("vRecentlySentMessageInfo : Called DeviceHandle = %d", f_u8DeviceHandle));

   most_fi_tcl_MsgMessageHandle l_oMessageHandle;

   l_oMessageHandle.u8DeviceHandle = f_u8DeviceHandle;

   //Bugfix for GMMY15-6773 View is always in sending status when reply a text message
   if (f_poMessageList)
   {
      FileSystemManager* l_poFileSystemManager
      = DbusClientInterface::getInstance().getFileSystemManager(f_u8DeviceHandle, f_sServiceName);

      if (l_poFileSystemManager)
      {
         QString l_sFolderName;

         if (m_bSaveMessageInDraft == true)
         {
            ETG_TRACE_USR4(("Inserting info into draft folder"));
            l_sFolderName = MSG_DBUS_FOLDER_TYPE_DRAFT;
         }
         else
         {
            ETG_TRACE_USR4(("Inserting info into sent folder"));
            l_sFolderName = MSG_DBUS_FOLDER_TYPE_SENT;
         }

         FolderNode* l_poConvFolderNode = l_poFileSystemManager->poSearchNodeByFolderName(MSG_DBUS_FOLDER_TYPE_CONVERSATION);
         tU8 u8ConvListSize = 0;

         if(l_poConvFolderNode && l_poConvFolderNode->m_pvConversationList)
         {
            //Get the conversation list size to update the MessageListChange accordingly
            u8ConvListSize = static_cast<tU8>(l_poConvFolderNode->m_pvConversationList->size());
         }

         l_poFileSystemManager->vSetCreateMessageListInProgressFolderName(l_sFolderName);

         l_oMessageHandle.u32MsgHandleUpper = l_poFileSystemManager->u32AddMessageInList(f_u8DeviceHandle, f_poMessageList);
         l_poFileSystemManager->vSortMessageList();

         FolderNode* l_poFolderNode = l_poFileSystemManager->poSearchNodeByFolderName(l_sFolderName);

         if (l_poFolderNode)
         {
            l_oMessageHandle.u32MsgHandleLower  = l_poFolderNode->m_u32ListHandle;

            // CMG3G-7699 - IS2202_message send notification (network level)@FC_Messaging
            tU8 u8MessgeType = f_poMessageList->u8GetMessageType();
            tU8 u8MessgeNotifyType = f_poMessageList->u8GetNotifyType();
            l_poFileSystemManager->vMessageNotify(l_oMessageHandle, u8MessgeType, u8MessgeNotifyType);
            l_poFileSystemManager->vMessageListChangeNotify((tU16) l_poFolderNode->m_u32ListHandle,
                  static_cast<unsigned int>(l_poFolderNode->m_pvMessageList->size()),
                  most_fi_tcl_e8_MsgListChangeType::FI_EN_E8LCH_ITEMS_ADDED, 0); // will be zero :)
         }

         if(l_poConvFolderNode && l_poConvFolderNode->m_pvConversationList)
         {
            if(l_poConvFolderNode->m_pvConversationList->size() > u8ConvListSize)
            {
               l_poFileSystemManager->vMessageListChangeNotify((tU16) l_poConvFolderNode->m_u32ListHandle,
                     static_cast<unsigned int>(l_poConvFolderNode->m_pvConversationList->size()),
                     most_fi_tcl_e8_MsgListChangeType::FI_EN_E8LCH_ITEMS_ADDED, 0); // will be zero :)
            }
            //ITEMS_CHANGED will be sent after message read from the device
            //else
            //{
            //   l_poFileSystemManager->vMessageListChangeNotify((tU16) l_poConvFolderNode->m_u32ListHandle,
            //         static_cast<unsigned int>(l_poConvFolderNode->m_pvConversationList->size()),
            //         most_fi_tcl_e8_MsgListChangeType::FI_EN_E8LCH_ITEMS_CHANGED, 0); // will be zero :)
            //}
         }

         if (FALSE == f_poMessageList->sGetRecipientAddress().isEmpty())
         {
            ETG_TRACE_USR4(("vRecentlySentMessageInfo Recipient Address exists"));

            QString sRecipientAddress = QString::fromUtf8(f_poMessageList->sGetRecipientAddress().constData());

            ETG_TRACE_USR4(("Lookup RecipientAddress : %s in PhonebookMap", sRecipientAddress.toUtf8().constData()));

            if(Phonebook_Detail::pGetPhonebookInstance(f_u8DeviceHandle))
            {
               Phonebook_Detail::pGetPhonebookInstance(f_u8DeviceHandle)->vSearchPhonebookMap(sRecipientAddress, e8NewSendMsg, f_u8DeviceHandle);
            }
         }

#ifdef CONVERSATION_MESSAGES_SUPPORT
         if(MessagingMutex::messagingMutexTrylock(NULLPTR) == 0)
         {
            l_poFileSystemManager->vGetMessagesForConversation();
         }
#endif
      }
   }
}

tU8 SendMessage::vGetDeviceHandle()
{
   return m_oCreateMessageMethodStart.oMessageHandle.u8DeviceHandle;
}
