/*******************************************************************************
 *
 * FILE:        	FC_Messaging_ReadMessageAloud.h
 *
 * SW-COMPONENT:  FC_Messaging application
 *
 * PROJECT:
 *
 * DESCRIPTION:
 *
 * AUTHOR:		Sandeep Arjun
 *
 * COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

#ifndef _FC_MESSAGING_READMESSAGEALOUD_H_
#define _FC_MESSAGING_READMESSAGEALOUD_H_

#define FC_MESSAGING_S_IMPORT_INTERFACE_MSG
#include "../../FC_Messaging_if.h"

#define MOST_FI_S_IMPORT_INTERFACE_MOST_TTSFI_TYPES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_TTSFI_FUNCTIONIDS
#define MOST_FI_S_IMPORT_INTERFACE_MOST_TTSFI_ERRORCODES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_TTSFI_SERVICEINFO

#include "conn_most_fi_if.h"

// include for audio routing lib
#ifndef ARL_S_IMPORT_INTERFACE_GENERIC
#define ARL_S_IMPORT_INTERFACE_GENERIC
#include "audio_routing_lib.h"
#endif

#include "../../DbusClient/FC_Messaging_Datatype.h"
#include "../../DbusClient/FC_Messaging_DbusClient_MsgRead.h"
#include "../../FileSystemManager/FC_Messaging_FileSystem.h"


/* Define the events that the machine can take */
#define FC_MESSAGING_SM_EVENT_SOURCEACTIVITY_RESPONSE            1
#define FC_MESSAGING_SM_EVENT_PREPAREVOICEOUTPUT_RESPONSE        2
#define FC_MESSAGING_SM_EVENT_SYNTHESIZESPEAK_RESPONSE           3
#define FC_MESSAGING_SM_EVENT_ABORTPROMPT_RESPONSE               4
#define FC_MESSAGING_SM_EVENT_GETMESSAGE_SUCCESS                 5
#define FC_MESSAGING_SM_EVENT_GETMESSAGE_FAILURE                 6
#define FC_MESSAGING_SM_EVENT_AUDIOROUTE_TIMER_EXPIRED           7

typedef enum FC_Msg_ReadAloudStatus
{
   FC_MSG_READALOUDSTATE_IDLE,
   FC_MSG_GET_MSG_IN_PROGRESS,
   FC_MSG_CHANNEL_ACQUISITION_IN_PROGRESS,
   FC_MSG_READALOUD_IN_PROGRESS,
   FC_MSG_ABORT_IN_PROGRESS,
   FC_MSG_CHANNEL_RELEASE_IN_PROGRESS
} tenFC_Msg_ReadAloudStatus;

typedef enum FC_Msg_ReadAloudSubStatus
{
   FC_MSG_READALOUDSUBSTATE_IDLE,
   FC_MSG_PREPARE_IN_PROGRESS,
   FC_MSG_SYNTHESIS_IN_PROGRESS,
   FC_MSG_STOP_IN_WAIT,
   FC_MSG_STOP_IN_PROGRESS,
   FC_MSG_CHANNEL_ALREADY_ACQUIRED
} tenFC_Msg_ReadAloudSubStatus;

typedef enum SynthesizeSpeakResult
{
   FC_MSG_SYNTHESIZESPEAKRESULT_FIRST,
   FC_MSG_SYNTHESIZESPEAKRESULT_MIDDLE,
   FC_MSG_SYNTHESIZESPEAKRESULT_LAST,
   FC_MSG_SYNTHESIZESPEAKRESULT_ERROR
} tenSynthesizeSpeakResult;

typedef struct
{
   tenSynthesizeSpeakResult enSynthesizeSpeakResult;
   tBool bSuccess;
   arl_tenSource enArlSrcNum;
   arl_tenActivity enArlSrcActivity;
} trFC_Msg_ProcessEventArg;

class ReadMessageAloud
{

public:

   static ReadMessageAloud* poGetInstance();
   static tVoid vDestroyReadMessageAloudObject();

   tVoid vGetMessageForReadAloud(most_msgfi_tclMsgReadMessageAloudMethodStart& roMsgReadMessageAloudMethodStart);
   tVoid vGetMessageForReadAloudReturn(MsgRead_t* poMsgRead, FolderNode* poFolderNode);
   tVoid vStopReadAloud(e8ReadMessageAloudCaller readMessageAloudCaller = e8ReadMessageAloudMethod);
   tVoid vReadAloudContentFromClient(tString sReadAloudContent);
   void vHandleReadMessageAloudOnDeviceDisconnection(uint8_t deviceHandle);
   tVoid vProcessEvent(tU16 u16EventId, tVoid *varg = NULLPTR);

private:

   static ReadMessageAloud* s_poReadMessageAloudObject;

   tBool m_bNewReadRequestWaiting;
   tBool m_bAudioSrcChangedByArl;
   tBool m_bAudioRouteTimerRunning;
   e8ReadMessageAloudCaller m_e8ReadMessageAloudCaller;

   tenFC_Msg_ReadAloudStatus m_enReadAloudStatus;
   tenFC_Msg_ReadAloudSubStatus m_enReadAloudSubStatus;

   most_fi_tcl_String m_sText;
   most_fi_tcl_String m_sNewRequestMessageText;
   most_fi_tcl_MsgMessageHandle m_oCurrentMessageHandle;
   most_fi_tcl_MsgMessageHandle m_oNewRequestMessageHandle;

   QList<most_fi_tcl_MsgMessageHandle> m_aoReadAloudMessageHandle;

   ReadMessageAloud();
   ~ReadMessageAloud();

   tVoid vAudioRouteRequest();
   tVoid vHandleAudioRouted();

   tVoid vAudioReleaseRequest();
   tVoid vHandleAudioReleased();

   tVoid vPrepareVoiceOutput();
   tVoid vPrepareVoiceOutputAck(tBool bSuccess);

   tVoid vSynthesizeSpeakAck(tenSynthesizeSpeakResult enSynthesizeSpeakResult);

   tVoid vAbortPromptAck(tBool bSuccess);

   tVoid vHandleEventInIdle(tU16 u16EventId, tVoid *varg);
   tVoid vHandleEventInGetMsgInProgress(tU16 u16EventId, tVoid *varg);
   tVoid vHandleEventInChannelAcquisitionInProgress(tU16 u16EventId, tVoid *varg);
   tVoid vHandleEventInReadAloudInProgress(tU16 u16EventId, tVoid *varg);
   tVoid vHandleEventInAbortInProgress(tU16 u16EventId, tVoid *varg);
   tVoid vHandleEventInChannelReleaseInProgress(tU16 u16EventId, tVoid *varg);

   tVoid vHandleWaitingReadRequest();
   tVoid vHandleSourceChangeDuringReadAloud();
   tVoid vAudioTimerExpired();
   tVoid vUpdateStatesAndReleaseAudio();
   tVoid vSendMessageListChangeUpdate(most_fi_tcl_MsgMessageHandle oMessageHandle, most_fi_tcl_e8_MsgPlaybackState::tenType enPlayState);
   tVoid vUpdateReadAloudMessageList(most_fi_tcl_MsgMessageHandle oMessageHandle);
   tVoid vHandleWaitingRequestsOnError();
   tVoid vSendReadMessageAloudResult(most_fi_tcl_e8_MsgPlaybackAction::tenType enPlaybackAction);
   tVoid vSendReadMessageAloudError();
   //tVoid vHandleEventInChannelAcquired(tU16 u16EventId, tVoid *varg);
};
#endif /* _FC_MESSAGING_READMESSAGEALOUD_H_ */
