#include "../Database/FC_Messaging_SQLite.h"
#include "FC_Messaging_Settings.h"
#include "../FC_Messaging_main.h"
#include "../FC_Messaging_clienthandler_BluetoothSetings.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_MESSAGING_APPLICATION
#include "trcGenProj/Header/FC_Messaging_Settings.cpp.trc.h"
#endif

Settings::Settings()
{
   ETG_TRACE_USR4(("Settings()"));

   m_u32UpdateInboxTime = FC_MSG_AUTO_UPDATE_INBOX_PERIOD;
   m_u8MsgLang = FC_MSG_DEFAULT_MSG_LANG;
   m_bAutoUpdateInbox = false;
   m_poPredefinedMessageList = NULLPTR; //Fix for CMG3G-5833
   m_poFC_Messaging_SQLite = NULLPTR;
   m_u16AutoReplyText = FC_MSG_DEFAULT_AUTO_REPLY_TEXT;
}

Settings::~Settings()
{
   ETG_TRACE_USR4(("~Settings()"));

   if (m_poPredefinedMessageList)
   {
      OSAL_DELETE m_poPredefinedMessageList;
      m_poPredefinedMessageList = NULLPTR;
   }

   if (m_poFC_Messaging_SQLite)
   {
      OSAL_DELETE m_poFC_Messaging_SQLite;
      m_poFC_Messaging_SQLite = NULLPTR;
   }
}

FC_Messaging_PredefinedMsgList* Settings::poGetPredefinedMessageListInstance()
{
   ETG_TRACE_USR4(("poGetPredefinedMessageListInstance Called"));
   if (!m_poPredefinedMessageList)
   {
      m_poPredefinedMessageList = new FC_Messaging_PredefinedMsgList();
      m_poFC_Messaging_SQLite = m_poPredefinedMessageList;

   }
   return m_poPredefinedMessageList;
}

tBool Settings::bSetUpdateInboxTime(tU32 f_u32Time, tBool f_boolautoUpdate)
{
   ETG_TRACE_USR4(("bSetUpdateInboxTime Called"));

   if (m_poFC_Messaging_SQLite)
   {
      return m_poFC_Messaging_SQLite->bQueryUpdateInboxSetting(f_u32Time, f_boolautoUpdate);
   }
   return FALSE;
}

tU32 Settings::u32GetUpdateInboxTime()
{
   ETG_TRACE_USR4(("u32GetUpdateInboxTime Called"));

   if (m_poFC_Messaging_SQLite)
   {
      m_u32UpdateInboxTime = m_poFC_Messaging_SQLite->szQueryGetUpdateInboxPeriod();
   }
   return m_u32UpdateInboxTime;
}

tBool Settings::bSetMessagingLanguage(tU8 f_MsgLang)
{
   ETG_TRACE_USR4(("bSetMessagingLanguage Called"));
   if (m_poFC_Messaging_SQLite)
   {
      return m_poFC_Messaging_SQLite->bQueryUpdateMessagingLanguage(f_MsgLang);
   }
   return FALSE;
}

tU8 Settings::u8GetMessagingLanguage()
{
   ETG_TRACE_USR4(("u8GetMessagingLanguage Called"));
   if (m_poFC_Messaging_SQLite)
   {
      m_u8MsgLang = static_cast<tU8>(m_poFC_Messaging_SQLite->szQueryGetMessagingLanguage());
   }
   return m_u8MsgLang;
}

tU16 Settings::u16GetAutoReplyText(tU8 u8DeviceHandle)
{
   ETG_TRACE_USR4(("u16GetAutoReplyText() called"));

   if (m_poFC_Messaging_SQLite)
   {
      m_u16AutoReplyText = static_cast<tU16>(m_poFC_Messaging_SQLite->szQueryGetAutoReplyText(u8DeviceHandle));
   }

   return m_u16AutoReplyText;
}

tBool Settings::bSetAutoReplyText(tU8 u8DeviceHandle, tU16 u16AutoReplyText)
{
   ETG_TRACE_USR4(("bSetAutoReplyText() called"));

   tBool bRetValue = FALSE;
   if (m_poFC_Messaging_SQLite)
   {
      bRetValue = m_poFC_Messaging_SQLite->bQueryUpdateAutoReplyText(u8DeviceHandle, u16AutoReplyText);
   }

   return bRetValue;
}

tBool Settings::bSetDeviceSpecificSetting(tU8 u8DeviceHandle, DeviceSettings enDeviceSpecificSetting, tBool bOnOffState)
{
   ETG_TRACE_USR4(("bSetDeviceSpecificSetting() called"));
   ETG_TRACE_USR4(("DevHandle: %d, enDeviceSpecificSetting: %d, bOnOffState: %d ", u8DeviceHandle, enDeviceSpecificSetting, bOnOffState));

   tBool bRetValue = FALSE;
   if (m_poFC_Messaging_SQLite)
   {
      bRetValue = m_poFC_Messaging_SQLite->bQueryUpdateDeviceSettings(u8DeviceHandle, enDeviceSpecificSetting, bOnOffState);
   }

   return bRetValue;
}

tBool Settings::bGetDeviceSpecificSetting(tU8 u8DeviceHandle, DeviceSettings enDeviceSpecificSetting)
{
   ETG_TRACE_USR4(("bGetDeviceSpecificSetting() called"));
   ETG_TRACE_USR4(("DevHandle: %d, enDeviceSpecificSetting: %d", u8DeviceHandle, enDeviceSpecificSetting));

   tBool bRetValue = FALSE;
   if (m_poFC_Messaging_SQLite)
   {
      bRetValue = m_poFC_Messaging_SQLite->szQueryGetDeviceSettings(u8DeviceHandle, enDeviceSpecificSetting);
   }

   return bRetValue;
}

tBool EmailSettings::bSetEmailAlertSetting(tBool f_bSetting)
{
   ETG_TRACE_USR4(("bSetEmailAlertSetting Called"));

   if (m_poFC_Messaging_SQLite)
   {
      return m_poFC_Messaging_SQLite->bQueryUpdateSystemWideSettings(EMAIL_ALERT_SETTING, f_bSetting);
   }

   return FALSE;
}

tBool EmailSettings::bGetEmailAlertSetting()
{
   ETG_TRACE_USR4(("bGetEmailAlertSetting Called"));

   if (m_poFC_Messaging_SQLite)
   {
      m_bEmailAlert = m_poFC_Messaging_SQLite->szQueryGetSystemWideSettings(EMAIL_ALERT_SETTING);
   }
   return m_bEmailAlert;
}

tBool EmailSettings::bSetSaveSentEmailSetting(tBool f_bSetting)
{
   ETG_TRACE_USR4(("bSetSaveSentEmailSetting Called"));

   if (m_poFC_Messaging_SQLite)
   {
      return m_poFC_Messaging_SQLite->bQueryUpdateSystemWideSettings(SAVE_SENT_EMAIL_SETTING, static_cast<bool>(f_bSetting));
   }
   return FALSE;
}

tBool EmailSettings::bGetSaveSentEmailSetting()
{
   ETG_TRACE_USR4(("bGetSaveSentEmailSetting Called"));

   if (m_poFC_Messaging_SQLite)
   {
      m_bSaveSentEmail = m_poFC_Messaging_SQLite->szQueryGetSystemWideSettings(SAVE_SENT_EMAIL_SETTING);
   }
   return m_bSaveSentEmail;
}

EmailSettings::EmailSettings()
{
   m_bEmailAlert = false;
   m_bSaveSentEmail = false;
}

EmailSettings::~EmailSettings()
{

}

tBool TextSettings::bSetTextAlertSetting(tBool f_bSetting)
{
   ETG_TRACE_USR4(("bSetTextAlertSetting Called"));

   if (m_poFC_Messaging_SQLite)
   {
      return m_poFC_Messaging_SQLite->bQueryUpdateSystemWideSettings(TEXT_ALERT_SETTING, static_cast<bool>(f_bSetting));
   }
   return FALSE;
}

tBool TextSettings::bGetTextAlertSetting()
{
   ETG_TRACE_USR4(("bGetTextAlertSetting Called"));

   if (m_poFC_Messaging_SQLite)
   {
      m_bTextAlert = m_poFC_Messaging_SQLite->szQueryGetSystemWideSettings(TEXT_ALERT_SETTING);
   }
   return m_bTextAlert;
}

tVoid TextSettings::vRestoreTextAlertSettingDefault()
{
	/* Bug-Fix for GMMY15-1593 - Unable to return Text Alert to factory settings*/
   bSetTextAlertSetting(true); // default is true
}

tBool TextSettings::bSetSaveSentTextSetting(tBool f_bSetting)
{
	ETG_TRACE_USR4(("bSetSaveSentTextSetting Called"));

    if (m_poFC_Messaging_SQLite)
    {
        return m_poFC_Messaging_SQLite->bQueryUpdateSystemWideSettings (SAVE_SENT_TEXT_SETTING, static_cast<bool>(f_bSetting));
    }
    return FALSE;
}

tBool TextSettings::bGetSaveSentTextSetting()
{
	ETG_TRACE_USR4(("bGetSaveSentTextSetting Called"));

    if (m_poFC_Messaging_SQLite)
    {
        m_bSaveSentText = m_poFC_Messaging_SQLite->szQueryGetSystemWideSettings(
                                                SAVE_SENT_TEXT_SETTING);
    }

    return m_bSaveSentText;
}

tVoid TextSettings::vRestoreSaveSentTextSettingDefault()
{
   bSetSaveSentTextSetting(false);
}

tVoid TextSettings::vRestoreTextSettingToDefault()
{
   ETG_TRACE_USR4(("vRestoreTextSettingToDefault Called"));

   vRestoreTextAlertSettingDefault();
   //Other feature like RestoreSaveSentTextSetting is currently not supported
}

TextSettings::TextSettings()
{
   m_bTextAlert = false;
   m_bSaveSentText = false;
}

TextSettings::~TextSettings()
{

}

MessagingSettings* MessagingSettings::m_poMessagingSettings = NULLPTR;

MessagingSettings* MessagingSettings::poGetMessagingSettingsInstance()
{
   ETG_TRACE_USR4(("poGetMessagingSettingsInstance Called"));

   // Bugfix for GMMY16-7867
   if (!m_poMessagingSettings)
   {
      m_poMessagingSettings = new MessagingSettings;
   }
   return m_poMessagingSettings;
}

tVoid MessagingSettings::vDeleteMessagingSettingsInstance()
{
   ETG_TRACE_USR4(("vDeleteMessagingSettingsInstance Called"));

   delete m_poMessagingSettings;
   m_poMessagingSettings = NULLPTR;
}

MessagingSettings::MessagingSettings()
{

}

MessagingSettings::~MessagingSettings()
{

}
