
/*
 * Wrapper for the communication to the external components
 */

#ifndef _FC_MESSAGING_GENERICWRAPPER_H_
#define _FC_MESSAGING_GENERICWRAPPER_H_

#ifndef FC_MESSAGING_S_IMPORT_INTERFACE_MSG
#define FC_MESSAGING_S_IMPORT_INTERFACE_MSG
#include "../FC_Messaging_if.h"
#endif

// include for audio routing lib
#ifndef ARL_S_IMPORT_INTERFACE_GENERIC
#define ARL_S_IMPORT_INTERFACE_GENERIC
#include "audio_routing_lib.h"
#endif

#include "../ReadMessageAloud/Gen3/FC_Messaging_ReadMessageAloud.h"
#include "../DbusClient/FC_Messaging_Macro.h"
class fc_messaging_tclApp;

class fc_messaging_tclGenericWrapper
{
public:

   fc_messaging_tclGenericWrapper(fc_messaging_tclApp* poMainAppl);

   ~fc_messaging_tclGenericWrapper();

   tBool bRequestAVActivation(arl_tenSource enSrcNum);

   tBool bRequestAVDeActivation(arl_tenSource enSrcNum);

   tBool bPrepareVoiceOutput();

   tBool bSynthesizeSpeak(most_fi_tcl_String sText);

   tBool bAbortPrompt();

   tVoid vOnSourceActivity(arl_tenSource enArlSrcNum, arl_tenActivity enArlSrcActivity);

   tVoid vHandle_PrepareVoiceOutput_Reponse(tBool bSuccess);

   tVoid vHandle_SynthesizeSpeak_Reponse(tenSynthesizeSpeakResult enSynthesizeSpeakResult);

   tVoid vHandle_AbortPrompt_Response(tBool bSuccess);

private:

   fc_messaging_tclApp *m_poMainApp;
};

#endif //_FC_MESSAGING_GENERICWRAPPER_H_

