/*******************************************************************************
 *
 * FILE:          GenericWrapper.cpp
 *
 * SW-COMPONENT:  FC_Messaging application
 *
 * PROJECT:
 *
 * DESCRIPTION:   Wrapper for CCA communication
 *
 * AUTHOR:
 *
 * COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

/*******************************************************************************
 | includes:
 | 1) system- and project-includes
 | 2) needed interfaces from external components
 | 3) internal and external interfaces from this component
 |-----------------------------------------------------------------------------*/

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif

#include "../Audio/FC_Messaging_AudioRouteHandler.h"
#include "../FC_Messaging_clienthandler_SDS.h"
//#include "arl_ISourceTypes.h"

#include "../FC_Messaging_main.h"
#include "FC_Messaging_GenericWrapper.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_MESSAGING_APPLICATION
#include "trcGenProj/Header/FC_Messaging_GenericWrapper.cpp.trc.h"
#endif

fc_messaging_tclGenericWrapper::fc_messaging_tclGenericWrapper(fc_messaging_tclApp* poMainAppl)
{
   m_poMainApp = poMainAppl;
}

fc_messaging_tclGenericWrapper::~fc_messaging_tclGenericWrapper()
{
   m_poMainApp = NULLPTR;
}

tBool fc_messaging_tclGenericWrapper::bRequestAVActivation(arl_tenSource enSrcNum)
{
   return m_poMainApp->poGetAudioRouteHandler()->bAudioRouteRequest(enSrcNum);
}

tBool fc_messaging_tclGenericWrapper::bRequestAVDeActivation(arl_tenSource enSrcNum)
{
   return m_poMainApp->poGetAudioRouteHandler()->bAudioReleaseRequest(enSrcNum);
}

tVoid fc_messaging_tclGenericWrapper::vOnSourceActivity(arl_tenSource enArlSrcNum, arl_tenActivity enArlSrcActivity)
{
   ReadMessageAloud* poReadMessageAloud = ReadMessageAloud::poGetInstance();

   if (poReadMessageAloud)
   {
      trFC_Msg_ProcessEventArg rProcessEventArg;
      rProcessEventArg.enArlSrcNum = enArlSrcNum;
      rProcessEventArg.enArlSrcActivity = enArlSrcActivity;
      poReadMessageAloud->vProcessEvent(FC_MESSAGING_SM_EVENT_SOURCEACTIVITY_RESPONSE, &rProcessEventArg);
   }
}

tBool fc_messaging_tclGenericWrapper::bPrepareVoiceOutput()
{
   return m_poMainApp->poGetClientHandler_SDS()->bPrepareVoiceOutput_MethodStart();
}

tBool fc_messaging_tclGenericWrapper::bSynthesizeSpeak(most_fi_tcl_String sText)
{
   return m_poMainApp->poGetClientHandler_SDS()->bSynthesizeSpeak_MethodStart(sText);
}

tBool fc_messaging_tclGenericWrapper::bAbortPrompt()
{
   return m_poMainApp->poGetClientHandler_SDS()->bAbortPrompt_MethodStart();
}

//Handle Abort error

tVoid fc_messaging_tclGenericWrapper::vHandle_PrepareVoiceOutput_Reponse(tBool bSuccess)
{
   ReadMessageAloud* poReadMessageAloud = ReadMessageAloud::poGetInstance();

   if (poReadMessageAloud)
   {
      trFC_Msg_ProcessEventArg rProcessEventArg;
      rProcessEventArg.bSuccess = bSuccess;
      poReadMessageAloud->vProcessEvent(FC_MESSAGING_SM_EVENT_PREPAREVOICEOUTPUT_RESPONSE, &rProcessEventArg);
   }
}

tVoid fc_messaging_tclGenericWrapper::vHandle_SynthesizeSpeak_Reponse(tenSynthesizeSpeakResult enSynthesizeSpeakResult)
{
   ReadMessageAloud* poReadMessageAloud = ReadMessageAloud::poGetInstance();

   if (poReadMessageAloud)
   {
      trFC_Msg_ProcessEventArg rProcessEventArg;
      rProcessEventArg.enSynthesizeSpeakResult = enSynthesizeSpeakResult;
      poReadMessageAloud->vProcessEvent(FC_MESSAGING_SM_EVENT_SYNTHESIZESPEAK_RESPONSE, &rProcessEventArg);
   }
}

tVoid fc_messaging_tclGenericWrapper::vHandle_AbortPrompt_Response(tBool bSuccess)
{

   ReadMessageAloud* poReadMessageAloud = ReadMessageAloud::poGetInstance();

   if (poReadMessageAloud)
   {
      trFC_Msg_ProcessEventArg rProcessEventArg;
      rProcessEventArg.bSuccess = bSuccess;
      poReadMessageAloud->vProcessEvent(FC_MESSAGING_SM_EVENT_ABORTPROMPT_RESPONSE, &rProcessEventArg);
   }
}
