/*
 * FC_Messaging_FileSystem.h
 *
 *  Created on: Dec 13, 2011
 *      Author: rakesh
 */

#ifndef FC_MESSAGING_FILESYSTEM_H_
#define FC_MESSAGING_FILESYSTEM_H_

#include "../DbusClient/FC_Messaging_Macro.h"
#include "../FC_Messaging_Debug.h"
#include <QString>

#define FC_MESSAGING_S_IMPORT_INTERFACE_MSG
#include "FC_Messaging_if.h"

struct FolderNode
{
   QString m_sFolderName;
   tU32 m_u32FolderHandle;
   tU32 m_u32ParentNodeHandle;
   tU32 m_u32ListHandle;
   tU32 m_u32NumSubFolders;
   tU32 m_u32NumberOfUnreadMessage;
   tU32 m_u32TotalMessage;
   QVector<most_fi_tcl_MsgMessageListSliceResultItem> *m_pvMessageList;
   QVector<most_fi_tcl_MsgConversationListSliceResultItem> *m_pvConversationList;
   QMap< tU32, QVector<most_fi_tcl_MsgConversationDetailListItem> > m_pvConversationDetailList;

   FolderNode()
   {
      m_u32NumSubFolders = 0;
      m_u32NumberOfUnreadMessage = 0;
      m_u32TotalMessage = 0;
      m_pvMessageList = NULLPTR;
      m_pvConversationList = NULLPTR;
      m_pvConversationDetailList.clear();
      m_u32FolderHandle = 0; //Lint fix
      m_u32ListHandle = 0; //Lint fix
      m_u32ParentNodeHandle = 0; //Lint fix
   }
};

typedef QMultiMap<QString, FolderNode> DirectoryStructure;

class FileSystem
{
protected:
   static tU32 m_su32FolderHandle;

   DirectoryStructure m_oDirectoryStructure;

public:
   FileSystem();

   virtual ~FileSystem(); //Lint fix

   tU32 u32GenerateUniqueFolderHandle(tU32 deviceHandle);

   tVoid vAddFolderNode(QString f_sParentFolderName,
      QString f_sFolderName, tU8 deviceHandle);

   FolderNode* poSearchNodeByListHandle(tU32 f_u32ListHandle);

   FolderNode* poSearchNodeByFolderHandle(tU32 f_u32FolderHandle);

   FolderNode* poSearchNodeByFolderName(QString f_sFolderName);

   tVoid vAddMessageInList(QString f_sFolderName,
      most_fi_tcl_MsgMessageListSliceResultItem&);

   tVoid vAddMessageInConversationDetailList(tU32 u32ConversationID,
      most_fi_tcl_MsgMessageListSliceResultItem& oMessageListSliceResultItem,
      tU32 attachmentSize, most_fi_tcl_e8_MsgMessageStatus::tenType messageStatus,
      most_fi_tcl_e8_MsgAddressFieldType::tenType addressFieldType);
};
#endif /* FC_MESSAGING_FILESYSTEM_H_ */
