/*******************************************************************************
 *
 * FILE:          FC_Messaging_service_Messaging.h
 *
 * SW-COMPONENT:  FC_Messaging application
 *
 * PROJECT:       Bosch
 *
 * DESCRIPTION:   CCA service Messaging.
 *
 * AUTHOR:        Arun Choudhary
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

#ifndef _FC_MESSAGING_SERVICE_MESSAGING_H_
#define _FC_MESSAGING_SERVICE_MESSAGING_H_

#ifndef __PLACEMENT_NEW_INLINE
#define __PLACEMENT_NEW_INLINE 1
#endif

#include<QVector>

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
// Include Application Help Library.
#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION_DEMO
#include "ahl_if.h"

// Include message framework interface (AMT, msgfw).
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
//Include public FI interface of this service.
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MESSAGING_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MESSAGING_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MESSAGING_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MESSAGING_SERVICEINFO
#include "midw_fi_if.h"
#include "FC_Messaging_Debug.h"
#include "DbusClient/FC_Messaging_Datatype.h"
#include "FileSystemManager/FC_Messaging_FileSystemManager.h"
/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/

// Loop back message defines to be processed by vOnLoopbackService().

/* Definition of internal Function IDs (iFIDs) and message        */
/* content IDs (MSGID) which are not public and therefore are     */
/* not in the public FI of our service. Such internal function    */
/* and message content IDs are necessary for 'loopback' messages, */
/* i.e. messages the application sends itself. These internal     */
/* function IDs must be different to the ones from the public FI. */
/* The developer has to take care about that. To have a maximum   */
/* separation of the public and the internal FIDs we start the    */
/* definition for the internal ones nearly at the end of the      */
/* possible range and then count downwards.*/

// Internal function ID defines.
#define MESSAGING_C_U16_IFID 					0xFFF0
#define MESSAGING_C_U16_IFID_EXAMPLE_1 	0xFFF0
// Message content ID defines.
#define MESSAGING_C_U32_MSGID_EXAMPLE_1 0x00000001

/******************************************************************************/
/*                                                                            */
/* fc_messaging_IncomingMessage                                               */
/* Internal structure used to store incoming message details                  */
/*                                                                            */
/******************************************************************************/
typedef struct fc_messaging_IncomingMessage
{
    tU16 u16SourceAppID;
    tU16 u16RegisterID;
    tU16 u16CmdCounter;
    tU16 u16FunctionID;

    fc_messaging_IncomingMessage()
    {
       u16SourceAppID = 0;
       u16RegisterID = 0;
       u16CmdCounter = 0;
       u16FunctionID = 0;
    }
} IncomingMessage;

#define SOURCE_NUM_MAX 						5
#define MSG_CHANNEL_NOT_ALLOCATED		1
#define MSG_CHANNEL_ALLOCATING			2
#define MSG_CHANNEL_ALLOCATED				3
#define MSG_ERR_EN_PROCESSINGERR				0x42

typedef struct
{
    tU8 AllocateState;
    tU16 u16BlockWidth;
    tU16 u16ConnectionLabel;
} AudioRouteAllocateStatus_t;

class AllocateStatusState
{
private:
    static tU8 u8CurrentAllocateSourceNr;
    static AudioRouteAllocateStatus_t
    aoAudioRouteAllocateStatus_t[SOURCE_NUM_MAX];

public:
    AllocateStatusState()
    {
        memset(aoAudioRouteAllocateStatus_t, 0,
               sizeof(aoAudioRouteAllocateStatus_t));
    }

    static tU8 geCurrentAllocateSourceNr()
    {
        return u8CurrentAllocateSourceNr;
    }

    static void setCurrentAllocateSourceNr(tU8 u8SNr)
    {
        u8CurrentAllocateSourceNr = u8SNr;
    }

    static tU8 getCurrentAllocateState(tU8 u8SourecNr)
    {
        return aoAudioRouteAllocateStatus_t[u8SourecNr - 1].AllocateState;
    }

    static void setCurrentAllocateState(tU8 u8SourecNr, tU8 u8State)
    {
        aoAudioRouteAllocateStatus_t[u8SourecNr - 1].AllocateState = u8State;
    }

    static tU16 getBlockWidth(tU8 u8SourecNr)
    {
        return aoAudioRouteAllocateStatus_t[u8SourecNr - 1].u16BlockWidth;
    }

    static void setBlockWidth(tU8 u8SourecNr, tU16 u16BW)
    {
        aoAudioRouteAllocateStatus_t[u8SourecNr - 1].u16BlockWidth = u16BW;
    }

    static tU16 getConnectionLabel(tU8 u8SourecNr)
    {
        return aoAudioRouteAllocateStatus_t[u8SourecNr - 1].u16ConnectionLabel;
    }

    static void setConnectionLabel(tU8 u8SourecNr, tU16 u16CL)
    {
        aoAudioRouteAllocateStatus_t[u8SourecNr - 1].u16ConnectionLabel = u16CL;
    }
};

class ahl_tclBaseOneThreadService;
class fc_messaging_tclApp;
class fc_messaging_tclClientHandler_BluetoothSetings;
class MessagingSettings;

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

class fc_messaging_tclService_Messaging FINAL: public ahl_tclBaseOneThreadService
{
public:

   static fc_messaging_tclService_Messaging* poGetInstance();

    fc_messaging_tclService_Messaging();
    fc_messaging_tclService_Messaging(fc_messaging_tclApp* poMainAppl);
    virtual ~fc_messaging_tclService_Messaging();
    tVoid _MemoryStatusFromDbus();
    /***************************************************************************
     * Application specific methods.
     ***************************************************************************/
    tVoid vOff2Normal();
    tVoid vNormal2Off();
     
    tVoid vOnLoopbackService(amt_tclServiceData* poMessage);
    tVoid vPostLoopBackMessage(LoopBackMessageData);
    QVector<LoopBackMessageData>::Iterator findMessagePosition(tU32);
    QVector<LoopBackMessageData> vLoopBackDataItems;
    QMutex mLoopBackMessageDataVectorMutex;

    tVoid vProcessTimer(tU16 u16TimerId);
    ail_tenCommunicationError eUpdatePropertyToClients(tU16 u16FunctionId);

    //void vPropertyStatusFactoryValetMode(tU16 u16FunctionId);

    tBool bStartTimer(tU16 nTimerID, OSAL_tMSecond nTimeUntilFirstTimerTick,
                      OSAL_tMSecond nTimerTickInterval);
    tBool bStopTimer(tU16 nTimerID);

    tVoid vSetPrivateServiceAvailableAllowed(tBool on) OVERRIDE
    {
        ahl_tclBaseOneThreadService::vSetPrivateServiceAvailableAllowed(on);
		m_bServerAvailable = on;
    }

    /* Attributes */
    static tBool m_bServerAvailable;

    static fc_messaging_tclService_Messaging* m_poMessagingService;
    tVoid  vHandle_SendMessage_Return(
            most_msgfi_tclMsgSendMessageMethodResult &poSendMessageMethodResult_MR);
    tVoid vHandle_SourceInfo_Error(
            most_fi_tcl_e8_ErrorCode::tenType e8ErrorCode,
            amt_tclServiceData* poMessage);

    tVoid vResetMapDeviceCapabilities(); // Task CMG3G-7698
    tVoid vResetMapDeviceCapabilitiesExtended();
    tVoid vResetMessagingDeviceConnectionStatus();
    tVoid vResetMessageNotificationStatus();
    tVoid vResetMessageListChangeStatus();
    tVoid vResetSignatureTextStatus();
    tVoid vEraseDeviceSignatureText(tU8 deviceHandle); //CMG3G-13910 This function is meant for device specific signature setting.
    tString getSignatureText(); //CMG3G-13910 This function has to be invoked only for signature setting that is not device specific.
    tVoid vSwitchMapOnOff(tBool bMapInput);
    tVoid vUpdateDeviceSpecificSettingsProperties();

public:
    static bool SendMessagingDeviceConnectionDefaultUpdate();
    static bool IsMessagingServiceAvailable();
    bool s32ClearAllPrivateData();
    tVoid vHandle_ClearPrivateData();
    /***************************************************************************
     * Overriding ahl_tclBaseOneThreadService methods.
     ***************************************************************************/
    virtual tVoid vOnServiceAvailable() OVERRIDE;
    virtual tVoid vOnServiceUnavailable() OVERRIDE;
    //virtual tVoid vOnNewAppStateNotify(tU32 , tU32 );

    virtual tBool bStatusMessageFactory(tU16 u16FunctionId,
                                        amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg) OVERRIDE;

    virtual tBool bProcessSet(amt_tclServiceData* poMessage,
                              tBool& bPropertyChanged, tU16& u16Error) OVERRIDE;

    /***************************************************************************
     * Handler function declarations used by message map.
     ***************************************************************************/

    // Add your CCA message handler function prototypes here.
    tVoid vHandle_Allocate_MethodStart(amt_tclServiceData* poMessage);
    tVoid vHandle_DeAllocate_MethodStart(amt_tclServiceData* poMessage);
    tVoid vHandle_SourceActivity_MethodStart(amt_tclServiceData* poMessage);
    tVoid vHandle_SendMessage_MethodStart(amt_tclServiceData* poMessage,
                                          struct Job* poMethodStart = NULLPTR);
    tVoid vHandle_GenericMessaging_MethodAbort(amt_tclServiceData* poMessage);
    //tVoid vHandle_SaveMessage_MethodStart(amt_tclServiceData* poMessage);


    tVoid vHandle_CreateMessageList_MethodStart(amt_tclServiceData* poMessage,
                                                struct Job * poMethodStart = NULLPTR);
    tVoid vHandle_RequestSliceMessageList_MethodStart(amt_tclServiceData* poMessage);
    tVoid vHandle_RequestSliceConversationList_MethodStart(amt_tclServiceData* poMessage);
    tVoid vHandle_GetSliceConversationDetails_MethodStart(amt_tclServiceData* poMessage,
          struct Job* f_prJob = NULLPTR);

    tVoid vHandle_ReleaseMessageList_MethodStart(amt_tclServiceData* poMessage);
    tVoid vHandle_GetMessage_MethodStart(amt_tclServiceData* poMessage,
                                         struct Job *poMethodStart = NULLPTR);
    tVoid vHandle_GetAttachmentList_MethodStart(amt_tclServiceData* poMessage);
    tVoid vHandle_GetBodyPartList_MethodStart(amt_tclServiceData* poMessage);
    tVoid vHandle_UpdateInbox_MethodStart(amt_tclServiceData* poMessage);
    tVoid vHandle_ReadMessageAloud_MethodStart(amt_tclServiceData* poMessage,
                                               struct Job* poMethodStart = NULLPTR);
    tVoid vHandle_ReadMessageAloudExtended_MethodStart(amt_tclServiceData* poMessage,
                                               struct Job* poMethodStart = NULLPTR);
    tVoid vHandle_GetImageAttachment_MethodStart(amt_tclServiceData* poMessage);
    tVoid vHandle_GetImageAttachmentInfo_MethodStart(
            amt_tclServiceData* poMessage);
    //AUDIO Attachment Playback START
    tVoid vHandle_MessagingAudioAttachmentPlayback_MethodStart(
            amt_tclServiceData* poMessage);
    tVoid vHandle_GetConversationMessages_MethodStart(
            amt_tclServiceData* poMessage, struct Job* poMethodStart = NULLPTR);

    tVoid vHandle_ClearUserMessagingInfo_MethodStart(
            amt_tclServiceData* poMessage);

    tVoid vHandle_ClearUserMessagingInfo_Error();
    //CMG3G-8286, CMG3G-8160, CMG3G-8287- ConnectMapProfile and MapConnectionStatus
    tVoid vHandle_ConnectMapProfile_MethodStart(amt_tclServiceData* poMessage);

public:
    tVoid PredefinedListChangeStatus();
    tVoid vHandle_RequestAccountList_MethodStart(amt_tclServiceData* poMessage);
    tVoid vHandle_RequestAccountList_Return(tU8);

    tVoid vHandle_ChangeAccount_MethodStart(amt_tclServiceData* poMessage,
                                            struct Job* poMethodStart = NULLPTR);
    tVoid vHandle_ChangeAccount_Return(tBool bActiveAccountStatus);

    tVoid vHandle_Error(tU16, most_fi_tcl_e8_ErrorCode::tenType, tU8*);
    tVoid vHandle_AddPredefinedMessage_MethodStart(
            amt_tclServiceData* poMessage);
    // CMG3G-8730 PSA - Predefined Message Template handling Extension
    tVoid vHandle_AddPredefinedMessageExtended_MethodStart(
              amt_tclServiceData* poMessage);
    tVoid vHandle_DeletePredefinedMessage_MethodStart(
            amt_tclServiceData* poMessage);
    tVoid vHandle_EditPredefinedMessage_MethodStart(
    		amt_tclServiceData* poMessage);
    tVoid vHandle_AddCustomMessage_MethodStart(
                  amt_tclServiceData* poMessage);
    tVoid vHandle_SwitchMapOnOff_MethodStart(
                  amt_tclServiceData* poMessage);

    tVoid vSendDeAllocateMethodResult(tU16 u16UCID);
    tVoid vSendAllocateMethodResult(tU8 u8SourceNr, tU8 BlockWidth,
                                    tU16 ConnectionLabel);
    tVoid vSendDeAllocateMethodError(most_fi_tcl_e8_ErrorCode::tenType);
    tVoid vSendAllocateMethodError(
            most_fi_tcl_e8_ErrorCode::tenType eErrorCode, tU8 u8SourceNr = 0,
            amt_tclServiceData* poMessage = NULLPTR);
    tVoid vSendSrcActivityMethodResultOn(tU16 ucid, tU16 cmdCounter);
    tVoid vSendSrcActivityMethodResultOff(tU16 ucid, tU16 cmdCounter);
    tVoid vSendSrcActivityMethodError(most_fi_tcl_e8_ErrorCode::tenType);
    tVoid
    vHandle_RequestFolderList_MethodStart(amt_tclServiceData* poMessage,
                                          struct Job* poMethodStart = NULLPTR);
    tVoid vHandle_RequestFolderList_Return(
            most_msgfi_tclMsgRequestFolderListMethodResult&);

    tVoid vHandle_GetConversationMessages_MethodResult(QVector<
                                                       most_fi_tcl_ShortStream> oMessageHandleList, tU32 u32MatchFound);
    tVoid vHandle_RequestSliceMessageList_Return(QVector<
                                                 most_fi_tcl_MsgMessageListSliceResultItem>* pvector, tU32, tU32);
    tVoid vHandle_RequestSliceMessageList_Error();

    tVoid vHandle_RequestSliceConversationList_Return(QVector<most_fi_tcl_MsgConversationListSliceResultItem>* pConversationList,
          tU32 u32WindowStart, tU32 u32WindowSize);

    tVoid vHandle_RequestSliceConversationList_Error();

    tVoid vHandle_GetSliceConversationDetails_Return(FileSystemManager* fileSystemManager,
          QVector<most_fi_tcl_MsgConversationDetailListItem> pConversationDetailListItem,
          tU32 u32WindowStart, tU32 u32WindowSize);

    tVoid vHandle_GetSliceConversationDetails_Error();

    tVoid vHandle_CreateMessageList_Return(tU16 u16ListHandle,
                                           tU32 u32NumberMessage);
    tVoid vHandle_ReleaseMessageList_Return(tU16 ListHandle);
    tVoid vHandle_ReleaseMessageList_Error();

    tVoid vHandle_GetMessage_Return(most_fi_tcl_MsgMessageDetailsResult& );
    tVoid vHandle_GetAttachmentList_Return();
    tVoid vHandle_GetBodyPartList_Return(most_msgfi_tclMsgGetBodyPartListMethodResult&
                                         f_roGetBodyPartListMethodResult);
    tVoid vHandle_UpdateInbox_Return();
    tVoid vHandle_ReadMessageAloud_Return(most_fi_tcl_e8_MsgPlaybackAction::tenType);
    tVoid vHandle_ReadMessageAloudExtended_Return(most_fi_tcl_e8_MsgPlaybackAction::tenType);
    tVoid vHandle_GetImageAttachment_Return();
    tVoid vHandle_GetImageAttachmentInfo_Return();
    //AUDIO Attachment Playback RETURN
    tVoid vHandle_MessagingAudioAttachmentPlayback_Return(tU8 state);

    tVoid vHandleGetDataError(amt_tclServiceData* poMessage,
                              tCString poHandlerStr);
    tVoid vHandleInvalidDataError(amt_tclServiceData* poMessage);

    tVoid
    vHandle_MessagingDeviceConnection_UpReg(
            amt_tclServiceData* poMessage);
    tVoid vHandle_MessagingDeviceConnection_RelUpReg(
            amt_tclServiceData* poMessage);
    //#ifdef FCAT1_6_1

    tVoid vHandle_DeleteMessage_MethodStart(amt_tclServiceData* poMessage,
                                            struct Job* poMethodStart = NULLPTR);
    tVoid
    vHandle_DeleteMessage_Return(
            const most_msgfi_tclMsgDeleteMessageMethodResult& oDeleteMessageMethodResult_MR);

    tVoid vHandle_ProvideMessageHeader_Method(amt_tclServiceData* poMessage);

    tVoid vHandle_CreateMessage_MethodStart(amt_tclServiceData* poMessage);

    tVoid vHandle_ProvideMessageBody_Method(amt_tclServiceData* poMessage);

    tVoid vMessageListChange(most_msgfi_tclMsgMessageListChangeStatus objmessageListStatus);

    tVoid vHandle_AddPredefinedMessage_Return(tU16 u16Handle);
    tVoid vHandle_AddPredefinedMessage_Error();
    // CMG3G-8730 PSA - Predefined Message Template handling Extension
    tVoid vHandle_AddPredefinedMessageExtended_Return(tU16 u16Handle);
    tVoid vHandle_AddPredefinedMessageExtended_Error();
    tVoid vHandle_DeletePredefinedMessage_Return(tU16 u16Handle);
    tVoid vHandle_DeletePredefinedMessage_Error();

    tVoid vHandle_EditPredefinedMessage_Return(tU16 u16Handle);
    tVoid vHandle_EditPredefinedMessage_Error();
    tVoid messagingAudioPlaybackState(tU8 e8Playmode);
    tVoid vHandle_SwitchMapOnOff_Return(tU8 u8DeviceHandle, tBool bOnOffState);
    tVoid vHandle_SwitchMapOnOff_Error();
    tVoid vHandle_AddCustomMessage_Return(tU8 u8DeviceHandle, tU16 u16PredefMsgHandle);
    tVoid vHandle_AddCustomMessage_Error();

    tVoid updateAttachmentAudioStateProperty(tU8 e8Playmode);
    tVoid vHandle_MessagingRecordAudio_MethodStart(
            amt_tclServiceData* poMessage);
    tVoid
    vHandle_MessagingRecordAudio_MethodResult(tU16 u16AudioRecordHandle);

    tVoid vHandle_MessagingPlaybackRecordedAudio_MethodStart(
            amt_tclServiceData* poMessage);
    tVoid vHandle_MessagingPlaybackRecordAudio_MethodResult(
            most_fi_tcl_e8_MsgPlaybackState::tenType enRecordMessageState);

    tVoid
    vHandle_MessagingRecordedAudioMessageState_Status(
            most_fi_tcl_e8_MsgRecordMessageState::tenType enMsgRecordMessageState);

    tVoid
    vHandle_MessagingRecordedAudioMessageInfoProp_Status(tU16 newHandle);

    tVoid vHandle_NewMessageNotification(amt_tclServiceData*, struct Job*); //Bugfix for GMMY17-5280

    tVoid vHandle_GetMessageforSubject(amt_tclServiceData*, struct Job*);

    tVoid vHandle_ListFolders(amt_tclServiceData*, struct Job*);

    tBool isSourceNrValid(tU8 u8SourceNr);
	
    // CMG3G-7699 - IS2202_message send notification (network level)@FC_Messaging
    tVoid vMsgNotificationstatus(trFC_Msg_Notification *prFC_Msg_Notification);

    /***************************************************************************
     * Message map definition macro
     ***************************************************************************/
    DECLARE_MSG_MAP(fc_messaging_tclService_Messaging)
    public:
   /* Properties */

   most_msgfi_tclMsgMessageListChangeStatus m_oMessageListChange_Status;

    tVoid _MessagingDeviceConnection(
            DeviceConnection_t *objDeviceConnection_t);
    tVoid _MemoryStatusFromDbus(
            DeviceConnection_t *objDeviceConnection_t);
    tVoid _MapDeviceCapabilities(
          const trFC_Msg_MapDeviceCapabilities *prFC_Msg_MapDeviceCapabilities);

    static most_msgfi_tclMsgSendMessageMethodStart* m_l_poSendMessageMethodStart;

    most_msgfi_tclMsgGetMessageMethodResult m_oGetMessageMethodResult_MR;
    most_msgfi_tclMsgGetAttachmentListMethodResult
    m_oGetAttachmentListMethodResult_MR;
    most_msgfi_tclMsgGetBodyPartListMethodResult
    m_oGetBodyPartListMethodResult_MR;
    most_msgfi_tclMsgGetImageAttachmentInfoMethodResult
    m_oGetImageAttachmentInfoMethodResult_MR;
    most_msgfi_tclMsgGetImageAttachmentMethodResult
    m_oGetImageAttachmentMethodResult_MR;

    most_msgfi_tclMsgPredefinedMessageListStatus
    m_oPredefinedMessageList_Status;
	// CMG3G-8602 - IS2543_PredefinedMessageListExtended@FC_Messaging
    most_msgfi_tclMsgPredefinedMessageListExtendedStatus
    m_oPredefinedMessageListExtended_Status;
    most_msgfi_tclMsgAddPredefinedMessageMethodResult
    oMsgAddPredefinedMessageMethodResult_MR;
    most_msgfi_tclMsgDeletePredefinedMessageMethodResult
    oMsgDeletePredefinedMessageMethodResult_MR;
    most_msgfi_tclMsgMessagingAudioPlaybackStateStatus
    m_oMessagingAudioPlaybackState_Status;
    static most_msgfi_tclMsgMessagingDeviceConnectionStatus
    m_oMessagingDeviceConnection_Status;
    most_msgfi_tclMsgAudioAttachmentPlaybackStateStatus
    m_oAudioAttachmentPlaybackState_Status;
    most_msgfi_tclMsgAudioMessageRecordingStateStatus
    m_oAudioMessageRecordingState_Status;

    most_msgfi_tclMsgRecordedAudioMessageInfoStatus
    m_oRecordedAudioMessageInfo_Status;

    tVoid vHandle_RecoverMessage_MethodStart(amt_tclServiceData* poMessage);
    tVoid vHandle_RecoverMessage_Return(tBool,
                                        most_fi_tcl_MsgMessageHandle);
    tVoid vHandle_RecoverMessage_Error();

    tVoid vHandle_FolderListChange_RelUpReg(amt_tclServiceData* poMessage);
    tVoid vHandle_FolderListChange_Request(tU32);
    tVoid  vHandle_SendMessage_Error();
    tVoid vHandle_RequestFolderList_Error();

    tVoid vHandle_GetMessage_Error();
    tVoid  vHandle_ChangeAccount_Error();
    tVoid vHandle_CreateMessageList_Error();
    most_msgfi_tclMsgFolderListChangeStatus m_oFolderListChange_Status;
    tVoid vHandle_GetMsgBodyActionElement_MethodStart(
            amt_tclServiceData* poMessage);
    tVoid vHandle_GetMsgBodyActionElement_Return(tU8);
    tVoid vHandle_Delete_Error();
    tVoid vHandle_UpdateInbox_Error();
    tVoid vHandle_GetConversationMessage_Error();
    tVoid vHandle_ReadMessageAloud_Error();
    tVoid vHandle_ReadMessageAloudExtended_Error();
    tVoid vHandle_SendMessageValet_MethodStart();

private:
    tBool vHandle_MessageListChange_ValetMode();
    tBool vHandle_MessagingDeviceConnection_ValetMode();

    /* GMMY15-9119 FC_Messaging : logiscope code complexity value >= 20 */
    tVoid vOnLoopbackServiceHelper(tU32 f_U32MsgContent, LoopBackMessageData* f_poLoopBackMessageData,
    		FileSystemManager* f_poFileSystemManager);

    static struct Job* m_l_prJob;
    QMutex m_lockMapDeviceCapabilities;

    tU8 m_u8SourceActivityErrorParameterPosition;
    IncomingMessage m_oCreateMessageList;
    IncomingMessage m_oRequestSliceMessageList;
    IncomingMessage m_oRequestSliceConversationList;
    IncomingMessage m_oGetSliceConversationDetails;
    IncomingMessage m_oReleaseMessageList;
    IncomingMessage m_oGetMessage;
    IncomingMessage m_oGetAttachmentList;
    IncomingMessage m_oGetBodyPartList;
    IncomingMessage m_oUpdateInbox;
    IncomingMessage m_oDeleteMessage;
    IncomingMessage m_MSGAllocateMessage;
    IncomingMessage m_MSGSourceActivityMessage;
    IncomingMessage m_MSGDeAllocateMessage;
    IncomingMessage m_oMSGRecordAudioMessage;
    IncomingMessage m_oMSGPlaybackRecordAudioMessage;
    IncomingMessage m_oMSGPlayAttachment;
    IncomingMessage m_oSendMessage;
    IncomingMessage m_oRequestFolderList;
    IncomingMessage m_oAddpredefinedMessage;
    IncomingMessage m_oDeletepredefinedMessage;
    IncomingMessage m_oEditPredefinedMessage;
    IncomingMessage m_oAddPredefinedMessageExtended;
    IncomingMessage m_oReadMessageAloud;
    IncomingMessage m_oReadMessageAloudExtended;
    IncomingMessage m_oGetImageAttachment;
    IncomingMessage m_oGetImageAttachmentInfo;
    IncomingMessage m_oGetConversationMessages;
    IncomingMessage m_oRequestAccountLlist;
    IncomingMessage m_oChangeAccount;
    IncomingMessage m_oRecoverMessage;
    IncomingMessage m_oClearUserMessagingInfo;
    IncomingMessage m_oGetMsgBodyActionElement;
    IncomingMessage m_oSwitchMapOnOff;
    IncomingMessage m_oAddCustomMessage;

    most_msgfi_tclMsgSourceAvailableStatus m_oSourceAvailableStatus;
    most_msgfi_tclMsgMapDeviceCapabilitiesStatus m_oMapDeviceCapabilitiesStatus; // Task CMG3G-7698
    most_msgfi_tclMsgMessageNotificationStatus m_oMsgNotificationStatus; // Task CMG3G-7699
    most_msgfi_tclMsgSignatureSettingStatus m_oSignatureSettingStatus; //Task CMG3G-12946
    most_msgfi_tclMsgSignatureSettingExtendedStatus m_oSignatureSettingExtendedStatus; //Task CMG3G-13910
    most_msgfi_tclMsgMapDeviceCapabilitiesExtendedStatus m_oMapDeviceCapabilitiesExtendedStatus;

    MessagingSettings* m_oMsgSettings;
};

#endif // _FC_MESSAGING_SERVICE_MESSAGING_H_
