/************************************************************************
* FILE:         FC_Bluetooth_clienthandler_Diaglib.cpp
* PROJECT:      
* SW-COMPONENT: 
*----------------------------------------------------------------------
*
* DESCRIPTION: Implementation of a RoutineControl listener.
* This handler sets the Nav Route Calculation value for a Routecalculation 
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
* HISTORY:      
* Date      | Author                 | Modification
* 12.11.10  | TMS Plischke           | Inital version
*
*************************************************************************/
// +++ Remove feature switch when not needed. Used to turn diaglib support on/off +++

#include "FC_Messaging_main.h"

// +++ Specify what part of diaglib you need in this file +++
#define DIAGLIB_INCLUDE_ROUTINE_CONTROL
#define DIAGLIB_INCLUDE_DIAGNOSIS_DATA
#include "diaglib_if.h"

#include "FC_Messaging_clienthandler_Diaglib.h"
#include "DbusClient/FC_Messaging_Macro.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_MESSAGING_APPLICATION
#include "trcGenProj/Header/FC_Messaging_clienthandler_Diaglib.cpp.trc.h"
#endif

fc_messaging_tclClientHandler_Diaglib* fc_messaging_tclClientHandler_Diaglib::m_poBtDiaglib = NULLPTR;

/******************************************************************
Function Name:	fc_messaging_tclClientHandler_Diaglib

Description: 	...
******************************************************************/
fc_messaging_tclClientHandler_Diaglib::fc_messaging_tclClientHandler_Diaglib(diaglib::tclServiceDiaglib* pDiaglibService): mpDiaglibService(pDiaglibService)
{
}

/******************************************************************
Function Name:	~fc_bluetooth_tclClientHandler_Diaglib

Description: 	...
******************************************************************/
fc_messaging_tclClientHandler_Diaglib::~fc_messaging_tclClientHandler_Diaglib()
{
	mpDiaglibService = NULLPTR;
}

/***********************************************************************
* \brief CCA Service vOnIoControl
*
* Command from Diagnois for IOControl request
*
************************************************************************/
tU32 fc_messaging_tclClientHandler_Diaglib::vOnRoutineControlStart (
	tU32 u32RoutineId, 
	tU32 u32Bitmask, 
	const diaglib::tclParameterVector& oParamVector,
	diaglib::tContext MsgContext
	)
{
	ETG_TRACE_USR4(("vOnRoutineControlStart : Called"));
        (void)u32RoutineId;
        (void)u32Bitmask;
        (void)oParamVector;
        (void)MsgContext;

	tU32 u32Return = diaglib::U32_DIAGLIB_RETURN_OK;  // Return result for Diaglib, only for send routine

	return u32Return;
}

tU32 fc_messaging_tclClientHandler_Diaglib::vOnRoutineControlAbort (
	tU32 u32RoutineId, 
	diaglib::tContext MsgContext
	)
{
	ETG_TRACE_USR4(("vOnRoutineControlAbort : Called"));
	tU32 u32Return = diaglib::U32_DIAGLIB_RETURN_OK;
        (void)u32RoutineId;
        (void)MsgContext;

	return u32Return;
}

tU32 fc_messaging_tclClientHandler_Diaglib::vOnGetRoutineResult (
	tU32 u32RoutineId,
	diaglib::tContext MsgContext
	)
{
	ETG_TRACE_USR4(("vOnGetRoutineResult : Called"));
	tU32 u32Return = diaglib::U32_DIAGLIB_RETURN_OK;
        (void)u32RoutineId;
        (void)MsgContext;
	return u32Return;
}

/***********************************************************************
* \brief CCA Service vOnDiagnosisData
*
* Command from Diagnois for simple Data by Id request
*
************************************************************************/
tU32 fc_messaging_tclClientHandler_Diaglib::vOnDiagnosisDataRead (
	tU32 u32DiagDataId, 
	diaglib::tContext MsgContext
	)
{
	ETG_TRACE_USR4(("vOnDiagnosisDataRead  : Called"));
	tU32 u32Return = diaglib::U32_DIAGLIB_RETURN_OK;
        (void)u32DiagDataId;
        (void)MsgContext;
	return u32Return;
}

/***********************************************************************
* \brief CCA Service vOnDiagDataWrite
*
* Command from Diagnois for simple Write request
*
************************************************************************/
tU32 fc_messaging_tclClientHandler_Diaglib::vOnDiagnosisDataWrite (
	tU32 u32DiagDataId, 
	const diaglib::tclParameterVector& oParamVector,
	diaglib::tContext MsgContext
	)
{
	ETG_TRACE_USR4(("vOnDiagnosisDataWrite : Called"));
        (void)oParamVector;
        (void)u32DiagDataId;
        (void)MsgContext;
	return diaglib::U32_DIAGLIB_RETURN_OK;
}

/*******************************************************************************
* FUNCTION:   pGetInstance(..)
*
* DESCRIPTION:
*   Get the instance of BT Diag service
*  PARAMETERS:
*     IN:   None
*    
*  RETURNVALUE: fc_bluetooth_tclClientHandler_Diaglib* : Pointer to BT Diag service
********************************************************************************/
fc_messaging_tclClientHandler_Diaglib* fc_messaging_tclClientHandler_Diaglib:: pGetInstance(tVoid)
{
	return(m_poBtDiaglib);
}
/*******************************************************************************/


