/*******************************************************************************
*                                                                               
* FILE:          FC_Messaging_clienthandler_BluetoothSetings.h             
*                                                                               
* SW-COMPONENT:  FC_Messaging application                                  
*                                                                               
* PROJECT:                                                                      
*                                                                               
* DESCRIPTION:   CCA client-handler for the service BluetoothSetings.              
*                                                                               
* AUTHOR:        Arun Choudhary                                                             
*                                                                               
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim                          
*                                                                               
*******************************************************************************/

#ifndef _FC_MESSAGING_CLIENTHANDLER_BLUETOOTHSETTINGS_H_
#define _FC_MESSAGING_CLIENTHANDLER_BLUETOOTHSETTINGS_H_

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
// Include message framework interface (AMT, msgfw)
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE

// Include FI interface of used service
#define MOST_FI_S_IMPORT_INTERFACE_MOST_BTSETFI_TYPES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_BTSETFI_FUNCTIONIDS
#define MOST_FI_S_IMPORT_INTERFACE_MOST_BTSETFI_ERRORCODES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_BTSETFI_SERVICEINFO
#include "conn_most_fi_if.h"

#include "FC_Messaging_main.h"

class ahl_tclBaseOneThreadClientHandler;

class fc_messaging_tclClientHandler_BluetoothSetings : public ahl_tclBaseOneThreadClientHandler
{
public:
   fc_messaging_tclClientHandler_BluetoothSetings(tVoid); 
   fc_messaging_tclClientHandler_BluetoothSetings(fc_messaging_tclApp* poMainAppl);
   virtual ~fc_messaging_tclClientHandler_BluetoothSetings() FINAL;

   /**************************************************************************
    * Assingment Operater, will not be implemented.
    * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class
    * 'fc_messaging_tclClientHandler_BluetoothSetings' which has no
    *  assignment operator.
    * NOTE: This is a technique to disable the assignment operator for this
    * class. So if an attempt for the assignment is made compiler complains.
    **************************************************************************/
   fc_messaging_tclClientHandler_BluetoothSetings& operator=(const fc_messaging_tclClientHandler_BluetoothSetings &oClientHandler);

   /***************************************************************************
    * Overriding ahl_tclBaseOneThreadClientHandler methods.
    ***************************************************************************/
   virtual tVoid vOnServiceAvailable() OVERRIDE;
   virtual tVoid vOnServiceUnavailable() OVERRIDE;

   /***************************************************************************
    * Handler function declarations used by message map.
    ***************************************************************************/
   // Add your CCA message handler function prototypes here.
   tVoid vHandle_DeviceListExtended_Status    (amt_tclServiceData* poMessage);
   tVoid vHandle_VehicleBTFriendlyName_Status (amt_tclServiceData* poMessage);
   tVoid vHandle_VehicleBTAddress_Status      (amt_tclServiceData* poMessage);
   tVoid vHandle_ConnectBluetoothProfile_MethodResult    (amt_tclServiceData* poMessage);
   tVoid vHandle_ConnectBluetoothProfile_MethodError     (amt_tclServiceData* poMessage);
   tVoid vHandle_DisconnectBluetoothProfile_MethodResult (amt_tclServiceData* poMessage);
   tVoid vHandle_DisconnectBluetoothProfile_MethodError  (amt_tclServiceData* poMessage);

   bool bConnectMAPProfile(tU8 deviceHandle);
   tVoid vDisconnectMAPProfile(tU8 deviceHandle);
   tVoid vReconnectMAPProfile(tU8 deviceHandle);
   tString getVehicleBTAddress();
   static tVoid addDeviceToRetryList(tU8 deviceHandle);
   static tVoid removeDeviceFromRetryList(tU8 deviceHandle);
   static tVoid clearDevicesFromRetryList();
   static tVoid addDeviceToMAPConnRetryForMNSList(tU8 deviceHandle);
   static tVoid removeDeviceFromMAPConnRetryForMNSList(tU8 deviceHandle);

   static most_fi_tcl_String m_VehicleBTFriendlyName;
   static QMutex m_DeviceListmutex;
   static std::map< tU8, std::string > m_oConnectedDeviceList;
   static std::vector< tU8 > m_u8ConnectedDevicesOrder;
   static std::vector< tU8 > m_u8RetryDeviceList;
   static std::vector< tU8 > m_u8MAPConnRetryReqForMNSList;
   // GMMY15-255 Bugfix - messaging inbox is not available when phone reconnects after disconnection.
   // Introduce a list for handling the Disconnected BT devices, when DeviceList is updated.
   static QList<tU8> m_u8DiscDeviceHandleList;

   tVoid vCheckAndUpdatePairedDeviceListinDB(tBool, tU8, std::string = "");
   tVoid vPrintPairedDeviceList();

   /***************************************************************************
   * Message map definition macro
   ***************************************************************************/
   DECLARE_MSG_MAP(fc_messaging_tclClientHandler_BluetoothSetings) 

private :
   tVoid vDeviceStatus(const most_fi_tcl_BTSetDeviceListExtendedResultItem& deviceListExtendedItem);
   tVoid vDeviceConnected(tU8 deviceHandle, tString deviceAddress);
   tVoid vDeviceDisconnected(tU8 deviceHandle);
   tVoid vResetMessagingQueuesAndValues(tBool disconnect = FALSE);

   most_fi_tcl_String m_VehicleBTAddress;

   tMap_DevHandle_DevAddress m_mapPairedDeviceList;
};

#endif // _FC_MESSAGING_CLIENTHANDLER_BLUETOOTHSETTINGS_H_

