/*******************************************************************************
 *
 * FILE:          FC_Messaging_Macro.h
 *
 * SW-COMPONENT:  FC_Messaging application
 *
 * PROJECT:
 *
 * DESCRIPTION:  Macro used for Messaging Dbus Clinet
 *
 * AUTHOR:     Rakesh Kumar
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/
#ifndef  _MESSAGING_MACRO_H_
#define  _MESSAGING_MACRO_H_

#if __cplusplus < 201103L
#define NULLPTR NULL //C++03 or below
#define OVERRIDE  //C++03 or below
#define FINAL
#else
#define NULLPTR nullptr //C++11 or above
#define OVERRIDE override //C++11 or above
#define FINAL final
#endif

#define BASE_EVO_OBJECT_PATH                 "/org/bluez/obex"
#define BASE_EVO_SERVICE_NAME                "org.bluez.obex"

#define BASE_EVO_TRANSFER_INTERFACE_NAME     "org.bluez.obex.Transfer"

#define BASE_EVO_MESSAGEACCESS_INTERFACE_NAME      "org.bluez.obex.MessageAccess"

#define BASE_EVO_SESSION_INTERFACE_NAME     "org.bluez.obex.Session"

#define BASE_EVO_MESSAGE_NOTIFICATION_ON      0x01

#define MESSAGE_HANDLE_LENGTH      16

#define BMESSAGE_MSG_BODY_LENGTH   22       //22 = BEGIN:MSG (9) + END:MSG (7) + 3*CRLF (6)
#define BMESSAGE_NEWLINE           "\r\n"
#define BMESSAGE_VCARD_VERSION     "VERSION:2.1"

#define STRING_CR               "\r"
#define CONTENT_TYPE            "Content-Type"
#define CONTENT_TYPE_TEXT_PLAIN "text/plain"
#define CONTENT_TYPE_MULTIPART  "multipart"
#define CONTENT_NAME_BOUNDARY   "boundary"
#define BOUNDARY_TEXT_LENGTH    9

#define DEFAULT_DATE_TIME "00000000T999999"
#define DEFAULT_DEVICE_HANDLE 0

#define EVO_TRANSFER_TYPE_LIST_MESSAGES "x-bt/MAP-msg-listing"
#define EVO_TRANSFER_TYPE_LIST_FOLDER "x-obex/folder-listing"
#define EVO_TRANSFER_TYPE_SET_MSG_STATUS "x-bt/messageStatus"

#define MESSAGE_STRING "/message"

#define EVO_MAP_SESSION_RETRY_TIMER 3000 //TODO try increasing time, Samsung Note 5 devices are not connecting some times due to less time
#define EVO_MAP_NOTIFICATION_WAIT_TIMER 8000 // Bug 731027
#define MAP_CONNECTION_RETRY_FOR_MNS 0

#define MAX_ATTACHMENT_NUM       0x06
#define MAX_INSTANCE_NUM         0x05

// Message type
#define DBUS_MSG_TYPE_EMAIL            0x01
#define DBUS_MSG_TYPE_SMS_GSM          0x02
#define DBUS_MSG_TYPE_SMS_CDMA         0x04
#define DBUS_MSG_TYPE_MMS              0x08

#define LIST_START_OFFSET              0x00
#define MAXIMUM_SUBJECT_LENGTH         0xFF

#define RETRIEVE_ATTACHMENTS           0x01
#define DONOT_RETRIEVE_ATTACHMENTS     0x00

#define SUCCESS                     0
#define FAILURE                     1

#define YES                         0
#define NO                          1

#define FOLDER_LIST_OFFSET                0x00
#define MAXIMUM_LIST_COUNT                100   //GACE-310  Text message download is restricted to 100 messages
#define MAX_RECORD_PER_SIGNAL             50


#define MSG_STATUS_READ             0
#define MSG_STATUS_UNREAD           1
#define MSG_STATUS_DELETED          2

#define DATA_FOR_TEXT                     0x00

#define TYPE_NEW_MESSAGE                  0x00
#define TYPE_DELIVERY_SUCCESS             0x01
#define TYPE_SENDING_SUCCESS              0x02
#define TYPE_DELIVERY_FAILURE             0x03
#define TYPE_SENDING_FAILURE              0x04
#define TYPE_MEMORY_FULL                  0x05
#define TYPE_MEMORY_AVAILABLE             0x06
#define TYPE_MESSAGE_DELETED              0x07
#define TYPE_MESSAGE_SHIFT                0x08
#define TYPE_READ_STATUS_CHANGED          0x09

#define NOTIFY_MSG_EMAIL                  0x00
#define NOTIFY_MSG_SMS_GSM                0x01
#define NOTIFY_MSG_SMS_CDMA               0x02
#define NOTIFY_MSG_MMS                    0x03
#define NOTIFY_MSG_IGNORE                 0xFF

#define MSG_STATUS_DELIVERY_SUCCESS       0x00
#define MSG_STATUS_DELIVERY_FAILURE       0x01
#define MSG_STATUS_SENDING_SUCCESS        0x02
#define MSG_STATUS_SENDING_FAILURE        0x03
#define MSG_STATUS_RECEIVED_COMPLETE      0x04
#define MSG_STATUS_RECEIVED_FRACTIONED    0x05
#define MSG_STATUS_RECEIVED_NOTIFICATION  0x06

#define MSG_DBUS_FOLDER_TYPE_INBOX              "inbox"
#define MSG_DBUS_FOLDER_TYPE_DELETED            "deleted"
#define MSG_DBUS_FOLDER_TYPE_DRAFT              "draft"
#define MSG_DBUS_FOLDER_TYPE_SENT               "sent"
#define MSG_DBUS_FOLDER_TYPE_OUTBOX             "outbox"
#define MSG_DBUS_FOLDER_TYPE_CONVERSATION       "conversation"

#define MSG_DBUS_FOLDER_TYPE_OUTBOX_UC          "OUTBOX"

#define MSG_DBUS_EVO_FOLDER_TYPE_INBOX              "/telecom/msg/inbox"
#define MSG_DBUS_EVO_FOLDER_TYPE_DELETED            "/telecom/msg/deleted"
#define MSG_DBUS_EVO_FOLDER_TYPE_DRAFT              "/telecom/msg/draft"
#define MSG_DBUS_EVO_FOLDER_TYPE_SENT               "/telecom/msg/sent"
#define MSG_DBUS_EVO_FOLDER_TYPE_USERDEFINED        "/telecom/msg/Userdefined" //TODO confirm this type
#define MSG_DBUS_EVO_FOLDER_TYPE_OUTBOX             "/telecom/msg/outbox"

#define MSG_DBUS_EVO_GETMESSAGE_PATH  "/tmp/messaging/getmessage.txt"
#define MSG_DBUS_EVO_PUSHMESSAGE_PATH "/tmp/messaging/pushmessage.txt"

#define MSG_DBUS_MESSAGE_TYPE_EMAIL                            0x00
#define MSG_DBUS_MESSAGE_TYPE_SMS_GSM                          0x01
#define MSG_DBUS_MESSAGE_TYPE_SMS_CDMA                         0x02
#define MSG_DBUS_MESSAGE_TYPE_MMS                              0x03

//Database related
#define FC_MSG_SYSTEMWIDESETTINGS_TABLE_NAME   "SystemWideSettings"
#define FC_MSG_COL_EMAIL_ALERT                 "EmailAlert"
#define FC_MSG_COL_TEXT_ALERT                  "TextAlert"
#define FC_MSG_COL_SAVE_SENT_EMAIL             "SaveSentEmail"
#define FC_MSG_COL_SAVE_SENT_TEXT              "SaveSentText"
#define FC_MSG_COL_AUTO_UPDATE_INBOX           "AutoUpdateInbox"
#define FC_MSG_COL_UPDATE_INBOX_PERIOD         "UpdateInboxPeriod"
#define FC_MSG_COL_MSG_LANG                    "MsgLang"

#define FC_MSG_DEVICESETTINGS_TABLE_NAME       "DeviceSettings"
#define FC_MSG_COL_DEVICE_HANDLE               "DeviceHandle"
#define FC_MSG_COL_DEVICE_ADDRESS              "DeviceAddress"
#define FC_MSG_COL_MAP_ON_OFF                  "MapOnOff"
#define FC_MSG_COL_TEXT_RINGTONE               "TextRingtone"
#define FC_MSG_COL_SIGN_ON_OFF                 "SignOnOff"
#define FC_MSG_COL_AUTOREPLY_ON_OFF            "AutoReplyOnOff"
#define FC_MSG_COL_AUTOREPLY_TEXT              "AutoReplyText"

#define FC_MSG_PREDEFMSG_TABLE_NAME            "PredefMsgTable"
#define FC_MSG_COL_PID                         "PID"
#define FC_MSG_COL_PRE_MSG                     "PredefMsg"
#define FC_MSG_COL_PRE_MSG_TYPE                "PredefMsgType"
#define FC_MSG_COL_PRE_MSG_CREATE_TYPE         "PredefMsgCreateType"
#define FC_MSG_COL_PRE_MSG_LAN_TYPE            "PredefMsgLanType"
#define FC_MSG_COL_PRE_MSG_MOD_TIME            "PredefMsgModTime"
#define FC_MSG_COL_PRE_MSG_SUB_CAT             "PredefMsgSubCat"

#define FC_MSG_DEFAULT_MSG_LANG                0
#define FC_MSG_DEFAULT_AUTO_REPLY_TEXT         0
#define FC_MSG_AUTO_UPDATE_INBOX_PERIOD        300
#define FC_MSG_MAX_PREDEF_MSG_COUNT            50

#endif
