/*******************************************************************************
 *
 * FILE:          FC_Messaging_DbusClient_MsgRead.h
 *
 * SW-COMPONENT:  FC_Messaging application
 *
 * PROJECT:
 *
 * DESCRIPTION:  Interfacing API's
 *
 * AUTHOR:		Rakesh Kumar
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/
#ifndef _MSG_READ_DATA_H
#define _MSG_READ_DATA_H

#include "FC_Messaging_Datatype.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

class MsgRead_t
{
private:
   tU8 m_u8ReadStatus;
   tU8 m_u8Type;
   tU8 m_u8ReceiverNum;
   tU8 m_u8AttachNum;
   tU32 m_u32DataFlag;
   QByteArray m_baDataPayLoad;
   QString m_sFolderName;

   QString m_sSenderN;
   QString m_sSenderFN;
   QString m_sSenderTEL;
   QString m_sSenderEMAIL;

   tVoid vSetReadStatus(tU8);
   tVoid vClear();
   tVoid vSetType(tU8);
   tVoid vSetReceiverNum(tU8);
   tVoid vSetAttachNum(tU8);
   tVoid vSetFolderName(tString);
   tVoid vSetSenderInfo(SenderPtr_t);
   tVoid vSetReceiverInfo(ReceiverPtr_t, tU8);
   tVoid vSetAttachmentList(AttachmentListPtr_t, tU8);
   tVoid vSetDataFlag(tU32);
   tVoid vSetDataPayLoad(tString, tU32);
   tVoid vSetAttachmentDataPayLoad(tString, tU32, tU8);

public:
   tU8 u8GetReadStatus();
   tU8 u8GetType();
   tU8 u8GetReceiverNum();
   tU8 u8GetAttachNum();
   tU32 u32GetDataLength();
   tU32 u32GetDataFlag();
   QByteArray sGetDataPayLoad();

   MsgRead_t();
   ~MsgRead_t();

   friend class EvolutionDbusClient;
};

#endif
