/*******************************************************************************
 *
 * FILE:        	FC_Messaging_DbusClient_MsgRead.cpp
 *
 * SW-COMPONENT: FC_Messaging application
 *
 * PROJECT:
 *
 * DESCRIPTION:  Message Read API's
 *
 * AUTHOR:		Rakesh Kumar
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/
#include "FC_Messaging_DbusClient_MsgRead.h"
#include <string.h>
#include "stdio.h"
#include "../FC_Messaging_Debug.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_MESSAGING_APPLICATION
#include "trcGenProj/Header/FC_Messaging_DbusClient_MsgRead.cpp.trc.h"
#endif


/*******************************************************************************
 * FUNCTION:		MsgRead_t
 * DESCRIPTION:	Constructor of MsgRead_t

 * PARAMETER:
 *
 * RETURNVALUE:
 ********************************************************************************/
MsgRead_t::MsgRead_t()
{
   m_u8ReadStatus = 0;
   m_u8ReadStatus = 0;
   m_u8Type = 0;
   m_u8ReceiverNum = 0;
   m_u8AttachNum = 0;
   m_u32DataFlag = 0;
}

/*******************************************************************************
 * FUNCTION:		~MsgRead_t
 * DESCRIPTION:	Destructor of MsgRead_t.

 * PARAMETER:
 *
 * RETURNVALUE:
 ********************************************************************************/
MsgRead_t::~MsgRead_t()
{

}

tVoid MsgRead_t::vClear()
{
   m_baDataPayLoad.clear();
}

/*******************************************************************************
 * FUNCTION:		setReadStatus
 * DESCRIPTION:	Function to set the read status.

 * PARAMETER:
 *
 * RETURNVALUE:	none.
 ********************************************************************************/
tVoid MsgRead_t::vSetReadStatus(tU8 f_u8ReadStatus)
{
   m_u8ReadStatus = f_u8ReadStatus;
}

/*******************************************************************************
 * FUNCTION:		setType
 * DESCRIPTION:	Function to set the message type.

 * PARAMETER:
 *
 * RETURNVALUE:	none.
 ********************************************************************************/
tVoid MsgRead_t::vSetType(tU8 f_u8Type)
{
   m_u8Type = f_u8Type;
}

/*******************************************************************************
 * FUNCTION:		setReceiverNum
 * DESCRIPTION:	Function to set the number of message receiver.

 * PARAMETER:
 *
 * RETURNVALUE:	none.
 ********************************************************************************/
tVoid MsgRead_t::vSetReceiverNum(tU8 f_u8ReceiverNum)
{
   m_u8ReceiverNum = f_u8ReceiverNum;
}

/*******************************************************************************
 * FUNCTION:		setAttachNum
 * DESCRIPTION:	Function to set the Attachment number.

 * PARAMETER:
 *
 * RETURNVALUE:	none.
 ********************************************************************************/
tVoid MsgRead_t::vSetAttachNum(tU8 f_u8AttachNum)
{
   m_u8AttachNum = f_u8AttachNum;
}

/*******************************************************************************
 *
 * FUNCTION:		setAttachmentList
 * DESCRIPTION:	Function to set the attachment list.

 * PARAMETER:
 *
 * RETURNVALUE:	none.
 ********************************************************************************/
tVoid MsgRead_t::vSetAttachmentList(AttachmentListPtr_t f_pstAttachmentList,
		tU8 f_u8Index)
{
   (tVoid) f_pstAttachmentList; //lint fix
   (tVoid) f_u8Index; //lint fix
}

/*******************************************************************************
 * FUNCTION:		setFolderInfo
 * DESCRIPTION:	Function to set the folder info.

 * PARAMETER:
 *
 * RETURNVALUE:	none.
 ********************************************************************************/
tVoid MsgRead_t::vSetFolderName(tString f_sFolderName)
{
   m_sFolderName = f_sFolderName;
}

/*******************************************************************************
 * FUNCTION:		setFolderInfo
 * DESCRIPTION:	Function to set the message Sender Info.

 * PARAMETER:
 *
 * RETURNVALUE:	none.
 ********************************************************************************/
tVoid MsgRead_t::vSetSenderInfo(SenderPtr_t p_pstSender)
{
   if(p_pstSender->pucN)
   {
      m_sSenderN = p_pstSender->pucN;
   }
   if(p_pstSender->pucFN)
   {
      m_sSenderFN = p_pstSender->pucFN;
   }
   if(p_pstSender->pucTEL)
   {
      m_sSenderTEL = p_pstSender->pucTEL;
   }
   if(p_pstSender->pucEMAIL)
   {
      m_sSenderEMAIL = p_pstSender->pucEMAIL;
   }
}

/*******************************************************************************
 * FUNCTION:		setReceiverInfo
 * DESCRIPTION:	Function to set message receiver info.

 * PARAMETER:
 *
 * RETURNVALUE:	none.
 ********************************************************************************/
tVoid MsgRead_t::vSetReceiverInfo(ReceiverPtr_t p_pstReceiver, tU8 ucIndex)
{
   (void) p_pstReceiver;
   (void) ucIndex;
}

/*******************************************************************************
 * FUNCTION:		setDataFlag
 * DESCRIPTION:	Function to set the message Data Flag.

 * PARAMETER:
 *
 * RETURNVALUE:	none.
 ********************************************************************************/
tVoid MsgRead_t::vSetDataFlag(tU32 f_u32DataFlag)
{
   m_u32DataFlag = f_u32DataFlag;
}

/*******************************************************************************
 * FUNCTION:		setDataPayLoad
 * DESCRIPTION:	Function to set the message Data payload.

 * PARAMETER:
 *
 * RETURNVALUE:	none.
 ********************************************************************************/
tVoid MsgRead_t::vSetDataPayLoad(tString p_pcDataPayLoad, tU32 f_u32Len)
{
   QByteArray ba(p_pcDataPayLoad,(tInt)f_u32Len);

   m_baDataPayLoad.append(ba);
}

/*******************************************************************************
 * FUNCTION:		getReadStatus
 * DESCRIPTION:	Function to get the message read status.

 * PARAMETER:
 *
 * RETURNVALUE:	message read status.
 ********************************************************************************/
tU8 MsgRead_t::u8GetReadStatus()
{
   return m_u8ReadStatus;
}

/*******************************************************************************
 * FUNCTION:		getType
 * DESCRIPTION:	Function to get the message type.

 * PARAMETER:
 *
 * RETURNVALUE:	message type.
 ********************************************************************************/
tU8 MsgRead_t::u8GetType()
{
   return m_u8Type;
}

/*******************************************************************************
 * FUNCTION:		getReceiverNum
 * DESCRIPTION:	Function to get the message Receiver Number.

 * PARAMETER:
 *
 * RETURNVALUE:	NUmber of Receiver.
 ********************************************************************************/
tU8 MsgRead_t::u8GetReceiverNum()
{
   return m_u8ReceiverNum;
}

tU8 MsgRead_t::u8GetAttachNum()
{
   return m_u8AttachNum;
}

/*******************************************************************************
 * FUNCTION:		getDataFlag
 * DESCRIPTION:	Function to get the message Data Flag.

 * PARAMETER:
 *
 * RETURNVALUE:	Data Flag.
 ********************************************************************************/
tU32 MsgRead_t::u32GetDataFlag()
{
   return m_u32DataFlag;
}

/*******************************************************************************
 * FUNCTION:		getDataPayLoad
 * DESCRIPTION:	Function to get the message Data payload.

 * PARAMETER:
 *
 * RETURNVALUE:	Data payload.
 ********************************************************************************/
QByteArray MsgRead_t::sGetDataPayLoad()
{
   return m_baDataPayLoad;
}

tU32 MsgRead_t::u32GetDataLength()
{
   return static_cast<unsigned int>(m_baDataPayLoad.size());
}
