/*******************************************************************************
 *
 * FILE:          FC_Messaging_DbusClient_MsgListData.h
 *
 * SW-COMPONENT:  FC_Messaging application
 *
 * PROJECT:
 *
 * DESCRIPTION:  Interfacing API's
 *
 * AUTHOR:		Rakesh Kumar
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/
#ifndef _MSG_LIST_DATA_H
#define _MSG_LIST_DATA_H

#include "FC_Messaging_Datatype.h"

// Message Listing
class MsgListing_t
{
private:
   QByteArray m_sMessageHandle;    // The handle of message
   QByteArray m_sSubject;          // The summary of message(subject)
   QByteArray m_sDatetime;
   QByteArray m_sSenderName;
   QByteArray m_sSenderAddress;
   QByteArray m_sReplytoAddress;
   QByteArray m_sRecipientName;
   QByteArray m_sRecipientAddress;
   tU8 m_u8Type;            // The type of message
   tU32 m_u32Size;          // The size of message as received from network
   tU8 m_u8Text;
   tU8 m_u8ReceptionStatus; // Status of reception of the message
   tU32 m_u32AttachSize;    // The size of the attachment
   tU8 m_u8Priority;
   tU8 m_u8Read;
   tU8 m_u8Sent;
   tU8 m_u8Protected;
   tU8 m_u8NotifyType;      // Type of Notification

public:
   //Setter Functions
   tVoid vSetHandle(tU8*, tU8);
   tVoid vSetSubject(tString);
   tVoid vSetDateTime(tString);
   tVoid vSetSenderName(tString);
   tVoid vSetSenderAddress(tString);
   tVoid vSetReplytoAddress(tString);
   tVoid vSetRecipientName(tString);
   tVoid vSetRecipientAddress(tString);
   tVoid vSetMsgListDataFlags(tU8, tU32, tU8, tU8, tU32,
         tU8, tU8, tU8, tU8, tU8);

   //Getter Functions
   QByteArray sGetMessageHandle();
   QByteArray sGetSubject();
   QByteArray sGetDateTime();
   QByteArray sGetSenderName();
   QByteArray sGetSenderAddress();
   QByteArray sGetReplytoAddress();
   QByteArray sGetRecipientName();
   QByteArray sGetRecipientAddress();
   tU8 u8GetMessageType();
   tU32 u32GetMessageSize();
   tU8 u8GetReceptionStatus();
   tU32 u32GetAttachSize();
   tU8 u8GetReadStatus();
   tU8 u8GetSentStatus();
   tU8 u8GetNotifyType(); // CMG3G-7699 - IS2202_message send notification (network level)@FC_Messaging

   //Clear all member variables
   tVoid vClear(); // Bug fix for GMMY15-73 - MMS message not displayed

   MsgListing_t();
   ~MsgListing_t();
};

#endif
