/********************************************************FileHeaderBegin** *//**
*
* FILE:          FC_Messaging_SQLite.h
*
* SW-COMPONENT:  FC_Messaging application
*
* PROJECT:       BOSCH-GM-NEXTGEN
*
* DESCRIPTION:   Handles the sqlite database using QtSql module. This is the
*                real class where all the Qt/QSql work is done.
* 
* AUTHOR:        Nishant Parashar
*
* COPYRIGHT:    (c) 2011 Robert Bosch GmbH, Hildesheim
*
**********************************************************FileHeaderEnd******* */
#if !defined(FC_Messaging_SQLite_H__INCLUDED)
#define FC_Messaging_SQLite_H__INCLUDED

#include "../FC_Messaging_main.h"

#include <QtSql/QtSql>

#define FC_MESSAGING_S_IMPORT_INTERFACE_MSG
#include "FC_Messaging_if.h"

class FC_Messaging_PredefinedMsgList;

enum SystemWideSettings
{
   EMAIL_ALERT_SETTING = 0,
   TEXT_ALERT_SETTING = 1,
   SAVE_SENT_EMAIL_SETTING = 2,
   SAVE_SENT_TEXT_SETTING = 3,
   AUTO_UPDATE_INBOX_SETTING = 4,
   AUTO_UPDATE_INBOX_PERIOD_SETTING = 5,
   MSG_LANGUAGE_SETTING = 6
};

enum DeviceSettings
{
   MAP_ON_OFF_SETTING = 0,
   TEXT_RINGTONE_ON_OFF_SETTING = 1,
   SIGNATURE_ON_OFF_SETTING = 2,
   AUTO_REPLY_ON_OFF_SETTING = 3,
   AUTO_REPLY_TEXT_SETTING = 4
};

enum LanguageType
{
   FI_EN_E8LANGUAGE_SELECTION_NA_ENGLISH = 0UL,
   FI_EN_E8LANGUAGE_SELECTION_GERMAN = 1UL,
   FI_EN_E8LANGUAGE_SELECTION_ITALIAN = 2UL,
   FI_EN_E8LANGUAGE_SELECTION_SWEDISH = 3UL,
   FI_EN_E8LANGUAGE_SELECTION_FRENCH = 4UL,
   FI_EN_E8LANGUAGE_SELECTION_SPANISH = 5UL,
   FI_EN_E8LANGUAGE_SELECTION_DUTCH = 6UL,
   FI_EN_E8LANGUAGE_SELECTION_PORTUGUESE = 7UL,
   FI_EN_E8LANGUAGE_SELECTION_NORWEGIAN = 8UL,
   FI_EN_E8LANGUAGE_SELECTION_FINNISH = 9UL,
   FI_EN_E8LANGUAGE_SELECTION_DANISH = 10UL,
   FI_EN_E8LANGUAGE_SELECTION_GREEK = 11UL,
   FI_EN_E8LANGUAGE_SELECTION_JAPANESE = 12UL,
   FI_EN_E8LANGUAGE_SELECTION_ARABIC = 13UL,
   FI_EN_E8LANGUAGE_SELECTION_STANDARD_CHINESE = 14UL,
   FI_EN_E8LANGUAGE_SELECTION_POLISH = 15UL,
   FI_EN_E8LANGUAGE_SELECTION_TURKISH = 16UL,
   FI_EN_E8LANGUAGE_SELECTION_KOREAN = 17UL,
   FI_EN_E8LANGUAGE_SELECTION_TRADITIONAL_CHINESE = 18UL,
   FI_EN_E8LANGUAGE_SELECTION_UK_ENGLISH = 19UL,
   FI_EN_E8LANGUAGE_SELECTION_HUNGARIAN = 20UL,
   FI_EN_E8LANGUAGE_SELECTION_CZECH = 21UL,
   FI_EN_E8LANGUAGE_SELECTION_SLOVAK = 22UL,
   FI_EN_E8LANGUAGE_SELECTION_RUSSIAN = 23UL,
   FI_EN_E8LANGUAGE_SELECTION_BRAZILIAN_PORTUGUESE = 24UL,
   FI_EN_E8LANGUAGE_SELECTION_THAI = 25UL,
   FI_EN_E8LANGUAGE_SELECTION_BULGARIAN = 26UL,
   FI_EN_E8LANGUAGE_SELECTION_ROMANIAN = 27UL,
   FI_EN_E8LANGUAGE_SELECTION_SLOVENIAN = 28UL,
   FI_EN_E8LANGUAGE_SELECTION_CROATIAN = 29UL,
   FI_EN_E8LANGUAGE_SELECTION_UKRAINIAN = 30UL,
   FI_EN_E8LANGUAGE_SELECTION_NA_FRENCH = 31UL,
   FI_EN_E8LANGUAGE_SELECTION_NA_SPANISH = 32UL,
   FI_EN_E8LANGUAGE_SELECTION_CANTONESE = 33UL
};

//==================================================================
//!\brief
//! This Class is used for accessing the SQL database related
//! to Messaging module.
//!
//! It Handles the sql lite database using QtSql module.
//! All the Qt-Sql query is performed in this class
//!
//==================================================================
class FC_Messaging_SQLite
{
protected:
   most_fi_tcl_MsgPredefinedMessageListResult m_oPredefinedMessageListResult;

public:
   FC_Messaging_SQLite();
   virtual ~FC_Messaging_SQLite();

   static FC_Messaging_SQLite* poGetFC_Messaging_SQLite();
   static void vDeleteInstance();
   void setDataBaseState(bool state);

   //Initialise Sql database
   bool bInitSQLDatabase();

   //Modified for CMG3G-8730 PSA - Predefined Message Template handling Extension
   bool bQueryInsertIntoPredefinedMessage
   (
      tU8 u8DeviceHandle,
      const QString& strPreMessage,
      quint16  u16PredefMsgType,
      quint16  u16PredefMsgCreatType,
      quint16& u16Handle,
      quint16 u16LanguageType,
      quint16 u16SubCategory
   );

   //Delete an existing Predefined Messages
   bool bQueryDeleteFromPredefinedMessage( quint16 u16PredefMsgHandle );

   bool bIsValidPredefMsgHandle( quint16 u16PredefMsgHandle );

   bool bQueryUpdatePredefinedMessage
   (
      quint16 u16PredefMsgHandle ,
      const QString& strPreMessage ,
      quint8 u8SubCategory
   );

   bool IsPredefinedListResultUpdateToDate();

   //Populate PredefinedMesssagelist object
   void vQuerySelectPredefinedMessageList();

   //Add system predefined messages
   bool bAddSystemPredefinedMessage();

   tVoid vDeleteAllPredefinedMessageBasedOnLanguage();

   //Bugfix for GMMY15-7204 Changing Language does not change predefined
   //messages in the Reply Text Message screen available to the user
   void newUserPredefinedMessageAdded();

   //Update SystemWideSettings
   bool bQueryUpdateSystemWideSettings(SystemWideSettings enSystemWideSetting, bool bSettingOn);

   //Get SystemWideSettings
   bool szQueryGetSystemWideSettings(SystemWideSettings enSystemWideSetting);

   //Update Inbox Setting
   bool bQueryUpdateInboxSetting(unsigned int uiUpdateInboxPeriod, bool bSettingOn = TRUE);

   //Get Update Inbox Setting
   unsigned int szQueryGetUpdateInboxPeriod();

   //Update Messaging Language
   bool bQueryUpdateMessagingLanguage(unsigned int uiMsgLang);

   //Get Messaging Language
   unsigned int szQueryGetMessagingLanguage();

   //Update AutoReplyText setting
   bool bQueryUpdateAutoReplyText(tU8 u8DeviceHandle, tU16 u8AutoReplyText);

   //Get AutoReplyText for a given DeviceHandle
   unsigned int szQueryGetAutoReplyText(tU8 u8DeviceHandle);

   //Update DeviceSettings
   bool bQueryUpdateDeviceSettings(tU8 u8DeviceHandle, DeviceSettings enDeviceSettings, tBool bOnOffState);

   //Get DeviceSettings
   bool szQueryGetDeviceSettings(tU8 u8DeviceHandle, DeviceSettings enDeviceSetting);

   //CMG3G-8753 : Severe DB error("malformed database schema ") during runtime should be used to decide
   //if the database is damaged in a critical way to be in FC_Messaging.
   #define MSG_CHECK_QUERY_TIMESTAMP_BYTE_LEN 50  // Max string length in byte for string of the following type:
   void vCheckQueryError(QSqlQuery &query, quint32 u32LineNr = 0, QString qsFileName = "file_name", QString qsFunctionName = "function_name");
   void vSetDbRecreationTrigger();
   #define MSG_CHECK_QUERY_ERROR(query) vCheckQueryError(query, __LINE__, __FILE__, __FUNCTION__);

   tVoid szQueryGetDeviceSpecificSettingList(DeviceSettings enDeviceSettings, tMap_DevHandle_SettingState &mapPairedDevicesSettingList);
   tVoid szQueryGetDeviceSpecificAutoReplyMsgHandleList(tMap_DevHandle_MsgHandle &mapPairedDevicesMsgHandleList);

   tVoid szQueryGetDevicesList(tMap_DevHandle_DevAddress &mapDevicesList);
   tBool bIsDeviceAvailableInDB(tU8 u8DeviceHandle, QString strTableName);

   //Add device into DeviceSettings table and Set Default Values in DeviceSettings Table
   tBool bQueryAddDevicetoDeviceSettingsTable(tU8 u8DeviceHandle, std::string sDeviceAddress);
   //Reset device settings
   tBool bQueryResetDeviceSettingsInDeviceSettingsTable(tU8 u8DeviceHandle, std::string sDeviceAddress);
   //remove device from the DeviceSettings table
   tBool bQueryRemoveDeviceFromDeviceSettingsTable(tU8 u8DeviceHandle);
   tBool bQueryRemoveCustomMessagesFromPreDefMsgTable(tU8 u8DeviceHandle);

private:    
   //!\brief
   //! Return the name of this class
   const char* pszGetClassName() const {return "FC_Messaging_SQLite";}

   //TODO: Additional Optimisation can be implemented in future
   //bool bIsResultUpdateDate();

   //Sql database
   inline QSqlDatabase GetSQLDatabase();

   //Create SystemWide Settings Table
   bool bCreateSystemWideSettingsDatabase();

   //Check SystemWideSettings Table Schema
   bool bCheckSystemWideSettingsTableSchema();

   //Create SystemWideSettings Table
   bool bCreateSystemWideSettingsTable();

   //Set Default Values in SystemWideSettings Table
   bool bQuerySetDefaultSystemWideSettings();

   //Create Device Setting Table
   bool bCreateDeviceSettingsDatabase();

   //Check DeviceSettings Table Schema
   bool bCheckDeviceSettingsTableSchema();

   //Create DeviceSettings Table
   bool bCreateDeviceSettingsTable();

   //Create PredefinedMessage Table
   bool bCreatePredefinedMessageDatabase();

   //Check the Predefined table schema
   bool bCheckPredefinedMessageTableSchema();

   //Create Predefined Message Table
   bool bCreateTablePreDefinedTable();

   //Get Total Number of Predefined Messages in the table
   bool u16GetTotalPredefMsgCount (quint16& u16PredefMsgCount,quint16);

   //Get generated Unique predefines message Handle
   quint16 u16GetNewUniquePredefMsgHandle();

   qint32 s32GetLatestMessageTime(quint16 u16LanguageType);

   //Instance of this class
   static FC_Messaging_SQLite* m_poInstance;

   //Semaphore to protect access the sql database
   QMutex m_mutex;
};


#endif // !defined(FC_Messaging_SQLite_H__INCLUDED)


