/*******************************************************************************
 *
 * FILE:          FC_Messaging_AudioRouteHandler.h
 *
 * SW-COMPONENT:  FC_Messaging application
 *
 * PROJECT:
 *
 * DESCRIPTION:   Header file for audio routing interface
 *
 * AUTHOR:
 *
 * COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

#ifndef _FC_MESSAGING_AUDIOROUTEHANDLER_H_
#define _FC_MESSAGING_AUDIOROUTEHANDLER_H_

/*******************************************************************************
 | includes of component-internal interfaces, if necessary
 | (scope: component-local)
 |-----------------------------------------------------------------------------*/

// include for audio routing lib
#ifndef ARL_S_IMPORT_INTERFACE_GENERIC
#define ARL_S_IMPORT_INTERFACE_GENERIC
#endif

#include "audio_routing_lib.h"
#include "../DbusClient/FC_Messaging_Macro.h"

class fc_messaging_tclApp;
class fc_messaging_tclService_Messaging;

class fc_messaging_tclAudioRouteHandler FINAL: public arl_tclISource
{

private:

   fc_messaging_tclApp* m_poMainApp;

protected:

   fc_messaging_tclAudioRouteHandler();

public:

   fc_messaging_tclAudioRouteHandler(fc_messaging_tclApp* poMainApp);
   tVoid vSetSourceAvailable(tBool bSourceAvailable);
   tVoid vSetSourceAvailability(arl_tenSrcAvailability enSrcAvailability,
         arl_tenAvailabilityReason enAvailabilityReason, arl_tenSource enSource,
         tU16 u16SubSource = 0);

   tBool bAudioRouteRequest(arl_tenSource enSrcNum);
   tBool bAudioReleaseRequest(arl_tenSource enSrcNum);
   tVoid vSetMessagingService(fc_messaging_tclService_Messaging*& rfpMessagingService);

   virtual ~fc_messaging_tclAudioRouteHandler();

   virtual tBool bOnAllocate(arl_tenSource enSrcNum, const arl_tAllocRouteResult& rfcoAllocRoute) OVERRIDE;

   virtual tBool bOnDeAllocate(arl_tenSource enSrcNum) OVERRIDE;

   virtual tBool bOnSrcActivity(arl_tenSource enSrcNum, const arl_tSrcActivity& rfcoSrcActivity) OVERRIDE;

   virtual tBool bOnMuteState(arl_tenSource enSrcNum, arl_tenMuteState enMuteState) OVERRIDE;

};

#endif /* _FC_MESSAGING_AUDIOROUTEHANDLER_H_ */
