/******************************************************************************
*
* FILE:   Pbk_FeatureConfig.h
*
* SW-COMPONENT:  Configuration
*
* PROJECT:   G3G
*
* DESCRIPTION:   Configuration file for FC_PhoneBook component
*
* AUTHOR   :   usman sheik
*
* COPYRIGHT:   (c) 2013 Robert Bosch GmbH, Hildesheim
*
*******************************************************************************/

#ifndef PBK_FEATURECONFIG_H
#define PBK_FEATURECONFIG_H

#include "../ConnectivityConfig.h"

//DEFAULT project features are defined here - Project independent features

#define FC_PB_DB_FILE_PATH "/var/opt/bosch/dynamic/connectivity/connectivity_mw"
#define FC_PB_DB_FILE_NAME "phonebook.db"
#define FC_PB_G_KEY_FILE_NAME "MaxContactCount.txt"

// -PHBK-QUERY-ERR- Instrumentation: BGN - for GMMY17-13044 "database disk image is malformed"
#define FC_PB_DB_RECREATE_TRIGGER_FILE_NAME  "pb.db.recreate.trigger"
// -PHBK-QUERY-ERR- Instrumentation: END - for GMMY17-13044 "database disk image is malformed"


#define PHONEBOOK_CONTACT_MEMORY_LIMIT (10485760U) // CMG3G-7702
#define APL2_PHOTO_MEMORY_LIMIT (20971520U) // CMG3G-7702

#define MAX_ENTRIES_VEHICLE_PHONEBOOK 1000
#define FC_PHONEBOOK_LIST_SEARCH_NUM_LEN 10

#define RETRY_TIMER_IN_LOCKED_SCENARIO 5000

#define LIMIT_ATTRIBUTE_LENGTH //FIX NCG3D-11656 Limiting of characters not required for AIVI

//Project specific features

#ifdef VARIANT_S_FTR_ENABLE_PSA_FEATURES

   #define MAX_NO_OF_CCH_ENTRIES (120)
   #define FC_PB_MAX_CALL_HISTORY_ENTRIES_PER_TYPE (10)

   #define VALID_VCARD_FORMAT_PHONENUMBER

   #define CONNECTIVITY_PHOTODOWNLOAD_ENABLE // Photo download is enabled

   #define CONNECTIVITY_AUTOCOMPLETE_PB_SEARCH

   #define REQUESTSLICE_EXTENDED_CH

   #define LIMIT_CCH_ENTRIES   // CMG3G-6311 IS1929_PB entry concatenation@FC_Phonebook

   #define TWO_PASS_DOWNLOAD //Download will be in two passes on fresh pairing
   
   #define PBDL_MAX_CONTACTS_PER_PHONE_TO_DOWNLOAD (4294967295U) // CMG3G-7702 decimal equivalent of 0xFFFFFFFF
   #define PBDL_MAX_CONTACTS_PER_PHONE_TO_STORE (4294967295U) // CMG3G-7702
   
   #define PBDL_VCARD_PARSE_NUMBERS_STYLE_FIRST_N_WITH_INDIVIDUAL_TYPE
   #define PBDL_MAX_PHONE_NUMBERS_PER_CONTACT_COUNT 4

   #undef FC_PHONEBOOK_LIST_SEARCH_NUM_LEN   
   #define FC_PHONEBOOK_LIST_SEARCH_NUM_LEN 7

#elif defined(VARIANT_S_FTR_ENABLE_JAC_FEATURES) 

   #define MAX_NO_OF_CCH_ENTRIES (60)
   #define FC_PB_MAX_CALL_HISTORY_ENTRIES_PER_TYPE (20)

   #define CONNECTIVITY_AUTOCOMPLETE_PB_SEARCH //Retrive the PhoneNumber from Contacts

   #define VALID_VCARD_FORMAT_PHONENUMBER //CMG3G-2971-Enhanced vcard handling-Check the Vcard PhoneNumber
   
   #define PBDL_MAX_CONTACTS_PER_PHONE_TO_DOWNLOAD (4294967295U) // CMG3G-7702 decimal equivalent of 0xFFFFFFFF
   #define PBDL_MAX_CONTACTS_PER_PHONE_TO_STORE (4294967295U) // CMG3G-7702
   #define PBDL_MAX_PHONE_NUMBERS_PER_CONTACT_COUNT 8  //CMG3G-8365 CONFIGURABLE PHONENUMBER
   
#elif defined(VARIANT_S_FTR_ENABLE_G3G_FEATURES)|| defined(VARIANT_S_FTR_ENABLE_CAF_FEATURES)

   #define MAX_NO_OF_CCH_ENTRIES (60)
   #define FC_PB_MAX_CALL_HISTORY_ENTRIES_PER_TYPE (20)

   #define CONNECTIVITY_AUTOCOMPLETE_PB_SEARCH //Retrive the PhoneNumber from Contacts

   #define VALID_VCARD_FORMAT_PHONENUMBER //CMG3G-2971-Enhanced vcard handling-Check the Vcard PhoneNumber

   //FIX SUZUKI-1113 API for numeric value to indicate number of calls against a CallHistory item in Phonebook SUZUKI-1114 API for numeric value to indicate number of dial-able phone numbers available to a contact item in Phonebook
   #define REQUESTSLICE_EXTENDED_CH

   #define UPDATE_BOTH_PBCHSUPPORT_ON_PREPARE_RESPONSEASZERO//When call history is updating and when user ignores/rejects the pop-up, PhoneBookSupport is not updated as ZERO.
   
   #define PBDL_MAX_CONTACTS_PER_PHONE_TO_DOWNLOAD (4294967295U) // CMG3G-7702 decimal equivalent of 0xFFFFFFFF
   #define PBDL_MAX_CONTACTS_PER_PHONE_TO_STORE (4294967295U) // CMG3G-7702
   #define PBDL_MAX_PHONE_NUMBERS_PER_CONTACT_COUNT 8  //CMG3G-8365 CONFIGURABLE PHONENUMBER

#elif defined(VARIANT_S_FTR_ENABLE_AIVI_FEATURES)

   #define MAX_NO_OF_CCH_ENTRIES (90)
   #define FC_PB_MAX_CALL_HISTORY_ENTRIES_PER_TYPE (30)

   #define CONNECTIVITY_AUTOCOMPLETE_PB_SEARCH //Retrive the PhoneNumber from Contacts

   #define VALID_VCARD_FORMAT_ADDRESS_PHONENUMBER //CMG3G-2971-Enhanced vcard handling-Check the Vcard Address and PhoneNumber

   #define UPDATE_BOTH_PBCHSUPPORT_ON_PREPARE_RESPONSEASZERO//When call history is updating and when user ignores/rejects the pop-up, PhoneBookSupport is not updated as ZERO.

   #define PB_PHONENUMBERS_IN_PRETTY_PRINT  //    CMG3G-8219 IS2342_phone number format in 2 different ways@FC_Phonebook
   
   #define PBDL_MAX_CONTACTS_PER_PHONE_TO_DOWNLOAD (4200) // CMG3G-7702
   #define PBDL_MAX_CONTACTS_PER_PHONE_TO_STORE (4000) // CMG3G-7702

   #define PBDL_SKIP_SIM_LIST //CMG3G-8364
   #undef MAX_ENTRIES_VEHICLE_PHONEBOOK
   #define MAX_ENTRIES_VEHICLE_PHONEBOOK 20
   #define CONNECTIVITY_PHOTODOWNLOAD_ENABLE // Photo download is enabled
   
   #define PBDL_VCARD_PARSE_NUMBERS_STYLE_FIRST_N_WITH_INDIVIDUAL_TYPE //CMG3G-8365 CONFIGURABLE PHONENUMBER
   #define PBDL_MAX_PHONE_NUMBERS_PER_CONTACT_COUNT 5 //CMG3G-8365 CONFIGURABLE PHONENUMBER

   #define TWO_PASS_DOWNLOAD
   #define SUPERVISION_IN_FIRST_PASS //Only insert non-duplicate entries in DB

   #undef LIMIT_ATTRIBUTE_LENGTH //FIX NCG3D-11656 Limiting of characters not required for AIVI
   
   #define ENABLE_SQLITE_ICU_EXTENSION

   #define HANDLE_PROBABLY_LOCKED_SCENARIO //CMG3G-12880 Phonebook download failure pop-up

   #undef PHONEBOOK_CONTACT_MEMORY_LIMIT // Task 241068
   #undef APL2_PHOTO_MEMORY_LIMIT // Task 241068
   #define PHONEBOOK_CONTACT_MEMORY_LIMIT (20971520U) // Task 241068
   #define APL2_PHOTO_MEMORY_LIMIT (31457280U) // Task 241068

   #undef FC_PHONEBOOK_LIST_SEARCH_NUM_LEN   //NCG3D-34087- 7digit rule enabled
   #define FC_PHONEBOOK_LIST_SEARCH_NUM_LEN 7   //NCG3D-34087- 7digit rule enabled
      
#elif defined(VARIANT_S_FTR_ENABLE_INF4CV_FEATURES) || defined(VARIANT_S_FTR_ENABLE_SMART_FEATURES)

   #define MAX_NO_OF_CCH_ENTRIES (90)
   #define FC_PB_MAX_CALL_HISTORY_ENTRIES_PER_TYPE (30)

   #define CONNECTIVITY_AUTOCOMPLETE_PB_SEARCH //Retrive the PhoneNumber from Contacts

   #define VALID_VCARD_FORMAT_ADDRESS_PHONENUMBER //CMG3G-2971-Enhanced vcard handling-Check the Vcard Address and PhoneNumber

   #define UPDATE_BOTH_PBCHSUPPORT_ON_PREPARE_RESPONSEASZERO//When call history is updating and when user ignores/rejects the pop-up, PhoneBookSupport is not updated as ZERO.

   #define PB_PHONENUMBERS_IN_PRETTY_PRINT  //    CMG3G-8219 IS2342_phone number format in 2 different ways@FC_Phonebook
   
   #define PBDL_MAX_CONTACTS_PER_PHONE_TO_DOWNLOAD (4200) // CMG3G-7702
   #define PBDL_MAX_CONTACTS_PER_PHONE_TO_STORE (4000) // CMG3G-7702

   //#define PBDL_SKIP_SIM_LIST //RTC 680068
   #undef MAX_ENTRIES_VEHICLE_PHONEBOOK
   #define MAX_ENTRIES_VEHICLE_PHONEBOOK 20
   #define CONNECTIVITY_PHOTODOWNLOAD_ENABLE // Photo download is enabled
   
   #define PBDL_VCARD_PARSE_NUMBERS_STYLE_FIRST_N_WITH_INDIVIDUAL_TYPE //CMG3G-8365 CONFIGURABLE PHONENUMBER
   #define PBDL_MAX_PHONE_NUMBERS_PER_CONTACT_COUNT 5 //CMG3G-8365 CONFIGURABLE PHONENUMBER

   #define TWO_PASS_DOWNLOAD
   #define SUPERVISION_IN_FIRST_PASS //Only insert non-duplicate entries in DB

   #undef LIMIT_ATTRIBUTE_LENGTH //FIX NCG3D-11656 Limiting of characters not required for AIVI
   
   #define ENABLE_SQLITE_ICU_EXTENSION

   #define HANDLE_PROBABLY_LOCKED_SCENARIO //CMG3G-12880 Phonebook download failure pop-up

   #undef PHONEBOOK_CONTACT_MEMORY_LIMIT // Task 241068
   #undef APL2_PHOTO_MEMORY_LIMIT // Task 241068
   #define PHONEBOOK_CONTACT_MEMORY_LIMIT (20971520U) // Task 241068
   #define APL2_PHOTO_MEMORY_LIMIT (31457280U) // Task 241068

   #undef FC_PHONEBOOK_LIST_SEARCH_NUM_LEN   //NCG3D-34087- 7digit rule enabled
   #define FC_PHONEBOOK_LIST_SEARCH_NUM_LEN 7   //NCG3D-34087- 7digit rule enabled
   #define REQUESTSLICE_EXTENDED_CH //Bug 556890
      
#endif

#if defined(VARIANT_S_FTR_ENABLE_AIVI_FEATURES) || defined(VARIANT_S_FTR_ENABLE_PSA_FEATURES) || defined(VARIANT_S_FTR_ENABLE_INF4CV_FEATURES) || defined(VARIANT_S_FTR_ENABLE_SMART_FEATURES)
   #define DATABASE_ENCRYPTION_VIA_SEE_AND_SDC  // Phonebook database encryption via SEE (SQLite Encryption Extension) and SDC (Secure Data Container)
   #define DATABASE_WAL_JOURNALING  // WAL journaling (Write Ahead Logging) is used instead of the (old) rollback journaling
   #define DATABASE_WAL_SHORT_NAMES
#endif


// Section for defines with depend on other defines
#ifdef DATABASE_WAL_SHORT_NAMES
   #define FC_PB_DB_WAL_FILE_NAME               "phonebook.wal"
   #define FC_PB_DB_SHM_FILE_NAME               "phonebook.shm"
   #define FC_PB_DB_JOURNAL_FILE_NAME           "phonebook.nal"
#else
   #define FC_PB_DB_WAL_FILE_NAME               "phonebook.db-wal"
   #define FC_PB_DB_SHM_FILE_NAME               "phonebook.db-shm"
   #define FC_PB_DB_JOURNAL_FILE_NAME           "phonebook.db-journal"
#endif

#endif // PBK_FEATURECONFIG_H
