/******************************************************************************
 *
 * FILE:          Phone_FeatureConfig.h
 *
 * SW-COMPONENT:  Configuration
 *
 * PROJECT:        G3G
 *
 * DESCRIPTION:   Configuration file for FC_Phone component
 *
 * AUTHOR   :     usman sheik
 *
 * COPYRIGHT:    (c) 2013 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

#ifndef PHONE_FEATURECONFIG_H
#define PHONE_FEATURECONFIG_H

#include "../ConnectivityConfig.h"

#define MINIMUM_DEVICE_HANDLE          2
#define MAXIMUM_DEVICE_HANDLE          11

//define default features - project independent

#define PHONE_USE_AVM
#define BYPASS_RINGTONE //Remove when Ringtone channel is handled

//NCG3D-3221- Hold the HfReleaseAudio signal for 500ms.
#define FC_PHONE_SCOCHANNEL_RELEASE_TIMEOUT_DURATION     500 //500 millisec
#define FC_PHONE_SCOCHANNEL_RELEASE_TIMEOUT_DURATION_WAITINGMODE_FIRSTCALL     5000 //5000 millisec

#ifdef CONNECTIVITY_SIRI
#define PHONE_SIRI
#endif

//Diagnosis is available for GM
#define  CONNECTIVITY_DIAGNOSIS_GM

#ifdef VARIANT_S_FTR_ENABLE_GM_FEATURES //GM specific configurations

#define PHONE_HFENHANCED
#define PHONE_USE_AVM
#undef BYPASS_RINGTONE

#elif defined(VARIANT_S_FTR_ENABLE_PSA_FEATURES) //PSA specific configurations

#define PHONE_WAITINGMODE
#define EXTEND_VR_SESSION
#define FC_PHONE_EXTEND_VR_SESSION_TIMEOUT_DURATION     2000 //2 secs

#elif defined(VARIANT_S_FTR_ENABLE_AIVI_FEATURES)  //AIVI

#define PHONE_WAITINGMODE
#define REJECT_THIRD_INCOMING_CALL
#define EXTEND_VR_SESSION
#define FC_PHONE_EXTEND_VR_SESSION_TIMEOUT_DURATION     1000 //1 sec
#define PHONE_SEPARATE_ECNR_SET_SIRI
#undef MAXIMUM_DEVICE_HANDLE
#define MAXIMUM_DEVICE_HANDLE          7

#elif defined(VARIANT_S_FTR_ENABLE_INF4CV_FEATURES) || defined(VARIANT_S_FTR_ENABLE_SMART_FEATURES) //INF4CV & SMART specific configurations

#define PHONE_WAITINGMODE
#define REJECT_THIRD_INCOMING_CALL
#define EXTEND_VR_SESSION
#define FC_PHONE_EXTEND_VR_SESSION_TIMEOUT_DURATION     1000 //1 sec
#define PHONE_SEPARATE_ECNR_SET_SIRI

#endif

#define ALERTTONE_FILE_PATH "/var/opt/bosch/static/connectivity/tones/AlertToneSecondCall.mp3"
#endif // PHONE_FEATURECONFIG_H
